/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.data.IMdmLinkDao;
import ca.uhn.fhir.jpa.dao.index.IJpaIdHelperService;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkFactory;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.rest.api.Constants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections4.CollectionUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MdmLinkDaoSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private IMdmLinkDao myMdmLinkDao;
    @Autowired
    private MdmLinkFactory myMdmLinkFactory;
    @Autowired
    private IJpaIdHelperService myJpaIdHelperService;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    protected EntityManager myEntityManager;

    @Transactional
    public MdmLink createOrUpdateLinkEntity(IBaseResource theGoldenResource, IBaseResource theSourceResource, MdmMatchOutcome theMatchOutcome, MdmLinkSourceEnum theLinkSource, @Nullable MdmTransactionContext theMdmTransactionContext) {
        Long goldenResourcePid = this.myJpaIdHelperService.getPidOrNull(theGoldenResource);
        Long sourceResourcePid = this.myJpaIdHelperService.getPidOrNull(theSourceResource);
        MdmLink mdmLink = this.getOrCreateMdmLinkByGoldenResourcePidAndSourceResourcePid(goldenResourcePid, sourceResourcePid);
        mdmLink.setLinkSource(theLinkSource);
        mdmLink.setMatchResult(theMatchOutcome.getMatchResultEnum());
        mdmLink.setEidMatch(Boolean.valueOf(theMatchOutcome.isEidMatch() | mdmLink.isEidMatchPresent()));
        mdmLink.setHadToCreateNewGoldenResource(Boolean.valueOf(theMatchOutcome.isCreatedNewResource() | mdmLink.getHadToCreateNewGoldenResource()));
        mdmLink.setMdmSourceType(this.myFhirContext.getResourceType(theSourceResource));
        if (mdmLink.getScore() != null) {
            mdmLink.setScore(Double.valueOf(Math.max(theMatchOutcome.score, mdmLink.getScore())));
        } else {
            mdmLink.setScore(theMatchOutcome.score);
        }
        RequestPartitionId partitionId = (RequestPartitionId)theSourceResource.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (partitionId != null && partitionId.getFirstPartitionIdOrNull() != null) {
            mdmLink.setPartitionId(new PartitionablePartitionId(partitionId.getFirstPartitionIdOrNull(), partitionId.getPartitionDate()));
        }
        String message = String.format("Creating MdmLink from %s to %s.", theGoldenResource.getIdElement().toUnqualifiedVersionless(), theSourceResource.getIdElement().toUnqualifiedVersionless());
        theMdmTransactionContext.addTransactionLogMessage(message);
        ourLog.debug(message);
        this.save(mdmLink);
        return mdmLink;
    }

    @Nonnull
    public MdmLink getOrCreateMdmLinkByGoldenResourcePidAndSourceResourcePid(Long theGoldenResourcePid, Long theSourceResourcePid) {
        Optional<MdmLink> oExisting = this.getLinkByGoldenResourcePidAndSourceResourcePid(theGoldenResourcePid, theSourceResourcePid);
        if (oExisting.isPresent()) {
            return oExisting.get();
        }
        MdmLink newLink = this.myMdmLinkFactory.newMdmLink();
        newLink.setGoldenResourcePid(theGoldenResourcePid);
        newLink.setSourcePid(theSourceResourcePid);
        return newLink;
    }

    public Optional<MdmLink> getLinkByGoldenResourcePidAndSourceResourcePid(Long theGoldenResourcePid, Long theSourceResourcePid) {
        if (theSourceResourcePid == null || theGoldenResourcePid == null) {
            return Optional.empty();
        }
        MdmLink link = this.myMdmLinkFactory.newMdmLink();
        link.setSourcePid(theSourceResourcePid);
        link.setGoldenResourcePid(theGoldenResourcePid);
        Example example = Example.of((Object)link);
        return this.myMdmLinkDao.findOne(example);
    }

    public List<MdmLink> getMdmLinksBySourcePidAndMatchResult(Long theSourcePid, MdmMatchResultEnum theMatchResult) {
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setSourcePid(theSourcePid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    @Transactional
    public Optional<MdmLink> getMatchedLinkForSourcePid(Long theSourcePid) {
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setSourcePid(theSourcePid);
        exampleLink.setMatchResult(MdmMatchResultEnum.MATCH);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    public Optional<MdmLink> getMatchedLinkForSource(IBaseResource theSourceResource) {
        return this.getMdmLinkWithMatchResult(theSourceResource, MdmMatchResultEnum.MATCH);
    }

    public Optional<MdmLink> getPossibleMatchedLinkForSource(IBaseResource theSourceResource) {
        return this.getMdmLinkWithMatchResult(theSourceResource, MdmMatchResultEnum.POSSIBLE_MATCH);
    }

    @Nonnull
    private Optional<MdmLink> getMdmLinkWithMatchResult(IBaseResource theSourceResource, MdmMatchResultEnum theMatchResult) {
        Long pid = this.myJpaIdHelperService.getPidOrNull(theSourceResource);
        if (pid == null) {
            return Optional.empty();
        }
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setSourcePid(pid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    public Optional<MdmLink> getMdmLinksByGoldenResourcePidSourcePidAndMatchResult(Long theGoldenResourcePid, Long theSourcePid, MdmMatchResultEnum theMatchResult) {
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setGoldenResourcePid(theGoldenResourcePid);
        exampleLink.setSourcePid(theSourcePid);
        exampleLink.setMatchResult(theMatchResult);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    public List<MdmLink> getPossibleDuplicates() {
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink();
        exampleLink.setMatchResult(MdmMatchResultEnum.POSSIBLE_DUPLICATE);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    @Transactional
    public Optional<MdmLink> findMdmLinkBySource(IBaseResource theSourceResource) {
        Long pid = this.myJpaIdHelperService.getPidOrNull(theSourceResource);
        if (pid == null) {
            return Optional.empty();
        }
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink().setSourcePid(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findOne(example);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteLink(MdmLink theMdmLink) {
        this.myMdmLinkDao.delete((Object)theMdmLink);
    }

    @Transactional
    public List<MdmLink> findMdmLinksByGoldenResource(IBaseResource theGoldenResource) {
        Long pid = this.myJpaIdHelperService.getPidOrNull(theGoldenResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink().setGoldenResourcePid(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public MdmLink save(MdmLink theMdmLink) {
        if (theMdmLink.getCreated() == null) {
            theMdmLink.setCreated(new Date());
        }
        theMdmLink.setUpdated(new Date());
        return (MdmLink)this.myMdmLinkDao.save((Object)theMdmLink);
    }

    public PageImpl<MdmLink> executeTypedQuery(IIdType theGoldenResourceId, IIdType theSourceId, MdmMatchResultEnum theMatchResult, MdmLinkSourceEnum theLinkSource, MdmPageRequest thePageRequest, List<Integer> thePartitionId) {
        CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(MdmLink.class);
        Root from = criteriaQuery.from(MdmLink.class);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        if (theGoldenResourceId != null) {
            Predicate goldenResourcePredicate = criteriaBuilder.equal(from.get("myGoldenResourcePid").as(Long.class), (Object)this.myJpaIdHelperService.getPidOrThrowException(theGoldenResourceId));
            andPredicates.add(goldenResourcePredicate);
        }
        if (theSourceId != null) {
            Predicate sourceIdPredicate = criteriaBuilder.equal(from.get("mySourcePid").as(Long.class), (Object)this.myJpaIdHelperService.getPidOrThrowException(theSourceId));
            andPredicates.add(sourceIdPredicate);
        }
        if (theMatchResult != null) {
            Predicate matchResultPredicate = criteriaBuilder.equal(from.get("myMatchResult").as(MdmMatchResultEnum.class), (Object)theMatchResult);
            andPredicates.add(matchResultPredicate);
        }
        if (theLinkSource != null) {
            Predicate linkSourcePredicate = criteriaBuilder.equal(from.get("myLinkSource").as(MdmLinkSourceEnum.class), (Object)theLinkSource);
            andPredicates.add(linkSourcePredicate);
        }
        if (!CollectionUtils.isEmpty(thePartitionId)) {
            Expression exp = from.get("myPartitionId").get("myPartitionId").as(Integer.class);
            Predicate linkSourcePredicate = exp.in(thePartitionId);
            andPredicates.add(linkSourcePredicate);
        }
        Predicate finalQuery = criteriaBuilder.and(andPredicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.myEntityManager.createQuery(criteriaQuery.where((Expression)finalQuery));
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQuery.from(MdmLink.class))).where((Expression)finalQuery);
        Long totalResults = (Long)this.myEntityManager.createQuery(countQuery).getSingleResult();
        return new PageImpl(typedQuery.setFirstResult(thePageRequest.getOffset()).setMaxResults(thePageRequest.getCount()).getResultList(), (Pageable)PageRequest.of((int)thePageRequest.getPage(), (int)thePageRequest.getCount()), totalResults.longValue());
    }

    @Transactional
    public List<MdmLink> findMdmLinksBySourceResource(IBaseResource theSourceResource) {
        Long pid = this.myJpaIdHelperService.getPidOrNull(theSourceResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink().setSourcePid(pid);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public List<MdmLink> findMdmMatchLinksByGoldenResource(IBaseResource theGoldenResource) {
        Long pid = this.myJpaIdHelperService.getPidOrNull(theGoldenResource);
        if (pid == null) {
            return Collections.emptyList();
        }
        MdmLink exampleLink = this.myMdmLinkFactory.newMdmLink().setGoldenResourcePid(pid);
        exampleLink.setMatchResult(MdmMatchResultEnum.MATCH);
        Example example = Example.of((Object)exampleLink);
        return this.myMdmLinkDao.findAll(example);
    }

    public MdmLink newMdmLink() {
        return this.myMdmLinkFactory.newMdmLink();
    }

    public Optional<MdmLink> getMatchedOrPossibleMatchedLinkForSource(IAnyResource theResource) {
        Optional<MdmLink> retval = this.getMatchedLinkForSource((IBaseResource)theResource);
        if (!retval.isPresent()) {
            retval = this.getPossibleMatchedLinkForSource((IBaseResource)theResource);
        }
        return retval;
    }

    public Optional<MdmLink> getLinkByGoldenResourceAndSourceResource(@Nullable IAnyResource theGoldenResource, @Nullable IAnyResource theSourceResource) {
        if (theGoldenResource == null || theSourceResource == null) {
            return Optional.empty();
        }
        return this.getLinkByGoldenResourcePidAndSourceResourcePid(this.myJpaIdHelperService.getPidOrNull((IBaseResource)theGoldenResource), this.myJpaIdHelperService.getPidOrNull((IBaseResource)theSourceResource));
    }
}

