/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.dao.expunge.IExpungeEverythingService;
import ca.uhn.fhir.jpa.dao.mdm.MdmLinkDeleteSvc;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.mdm.interceptor.IMdmStorageInterceptor;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.util.EIDHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmStorageInterceptor
implements IMdmStorageInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmStorageInterceptor.class);
    @Autowired
    private IExpungeEverythingService myExpungeEverythingService;
    @Autowired
    private MdmLinkDeleteSvc myMdmLinkDeleteSvc;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private EIDHelper myEIDHelper;
    @Autowired
    private IMdmSettings myMdmSettings;

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void blockManualResourceManipulationOnCreate(IBaseResource theBaseResource, RequestDetails theRequestDetails, ServletRequestDetails theServletRequestDetails) {
        ourLog.debug("Starting pre-storage resource created hook for {}, {}, {}", new Object[]{theBaseResource, theRequestDetails, theServletRequestDetails});
        if (theBaseResource == null) {
            ourLog.warn("Attempting to block golden resource manipulation on a null resource");
            return;
        }
        if (this.myMdmSettings.isPreventMultipleEids()) {
            ourLog.debug("Forbidding multiple EIDs on ", (Object)theBaseResource);
            this.forbidIfHasMultipleEids(theBaseResource);
        }
        if (this.isInternalRequest(theRequestDetails)) {
            ourLog.debug("Internal request - completed processing");
            return;
        }
        this.forbidIfMdmManagedTagIsPresent(theBaseResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void blockManualGoldenResourceManipulationOnUpdate(IBaseResource theOldResource, IBaseResource theUpdatedResource, RequestDetails theRequestDetails, ServletRequestDetails theServletRequestDetails) {
        ourLog.debug("Starting pre-storage resource updated hook for {}, {}, {}, {}", new Object[]{theOldResource, theUpdatedResource, theRequestDetails, theServletRequestDetails});
        if (theUpdatedResource == null) {
            ourLog.warn("Attempting to block golden resource manipulation on a null resource");
            return;
        }
        if (this.myMdmSettings.isPreventMultipleEids()) {
            ourLog.debug("Forbidding multiple EIDs on ", (Object)theUpdatedResource);
            this.forbidIfHasMultipleEids(theUpdatedResource);
        }
        if (MdmResourceUtil.isGoldenRecordRedirected((IBaseResource)theUpdatedResource)) {
            ourLog.debug("Deleting MDM links to deactivated Golden resource {}", (Object)theUpdatedResource.getIdElement().toUnqualifiedVersionless());
            int deleted = this.myMdmLinkDeleteSvc.deleteNonRedirectWithAnyReferenceTo(theUpdatedResource);
            if (deleted > 0) {
                ourLog.debug("Deleted {} MDM links", (Object)deleted);
            }
        }
        if (this.isInternalRequest(theRequestDetails)) {
            ourLog.debug("Internal request - completed processing");
            return;
        }
        if (theOldResource != null) {
            this.forbidIfMdmManagedTagIsPresent(theOldResource);
            this.forbidModifyingMdmTag(theUpdatedResource, theOldResource);
        } else {
            ourLog.warn("Null theOldResource for {} {}", (Object)(theUpdatedResource == null ? "null updated resource" : theUpdatedResource.getIdElement()), (Object)theRequestDetails);
        }
        if (this.myMdmSettings.isPreventEidUpdates()) {
            this.forbidIfModifyingExternalEidOnTarget(theUpdatedResource, theOldResource);
        }
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_DELETED)
    public void deleteMdmLinks(RequestDetails theRequest, IBaseResource theResource) {
        if (!this.myMdmSettings.isSupportedMdmType(this.myFhirContext.getResourceType(theResource))) {
            return;
        }
        this.myMdmLinkDeleteSvc.deleteWithAnyReferenceTo(theResource);
    }

    private void forbidIfModifyingExternalEidOnTarget(IBaseResource theNewResource, IBaseResource theOldResource) {
        List newExternalEids = Collections.emptyList();
        List oldExternalEids = Collections.emptyList();
        if (theNewResource != null) {
            newExternalEids = this.myEIDHelper.getExternalEid(theNewResource);
        }
        if (theOldResource != null) {
            oldExternalEids = this.myEIDHelper.getExternalEid(theOldResource);
        }
        if (oldExternalEids.isEmpty()) {
            return;
        }
        if (!this.myEIDHelper.eidMatchExists(newExternalEids, oldExternalEids)) {
            this.throwBlockEidChange();
        }
    }

    private void throwBlockEidChange() {
        throw new ForbiddenOperationException(Msg.code((int)763) + "While running with EID updates disabled, EIDs may not be updated on source resources");
    }

    private void forbidModifyingMdmTag(IBaseResource theNewResource, IBaseResource theOldResource) {
        if (MdmResourceUtil.isMdmManaged((IBaseResource)theNewResource) != MdmResourceUtil.isMdmManaged((IBaseResource)theOldResource)) {
            this.throwBlockMdmManagedTagChange();
        }
    }

    private void forbidIfHasMultipleEids(IBaseResource theResource) {
        String resourceType = this.extractResourceType(theResource);
        if (this.myMdmSettings.isSupportedMdmType(resourceType) && this.myEIDHelper.getExternalEid(theResource).size() > 1) {
            this.throwBlockMultipleEids();
        }
    }

    private boolean isInternalRequest(RequestDetails theRequestDetails) {
        return theRequestDetails == null || theRequestDetails instanceof SystemRequestDetails;
    }

    private void forbidIfMdmManagedTagIsPresent(IBaseResource theResource) {
        if (theResource == null) {
            ourLog.warn("Attempting to forbid MDM on a null resource");
            return;
        }
        if (MdmResourceUtil.isMdmManaged((IBaseResource)theResource)) {
            this.throwModificationBlockedByMdm();
        }
        if (MdmResourceUtil.hasGoldenRecordSystemTag((IBaseResource)theResource)) {
            this.throwModificationBlockedByMdm();
        }
    }

    private void throwBlockMdmManagedTagChange() {
        throw new ForbiddenOperationException(Msg.code((int)764) + "The HAPI-MDM tag on a resource may not be changed once created.");
    }

    private void throwModificationBlockedByMdm() {
        throw new ForbiddenOperationException(Msg.code((int)765) + "Cannot create or modify Resources that are managed by MDM. This resource contains a tag with one of these systems: http://hapifhir.io/fhir/NamingSystem/mdm-record-status or https://hapifhir.org/NamingSystem/managing-mdm-system");
    }

    private void throwBlockMultipleEids() {
        throw new ForbiddenOperationException(Msg.code((int)766) + "While running with multiple EIDs disabled, source resources may have at most one EID.");
    }

    private String extractResourceType(IBaseResource theResource) {
        return this.myFhirContext.getResourceType(theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_EXPUNGE_EVERYTHING)
    public void expungeAllMdmLinks(AtomicInteger theCounter) {
        ourLog.debug("Expunging all MdmLink records");
        theCounter.addAndGet(this.myExpungeEverythingService.expungeEverythingByType(MdmLink.class));
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_EXPUNGE_RESOURCE)
    public void expungeAllMatchedMdmLinks(AtomicInteger theCounter, IBaseResource theResource) {
        ourLog.debug("Expunging MdmLink records with reference to {}", (Object)theResource.getIdElement());
        theCounter.addAndGet(this.myMdmLinkDeleteSvc.deleteWithAnyReferenceTo(theResource));
    }
}

