/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.index.IJpaIdHelperService;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmResourceDaoSvc;
import ca.uhn.fhir.jpa.mdm.util.MdmPartitionHelper;
import ca.uhn.fhir.mdm.api.IGoldenResourceMergerSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkSvc;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.util.GoldenResourceHelper;
import ca.uhn.fhir.mdm.util.MdmResourceUtil;
import ca.uhn.fhir.mdm.util.MessageHelper;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoldenResourceMergerSvcImpl
implements IGoldenResourceMergerSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    GoldenResourceHelper myGoldenResourceHelper;
    @Autowired
    MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    IMdmLinkSvc myMdmLinkSvc;
    @Autowired
    IJpaIdHelperService myIdHelperService;
    @Autowired
    MdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    MessageHelper myMessageHelper;
    @Autowired
    MdmPartitionHelper myMdmPartitionHelper;

    @Transactional
    public IAnyResource mergeGoldenResources(IAnyResource theFromGoldenResource, IAnyResource theMergedResource, IAnyResource theToGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        Long fromGoldenResourcePid = this.myIdHelperService.getPidOrThrowException(theFromGoldenResource);
        Long toGoldenResourcePid = this.myIdHelperService.getPidOrThrowException(theToGoldenResource);
        String resourceType = theMdmTransactionContext.getResourceType();
        if (theMergedResource != null) {
            if (this.myGoldenResourceHelper.hasIdentifier((IBaseResource)theMergedResource)) {
                throw new IllegalArgumentException(Msg.code((int)751) + "Manually merged resource can not contain identifiers");
            }
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theFromGoldenResource, (IBaseResource)theMergedResource, theMdmTransactionContext);
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theToGoldenResource, (IBaseResource)theMergedResource, theMdmTransactionContext);
            theMergedResource.setId(theToGoldenResource.getId());
            theToGoldenResource = (IAnyResource)this.myMdmResourceDaoSvc.upsertGoldenResource(theMergedResource, resourceType).getResource();
        } else {
            this.myGoldenResourceHelper.mergeIndentifierFields((IBaseResource)theFromGoldenResource, (IBaseResource)theToGoldenResource, theMdmTransactionContext);
            this.myGoldenResourceHelper.mergeNonIdentiferFields((IBaseResource)theFromGoldenResource, (IBaseResource)theToGoldenResource, theMdmTransactionContext);
            this.myMdmResourceDaoSvc.upsertGoldenResource(theToGoldenResource, resourceType);
        }
        this.myMdmPartitionHelper.validateResourcesInSamePartition(theFromGoldenResource, theToGoldenResource);
        this.mergeGoldenResourceLinks(theFromGoldenResource, theToGoldenResource, toGoldenResourcePid, theMdmTransactionContext);
        this.addMergeLink(toGoldenResourcePid, fromGoldenResourcePid, resourceType);
        this.myMdmResourceDaoSvc.removeGoldenResourceTag(theFromGoldenResource, resourceType);
        MdmResourceUtil.setGoldenResourceRedirected((IBaseResource)theFromGoldenResource);
        this.myMdmResourceDaoSvc.upsertGoldenResource(theFromGoldenResource, resourceType);
        this.log(theMdmTransactionContext, "Merged " + theFromGoldenResource.getIdElement().toVersionless() + " into " + theToGoldenResource.getIdElement().toVersionless());
        return theToGoldenResource;
    }

    private void addMergeLink(Long theGoldenResourcePidAkaActive, Long theTargetResourcePidAkaDeactivated, String theResourceType) {
        MdmLink mdmLink = this.myMdmLinkDaoSvc.getOrCreateMdmLinkByGoldenResourcePidAndSourceResourcePid(theGoldenResourcePidAkaActive, theTargetResourcePidAkaDeactivated);
        mdmLink.setMdmSourceType(theResourceType).setMatchResult(MdmMatchResultEnum.REDIRECT).setLinkSource(MdmLinkSourceEnum.MANUAL);
        this.myMdmLinkDaoSvc.save(mdmLink);
    }

    private void mergeGoldenResourceLinks(IAnyResource theFromResource, IAnyResource theToResource, Long theToResourcePid, MdmTransactionContext theMdmTransactionContext) {
        List<MdmLink> fromLinks = this.myMdmLinkDaoSvc.findMdmLinksByGoldenResource((IBaseResource)theFromResource);
        List<MdmLink> toLinks = this.myMdmLinkDaoSvc.findMdmLinksByGoldenResource((IBaseResource)theToResource);
        ArrayList<MdmLink> toDelete = new ArrayList<MdmLink>();
        for (MdmLink fromLink : fromLinks) {
            Optional<MdmLink> optionalToLink = this.findFirstLinkWithMatchingSource(toLinks, fromLink);
            if (optionalToLink.isPresent()) {
                MdmLink toLink = optionalToLink.get();
                if (fromLink.isManual()) {
                    switch (toLink.getLinkSource()) {
                        case AUTO: {
                            this.log(theMdmTransactionContext, String.format("MANUAL overrides AUT0.  Deleting link %s", toLink.toString()));
                            this.myMdmLinkDaoSvc.deleteLink(toLink);
                            break;
                        }
                        case MANUAL: {
                            if (fromLink.getMatchResult() == toLink.getMatchResult()) break;
                            throw new InvalidRequestException(Msg.code((int)752) + "A MANUAL " + fromLink.getMatchResult() + " link may not be merged into a MANUAL " + toLink.getMatchResult() + " link for the same target");
                        }
                    }
                } else {
                    toDelete.add(fromLink);
                    continue;
                }
            }
            fromLink.setGoldenResourcePid(theToResourcePid);
            ourLog.trace("Saving link {}", (Object)fromLink);
            this.myMdmLinkDaoSvc.save(fromLink);
        }
        toDelete.forEach(link -> this.myMdmLinkDaoSvc.deleteLink((MdmLink)link));
    }

    private Optional<MdmLink> findFirstLinkWithMatchingSource(List<MdmLink> theMdmLinks, MdmLink theLinkWithSourceToMatch) {
        return theMdmLinks.stream().filter(mdmLink -> mdmLink.getSourcePid().equals(theLinkWithSourceToMatch.getSourcePid())).findFirst();
    }

    private void log(MdmTransactionContext theMdmTransactionContext, String theMessage) {
        theMdmTransactionContext.addTransactionLogMessage(theMessage);
        ourLog.debug(theMessage);
    }
}

