/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.mdm.api.IGoldenResourceMergerSvc;
import ca.uhn.fhir.mdm.api.IMdmBatchJobSubmitterFactory;
import ca.uhn.fhir.mdm.api.IMdmControllerSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkCreateSvc;
import ca.uhn.fhir.mdm.api.IMdmLinkQuerySvc;
import ca.uhn.fhir.mdm.api.IMdmLinkUpdaterSvc;
import ca.uhn.fhir.mdm.api.MdmLinkJson;
import ca.uhn.fhir.mdm.api.MdmLinkSourceEnum;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.api.paging.MdmPageRequest;
import ca.uhn.fhir.mdm.model.MdmTransactionContext;
import ca.uhn.fhir.mdm.provider.MdmControllerHelper;
import ca.uhn.fhir.mdm.provider.MdmControllerUtil;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IMultiUrlJobSubmitter;
import ca.uhn.fhir.rest.server.provider.MultiUrlProcessor;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class MdmControllerSvcImpl
implements IMdmControllerSvc {
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    MdmControllerHelper myMdmControllerHelper;
    @Autowired
    IGoldenResourceMergerSvc myGoldenResourceMergerSvc;
    @Autowired
    IMdmLinkQuerySvc myMdmLinkQuerySvc;
    @Autowired
    IMdmLinkUpdaterSvc myIMdmLinkUpdaterSvc;
    @Autowired
    IMdmLinkCreateSvc myIMdmLinkCreateSvc;
    @Autowired
    IMdmBatchJobSubmitterFactory myMdmBatchJobSubmitterFactory;
    @Autowired
    IRequestPartitionHelperSvc myRequestPartitionHelperSvc;

    public IAnyResource mergeGoldenResources(String theFromGoldenResourceId, String theToGoldenResourceId, IAnyResource theManuallyMergedGoldenResource, MdmTransactionContext theMdmTransactionContext) {
        IAnyResource fromGoldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("fromGoldenResourceId", theFromGoldenResourceId);
        IAnyResource toGoldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("toGoldenResourceId", theToGoldenResourceId);
        this.myMdmControllerHelper.validateMergeResources(fromGoldenResource, toGoldenResource);
        this.myMdmControllerHelper.validateSameVersion(fromGoldenResource, theFromGoldenResourceId);
        this.myMdmControllerHelper.validateSameVersion(toGoldenResource, theToGoldenResourceId);
        return this.myGoldenResourceMergerSvc.mergeGoldenResources(fromGoldenResource, theManuallyMergedGoldenResource, toGoldenResource, theMdmTransactionContext);
    }

    public Page<MdmLinkJson> queryLinks(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest) {
        return this.queryLinksFromPartitionList(theGoldenResourceId, theSourceResourceId, theMatchResult, theLinkSource, theMdmTransactionContext, thePageRequest, null);
    }

    public Page<MdmLinkJson> queryLinks(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, @Nullable RequestDetails theRequestDetails) {
        Page<MdmLinkJson> resultPage;
        RequestPartitionId theReadPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequest(theRequestDetails, null, null);
        if (theReadPartitionId.hasPartitionIds()) {
            resultPage = this.queryLinksFromPartitionList(theGoldenResourceId, theSourceResourceId, theMatchResult, theLinkSource, theMdmTransactionContext, thePageRequest, theReadPartitionId.getPartitionIds());
            this.validateMdmQueryPermissions(theReadPartitionId, resultPage.getContent(), theRequestDetails);
        } else {
            resultPage = this.queryLinksFromPartitionList(theGoldenResourceId, theSourceResourceId, theMatchResult, theLinkSource, theMdmTransactionContext, thePageRequest, null);
        }
        return resultPage;
    }

    public Page<MdmLinkJson> queryLinksFromPartitionList(@Nullable String theGoldenResourceId, @Nullable String theSourceResourceId, @Nullable String theMatchResult, @Nullable String theLinkSource, MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, @Nullable List<Integer> thePartitionIds) {
        IIdType goldenResourceId = MdmControllerUtil.extractGoldenResourceIdDtOrNull((String)"goldenResourceId", (String)theGoldenResourceId);
        IIdType sourceId = MdmControllerUtil.extractSourceIdDtOrNull((String)"resourceId", (String)theSourceResourceId);
        MdmMatchResultEnum matchResult = MdmControllerUtil.extractMatchResultOrNull((String)theMatchResult);
        MdmLinkSourceEnum linkSource = MdmControllerUtil.extractLinkSourceOrNull((String)theLinkSource);
        return this.myMdmLinkQuerySvc.queryLinks(goldenResourceId, sourceId, matchResult, linkSource, theMdmTransactionContext, thePageRequest, thePartitionIds);
    }

    public Page<MdmLinkJson> getDuplicateGoldenResources(MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest) {
        return this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest);
    }

    public Page<MdmLinkJson> getDuplicateGoldenResources(MdmTransactionContext theMdmTransactionContext, MdmPageRequest thePageRequest, RequestDetails theRequestDetails) {
        RequestPartitionId readPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequest(theRequestDetails, null, null);
        Page resultPage = readPartitionId.isAllPartitions() ? this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest) : this.myMdmLinkQuerySvc.getDuplicateGoldenResources(theMdmTransactionContext, thePageRequest, readPartitionId.getPartitionIds());
        this.validateMdmQueryPermissions(readPartitionId, resultPage.getContent(), theRequestDetails);
        return resultPage;
    }

    public IAnyResource updateLink(String theGoldenResourceId, String theSourceResourceId, String theMatchResult, MdmTransactionContext theMdmTransactionContext) {
        MdmMatchResultEnum matchResult = MdmControllerUtil.extractMatchResultOrNull((String)theMatchResult);
        IAnyResource goldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("goldenResourceId", theGoldenResourceId);
        IAnyResource source = this.myMdmControllerHelper.getLatestSourceFromIdOrThrowException("resourceId", theSourceResourceId);
        this.myMdmControllerHelper.validateSameVersion(goldenResource, theGoldenResourceId);
        this.myMdmControllerHelper.validateSameVersion(source, theSourceResourceId);
        return this.myIMdmLinkUpdaterSvc.updateLink(goldenResource, source, matchResult, theMdmTransactionContext);
    }

    public IAnyResource createLink(String theGoldenResourceId, String theSourceResourceId, @Nullable String theMatchResult, MdmTransactionContext theMdmTransactionContext) {
        MdmMatchResultEnum matchResult = MdmControllerUtil.extractMatchResultOrNull((String)theMatchResult);
        IAnyResource goldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("goldenResourceId", theGoldenResourceId);
        IAnyResource source = this.myMdmControllerHelper.getLatestSourceFromIdOrThrowException("resourceId", theSourceResourceId);
        this.myMdmControllerHelper.validateSameVersion(goldenResource, theGoldenResourceId);
        this.myMdmControllerHelper.validateSameVersion(source, theSourceResourceId);
        return this.myIMdmLinkCreateSvc.createLink(goldenResource, source, matchResult, theMdmTransactionContext);
    }

    public IBaseParameters submitMdmClearJob(List<String> theUrls, IPrimitiveType<BigDecimal> theBatchSize, ServletRequestDetails theRequestDetails) {
        MultiUrlProcessor multiUrlProcessor = new MultiUrlProcessor(this.myFhirContext, (IMultiUrlJobSubmitter)this.myMdmBatchJobSubmitterFactory.getClearJobSubmitter());
        return multiUrlProcessor.processUrls(theUrls, multiUrlProcessor.getBatchSize(theBatchSize), (RequestDetails)theRequestDetails);
    }

    public void notDuplicateGoldenResource(String theGoldenResourceId, String theTargetGoldenResourceId, MdmTransactionContext theMdmTransactionContext) {
        IAnyResource goldenResource = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("goldenResourceId", theGoldenResourceId);
        IAnyResource target = this.myMdmControllerHelper.getLatestGoldenResourceFromIdOrThrowException("resourceId", theTargetGoldenResourceId);
        this.myIMdmLinkUpdaterSvc.notDuplicateGoldenResource(goldenResource, target, theMdmTransactionContext);
    }

    private void validateMdmQueryPermissions(RequestPartitionId theRequestPartitionId, List<MdmLinkJson> theMdmLinkJsonList, RequestDetails theRequestDetails) {
        HashSet<String> seenResourceTypes = new HashSet<String>();
        for (MdmLinkJson mdmLinkJson : theMdmLinkJsonList) {
            IdDt idDt = new IdDt(mdmLinkJson.getSourceId());
            if (seenResourceTypes.contains(idDt.getResourceType())) continue;
            this.myRequestPartitionHelperSvc.validateHasPartitionPermissions(theRequestDetails, idDt.getResourceType(), theRequestPartitionId);
            seenResourceTypes.add(idDt.getResourceType());
        }
    }
}

