/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.mdm.svc.MdmSearchParamSvc;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.mdm.api.IMdmChannelSubmitterSvc;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.mdm.api.IMdmSubmitSvc;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class MdmSubmitSvcImpl
implements IMdmSubmitSvc {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private MdmSearchParamSvc myMdmSearchParamSvc;
    @Autowired
    private IMdmChannelSubmitterSvc myMdmChannelSubmitterSvc;
    @Autowired
    private IMdmSettings myMdmSettings;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    public static final int DEFAULT_BUFFER_SIZE = 100;
    private int myBufferSize = 100;

    @Transactional
    public long submitAllSourceTypesToMdm(@Nullable String theCriteria, @Nonnull RequestDetails theRequestDetails) {
        long submittedCount = this.myMdmSettings.getMdmRules().getMdmTypes().stream().mapToLong(type -> this.submitSourceResourceTypeToMdm((String)type, theCriteria, theRequestDetails)).sum();
        return submittedCount;
    }

    @Transactional
    public long submitSourceResourceTypeToMdm(String theSourceResourceType, @Nullable String theCriteria, @Nonnull RequestDetails theRequestDetails) {
        if (theCriteria == null) {
            ourLog.info("Submitting all resources of type {} to MDM", (Object)theSourceResourceType);
        } else {
            ourLog.info("Submitting resources of type {} with criteria {} to MDM", (Object)theSourceResourceType, (Object)theCriteria);
        }
        this.validateSourceType(theSourceResourceType);
        SearchParameterMap spMap = this.myMdmSearchParamSvc.getSearchParameterMapFromCriteria(theSourceResourceType, theCriteria);
        spMap.setLoadSynchronous(true);
        spMap.setCount(Integer.valueOf(this.myBufferSize));
        ISearchBuilder searchBuilder = this.myMdmSearchParamSvc.generateSearchBuilderForType(theSourceResourceType);
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForSearchType(theRequestDetails, theSourceResourceType, spMap, null);
        return this.submitAllMatchingResourcesToMdmChannel(spMap, searchBuilder, requestPartitionId);
    }

    private long submitAllMatchingResourcesToMdmChannel(SearchParameterMap theSpMap, ISearchBuilder theSearchBuilder, RequestPartitionId theRequestPartitionId) {
        SearchRuntimeDetails searchRuntimeDetails = new SearchRuntimeDetails(null, UUID.randomUUID().toString());
        long total = 0L;
        try (IResultIterator query = theSearchBuilder.createQuery(theSpMap, searchRuntimeDetails, null, theRequestPartitionId);){
            do {
                Collection pidBatch = query.getNextResultBatch((long)this.myBufferSize);
                total += this.loadPidsAndSubmitToMdmChannel(theSearchBuilder, pidBatch);
            } while (query.hasNext());
        }
        catch (IOException theE) {
            throw new InternalErrorException(Msg.code((int)749) + "Failure while attempting to query resources for $mdm-submit", (Throwable)theE);
        }
        ourLog.info("MDM Submit complete.  Submitted a total of {} resources.", (Object)total);
        return total;
    }

    private long loadPidsAndSubmitToMdmChannel(ISearchBuilder theSearchBuilder, Collection<ResourcePersistentId> thePidsToSubmit) {
        ArrayList resourcesToSubmit = new ArrayList();
        theSearchBuilder.loadResourcesByPid(thePidsToSubmit, Collections.emptyList(), resourcesToSubmit, false, null);
        ourLog.info("Submitting {} resources to MDM", (Object)resourcesToSubmit.size());
        resourcesToSubmit.forEach(resource -> this.myMdmChannelSubmitterSvc.submitResourceToMdmChannel(resource));
        return resourcesToSubmit.size();
    }

    @Transactional
    public long submitPractitionerTypeToMdm(@Nullable String theCriteria, @Nonnull RequestDetails theRequestDetails) {
        return this.submitSourceResourceTypeToMdm("Practitioner", theCriteria, theRequestDetails);
    }

    @Transactional
    public long submitPatientTypeToMdm(@Nullable String theCriteria, @Nonnull RequestDetails theRequestDetails) {
        return this.submitSourceResourceTypeToMdm("Patient", theCriteria, theRequestDetails);
    }

    @Transactional
    public long submitSourceResourceToMdm(IIdType theId, RequestDetails theRequestDetails) {
        this.validateSourceType(theId.getResourceType());
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theId.getResourceType());
        IBaseResource read = resourceDao.read(theId, theRequestDetails);
        this.myMdmChannelSubmitterSvc.submitResourceToMdmChannel(read);
        return 1L;
    }

    public void setMdmSettings(IMdmSettings theMdmSettings) {
        this.myMdmSettings = theMdmSettings;
    }

    private void validateSourceType(String theResourceType) {
        if (!this.myMdmSettings.getMdmRules().getMdmTypes().contains(theResourceType)) {
            throw new InvalidRequestException(Msg.code((int)750) + "$mdm-submit does not support resource type: " + theResourceType);
        }
    }

    public void setBufferSize(int myBufferSize) {
        this.myBufferSize = myBufferSize;
    }
}

