/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class CandidateList {
    private final CandidateStrategyEnum myStrategy;
    private final List<MatchedGoldenResourceCandidate> myList = new ArrayList<MatchedGoldenResourceCandidate>();

    public CandidateList(CandidateStrategyEnum theStrategy) {
        this.myStrategy = theStrategy;
    }

    public CandidateStrategyEnum getStrategy() {
        return this.myStrategy;
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    public void addAll(List<MatchedGoldenResourceCandidate> theList) {
        this.myList.addAll(theList);
    }

    public MatchedGoldenResourceCandidate getOnlyMatch() {
        assert (this.myList.size() == 1);
        return this.myList.get(0);
    }

    public boolean exactlyOneMatch() {
        return this.myList.size() == 1;
    }

    public Stream<MatchedGoldenResourceCandidate> stream() {
        return this.myList.stream();
    }

    public List<MatchedGoldenResourceCandidate> getCandidates() {
        return Collections.unmodifiableList(this.myList);
    }

    public MatchedGoldenResourceCandidate getFirstMatch() {
        return this.myList.get(0);
    }

    public boolean isEidMatch() {
        return this.myStrategy.isEidMatch();
    }

    public int size() {
        return this.myList.size();
    }
}

