/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.mdm.svc.MdmSearchParamSvc;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.mdm.api.IMdmSettings;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CandidateSearcher {
    private static final Logger ourLog = LoggerFactory.getLogger(CandidateSearcher.class);
    private final DaoRegistry myDaoRegistry;
    private final IMdmSettings myMdmSettings;
    private final MdmSearchParamSvc myMdmSearchParamSvc;

    @Autowired
    public CandidateSearcher(DaoRegistry theDaoRegistry, IMdmSettings theMdmSettings, MdmSearchParamSvc theMdmSearchParamSvc) {
        this.myDaoRegistry = theDaoRegistry;
        this.myMdmSettings = theMdmSettings;
        this.myMdmSearchParamSvc = theMdmSearchParamSvc;
    }

    public Optional<IBundleProvider> search(String theResourceType, String theResourceCriteria, RequestPartitionId partitionId) {
        SearchParameterMap searchParameterMap = this.myMdmSearchParamSvc.mapFromCriteria(theResourceType, theResourceCriteria);
        searchParameterMap.setLoadSynchronousUpTo(Integer.valueOf(this.myMdmSettings.getCandidateSearchLimit()));
        IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(theResourceType);
        SystemRequestDetails systemRequestDetails = new SystemRequestDetails();
        systemRequestDetails.setRequestPartitionId(partitionId);
        IBundleProvider retval = resourceDao.search(searchParameterMap, (RequestDetails)systemRequestDetails);
        if (retval.size() != null && retval.size() >= this.myMdmSettings.getCandidateSearchLimit()) {
            return Optional.empty();
        }
        return Optional.of(retval);
    }

    public Optional<IBundleProvider> search(String theResourceType, String theResourceCriteria) {
        return this.search(theResourceType, theResourceCriteria, RequestPartitionId.allPartitions());
    }
}

