/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.MdmResourceDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.BaseCandidateFinder;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.mdm.api.MdmMatchOutcome;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.mdm.model.CanonicalEID;
import ca.uhn.fhir.mdm.util.EIDHelper;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FindCandidateByEidSvc
extends BaseCandidateFinder {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    private EIDHelper myEIDHelper;
    @Autowired
    private MdmResourceDaoSvc myMdmResourceDaoSvc;
    @Autowired
    private MdmLinkDaoSvc myMdmLinkDaoSvc;

    @Override
    protected List<MatchedGoldenResourceCandidate> findMatchGoldenResourceCandidates(IAnyResource theBaseResource) {
        ArrayList<MatchedGoldenResourceCandidate> retval = new ArrayList<MatchedGoldenResourceCandidate>();
        List eidFromResource = this.myEIDHelper.getExternalEid((IBaseResource)theBaseResource);
        if (!eidFromResource.isEmpty()) {
            for (CanonicalEID eid : eidFromResource) {
                IAnyResource foundGoldenResource;
                Optional<IAnyResource> oFoundGoldenResource = this.myMdmResourceDaoSvc.searchGoldenResourceByEID(eid.getValue(), theBaseResource.getIdElement().getResourceType(), (RequestPartitionId)theBaseResource.getUserData(Constants.RESOURCE_PARTITION_ID));
                if (!oFoundGoldenResource.isPresent() || this.isNoMatch(foundGoldenResource = oFoundGoldenResource.get(), theBaseResource)) continue;
                Long pidOrNull = this.myIdHelperService.getPidOrNull((IBaseResource)foundGoldenResource);
                MatchedGoldenResourceCandidate mpc = new MatchedGoldenResourceCandidate(new ResourcePersistentId((Object)pidOrNull), MdmMatchOutcome.EID_MATCH);
                ourLog.debug("Matched {} by EID {}", (Object)foundGoldenResource.getIdElement(), (Object)eid);
                retval.add(mpc);
            }
        }
        return retval;
    }

    private boolean isNoMatch(IAnyResource theGoldenResource, IAnyResource theSourceResource) {
        Optional<MdmLink> oLink = this.myMdmLinkDaoSvc.getLinkByGoldenResourceAndSourceResource(theGoldenResource, theSourceResource);
        if (oLink.isEmpty()) {
            return false;
        }
        MdmLink link = oLink.get();
        return link.isNoMatch();
    }

    @Override
    protected CandidateStrategyEnum getStrategy() {
        return CandidateStrategyEnum.EID;
    }
}

