/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.index.IJpaIdHelperService;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.mdm.dao.MdmLinkDaoSvc;
import ca.uhn.fhir.jpa.mdm.svc.candidate.BaseCandidateFinder;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.mdm.api.IMdmMatchFinderSvc;
import ca.uhn.fhir.mdm.api.MatchedTarget;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FindCandidateByExampleSvc
extends BaseCandidateFinder {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();
    @Autowired
    IJpaIdHelperService myIdHelperService;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private MdmLinkDaoSvc myMdmLinkDaoSvc;
    @Autowired
    private IMdmMatchFinderSvc myMdmMatchFinderSvc;

    @Override
    protected List<MatchedGoldenResourceCandidate> findMatchGoldenResourceCandidates(IAnyResource theTarget) {
        ArrayList<MatchedGoldenResourceCandidate> retval = new ArrayList<MatchedGoldenResourceCandidate>();
        List<Long> goldenResourcePidsToExclude = this.getNoMatchGoldenResourcePids((IBaseResource)theTarget);
        List matchedCandidates = this.myMdmMatchFinderSvc.getMatchedTargets(this.myFhirContext.getResourceType((IBaseResource)theTarget), theTarget, (RequestPartitionId)theTarget.getUserData(Constants.RESOURCE_PARTITION_ID));
        matchedCandidates = matchedCandidates.stream().filter(mc -> mc.isMatch() || mc.isPossibleMatch()).collect(Collectors.toList());
        for (MatchedTarget match : matchedCandidates) {
            Optional<MdmLink> optionalMdmLink = this.myMdmLinkDaoSvc.getMatchedLinkForSourcePid(this.myIdHelperService.getPidOrNull((IBaseResource)match.getTarget()));
            if (!optionalMdmLink.isPresent()) continue;
            MdmLink matchMdmLink = optionalMdmLink.get();
            if (goldenResourcePidsToExclude.contains(matchMdmLink.getGoldenResourcePid())) {
                ourLog.info("Skipping MDM on candidate Golden Resource with PID {} due to manual NO_MATCH", (Object)matchMdmLink.getGoldenResourcePid());
                continue;
            }
            MatchedGoldenResourceCandidate candidate = new MatchedGoldenResourceCandidate(this.getResourcePersistentId(matchMdmLink.getGoldenResourcePid()), match.getMatchResult());
            retval.add(candidate);
        }
        return retval;
    }

    private List<Long> getNoMatchGoldenResourcePids(IBaseResource theBaseResource) {
        Long targetPid = this.myIdHelperService.getPidOrNull(theBaseResource);
        return this.myMdmLinkDaoSvc.getMdmLinksBySourcePidAndMatchResult(targetPid, MdmMatchResultEnum.NO_MATCH).stream().map(MdmLink::getGoldenResourcePid).collect(Collectors.toList());
    }

    private ResourcePersistentId getResourcePersistentId(Long theGoldenResourcePid) {
        return new ResourcePersistentId((Object)theGoldenResourcePid);
    }

    @Override
    protected CandidateStrategyEnum getStrategy() {
        return CandidateStrategyEnum.SCORE;
    }
}

