/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.mdm.svc.candidate;

import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.mdm.svc.candidate.BaseCandidateFinder;
import ca.uhn.fhir.jpa.mdm.svc.candidate.CandidateStrategyEnum;
import ca.uhn.fhir.jpa.mdm.svc.candidate.MatchedGoldenResourceCandidate;
import ca.uhn.fhir.mdm.log.Logs;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FindCandidateByLinkSvc
extends BaseCandidateFinder {
    private static final Logger ourLog = Logs.getMdmTroubleshootingLog();

    @Override
    protected List<MatchedGoldenResourceCandidate> findMatchGoldenResourceCandidates(IAnyResource theTarget) {
        Optional<MdmLink> oLink;
        ArrayList<MatchedGoldenResourceCandidate> retval = new ArrayList<MatchedGoldenResourceCandidate>();
        Long targetPid = this.myIdHelperService.getPidOrNull((IBaseResource)theTarget);
        if (targetPid != null && (oLink = this.myMdmLinkDaoSvc.getMatchedLinkForSourcePid(targetPid)).isPresent()) {
            ResourcePersistentId goldenResourcePid = new ResourcePersistentId((Object)oLink.get().getGoldenResourcePid());
            ourLog.debug("Resource previously linked. Using existing link.");
            retval.add(new MatchedGoldenResourceCandidate(goldenResourcePid, oLink.get()));
        }
        return retval;
    }

    @Override
    protected CandidateStrategyEnum getStrategy() {
        return CandidateStrategyEnum.LINK;
    }
}

