/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationFlagsEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class RuleBulkExportImpl
extends BaseRule {
    private String myGroupId;
    private BulkDataExportOptions.ExportStyle myWantExportStyle;
    private Collection<String> myResourceTypes;
    private boolean myWantAnyStyle;

    RuleBulkExportImpl(String theRuleName) {
        super(theRuleName);
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier, Set<AuthorizationFlagsEnum> theFlags, Pointcut thePointcut) {
        if (thePointcut != Pointcut.STORAGE_INITIATE_BULK_EXPORT) {
            return null;
        }
        if (theRequestDetails == null) {
            return null;
        }
        BulkDataExportOptions options = (BulkDataExportOptions)theRequestDetails.getAttribute(AuthorizationInterceptor.REQUEST_ATTRIBUTE_BULK_DATA_EXPORT_OPTIONS);
        if (!this.myWantAnyStyle && options.getExportStyle() != this.myWantExportStyle) {
            return null;
        }
        if (this.myResourceTypes != null && !this.myResourceTypes.isEmpty()) {
            if (options.getResourceTypes() == null) {
                return null;
            }
            for (String next : options.getResourceTypes()) {
                if (this.myResourceTypes.contains(next)) continue;
                return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
            }
        }
        if (this.myWantAnyStyle || this.myWantExportStyle == BulkDataExportOptions.ExportStyle.SYSTEM) {
            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
        }
        if (StringUtils.isNotBlank((CharSequence)this.myGroupId) && options.getGroupId() != null) {
            String actualGroupId;
            String expectedGroupId = new IdDt(this.myGroupId).toUnqualifiedVersionless().getValue();
            if (Objects.equals(expectedGroupId, actualGroupId = options.getGroupId().toUnqualifiedVersionless().getValue())) {
                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
            }
            return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
        }
        return null;
    }

    public void setAppliesToGroupExportOnGroup(String theGroupId) {
        this.myWantExportStyle = BulkDataExportOptions.ExportStyle.GROUP;
        this.myGroupId = theGroupId;
    }

    public void setAppliesToPatientExportOnGroup(String theGroupId) {
        this.myWantExportStyle = BulkDataExportOptions.ExportStyle.PATIENT;
        this.myGroupId = theGroupId;
    }

    public void setAppliesToSystem() {
        this.myWantExportStyle = BulkDataExportOptions.ExportStyle.SYSTEM;
    }

    public void setResourceTypes(Collection<String> theResourceTypes) {
        this.myResourceTypes = theResourceTypes;
    }

    public void setAppliesToAny() {
        this.myWantAnyStyle = true;
    }

    String getGroupId() {
        return this.myGroupId;
    }

    BulkDataExportOptions.ExportStyle getWantExportStyle() {
        return this.myWantExportStyle;
    }
}

