/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationFlagsEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleImplOp;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleTarget;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.FhirTerser;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;

class SearchParameterAndValueSetRuleImpl
extends RuleImplOp {
    private String mySearchParameterName;
    private String myValueSetUrl;
    private boolean myWantCode;

    SearchParameterAndValueSetRuleImpl(String theRuleName) {
        super(theRuleName);
    }

    void setWantCode(boolean theWantCode) {
        this.myWantCode = theWantCode;
    }

    public void setSearchParameterName(String theSearchParameterName) {
        this.mySearchParameterName = theSearchParameterName;
    }

    public void setValueSetUrl(String theValueSetUrl) {
        this.myValueSetUrl = theValueSetUrl;
    }

    @Override
    protected AuthorizationInterceptor.Verdict applyRuleLogic(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, Set<AuthorizationFlagsEnum> theFlags, FhirContext theFhirContext, RuleTarget theRuleTarget, IRuleApplier theRuleApplier) {
        Validate.isTrue((theInputResource == null || theOutputResource == null ? 1 : 0) != 0);
        if (theInputResource != null) {
            return this.applyRuleLogic(theFhirContext, theRequestDetails, theInputResource, theOperation, theInputResource, theInputResourceId, theOutputResource, theRuleApplier);
        }
        if (theOutputResource != null) {
            return this.applyRuleLogic(theFhirContext, theRequestDetails, theOutputResource, theOperation, theInputResource, theInputResourceId, theOutputResource, theRuleApplier);
        }
        if (theOperation == RestOperationTypeEnum.READ || theOperation == RestOperationTypeEnum.SEARCH_TYPE) {
            return new AuthorizationInterceptor.Verdict(PolicyEnum.ALLOW, this);
        }
        return null;
    }

    private AuthorizationInterceptor.Verdict applyRuleLogic(FhirContext theFhirContext, RequestDetails theRequestDetails, IBaseResource theResource, RestOperationTypeEnum theOperation, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier) {
        IValidationSupport validationSupport = theRuleApplier.getValidationSupport();
        if (validationSupport == null) {
            validationSupport = theFhirContext.getValidationSupport();
        }
        String operationDescription = "Authorization Rule";
        ISearchParamRegistry searchParamRegistry = null;
        boolean wantCode = this.myWantCode;
        Logger troubleshootingLog = theRuleApplier.getTroubleshootingLog();
        CodeMatchCount codeMatchCount = SearchParameterAndValueSetRuleImpl.countMatchingCodesInValueSetForSearchParameter(theResource, validationSupport, searchParamRegistry, wantCode, this.mySearchParameterName, this.myValueSetUrl, troubleshootingLog, operationDescription);
        if (codeMatchCount.isAtLeastOneUnableToValidate()) {
            troubleshootingLog.warn("ValueSet {} could not be validated by terminology service - Assuming DENY", (Object)this.myValueSetUrl);
            return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
        }
        if (this.myWantCode && codeMatchCount.getMatchingCodeCount() > 0) {
            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
        }
        if (!this.myWantCode) {
            boolean othersFound;
            boolean notFound = this.getMode() == PolicyEnum.ALLOW && codeMatchCount.getMatchingCodeCount() == 0;
            boolean bl = othersFound = this.getMode() == PolicyEnum.DENY && codeMatchCount.getMatchingCodeCount() < codeMatchCount.getOverallCodeCount();
            if (notFound || othersFound) {
                AuthorizationInterceptor.Verdict verdict = this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                if (notFound) {
                    troubleshootingLog.debug("Code was not found in VS - Verdict: {}", (Object)verdict);
                } else {
                    troubleshootingLog.debug("Code(s) found that are not in VS - Verdict: {}", (Object)verdict);
                }
                return verdict;
            }
        }
        return null;
    }

    @Nonnull
    static CodeMatchCount countMatchingCodesInValueSetForSearchParameter(IBaseResource theResource, IValidationSupport theValidationSupport, ISearchParamRegistry theSearchParamRegistry, boolean theReturnOnFirstMatch, String theSearchParameterName, String theValueSetUrl, Logger theTroubleshootingLog, String theOperationDescription) {
        theTroubleshootingLog.debug("Applying {} {}:{} for valueSet: {}", new Object[]{theOperationDescription, theSearchParameterName, theReturnOnFirstMatch ? "in" : "not-in", theValueSetUrl});
        FhirContext fhirContext = theValidationSupport.getFhirContext();
        FhirTerser terser = fhirContext.newTerser();
        ConceptValidationOptions conceptValidationOptions = new ConceptValidationOptions();
        ValidationSupportContext validationSupportContext = new ValidationSupportContext(theValidationSupport);
        RuntimeResourceDefinition resourceDefinition = fhirContext.getResourceDefinition(theResource);
        RuntimeSearchParam searchParameter = resourceDefinition.getSearchParam(theSearchParameterName);
        if (searchParameter == null) {
            throw new InternalErrorException(Msg.code((int)2025) + "Unknown SearchParameter for resource " + resourceDefinition.getName() + ": " + theSearchParameterName);
        }
        List paths = searchParameter.getPathsSplitForResourceType(resourceDefinition.getName());
        CodeMatchCount codeMatchCount = new CodeMatchCount();
        for (String nextPath : paths) {
            List foundCodeableConcepts = fhirContext.newFhirPath().evaluate((IBase)theResource, nextPath, ICompositeType.class);
            for (ICompositeType nextCodeableConcept : foundCodeableConcepts) {
                for (IBase nextCoding : terser.getValues((IBase)nextCodeableConcept, "coding")) {
                    String system = terser.getSinglePrimitiveValueOrNull(nextCoding, "system");
                    String code = terser.getSinglePrimitiveValueOrNull(nextCoding, "code");
                    if (!StringUtils.isNotBlank((CharSequence)system) || !StringUtils.isNotBlank((CharSequence)code)) continue;
                    IValidationSupport.CodeValidationResult validateCodeResult = theValidationSupport.validateCode(validationSupportContext, conceptValidationOptions, system, code, null, theValueSetUrl);
                    if (validateCodeResult != null) {
                        if (validateCodeResult.isOk()) {
                            codeMatchCount.addMatchingCode();
                            theTroubleshootingLog.debug("Code {}#{} was found in ValueSet[{}] - {}", new Object[]{system, code, theValueSetUrl, validateCodeResult.getMessage()});
                            if (!theReturnOnFirstMatch) continue;
                            return codeMatchCount;
                        }
                        codeMatchCount.addNonMatchingCode();
                        theTroubleshootingLog.debug("Code {}#{} was not found in ValueSet[{}]: {}", new Object[]{system, code, theValueSetUrl, validateCodeResult.getMessage()});
                        continue;
                    }
                    theTroubleshootingLog.debug("Terminology service was unable to validate code {}#{} in ValueSet[{}] - No service was able to handle this request", new Object[]{system, code, theValueSetUrl});
                    codeMatchCount.addUnableToValidate();
                }
            }
        }
        return codeMatchCount;
    }

    static class CodeMatchCount {
        private int myMatchingCodeCount;
        private int myOverallCodeCount;
        private boolean myAtLeastOneUnableToValidate;

        CodeMatchCount() {
        }

        public boolean isAtLeastOneUnableToValidate() {
            return this.myAtLeastOneUnableToValidate;
        }

        public void addUnableToValidate() {
            this.myAtLeastOneUnableToValidate = true;
        }

        public void addNonMatchingCode() {
            ++this.myOverallCodeCount;
        }

        public void addMatchingCode() {
            ++this.myMatchingCodeCount;
            ++this.myOverallCodeCount;
        }

        public int getMatchingCodeCount() {
            return this.myMatchingCodeCount;
        }

        public int getOverallCodeCount() {
            return this.myOverallCodeCount;
        }
    }
}

