/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging;

import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.messaging.IResourceMessage;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public abstract class BaseResourceMessage
implements IResourceMessage,
IModelJson {
    @JsonProperty(value="operationType")
    protected OperationTypeEnum myOperationType;
    @JsonProperty(value="attributes")
    private Map<String, String> myAttributes;
    @JsonProperty(value="transactionId")
    private String myTransactionId;
    @JsonProperty(value="mediaType")
    private String myMediaType;
    @JsonProperty(value="messageKey")
    private String myMessageKey;

    public Optional<String> getAttribute(String theKey) {
        Validate.notBlank((CharSequence)theKey);
        if (this.myAttributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.myAttributes.get(theKey));
    }

    public void setAttribute(String theKey, String theValue) {
        Validate.notBlank((CharSequence)theKey);
        Validate.notNull((Object)theValue);
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<String, String>();
        }
        this.myAttributes.put(theKey, theValue);
    }

    public void copyAdditionalPropertiesFrom(BaseResourceMessage theMsg) {
        if (theMsg.myAttributes != null) {
            if (this.myAttributes == null) {
                this.myAttributes = new HashMap<String, String>();
            }
            this.myAttributes.putAll(theMsg.myAttributes);
        }
    }

    public OperationTypeEnum getOperationType() {
        return this.myOperationType;
    }

    public void setOperationType(OperationTypeEnum theOperationType) {
        this.myOperationType = theOperationType;
    }

    @Nullable
    public String getTransactionId() {
        return this.myTransactionId;
    }

    public void setTransactionId(String theTransactionId) {
        this.myTransactionId = theTransactionId;
    }

    public String getMediaType() {
        return this.myMediaType;
    }

    public void setMediaType(String theMediaType) {
        this.myMediaType = theMediaType;
    }

    @Nullable
    public String getMessageKeyOrNull() {
        return this.myMessageKey;
    }

    public void setMessageKey(String theMessageKey) {
        this.myMessageKey = theMessageKey;
    }

    public static enum OperationTypeEnum {
        CREATE(RestOperationTypeEnum.CREATE),
        UPDATE(RestOperationTypeEnum.UPDATE),
        DELETE(RestOperationTypeEnum.DELETE),
        MANUALLY_TRIGGERED(RestOperationTypeEnum.UPDATE),
        TRANSACTION(RestOperationTypeEnum.UPDATE);

        private final RestOperationTypeEnum myRestOperationTypeEnum;

        private OperationTypeEnum(RestOperationTypeEnum theRestOperationTypeEnum) {
            this.myRestOperationTypeEnum = theRestOperationTypeEnum;
        }

        public RestOperationTypeEnum asRestOperationType() {
            return this.myRestOperationTypeEnum;
        }
    }
}

