/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ResourceSearchParams {
    private final String myResourceName;
    private final Map<String, RuntimeSearchParam> myMap;

    public ResourceSearchParams(String theResourceName) {
        this.myResourceName = theResourceName;
        this.myMap = new LinkedHashMap<String, RuntimeSearchParam>();
    }

    private ResourceSearchParams(String theResourceName, Map<String, RuntimeSearchParam> theMap) {
        this.myResourceName = theResourceName;
        this.myMap = theMap;
    }

    public Collection<RuntimeSearchParam> values() {
        return this.myMap.values();
    }

    public static ResourceSearchParams empty(String theResourceName) {
        return new ResourceSearchParams(theResourceName, Collections.emptyMap());
    }

    public ResourceSearchParams readOnly() {
        return new ResourceSearchParams(this.myResourceName, Collections.unmodifiableMap(this.myMap));
    }

    public void remove(String theName) {
        this.myMap.remove(theName);
    }

    public int size() {
        return this.myMap.size();
    }

    public RuntimeSearchParam get(String theParamName) {
        return this.myMap.get(theParamName);
    }

    public RuntimeSearchParam put(String theName, RuntimeSearchParam theSearchParam) {
        return this.myMap.put(theName, theSearchParam);
    }

    public void addSearchParamIfAbsent(String theParamName, RuntimeSearchParam theRuntimeSearchParam) {
        this.myMap.putIfAbsent(theParamName, theRuntimeSearchParam);
    }

    public Set<String> getSearchParamNames() {
        return this.myMap.keySet();
    }

    public boolean containsParamName(String theParamName) {
        return this.myMap.containsKey(theParamName);
    }

    public void removeInactive() {
        this.myMap.entrySet().removeIf(entry -> ((RuntimeSearchParam)entry.getValue()).getStatus() != RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE);
    }

    public Stream<String> getReferenceSearchParamNames() {
        return this.myMap.entrySet().stream().filter(entry -> ((RuntimeSearchParam)entry.getValue()).getParamType() == RestSearchParameterTypeEnum.REFERENCE).map(Map.Entry::getKey);
    }

    public ResourceSearchParams makeCopy() {
        return new ResourceSearchParams(this.myResourceName, new HashMap<String, RuntimeSearchParam>(this.myMap));
    }
}

