/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SimplePreResourceShowDetails
implements IPreResourceShowDetails {
    private static final IBaseResource[] EMPTY_RESOURCE_ARRAY = new IBaseResource[0];
    private final IBaseResource[] myResources;
    private final boolean[] myResourceMarkedAsSubset;

    public SimplePreResourceShowDetails(IBaseResource theResource) {
        this(Lists.newArrayList((Object[])new IBaseResource[]{theResource}));
    }

    public <T extends IBaseResource> SimplePreResourceShowDetails(Collection<T> theResources) {
        this.myResources = theResources.toArray(EMPTY_RESOURCE_ARRAY);
        this.myResourceMarkedAsSubset = new boolean[this.myResources.length];
    }

    @Override
    public int size() {
        return this.myResources.length;
    }

    @Override
    public IBaseResource getResource(int theIndex) {
        return this.myResources[theIndex];
    }

    @Override
    public void setResource(int theIndex, IBaseResource theResource) {
        Validate.isTrue((theIndex >= 0 ? 1 : 0) != 0, (String)"Invalid index %d - theIndex must not be < 0", (long)theIndex);
        Validate.isTrue((theIndex < this.myResources.length ? 1 : 0) != 0, (String)"Invalid index {} - theIndex must be < %d", (Object[])new Object[]{theIndex, this.myResources.length});
        this.myResources[theIndex] = theResource;
    }

    @Override
    public void markResourceAtIndexAsSubset(int theIndex) {
        Validate.isTrue((theIndex >= 0 ? 1 : 0) != 0, (String)"Invalid index %d - theIndex must not be < 0", (long)theIndex);
        Validate.isTrue((theIndex < this.myResources.length ? 1 : 0) != 0, (String)"Invalid index {} - theIndex must be < %d", (Object[])new Object[]{theIndex, this.myResources.length});
        this.myResourceMarkedAsSubset[theIndex] = true;
    }

    @Override
    public List<IBaseResource> getAllResources() {
        ArrayList retVal = new ArrayList(this.myResources.length);
        Arrays.stream(this.myResources).filter(Objects::nonNull).forEach(retVal::add);
        return Collections.unmodifiableList(retVal);
    }

    @Override
    public Iterator<IBaseResource> iterator() {
        return Arrays.asList(this.myResources).iterator();
    }

    public List<IBaseResource> toList() {
        return Lists.newArrayList((Object[])this.myResources);
    }
}

