/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.IncomingRequestAddressStrategy;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ApacheProxyAddressStrategy
extends IncomingRequestAddressStrategy {
    private static final String X_FORWARDED_PREFIX = "x-forwarded-prefix";
    private static final String X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final Logger LOG = LoggerFactory.getLogger(ApacheProxyAddressStrategy.class);
    private final boolean useHttps;

    public ApacheProxyAddressStrategy(boolean useHttps) {
        this.useHttps = useHttps;
    }

    @Override
    public String determineServerBase(ServletContext servletContext, HttpServletRequest request) {
        String serverBase = super.determineServerBase(servletContext, request);
        ServletServerHttpRequest requestWrapper = new ServletServerHttpRequest(request);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpRequest((HttpRequest)requestWrapper);
        uriBuilder.replaceQuery(null);
        HttpHeaders headers = requestWrapper.getHeaders();
        this.adjustSchemeWithDefault(uriBuilder, headers);
        return this.forwardedServerBase(serverBase, headers, uriBuilder);
    }

    private void adjustSchemeWithDefault(UriComponentsBuilder uriBuilder, HttpHeaders headers) {
        if (headers.getFirst(X_FORWARDED_HOST) != null && headers.getFirst(X_FORWARDED_PROTO) == null) {
            uriBuilder.scheme(this.useHttps ? "https" : "http");
        }
    }

    private String forwardedServerBase(String originalServerBase, HttpHeaders headers, UriComponentsBuilder uriBuilder) {
        Optional<String> forwardedPrefix = this.getForwardedPrefix(headers);
        LOG.debug("serverBase: {}, forwardedPrefix: {}", (Object)originalServerBase, forwardedPrefix);
        LOG.debug("request header: {}", (Object)headers);
        String path = forwardedPrefix.orElseGet(() -> this.pathFrom(originalServerBase));
        uriBuilder.replacePath(path);
        return uriBuilder.build().toUriString();
    }

    private String pathFrom(String serverBase) {
        UriComponents build = UriComponentsBuilder.fromHttpUrl((String)serverBase).build();
        return (String)StringUtils.defaultIfBlank((CharSequence)build.getPath(), (CharSequence)"");
    }

    private Optional<String> getForwardedPrefix(HttpHeaders headers) {
        return Optional.ofNullable(headers.getFirst(X_FORWARDED_PREFIX));
    }

    public static ApacheProxyAddressStrategy forHttp() {
        return new ApacheProxyAddressStrategy(false);
    }

    public static ApacheProxyAddressStrategy forHttps() {
        return new ApacheProxyAddressStrategy(true);
    }
}

