/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.IPagingProvider;
import org.apache.commons.lang3.Validate;

public abstract class BasePagingProvider
implements IPagingProvider {
    public static final int DEFAULT_DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_MAX_PAGE_SIZE = 50;
    private int myDefaultPageSize = 10;
    private int myMaximumPageSize = 50;

    @Override
    public int getDefaultPageSize() {
        return this.myDefaultPageSize;
    }

    @Override
    public int getMaximumPageSize() {
        return this.myMaximumPageSize;
    }

    public BasePagingProvider setDefaultPageSize(int theDefaultPageSize) {
        Validate.isTrue((theDefaultPageSize > 0 ? 1 : 0) != 0, (String)"size must be greater than 0", (Object[])new Object[0]);
        this.myDefaultPageSize = theDefaultPageSize;
        return this;
    }

    public BasePagingProvider setMaximumPageSize(int theMaximumPageSize) {
        Validate.isTrue((theMaximumPageSize > 0 ? 1 : 0) != 0, (String)"size must be greater than 0", (Object[])new Object[0]);
        this.myMaximumPageSize = theMaximumPageSize;
        return this;
    }
}

