/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.rest.server.method.ResponsePage;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class BundleProviderWithNamedPages
extends SimpleBundleProvider {
    private String myNextPageId;
    private String myCurrentPageId;
    private String myPreviousPageId;

    public BundleProviderWithNamedPages(List<IBaseResource> theResultsInThisPage, String theSearchId, String thePageId, Integer theTotalResults) {
        super(theResultsInThisPage, theSearchId);
        Validate.notNull(theResultsInThisPage, (String)"theResultsInThisPage must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)thePageId, (String)"thePageId must not be null or blank", (Object[])new Object[0]);
        this.setCurrentPageId(thePageId);
        this.setSize(theTotalResults);
    }

    @Override
    public String getCurrentPageId() {
        return this.myCurrentPageId;
    }

    public BundleProviderWithNamedPages setCurrentPageId(String theCurrentPageId) {
        this.myCurrentPageId = theCurrentPageId;
        return this;
    }

    @Override
    public String getNextPageId() {
        return this.myNextPageId;
    }

    public BundleProviderWithNamedPages setNextPageId(String theNextPageId) {
        this.myNextPageId = theNextPageId;
        return this;
    }

    @Override
    public String getPreviousPageId() {
        return this.myPreviousPageId;
    }

    public BundleProviderWithNamedPages setPreviousPageId(String thePreviousPageId) {
        this.myPreviousPageId = thePreviousPageId;
        return this;
    }

    @Override
    @Nonnull
    public List<IBaseResource> getResources(int theFromIndex, int theToIndex, @Nonnull ResponsePage.ResponsePageBuilder theResponsePageBuilder) {
        return this.getList();
    }

    @Override
    public BundleProviderWithNamedPages setSize(Integer theSize) {
        super.setSize(theSize);
        return this;
    }
}

