/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceBinding.class);
    private String myResourceName;
    private final LinkedList<BaseMethodBinding> myMethodBindings = new LinkedList();

    public BaseMethodBinding getMethod(RequestDetails theRequest) {
        if (this.myMethodBindings.isEmpty()) {
            ourLog.warn("No methods exist for resource: {}", (Object)this.myResourceName);
            return null;
        }
        ourLog.debug("Looking for a handler for {}", (Object)theRequest);
        BaseMethodBinding matchedMethod = null;
        Enum matchedMethodStrength = null;
        for (BaseMethodBinding rm : this.myMethodBindings) {
            MethodMatchEnum nextMethodMatch = rm.incomingServerRequestMatchesMethod(theRequest);
            if (nextMethodMatch == MethodMatchEnum.NONE) continue;
            if (matchedMethodStrength == null || matchedMethodStrength.ordinal() < nextMethodMatch.ordinal()) {
                matchedMethod = rm;
                matchedMethodStrength = nextMethodMatch;
            }
            if (matchedMethodStrength != MethodMatchEnum.EXACT) continue;
            break;
        }
        return matchedMethod;
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    public void setResourceName(String resourceName) {
        this.myResourceName = resourceName;
    }

    public List<BaseMethodBinding> getMethodBindings() {
        return this.myMethodBindings;
    }

    public void addMethod(BaseMethodBinding method) {
        if (this.myMethodBindings.stream().anyMatch(t -> t.getMethod().toString().equals(method.getMethod().toString()))) {
            ourLog.warn("The following method has been registered twice against this RestfulServer: {}", (Object)method.getMethod());
        }
        this.myMethodBindings.push(method);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceBinding)) {
            return false;
        }
        return this.myResourceName.equals(((ResourceBinding)o).getResourceName());
    }

    public int hashCode() {
        return 0;
    }
}

