/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hl7.fhir.instance.model.api.IBaseResource;

public interface IServerInterceptor {
    @Hook(value=Pointcut.SERVER_HANDLE_EXCEPTION)
    public boolean handleException(RequestDetails var1, BaseServerResponseException var2, HttpServletRequest var3, HttpServletResponse var4) throws ServletException, IOException;

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_POST_PROCESSED)
    public boolean incomingRequestPostProcessed(RequestDetails var1, HttpServletRequest var2, HttpServletResponse var3) throws AuthenticationException;

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void incomingRequestPreHandled(RestOperationTypeEnum var1, RequestDetails var2);

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_PROCESSED)
    public boolean incomingRequestPreProcessed(HttpServletRequest var1, HttpServletResponse var2);

    @Deprecated
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1);

    @Deprecated
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1, HttpServletRequest var2, HttpServletResponse var3) throws AuthenticationException;

    @Deprecated
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1, IBaseResource var2);

    @Deprecated
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1, IBaseResource var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1, ResponseDetails var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    @Deprecated
    public boolean outgoingResponse(RequestDetails var1, TagList var2);

    @Deprecated
    public boolean outgoingResponse(RequestDetails var1, TagList var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    @Hook(value=Pointcut.SERVER_PRE_PROCESS_OUTGOING_EXCEPTION)
    public BaseServerResponseException preProcessOutgoingException(RequestDetails var1, Throwable var2, HttpServletRequest var3) throws ServletException;

    @Hook(value=Pointcut.SERVER_PROCESSING_COMPLETED_NORMALLY)
    public void processingCompletedNormally(ServletRequestDetails var1);
}

