/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.BaseResponseTerminologyInterceptor;
import ca.uhn.fhir.rest.server.interceptor.ResponseTerminologyTranslationSvc;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ResponseTerminologyTranslationInterceptor
extends BaseResponseTerminologyInterceptor {
    private final ResponseTerminologyTranslationSvc myResponseTerminologyTranslationSvc;

    public ResponseTerminologyTranslationInterceptor(IValidationSupport theValidationSupport, ResponseTerminologyTranslationSvc theResponseTerminologyTranslationSvc) {
        super(theValidationSupport);
        this.myResponseTerminologyTranslationSvc = theResponseTerminologyTranslationSvc;
    }

    public void addMappingSpecification(String theSourceCodeSystemUrl, String theTargetCodeSystemUrl) {
        this.myResponseTerminologyTranslationSvc.addMappingSpecification(theSourceCodeSystemUrl, theTargetCodeSystemUrl);
    }

    public void clearMappingSpecifications() {
        this.myResponseTerminologyTranslationSvc.clearMappingSpecifications();
    }

    public Map<String, String> getMappingSpecifications() {
        return this.myResponseTerminologyTranslationSvc.getMappingSpecifications();
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE, order=100)
    public void handleResource(RequestDetails theRequestDetails, IBaseResource theResource) {
        List<IBaseResource> resources = this.toListForProcessing(theRequestDetails, theResource);
        this.myResponseTerminologyTranslationSvc.processResourcesForTerminologyTranslation(resources);
    }
}

