/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerboseLoggingInterceptor
extends InterceptorAdapter {
    private static final Logger ourLog = LoggerFactory.getLogger(VerboseLoggingInterceptor.class);

    @Override
    public boolean incomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        StringBuilder b = new StringBuilder("Incoming request: ");
        b.append(theRequest.getMethod());
        b.append(" ");
        b.append(theRequest.getRequestURL());
        b.append("\n");
        Enumeration headerEnumeration = theRequest.getHeaderNames();
        while (headerEnumeration.hasMoreElements()) {
            String nextName = (String)headerEnumeration.nextElement();
            Enumeration valueEnumeration = theRequest.getHeaders(nextName);
            while (valueEnumeration.hasMoreElements()) {
                b.append(" * ").append(nextName).append(": ").append((String)valueEnumeration.nextElement()).append("\n");
            }
        }
        ourLog.info(b.toString());
        return true;
    }
}

