/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IAuthRuleTester {
    default public boolean matches(RuleTestRequest theRequest) {
        return this.matches(theRequest.operation, theRequest.requestDetails, theRequest.resourceId, theRequest.resource);
    }

    @Deprecated(since="6.1.0")
    default public boolean matches(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IIdType theInputResourceId, IBaseResource theInputResource) {
        return true;
    }

    default public boolean matchesOutput(RuleTestRequest theRequest) {
        return this.matchesOutput(theRequest.operation, theRequest.requestDetails, theRequest.resource);
    }

    @Deprecated(since="6.1.0")
    default public boolean matchesOutput(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theOutputResource) {
        return true;
    }

    public static class RuleTestRequest {
        @Nonnull
        public final PolicyEnum mode;
        @Nonnull
        public final RestOperationTypeEnum operation;
        @Nonnull
        public final RequestDetails requestDetails;
        @Nullable
        public final IIdType resourceId;
        @Nullable
        public final IBaseResource resource;
        @Nonnull
        public final IRuleApplier ruleApplier;

        public RuleTestRequest(PolicyEnum theMode, @Nonnull RestOperationTypeEnum theOperation, @Nonnull RequestDetails theRequestDetails, @Nullable IIdType theResourceId, @Nullable IBaseResource theResource, @Nonnull IRuleApplier theRuleApplier) {
            Validate.notNull((Object)((Object)theMode));
            Validate.notNull((Object)theOperation);
            Validate.notNull((Object)theRequestDetails);
            Validate.notNull((Object)theRuleApplier);
            this.mode = theMode;
            this.operation = theOperation;
            this.requestDetails = theRequestDetails;
            this.resource = theResource;
            this.resourceId = theResourceId == null && this.resource != null ? this.resource.getIdElement() : theResourceId;
            this.ruleApplier = theRuleApplier;
        }
    }
}

