/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class GraphQLQueryBodyParameter
implements IParameter {
    private Class<?> myType;

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding theMethodBinding) throws InternalErrorException, InvalidRequestException {
        String ctValue = StringUtils.defaultString((String)theRequest.getHeader("Content-Type"));
        Reader requestReader = ResourceParameter.createRequestReader(theRequest);
        int semicolonIdx = ctValue.indexOf(59);
        if (semicolonIdx != -1) {
            ctValue = ctValue.substring(0, semicolonIdx);
        }
        if ("application/json".equals(ctValue = StringUtils.trim((String)ctValue))) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonNode = mapper.readTree(requestReader);
                if (jsonNode != null && jsonNode.get("query") != null) {
                    return jsonNode.get("query").asText();
                }
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)356) + e);
            }
        }
        if ("application/graphql".equals(ctValue)) {
            try {
                return IOUtils.toString((Reader)requestReader);
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)357) + e);
            }
        }
        return null;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException(Msg.code((int)358) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Count.class.getName() + " but can not be of collection type");
        }
        if (!String.class.equals(theParameterType)) {
            throw new ConfigurationException(Msg.code((int)359) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Count.class.getName() + " but type '" + theParameterType + "' is an invalid type, must be one of Integer or IntegerType");
        }
        this.myType = theParameterType;
    }
}

