/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.method.RequestedPage;
import ca.uhn.fhir.rest.server.method.ResponseBundleRequest;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponsePage {
    private static final Logger ourLog = LoggerFactory.getLogger(ResponsePage.class);
    private final String mySearchId;
    private final List<IBaseResource> myResourceList;
    private final Integer myNumTotalResults;
    private final int myPageSize;
    private final int myNumToReturn;
    private final int myIncludedResourceCount;
    private final int myOmittedResourceCount;
    private final int myTotalRequestedResourcesFetched;
    private final IBundleProvider myBundleProvider;
    private ResponseBundleRequest myResponseBundleRequest;
    private boolean myIsUsingOffsetPages = false;
    private RequestedPage myRequestedPage;
    private PagingStyle myPagingStyle;

    ResponsePage(String theSearchId, List<IBaseResource> theResourceList, int thePageSize, int theNumToReturn, int theIncludedResourceCount, int theOmittedResourceCount, int theTotalRequestedResourcesFetched, IBundleProvider theBundleProvider) {
        this.mySearchId = theSearchId;
        this.myResourceList = theResourceList;
        this.myPageSize = thePageSize;
        this.myNumToReturn = theNumToReturn;
        this.myIncludedResourceCount = theIncludedResourceCount;
        this.myOmittedResourceCount = theOmittedResourceCount;
        this.myTotalRequestedResourcesFetched = theTotalRequestedResourcesFetched;
        this.myBundleProvider = theBundleProvider;
        this.myNumTotalResults = this.myBundleProvider.size();
    }

    public int size() {
        return this.myResourceList.size();
    }

    public List<IBaseResource> getResourceList() {
        return this.myResourceList;
    }

    private boolean isBundleProviderOffsetPaging() {
        if (this.myBundleProvider != null && this.myBundleProvider.getCurrentPageOffset() != null) {
            return StringUtils.isNotBlank((CharSequence)this.myBundleProvider.getNextPageId()) || StringUtils.isNotBlank((CharSequence)this.myBundleProvider.getPreviousPageId());
        }
        return false;
    }

    private void determinePagingStyle() {
        if (this.myPagingStyle != null) {
            return;
        }
        if (this.isBundleProviderOffsetPaging()) {
            this.myPagingStyle = PagingStyle.BUNDLE_PROVIDER_OFFSETS;
        } else if (this.myIsUsingOffsetPages) {
            this.myPagingStyle = PagingStyle.NONCACHED_OFFSET;
        } else if (this.myBundleProvider != null && StringUtils.isNotBlank((CharSequence)this.myBundleProvider.getCurrentPageId())) {
            this.myPagingStyle = PagingStyle.BUNDLE_PROVIDER_PAGE_IDS;
        } else if (StringUtils.isNotBlank((CharSequence)this.mySearchId)) {
            this.myPagingStyle = PagingStyle.SAVED_SEARCH;
        } else {
            this.myPagingStyle = PagingStyle.NONE;
            ourLog.debug("No accurate paging will be generated. If accurate paging is desired, ResponsePageBuilder must be provided with additioanl information.");
        }
    }

    public void setRequestedPage(RequestedPage theRequestedPage) {
        this.myRequestedPage = theRequestedPage;
    }

    public IBundleProvider getBundleProvider() {
        return this.myBundleProvider;
    }

    public void setUseOffsetPaging(boolean theIsUsingOffsetPaging) {
        this.myIsUsingOffsetPages = theIsUsingOffsetPaging;
    }

    public void setResponseBundleRequest(ResponseBundleRequest theRequest) {
        this.myResponseBundleRequest = theRequest;
    }

    private boolean hasNextPage() {
        this.determinePagingStyle();
        switch (this.myPagingStyle) {
            case BUNDLE_PROVIDER_OFFSETS: 
            case BUNDLE_PROVIDER_PAGE_IDS: {
                return StringUtils.isNotBlank((CharSequence)this.myBundleProvider.getNextPageId());
            }
            case NONCACHED_OFFSET: {
                if (!(this.myNumTotalResults == null ? this.hasNextPageWithoutKnowingTotal() : this.myNumTotalResults > this.myNumToReturn + (Integer)ObjectUtils.defaultIfNull((Object)this.myRequestedPage.offset, (Object)0))) break;
                return true;
            }
            case SAVED_SEARCH: {
                if (!(this.myNumTotalResults == null ? this.hasNextPageWithoutKnowingTotal() : this.myResponseBundleRequest.offset + this.myNumToReturn < this.myNumTotalResults)) break;
                return true;
            }
        }
        return false;
    }

    private boolean hasNextPageWithoutKnowingTotal() {
        if (this.myTotalRequestedResourcesFetched >= 0) {
            if (this.myPageSize < this.myTotalRequestedResourcesFetched) {
                return true;
            }
        } else if (this.myPageSize == this.myResourceList.size() - this.myIncludedResourceCount + this.myOmittedResourceCount) {
            ourLog.warn("Returning a next page based on calculated resource count. This could be inaccurate if the exact number of resources were fetched is equal to the pagesize requested.  Consider setting ResponseBundleBuilder.setTotalResourcesFetchedRequest after fetching resources.");
            return true;
        }
        return false;
    }

    public void setNextPageIfNecessary(BundleLinks theLinks) {
        if (this.hasNextPage()) {
            String next;
            switch (this.myPagingStyle) {
                case BUNDLE_PROVIDER_OFFSETS: {
                    next = RestfulServerUtils.createOffsetPagingLink(theLinks, this.myResponseBundleRequest.requestDetails.getRequestPath(), this.myResponseBundleRequest.requestDetails.getTenantId(), this.myRequestedPage.offset + this.myRequestedPage.limit, this.myRequestedPage.limit, this.myResponseBundleRequest.getRequestParameters());
                    break;
                }
                case NONCACHED_OFFSET: {
                    next = RestfulServerUtils.createOffsetPagingLink(theLinks, this.myResponseBundleRequest.requestDetails.getRequestPath(), this.myResponseBundleRequest.requestDetails.getTenantId(), (Integer)ObjectUtils.defaultIfNull((Object)this.myRequestedPage.offset, (Object)0) + this.myNumToReturn, this.myNumToReturn, this.myResponseBundleRequest.getRequestParameters());
                    break;
                }
                case BUNDLE_PROVIDER_PAGE_IDS: {
                    next = RestfulServerUtils.createPagingLink(theLinks, this.myResponseBundleRequest.requestDetails, this.myBundleProvider.getUuid(), this.myBundleProvider.getNextPageId(), this.myResponseBundleRequest.getRequestParameters());
                    break;
                }
                case SAVED_SEARCH: {
                    next = RestfulServerUtils.createPagingLink(theLinks, this.myResponseBundleRequest.requestDetails, this.mySearchId, this.myResponseBundleRequest.offset + this.myNumToReturn, this.myNumToReturn, this.myResponseBundleRequest.getRequestParameters());
                    break;
                }
                default: {
                    next = null;
                }
            }
            if (StringUtils.isNotBlank(next)) {
                theLinks.setNext(next);
            }
        }
    }

    private boolean hasPreviousPage() {
        this.determinePagingStyle();
        switch (this.myPagingStyle) {
            case BUNDLE_PROVIDER_OFFSETS: 
            case BUNDLE_PROVIDER_PAGE_IDS: {
                return StringUtils.isNotBlank((CharSequence)this.myBundleProvider.getPreviousPageId());
            }
            case NONCACHED_OFFSET: {
                if (this.myRequestedPage == null || this.myRequestedPage.offset == null || this.myRequestedPage.offset <= 0) break;
                return true;
            }
            case SAVED_SEARCH: {
                return this.myResponseBundleRequest.offset > 0;
            }
        }
        return false;
    }

    public void setPreviousPageIfNecessary(BundleLinks theLinks) {
        if (this.hasPreviousPage()) {
            String prev;
            switch (this.myPagingStyle) {
                case BUNDLE_PROVIDER_OFFSETS: {
                    prev = RestfulServerUtils.createOffsetPagingLink(theLinks, this.myResponseBundleRequest.requestDetails.getRequestPath(), this.myResponseBundleRequest.requestDetails.getTenantId(), Math.max((Integer)ObjectUtils.defaultIfNull((Object)this.myRequestedPage.offset, (Object)0) - this.myRequestedPage.limit, 0), this.myRequestedPage.limit, this.myResponseBundleRequest.getRequestParameters());
                    break;
                }
                case NONCACHED_OFFSET: {
                    int start = Math.max(0, (Integer)ObjectUtils.defaultIfNull((Object)this.myRequestedPage.offset, (Object)0) - this.myPageSize);
                    prev = RestfulServerUtils.createOffsetPagingLink(theLinks, this.myResponseBundleRequest.requestDetails.getRequestPath(), this.myResponseBundleRequest.requestDetails.getTenantId(), start, this.myPageSize, this.myResponseBundleRequest.getRequestParameters());
                    break;
                }
                case BUNDLE_PROVIDER_PAGE_IDS: {
                    prev = RestfulServerUtils.createPagingLink(theLinks, this.myResponseBundleRequest.requestDetails, this.myBundleProvider.getUuid(), this.myBundleProvider.getPreviousPageId(), this.myResponseBundleRequest.getRequestParameters());
                    break;
                }
                case SAVED_SEARCH: {
                    int start = Math.max(0, this.myResponseBundleRequest.offset - this.myPageSize);
                    prev = RestfulServerUtils.createPagingLink(theLinks, this.myResponseBundleRequest.requestDetails, this.mySearchId, start, this.myPageSize, this.myResponseBundleRequest.getRequestParameters());
                    break;
                }
                default: {
                    prev = null;
                }
            }
            if (StringUtils.isNotBlank(prev)) {
                theLinks.setPrev(prev);
            }
        }
    }

    private static enum PagingStyle {
        NONCACHED_OFFSET,
        BUNDLE_PROVIDER_OFFSETS,
        BUNDLE_PROVIDER_PAGE_IDS,
        SAVED_SEARCH,
        NONE;

    }

    public static class ResponsePageBuilder {
        private String mySearchId;
        private List<IBaseResource> myResources;
        private int myPageSize;
        private int myNumToReturn;
        private int myIncludedResourceCount;
        private int myOmittedResourceCount;
        private IBundleProvider myBundleProvider;
        private int myTotalRequestedResourcesFetched = -1;

        public ResponsePageBuilder setOmittedResourceCount(int theOmittedResourceCount) {
            this.myOmittedResourceCount = theOmittedResourceCount;
            return this;
        }

        public ResponsePageBuilder setIncludedResourceCount(int theIncludedResourceCount) {
            this.myIncludedResourceCount = theIncludedResourceCount;
            return this;
        }

        public ResponsePageBuilder setNumToReturn(int theNumToReturn) {
            this.myNumToReturn = theNumToReturn;
            return this;
        }

        public ResponsePageBuilder setPageSize(int thePageSize) {
            this.myPageSize = thePageSize;
            return this;
        }

        public ResponsePageBuilder setBundleProvider(IBundleProvider theBundleProvider) {
            this.myBundleProvider = theBundleProvider;
            return this;
        }

        public ResponsePageBuilder setResources(List<IBaseResource> theResources) {
            this.myResources = theResources;
            return this;
        }

        public ResponsePageBuilder setSearchId(String theSearchId) {
            this.mySearchId = theSearchId;
            return this;
        }

        public ResponsePageBuilder setTotalRequestedResourcesFetched(int theTotalRequestedResourcesFetched) {
            this.myTotalRequestedResourcesFetched = theTotalRequestedResourcesFetched;
            return this;
        }

        public void combineWith(ResponsePageBuilder theSecondBuilder) {
            assert (theSecondBuilder != this);
            if (this.myTotalRequestedResourcesFetched != -1 && theSecondBuilder.myTotalRequestedResourcesFetched != -1) {
                this.myTotalRequestedResourcesFetched += theSecondBuilder.myTotalRequestedResourcesFetched;
            }
            this.myIncludedResourceCount += theSecondBuilder.myIncludedResourceCount;
            this.myOmittedResourceCount += theSecondBuilder.myOmittedResourceCount;
        }

        public ResponsePage build() {
            return new ResponsePage(this.mySearchId, this.myResources, this.myPageSize, this.myNumToReturn, this.myIncludedResourceCount, this.myOmittedResourceCount, this.myTotalRequestedResourcesFetched, this.myBundleProvider);
        }
    }
}

