/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.QualifierDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseQueryParameter;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchMethodBinding
extends BaseResourceReturningMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchMethodBinding.class);
    private static final Set<String> SPECIAL_SEARCH_PARAMS;
    private final String myResourceProviderResourceName;
    private final List<String> myRequiredParamNames;
    private final List<String> myOptionalParamNames;
    private final String myCompartmentName;
    private String myDescription;
    private final Integer myIdParamIndex;
    private final String myQueryName;
    private final boolean myAllowUnknownParams;

    public SearchMethodBinding(Class<? extends IBaseResource> theReturnResourceType, Class<? extends IBaseResource> theResourceProviderResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        Search search = theMethod.getAnnotation(Search.class);
        this.myQueryName = (String)StringUtils.defaultIfBlank((CharSequence)search.queryName(), null);
        this.myCompartmentName = (String)StringUtils.defaultIfBlank((CharSequence)search.compartmentName(), null);
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        this.myAllowUnknownParams = search.allowUnknownParams();
        this.myDescription = ParametersUtil.extractDescription((AnnotatedElement)theMethod);
        if (StringUtils.isBlank((CharSequence)this.myCompartmentName) && this.myIdParamIndex != null) {
            String msg = theContext.getLocalizer().getMessage(this.getClass().getName() + ".idWithoutCompartment", new Object[]{theMethod.getName(), theMethod.getDeclaringClass()});
            throw new ConfigurationException(Msg.code((int)412) + msg);
        }
        this.myResourceProviderResourceName = theResourceProviderResourceType != null ? theContext.getResourceType(theResourceProviderResourceType) : null;
        this.myRequiredParamNames = this.getQueryParameters().stream().filter(t -> t.isRequired()).map(t -> t.getName()).collect(Collectors.toList());
        this.myOptionalParamNames = this.getQueryParameters().stream().filter(t -> !t.isRequired()).map(t -> t.getName()).collect(Collectors.toList());
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getQueryName() {
        return this.myQueryName;
    }

    public String getResourceProviderResourceName() {
        return this.myResourceProviderResourceName;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.SEARCH_TYPE;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.SEARCHSET;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        block21: {
            String[] queryNameValues;
            if (!SearchMethodBinding.mightBeSearchRequest(theRequest)) {
                return MethodMatchEnum.NONE;
            }
            if (theRequest.getId() != null && this.myIdParamIndex == null) {
                ourLog.trace("Method {} doesn't match because ID is not null: {}", (Object)this.getMethod(), (Object)theRequest.getId());
                return MethodMatchEnum.NONE;
            }
            if (!StringUtils.equals((CharSequence)this.myCompartmentName, (CharSequence)theRequest.getCompartmentName())) {
                ourLog.trace("Method {} doesn't match because it is for compartment {} but request is compartment {}", new Object[]{this.getMethod(), this.myCompartmentName, theRequest.getCompartmentName()});
                return MethodMatchEnum.NONE;
            }
            if (this.myQueryName != null) {
                queryNameValues = theRequest.getParameters().get("_query");
                if (queryNameValues != null && StringUtils.isNotBlank((CharSequence)queryNameValues[0])) {
                    String queryName = queryNameValues[0];
                    if (!this.myQueryName.equals(queryName)) {
                        ourLog.trace("Query name does not match {}", (Object)this.myQueryName);
                        return MethodMatchEnum.NONE;
                    }
                    break block21;
                } else {
                    ourLog.trace("Query name does not match {}", (Object)this.myQueryName);
                    return MethodMatchEnum.NONE;
                }
            }
            queryNameValues = theRequest.getParameters().get("_query");
            if (queryNameValues != null && StringUtils.isNotBlank((CharSequence)queryNameValues[0])) {
                ourLog.trace("Query has name");
                return MethodMatchEnum.NONE;
            }
        }
        Set<String> unqualifiedNames = theRequest.getUnqualifiedToQualifiedNames().keySet();
        Set<String> qualifiedParamNames = theRequest.getParameters().keySet();
        MethodMatchEnum retVal = MethodMatchEnum.EXACT;
        for (String nextRequestParam : theRequest.getParameters().keySet()) {
            String nextUnqualifiedRequestParam = ParameterUtil.stripModifierPart((String)nextRequestParam);
            if (nextRequestParam.startsWith("_") && !SPECIAL_SEARCH_PARAMS.contains(nextUnqualifiedRequestParam)) continue;
            boolean parameterMatches = false;
            boolean approx = false;
            for (BaseQueryParameter nextMethodParam : this.getQueryParameters()) {
                List<String> qualifiedNames;
                if (nextRequestParam.equals(nextMethodParam.getName())) {
                    QualifierDetails qualifiers = QualifierDetails.extractQualifiersFromParameterName((String)nextRequestParam);
                    if (qualifiers.passes(nextMethodParam.getQualifierWhitelist(), nextMethodParam.getQualifierBlacklist())) {
                        parameterMatches = true;
                    }
                } else if (nextUnqualifiedRequestParam.equals(nextMethodParam.getName()) && this.passesWhitelistAndBlacklist(qualifiedNames = theRequest.getUnqualifiedToQualifiedNames().get(nextUnqualifiedRequestParam), nextMethodParam.getQualifierWhitelist(), nextMethodParam.getQualifierBlacklist())) {
                    parameterMatches = true;
                }
                if (theRequest.getParameters().get(nextRequestParam).length > 1 == nextMethodParam.supportsRepetition()) continue;
                approx = true;
            }
            if (parameterMatches) {
                if (approx) {
                    retVal = retVal.weakerOf(MethodMatchEnum.APPROXIMATE);
                }
            } else {
                retVal = this.myAllowUnknownParams ? retVal.weakerOf(MethodMatchEnum.APPROXIMATE) : retVal.weakerOf(MethodMatchEnum.NONE);
            }
            if (retVal != MethodMatchEnum.NONE) continue;
        }
        if (retVal != MethodMatchEnum.NONE) {
            for (String nextRequiredParamName : this.myRequiredParamNames) {
                if (qualifiedParamNames.contains(nextRequiredParamName) || unqualifiedNames.contains(nextRequiredParamName)) continue;
                retVal = MethodMatchEnum.NONE;
                break;
            }
        }
        if (retVal != MethodMatchEnum.NONE) {
            for (String nextRequiredParamName : this.myOptionalParamNames) {
                if (qualifiedParamNames.contains(nextRequiredParamName) || unqualifiedNames.contains(nextRequiredParamName)) continue;
                retVal = retVal.weakerOf(MethodMatchEnum.APPROXIMATE);
            }
        }
        return retVal;
    }

    public static boolean isPlainSearchRequest(RequestDetails theRequest) {
        if (theRequest.getId() != null) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)theRequest.getCompartmentName())) {
            return false;
        }
        return SearchMethodBinding.mightBeSearchRequest(theRequest);
    }

    private static boolean mightBeSearchRequest(RequestDetails theRequest) {
        if (theRequest.getRequestType() == RequestTypeEnum.GET && theRequest.getOperation() != null && !"_search".equals(theRequest.getOperation())) {
            return false;
        }
        if (theRequest.getRequestType() == RequestTypeEnum.POST && !"_search".equals(theRequest.getOperation())) {
            return false;
        }
        if (theRequest.getRequestType() != RequestTypeEnum.GET && theRequest.getRequestType() != RequestTypeEnum.POST) {
            return false;
        }
        return theRequest.getParameters().get("_getpages") == null;
    }

    @Override
    public IBundleProvider invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theRequest, theMethodParams);
        return this.toResourceList(response);
    }

    @Override
    protected boolean isAddContentLocationHeader() {
        return false;
    }

    private boolean passesWhitelistAndBlacklist(List<String> theQualifiedNames, Set<String> theQualifierWhitelist, Set<String> theQualifierBlacklist) {
        if (theQualifierWhitelist == null && theQualifierBlacklist == null) {
            return true;
        }
        for (String next : theQualifiedNames) {
            QualifierDetails qualifiers = QualifierDetails.extractQualifiersFromParameterName((String)next);
            if (qualifiers.passes(theQualifierWhitelist, theQualifierBlacklist)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getMethod().toString();
    }

    static {
        HashSet<String> specialSearchParams = new HashSet<String>();
        specialSearchParams.add("_id");
        specialSearchParams.add("_include");
        specialSearchParams.add("_revinclude");
        SPECIAL_SEARCH_PARAMS = Collections.unmodifiableSet(specialSearchParams);
    }
}

