/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.rest.server.provider.IObservableSupplierSetObserver;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableSupplierSet<T extends IObservableSupplierSetObserver> {
    private static final Logger ourLog = LoggerFactory.getLogger(ObservableSupplierSet.class);
    private final Set<T> myObservers = Collections.synchronizedSet(new HashSet());
    private final Set<Supplier<Object>> mySuppliers = new LinkedHashSet<Supplier<Object>>();

    public void addSupplier(@Nonnull Supplier<Object> theSupplier) {
        if (this.mySuppliers.add(theSupplier)) {
            this.myObservers.forEach(observer -> observer.update(theSupplier));
        }
    }

    public void removeSupplier(@Nonnull Supplier<Object> theSupplier) {
        if (this.mySuppliers.remove(theSupplier)) {
            this.myObservers.forEach(observer -> observer.remove(theSupplier));
        } else {
            ourLog.warn("Failed to remove supplier", (Throwable)new RuntimeException());
        }
    }

    public void attach(T theObserver) {
        this.myObservers.add(theObserver);
    }

    public void detach(T theObserver) {
        this.myObservers.remove(theObserver);
    }

    protected List<Object> getSupplierResults() {
        ArrayList<Object> retVal = new ArrayList<Object>();
        for (Supplier<Object> next : this.mySuppliers) {
            Object nextRp = next.get();
            if (nextRp == null) continue;
            retVal.add(nextRp);
        }
        return retVal;
    }
}

