/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBinary;

@ResourceDef(name="Binary", profile="http://hl7.org/fhir/profiles/Binary", id="binary")
public class Binary
extends BaseResource
implements IResource,
IBaseBinary {
    @SearchParamDefinition(name="contenttype", path="Binary.contentType", description="", type="token")
    public static final String SP_CONTENTTYPE = "contenttype";
    public static final TokenClientParam CONTENTTYPE = new TokenClientParam("contenttype");
    @Child(name="contentType", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="MimeType of the binary content represented as a standard MimeType (BCP 13)")
    private CodeDt myContentType;
    @Child(name="content", type={Base64BinaryDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The actual content, base64 encoded")
    private Base64BinaryDt myContent;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContentType, this.myContent});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContentType, this.myContent});
    }

    public CodeDt getContentTypeElement() {
        if (this.myContentType == null) {
            this.myContentType = new CodeDt();
        }
        return this.myContentType;
    }

    public String getContentType() {
        return (String)this.getContentTypeElement().getValue();
    }

    public Binary setContentType(CodeDt theValue) {
        this.myContentType = theValue;
        return this;
    }

    public Binary setContentType(String theCode) {
        this.myContentType = new CodeDt(theCode);
        return this;
    }

    public Base64BinaryDt getContentElement() {
        if (this.myContent == null) {
            this.myContent = new Base64BinaryDt();
        }
        return this.myContent;
    }

    public byte[] getContent() {
        return (byte[])this.getContentElement().getValue();
    }

    public Binary setContent(Base64BinaryDt theValue) {
        this.myContent = theValue;
        return this;
    }

    public Binary setContent(byte[] theBytes) {
        this.myContent = new Base64BinaryDt(theBytes);
        return this;
    }

    public String getResourceName() {
        return "Binary";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    public String getContentAsBase64() {
        return this.getContentElement().getValueAsString();
    }

    public Binary setContentAsBase64(String theContent) {
        this.getContentElement().setValueAsString(theContent);
        return this;
    }

    public boolean hasData() {
        return this.getContent() != null;
    }
}

