/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.NarrativeDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.CompositionAttestationModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.CompositionStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Composition", profile="http://hl7.org/fhir/profiles/Composition", id="composition")
public class Composition
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Composition.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="class", path="Composition.class", description="", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="date", path="Composition.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subject", path="Composition.subject", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="author", path="Composition.author", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner"), @Compartment(name="Device")})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    @SearchParamDefinition(name="attester", path="Composition.attester.party", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner")})
    public static final String SP_ATTESTER = "attester";
    public static final ReferenceClientParam ATTESTER = new ReferenceClientParam("attester");
    @SearchParamDefinition(name="context", path="Composition.event.code", description="", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="section", path="Composition.section.code", description="", type="token")
    public static final String SP_SECTION = "section";
    public static final TokenClientParam SECTION = new TokenClientParam("section");
    @SearchParamDefinition(name="entry", path="Composition.section.entry", description="", type="reference")
    public static final String SP_ENTRY = "entry";
    public static final ReferenceClientParam ENTRY = new ReferenceClientParam("entry");
    @SearchParamDefinition(name="identifier", path="Composition.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="title", path="Composition.title", description="", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="status", path="Composition.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="confidentiality", path="Composition.confidentiality", description="", type="token")
    public static final String SP_CONFIDENTIALITY = "confidentiality";
    public static final TokenClientParam CONFIDENTIALITY = new TokenClientParam("confidentiality");
    @SearchParamDefinition(name="period", path="Composition.event.period", description="", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="patient", path="Composition.subject", description="", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="encounter", path="Composition.encounter", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ATTESTER = new Include("Composition:attester");
    public static final Include INCLUDE_AUTHOR = new Include("Composition:author");
    public static final Include INCLUDE_ENCOUNTER = new Include("Composition:encounter");
    public static final Include INCLUDE_ENTRY = new Include("Composition:entry");
    public static final Include INCLUDE_PATIENT = new Include("Composition:patient");
    public static final Include INCLUDE_SUBJECT = new Include("Composition:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Logical identifier for the composition, assigned when created. This identifier stays constant as the composition is changed over time")
    private IdentifierDt myIdentifier;
    @Child(name="date", type={DateTimeDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The composition editing time, when the composition was last logically changed by the author")
    private DateTimeDt myDate;
    @Child(name="type", type={CodeableConceptDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-doc-typecodes")
    private CodeableConceptDt myType;
    @Child(name="class", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type")
    private CodeableConceptDt myClassElement;
    @Child(name="title", type={StringDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Official human-readable label for the composition")
    private StringDt myTitle;
    @Child(name="status", type={CodeDt.class}, order=5, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-status")
    private BoundCodeDt<CompositionStatusEnum> myStatus;
    @Child(name="confidentiality", type={CodeDt.class}, order=6, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="The code specifying the level of confidentiality of the Composition")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-Confidentiality")
    private CodeDt myConfidentiality;
    @Child(name="subject", order=7, min=1, max=1, summary=true, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure)")
    private ResourceReferenceDt mySubject;
    @Child(name="author", order=8, min=1, max=-1, summary=true, modifier=false, type={Practitioner.class, Device.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="", formalDefinition="Identifies who is responsible for the information in the composition, not necessarily who typed it in.")
    private List<ResourceReferenceDt> myAuthor;
    @Child(name="attester", order=9, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A participant who has attested to the accuracy of the composition/document")
    private List<Attester> myAttester;
    @Child(name="custodian", order=10, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information")
    private ResourceReferenceDt myCustodian;
    @Child(name="event", order=11, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The clinical service, such as a colonoscopy or an appendectomy, being documented")
    private List<Event> myEvent;
    @Child(name="encounter", order=12, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="", formalDefinition="Describes the clinical encounter or type of care this documentation is associated with.")
    private ResourceReferenceDt myEncounter;
    @Child(name="section", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The root of the sections that make up the composition")
    private List<Section> mySection;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDate, this.myType, this.myClassElement, this.myTitle, this.myStatus, this.myConfidentiality, this.mySubject, this.myAuthor, this.myAttester, this.myCustodian, this.myEvent, this.myEncounter, this.mySection});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDate, this.myType, this.myClassElement, this.myTitle, this.myStatus, this.myConfidentiality, this.mySubject, this.myAuthor, this.myAttester, this.myCustodian, this.myEvent, this.myEncounter, this.mySection});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Composition setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public Composition setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Composition setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public Composition setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Composition setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public CodeableConceptDt getClassElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new CodeableConceptDt();
        }
        return this.myClassElement;
    }

    public Composition setClassElement(CodeableConceptDt theValue) {
        this.myClassElement = theValue;
        return this;
    }

    public StringDt getTitleElement() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    public String getTitle() {
        return (String)this.getTitleElement().getValue();
    }

    public Composition setTitle(StringDt theValue) {
        this.myTitle = theValue;
        return this;
    }

    public Composition setTitle(String theString) {
        this.myTitle = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<CompositionStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(CompositionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Composition setStatus(BoundCodeDt<CompositionStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Composition setStatus(CompositionStatusEnum theValue) {
        this.setStatus((BoundCodeDt<CompositionStatusEnum>)new BoundCodeDt(CompositionStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeDt getConfidentialityElement() {
        if (this.myConfidentiality == null) {
            this.myConfidentiality = new CodeDt();
        }
        return this.myConfidentiality;
    }

    public String getConfidentiality() {
        return (String)this.getConfidentialityElement().getValue();
    }

    public Composition setConfidentiality(CodeDt theValue) {
        this.myConfidentiality = theValue;
        return this;
    }

    public Composition setConfidentiality(String theCode) {
        this.myConfidentiality = new CodeDt(theCode);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Composition setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public Composition setAuthor(List<ResourceReferenceDt> theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthor() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthor().add(newType);
        return newType;
    }

    public List<Attester> getAttester() {
        if (this.myAttester == null) {
            this.myAttester = new ArrayList<Attester>();
        }
        return this.myAttester;
    }

    public Composition setAttester(List<Attester> theValue) {
        this.myAttester = theValue;
        return this;
    }

    public Attester addAttester() {
        Attester newType = new Attester();
        this.getAttester().add(newType);
        return newType;
    }

    public Composition addAttester(Attester theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAttester().add(theValue);
        return this;
    }

    public Attester getAttesterFirstRep() {
        if (this.getAttester().isEmpty()) {
            return this.addAttester();
        }
        return this.getAttester().get(0);
    }

    public ResourceReferenceDt getCustodian() {
        if (this.myCustodian == null) {
            this.myCustodian = new ResourceReferenceDt();
        }
        return this.myCustodian;
    }

    public Composition setCustodian(ResourceReferenceDt theValue) {
        this.myCustodian = theValue;
        return this;
    }

    public List<Event> getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<Event>();
        }
        return this.myEvent;
    }

    public Composition setEvent(List<Event> theValue) {
        this.myEvent = theValue;
        return this;
    }

    public Event addEvent() {
        Event newType = new Event();
        this.getEvent().add(newType);
        return newType;
    }

    public Composition addEvent(Event theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getEvent().add(theValue);
        return this;
    }

    public Event getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            return this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Composition setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public List<Section> getSection() {
        if (this.mySection == null) {
            this.mySection = new ArrayList<Section>();
        }
        return this.mySection;
    }

    public Composition setSection(List<Section> theValue) {
        this.mySection = theValue;
        return this;
    }

    public Section addSection() {
        Section newType = new Section();
        this.getSection().add(newType);
        return newType;
    }

    public Composition addSection(Section theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getSection().add(theValue);
        return this;
    }

    public Section getSectionFirstRep() {
        if (this.getSection().isEmpty()) {
            return this.addSection();
        }
        return this.getSection().get(0);
    }

    public String getResourceName() {
        return "Composition";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Attester
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="mode", type={CodeDt.class}, order=0, min=1, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of attestation the authenticator offers")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-attestation-mode")
        private List<BoundCodeDt<CompositionAttestationModeEnum>> myMode;
        @Child(name="time", type={DateTimeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="When composition was attested by the party")
        private DateTimeDt myTime;
        @Child(name="party", order=2, min=0, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, Organization.class})
        @Description(shortDefinition="", formalDefinition="Who attested the composition in the specified way")
        private ResourceReferenceDt myParty;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMode, this.myTime, this.myParty});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMode, this.myTime, this.myParty});
        }

        public List<BoundCodeDt<CompositionAttestationModeEnum>> getMode() {
            if (this.myMode == null) {
                this.myMode = new ArrayList<BoundCodeDt<CompositionAttestationModeEnum>>();
            }
            return this.myMode;
        }

        public Attester setMode(List<BoundCodeDt<CompositionAttestationModeEnum>> theValue) {
            this.myMode = theValue;
            return this;
        }

        public BoundCodeDt<CompositionAttestationModeEnum> addMode(CompositionAttestationModeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(CompositionAttestationModeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getMode().add((BoundCodeDt<CompositionAttestationModeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<CompositionAttestationModeEnum> getModeFirstRep() {
            if (this.getMode().size() == 0) {
                this.addMode();
            }
            return this.getMode().get(0);
        }

        public BoundCodeDt<CompositionAttestationModeEnum> addMode() {
            BoundCodeDt retVal = new BoundCodeDt(CompositionAttestationModeEnum.VALUESET_BINDER);
            this.getMode().add((BoundCodeDt<CompositionAttestationModeEnum>)retVal);
            return retVal;
        }

        public Attester setMode(CompositionAttestationModeEnum theValue) {
            this.getMode().clear();
            this.addMode(theValue);
            return this;
        }

        public DateTimeDt getTimeElement() {
            if (this.myTime == null) {
                this.myTime = new DateTimeDt();
            }
            return this.myTime;
        }

        public Date getTime() {
            return (Date)this.getTimeElement().getValue();
        }

        public Attester setTime(DateTimeDt theValue) {
            this.myTime = theValue;
            return this;
        }

        public Attester setTimeWithSecondsPrecision(Date theDate) {
            this.myTime = new DateTimeDt(theDate);
            return this;
        }

        public Attester setTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myTime = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public ResourceReferenceDt getParty() {
            if (this.myParty == null) {
                this.myParty = new ResourceReferenceDt();
            }
            return this.myParty;
        }

        public Attester setParty(ResourceReferenceDt theValue) {
            this.myParty = theValue;
            return this;
        }
    }

    @Block
    public static class Event
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.")
        private List<CodeableConceptDt> myCode;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time")
        private PeriodDt myPeriod;
        @Child(name="detail", order=2, min=0, max=-1, summary=true, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy")
        private List<ResourceReferenceDt> myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myPeriod, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myPeriod, this.myDetail});
        }

        public List<CodeableConceptDt> getCode() {
            if (this.myCode == null) {
                this.myCode = new ArrayList<CodeableConceptDt>();
            }
            return this.myCode;
        }

        public Event setCode(List<CodeableConceptDt> theValue) {
            this.myCode = theValue;
            return this;
        }

        public CodeableConceptDt addCode() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getCode().add(newType);
            return newType;
        }

        public Event addCode(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getCode().add(theValue);
            return this;
        }

        public CodeableConceptDt getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                return this.addCode();
            }
            return this.getCode().get(0);
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Event setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ResourceReferenceDt>();
            }
            return this.myDetail;
        }

        public Event setDetail(List<ResourceReferenceDt> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ResourceReferenceDt addDetail() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getDetail().add(newType);
            return newType;
        }
    }

    @Block
    public static class Section
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="title", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents")
        private StringDt myTitle;
        @Child(name="code", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code identifying the kind of content contained within the section. This must be consistent with the section title")
        private CodeableConceptDt myCode;
        @Child(name="text", type={NarrativeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.")
        private NarrativeDt myText;
        @Child(name="mode", type={CodeDt.class}, order=3, min=0, max=1, summary=true, modifier=true)
        @Description(shortDefinition="", formalDefinition="How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-mode")
        private CodeDt myMode;
        @Child(name="orderedBy", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specifies the order applied to the items in the section entries")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-order")
        private CodeableConceptDt myOrderedBy;
        @Child(name="entry", order=5, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="A reference to the actual resource from which the narrative in the section is derived")
        private List<ResourceReferenceDt> myEntry;
        @Child(name="emptyReason", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
        private CodeableConceptDt myEmptyReason;
        @Child(name="section", type={Section.class}, order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A nested sub-section within this section")
        private List<Section> mySection;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myTitle, this.myCode, this.myText, this.myMode, this.myOrderedBy, this.myEntry, this.myEmptyReason, this.mySection});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTitle, this.myCode, this.myText, this.myMode, this.myOrderedBy, this.myEntry, this.myEmptyReason, this.mySection});
        }

        public StringDt getTitleElement() {
            if (this.myTitle == null) {
                this.myTitle = new StringDt();
            }
            return this.myTitle;
        }

        public String getTitle() {
            return (String)this.getTitleElement().getValue();
        }

        public Section setTitle(StringDt theValue) {
            this.myTitle = theValue;
            return this;
        }

        public Section setTitle(String theString) {
            this.myTitle = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Section setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public NarrativeDt getText() {
            if (this.myText == null) {
                this.myText = new NarrativeDt();
            }
            return this.myText;
        }

        public Section setText(NarrativeDt theValue) {
            this.myText = theValue;
            return this;
        }

        public CodeDt getModeElement() {
            if (this.myMode == null) {
                this.myMode = new CodeDt();
            }
            return this.myMode;
        }

        public String getMode() {
            return (String)this.getModeElement().getValue();
        }

        public Section setMode(CodeDt theValue) {
            this.myMode = theValue;
            return this;
        }

        public Section setMode(String theCode) {
            this.myMode = new CodeDt(theCode);
            return this;
        }

        public CodeableConceptDt getOrderedBy() {
            if (this.myOrderedBy == null) {
                this.myOrderedBy = new CodeableConceptDt();
            }
            return this.myOrderedBy;
        }

        public Section setOrderedBy(CodeableConceptDt theValue) {
            this.myOrderedBy = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getEntry() {
            if (this.myEntry == null) {
                this.myEntry = new ArrayList<ResourceReferenceDt>();
            }
            return this.myEntry;
        }

        public Section setEntry(List<ResourceReferenceDt> theValue) {
            this.myEntry = theValue;
            return this;
        }

        public ResourceReferenceDt addEntry() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getEntry().add(newType);
            return newType;
        }

        public CodeableConceptDt getEmptyReason() {
            if (this.myEmptyReason == null) {
                this.myEmptyReason = new CodeableConceptDt();
            }
            return this.myEmptyReason;
        }

        public Section setEmptyReason(CodeableConceptDt theValue) {
            this.myEmptyReason = theValue;
            return this;
        }

        public List<Section> getSection() {
            if (this.mySection == null) {
                this.mySection = new ArrayList<Section>();
            }
            return this.mySection;
        }

        public Section setSection(List<Section> theValue) {
            this.mySection = theValue;
            return this;
        }

        public Section addSection() {
            Section newType = new Section();
            this.getSection().add(newType);
            return newType;
        }

        public Section addSection(Section theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSection().add(theValue);
            return this;
        }

        public Section getSectionFirstRep() {
            if (this.getSection().isEmpty()) {
                return this.addSection();
            }
            return this.getSection().get(0);
        }
    }
}

