/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.ReferralRequest;
import ca.uhn.fhir.model.dstu2.valueset.EpisodeOfCareStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="EpisodeOfCare", profile="http://hl7.org/fhir/profiles/EpisodeOfCare", id="episodeofcare")
public class EpisodeOfCare
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="EpisodeOfCare.patient", description="", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="identifier", path="EpisodeOfCare.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="EpisodeOfCare.status", description="The current status of the Episode of Care as provided (does not check the status history collection)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="organization", path="EpisodeOfCare.managingOrganization", description="The organization that has assumed the specific responsibilities of this EpisodeOfCare", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    @SearchParamDefinition(name="date", path="EpisodeOfCare.period", description="The provided date search value falls within the episode of care's period", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="type", path="EpisodeOfCare.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="condition", path="EpisodeOfCare.condition", description="", type="reference", target={Condition.class})
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    @SearchParamDefinition(name="incomingreferral", path="EpisodeOfCare.referralRequest", description="Incoming Referral Request", type="reference", target={ReferralRequest.class})
    public static final String SP_INCOMINGREFERRAL = "incomingreferral";
    public static final ReferenceClientParam INCOMINGREFERRAL = new ReferenceClientParam("incomingreferral");
    @SearchParamDefinition(name="care-manager", path="EpisodeOfCare.careManager", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Practitioner.class})
    public static final String SP_CARE_MANAGER = "care-manager";
    public static final ReferenceClientParam CARE_MANAGER = new ReferenceClientParam("care-manager");
    @SearchParamDefinition(name="team-member", path="EpisodeOfCare.careTeam.member", description="A Practitioner or Organization allocated to the care team for this EpisodeOfCare", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_TEAM_MEMBER = "team-member";
    public static final ReferenceClientParam TEAM_MEMBER = new ReferenceClientParam("team-member");
    public static final Include INCLUDE_CARE_MANAGER = new Include("EpisodeOfCare:care-manager");
    public static final Include INCLUDE_CONDITION = new Include("EpisodeOfCare:condition");
    public static final Include INCLUDE_INCOMINGREFERRAL = new Include("EpisodeOfCare:incomingreferral");
    public static final Include INCLUDE_ORGANIZATION = new Include("EpisodeOfCare:organization");
    public static final Include INCLUDE_PATIENT = new Include("EpisodeOfCare:patient");
    public static final Include INCLUDE_TEAM_MEMBER = new Include("EpisodeOfCare:team-member");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifier(s) by which this EpisodeOfCare is known")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="planned | waitlist | active | onhold | finished | cancelled")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/episode-of-care-status")
    private BoundCodeDt<EpisodeOfCareStatusEnum> myStatus;
    @Child(name="statusHistory", order=2, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The history of statuses that the EpisodeOfCare has been through (without requiring processing the history of the resource)")
    private List<StatusHistory> myStatusHistory;
    @Child(name="type", type={CodeableConceptDt.class}, order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="A classification of the type of encounter; e.g. specialist referral, disease management, type of funded care")
    private List<CodeableConceptDt> myType;
    @Child(name="condition", order=4, min=0, max=-1, summary=false, modifier=false, type={Condition.class})
    @Description(shortDefinition="what", formalDefinition="A list of conditions/problems/diagnoses that this episode of care is intended to be providing care for")
    private List<ResourceReferenceDt> myCondition;
    @Child(name="patient", order=5, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient that this EpisodeOfCare applies to")
    private ResourceReferenceDt myPatient;
    @Child(name="managingOrganization", order=6, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization that has assumed the specific responsibilities for the specified duration")
    private ResourceReferenceDt myManagingOrganization;
    @Child(name="period", type={PeriodDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.init", formalDefinition="The interval during which the managing organization assumes the defined responsibility")
    private PeriodDt myPeriod;
    @Child(name="referralRequest", order=8, min=0, max=-1, summary=false, modifier=false, type={ReferralRequest.class})
    @Description(shortDefinition="", formalDefinition="Referral Request(s) that are fulfilled by this EpisodeOfCare, incoming referrals")
    private List<ResourceReferenceDt> myReferralRequest;
    @Child(name="careManager", order=9, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner that is the care manager/care co-ordinator for this patient")
    private ResourceReferenceDt myCareManager;
    @Child(name="careTeam", order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The list of practitioners that may be facilitating this episode of care for specific purposes")
    private List<CareTeam> myCareTeam;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myStatusHistory, this.myType, this.myCondition, this.myPatient, this.myManagingOrganization, this.myPeriod, this.myReferralRequest, this.myCareManager, this.myCareTeam});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myStatusHistory, this.myType, this.myCondition, this.myPatient, this.myManagingOrganization, this.myPeriod, this.myReferralRequest, this.myCareManager, this.myCareTeam});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public EpisodeOfCare setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public EpisodeOfCare addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<EpisodeOfCareStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(EpisodeOfCareStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public EpisodeOfCare setStatus(BoundCodeDt<EpisodeOfCareStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public EpisodeOfCare setStatus(EpisodeOfCareStatusEnum theValue) {
        this.setStatus((BoundCodeDt<EpisodeOfCareStatusEnum>)new BoundCodeDt(EpisodeOfCareStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<StatusHistory> getStatusHistory() {
        if (this.myStatusHistory == null) {
            this.myStatusHistory = new ArrayList<StatusHistory>();
        }
        return this.myStatusHistory;
    }

    public EpisodeOfCare setStatusHistory(List<StatusHistory> theValue) {
        this.myStatusHistory = theValue;
        return this;
    }

    public StatusHistory addStatusHistory() {
        StatusHistory newType = new StatusHistory();
        this.getStatusHistory().add(newType);
        return newType;
    }

    public EpisodeOfCare addStatusHistory(StatusHistory theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getStatusHistory().add(theValue);
        return this;
    }

    public StatusHistory getStatusHistoryFirstRep() {
        if (this.getStatusHistory().isEmpty()) {
            return this.addStatusHistory();
        }
        return this.getStatusHistory().get(0);
    }

    public List<CodeableConceptDt> getType() {
        if (this.myType == null) {
            this.myType = new ArrayList<CodeableConceptDt>();
        }
        return this.myType;
    }

    public EpisodeOfCare setType(List<CodeableConceptDt> theValue) {
        this.myType = theValue;
        return this;
    }

    public CodeableConceptDt addType() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getType().add(newType);
        return newType;
    }

    public EpisodeOfCare addType(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getType().add(theValue);
        return this;
    }

    public CodeableConceptDt getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            return this.addType();
        }
        return this.getType().get(0);
    }

    public List<ResourceReferenceDt> getCondition() {
        if (this.myCondition == null) {
            this.myCondition = new ArrayList<ResourceReferenceDt>();
        }
        return this.myCondition;
    }

    public EpisodeOfCare setCondition(List<ResourceReferenceDt> theValue) {
        this.myCondition = theValue;
        return this;
    }

    public ResourceReferenceDt addCondition() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getCondition().add(newType);
        return newType;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public EpisodeOfCare setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getManagingOrganization() {
        if (this.myManagingOrganization == null) {
            this.myManagingOrganization = new ResourceReferenceDt();
        }
        return this.myManagingOrganization;
    }

    public EpisodeOfCare setManagingOrganization(ResourceReferenceDt theValue) {
        this.myManagingOrganization = theValue;
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public EpisodeOfCare setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getReferralRequest() {
        if (this.myReferralRequest == null) {
            this.myReferralRequest = new ArrayList<ResourceReferenceDt>();
        }
        return this.myReferralRequest;
    }

    public EpisodeOfCare setReferralRequest(List<ResourceReferenceDt> theValue) {
        this.myReferralRequest = theValue;
        return this;
    }

    public ResourceReferenceDt addReferralRequest() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getReferralRequest().add(newType);
        return newType;
    }

    public ResourceReferenceDt getCareManager() {
        if (this.myCareManager == null) {
            this.myCareManager = new ResourceReferenceDt();
        }
        return this.myCareManager;
    }

    public EpisodeOfCare setCareManager(ResourceReferenceDt theValue) {
        this.myCareManager = theValue;
        return this;
    }

    public List<CareTeam> getCareTeam() {
        if (this.myCareTeam == null) {
            this.myCareTeam = new ArrayList<CareTeam>();
        }
        return this.myCareTeam;
    }

    public EpisodeOfCare setCareTeam(List<CareTeam> theValue) {
        this.myCareTeam = theValue;
        return this;
    }

    public CareTeam addCareTeam() {
        CareTeam newType = new CareTeam();
        this.getCareTeam().add(newType);
        return newType;
    }

    public EpisodeOfCare addCareTeam(CareTeam theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCareTeam().add(theValue);
        return this;
    }

    public CareTeam getCareTeamFirstRep() {
        if (this.getCareTeam().isEmpty()) {
            return this.addCareTeam();
        }
        return this.getCareTeam().get(0);
    }

    public String getResourceName() {
        return "EpisodeOfCare";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class StatusHistory
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="status", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="planned | waitlist | active | onhold | finished | cancelled")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/episode-of-care-status")
        private BoundCodeDt<EpisodeOfCareStatusEnum> myStatus;
        @Child(name="period", type={PeriodDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The period during this EpisodeOfCare that the specific status applied")
        private PeriodDt myPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStatus, this.myPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStatus, this.myPeriod});
        }

        public BoundCodeDt<EpisodeOfCareStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(EpisodeOfCareStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public String getStatus() {
            return (String)this.getStatusElement().getValue();
        }

        public StatusHistory setStatus(BoundCodeDt<EpisodeOfCareStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public StatusHistory setStatus(EpisodeOfCareStatusEnum theValue) {
            this.setStatus((BoundCodeDt<EpisodeOfCareStatusEnum>)new BoundCodeDt(EpisodeOfCareStatusEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public StatusHistory setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }
    }

    @Block
    public static class CareTeam
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The role this team member is taking within this episode of care")
        private List<CodeableConceptDt> myRole;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The period of time this practitioner is performing some role within the episode of care")
        private PeriodDt myPeriod;
        @Child(name="member", order=2, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class})
        @Description(shortDefinition="who", formalDefinition="The practitioner (or Organization) within the team")
        private ResourceReferenceDt myMember;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myRole, this.myPeriod, this.myMember});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myPeriod, this.myMember});
        }

        public List<CodeableConceptDt> getRole() {
            if (this.myRole == null) {
                this.myRole = new ArrayList<CodeableConceptDt>();
            }
            return this.myRole;
        }

        public CareTeam setRole(List<CodeableConceptDt> theValue) {
            this.myRole = theValue;
            return this;
        }

        public CodeableConceptDt addRole() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getRole().add(newType);
            return newType;
        }

        public CareTeam addRole(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getRole().add(theValue);
            return this;
        }

        public CodeableConceptDt getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                return this.addRole();
            }
            return this.getRole().get(0);
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public CareTeam setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public ResourceReferenceDt getMember() {
            if (this.myMember == null) {
                this.myMember = new ResourceReferenceDt();
            }
            return this.myMember;
        }

        public CareTeam setMember(ResourceReferenceDt theValue) {
            this.myMember = theValue;
            return this;
        }
    }
}

