/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ConditionClinicalStatusCodesEnum {
    ACTIVE("active", "http://hl7.org/fhir/condition-clinical"),
    RELAPSE("relapse", "http://hl7.org/fhir/condition-clinical"),
    REMISSION("remission", "http://hl7.org/fhir/condition-clinical"),
    RESOLVED("resolved", "http://hl7.org/fhir/condition-clinical");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Condition Clinical Status Codes";
    private static Map<String, ConditionClinicalStatusCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ConditionClinicalStatusCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ConditionClinicalStatusCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ConditionClinicalStatusCodesEnum forCode(String theCode) {
        ConditionClinicalStatusCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ConditionClinicalStatusCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ConditionClinicalStatusCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ConditionClinicalStatusCodesEnum>>();
        for (ConditionClinicalStatusCodesEnum next : ConditionClinicalStatusCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ConditionClinicalStatusCodesEnum>(){

            public String toCodeString(ConditionClinicalStatusCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ConditionClinicalStatusCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ConditionClinicalStatusCodesEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public ConditionClinicalStatusCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, ConditionClinicalStatusCodesEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

