/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SubstanceCategoryCodesEnum {
    ALLERGEN("allergen", "http://hl7.org/fhir/substance-category"),
    BIOLOGICAL_SUBSTANCE("biological", "http://hl7.org/fhir/substance-category"),
    BODY_SUBSTANCE("body", "http://hl7.org/fhir/substance-category"),
    CHEMICAL("chemical", "http://hl7.org/fhir/substance-category"),
    DIETARY_SUBSTANCE("food", "http://hl7.org/fhir/substance-category"),
    DRUG_OR_MEDICAMENT("drug", "http://hl7.org/fhir/substance-category"),
    MATERIAL("material", "http://hl7.org/fhir/substance-category");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Substance Category Codes";
    private static Map<String, SubstanceCategoryCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SubstanceCategoryCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SubstanceCategoryCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static SubstanceCategoryCodesEnum forCode(String theCode) {
        SubstanceCategoryCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SubstanceCategoryCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SubstanceCategoryCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SubstanceCategoryCodesEnum>>();
        for (SubstanceCategoryCodesEnum next : SubstanceCategoryCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SubstanceCategoryCodesEnum>(){

            public String toCodeString(SubstanceCategoryCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SubstanceCategoryCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public SubstanceCategoryCodesEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public SubstanceCategoryCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, SubstanceCategoryCodesEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

