/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider.dstu2;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.BundleInclusionRule;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import ca.uhn.fhir.model.dstu2.valueset.SearchEntryModeEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class Dstu2BundleFactory
implements IVersionSpecificBundleFactory {
    private String myBase;
    private Bundle myBundle;
    private FhirContext myContext;

    public Dstu2BundleFactory(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void addResourcesToBundle(List<IBaseResource> theResult, BundleTypeEnum theBundleType, String theServerBase, BundleInclusionRule theBundleInclusionRule, Set<Include> theIncludes) {
        this.ensureBundle();
        ArrayList includedResources = new ArrayList();
        HashSet<IdDt> addedResourceIds = new HashSet<IdDt>();
        for (IBaseResource next : theResult) {
            if (next.getIdElement().isEmpty()) continue;
            addedResourceIds.add((IdDt)next.getIdElement());
        }
        for (IBaseResource nextBaseRes : theResult) {
            BigDecimal searchScore;
            IResource next = (IResource)nextBaseRes;
            HashSet<String> containedIds = new HashSet<String>();
            for (IResource nextContained : next.getContained().getContainedResources()) {
                if (nextContained.getId().isEmpty()) continue;
                containedIds.add(nextContained.getId().getValue());
            }
            ArrayList references = this.myContext.newTerser().getAllResourceReferences((IBaseResource)next);
            do {
                ArrayList<IResource> addedResourcesThisPass = new ArrayList<IResource>();
                for (ResourceReferenceInfo nextRefInfo : references) {
                    IResource nextRes;
                    if (theBundleInclusionRule != null && !theBundleInclusionRule.shouldIncludeReferencedResource(nextRefInfo, theIncludes) || (nextRes = (IResource)nextRefInfo.getResourceReference().getResource()) == null || !nextRes.getId().hasIdPart() || containedIds.contains(nextRes.getId().getValue())) continue;
                    IdDt id = nextRes.getId();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceType((IBaseResource)nextRes);
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    addedResourcesThisPass.add(nextRes);
                }
                includedResources.addAll(addedResourcesThisPass);
                references = new ArrayList();
                for (IResource iResource : addedResourcesThisPass) {
                    List newReferences = this.myContext.newTerser().getAllResourceReferences((IBaseResource)iResource);
                    references.addAll(newReferences);
                }
            } while (!references.isEmpty());
            Bundle.Entry entry = this.myBundle.addEntry().setResource(next);
            BundleEntryTransactionMethodEnum httpVerb = (BundleEntryTransactionMethodEnum)ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.get((IBaseResource)next);
            if (httpVerb != null) {
                entry.getRequest().getMethodElement().setValueAsString(httpVerb.getCode());
            }
            this.populateBundleEntryFullUrl(next, entry);
            BundleEntrySearchModeEnum searchMode = (BundleEntrySearchModeEnum)ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.get((IBaseResource)next);
            if (searchMode != null) {
                entry.getSearch().getModeElement().setValue((Object)searchMode.getCode());
            }
            if ((searchScore = (BigDecimal)ResourceMetadataKeyEnum.ENTRY_SEARCH_SCORE.get((IBaseResource)next)) == null) continue;
            entry.getSearch().getScoreElement().setValue((Object)searchScore);
        }
        for (IBaseResource next : includedResources) {
            Bundle.Entry entry = this.myBundle.addEntry();
            entry.setResource((IResource)next).getSearch().setMode(SearchEntryModeEnum.INCLUDE);
            this.populateBundleEntryFullUrl((IResource)next, entry);
        }
    }

    public void addRootPropertiesToBundle(String theId, @Nonnull BundleLinks theBundleLinks, Integer theTotalResults, IPrimitiveType<Date> theLastUpdated) {
        this.ensureBundle();
        this.myBase = theBundleLinks.serverBase;
        if (this.myBundle.getIdElement().isEmpty()) {
            this.myBundle.setId(theId);
        }
        if (ResourceMetadataKeyEnum.UPDATED.get((IBaseResource)this.myBundle) == null) {
            ResourceMetadataKeyEnum.UPDATED.put((IBaseResource)this.myBundle, (Object)((InstantDt)theLastUpdated));
        }
        if (!this.hasLink("self", this.myBundle) && StringUtils.isNotBlank((CharSequence)theBundleLinks.getSelf())) {
            this.myBundle.addLink().setRelation("self").setUrl(theBundleLinks.getSelf());
        }
        if (!this.hasLink("next", this.myBundle) && StringUtils.isNotBlank((CharSequence)theBundleLinks.getNext())) {
            this.myBundle.addLink().setRelation("next").setUrl(theBundleLinks.getNext());
        }
        if (!this.hasLink("previous", this.myBundle) && StringUtils.isNotBlank((CharSequence)theBundleLinks.getPrev())) {
            this.myBundle.addLink().setRelation("previous").setUrl(theBundleLinks.getPrev());
        }
        this.addTotalResultsToBundle(theTotalResults, theBundleLinks.bundleType);
    }

    public void addTotalResultsToBundle(Integer theTotalResults, BundleTypeEnum theBundleType) {
        this.ensureBundle();
        if (this.myBundle.getId().isEmpty()) {
            this.myBundle.setId(UUID.randomUUID().toString());
        }
        if (this.myBundle.getTypeElement().isEmpty() && theBundleType != null) {
            this.myBundle.getTypeElement().setValueAsString(theBundleType.getCode());
        }
        if (this.myBundle.getTotalElement().isEmpty() && theTotalResults != null) {
            this.myBundle.getTotalElement().setValue((Object)theTotalResults);
        }
    }

    private void ensureBundle() {
        if (this.myBundle == null) {
            this.myBundle = new Bundle();
        }
    }

    public IResource getResourceBundle() {
        return this.myBundle;
    }

    private boolean hasLink(String theLinkType, Bundle theBundle) {
        for (Bundle.Link next : theBundle.getLink()) {
            if (!theLinkType.equals(next.getRelation())) continue;
            return true;
        }
        return false;
    }

    public void initializeWithBundleResource(IBaseResource theBundle) {
        this.myBundle = (Bundle)theBundle;
    }

    private void populateBundleEntryFullUrl(IResource next, Bundle.Entry entry) {
        if (next.getId().hasBaseUrl()) {
            entry.setFullUrl(next.getId().toVersionless().getValue());
        } else if (StringUtils.isNotBlank((CharSequence)this.myBase) && next.getId().hasIdPart()) {
            IdDt id = next.getId().toVersionless();
            id = id.withServerBase(this.myBase, this.myContext.getResourceType((IBaseResource)next));
            entry.setFullUrl(id.getValue());
        }
    }

    public List<IBaseResource> toListOfResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (Bundle.Entry next : this.myBundle.getEntry()) {
            IdDt id;
            String resourceType;
            if (next.getResource() != null) {
                retVal.add((IBaseResource)next.getResource());
                continue;
            }
            if (next.getResponse().getLocationElement().isEmpty() || !StringUtils.isNotBlank((CharSequence)(resourceType = (id = new IdDt(next.getResponse().getLocation())).getResourceType()))) continue;
            IResource res = (IResource)this.myContext.getResourceDefinition(resourceType).newInstance();
            res.setId(id);
            retVal.add((IBaseResource)res);
        }
        return retVal;
    }
}

