/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import java.util.List;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public interface IValidationSupport
extends IContextValidationSupport<ValueSet.ConceptSetComponent, ValueSet.ValueSetExpansionComponent, StructureDefinition, CodeSystem, CodeSystem.ConceptDefinitionComponent, ValidationMessage.IssueSeverity> {
    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext var1, ValueSet.ConceptSetComponent var2);

    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext var1);

    public CodeSystem fetchCodeSystem(FhirContext var1, String var2);

    public ValueSet fetchValueSet(FhirContext var1, String var2);

    public StructureDefinition fetchStructureDefinition(FhirContext var1, String var2);

    public boolean isCodeSystemSupported(FhirContext var1, String var2);

    public CodeValidationResult validateCode(FhirContext var1, String var2, String var3, String var4);

    public StructureDefinition generateSnapshot(StructureDefinition var1, String var2, String var3);

    public static class CodeValidationResult
    extends IContextValidationSupport.CodeValidationResult<CodeSystem.ConceptDefinitionComponent, ValidationMessage.IssueSeverity> {
        public CodeValidationResult(CodeSystem.ConceptDefinitionComponent theNext) {
            super((Object)theNext);
        }

        public CodeValidationResult(ValidationMessage.IssueSeverity theSeverity, String theMessage) {
            super((Object)theSeverity, theMessage);
        }

        public CodeValidationResult(ValidationMessage.IssueSeverity severity, String message, CodeSystem.ConceptDefinitionComponent definition) {
            super((Object)severity, message, (Object)definition);
        }

        protected String getDisplay() {
            String retVal = null;
            if (this.isOk()) {
                retVal = ((CodeSystem.ConceptDefinitionComponent)this.asConceptDefinition()).getDisplay();
            }
            return retVal;
        }
    }
}

