/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.fluentpath;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fluentpath.FluentPathExecutionException;
import ca.uhn.fhir.fluentpath.IFluentPath;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.IValidationSupport;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.utils.FHIRPathEngine;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;

public class FluentPathDstu3
implements IFluentPath {
    private FHIRPathEngine myEngine;

    public FluentPathDstu3(FhirContext theCtx) {
        if (!(theCtx.getValidationSupport() instanceof IValidationSupport)) {
            throw new IllegalStateException("Validation support module configured on context appears to be for the wrong FHIR version- Does not extend " + IValidationSupport.class.getName());
        }
        IValidationSupport validationSupport = (IValidationSupport)theCtx.getValidationSupport();
        this.myEngine = new FHIRPathEngine((IWorkerContext)new HapiWorkerContext(theCtx, validationSupport));
    }

    public <T extends IBase> List<T> evaluate(IBase theInput, String thePath, Class<T> theReturnType) {
        List result;
        try {
            result = this.myEngine.evaluate((Base)theInput, thePath);
        }
        catch (FHIRException e) {
            throw new FluentPathExecutionException((Throwable)e);
        }
        for (Base next : result) {
            if (theReturnType.isAssignableFrom(next.getClass())) continue;
            throw new FluentPathExecutionException("FluentPath expression \"" + thePath + "\" returned unexpected type " + next.getClass().getSimpleName() + " - Expected " + theReturnType.getName());
        }
        return result;
    }

    public <T extends IBase> Optional<T> evaluateFirst(IBase theInput, String thePath, Class<T> theReturnType) {
        return this.evaluate(theInput, thePath, theReturnType).stream().findFirst();
    }
}

