package org.hl7.fhir.r4.formats;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Thu, Sep 13, 2018 09:04-0400 for FHIR v3.5.0

import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.*;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.r4.utils.formats.JsonTrackingParser.PresentedBigDecimal;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.FHIRException;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;

public class JsonParser extends JsonParserBase {

  protected void parseElementProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
    super.parseElementProperties(json, element);
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        element.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected void parseBackboneElementProperties(JsonObject json, BackboneElement element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        element.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
  }

  protected void parseBackboneElementProperties(JsonObject json, BackboneType element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        element.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
  }

  protected void parseTypeProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    if (s != null)
      res.setValue((E) e.fromCode(s));
    return res;
  }

  protected DateType parseDate(String v) throws IOException, FHIRFormatError {
    DateType res = new DateType(v);
    return res;
  }

  protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(v);
    return res;
  }

  protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
    CodeType res = new CodeType(v);
    return res;
  }

  protected StringType parseString(String v) throws IOException, FHIRFormatError {
    StringType res = new StringType(v);
    return res;
  }

  protected IntegerType parseInteger(java.lang.Long v) throws IOException, FHIRFormatError {
    IntegerType res = new IntegerType(v);
    return res;
  }

  protected OidType parseOid(String v) throws IOException, FHIRFormatError {
    OidType res = new OidType(v);
    return res;
  }

  protected CanonicalType parseCanonical(String v) throws IOException, FHIRFormatError {
    CanonicalType res = new CanonicalType(v);
    return res;
  }

  protected UriType parseUri(String v) throws IOException, FHIRFormatError {
    UriType res = new UriType(v);
    return res;
  }

  protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
    UuidType res = new UuidType(v);
    return res;
  }

  protected UrlType parseUrl(String v) throws IOException, FHIRFormatError {
    UrlType res = new UrlType(v);
    return res;
  }

  protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
    InstantType res = new InstantType(v);
    return res;
  }

  protected BooleanType parseBoolean(java.lang.Boolean v) throws IOException, FHIRFormatError {
    BooleanType res = new BooleanType(v);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(v);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(v);
    return res;
  }

  protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(v);
    return res;
  }

  protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
    TimeType res = new TimeType(v);
    return res;
  }

  protected IdType parseId(String v) throws IOException, FHIRFormatError {
    IdType res = new IdType(v);
    return res;
  }

  protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(v);
    return res;
  }

  protected DecimalType parseDecimal(java.math.BigDecimal v) throws IOException, FHIRFormatError {
    DecimalType res = new DecimalType(v);
    if (v instanceof PresentedBigDecimal)
      res.setRepresentation(((PresentedBigDecimal) v).getPresentation());
    return res;
  }

  protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
    Extension res = new Extension();
    parseExtensionProperties(json, res);
    return res;
  }

  protected void parseExtensionProperties(JsonObject json, Extension res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseNarrativeProperties(json, res);
    return res;
  }

  protected void parseNarrativeProperties(JsonObject json, Narrative res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("div"))
      res.setDiv(parseXhtml(json.get("div").getAsString()));
  }

  protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
    Meta res = new Meta();
    parseMetaProperties(json, res);
    return res;
  }

  protected void parseMetaProperties(JsonObject json, Meta res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseId(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
    if (json.has("lastUpdated"))
      res.setLastUpdatedElement(parseInstant(json.get("lastUpdated").getAsString()));
    if (json.has("_lastUpdated"))
      parseElementProperties(json.getAsJsonObject("_lastUpdated"), res.getLastUpdatedElement());
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    if (json.has("security")) {
      JsonArray array = json.getAsJsonArray("security");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurity().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("tag")) {
      JsonArray array = json.getAsJsonArray("tag");
      for (int i = 0; i < array.size(); i++) {
        res.getTag().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
    Address res = new Address();
    parseAddressProperties(json, res);
    return res;
  }

  protected void parseAddressProperties(JsonObject json, Address res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("line")) {
      JsonArray array = json.getAsJsonArray("line");
      for (int i = 0; i < array.size(); i++) {
        res.getLine().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_line")) {
      JsonArray array = json.getAsJsonArray("_line");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLine().size())
          res.getLine().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
      }
    };
    if (json.has("city"))
      res.setCityElement(parseString(json.get("city").getAsString()));
    if (json.has("_city"))
      parseElementProperties(json.getAsJsonObject("_city"), res.getCityElement());
    if (json.has("district"))
      res.setDistrictElement(parseString(json.get("district").getAsString()));
    if (json.has("_district"))
      parseElementProperties(json.getAsJsonObject("_district"), res.getDistrictElement());
    if (json.has("state"))
      res.setStateElement(parseString(json.get("state").getAsString()));
    if (json.has("_state"))
      parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
    if (json.has("postalCode"))
      res.setPostalCodeElement(parseString(json.get("postalCode").getAsString()));
    if (json.has("_postalCode"))
      parseElementProperties(json.getAsJsonObject("_postalCode"), res.getPostalCodeElement());
    if (json.has("country"))
      res.setCountryElement(parseString(json.get("country").getAsString()));
    if (json.has("_country"))
      parseElementProperties(json.getAsJsonObject("_country"), res.getCountryElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Contributor parseContributor(JsonObject json) throws IOException, FHIRFormatError {
    Contributor res = new Contributor();
    parseContributorProperties(json, res);
    return res;
  }

  protected void parseContributorProperties(JsonObject json, Contributor res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseAttachmentProperties(json, res);
    return res;
  }

  protected void parseAttachmentProperties(JsonObject json, Attachment res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("size"))
      res.setSizeElement(parseUnsignedInt(json.get("size").getAsString()));
    if (json.has("_size"))
      parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
    if (json.has("hash"))
      res.setHashElement(parseBase64Binary(json.get("hash").getAsString()));
    if (json.has("_hash"))
      parseElementProperties(json.getAsJsonObject("_hash"), res.getHashElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("creation"))
      res.setCreationElement(parseDateTime(json.get("creation").getAsString()));
    if (json.has("_creation"))
      parseElementProperties(json.getAsJsonObject("_creation"), res.getCreationElement());
  }

  protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
    Count res = new Count();
    parseCountProperties(json, res);
    return res;
  }

  protected void parseCountProperties(JsonObject json, Count res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseDataRequirementProperties(json, res);
    return res;
  }

  protected void parseDataRequirementProperties(JsonObject json, DataRequirement res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("mustSupport")) {
      JsonArray array = json.getAsJsonArray("mustSupport");
      for (int i = 0; i < array.size(); i++) {
        res.getMustSupport().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_mustSupport")) {
      JsonArray array = json.getAsJsonArray("_mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMustSupport().size())
          res.getMustSupport().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
      }
    };
    if (json.has("codeFilter")) {
      JsonArray array = json.getAsJsonArray("codeFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeFilter().add(parseDataRequirementDataRequirementCodeFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("dateFilter")) {
      JsonArray array = json.getAsJsonArray("dateFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getDateFilter().add(parseDataRequirementDataRequirementDateFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("limit"))
      res.setLimitElement(parsePositiveInt(json.get("limit").getAsString()));
    if (json.has("_limit"))
      parseElementProperties(json.getAsJsonObject("_limit"), res.getLimitElement());
    if (json.has("sort")) {
      JsonArray array = json.getAsJsonArray("sort");
      for (int i = 0; i < array.size(); i++) {
        res.getSort().add(parseDataRequirementDataRequirementSortComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseDataRequirementDataRequirementCodeFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataRequirementDataRequirementCodeFilterComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementCodeFilterComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(json.getAsJsonObject("_searchParam"), res.getSearchParamElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseDataRequirementDataRequirementDateFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataRequirementDataRequirementDateFilterComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementDateFilterComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(json.getAsJsonObject("_searchParam"), res.getSearchParamElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DataRequirement.DataRequirementSortComponent parseDataRequirementDataRequirementSortComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
    parseDataRequirementDataRequirementSortComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDataRequirementDataRequirementSortComponentProperties(JsonObject json, DataRequirement owner, DataRequirement.DataRequirementSortComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("direction"))
      res.setDirectionElement(parseEnumeration(json.get("direction").getAsString(), DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
    if (json.has("_direction"))
      parseElementProperties(json.getAsJsonObject("_direction"), res.getDirectionElement());
  }

  protected Dosage parseDosage(JsonObject json) throws IOException, FHIRFormatError {
    Dosage res = new Dosage();
    parseDosageProperties(json, res);
    return res;
  }

  protected void parseDosageProperties(JsonObject json, Dosage res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parseInteger(json.get("sequence").getAsLong()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("additionalInstruction")) {
      JsonArray array = json.getAsJsonArray("additionalInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalInstruction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patientInstruction"))
      res.setPatientInstructionElement(parseString(json.get("patientInstruction").getAsString()));
    if (json.has("_patientInstruction"))
      parseElementProperties(json.getAsJsonObject("_patientInstruction"), res.getPatientInstructionElement());
    if (json.has("timing"))
      res.setTiming(parseTiming(json.getAsJsonObject("timing")));
    Type asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("doseAndRate")) {
      JsonArray array = json.getAsJsonArray("doseAndRate");
      for (int i = 0; i < array.size(); i++) {
        res.getDoseAndRate().add(parseDosageDosageDoseAndRateComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("maxDosePerPeriod"))
      res.setMaxDosePerPeriod(parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
    if (json.has("maxDosePerAdministration"))
      res.setMaxDosePerAdministration(parseQuantity(json.getAsJsonObject("maxDosePerAdministration")));
    if (json.has("maxDosePerLifetime"))
      res.setMaxDosePerLifetime(parseQuantity(json.getAsJsonObject("maxDosePerLifetime")));
  }

  protected Dosage.DosageDoseAndRateComponent parseDosageDosageDoseAndRateComponent(JsonObject json, Dosage owner) throws IOException, FHIRFormatError {
    Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
    parseDosageDosageDoseAndRateComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDosageDosageDoseAndRateComponentProperties(JsonObject json, Dosage owner, Dosage.DosageDoseAndRateComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type dose = parseType("dose", json);
    if (dose != null)
      res.setDose(dose);
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
    Money res = new Money();
    parseMoneyProperties(json, res);
    return res;
  }

  protected void parseMoneyProperties(JsonObject json, Money res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("currency"))
      res.setCurrencyElement(parseCode(json.get("currency").getAsString()));
    if (json.has("_currency"))
      parseElementProperties(json.getAsJsonObject("_currency"), res.getCurrencyElement());
  }

  protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseHumanNameProperties(json, res);
    return res;
  }

  protected void parseHumanNameProperties(JsonObject json, HumanName res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("family"))
      res.setFamilyElement(parseString(json.get("family").getAsString()));
    if (json.has("_family"))
      parseElementProperties(json.getAsJsonObject("_family"), res.getFamilyElement());
    if (json.has("given")) {
      JsonArray array = json.getAsJsonArray("given");
      for (int i = 0; i < array.size(); i++) {
        res.getGiven().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_given")) {
      JsonArray array = json.getAsJsonArray("_given");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGiven().size())
          res.getGiven().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
      }
    };
    if (json.has("prefix")) {
      JsonArray array = json.getAsJsonArray("prefix");
      for (int i = 0; i < array.size(); i++) {
        res.getPrefix().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_prefix")) {
      JsonArray array = json.getAsJsonArray("_prefix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPrefix().size())
          res.getPrefix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
      }
    };
    if (json.has("suffix")) {
      JsonArray array = json.getAsJsonArray("suffix");
      for (int i = 0; i < array.size(); i++) {
        res.getSuffix().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_suffix")) {
      JsonArray array = json.getAsJsonArray("_suffix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSuffix().size())
          res.getSuffix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseContactPointProperties(json, res);
    return res;
  }

  protected void parseContactPointProperties(JsonObject json, ContactPoint res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseIdentifierProperties(json, res);
    return res;
  }

  protected void parseIdentifierProperties(JsonObject json, Identifier res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("assigner"))
      res.setAssigner(parseReference(json.getAsJsonObject("assigner")));
  }

  protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
    Coding res = new Coding();
    parseCodingProperties(json, res);
    return res;
  }

  protected void parseCodingProperties(JsonObject json, Coding res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("userSelected"))
      res.setUserSelectedElement(parseBoolean(json.get("userSelected").getAsBoolean()));
    if (json.has("_userSelected"))
      parseElementProperties(json.getAsJsonObject("_userSelected"), res.getUserSelectedElement());
  }

  protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseSampledDataProperties(json, res);
    return res;
  }

  protected void parseSampledDataProperties(JsonObject json, SampledData res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("origin"))
      res.setOrigin(parseQuantity(json.getAsJsonObject("origin")));
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("lowerLimit"))
      res.setLowerLimitElement(parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
    if (json.has("_lowerLimit"))
      parseElementProperties(json.getAsJsonObject("_lowerLimit"), res.getLowerLimitElement());
    if (json.has("upperLimit"))
      res.setUpperLimitElement(parseDecimal(json.get("upperLimit").getAsBigDecimal()));
    if (json.has("_upperLimit"))
      parseElementProperties(json.getAsJsonObject("_upperLimit"), res.getUpperLimitElement());
    if (json.has("dimensions"))
      res.setDimensionsElement(parsePositiveInt(json.get("dimensions").getAsString()));
    if (json.has("_dimensions"))
      parseElementProperties(json.getAsJsonObject("_dimensions"), res.getDimensionsElement());
    if (json.has("data"))
      res.setDataElement(parseString(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
  }

  protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseRatioProperties(json, res);
    return res;
  }

  protected void parseRatioProperties(JsonObject json, Ratio res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("numerator"))
      res.setNumerator(parseQuantity(json.getAsJsonObject("numerator")));
    if (json.has("denominator"))
      res.setDenominator(parseQuantity(json.getAsJsonObject("denominator")));
  }

  protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
    Distance res = new Distance();
    parseDistanceProperties(json, res);
    return res;
  }

  protected void parseDistanceProperties(JsonObject json, Distance res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
    Age res = new Age();
    parseAgeProperties(json, res);
    return res;
  }

  protected void parseAgeProperties(JsonObject json, Age res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
    Reference res = new Reference();
    parseReferenceProperties(json, res);
    return res;
  }

  protected void parseReferenceProperties(JsonObject json, Reference res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("reference"))
      res.setReferenceElement(parseString(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("type"))
      res.setTypeElement(parseUri(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
  }

  protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseTriggerDefinitionProperties(json, res);
    return res;
  }

  protected void parseTriggerDefinitionProperties(JsonObject json, TriggerDefinition res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("data"))
      res.setData(parseDataRequirement(json.getAsJsonObject("data")));
    if (json.has("condition"))
      res.setCondition(parseExpression(json.getAsJsonObject("condition")));
  }

  protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseQuantityProperties(json, res);
    return res;
  }

  protected void parseQuantityProperties(JsonObject json, Quantity res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
  }

  protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
    Period res = new Period();
    parsePeriodProperties(json, res);
    return res;
  }

  protected void parsePeriodProperties(JsonObject json, Period res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseDateTime(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseDateTime(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
  }

  protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
    Duration res = new Duration();
    parseDurationProperties(json, res);
    return res;
  }

  protected void parseDurationProperties(JsonObject json, Duration res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
    Range res = new Range();
    parseRangeProperties(json, res);
    return res;
  }

  protected void parseRangeProperties(JsonObject json, Range res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("low"))
      res.setLow(parseQuantity(json.getAsJsonObject("low")));
    if (json.has("high"))
      res.setHigh(parseQuantity(json.getAsJsonObject("high")));
  }

  protected RelatedArtifact parseRelatedArtifact(JsonObject json) throws IOException, FHIRFormatError {
    RelatedArtifact res = new RelatedArtifact();
    parseRelatedArtifactProperties(json, res);
    return res;
  }

  protected void parseRelatedArtifactProperties(JsonObject json, RelatedArtifact res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("citation"))
      res.setCitationElement(parseString(json.get("citation").getAsString()));
    if (json.has("_citation"))
      parseElementProperties(json.getAsJsonObject("_citation"), res.getCitationElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("document"))
      res.setDocument(parseAttachment(json.getAsJsonObject("document")));
    if (json.has("resource"))
      res.setResourceElement(parseCanonical(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
  }

  protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseAnnotationProperties(json, res);
    return res;
  }

  protected void parseAnnotationProperties(JsonObject json, Annotation res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    Type author = parseType("author", json);
    if (author != null)
      res.setAuthor(author);
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("text"))
      res.setTextElement(parseMarkdown(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected ContactDetail parseContactDetail(JsonObject json) throws IOException, FHIRFormatError {
    ContactDetail res = new ContactDetail();
    parseContactDetailProperties(json, res);
    return res;
  }

  protected void parseContactDetailProperties(JsonObject json, ContactDetail res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected UsageContext parseUsageContext(JsonObject json) throws IOException, FHIRFormatError {
    UsageContext res = new UsageContext();
    parseUsageContextProperties(json, res);
    return res;
  }

  protected void parseUsageContextProperties(JsonObject json, UsageContext res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Expression parseExpression(JsonObject json) throws IOException, FHIRFormatError {
    Expression res = new Expression();
    parseExpressionProperties(json, res);
    return res;
  }

  protected void parseExpressionProperties(JsonObject json, Expression res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("language"))
      res.setLanguageElement(parseEnumeration(json.get("language").getAsString(), Expression.ExpressionLanguage.NULL, new Expression.ExpressionLanguageEnumFactory()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
  }

  protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
    Signature res = new Signature();
    parseSignatureProperties(json, res);
    return res;
  }

  protected void parseSignatureProperties(JsonObject json, Signature res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("when"))
      res.setWhenElement(parseInstant(json.get("when").getAsString()));
    if (json.has("_when"))
      parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
    if (json.has("who"))
      res.setWho(parseReference(json.getAsJsonObject("who")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
    if (json.has("targetFormat"))
      res.setTargetFormatElement(parseCode(json.get("targetFormat").getAsString()));
    if (json.has("_targetFormat"))
      parseElementProperties(json.getAsJsonObject("_targetFormat"), res.getTargetFormatElement());
    if (json.has("sigFormat"))
      res.setSigFormatElement(parseCode(json.get("sigFormat").getAsString()));
    if (json.has("_sigFormat"))
      parseElementProperties(json.getAsJsonObject("_sigFormat"), res.getSigFormatElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
  }

  protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
    Timing res = new Timing();
    parseTimingProperties(json, res);
    return res;
  }

  protected void parseTimingProperties(JsonObject json, Timing res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseDateTime(array.get(i).getAsString()));
      }
    };
    if (json.has("_event")) {
      JsonArray array = json.getAsJsonArray("_event");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getEvent().size())
          res.getEvent().add(parseDateTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
      }
    };
    if (json.has("repeat"))
      res.setRepeat(parseTimingTimingRepeatComponent(json.getAsJsonObject("repeat"), res));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(JsonObject json, Timing owner) throws IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseTimingTimingRepeatComponentProperties(json, owner, res);
    return res;
  }

  protected void parseTimingTimingRepeatComponentProperties(JsonObject json, Timing owner, Timing.TimingRepeatComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    Type bounds = parseType("bounds", json);
    if (bounds != null)
      res.setBounds(bounds);
    if (json.has("count"))
      res.setCountElement(parsePositiveInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("countMax"))
      res.setCountMaxElement(parsePositiveInt(json.get("countMax").getAsString()));
    if (json.has("_countMax"))
      parseElementProperties(json.getAsJsonObject("_countMax"), res.getCountMaxElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("durationMax"))
      res.setDurationMaxElement(parseDecimal(json.get("durationMax").getAsBigDecimal()));
    if (json.has("_durationMax"))
      parseElementProperties(json.getAsJsonObject("_durationMax"), res.getDurationMaxElement());
    if (json.has("durationUnit"))
      res.setDurationUnitElement(parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_durationUnit"))
      parseElementProperties(json.getAsJsonObject("_durationUnit"), res.getDurationUnitElement());
    if (json.has("frequency"))
      res.setFrequencyElement(parsePositiveInt(json.get("frequency").getAsString()));
    if (json.has("_frequency"))
      parseElementProperties(json.getAsJsonObject("_frequency"), res.getFrequencyElement());
    if (json.has("frequencyMax"))
      res.setFrequencyMaxElement(parsePositiveInt(json.get("frequencyMax").getAsString()));
    if (json.has("_frequencyMax"))
      parseElementProperties(json.getAsJsonObject("_frequencyMax"), res.getFrequencyMaxElement());
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
    if (json.has("periodMax"))
      res.setPeriodMaxElement(parseDecimal(json.get("periodMax").getAsBigDecimal()));
    if (json.has("_periodMax"))
      parseElementProperties(json.getAsJsonObject("_periodMax"), res.getPeriodMaxElement());
    if (json.has("periodUnit"))
      res.setPeriodUnitElement(parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_periodUnit"))
      parseElementProperties(json.getAsJsonObject("_periodUnit"), res.getPeriodUnitElement());
    if (json.has("dayOfWeek")) {
      JsonArray array = json.getAsJsonArray("dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        res.getDayOfWeek().add(parseEnumeration(array.get(i).getAsString(), Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
      }
    };
    if (json.has("_dayOfWeek")) {
      JsonArray array = json.getAsJsonArray("_dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDayOfWeek().size())
          res.getDayOfWeek().add(parseEnumeration(null, Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDayOfWeek().get(i));
      }
    };
    if (json.has("timeOfDay")) {
      JsonArray array = json.getAsJsonArray("timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        res.getTimeOfDay().add(parseTime(array.get(i).getAsString()));
      }
    };
    if (json.has("_timeOfDay")) {
      JsonArray array = json.getAsJsonArray("_timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTimeOfDay().size())
          res.getTimeOfDay().add(parseTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTimeOfDay().get(i));
      }
    };
    if (json.has("when")) {
      JsonArray array = json.getAsJsonArray("when");
      for (int i = 0; i < array.size(); i++) {
        res.getWhen().add(parseEnumeration(array.get(i).getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
      }
    };
    if (json.has("_when")) {
      JsonArray array = json.getAsJsonArray("_when");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getWhen().size())
          res.getWhen().add(parseEnumeration(null, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getWhen().get(i));
      }
    };
    if (json.has("offset"))
      res.setOffsetElement(parseUnsignedInt(json.get("offset").getAsString()));
    if (json.has("_offset"))
      parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
  }

  protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseCodeableConceptProperties(json, res);
    return res;
  }

  protected void parseCodeableConceptProperties(JsonObject json, CodeableConcept res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("coding")) {
      JsonArray array = json.getAsJsonArray("coding");
      for (int i = 0; i < array.size(); i++) {
        res.getCoding().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseParameterDefinitionProperties(json, res);
    return res;
  }

  protected void parseParameterDefinitionProperties(JsonObject json, ParameterDefinition res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ParameterDefinition.ParameterUse.NULL, new ParameterDefinition.ParameterUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
  }

  protected MarketingStatus parseMarketingStatus(JsonObject json) throws IOException, FHIRFormatError {
    MarketingStatus res = new MarketingStatus();
    parseMarketingStatusProperties(json, res);
    return res;
  }

  protected void parseMarketingStatusProperties(JsonObject json, MarketingStatus res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(json.getAsJsonObject("country")));
    if (json.has("jurisdiction"))
      res.setJurisdiction(parseCodeableConcept(json.getAsJsonObject("jurisdiction")));
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
    if (json.has("dateRange"))
      res.setDateRange(parsePeriod(json.getAsJsonObject("dateRange")));
    if (json.has("restoreDate"))
      res.setRestoreDateElement(parseDateTime(json.get("restoreDate").getAsString()));
    if (json.has("_restoreDate"))
      parseElementProperties(json.getAsJsonObject("_restoreDate"), res.getRestoreDateElement());
  }

  protected SubstanceAmount parseSubstanceAmount(JsonObject json) throws IOException, FHIRFormatError {
    SubstanceAmount res = new SubstanceAmount();
    parseSubstanceAmountProperties(json, res);
    return res;
  }

  protected void parseSubstanceAmountProperties(JsonObject json, SubstanceAmount res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type amount = parseType("amount", json);
    if (amount != null)
      res.setAmount(amount);
    if (json.has("amountType"))
      res.setAmountType(parseCodeableConcept(json.getAsJsonObject("amountType")));
    if (json.has("amountText"))
      res.setAmountTextElement(parseString(json.get("amountText").getAsString()));
    if (json.has("_amountText"))
      parseElementProperties(json.getAsJsonObject("_amountText"), res.getAmountTextElement());
    if (json.has("referenceRange"))
      res.setReferenceRange(parseSubstanceAmountSubstanceAmountReferenceRangeComponent(json.getAsJsonObject("referenceRange"), res));
  }

  protected SubstanceAmount.SubstanceAmountReferenceRangeComponent parseSubstanceAmountSubstanceAmountReferenceRangeComponent(JsonObject json, SubstanceAmount owner) throws IOException, FHIRFormatError {
    SubstanceAmount.SubstanceAmountReferenceRangeComponent res = new SubstanceAmount.SubstanceAmountReferenceRangeComponent();
    parseSubstanceAmountSubstanceAmountReferenceRangeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseSubstanceAmountSubstanceAmountReferenceRangeComponentProperties(JsonObject json, SubstanceAmount owner, SubstanceAmount.SubstanceAmountReferenceRangeComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("lowLimit"))
      res.setLowLimit(parseQuantity(json.getAsJsonObject("lowLimit")));
    if (json.has("highLimit"))
      res.setHighLimit(parseQuantity(json.getAsJsonObject("highLimit")));
  }

  protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementDefinitionProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionProperties(JsonObject json, ElementDefinition res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("representation")) {
      JsonArray array = json.getAsJsonArray("representation");
      for (int i = 0; i < array.size(); i++) {
        res.getRepresentation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
      }
    };
    if (json.has("_representation")) {
      JsonArray array = json.getAsJsonArray("_representation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRepresentation().size())
          res.getRepresentation().add(parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getRepresentation().get(i));
      }
    };
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(json.getAsJsonObject("_sliceName"), res.getSliceNameElement());
    if (json.has("sliceIsConstraining"))
      res.setSliceIsConstrainingElement(parseBoolean(json.get("sliceIsConstraining").getAsBoolean()));
    if (json.has("_sliceIsConstraining"))
      parseElementProperties(json.getAsJsonObject("_sliceIsConstraining"), res.getSliceIsConstrainingElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("slicing"))
      res.setSlicing(parseElementDefinitionElementDefinitionSlicingComponent(json.getAsJsonObject("slicing"), res));
    if (json.has("short"))
      res.setShortElement(parseString(json.get("short").getAsString()));
    if (json.has("_short"))
      parseElementProperties(json.getAsJsonObject("_short"), res.getShortElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseMarkdown(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseMarkdown(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("base"))
      res.setBase(parseElementDefinitionElementDefinitionBaseComponent(json.getAsJsonObject("base"), res));
    if (json.has("contentReference"))
      res.setContentReferenceElement(parseUri(json.get("contentReference").getAsString()));
    if (json.has("_contentReference"))
      parseElementProperties(json.getAsJsonObject("_contentReference"), res.getContentReferenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseElementDefinitionTypeRefComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type defaultValue = parseType("defaultValue", json);
    if (defaultValue != null)
      res.setDefaultValue(defaultValue);
    if (json.has("meaningWhenMissing"))
      res.setMeaningWhenMissingElement(parseMarkdown(json.get("meaningWhenMissing").getAsString()));
    if (json.has("_meaningWhenMissing"))
      parseElementProperties(json.getAsJsonObject("_meaningWhenMissing"), res.getMeaningWhenMissingElement());
    if (json.has("orderMeaning"))
      res.setOrderMeaningElement(parseString(json.get("orderMeaning").getAsString()));
    if (json.has("_orderMeaning"))
      parseElementProperties(json.getAsJsonObject("_orderMeaning"), res.getOrderMeaningElement());
    Type fixed = parseType("fixed", json);
    if (fixed != null)
      res.setFixed(fixed);
    Type pattern = parseType("pattern", json);
    if (pattern != null)
      res.setPattern(pattern);
    if (json.has("example")) {
      JsonArray array = json.getAsJsonArray("example");
      for (int i = 0; i < array.size(); i++) {
        res.getExample().add(parseElementDefinitionElementDefinitionExampleComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type minValue = parseType("minValue", json);
    if (minValue != null)
      res.setMinValue(minValue);
    Type maxValue = parseType("maxValue", json);
    if (maxValue != null)
      res.setMaxValue(maxValue);
    if (json.has("maxLength"))
      res.setMaxLengthElement(parseInteger(json.get("maxLength").getAsLong()));
    if (json.has("_maxLength"))
      parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseId(array.get(i).getAsString()));
      }
    };
    if (json.has("_condition")) {
      JsonArray array = json.getAsJsonArray("_condition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCondition().size())
          res.getCondition().add(parseId(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
      }
    };
    if (json.has("constraint")) {
      JsonArray array = json.getAsJsonArray("constraint");
      for (int i = 0; i < array.size(); i++) {
        res.getConstraint().add(parseElementDefinitionElementDefinitionConstraintComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("mustSupport"))
      res.setMustSupportElement(parseBoolean(json.get("mustSupport").getAsBoolean()));
    if (json.has("_mustSupport"))
      parseElementProperties(json.getAsJsonObject("_mustSupport"), res.getMustSupportElement());
    if (json.has("isModifier"))
      res.setIsModifierElement(parseBoolean(json.get("isModifier").getAsBoolean()));
    if (json.has("_isModifier"))
      parseElementProperties(json.getAsJsonObject("_isModifier"), res.getIsModifierElement());
    if (json.has("isModifierReason"))
      res.setIsModifierReasonElement(parseString(json.get("isModifierReason").getAsString()));
    if (json.has("_isModifierReason"))
      parseElementProperties(json.getAsJsonObject("_isModifierReason"), res.getIsModifierReasonElement());
    if (json.has("isSummary"))
      res.setIsSummaryElement(parseBoolean(json.get("isSummary").getAsBoolean()));
    if (json.has("_isSummary"))
      parseElementProperties(json.getAsJsonObject("_isSummary"), res.getIsSummaryElement());
    if (json.has("binding"))
      res.setBinding(parseElementDefinitionElementDefinitionBindingComponent(json.getAsJsonObject("binding"), res));
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping().add(parseElementDefinitionElementDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementDefinitionElementDefinitionSlicingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionSlicingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("discriminator")) {
      JsonArray array = json.getAsJsonArray("discriminator");
      for (int i = 0; i < array.size(); i++) {
        res.getDiscriminator().add(parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("ordered"))
      res.setOrderedElement(parseBoolean(json.get("ordered").getAsBoolean()));
    if (json.has("_ordered"))
      parseElementProperties(json.getAsJsonObject("_ordered"), res.getOrderedElement());
    if (json.has("rules"))
      res.setRulesElement(parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
    if (json.has("_rules"))
      parseElementProperties(json.getAsJsonObject("_rules"), res.getRulesElement());
  }

  protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
    parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementDefinitionElementDefinitionBaseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionBaseComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionBaseComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementDefinitionTypeRefComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionTypeRefComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.TypeRefComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseUri(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    if (json.has("targetProfile")) {
      JsonArray array = json.getAsJsonArray("targetProfile");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetProfile().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_targetProfile")) {
      JsonArray array = json.getAsJsonArray("_targetProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTargetProfile().size())
          res.getTargetProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTargetProfile().get(i));
      }
    };
    if (json.has("aggregation")) {
      JsonArray array = json.getAsJsonArray("aggregation");
      for (int i = 0; i < array.size(); i++) {
        res.getAggregation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
      }
    };
    if (json.has("_aggregation")) {
      JsonArray array = json.getAsJsonArray("_aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAggregation().size())
          res.getAggregation().add(parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
  }

  protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionElementDefinitionExampleComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
    parseElementDefinitionElementDefinitionExampleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionExampleComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionExampleComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementDefinitionElementDefinitionConstraintComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionConstraintComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionConstraintComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseId(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(json.getAsJsonObject("_key"), res.getKeyElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("human"))
      res.setHumanElement(parseString(json.get("human").getAsString()));
    if (json.has("_human"))
      parseElementProperties(json.getAsJsonObject("_human"), res.getHumanElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("xpath"))
      res.setXpathElement(parseString(json.get("xpath").getAsString()));
    if (json.has("_xpath"))
      parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
    if (json.has("source"))
      res.setSourceElement(parseCanonical(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementDefinitionElementDefinitionBindingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionBindingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionBindingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementDefinitionElementDefinitionMappingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseElementDefinitionElementDefinitionMappingComponentProperties(JsonObject json, ElementDefinition owner, ElementDefinition.ElementDefinitionMappingComponent res) throws IOException, FHIRFormatError {
    parseTypeProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("map"))
      res.setMapElement(parseString(json.get("map").getAsString()));
    if (json.has("_map"))
      parseElementProperties(json.getAsJsonObject("_map"), res.getMapElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected SubstanceMoiety parseSubstanceMoiety(JsonObject json) throws IOException, FHIRFormatError {
    SubstanceMoiety res = new SubstanceMoiety();
    parseSubstanceMoietyProperties(json, res);
    return res;
  }

  protected void parseSubstanceMoietyProperties(JsonObject json, SubstanceMoiety res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("stereochemistry"))
      res.setStereochemistry(parseCodeableConcept(json.getAsJsonObject("stereochemistry")));
    if (json.has("opticalActivity"))
      res.setOpticalActivity(parseCodeableConcept(json.getAsJsonObject("opticalActivity")));
    if (json.has("molecularFormula"))
      res.setMolecularFormulaElement(parseString(json.get("molecularFormula").getAsString()));
    if (json.has("_molecularFormula"))
      parseElementProperties(json.getAsJsonObject("_molecularFormula"), res.getMolecularFormulaElement());
    if (json.has("amount"))
      res.setAmount(parseSubstanceAmount(json.getAsJsonObject("amount")));
  }

  protected ProductShelfLife parseProductShelfLife(JsonObject json) throws IOException, FHIRFormatError {
    ProductShelfLife res = new ProductShelfLife();
    parseProductShelfLifeProperties(json, res);
    return res;
  }

  protected void parseProductShelfLifeProperties(JsonObject json, ProductShelfLife res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("period"))
      res.setPeriod(parseQuantity(json.getAsJsonObject("period")));
    if (json.has("specialPrecautionsForStorage")) {
      JsonArray array = json.getAsJsonArray("specialPrecautionsForStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialPrecautionsForStorage().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ProdCharacteristic parseProdCharacteristic(JsonObject json) throws IOException, FHIRFormatError {
    ProdCharacteristic res = new ProdCharacteristic();
    parseProdCharacteristicProperties(json, res);
    return res;
  }

  protected void parseProdCharacteristicProperties(JsonObject json, ProdCharacteristic res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("height"))
      res.setHeight(parseQuantity(json.getAsJsonObject("height")));
    if (json.has("width"))
      res.setWidth(parseQuantity(json.getAsJsonObject("width")));
    if (json.has("depth"))
      res.setDepth(parseQuantity(json.getAsJsonObject("depth")));
    if (json.has("weight"))
      res.setWeight(parseQuantity(json.getAsJsonObject("weight")));
    if (json.has("nominalVolume"))
      res.setNominalVolume(parseQuantity(json.getAsJsonObject("nominalVolume")));
    if (json.has("externalDiameter"))
      res.setExternalDiameter(parseQuantity(json.getAsJsonObject("externalDiameter")));
    if (json.has("shape"))
      res.setShapeElement(parseString(json.get("shape").getAsString()));
    if (json.has("_shape"))
      parseElementProperties(json.getAsJsonObject("_shape"), res.getShapeElement());
    if (json.has("color")) {
      JsonArray array = json.getAsJsonArray("color");
      for (int i = 0; i < array.size(); i++) {
        res.getColor().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_color")) {
      JsonArray array = json.getAsJsonArray("_color");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getColor().size())
          res.getColor().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getColor().get(i));
      }
    };
    if (json.has("imprint")) {
      JsonArray array = json.getAsJsonArray("imprint");
      for (int i = 0; i < array.size(); i++) {
        res.getImprint().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_imprint")) {
      JsonArray array = json.getAsJsonArray("_imprint");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImprint().size())
          res.getImprint().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImprint().get(i));
      }
    };
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("scoring"))
      res.setScoring(parseCodeableConcept(json.getAsJsonObject("scoring")));
  }

  protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("text"))
      res.setText(parseNarrative(json.getAsJsonObject("text")));
    if (json.has("contained")) {
      JsonArray array = json.getAsJsonArray("contained");
      for (int i = 0; i < array.size(); i++) {
        res.getContained().add(parseResource(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        res.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Parameters parseParameters(JsonObject json) throws IOException, FHIRFormatError {
    Parameters res = new Parameters();
    parseParametersProperties(json, res);
    return res;
  }

  protected void parseParametersProperties(JsonObject json, Parameters res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(JsonObject json, Parameters owner) throws IOException, FHIRFormatError {
    Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
    parseParametersParametersParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseParametersParametersParameterComponentProperties(JsonObject json, Parameters owner, Parameters.ParametersParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("resource"))
      res.setResource(parseResource(json.getAsJsonObject("resource")));
    if (json.has("part")) {
      JsonArray array = json.getAsJsonArray("part");
      for (int i = 0; i < array.size(); i++) {
        res.getPart().add(parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
    if (json.has("id"))
      res.setIdElement(parseId(json.get("id").getAsString()));
    if (json.has("_id"))
      parseElementProperties(json.getAsJsonObject("_id"), res.getIdElement());
    if (json.has("meta"))
      res.setMeta(parseMeta(json.getAsJsonObject("meta")));
    if (json.has("implicitRules"))
      res.setImplicitRulesElement(parseUri(json.get("implicitRules").getAsString()));
    if (json.has("_implicitRules"))
      parseElementProperties(json.getAsJsonObject("_implicitRules"), res.getImplicitRulesElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
  }

  protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
    Account res = new Account();
    parseAccountProperties(json, res);
    return res;
  }

  protected void parseAccountProperties(JsonObject json, Account res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("servicePeriod"))
      res.setServicePeriod(parsePeriod(json.getAsJsonObject("servicePeriod")));
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseAccountCoverageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("guarantor")) {
      JsonArray array = json.getAsJsonArray("guarantor");
      for (int i = 0; i < array.size(); i++) {
        res.getGuarantor().add(parseAccountGuarantorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
  }

  protected Account.CoverageComponent parseAccountCoverageComponent(JsonObject json, Account owner) throws IOException, FHIRFormatError {
    Account.CoverageComponent res = new Account.CoverageComponent();
    parseAccountCoverageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAccountCoverageComponentProperties(JsonObject json, Account owner, Account.CoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("priority"))
      res.setPriorityElement(parsePositiveInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
  }

  protected Account.GuarantorComponent parseAccountGuarantorComponent(JsonObject json, Account owner) throws IOException, FHIRFormatError {
    Account.GuarantorComponent res = new Account.GuarantorComponent();
    parseAccountGuarantorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAccountGuarantorComponentProperties(JsonObject json, Account owner, Account.GuarantorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
    if (json.has("onHold"))
      res.setOnHoldElement(parseBoolean(json.get("onHold").getAsBoolean()));
    if (json.has("_onHold"))
      parseElementProperties(json.getAsJsonObject("_onHold"), res.getOnHoldElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected ActivityDefinition parseActivityDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition res = new ActivityDefinition();
    parseActivityDefinitionProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionProperties(JsonObject json, ActivityDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_library")) {
      JsonArray array = json.getAsJsonArray("_library");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLibrary().size())
          res.getLibrary().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLibrary().get(i));
      }
    };
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), ActivityDefinition.ActivityDefinitionKind.NULL, new ActivityDefinition.ActivityDefinitionKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), ActivityDefinition.RequestIntent.NULL, new ActivityDefinition.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), ActivityDefinition.RequestPriority.NULL, new ActivityDefinition.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseActivityDefinitionActivityDefinitionParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specimenRequirement")) {
      JsonArray array = json.getAsJsonArray("specimenRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimenRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("observationRequirement")) {
      JsonArray array = json.getAsJsonArray("observationRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getObservationRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("observationResultRequirement")) {
      JsonArray array = json.getAsJsonArray("observationResultRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getObservationResultRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("transform"))
      res.setTransformElement(parseCanonical(json.get("transform").getAsString()));
    if (json.has("_transform"))
      parseElementProperties(json.getAsJsonObject("_transform"), res.getTransformElement());
    if (json.has("dynamicValue")) {
      JsonArray array = json.getAsJsonArray("dynamicValue");
      for (int i = 0; i < array.size(); i++) {
        res.getDynamicValue().add(parseActivityDefinitionActivityDefinitionDynamicValueComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionActivityDefinitionParticipantComponent(JsonObject json, ActivityDefinition owner) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
    parseActivityDefinitionActivityDefinitionParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseActivityDefinitionActivityDefinitionParticipantComponentProperties(JsonObject json, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ActivityDefinition.ActivityParticipantType.NULL, new ActivityDefinition.ActivityParticipantTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
  }

  protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionActivityDefinitionDynamicValueComponent(JsonObject json, ActivityDefinition owner) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
    parseActivityDefinitionActivityDefinitionDynamicValueComponentProperties(json, owner, res);
    return res;
  }

  protected void parseActivityDefinitionActivityDefinitionDynamicValueComponentProperties(JsonObject json, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("expression"))
      res.setExpression(parseExpression(json.getAsJsonObject("expression")));
  }

  protected AdverseEvent parseAdverseEvent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent res = new AdverseEvent();
    parseAdverseEventProperties(json, res);
    return res;
  }

  protected void parseAdverseEventProperties(JsonObject json, AdverseEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("actuality"))
      res.setActualityElement(parseEnumeration(json.get("actuality").getAsString(), AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
    if (json.has("_actuality"))
      parseElementProperties(json.getAsJsonObject("_actuality"), res.getActualityElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("event"))
      res.setEvent(parseCodeableConcept(json.getAsJsonObject("event")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("detected"))
      res.setDetectedElement(parseDateTime(json.get("detected").getAsString()));
    if (json.has("_detected"))
      parseElementProperties(json.getAsJsonObject("_detected"), res.getDetectedElement());
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
    if (json.has("resultingCondition")) {
      JsonArray array = json.getAsJsonArray("resultingCondition");
      for (int i = 0; i < array.size(); i++) {
        res.getResultingCondition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("seriousness"))
      res.setSeriousness(parseCodeableConcept(json.getAsJsonObject("seriousness")));
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(json.getAsJsonObject("severity")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("suspectEntity")) {
      JsonArray array = json.getAsJsonArray("suspectEntity");
      for (int i = 0; i < array.size(); i++) {
        res.getSuspectEntity().add(parseAdverseEventAdverseEventSuspectEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("subjectMedicalHistory")) {
      JsonArray array = json.getAsJsonArray("subjectMedicalHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getSubjectMedicalHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referenceDocument")) {
      JsonArray array = json.getAsJsonArray("referenceDocument");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceDocument().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("study")) {
      JsonArray array = json.getAsJsonArray("study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventAdverseEventSuspectEntityComponent(JsonObject json, AdverseEvent owner) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
    parseAdverseEventAdverseEventSuspectEntityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAdverseEventAdverseEventSuspectEntityComponentProperties(JsonObject json, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("instance"))
      res.setInstance(parseReference(json.getAsJsonObject("instance")));
    if (json.has("causality")) {
      JsonArray array = json.getAsJsonArray("causality");
      for (int i = 0; i < array.size(); i++) {
        res.getCausality().add(parseAdverseEventAdverseEventSuspectEntityCausalityComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventAdverseEventSuspectEntityCausalityComponent(JsonObject json, AdverseEvent owner) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
    parseAdverseEventAdverseEventSuspectEntityCausalityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAdverseEventAdverseEventSuspectEntityCausalityComponentProperties(JsonObject json, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("assessment"))
      res.setAssessment(parseCodeableConcept(json.getAsJsonObject("assessment")));
    if (json.has("productRelatedness"))
      res.setProductRelatednessElement(parseString(json.get("productRelatedness").getAsString()));
    if (json.has("_productRelatedness"))
      parseElementProperties(json.getAsJsonObject("_productRelatedness"), res.getProductRelatednessElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
  }

  protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseAllergyIntoleranceProperties(json, res);
    return res;
  }

  protected void parseAllergyIntoleranceProperties(JsonObject json, AllergyIntolerance res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatusElement(parseEnumeration(json.get("clinicalStatus").getAsString(), AllergyIntolerance.AllergyIntoleranceClinicalStatus.NULL, new AllergyIntolerance.AllergyIntoleranceClinicalStatusEnumFactory()));
    if (json.has("_clinicalStatus"))
      parseElementProperties(json.getAsJsonObject("_clinicalStatus"), res.getClinicalStatusElement());
    if (json.has("verificationStatus"))
      res.setVerificationStatusElement(parseEnumeration(json.get("verificationStatus").getAsString(), AllergyIntolerance.AllergyIntoleranceVerificationStatus.NULL, new AllergyIntolerance.AllergyIntoleranceVerificationStatusEnumFactory()));
    if (json.has("_verificationStatus"))
      parseElementProperties(json.getAsJsonObject("_verificationStatus"), res.getVerificationStatusElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseEnumeration(array.get(i).getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
      }
    };
    if (json.has("_category")) {
      JsonArray array = json.getAsJsonArray("_category");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCategory().size())
          res.getCategory().add(parseEnumeration(null, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCategory().get(i));
      }
    };
    if (json.has("criticality"))
      res.setCriticalityElement(parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
    if (json.has("_criticality"))
      parseElementProperties(json.getAsJsonObject("_criticality"), res.getCriticalityElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("asserter"))
      res.setAsserter(parseReference(json.getAsJsonObject("asserter")));
    if (json.has("lastOccurrence"))
      res.setLastOccurrenceElement(parseDateTime(json.get("lastOccurrence").getAsString()));
    if (json.has("_lastOccurrence"))
      parseElementProperties(json.getAsJsonObject("_lastOccurrence"), res.getLastOccurrenceElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseAllergyIntoleranceAllergyIntoleranceReactionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(JsonObject json, AllergyIntolerance owner) throws IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseAllergyIntoleranceAllergyIntoleranceReactionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAllergyIntoleranceAllergyIntoleranceReactionComponentProperties(JsonObject json, AllergyIntolerance owner, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("manifestation")) {
      JsonArray array = json.getAsJsonArray("manifestation");
      for (int i = 0; i < array.size(); i++) {
        res.getManifestation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("onset"))
      res.setOnsetElement(parseDateTime(json.get("onset").getAsString()));
    if (json.has("_onset"))
      parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("exposureRoute"))
      res.setExposureRoute(parseCodeableConcept(json.getAsJsonObject("exposureRoute")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseAppointmentProperties(json, res);
    return res;
  }

  protected void parseAppointmentProperties(JsonObject json, Appointment res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("serviceCategory")) {
      JsonArray array = json.getAsJsonArray("serviceCategory");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentType"))
      res.setAppointmentType(parseCodeableConcept(json.getAsJsonObject("appointmentType")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("indication")) {
      JsonArray array = json.getAsJsonArray("indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseUnsignedInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("minutesDuration"))
      res.setMinutesDurationElement(parsePositiveInt(json.get("minutesDuration").getAsString()));
    if (json.has("_minutesDuration"))
      parseElementProperties(json.getAsJsonObject("_minutesDuration"), res.getMinutesDurationElement());
    if (json.has("slot")) {
      JsonArray array = json.getAsJsonArray("slot");
      for (int i = 0; i < array.size(); i++) {
        res.getSlot().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("patientInstruction"))
      res.setPatientInstructionElement(parseString(json.get("patientInstruction").getAsString()));
    if (json.has("_patientInstruction"))
      parseElementProperties(json.getAsJsonObject("_patientInstruction"), res.getPatientInstructionElement());
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAppointmentAppointmentParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("requestedPeriod")) {
      JsonArray array = json.getAsJsonArray("requestedPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getRequestedPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(JsonObject json, Appointment owner) throws IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseAppointmentAppointmentParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAppointmentAppointmentParticipantComponentProperties(JsonObject json, Appointment owner, Appointment.AppointmentParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("required"))
      res.setRequiredElement(parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseAppointmentResponseProperties(json, res);
    return res;
  }

  protected void parseAppointmentResponseProperties(JsonObject json, AppointmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointment"))
      res.setAppointment(parseReference(json.getAsJsonObject("appointment")));
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("participantType")) {
      JsonArray array = json.getAsJsonArray("participantType");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipantType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("participantStatus"))
      res.setParticipantStatusElement(parseEnumeration(json.get("participantStatus").getAsString(), AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
    if (json.has("_participantStatus"))
      parseElementProperties(json.getAsJsonObject("_participantStatus"), res.getParticipantStatusElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseAuditEventProperties(json, res);
    return res;
  }

  protected void parseAuditEventProperties(JsonObject json, AuditEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("subtype")) {
      JsonArray array = json.getAsJsonArray("subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action"))
      res.setActionElement(parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
    if (json.has("_action"))
      parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("recorded"))
      res.setRecordedElement(parseInstant(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("outcomeDesc"))
      res.setOutcomeDescElement(parseString(json.get("outcomeDesc").getAsString()));
    if (json.has("_outcomeDesc"))
      parseElementProperties(json.getAsJsonObject("_outcomeDesc"), res.getOutcomeDescElement());
    if (json.has("purposeOfEvent")) {
      JsonArray array = json.getAsJsonArray("purposeOfEvent");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseAuditEventAuditEventAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("source"))
      res.setSource(parseAuditEventAuditEventSourceComponent(json.getAsJsonObject("source"), res));
    if (json.has("entity")) {
      JsonArray array = json.getAsJsonArray("entity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntity().add(parseAuditEventAuditEventEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseAuditEventAuditEventAgentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventAgentComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("who"))
      res.setWho(parseReference(json.getAsJsonObject("who")));
    if (json.has("altId"))
      res.setAltIdElement(parseString(json.get("altId").getAsString()));
    if (json.has("_altId"))
      parseElementProperties(json.getAsJsonObject("_altId"), res.getAltIdElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("requestor"))
      res.setRequestorElement(parseBoolean(json.get("requestor").getAsBoolean()));
    if (json.has("_requestor"))
      parseElementProperties(json.getAsJsonObject("_requestor"), res.getRequestorElement());
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_policy")) {
      JsonArray array = json.getAsJsonArray("_policy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPolicy().size())
          res.getPolicy().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
      }
    };
    if (json.has("media"))
      res.setMedia(parseCoding(json.getAsJsonObject("media")));
    if (json.has("network"))
      res.setNetwork(parseAuditEventAuditEventAgentNetworkComponent(json.getAsJsonObject("network"), owner));
    if (json.has("purposeOfUse")) {
      JsonArray array = json.getAsJsonArray("purposeOfUse");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfUse().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
    parseAuditEventAuditEventAgentNetworkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventAgentNetworkComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventAgentNetworkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("address"))
      res.setAddressElement(parseString(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseAuditEventAuditEventSourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventSourceComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("site"))
      res.setSiteElement(parseString(json.get("site").getAsString()));
    if (json.has("_site"))
      parseElementProperties(json.getAsJsonObject("_site"), res.getSiteElement());
    if (json.has("observer"))
      res.setObserver(parseReference(json.getAsJsonObject("observer")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseAuditEventAuditEventEntityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventEntityComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("what"))
      res.setWhat(parseReference(json.getAsJsonObject("what")));
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("role"))
      res.setRole(parseCoding(json.getAsJsonObject("role")));
    if (json.has("lifecycle"))
      res.setLifecycle(parseCoding(json.getAsJsonObject("lifecycle")));
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("query"))
      res.setQueryElement(parseBase64Binary(json.get("query").getAsString()));
    if (json.has("_query"))
      parseElementProperties(json.getAsJsonObject("_query"), res.getQueryElement());
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseAuditEventAuditEventEntityDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseAuditEventAuditEventEntityDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseAuditEventAuditEventEntityDetailComponentProperties(JsonObject json, AuditEvent owner, AuditEvent.AuditEventEntityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
    Basic res = new Basic();
    parseBasicProperties(json, res);
    return res;
  }

  protected void parseBasicProperties(JsonObject json, Basic res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDate(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
    Binary res = new Binary();
    parseBinaryProperties(json, res);
    return res;
  }

  protected void parseBinaryProperties(JsonObject json, Binary res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("securityContext"))
      res.setSecurityContext(parseReference(json.getAsJsonObject("securityContext")));
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
  }

  protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
    parseBiologicallyDerivedProductProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductProperties(JsonObject json, BiologicallyDerivedProduct res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productCategory"))
      res.setProductCategoryElement(parseEnumeration(json.get("productCategory").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory()));
    if (json.has("_productCategory"))
      parseElementProperties(json.getAsJsonObject("_productCategory"), res.getProductCategoryElement());
    if (json.has("productCode"))
      res.setProductCode(parseCodeableConcept(json.getAsJsonObject("productCode")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("request")) {
      JsonArray array = json.getAsJsonArray("request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantityElement(parseInteger(json.get("quantity").getAsLong()));
    if (json.has("_quantity"))
      parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("collection"))
      res.setCollection(parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(json.getAsJsonObject("collection"), res));
    if (json.has("processing")) {
      JsonArray array = json.getAsJsonArray("processing");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessing().add(parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("manipulation"))
      res.setManipulation(parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(json.getAsJsonObject("manipulation"), res));
    if (json.has("storage")) {
      JsonArray array = json.getAsJsonArray("storage");
      for (int i = 0; i < array.size(); i++) {
        res.getStorage().add(parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(JsonObject json, BiologicallyDerivedProduct owner) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
    parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponentProperties(JsonObject json, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("collector"))
      res.setCollector(parseReference(json.getAsJsonObject("collector")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    Type collected = parseType("collected", json);
    if (collected != null)
      res.setCollected(collected);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(JsonObject json, BiologicallyDerivedProduct owner) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
    parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponentProperties(JsonObject json, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("procedure"))
      res.setProcedure(parseCodeableConcept(json.getAsJsonObject("procedure")));
    if (json.has("additive"))
      res.setAdditive(parseReference(json.getAsJsonObject("additive")));
    Type time = parseType("time", json);
    if (time != null)
      res.setTime(time);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(JsonObject json, BiologicallyDerivedProduct owner) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
    parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponentProperties(JsonObject json, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    Type time = parseType("time", json);
    if (time != null)
      res.setTime(time);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(JsonObject json, BiologicallyDerivedProduct owner) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
    parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponentProperties(JsonObject json, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("temperature"))
      res.setTemperatureElement(parseDecimal(json.get("temperature").getAsBigDecimal()));
    if (json.has("_temperature"))
      parseElementProperties(json.getAsJsonObject("_temperature"), res.getTemperatureElement());
    if (json.has("scale"))
      res.setScaleElement(parseEnumeration(json.get("scale").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory()));
    if (json.has("_scale"))
      parseElementProperties(json.getAsJsonObject("_scale"), res.getScaleElement());
    if (json.has("duration"))
      res.setDuration(parsePeriod(json.getAsJsonObject("duration")));
  }

  protected BodyStructure parseBodyStructure(JsonObject json) throws IOException, FHIRFormatError {
    BodyStructure res = new BodyStructure();
    parseBodyStructureProperties(json, res);
    return res;
  }

  protected void parseBodyStructureProperties(JsonObject json, BodyStructure res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("morphology"))
      res.setMorphology(parseCodeableConcept(json.getAsJsonObject("morphology")));
    if (json.has("location"))
      res.setLocation(parseCodeableConcept(json.getAsJsonObject("location")));
    if (json.has("locationQualifier")) {
      JsonArray array = json.getAsJsonArray("locationQualifier");
      for (int i = 0; i < array.size(); i++) {
        res.getLocationQualifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
  }

  protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseBundleProperties(json, res);
    return res;
  }

  protected void parseBundleProperties(JsonObject json, Bundle res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("timestamp"))
      res.setTimestampElement(parseInstant(json.get("timestamp").getAsString()));
    if (json.has("_timestamp"))
      parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
    if (json.has("total"))
      res.setTotalElement(parseUnsignedInt(json.get("total").getAsString()));
    if (json.has("_total"))
      parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseBundleBundleEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("signature"))
      res.setSignature(parseSignature(json.getAsJsonObject("signature")));
  }

  protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseBundleBundleLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleLinkComponentProperties(JsonObject json, Bundle owner, Bundle.BundleLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relation"))
      res.setRelationElement(parseString(json.get("relation").getAsString()));
    if (json.has("_relation"))
      parseElementProperties(json.getAsJsonObject("_relation"), res.getRelationElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
  }

  protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseBundleBundleEntryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("fullUrl"))
      res.setFullUrlElement(parseUri(json.get("fullUrl").getAsString()));
    if (json.has("_fullUrl"))
      parseElementProperties(json.getAsJsonObject("_fullUrl"), res.getFullUrlElement());
    if (json.has("resource"))
      res.setResource(parseResource(json.getAsJsonObject("resource")));
    if (json.has("search"))
      res.setSearch(parseBundleBundleEntrySearchComponent(json.getAsJsonObject("search"), owner));
    if (json.has("request"))
      res.setRequest(parseBundleBundleEntryRequestComponent(json.getAsJsonObject("request"), owner));
    if (json.has("response"))
      res.setResponse(parseBundleBundleEntryResponseComponent(json.getAsJsonObject("response"), owner));
  }

  protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseBundleBundleEntrySearchComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntrySearchComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntrySearchComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("score"))
      res.setScoreElement(parseDecimal(json.get("score").getAsBigDecimal()));
    if (json.has("_score"))
      parseElementProperties(json.getAsJsonObject("_score"), res.getScoreElement());
  }

  protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseBundleBundleEntryRequestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryRequestComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("method"))
      res.setMethodElement(parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
    if (json.has("_method"))
      parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("ifNoneMatch"))
      res.setIfNoneMatchElement(parseString(json.get("ifNoneMatch").getAsString()));
    if (json.has("_ifNoneMatch"))
      parseElementProperties(json.getAsJsonObject("_ifNoneMatch"), res.getIfNoneMatchElement());
    if (json.has("ifModifiedSince"))
      res.setIfModifiedSinceElement(parseInstant(json.get("ifModifiedSince").getAsString()));
    if (json.has("_ifModifiedSince"))
      parseElementProperties(json.getAsJsonObject("_ifModifiedSince"), res.getIfModifiedSinceElement());
    if (json.has("ifMatch"))
      res.setIfMatchElement(parseString(json.get("ifMatch").getAsString()));
    if (json.has("_ifMatch"))
      parseElementProperties(json.getAsJsonObject("_ifMatch"), res.getIfMatchElement());
    if (json.has("ifNoneExist"))
      res.setIfNoneExistElement(parseString(json.get("ifNoneExist").getAsString()));
    if (json.has("_ifNoneExist"))
      parseElementProperties(json.getAsJsonObject("_ifNoneExist"), res.getIfNoneExistElement());
  }

  protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseBundleBundleEntryResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseBundleBundleEntryResponseComponentProperties(JsonObject json, Bundle owner, Bundle.BundleEntryResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseString(json.get("status").getAsString()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("location"))
      res.setLocationElement(parseUri(json.get("location").getAsString()));
    if (json.has("_location"))
      parseElementProperties(json.getAsJsonObject("_location"), res.getLocationElement());
    if (json.has("etag"))
      res.setEtagElement(parseString(json.get("etag").getAsString()));
    if (json.has("_etag"))
      parseElementProperties(json.getAsJsonObject("_etag"), res.getEtagElement());
    if (json.has("lastModified"))
      res.setLastModifiedElement(parseInstant(json.get("lastModified").getAsString()));
    if (json.has("_lastModified"))
      parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
    if (json.has("outcome"))
      res.setOutcome(parseResource(json.getAsJsonObject("outcome")));
  }

  protected CapabilityStatement parseCapabilityStatement(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement res = new CapabilityStatement();
    parseCapabilityStatementProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementProperties(JsonObject json, CapabilityStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), CapabilityStatement.CapabilityStatementKind.NULL, new CapabilityStatement.CapabilityStatementKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiates().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("imports")) {
      JsonArray array = json.getAsJsonArray("imports");
      for (int i = 0; i < array.size(); i++) {
        res.getImports().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_imports")) {
      JsonArray array = json.getAsJsonArray("_imports");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImports().size())
          res.getImports().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImports().get(i));
      }
    };
    if (json.has("software"))
      res.setSoftware(parseCapabilityStatementCapabilityStatementSoftwareComponent(json.getAsJsonObject("software"), res));
    if (json.has("implementation"))
      res.setImplementation(parseCapabilityStatementCapabilityStatementImplementationComponent(json.getAsJsonObject("implementation"), res));
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseId(json.get("fhirVersion").getAsString()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("format")) {
      JsonArray array = json.getAsJsonArray("format");
      for (int i = 0; i < array.size(); i++) {
        res.getFormat().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_format")) {
      JsonArray array = json.getAsJsonArray("_format");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFormat().size())
          res.getFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
      }
    };
    if (json.has("patchFormat")) {
      JsonArray array = json.getAsJsonArray("patchFormat");
      for (int i = 0; i < array.size(); i++) {
        res.getPatchFormat().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_patchFormat")) {
      JsonArray array = json.getAsJsonArray("_patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPatchFormat().size())
          res.getPatchFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPatchFormat().get(i));
      }
    };
    if (json.has("implementationGuide")) {
      JsonArray array = json.getAsJsonArray("implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        res.getImplementationGuide().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_implementationGuide")) {
      JsonArray array = json.getAsJsonArray("_implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImplementationGuide().size())
          res.getImplementationGuide().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImplementationGuide().get(i));
      }
    };
    if (json.has("rest")) {
      JsonArray array = json.getAsJsonArray("rest");
      for (int i = 0; i < array.size(); i++) {
        res.getRest().add(parseCapabilityStatementCapabilityStatementRestComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("messaging")) {
      JsonArray array = json.getAsJsonArray("messaging");
      for (int i = 0; i < array.size(); i++) {
        res.getMessaging().add(parseCapabilityStatementCapabilityStatementMessagingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("document")) {
      JsonArray array = json.getAsJsonArray("document");
      for (int i = 0; i < array.size(); i++) {
        res.getDocument().add(parseCapabilityStatementCapabilityStatementDocumentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementCapabilityStatementSoftwareComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
    parseCapabilityStatementCapabilityStatementSoftwareComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementSoftwareComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("releaseDate"))
      res.setReleaseDateElement(parseDateTime(json.get("releaseDate").getAsString()));
    if (json.has("_releaseDate"))
      parseElementProperties(json.getAsJsonObject("_releaseDate"), res.getReleaseDateElement());
  }

  protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementCapabilityStatementImplementationComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
    parseCapabilityStatementCapabilityStatementImplementationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementImplementationComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementImplementationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
  }

  protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementCapabilityStatementRestComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
    parseCapabilityStatementCapabilityStatementRestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("security"))
      res.setSecurity(parseCapabilityStatementCapabilityStatementRestSecurityComponent(json.getAsJsonObject("security"), owner));
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCapabilityStatementCapabilityStatementRestResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementSystemInteractionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        res.getCompartment().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_compartment")) {
      JsonArray array = json.getAsJsonArray("_compartment");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCompartment().size())
          res.getCompartment().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementCapabilityStatementRestSecurityComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
    parseCapabilityStatementCapabilityStatementRestSecurityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestSecurityComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("cors"))
      res.setCorsElement(parseBoolean(json.get("cors").getAsBoolean()));
    if (json.has("_cors"))
      parseElementProperties(json.getAsJsonObject("_cors"), res.getCorsElement());
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementCapabilityStatementRestResourceComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
    parseCapabilityStatementCapabilityStatementRestResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestResourceComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("supportedProfile")) {
      JsonArray array = json.getAsJsonArray("supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportedProfile().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_supportedProfile")) {
      JsonArray array = json.getAsJsonArray("_supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportedProfile().size())
          res.getSupportedProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportedProfile().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementResourceInteractionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
    if (json.has("readHistory"))
      res.setReadHistoryElement(parseBoolean(json.get("readHistory").getAsBoolean()));
    if (json.has("_readHistory"))
      parseElementProperties(json.getAsJsonObject("_readHistory"), res.getReadHistoryElement());
    if (json.has("updateCreate"))
      res.setUpdateCreateElement(parseBoolean(json.get("updateCreate").getAsBoolean()));
    if (json.has("_updateCreate"))
      parseElementProperties(json.getAsJsonObject("_updateCreate"), res.getUpdateCreateElement());
    if (json.has("conditionalCreate"))
      res.setConditionalCreateElement(parseBoolean(json.get("conditionalCreate").getAsBoolean()));
    if (json.has("_conditionalCreate"))
      parseElementProperties(json.getAsJsonObject("_conditionalCreate"), res.getConditionalCreateElement());
    if (json.has("conditionalRead"))
      res.setConditionalReadElement(parseEnumeration(json.get("conditionalRead").getAsString(), CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
    if (json.has("_conditionalRead"))
      parseElementProperties(json.getAsJsonObject("_conditionalRead"), res.getConditionalReadElement());
    if (json.has("conditionalUpdate"))
      res.setConditionalUpdateElement(parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
    if (json.has("_conditionalUpdate"))
      parseElementProperties(json.getAsJsonObject("_conditionalUpdate"), res.getConditionalUpdateElement());
    if (json.has("conditionalDelete"))
      res.setConditionalDeleteElement(parseEnumeration(json.get("conditionalDelete").getAsString(), CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
    if (json.has("_conditionalDelete"))
      parseElementProperties(json.getAsJsonObject("_conditionalDelete"), res.getConditionalDeleteElement());
    if (json.has("referencePolicy")) {
      JsonArray array = json.getAsJsonArray("referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        res.getReferencePolicy().add(parseEnumeration(array.get(i).getAsString(), CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
      }
    };
    if (json.has("_referencePolicy")) {
      JsonArray array = json.getAsJsonArray("_referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReferencePolicy().size())
          res.getReferencePolicy().add(parseEnumeration(null, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReferencePolicy().get(i));
      }
    };
    if (json.has("searchInclude")) {
      JsonArray array = json.getAsJsonArray("searchInclude");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchInclude().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_searchInclude")) {
      JsonArray array = json.getAsJsonArray("_searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchInclude().size())
          res.getSearchInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
      }
    };
    if (json.has("searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchRevInclude().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("_searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchRevInclude().size())
          res.getSearchRevInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
    parseCapabilityStatementResourceInteractionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementResourceInteractionComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
    parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
    parseCapabilityStatementCapabilityStatementRestResourceOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementRestResourceOperationComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
    parseCapabilityStatementSystemInteractionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementSystemInteractionComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.SystemInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementCapabilityStatementMessagingComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
    parseCapabilityStatementCapabilityStatementMessagingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("reliableCache"))
      res.setReliableCacheElement(parseUnsignedInt(json.get("reliableCache").getAsString()));
    if (json.has("_reliableCache"))
      parseElementProperties(json.getAsJsonObject("_reliableCache"), res.getReliableCacheElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("supportedMessage")) {
      JsonArray array = json.getAsJsonArray("supportedMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportedMessage().add(parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
    parseCapabilityStatementCapabilityStatementMessagingEndpointComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingEndpointComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("protocol"))
      res.setProtocol(parseCoding(json.getAsJsonObject("protocol")));
    if (json.has("address"))
      res.setAddressElement(parseUrl(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
    parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
  }

  protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementCapabilityStatementDocumentComponent(JsonObject json, CapabilityStatement owner) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
    parseCapabilityStatementCapabilityStatementDocumentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCapabilityStatementCapabilityStatementDocumentComponentProperties(JsonObject json, CapabilityStatement owner, CapabilityStatement.CapabilityStatementDocumentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
  }

  protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseCarePlanProperties(json, res);
    return res;
  }

  protected void parseCarePlanProperties(JsonObject json, CarePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("activity")) {
      JsonArray array = json.getAsJsonArray("activity");
      for (int i = 0; i < array.size(); i++) {
        res.getActivity().add(parseCarePlanCarePlanActivityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseCarePlanCarePlanActivityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCarePlanCarePlanActivityComponentProperties(JsonObject json, CarePlan owner, CarePlan.CarePlanActivityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("outcomeCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("outcomeCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeReference")) {
      JsonArray array = json.getAsJsonArray("outcomeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("progress")) {
      JsonArray array = json.getAsJsonArray("progress");
      for (int i = 0; i < array.size(); i++) {
        res.getProgress().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("detail"))
      res.setDetail(parseCarePlanCarePlanActivityDetailComponent(json.getAsJsonObject("detail"), owner));
  }

  protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
    parseCarePlanCarePlanActivityDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCarePlanCarePlanActivityDetailComponentProperties(JsonObject json, CarePlan owner, CarePlan.CarePlanActivityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    Type scheduled = parseType("scheduled", json);
    if (scheduled != null)
      res.setScheduled(scheduled);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("dailyAmount"))
      res.setDailyAmount(parseQuantity(json.getAsJsonObject("dailyAmount")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseCareTeamProperties(json, res);
    return res;
  }

  protected void parseCareTeamProperties(JsonObject json, CareTeam res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseCareTeamCareTeamParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("managingOrganization")) {
      JsonArray array = json.getAsJsonArray("managingOrganization");
      for (int i = 0; i < array.size(); i++) {
        res.getManagingOrganization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(JsonObject json, CareTeam owner) throws IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseCareTeamCareTeamParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCareTeamCareTeamParticipantComponentProperties(JsonObject json, CareTeam owner, CareTeam.CareTeamParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("member"))
      res.setMember(parseReference(json.getAsJsonObject("member")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected CatalogEntry parseCatalogEntry(JsonObject json) throws IOException, FHIRFormatError {
    CatalogEntry res = new CatalogEntry();
    parseCatalogEntryProperties(json, res);
    return res;
  }

  protected void parseCatalogEntryProperties(JsonObject json, CatalogEntry res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("orderable"))
      res.setOrderableElement(parseBoolean(json.get("orderable").getAsBoolean()));
    if (json.has("_orderable"))
      parseElementProperties(json.getAsJsonObject("_orderable"), res.getOrderableElement());
    if (json.has("referencedItem"))
      res.setReferencedItem(parseReference(json.getAsJsonObject("referencedItem")));
    if (json.has("additionalIdentifier")) {
      JsonArray array = json.getAsJsonArray("additionalIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("classification")) {
      JsonArray array = json.getAsJsonArray("classification");
      for (int i = 0; i < array.size(); i++) {
        res.getClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(json.getAsJsonObject("validityPeriod")));
    if (json.has("validTo"))
      res.setValidToElement(parseDateTime(json.get("validTo").getAsString()));
    if (json.has("_validTo"))
      parseElementProperties(json.getAsJsonObject("_validTo"), res.getValidToElement());
    if (json.has("lastUpdated"))
      res.setLastUpdatedElement(parseDateTime(json.get("lastUpdated").getAsString()));
    if (json.has("_lastUpdated"))
      parseElementProperties(json.getAsJsonObject("_lastUpdated"), res.getLastUpdatedElement());
    if (json.has("additionalCharacteristic")) {
      JsonArray array = json.getAsJsonArray("additionalCharacteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalCharacteristic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("additionalClassification")) {
      JsonArray array = json.getAsJsonArray("additionalClassification");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedEntry")) {
      JsonArray array = json.getAsJsonArray("relatedEntry");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedEntry().add(parseCatalogEntryCatalogEntryRelatedEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CatalogEntry.CatalogEntryRelatedEntryComponent parseCatalogEntryCatalogEntryRelatedEntryComponent(JsonObject json, CatalogEntry owner) throws IOException, FHIRFormatError {
    CatalogEntry.CatalogEntryRelatedEntryComponent res = new CatalogEntry.CatalogEntryRelatedEntryComponent();
    parseCatalogEntryCatalogEntryRelatedEntryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCatalogEntryCatalogEntryRelatedEntryComponentProperties(JsonObject json, CatalogEntry owner, CatalogEntry.CatalogEntryRelatedEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relationtype"))
      res.setRelationtypeElement(parseEnumeration(json.get("relationtype").getAsString(), CatalogEntry.CatalogEntryRelationType.NULL, new CatalogEntry.CatalogEntryRelationTypeEnumFactory()));
    if (json.has("_relationtype"))
      parseElementProperties(json.getAsJsonObject("_relationtype"), res.getRelationtypeElement());
    if (json.has("item"))
      res.setItem(parseReference(json.getAsJsonObject("item")));
  }

  protected ChargeItem parseChargeItem(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItem res = new ChargeItem();
    parseChargeItemProperties(json, res);
    return res;
  }

  protected void parseChargeItemProperties(JsonObject json, ChargeItem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_definition")) {
      JsonArray array = json.getAsJsonArray("_definition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinition().size())
          res.getDefinition().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseChargeItemChargeItemPerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("performingOrganization"))
      res.setPerformingOrganization(parseReference(json.getAsJsonObject("performingOrganization")));
    if (json.has("requestingOrganization"))
      res.setRequestingOrganization(parseReference(json.getAsJsonObject("requestingOrganization")));
    if (json.has("costCenter"))
      res.setCostCenter(parseReference(json.getAsJsonObject("costCenter")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("bodysite")) {
      JsonArray array = json.getAsJsonArray("bodysite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodysite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("factorOverride"))
      res.setFactorOverrideElement(parseDecimal(json.get("factorOverride").getAsBigDecimal()));
    if (json.has("_factorOverride"))
      parseElementProperties(json.getAsJsonObject("_factorOverride"), res.getFactorOverrideElement());
    if (json.has("priceOverride"))
      res.setPriceOverride(parseMoney(json.getAsJsonObject("priceOverride")));
    if (json.has("overrideReason"))
      res.setOverrideReasonElement(parseString(json.get("overrideReason").getAsString()));
    if (json.has("_overrideReason"))
      parseElementProperties(json.getAsJsonObject("_overrideReason"), res.getOverrideReasonElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("enteredDate"))
      res.setEnteredDateElement(parseDateTime(json.get("enteredDate").getAsString()));
    if (json.has("_enteredDate"))
      parseElementProperties(json.getAsJsonObject("_enteredDate"), res.getEnteredDateElement());
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ChargeItem.ChargeItemPerformerComponent parseChargeItemChargeItemPerformerComponent(JsonObject json, ChargeItem owner) throws IOException, FHIRFormatError {
    ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
    parseChargeItemChargeItemPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemChargeItemPerformerComponentProperties(JsonObject json, ChargeItem owner, ChargeItem.ChargeItemPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected ChargeItemDefinition parseChargeItemDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition res = new ChargeItemDefinition();
    parseChargeItemDefinitionProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionProperties(JsonObject json, ChargeItemDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("derivedFromUri")) {
      JsonArray array = json.getAsJsonArray("derivedFromUri");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFromUri().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_derivedFromUri")) {
      JsonArray array = json.getAsJsonArray("_derivedFromUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDerivedFromUri().size())
          res.getDerivedFromUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDerivedFromUri().get(i));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_partOf")) {
      JsonArray array = json.getAsJsonArray("_partOf");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPartOf().size())
          res.getPartOf().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPartOf().get(i));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_replaces")) {
      JsonArray array = json.getAsJsonArray("_replaces");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReplaces().size())
          res.getReplaces().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReplaces().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("applicability")) {
      JsonArray array = json.getAsJsonArray("applicability");
      for (int i = 0; i < array.size(); i++) {
        res.getApplicability().add(parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("propertyGroup")) {
      JsonArray array = json.getAsJsonArray("propertyGroup");
      for (int i = 0; i < array.size(); i++) {
        res.getPropertyGroup().add(parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(JsonObject json, ChargeItemDefinition owner) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
    parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponentProperties(JsonObject json, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("language"))
      res.setLanguageElement(parseString(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(JsonObject json, ChargeItemDefinition owner) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
    parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponentProperties(JsonObject json, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("applicability")) {
      JsonArray array = json.getAsJsonArray("applicability");
      for (int i = 0; i < array.size(); i++) {
        res.getApplicability().add(parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("priceComponent")) {
      JsonArray array = json.getAsJsonArray("priceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getPriceComponent().add(parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(JsonObject json, ChargeItemDefinition owner) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
    parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponentProperties(JsonObject json, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.NULL, new ChargeItemDefinition.ChargeItemDefinitionPriceComponentTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
    Claim res = new Claim();
    parseClaimProperties(json, res);
    return res;
  }

  protected void parseClaimProperties(JsonObject json, Claim res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Claim.ClaimStatus.NULL, new Claim.ClaimStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Claim.Use.NULL, new Claim.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(json.getAsJsonObject("billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(json.getAsJsonObject("fundsReserve")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseClaimRelatedClaimComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(json.getAsJsonObject("prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(json.getAsJsonObject("originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseClaimPayeeComponent(json.getAsJsonObject("payee"), res));
    if (json.has("referral"))
      res.setReferral(parseReference(json.getAsJsonObject("referral")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseClaimCareTeamComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("information")) {
      JsonArray array = json.getAsJsonArray("information");
      for (int i = 0; i < array.size(); i++) {
        res.getInformation().add(parseClaimSpecialConditionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseClaimDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseClaimProcedureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseClaimAccidentComponent(json.getAsJsonObject("accident"), res));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("total"))
      res.setTotal(parseMoney(json.getAsJsonObject("total")));
  }

  protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
    parseClaimRelatedClaimComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimRelatedClaimComponentProperties(JsonObject json, Claim owner, Claim.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(json.getAsJsonObject("reference")));
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseClaimPayeeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimPayeeComponentProperties(JsonObject json, Claim owner, Claim.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("resource"))
      res.setResource(parseCoding(json.getAsJsonObject("resource")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected Claim.CareTeamComponent parseClaimCareTeamComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.CareTeamComponent res = new Claim.CareTeamComponent();
    parseClaimCareTeamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimCareTeamComponentProperties(JsonObject json, Claim owner, Claim.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("qualification"))
      res.setQualification(parseCodeableConcept(json.getAsJsonObject("qualification")));
  }

  protected Claim.SpecialConditionComponent parseClaimSpecialConditionComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.SpecialConditionComponent res = new Claim.SpecialConditionComponent();
    parseClaimSpecialConditionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimSpecialConditionComponentProperties(JsonObject json, Claim owner, Claim.SpecialConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseClaimDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimDiagnosisComponentProperties(JsonObject json, Claim owner, Claim.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    Type diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmission(parseCodeableConcept(json.getAsJsonObject("onAdmission")));
    if (json.has("packageCode"))
      res.setPackageCode(parseCodeableConcept(json.getAsJsonObject("packageCode")));
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseClaimProcedureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimProcedureComponentProperties(JsonObject json, Claim owner, Claim.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    Type procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
  }

  protected Claim.InsuranceComponent parseClaimInsuranceComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.InsuranceComponent res = new Claim.InsuranceComponent();
    parseClaimInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimInsuranceComponentProperties(JsonObject json, Claim owner, Claim.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
  }

  protected Claim.AccidentComponent parseClaimAccidentComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.AccidentComponent res = new Claim.AccidentComponent();
    parseClaimAccidentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimAccidentComponentProperties(JsonObject json, Claim owner, Claim.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected Claim.ItemComponent parseClaimItemComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.ItemComponent res = new Claim.ItemComponent();
    parseClaimItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimItemComponentProperties(JsonObject json, Claim owner, Claim.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeamSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("_careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamSequence().size())
          res.getCareTeamSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCareTeamSequence().get(i));
      }
    };
    if (json.has("diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosisSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("_diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisSequence().size())
          res.getDiagnosisSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisSequence().get(i));
      }
    };
    if (json.has("procedureSequence")) {
      JsonArray array = json.getAsJsonArray("procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedureSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_procedureSequence")) {
      JsonArray array = json.getAsJsonArray("_procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureSequence().size())
          res.getProcedureSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProcedureSequence().get(i));
      }
    };
    if (json.has("informationSequence")) {
      JsonArray array = json.getAsJsonArray("informationSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_informationSequence")) {
      JsonArray array = json.getAsJsonArray("_informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationSequence().size())
          res.getInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInformationSequence().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseClaimDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimDetailComponentProperties(JsonObject json, Claim owner, Claim.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseClaimSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimSubDetailComponentProperties(JsonObject json, Claim owner, Claim.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseClaimResponseProperties(json, res);
    return res;
  }

  protected void parseClaimResponseProperties(JsonObject json, ClaimResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ClaimResponse.ClaimResponseStatus.NULL, new ClaimResponse.ClaimResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ClaimResponse.Use.NULL, new ClaimResponse.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), ClaimResponse.RemittanceOutcome.NULL, new ClaimResponse.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(json.getAsJsonObject("_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("payeeType"))
      res.setPayeeType(parseCodeableConcept(json.getAsJsonObject("payeeType")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimResponseItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseClaimResponseErrorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("total")) {
      JsonArray array = json.getAsJsonArray("total");
      for (int i = 0; i < array.size(); i++) {
        res.getTotal().add(parseClaimResponseTotalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("payment"))
      res.setPayment(parseClaimResponsePaymentComponent(json.getAsJsonObject("payment"), res));
    if (json.has("reserved"))
      res.setReserved(parseCoding(json.getAsJsonObject("reserved")));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseClaimResponseNoteComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("communicationRequest")) {
      JsonArray array = json.getAsJsonArray("communicationRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunicationRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimResponseInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
    parseClaimResponseItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseItemComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence"))
      res.setItemSequenceElement(parsePositiveInt(json.get("itemSequence").getAsString()));
    if (json.has("_itemSequence"))
      parseElementProperties(json.getAsJsonObject("_itemSequence"), res.getItemSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
    parseClaimResponseAdjudicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAdjudicationComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseClaimResponseItemDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseItemDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("detailSequence"))
      res.setDetailSequenceElement(parsePositiveInt(json.get("detailSequence").getAsString()));
    if (json.has("_detailSequence"))
      parseElementProperties(json.getAsJsonObject("_detailSequence"), res.getDetailSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseClaimResponseSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseSubDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("subDetailSequence"))
      res.setSubDetailSequenceElement(parsePositiveInt(json.get("subDetailSequence").getAsString()));
    if (json.has("_subDetailSequence"))
      parseElementProperties(json.getAsJsonObject("_subDetailSequence"), res.getSubDetailSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseClaimResponseAddedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAddedItemComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence")) {
      JsonArray array = json.getAsJsonArray("itemSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getItemSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_itemSequence")) {
      JsonArray array = json.getAsJsonArray("_itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getItemSequence().size())
          res.getItemSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getItemSequence().get(i));
      }
    };
    if (json.has("detailSequence")) {
      JsonArray array = json.getAsJsonArray("detailSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_detailSequence")) {
      JsonArray array = json.getAsJsonArray("_detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDetailSequence().size())
          res.getDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDetailSequence().get(i));
      }
    };
    if (json.has("subdetailSequence")) {
      JsonArray array = json.getAsJsonArray("subdetailSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getSubdetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_subdetailSequence")) {
      JsonArray array = json.getAsJsonArray("_subdetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubdetailSequence().size())
          res.getSubdetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSubdetailSequence().get(i));
      }
    };
    if (json.has("provider")) {
      JsonArray array = json.getAsJsonArray("provider");
      for (int i = 0; i < array.size(); i++) {
        res.getProvider().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseAddedItemDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
    parseClaimResponseAddedItemDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAddedItemDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseAddedItemSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
    parseClaimResponseAddedItemSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseAddedItemSubDetailComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.AddedItemSubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
    parseClaimResponseErrorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseErrorComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.ErrorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence"))
      res.setItemSequenceElement(parsePositiveInt(json.get("itemSequence").getAsString()));
    if (json.has("_itemSequence"))
      parseElementProperties(json.getAsJsonObject("_itemSequence"), res.getItemSequenceElement());
    if (json.has("detailSequence"))
      res.setDetailSequenceElement(parsePositiveInt(json.get("detailSequence").getAsString()));
    if (json.has("_detailSequence"))
      parseElementProperties(json.getAsJsonObject("_detailSequence"), res.getDetailSequenceElement());
    if (json.has("subDetailSequence"))
      res.setSubDetailSequenceElement(parsePositiveInt(json.get("subDetailSequence").getAsString()));
    if (json.has("_subDetailSequence"))
      parseElementProperties(json.getAsJsonObject("_subDetailSequence"), res.getSubDetailSequenceElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
    parseClaimResponseTotalComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseTotalComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.TotalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
    parseClaimResponsePaymentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponsePaymentComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(json.getAsJsonObject("adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(json.getAsJsonObject("adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
  }

  protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
    parseClaimResponseNoteComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseNoteComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
  }

  protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
    parseClaimResponseInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClaimResponseInsuranceComponentProperties(JsonObject json, ClaimResponse owner, ClaimResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
  }

  protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseClinicalImpressionProperties(json, res);
    return res;
  }

  protected void parseClinicalImpressionProperties(JsonObject json, ClinicalImpression res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("assessor"))
      res.setAssessor(parseReference(json.getAsJsonObject("assessor")));
    if (json.has("previous"))
      res.setPrevious(parseReference(json.getAsJsonObject("previous")));
    if (json.has("problem")) {
      JsonArray array = json.getAsJsonArray("problem");
      for (int i = 0; i < array.size(); i++) {
        res.getProblem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("investigation")) {
      JsonArray array = json.getAsJsonArray("investigation");
      for (int i = 0; i < array.size(); i++) {
        res.getInvestigation().add(parseClinicalImpressionClinicalImpressionInvestigationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("protocol")) {
      JsonArray array = json.getAsJsonArray("protocol");
      for (int i = 0; i < array.size(); i++) {
        res.getProtocol().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_protocol")) {
      JsonArray array = json.getAsJsonArray("_protocol");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProtocol().size())
          res.getProtocol().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProtocol().get(i));
      }
    };
    if (json.has("summary"))
      res.setSummaryElement(parseString(json.get("summary").getAsString()));
    if (json.has("_summary"))
      parseElementProperties(json.getAsJsonObject("_summary"), res.getSummaryElement());
    if (json.has("finding")) {
      JsonArray array = json.getAsJsonArray("finding");
      for (int i = 0; i < array.size(); i++) {
        res.getFinding().add(parseClinicalImpressionClinicalImpressionFindingComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prognosisCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("prognosisCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prognosisReference")) {
      JsonArray array = json.getAsJsonArray("prognosisReference");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalImpression.ClinicalImpressionInvestigationComponent parseClinicalImpressionClinicalImpressionInvestigationComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionInvestigationComponent res = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
    parseClinicalImpressionClinicalImpressionInvestigationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClinicalImpressionClinicalImpressionInvestigationComponentProperties(JsonObject json, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionInvestigationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseClinicalImpressionClinicalImpressionFindingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseClinicalImpressionClinicalImpressionFindingComponentProperties(JsonObject json, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionFindingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemCodeableConcept"))
      res.setItemCodeableConcept(parseCodeableConcept(json.getAsJsonObject("itemCodeableConcept")));
    if (json.has("itemReference"))
      res.setItemReference(parseReference(json.getAsJsonObject("itemReference")));
    if (json.has("basis"))
      res.setBasisElement(parseString(json.get("basis").getAsString()));
    if (json.has("_basis"))
      parseElementProperties(json.getAsJsonObject("_basis"), res.getBasisElement());
  }

  protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseCodeSystemProperties(json, res);
    return res;
  }

  protected void parseCodeSystemProperties(JsonObject json, CodeSystem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("caseSensitive"))
      res.setCaseSensitiveElement(parseBoolean(json.get("caseSensitive").getAsBoolean()));
    if (json.has("_caseSensitive"))
      parseElementProperties(json.getAsJsonObject("_caseSensitive"), res.getCaseSensitiveElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
    if (json.has("hierarchyMeaning"))
      res.setHierarchyMeaningElement(parseEnumeration(json.get("hierarchyMeaning").getAsString(), CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
    if (json.has("_hierarchyMeaning"))
      parseElementProperties(json.getAsJsonObject("_hierarchyMeaning"), res.getHierarchyMeaningElement());
    if (json.has("compositional"))
      res.setCompositionalElement(parseBoolean(json.get("compositional").getAsBoolean()));
    if (json.has("_compositional"))
      parseElementProperties(json.getAsJsonObject("_compositional"), res.getCompositionalElement());
    if (json.has("versionNeeded"))
      res.setVersionNeededElement(parseBoolean(json.get("versionNeeded").getAsBoolean()));
    if (json.has("_versionNeeded"))
      parseElementProperties(json.getAsJsonObject("_versionNeeded"), res.getVersionNeededElement());
    if (json.has("content"))
      res.setContentElement(parseEnumeration(json.get("content").getAsString(), CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
    if (json.has("_content"))
      parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
    if (json.has("supplements"))
      res.setSupplementsElement(parseCanonical(json.get("supplements").getAsString()));
    if (json.has("_supplements"))
      parseElementProperties(json.getAsJsonObject("_supplements"), res.getSupplementsElement());
    if (json.has("count"))
      res.setCountElement(parseUnsignedInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("filter")) {
      JsonArray array = json.getAsJsonArray("filter");
      for (int i = 0; i < array.size(); i++) {
        res.getFilter().add(parseCodeSystemCodeSystemFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemPropertyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseCodeSystemCodeSystemFilterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemCodeSystemFilterComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.CodeSystemFilterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("operator")) {
      JsonArray array = json.getAsJsonArray("operator");
      for (int i = 0; i < array.size(); i++) {
        res.getOperator().add(parseEnumeration(array.get(i).getAsString(), CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
      }
    };
    if (json.has("_operator")) {
      JsonArray array = json.getAsJsonArray("_operator");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOperator().size())
          res.getOperator().add(parseEnumeration(null, CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOperator().get(i));
      }
    };
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
    parseCodeSystemPropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemPropertyComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.PropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseCodeSystemConceptDefinitionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseString(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation().add(parseCodeSystemConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemConceptPropertyComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseCodeSystemConceptDefinitionDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionDesignationComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptDefinitionDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
    parseCodeSystemConceptPropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCodeSystemConceptPropertyComponentProperties(JsonObject json, CodeSystem owner, CodeSystem.ConceptPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
    Communication res = new Communication();
    parseCommunicationProperties(json, res);
    return res;
  }

  protected void parseCommunicationProperties(JsonObject json, Communication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("inResponseTo")) {
      JsonArray array = json.getAsJsonArray("inResponseTo");
      for (int i = 0; i < array.size(); i++) {
        res.getInResponseTo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Communication.CommunicationPriority.NULL, new Communication.CommunicationPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("topic"))
      res.setTopic(parseCodeableConcept(json.getAsJsonObject("topic")));
    if (json.has("about")) {
      JsonArray array = json.getAsJsonArray("about");
      for (int i = 0; i < array.size(); i++) {
        res.getAbout().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("sent"))
      res.setSentElement(parseDateTime(json.get("sent").getAsString()));
    if (json.has("_sent"))
      parseElementProperties(json.getAsJsonObject("_sent"), res.getSentElement());
    if (json.has("received"))
      res.setReceivedElement(parseDateTime(json.get("received").getAsString()));
    if (json.has("_received"))
      parseElementProperties(json.getAsJsonObject("_received"), res.getReceivedElement());
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationCommunicationPayloadComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(JsonObject json, Communication owner) throws IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseCommunicationCommunicationPayloadComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCommunicationCommunicationPayloadComponentProperties(JsonObject json, Communication owner, Communication.CommunicationPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseCommunicationRequestProperties(json, res);
    return res;
  }

  protected void parseCommunicationRequestProperties(JsonObject json, CommunicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), CommunicationRequest.CommunicationPriority.NULL, new CommunicationRequest.CommunicationPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("about")) {
      JsonArray array = json.getAsJsonArray("about");
      for (int i = 0; i < array.size(); i++) {
        res.getAbout().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationRequestCommunicationRequestPayloadComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseCommunicationRequestCommunicationRequestPayloadComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCommunicationRequestCommunicationRequestPayloadComponentProperties(JsonObject json, CommunicationRequest owner, CommunicationRequest.CommunicationRequestPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseCompartmentDefinitionProperties(json, res);
    return res;
  }

  protected void parseCompartmentDefinitionProperties(JsonObject json, CompartmentDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("search"))
      res.setSearchElement(parseBoolean(json.get("search").getAsBoolean()));
    if (json.has("_search"))
      parseElementProperties(json.getAsJsonObject("_search"), res.getSearchElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCompartmentDefinitionCompartmentDefinitionResourceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(JsonObject json, CompartmentDefinition owner) throws IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseCompartmentDefinitionCompartmentDefinitionResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompartmentDefinitionCompartmentDefinitionResourceComponentProperties(JsonObject json, CompartmentDefinition owner, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_param")) {
      JsonArray array = json.getAsJsonArray("_param");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParam().size())
          res.getParam().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParam().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
    Composition res = new Composition();
    parseCompositionProperties(json, res);
    return res;
  }

  protected void parseCompositionProperties(JsonObject json, Composition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("confidentiality"))
      res.setConfidentialityElement(parseEnumeration(json.get("confidentiality").getAsString(), Composition.DocumentConfidentiality.NULL, new Composition.DocumentConfidentialityEnumFactory()));
    if (json.has("_confidentiality"))
      parseElementProperties(json.getAsJsonObject("_confidentiality"), res.getConfidentialityElement());
    if (json.has("attester")) {
      JsonArray array = json.getAsJsonArray("attester");
      for (int i = 0; i < array.size(); i++) {
        res.getAttester().add(parseCompositionCompositionAttesterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseCompositionCompositionRelatesToComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCompositionCompositionEventComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseCompositionCompositionAttesterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionAttesterComponentProperties(JsonObject json, Composition owner, Composition.CompositionAttesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected Composition.CompositionRelatesToComponent parseCompositionCompositionRelatesToComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
    parseCompositionCompositionRelatesToComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionRelatesToComponentProperties(JsonObject json, Composition owner, Composition.CompositionRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Composition.DocumentRelationshipType.NULL, new Composition.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
  }

  protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseCompositionCompositionEventComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionCompositionEventComponentProperties(JsonObject json, Composition owner, Composition.CompositionEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseCompositionSectionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCompositionSectionComponentProperties(JsonObject json, Composition owner, Composition.SectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setText(parseNarrative(json.getAsJsonObject("text")));
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Composition.SectionMode.NULL, new Composition.SectionModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(json.getAsJsonObject("orderedBy")));
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(json.getAsJsonObject("emptyReason")));
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseConceptMapProperties(json, res);
    return res;
  }

  protected void parseConceptMapProperties(JsonObject json, ConceptMap res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseConceptMapConceptMapGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ConceptMap.ConceptMapGroupComponent parseConceptMapConceptMapGroupComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
    parseConceptMapConceptMapGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapConceptMapGroupComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.ConceptMapGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("sourceVersion"))
      res.setSourceVersionElement(parseString(json.get("sourceVersion").getAsString()));
    if (json.has("_sourceVersion"))
      parseElementProperties(json.getAsJsonObject("_sourceVersion"), res.getSourceVersionElement());
    if (json.has("target"))
      res.setTargetElement(parseUri(json.get("target").getAsString()));
    if (json.has("_target"))
      parseElementProperties(json.getAsJsonObject("_target"), res.getTargetElement());
    if (json.has("targetVersion"))
      res.setTargetVersionElement(parseString(json.get("targetVersion").getAsString()));
    if (json.has("_targetVersion"))
      parseElementProperties(json.getAsJsonObject("_targetVersion"), res.getTargetVersionElement());
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseConceptMapSourceElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("unmapped"))
      res.setUnmapped(parseConceptMapConceptMapGroupUnmappedComponent(json.getAsJsonObject("unmapped"), owner));
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseConceptMapSourceElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapSourceElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.SourceElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseConceptMapTargetElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapTargetElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.TargetElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("equivalence"))
      res.setEquivalenceElement(parseEnumeration(json.get("equivalence").getAsString(), Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
    if (json.has("_equivalence"))
      parseElementProperties(json.getAsJsonObject("_equivalence"), res.getEquivalenceElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("dependsOn")) {
      JsonArray array = json.getAsJsonArray("dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("product")) {
      JsonArray array = json.getAsJsonArray("product");
      for (int i = 0; i < array.size(); i++) {
        res.getProduct().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseConceptMapOtherElementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapOtherElementComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.OtherElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("property"))
      res.setPropertyElement(parseUri(json.get("property").getAsString()));
    if (json.has("_property"))
      parseElementProperties(json.getAsJsonObject("_property"), res.getPropertyElement());
    if (json.has("system"))
      res.setSystemElement(parseCanonical(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
  }

  protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapConceptMapGroupUnmappedComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
    parseConceptMapConceptMapGroupUnmappedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConceptMapConceptMapGroupUnmappedComponentProperties(JsonObject json, ConceptMap owner, ConceptMap.ConceptMapGroupUnmappedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("url"))
      res.setUrlElement(parseCanonical(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
  }

  protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
    Condition res = new Condition();
    parseConditionProperties(json, res);
    return res;
  }

  protected void parseConditionProperties(JsonObject json, Condition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatus(parseCodeableConcept(json.getAsJsonObject("clinicalStatus")));
    if (json.has("verificationStatus"))
      res.setVerificationStatus(parseCodeableConcept(json.getAsJsonObject("verificationStatus")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(json.getAsJsonObject("severity")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    Type abatement = parseType("abatement", json);
    if (abatement != null)
      res.setAbatement(abatement);
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("asserter"))
      res.setAsserter(parseReference(json.getAsJsonObject("asserter")));
    if (json.has("stage")) {
      JsonArray array = json.getAsJsonArray("stage");
      for (int i = 0; i < array.size(); i++) {
        res.getStage().add(parseConditionConditionStageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("evidence")) {
      JsonArray array = json.getAsJsonArray("evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseConditionConditionEvidenceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Condition.ConditionStageComponent parseConditionConditionStageComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseConditionConditionStageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConditionConditionStageComponentProperties(JsonObject json, Condition owner, Condition.ConditionStageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("summary"))
      res.setSummary(parseCodeableConcept(json.getAsJsonObject("summary")));
    if (json.has("assessment")) {
      JsonArray array = json.getAsJsonArray("assessment");
      for (int i = 0; i < array.size(); i++) {
        res.getAssessment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
  }

  protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
    Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
    parseConditionConditionEvidenceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConditionConditionEvidenceComponentProperties(JsonObject json, Condition owner, Condition.ConditionEvidenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Consent parseConsent(JsonObject json) throws IOException, FHIRFormatError {
    Consent res = new Consent();
    parseConsentProperties(json, res);
    return res;
  }

  protected void parseConsentProperties(JsonObject json, Consent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(json.getAsJsonObject("scope")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("organization")) {
      JsonArray array = json.getAsJsonArray("organization");
      for (int i = 0; i < array.size(); i++) {
        res.getOrganization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseConsentConsentPolicyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("policyRule"))
      res.setPolicyRule(parseCodeableConcept(json.getAsJsonObject("policyRule")));
    if (json.has("verification")) {
      JsonArray array = json.getAsJsonArray("verification");
      for (int i = 0; i < array.size(); i++) {
        res.getVerification().add(parseConsentConsentVerificationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("provision"))
      res.setProvision(parseConsentprovisionComponent(json.getAsJsonObject("provision"), res));
  }

  protected Consent.ConsentPolicyComponent parseConsentConsentPolicyComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
    parseConsentConsentPolicyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentConsentPolicyComponentProperties(JsonObject json, Consent owner, Consent.ConsentPolicyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("authority"))
      res.setAuthorityElement(parseUri(json.get("authority").getAsString()));
    if (json.has("_authority"))
      parseElementProperties(json.getAsJsonObject("_authority"), res.getAuthorityElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
  }

  protected Consent.ConsentVerificationComponent parseConsentConsentVerificationComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
    parseConsentConsentVerificationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentConsentVerificationComponentProperties(JsonObject json, Consent owner, Consent.ConsentVerificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("verified"))
      res.setVerifiedElement(parseBoolean(json.get("verified").getAsBoolean()));
    if (json.has("_verified"))
      parseElementProperties(json.getAsJsonObject("_verified"), res.getVerifiedElement());
    if (json.has("verifiedWith"))
      res.setVerifiedWith(parseReference(json.getAsJsonObject("verifiedWith")));
    if (json.has("verificationDate"))
      res.setVerificationDateElement(parseDateTime(json.get("verificationDate").getAsString()));
    if (json.has("_verificationDate"))
      parseElementProperties(json.getAsJsonObject("_verificationDate"), res.getVerificationDateElement());
  }

  protected Consent.provisionComponent parseConsentprovisionComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.provisionComponent res = new Consent.provisionComponent();
    parseConsentprovisionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentprovisionComponentProperties(JsonObject json, Consent owner, Consent.provisionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Consent.ConsentProvisionType.NULL, new Consent.ConsentProvisionTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseConsentprovisionActorComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        res.getPurpose().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("class")) {
      JsonArray array = json.getAsJsonArray("class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataPeriod"))
      res.setDataPeriod(parsePeriod(json.getAsJsonObject("dataPeriod")));
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseConsentprovisionDataComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("provision")) {
      JsonArray array = json.getAsJsonArray("provision");
      for (int i = 0; i < array.size(); i++) {
        res.getProvision().add(parseConsentprovisionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Consent.provisionActorComponent parseConsentprovisionActorComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.provisionActorComponent res = new Consent.provisionActorComponent();
    parseConsentprovisionActorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentprovisionActorComponentProperties(JsonObject json, Consent owner, Consent.provisionActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Consent.provisionDataComponent parseConsentprovisionDataComponent(JsonObject json, Consent owner) throws IOException, FHIRFormatError {
    Consent.provisionDataComponent res = new Consent.provisionDataComponent();
    parseConsentprovisionDataComponentProperties(json, owner, res);
    return res;
  }

  protected void parseConsentprovisionDataComponentProperties(JsonObject json, Consent owner, Consent.provisionDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("meaning"))
      res.setMeaningElement(parseEnumeration(json.get("meaning").getAsString(), Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
    if (json.has("_meaning"))
      parseElementProperties(json.getAsJsonObject("_meaning"), res.getMeaningElement());
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
    Contract res = new Contract();
    parseContractProperties(json, res);
    return res;
  }

  protected void parseContractProperties(JsonObject json, Contract res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Contract.ContractStatus.NULL, new Contract.ContractStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("legalState"))
      res.setLegalState(parseCodeableConcept(json.getAsJsonObject("legalState")));
    if (json.has("instantiatesCanonical"))
      res.setInstantiatesCanonical(parseReference(json.getAsJsonObject("instantiatesCanonical")));
    if (json.has("instantiatesUri"))
      res.setInstantiatesUriElement(parseUri(json.get("instantiatesUri").getAsString()));
    if (json.has("_instantiatesUri"))
      parseElementProperties(json.getAsJsonObject("_instantiatesUri"), res.getInstantiatesUriElement());
    if (json.has("contentDerivative"))
      res.setContentDerivative(parseCodeableConcept(json.getAsJsonObject("contentDerivative")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(json.getAsJsonObject("applies")));
    if (json.has("expirationType"))
      res.setExpirationType(parseCodeableConcept(json.getAsJsonObject("expirationType")));
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authority")) {
      JsonArray array = json.getAsJsonArray("authority");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthority().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("domain")) {
      JsonArray array = json.getAsJsonArray("domain");
      for (int i = 0; i < array.size(); i++) {
        res.getDomain().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("site")) {
      JsonArray array = json.getAsJsonArray("site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(json.getAsJsonObject("scope")));
    Type topic = parseType("topic", json);
    if (topic != null)
      res.setTopic(topic);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contentDefinition"))
      res.setContentDefinition(parseContractContentDefinitionComponent(json.getAsJsonObject("contentDefinition"), res));
    if (json.has("term")) {
      JsonArray array = json.getAsJsonArray("term");
      for (int i = 0; i < array.size(); i++) {
        res.getTerm().add(parseContractTermComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("signer")) {
      JsonArray array = json.getAsJsonArray("signer");
      for (int i = 0; i < array.size(); i++) {
        res.getSigner().add(parseContractSignatoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("friendly")) {
      JsonArray array = json.getAsJsonArray("friendly");
      for (int i = 0; i < array.size(); i++) {
        res.getFriendly().add(parseContractFriendlyLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("legal")) {
      JsonArray array = json.getAsJsonArray("legal");
      for (int i = 0; i < array.size(); i++) {
        res.getLegal().add(parseContractLegalLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseContractComputableLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type legallyBinding = parseType("legallyBinding", json);
    if (legallyBinding != null)
      res.setLegallyBinding(legallyBinding);
  }

  protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
    parseContractContentDefinitionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractContentDefinitionComponentProperties(JsonObject json, Contract owner, Contract.ContentDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("publisher"))
      res.setPublisher(parseReference(json.getAsJsonObject("publisher")));
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDateTime(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(json.getAsJsonObject("_publicationDate"), res.getPublicationDateElement());
    if (json.has("publicationStatus"))
      res.setPublicationStatusElement(parseEnumeration(json.get("publicationStatus").getAsString(), Contract.ContractPublicationStatus.NULL, new Contract.ContractPublicationStatusEnumFactory()));
    if (json.has("_publicationStatus"))
      parseElementProperties(json.getAsJsonObject("_publicationStatus"), res.getPublicationStatusElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
  }

  protected Contract.TermComponent parseContractTermComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseContractTermComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractTermComponentProperties(JsonObject json, Contract owner, Contract.TermComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(json.getAsJsonObject("applies")));
    Type topic = parseType("topic", json);
    if (topic != null)
      res.setTopic(topic);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseContractSecurityLabelComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("offer"))
      res.setOffer(parseContractContractOfferComponent(json.getAsJsonObject("offer"), owner));
    if (json.has("asset")) {
      JsonArray array = json.getAsJsonArray("asset");
      for (int i = 0; i < array.size(); i++) {
        res.getAsset().add(parseContractContractAssetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseContractActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseContractTermComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
    parseContractSecurityLabelComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractSecurityLabelComponentProperties(JsonObject json, Contract owner, Contract.SecurityLabelComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number")) {
      JsonArray array = json.getAsJsonArray("number");
      for (int i = 0; i < array.size(); i++) {
        res.getNumber().add(parseUnsignedInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_number")) {
      JsonArray array = json.getAsJsonArray("_number");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumber().size())
          res.getNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumber().get(i));
      }
    };
    if (json.has("classification"))
      res.setClassification(parseCoding(json.getAsJsonObject("classification")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("control")) {
      JsonArray array = json.getAsJsonArray("control");
      for (int i = 0; i < array.size(); i++) {
        res.getControl().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.ContractOfferComponent parseContractContractOfferComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
    parseContractContractOfferComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractContractOfferComponentProperties(JsonObject json, Contract owner, Contract.ContractOfferComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("party")) {
      JsonArray array = json.getAsJsonArray("party");
      for (int i = 0; i < array.size(); i++) {
        res.getParty().add(parseContractContractPartyComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("topic"))
      res.setTopic(parseReference(json.getAsJsonObject("topic")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("decision"))
      res.setDecision(parseCodeableConcept(json.getAsJsonObject("decision")));
    if (json.has("decisionMode")) {
      JsonArray array = json.getAsJsonArray("decisionMode");
      for (int i = 0; i < array.size(); i++) {
        res.getDecisionMode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("answer")) {
      JsonArray array = json.getAsJsonArray("answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseContractAnswerComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        res.getLinkId().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ContractPartyComponent parseContractContractPartyComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
    parseContractContractPartyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractContractPartyComponentProperties(JsonObject json, Contract owner, Contract.ContractPartyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
  }

  protected Contract.AnswerComponent parseContractAnswerComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.AnswerComponent res = new Contract.AnswerComponent();
    parseContractAnswerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractAnswerComponentProperties(JsonObject json, Contract owner, Contract.AnswerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Contract.ContractAssetComponent parseContractContractAssetComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
    parseContractContractAssetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractContractAssetComponentProperties(JsonObject json, Contract owner, Contract.ContractAssetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(json.getAsJsonObject("scope")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("typeReference")) {
      JsonArray array = json.getAsJsonArray("typeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getTypeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subtype")) {
      JsonArray array = json.getAsJsonArray("subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relationship"))
      res.setRelationship(parseCoding(json.getAsJsonObject("relationship")));
    if (json.has("context")) {
      JsonArray array = json.getAsJsonArray("context");
      for (int i = 0; i < array.size(); i++) {
        res.getContext().add(parseContractAssetContextComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("condition"))
      res.setConditionElement(parseString(json.get("condition").getAsString()));
    if (json.has("_condition"))
      parseElementProperties(json.getAsJsonObject("_condition"), res.getConditionElement());
    if (json.has("periodType")) {
      JsonArray array = json.getAsJsonArray("periodType");
      for (int i = 0; i < array.size(); i++) {
        res.getPeriodType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period")) {
      JsonArray array = json.getAsJsonArray("period");
      for (int i = 0; i < array.size(); i++) {
        res.getPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("usePeriod")) {
      JsonArray array = json.getAsJsonArray("usePeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getUsePeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        res.getLinkId().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("answer")) {
      JsonArray array = json.getAsJsonArray("answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseContractAnswerComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
    if (json.has("valuedItem")) {
      JsonArray array = json.getAsJsonArray("valuedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getValuedItem().add(parseContractValuedItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Contract.AssetContextComponent parseContractAssetContextComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.AssetContextComponent res = new Contract.AssetContextComponent();
    parseContractAssetContextComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractAssetContextComponentProperties(JsonObject json, Contract owner, Contract.AssetContextComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseContractValuedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractValuedItemComponentProperties(JsonObject json, Contract owner, Contract.ValuedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type entity = parseType("entity", json);
    if (entity != null)
      res.setEntity(entity);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("effectiveTime"))
      res.setEffectiveTimeElement(parseDateTime(json.get("effectiveTime").getAsString()));
    if (json.has("_effectiveTime"))
      parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("payment"))
      res.setPaymentElement(parseString(json.get("payment").getAsString()));
    if (json.has("_payment"))
      parseElementProperties(json.getAsJsonObject("_payment"), res.getPaymentElement());
    if (json.has("paymentDate"))
      res.setPaymentDateElement(parseDateTime(json.get("paymentDate").getAsString()));
    if (json.has("_paymentDate"))
      parseElementProperties(json.getAsJsonObject("_paymentDate"), res.getPaymentDateElement());
    if (json.has("responsible"))
      res.setResponsible(parseReference(json.getAsJsonObject("responsible")));
    if (json.has("recipient"))
      res.setRecipient(parseReference(json.getAsJsonObject("recipient")));
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        res.getLinkId().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ActionComponent parseContractActionComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ActionComponent res = new Contract.ActionComponent();
    parseContractActionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractActionComponentProperties(JsonObject json, Contract owner, Contract.ActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseContractActionSubjectComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("intent"))
      res.setIntent(parseCodeableConcept(json.getAsJsonObject("intent")));
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        res.getLinkId().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("contextLinkId")) {
      JsonArray array = json.getAsJsonArray("contextLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getContextLinkId().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_contextLinkId")) {
      JsonArray array = json.getAsJsonArray("_contextLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getContextLinkId().size())
          res.getContextLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getContextLinkId().get(i));
      }
    };
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("requester")) {
      JsonArray array = json.getAsJsonArray("requester");
      for (int i = 0; i < array.size(); i++) {
        res.getRequester().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("requesterLinkId")) {
      JsonArray array = json.getAsJsonArray("requesterLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getRequesterLinkId().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_requesterLinkId")) {
      JsonArray array = json.getAsJsonArray("_requesterLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRequesterLinkId().size())
          res.getRequesterLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getRequesterLinkId().get(i));
      }
    };
    if (json.has("performerType")) {
      JsonArray array = json.getAsJsonArray("performerType");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformerType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("performerRole"))
      res.setPerformerRole(parseCodeableConcept(json.getAsJsonObject("performerRole")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("performerLinkId")) {
      JsonArray array = json.getAsJsonArray("performerLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformerLinkId().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_performerLinkId")) {
      JsonArray array = json.getAsJsonArray("_performerLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPerformerLinkId().size())
          res.getPerformerLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPerformerLinkId().get(i));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_reason")) {
      JsonArray array = json.getAsJsonArray("_reason");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReason().size())
          res.getReason().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReason().get(i));
      }
    };
    if (json.has("reasonLinkId")) {
      JsonArray array = json.getAsJsonArray("reasonLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonLinkId().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_reasonLinkId")) {
      JsonArray array = json.getAsJsonArray("_reasonLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReasonLinkId().size())
          res.getReasonLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReasonLinkId().get(i));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
    parseContractActionSubjectComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractActionSubjectComponentProperties(JsonObject json, Contract owner, Contract.ActionSubjectComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseContractSignatoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractSignatoryComponentProperties(JsonObject json, Contract owner, Contract.SignatoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
    if (json.has("signature")) {
      JsonArray array = json.getAsJsonArray("signature");
      for (int i = 0; i < array.size(); i++) {
        res.getSignature().add(parseSignature(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseContractFriendlyLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractFriendlyLanguageComponentProperties(JsonObject json, Contract owner, Contract.FriendlyLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseContractLegalLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractLegalLanguageComponentProperties(JsonObject json, Contract owner, Contract.LegalLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseContractComputableLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseContractComputableLanguageComponentProperties(JsonObject json, Contract owner, Contract.ComputableLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseCoverageProperties(json, res);
    return res;
  }

  protected void parseCoverageProperties(JsonObject json, Coverage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Coverage.CoverageStatus.NULL, new Coverage.CoverageStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("policyHolder"))
      res.setPolicyHolder(parseReference(json.getAsJsonObject("policyHolder")));
    if (json.has("subscriber"))
      res.setSubscriber(parseReference(json.getAsJsonObject("subscriber")));
    if (json.has("subscriberId"))
      res.setSubscriberIdElement(parseString(json.get("subscriberId").getAsString()));
    if (json.has("_subscriberId"))
      parseElementProperties(json.getAsJsonObject("_subscriberId"), res.getSubscriberIdElement());
    if (json.has("beneficiary"))
      res.setBeneficiary(parseReference(json.getAsJsonObject("beneficiary")));
    if (json.has("dependent"))
      res.setDependentElement(parseString(json.get("dependent").getAsString()));
    if (json.has("_dependent"))
      parseElementProperties(json.getAsJsonObject("_dependent"), res.getDependentElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("payor")) {
      JsonArray array = json.getAsJsonArray("payor");
      for (int i = 0; i < array.size(); i++) {
        res.getPayor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("class")) {
      JsonArray array = json.getAsJsonArray("class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCoverageClassComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("order"))
      res.setOrderElement(parsePositiveInt(json.get("order").getAsString()));
    if (json.has("_order"))
      parseElementProperties(json.getAsJsonObject("_order"), res.getOrderElement());
    if (json.has("network"))
      res.setNetworkElement(parseString(json.get("network").getAsString()));
    if (json.has("_network"))
      parseElementProperties(json.getAsJsonObject("_network"), res.getNetworkElement());
    if (json.has("copay")) {
      JsonArray array = json.getAsJsonArray("copay");
      for (int i = 0; i < array.size(); i++) {
        res.getCopay().add(parseCoverageCoPayComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("contract")) {
      JsonArray array = json.getAsJsonArray("contract");
      for (int i = 0; i < array.size(); i++) {
        res.getContract().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Coverage.ClassComponent parseCoverageClassComponent(JsonObject json, Coverage owner) throws IOException, FHIRFormatError {
    Coverage.ClassComponent res = new Coverage.ClassComponent();
    parseCoverageClassComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageClassComponentProperties(JsonObject json, Coverage owner, Coverage.ClassComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
  }

  protected Coverage.CoPayComponent parseCoverageCoPayComponent(JsonObject json, Coverage owner) throws IOException, FHIRFormatError {
    Coverage.CoPayComponent res = new Coverage.CoPayComponent();
    parseCoverageCoPayComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageCoPayComponentProperties(JsonObject json, Coverage owner, Coverage.CoPayComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("value"))
      res.setValue(parseQuantity(json.getAsJsonObject("value")));
  }

  protected CoverageEligibilityRequest parseCoverageEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest res = new CoverageEligibilityRequest();
    parseCoverageEligibilityRequestProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestProperties(JsonObject json, CoverageEligibilityRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CoverageEligibilityRequest.EligibilityRequestStatus.NULL, new CoverageEligibilityRequest.EligibilityRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        res.getPurpose().add(parseEnumeration(array.get(i).getAsString(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
      }
    };
    if (json.has("_purpose")) {
      JsonArray array = json.getAsJsonArray("_purpose");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPurpose().size())
          res.getPurpose().add(parseEnumeration(null, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPurpose().get(i));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseCoverageEligibilityRequestInformationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseCoverageEligibilityRequestInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseCoverageEligibilityRequestDetailsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CoverageEligibilityRequest.InformationComponent parseCoverageEligibilityRequestInformationComponent(JsonObject json, CoverageEligibilityRequest owner) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.InformationComponent res = new CoverageEligibilityRequest.InformationComponent();
    parseCoverageEligibilityRequestInformationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestInformationComponentProperties(JsonObject json, CoverageEligibilityRequest owner, CoverageEligibilityRequest.InformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("information"))
      res.setInformation(parseReference(json.getAsJsonObject("information")));
    if (json.has("appliesToAll"))
      res.setAppliesToAllElement(parseBoolean(json.get("appliesToAll").getAsBoolean()));
    if (json.has("_appliesToAll"))
      parseElementProperties(json.getAsJsonObject("_appliesToAll"), res.getAppliesToAllElement());
  }

  protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(JsonObject json, CoverageEligibilityRequest owner) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
    parseCoverageEligibilityRequestInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestInsuranceComponentProperties(JsonObject json, CoverageEligibilityRequest owner, CoverageEligibilityRequest.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
  }

  protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(JsonObject json, CoverageEligibilityRequest owner) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
    parseCoverageEligibilityRequestDetailsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestDetailsComponentProperties(JsonObject json, CoverageEligibilityRequest owner, CoverageEligibilityRequest.DetailsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("supportingInformationSequence")) {
      JsonArray array = json.getAsJsonArray("supportingInformationSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_supportingInformationSequence")) {
      JsonArray array = json.getAsJsonArray("_supportingInformationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportingInformationSequence().size())
          res.getSupportingInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportingInformationSequence().get(i));
      }
    };
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseCoverageEligibilityRequestDiagnosisComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(JsonObject json, CoverageEligibilityRequest owner) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
    parseCoverageEligibilityRequestDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestDiagnosisComponentProperties(JsonObject json, CoverageEligibilityRequest owner, CoverageEligibilityRequest.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
  }

  protected CoverageEligibilityResponse parseCoverageEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse res = new CoverageEligibilityResponse();
    parseCoverageEligibilityResponseProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseProperties(JsonObject json, CoverageEligibilityResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CoverageEligibilityResponse.EligibilityResponseStatus.NULL, new CoverageEligibilityResponse.EligibilityResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        res.getPurpose().add(parseEnumeration(array.get(i).getAsString(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
      }
    };
    if (json.has("_purpose")) {
      JsonArray array = json.getAsJsonArray("_purpose");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPurpose().size())
          res.getPurpose().add(parseEnumeration(null, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPurpose().get(i));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseCoverageEligibilityResponseInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(json.getAsJsonObject("_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseCoverageEligibilityResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(JsonObject json, CoverageEligibilityResponse owner) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
    parseCoverageEligibilityResponseInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseInsuranceComponentProperties(JsonObject json, CoverageEligibilityResponse owner, CoverageEligibilityResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("contract"))
      res.setContract(parseReference(json.getAsJsonObject("contract")));
    if (json.has("inforce"))
      res.setInforceElement(parseBoolean(json.get("inforce").getAsBoolean()));
    if (json.has("_inforce"))
      parseElementProperties(json.getAsJsonObject("_inforce"), res.getInforceElement());
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseCoverageEligibilityResponseItemsComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(JsonObject json, CoverageEligibilityResponse owner) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
    parseCoverageEligibilityResponseItemsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseItemsComponentProperties(JsonObject json, CoverageEligibilityResponse owner, CoverageEligibilityResponse.ItemsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(json.getAsJsonObject("_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(json.getAsJsonObject("network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(json.getAsJsonObject("term")));
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseCoverageEligibilityResponseBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("authorizationRequired"))
      res.setAuthorizationRequiredElement(parseBoolean(json.get("authorizationRequired").getAsBoolean()));
    if (json.has("_authorizationRequired"))
      parseElementProperties(json.getAsJsonObject("_authorizationRequired"), res.getAuthorizationRequiredElement());
    if (json.has("authorizationSupporting")) {
      JsonArray array = json.getAsJsonArray("authorizationSupporting");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizationSupporting().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authorizationUrl"))
      res.setAuthorizationUrlElement(parseUri(json.get("authorizationUrl").getAsString()));
    if (json.has("_authorizationUrl"))
      parseElementProperties(json.getAsJsonObject("_authorizationUrl"), res.getAuthorizationUrlElement());
  }

  protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(JsonObject json, CoverageEligibilityResponse owner) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
    parseCoverageEligibilityResponseBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseBenefitComponentProperties(JsonObject json, CoverageEligibilityResponse owner, CoverageEligibilityResponse.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    Type used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(JsonObject json, CoverageEligibilityResponse owner) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
    parseCoverageEligibilityResponseErrorsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseErrorsComponentProperties(JsonObject json, CoverageEligibilityResponse owner, CoverageEligibilityResponse.ErrorsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseDetectedIssueProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueProperties(JsonObject json, DetectedIssue res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("implicated")) {
      JsonArray array = json.getAsJsonArray("implicated");
      for (int i = 0; i < array.size(); i++) {
        res.getImplicated().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail"))
      res.setDetailElement(parseString(json.get("detail").getAsString()));
    if (json.has("_detail"))
      parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("mitigation")) {
      JsonArray array = json.getAsJsonArray("mitigation");
      for (int i = 0; i < array.size(); i++) {
        res.getMitigation().add(parseDetectedIssueDetectedIssueMitigationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(JsonObject json, DetectedIssue owner) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseDetectedIssueDetectedIssueMitigationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDetectedIssueDetectedIssueMitigationComponentProperties(JsonObject json, DetectedIssue owner, DetectedIssue.DetectedIssueMitigationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("action"))
      res.setAction(parseCodeableConcept(json.getAsJsonObject("action")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
    Device res = new Device();
    parseDeviceProperties(json, res);
    return res;
  }

  protected void parseDeviceProperties(JsonObject json, Device res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition"))
      res.setDefinition(parseReference(json.getAsJsonObject("definition")));
    if (json.has("udiCarrier")) {
      JsonArray array = json.getAsJsonArray("udiCarrier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiCarrier().add(parseDeviceDeviceUdiCarrierComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("distinctIdentificationCode"))
      res.setDistinctIdentificationCodeElement(parseString(json.get("distinctIdentificationCode").getAsString()));
    if (json.has("_distinctIdentificationCode"))
      parseElementProperties(json.getAsJsonObject("_distinctIdentificationCode"), res.getDistinctIdentificationCodeElement());
    if (json.has("manufacturer"))
      res.setManufacturerElement(parseString(json.get("manufacturer").getAsString()));
    if (json.has("_manufacturer"))
      parseElementProperties(json.getAsJsonObject("_manufacturer"), res.getManufacturerElement());
    if (json.has("manufactureDate"))
      res.setManufactureDateElement(parseDateTime(json.get("manufactureDate").getAsString()));
    if (json.has("_manufactureDate"))
      parseElementProperties(json.getAsJsonObject("_manufactureDate"), res.getManufactureDateElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("serialNumber"))
      res.setSerialNumberElement(parseString(json.get("serialNumber").getAsString()));
    if (json.has("_serialNumber"))
      parseElementProperties(json.getAsJsonObject("_serialNumber"), res.getSerialNumberElement());
    if (json.has("deviceName")) {
      JsonArray array = json.getAsJsonArray("deviceName");
      for (int i = 0; i < array.size(); i++) {
        res.getDeviceName().add(parseDeviceDeviceDeviceNameComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(json.getAsJsonObject("_modelNumber"), res.getModelNumberElement());
    if (json.has("partNumber"))
      res.setPartNumberElement(parseString(json.get("partNumber").getAsString()));
    if (json.has("_partNumber"))
      parseElementProperties(json.getAsJsonObject("_partNumber"), res.getPartNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("specialization")) {
      JsonArray array = json.getAsJsonArray("specialization");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialization().add(parseDeviceDeviceSpecializationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseDeviceDeviceVersionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseDeviceDevicePropertyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("safety")) {
      JsonArray array = json.getAsJsonArray("safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
  }

  protected Device.DeviceUdiCarrierComponent parseDeviceDeviceUdiCarrierComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
    parseDeviceDeviceUdiCarrierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceUdiCarrierComponentProperties(JsonObject json, Device owner, Device.DeviceUdiCarrierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(json.getAsJsonObject("_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(json.getAsJsonObject("_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(json.getAsJsonObject("_jurisdiction"), res.getJurisdictionElement());
    if (json.has("carrierAIDC"))
      res.setCarrierAIDCElement(parseBase64Binary(json.get("carrierAIDC").getAsString()));
    if (json.has("_carrierAIDC"))
      parseElementProperties(json.getAsJsonObject("_carrierAIDC"), res.getCarrierAIDCElement());
    if (json.has("carrierHRF"))
      res.setCarrierHRFElement(parseString(json.get("carrierHRF").getAsString()));
    if (json.has("_carrierHRF"))
      parseElementProperties(json.getAsJsonObject("_carrierHRF"), res.getCarrierHRFElement());
    if (json.has("entryType"))
      res.setEntryTypeElement(parseEnumeration(json.get("entryType").getAsString(), Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
    if (json.has("_entryType"))
      parseElementProperties(json.getAsJsonObject("_entryType"), res.getEntryTypeElement());
  }

  protected Device.DeviceDeviceNameComponent parseDeviceDeviceDeviceNameComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceDeviceNameComponent res = new Device.DeviceDeviceNameComponent();
    parseDeviceDeviceDeviceNameComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceDeviceNameComponentProperties(JsonObject json, Device owner, Device.DeviceDeviceNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Device.DeviceNameType.NULL, new Device.DeviceNameTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected Device.DeviceSpecializationComponent parseDeviceDeviceSpecializationComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceSpecializationComponent res = new Device.DeviceSpecializationComponent();
    parseDeviceDeviceSpecializationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceSpecializationComponentProperties(JsonObject json, Device owner, Device.DeviceSpecializationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("systemType"))
      res.setSystemType(parseCodeableConcept(json.getAsJsonObject("systemType")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
  }

  protected Device.DeviceVersionComponent parseDeviceDeviceVersionComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
    parseDeviceDeviceVersionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDeviceVersionComponentProperties(JsonObject json, Device owner, Device.DeviceVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("component"))
      res.setComponent(parseIdentifier(json.getAsJsonObject("component")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected Device.DevicePropertyComponent parseDeviceDevicePropertyComponent(JsonObject json, Device owner) throws IOException, FHIRFormatError {
    Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
    parseDeviceDevicePropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDevicePropertyComponentProperties(JsonObject json, Device owner, Device.DevicePropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("valueQuanity")) {
      JsonArray array = json.getAsJsonArray("valueQuanity");
      for (int i = 0; i < array.size(); i++) {
        res.getValueQuanity().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition parseDeviceDefinition(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition res = new DeviceDefinition();
    parseDeviceDefinitionProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionProperties(JsonObject json, DeviceDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("udiDeviceIdentifier")) {
      JsonArray array = json.getAsJsonArray("udiDeviceIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiDeviceIdentifier().add(parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    Type manufacturer = parseType("manufacturer", json);
    if (manufacturer != null)
      res.setManufacturer(manufacturer);
    if (json.has("deviceName")) {
      JsonArray array = json.getAsJsonArray("deviceName");
      for (int i = 0; i < array.size(); i++) {
        res.getDeviceName().add(parseDeviceDefinitionDeviceDefinitionDeviceNameComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(json.getAsJsonObject("_modelNumber"), res.getModelNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("specialization")) {
      JsonArray array = json.getAsJsonArray("specialization");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialization().add(parseDeviceDefinitionDeviceDefinitionSpecializationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_version")) {
      JsonArray array = json.getAsJsonArray("_version");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getVersion().size())
          res.getVersion().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getVersion().get(i));
      }
    };
    if (json.has("safety")) {
      JsonArray array = json.getAsJsonArray("safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("shelfLifeStorage")) {
      JsonArray array = json.getAsJsonArray("shelfLifeStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getShelfLifeStorage().add(parseProductShelfLife(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("physicalCharacteristics"))
      res.setPhysicalCharacteristics(parseProdCharacteristic(json.getAsJsonObject("physicalCharacteristics")));
    if (json.has("languageCode")) {
      JsonArray array = json.getAsJsonArray("languageCode");
      for (int i = 0; i < array.size(); i++) {
        res.getLanguageCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("capability")) {
      JsonArray array = json.getAsJsonArray("capability");
      for (int i = 0; i < array.size(); i++) {
        res.getCapability().add(parseDeviceDefinitionDeviceDefinitionCapabilityComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseDeviceDefinitionDeviceDefinitionPropertyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("onlineInformation"))
      res.setOnlineInformationElement(parseUri(json.get("onlineInformation").getAsString()));
    if (json.has("_onlineInformation"))
      parseElementProperties(json.getAsJsonObject("_onlineInformation"), res.getOnlineInformationElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("parentDevice"))
      res.setParentDevice(parseReference(json.getAsJsonObject("parentDevice")));
    if (json.has("material")) {
      JsonArray array = json.getAsJsonArray("material");
      for (int i = 0; i < array.size(); i++) {
        res.getMaterial().add(parseDeviceDefinitionDeviceDefinitionMaterialComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
    parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(json.getAsJsonObject("_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(json.getAsJsonObject("_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(json.getAsJsonObject("_jurisdiction"), res.getJurisdictionElement());
  }

  protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceDefinitionDeviceNameComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
    parseDeviceDefinitionDeviceDefinitionDeviceNameComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionDeviceNameComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceDefinition.DeviceNameType.NULL, new DeviceDefinition.DeviceNameTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected DeviceDefinition.DeviceDefinitionSpecializationComponent parseDeviceDefinitionDeviceDefinitionSpecializationComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionSpecializationComponent res = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
    parseDeviceDefinitionDeviceDefinitionSpecializationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionSpecializationComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionSpecializationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("systemType"))
      res.setSystemTypeElement(parseString(json.get("systemType").getAsString()));
    if (json.has("_systemType"))
      parseElementProperties(json.getAsJsonObject("_systemType"), res.getSystemTypeElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
  }

  protected DeviceDefinition.DeviceDefinitionCapabilityComponent parseDeviceDefinitionDeviceDefinitionCapabilityComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionCapabilityComponent res = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
    parseDeviceDefinitionDeviceDefinitionCapabilityComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionCapabilityComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionCapabilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("description")) {
      JsonArray array = json.getAsJsonArray("description");
      for (int i = 0; i < array.size(); i++) {
        res.getDescription().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionDeviceDefinitionPropertyComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
    parseDeviceDefinitionDeviceDefinitionPropertyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionPropertyComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("valueQuanity")) {
      JsonArray array = json.getAsJsonArray("valueQuanity");
      for (int i = 0; i < array.size(); i++) {
        res.getValueQuanity().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionDeviceDefinitionMaterialComponent(JsonObject json, DeviceDefinition owner) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
    parseDeviceDefinitionDeviceDefinitionMaterialComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceDefinitionMaterialComponentProperties(JsonObject json, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("alternate"))
      res.setAlternateElement(parseBoolean(json.get("alternate").getAsBoolean()));
    if (json.has("_alternate"))
      parseElementProperties(json.getAsJsonObject("_alternate"), res.getAlternateElement());
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(json.getAsJsonObject("_allergenicIndicator"), res.getAllergenicIndicatorElement());
  }

  protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseDeviceMetricProperties(json, res);
    return res;
  }

  protected void parseDeviceMetricProperties(JsonObject json, DeviceMetric res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("operationalStatus"))
      res.setOperationalStatusElement(parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
    if (json.has("_operationalStatus"))
      parseElementProperties(json.getAsJsonObject("_operationalStatus"), res.getOperationalStatusElement());
    if (json.has("color"))
      res.setColorElement(parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
    if (json.has("_color"))
      parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("measurementPeriod"))
      res.setMeasurementPeriod(parseTiming(json.getAsJsonObject("measurementPeriod")));
    if (json.has("calibration")) {
      JsonArray array = json.getAsJsonArray("calibration");
      for (int i = 0; i < array.size(); i++) {
        res.getCalibration().add(parseDeviceMetricDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(JsonObject json, DeviceMetric owner) throws IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseDeviceMetricDeviceMetricCalibrationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceMetricDeviceMetricCalibrationComponentProperties(JsonObject json, DeviceMetric owner, DeviceMetric.DeviceMetricCalibrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("state"))
      res.setStateElement(parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
    if (json.has("_state"))
      parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
    if (json.has("time"))
      res.setTimeElement(parseInstant(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
  }

  protected DeviceRequest parseDeviceRequest(JsonObject json) throws IOException, FHIRFormatError {
    DeviceRequest res = new DeviceRequest();
    parseDeviceRequestProperties(json, res);
    return res;
  }

  protected void parseDeviceRequestProperties(JsonObject json, DeviceRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priorRequest")) {
      JsonArray array = json.getAsJsonArray("priorRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getPriorRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceRequest.DeviceRequestStatus.NULL, new DeviceRequest.DeviceRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), DeviceRequest.RequestIntent.NULL, new DeviceRequest.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), DeviceRequest.RequestPriority.NULL, new DeviceRequest.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    Type code = parseType("code", json);
    if (code != null)
      res.setCode(code);
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseDeviceRequestDeviceRequestParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("performerType"))
      res.setPerformerType(parseCodeableConcept(json.getAsJsonObject("performerType")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestDeviceRequestParameterComponent(JsonObject json, DeviceRequest owner) throws IOException, FHIRFormatError {
    DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
    parseDeviceRequestDeviceRequestParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDeviceRequestDeviceRequestParameterComponentProperties(JsonObject json, DeviceRequest owner, DeviceRequest.DeviceRequestParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
    DeviceUseStatement res = new DeviceUseStatement();
    parseDeviceUseStatementProperties(json, res);
    return res;
  }

  protected void parseDeviceUseStatementProperties(JsonObject json, DeviceUseStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("recordedOn"))
      res.setRecordedOnElement(parseDateTime(json.get("recordedOn").getAsString()));
    if (json.has("_recordedOn"))
      parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseDiagnosticReportProperties(json, res);
    return res;
  }

  protected void parseDiagnosticReportProperties(JsonObject json, DiagnosticReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("resultsInterpreter")) {
      JsonArray array = json.getAsJsonArray("resultsInterpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getResultsInterpreter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("result")) {
      JsonArray array = json.getAsJsonArray("result");
      for (int i = 0; i < array.size(); i++) {
        res.getResult().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("imagingStudy")) {
      JsonArray array = json.getAsJsonArray("imagingStudy");
      for (int i = 0; i < array.size(); i++) {
        res.getImagingStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("media")) {
      JsonArray array = json.getAsJsonArray("media");
      for (int i = 0; i < array.size(); i++) {
        res.getMedia().add(parseDiagnosticReportDiagnosticReportMediaComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("conclusion"))
      res.setConclusionElement(parseString(json.get("conclusion").getAsString()));
    if (json.has("_conclusion"))
      parseElementProperties(json.getAsJsonObject("_conclusion"), res.getConclusionElement());
    if (json.has("conclusionCode")) {
      JsonArray array = json.getAsJsonArray("conclusionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getConclusionCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("presentedForm")) {
      JsonArray array = json.getAsJsonArray("presentedForm");
      for (int i = 0; i < array.size(); i++) {
        res.getPresentedForm().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportDiagnosticReportMediaComponent(JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
    parseDiagnosticReportDiagnosticReportMediaComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDiagnosticReportDiagnosticReportMediaComponentProperties(JsonObject json, DiagnosticReport owner, DiagnosticReport.DiagnosticReportMediaComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("link"))
      res.setLink(parseReference(json.getAsJsonObject("link")));
  }

  protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
    DocumentManifest res = new DocumentManifest();
    parseDocumentManifestProperties(json, res);
    return res;
  }

  protected void parseDocumentManifestProperties(JsonObject json, DocumentManifest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(json.getAsJsonObject("masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseDocumentManifestDocumentManifestAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseDocumentManifestDocumentManifestRelatedComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected DocumentManifest.DocumentManifestAgentComponent parseDocumentManifestDocumentManifestAgentComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestAgentComponent res = new DocumentManifest.DocumentManifestAgentComponent();
    parseDocumentManifestDocumentManifestAgentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentManifestDocumentManifestAgentComponentProperties(JsonObject json, DocumentManifest owner, DocumentManifest.DocumentManifestAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("who"))
      res.setWho(parseReference(json.getAsJsonObject("who")));
  }

  protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
    parseDocumentManifestDocumentManifestRelatedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentManifestDocumentManifestRelatedComponentProperties(JsonObject json, DocumentManifest owner, DocumentManifest.DocumentManifestRelatedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("ref"))
      res.setRef(parseReference(json.getAsJsonObject("ref")));
  }

  protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseDocumentReferenceProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceProperties(JsonObject json, DocumentReference res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(json.getAsJsonObject("masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("docStatus"))
      res.setDocStatusElement(parseEnumeration(json.get("docStatus").getAsString(), DocumentReference.ReferredDocumentStatus.NULL, new DocumentReference.ReferredDocumentStatusEnumFactory()));
    if (json.has("_docStatus"))
      parseElementProperties(json.getAsJsonObject("_docStatus"), res.getDocStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("date"))
      res.setDateElement(parseInstant(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseDocumentReferenceDocumentReferenceAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("authenticator"))
      res.setAuthenticator(parseReference(json.getAsJsonObject("authenticator")));
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseDocumentReferenceDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseDocumentReferenceDocumentReferenceContentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("context"))
      res.setContext(parseDocumentReferenceDocumentReferenceContextComponent(json.getAsJsonObject("context"), res));
  }

  protected DocumentReference.DocumentReferenceAgentComponent parseDocumentReferenceDocumentReferenceAgentComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceAgentComponent res = new DocumentReference.DocumentReferenceAgentComponent();
    parseDocumentReferenceDocumentReferenceAgentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceAgentComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("who"))
      res.setWho(parseReference(json.getAsJsonObject("who")));
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseDocumentReferenceDocumentReferenceRelatesToComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceRelatesToComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseDocumentReferenceDocumentReferenceContentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceContentComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("attachment"))
      res.setAttachment(parseAttachment(json.getAsJsonObject("attachment")));
    if (json.has("format"))
      res.setFormat(parseCoding(json.getAsJsonObject("format")));
  }

  protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
    parseDocumentReferenceDocumentReferenceContextComponentProperties(json, owner, res);
    return res;
  }

  protected void parseDocumentReferenceDocumentReferenceContextComponentProperties(JsonObject json, DocumentReference owner, DocumentReference.DocumentReferenceContextComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("facilityType"))
      res.setFacilityType(parseCodeableConcept(json.getAsJsonObject("facilityType")));
    if (json.has("practiceSetting"))
      res.setPracticeSetting(parseCodeableConcept(json.getAsJsonObject("practiceSetting")));
    if (json.has("sourcePatientInfo"))
      res.setSourcePatientInfo(parseReference(json.getAsJsonObject("sourcePatientInfo")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseEncounterProperties(json, res);
    return res;
  }

  protected void parseEncounterProperties(JsonObject json, Encounter res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEncounterStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("class"))
      res.setClass_(parseCoding(json.getAsJsonObject("class")));
    if (json.has("classHistory")) {
      JsonArray array = json.getAsJsonArray("classHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getClassHistory().add(parseEncounterClassHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceType"))
      res.setServiceType(parseCodeableConcept(json.getAsJsonObject("serviceType")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("episodeOfCare")) {
      JsonArray array = json.getAsJsonArray("episodeOfCare");
      for (int i = 0; i < array.size(); i++) {
        res.getEpisodeOfCare().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseEncounterEncounterParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("appointment"))
      res.setAppointment(parseReference(json.getAsJsonObject("appointment")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("length"))
      res.setLength(parseDuration(json.getAsJsonObject("length")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEncounterDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("hospitalization"))
      res.setHospitalization(parseEncounterEncounterHospitalizationComponent(json.getAsJsonObject("hospitalization"), res));
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseEncounterEncounterLocationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("serviceProvider"))
      res.setServiceProvider(parseReference(json.getAsJsonObject("serviceProvider")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
  }

  protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
    parseEncounterStatusHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterStatusHistoryComponentProperties(JsonObject json, Encounter owner, Encounter.StatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
    parseEncounterClassHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterClassHistoryComponentProperties(JsonObject json, Encounter owner, Encounter.ClassHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("class"))
      res.setClass_(parseCoding(json.getAsJsonObject("class")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseEncounterEncounterParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterParticipantComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("individual"))
      res.setIndividual(parseReference(json.getAsJsonObject("individual")));
  }

  protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
    parseEncounterDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterDiagnosisComponentProperties(JsonObject json, Encounter owner, Encounter.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseReference(json.getAsJsonObject("condition")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
  }

  protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
    parseEncounterEncounterHospitalizationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterHospitalizationComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterHospitalizationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("preAdmissionIdentifier"))
      res.setPreAdmissionIdentifier(parseIdentifier(json.getAsJsonObject("preAdmissionIdentifier")));
    if (json.has("origin"))
      res.setOrigin(parseReference(json.getAsJsonObject("origin")));
    if (json.has("admitSource"))
      res.setAdmitSource(parseCodeableConcept(json.getAsJsonObject("admitSource")));
    if (json.has("reAdmission"))
      res.setReAdmission(parseCodeableConcept(json.getAsJsonObject("reAdmission")));
    if (json.has("dietPreference")) {
      JsonArray array = json.getAsJsonArray("dietPreference");
      for (int i = 0; i < array.size(); i++) {
        res.getDietPreference().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialCourtesy")) {
      JsonArray array = json.getAsJsonArray("specialCourtesy");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialCourtesy().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialArrangement")) {
      JsonArray array = json.getAsJsonArray("specialArrangement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialArrangement().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("dischargeDisposition"))
      res.setDischargeDisposition(parseCodeableConcept(json.getAsJsonObject("dischargeDisposition")));
  }

  protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseEncounterEncounterLocationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEncounterEncounterLocationComponentProperties(JsonObject json, Encounter owner, Encounter.EncounterLocationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Endpoint parseEndpoint(JsonObject json) throws IOException, FHIRFormatError {
    Endpoint res = new Endpoint();
    parseEndpointProperties(json, res);
    return res;
  }

  protected void parseEndpointProperties(JsonObject json, Endpoint res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("connectionType"))
      res.setConnectionType(parseCoding(json.getAsJsonObject("connectionType")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("payloadType")) {
      JsonArray array = json.getAsJsonArray("payloadType");
      for (int i = 0; i < array.size(); i++) {
        res.getPayloadType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payloadMimeType")) {
      JsonArray array = json.getAsJsonArray("payloadMimeType");
      for (int i = 0; i < array.size(); i++) {
        res.getPayloadMimeType().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_payloadMimeType")) {
      JsonArray array = json.getAsJsonArray("_payloadMimeType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPayloadMimeType().size())
          res.getPayloadMimeType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPayloadMimeType().get(i));
      }
    };
    if (json.has("address"))
      res.setAddressElement(parseUrl(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
    if (json.has("header")) {
      JsonArray array = json.getAsJsonArray("header");
      for (int i = 0; i < array.size(); i++) {
        res.getHeader().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_header")) {
      JsonArray array = json.getAsJsonArray("_header");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getHeader().size())
          res.getHeader().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getHeader().get(i));
      }
    };
  }

  protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseEnrollmentRequestProperties(json, res);
    return res;
  }

  protected void parseEnrollmentRequestProperties(JsonObject json, EnrollmentRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EnrollmentRequest.EnrollmentRequestStatus.NULL, new EnrollmentRequest.EnrollmentRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("candidate"))
      res.setCandidate(parseReference(json.getAsJsonObject("candidate")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
  }

  protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseEnrollmentResponseProperties(json, res);
    return res;
  }

  protected void parseEnrollmentResponseProperties(JsonObject json, EnrollmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EnrollmentResponse.EnrollmentResponseStatus.NULL, new EnrollmentResponse.EnrollmentResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
  }

  protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseEpisodeOfCareProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareProperties(JsonObject json, EpisodeOfCare res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEpisodeOfCareDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("referralRequest")) {
      JsonArray array = json.getAsJsonArray("referralRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careManager"))
      res.setCareManager(parseReference(json.getAsJsonObject("careManager")));
    if (json.has("team")) {
      JsonArray array = json.getAsJsonArray("team");
      for (int i = 0; i < array.size(); i++) {
        res.getTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentProperties(JsonObject json, EpisodeOfCare owner, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
    EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
    parseEpisodeOfCareDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseEpisodeOfCareDiagnosisComponentProperties(JsonObject json, EpisodeOfCare owner, EpisodeOfCare.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseReference(json.getAsJsonObject("condition")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
  }

  protected EventDefinition parseEventDefinition(JsonObject json) throws IOException, FHIRFormatError {
    EventDefinition res = new EventDefinition();
    parseEventDefinitionProperties(json, res);
    return res;
  }

  protected void parseEventDefinitionProperties(JsonObject json, EventDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("trigger"))
      res.setTrigger(parseTriggerDefinition(json.getAsJsonObject("trigger")));
  }

  protected ExampleScenario parseExampleScenario(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario res = new ExampleScenario();
    parseExampleScenarioProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProperties(JsonObject json, ExampleScenario res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseExampleScenarioExampleScenarioActorComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseExampleScenarioExampleScenarioInstanceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("process")) {
      JsonArray array = json.getAsJsonArray("process");
      for (int i = 0; i < array.size(); i++) {
        res.getProcess().add(parseExampleScenarioExampleScenarioProcessComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("workflow")) {
      JsonArray array = json.getAsJsonArray("workflow");
      for (int i = 0; i < array.size(); i++) {
        res.getWorkflow().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_workflow")) {
      JsonArray array = json.getAsJsonArray("_workflow");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getWorkflow().size())
          res.getWorkflow().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getWorkflow().get(i));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioExampleScenarioActorComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
    parseExampleScenarioExampleScenarioActorComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioActorComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("actorId"))
      res.setActorIdElement(parseString(json.get("actorId").getAsString()));
    if (json.has("_actorId"))
      parseElementProperties(json.getAsJsonObject("_actorId"), res.getActorIdElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ExampleScenario.ExampleScenarioActorType.NULL, new ExampleScenario.ExampleScenarioActorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioExampleScenarioInstanceComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
    parseExampleScenarioExampleScenarioInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioInstanceComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("resourceId"))
      res.setResourceIdElement(parseString(json.get("resourceId").getAsString()));
    if (json.has("_resourceId"))
      parseElementProperties(json.getAsJsonObject("_resourceId"), res.getResourceIdElement());
    if (json.has("resourceType"))
      res.setResourceTypeElement(parseEnumeration(json.get("resourceType").getAsString(), ExampleScenario.FHIRResourceType.NULL, new ExampleScenario.FHIRResourceTypeEnumFactory()));
    if (json.has("_resourceType"))
      parseElementProperties(json.getAsJsonObject("_resourceType"), res.getResourceTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseExampleScenarioExampleScenarioInstanceVersionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("containedInstance")) {
      JsonArray array = json.getAsJsonArray("containedInstance");
      for (int i = 0; i < array.size(); i++) {
        res.getContainedInstance().add(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioExampleScenarioInstanceVersionComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
    parseExampleScenarioExampleScenarioInstanceVersionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioInstanceVersionComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseString(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
    parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("resourceId"))
      res.setResourceIdElement(parseString(json.get("resourceId").getAsString()));
    if (json.has("_resourceId"))
      parseElementProperties(json.getAsJsonObject("_resourceId"), res.getResourceIdElement());
    if (json.has("versionId"))
      res.setVersionIdElement(parseString(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
  }

  protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioExampleScenarioProcessComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
    parseExampleScenarioExampleScenarioProcessComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("preConditions"))
      res.setPreConditionsElement(parseMarkdown(json.get("preConditions").getAsString()));
    if (json.has("_preConditions"))
      parseElementProperties(json.getAsJsonObject("_preConditions"), res.getPreConditionsElement());
    if (json.has("postConditions"))
      res.setPostConditionsElement(parseMarkdown(json.get("postConditions").getAsString()));
    if (json.has("_postConditions"))
      parseElementProperties(json.getAsJsonObject("_postConditions"), res.getPostConditionsElement());
    if (json.has("step")) {
      JsonArray array = json.getAsJsonArray("step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseExampleScenarioExampleScenarioProcessStepComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioExampleScenarioProcessStepComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
    parseExampleScenarioExampleScenarioProcessStepComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessStepComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("process")) {
      JsonArray array = json.getAsJsonArray("process");
      for (int i = 0; i < array.size(); i++) {
        res.getProcess().add(parseExampleScenarioExampleScenarioProcessComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("pause"))
      res.setPauseElement(parseBoolean(json.get("pause").getAsBoolean()));
    if (json.has("_pause"))
      parseElementProperties(json.getAsJsonObject("_pause"), res.getPauseElement());
    if (json.has("operation"))
      res.setOperation(parseExampleScenarioExampleScenarioProcessStepOperationComponent(json.getAsJsonObject("operation"), owner));
    if (json.has("alternative"))
      res.setAlternative(parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(json.getAsJsonObject("alternative"), owner));
  }

  protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioExampleScenarioProcessStepOperationComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
    parseExampleScenarioExampleScenarioProcessStepOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessStepOperationComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parseString(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("initiator"))
      res.setInitiatorElement(parseString(json.get("initiator").getAsString()));
    if (json.has("_initiator"))
      parseElementProperties(json.getAsJsonObject("_initiator"), res.getInitiatorElement());
    if (json.has("receiver"))
      res.setReceiverElement(parseString(json.get("receiver").getAsString()));
    if (json.has("_receiver"))
      parseElementProperties(json.getAsJsonObject("_receiver"), res.getReceiverElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("initiatorActive"))
      res.setInitiatorActiveElement(parseBoolean(json.get("initiatorActive").getAsBoolean()));
    if (json.has("_initiatorActive"))
      parseElementProperties(json.getAsJsonObject("_initiatorActive"), res.getInitiatorActiveElement());
    if (json.has("receiverActive"))
      res.setReceiverActiveElement(parseBoolean(json.get("receiverActive").getAsBoolean()));
    if (json.has("_receiverActive"))
      parseElementProperties(json.getAsJsonObject("_receiverActive"), res.getReceiverActiveElement());
    if (json.has("request"))
      res.setRequest(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(json.getAsJsonObject("request"), owner));
    if (json.has("response"))
      res.setResponse(parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(json.getAsJsonObject("response"), owner));
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
    parseExampleScenarioExampleScenarioProcessStepAlternativeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessStepAlternativeComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("option")) {
      JsonArray array = json.getAsJsonArray("option");
      for (int i = 0; i < array.size(); i++) {
        res.getOption().add(parseExampleScenarioExampleScenarioProcessStepAlternativeOptionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent parseExampleScenarioExampleScenarioProcessStepAlternativeOptionComponent(JsonObject json, ExampleScenario owner) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent();
    parseExampleScenarioExampleScenarioProcessStepAlternativeOptionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExampleScenarioExampleScenarioProcessStepAlternativeOptionComponentProperties(JsonObject json, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepAlternativeOptionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("step")) {
      JsonArray array = json.getAsJsonArray("step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseExampleScenarioExampleScenarioProcessStepComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("pause")) {
      JsonArray array = json.getAsJsonArray("pause");
      for (int i = 0; i < array.size(); i++) {
        res.getPause().add(parseBoolean(array.get(i).getAsBoolean()));
      }
    };
    if (json.has("_pause")) {
      JsonArray array = json.getAsJsonArray("_pause");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPause().size())
          res.getPause().add(parseBoolean(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPause().get(i));
      }
    };
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseExplanationOfBenefitProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitProperties(JsonObject json, ExplanationOfBenefit res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ExplanationOfBenefit.Use.NULL, new ExplanationOfBenefit.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(json.getAsJsonObject("billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("referral"))
      res.setReferral(parseReference(json.getAsJsonObject("referral")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), ExplanationOfBenefit.RemittanceOutcome.NULL, new ExplanationOfBenefit.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseExplanationOfBenefitRelatedClaimComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(json.getAsJsonObject("prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(json.getAsJsonObject("originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseExplanationOfBenefitPayeeComponent(json.getAsJsonObject("payee"), res));
    if (json.has("information")) {
      JsonArray array = json.getAsJsonArray("information");
      for (int i = 0; i < array.size(); i++) {
        res.getInformation().add(parseExplanationOfBenefitSupportingInformationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseExplanationOfBenefitCareTeamComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("precedence"))
      res.setPrecedenceElement(parsePositiveInt(json.get("precedence").getAsString()));
    if (json.has("_precedence"))
      parseElementProperties(json.getAsJsonObject("_precedence"), res.getPrecedenceElement());
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseExplanationOfBenefitInsuranceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseExplanationOfBenefitAccidentComponent(json.getAsJsonObject("accident"), res));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseExplanationOfBenefitItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("total")) {
      JsonArray array = json.getAsJsonArray("total");
      for (int i = 0; i < array.size(); i++) {
        res.getTotal().add(parseExplanationOfBenefitTotalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("payment"))
      res.setPayment(parseExplanationOfBenefitPaymentComponent(json.getAsJsonObject("payment"), res));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseExplanationOfBenefitNoteComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("benefitBalance")) {
      JsonArray array = json.getAsJsonArray("benefitBalance");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefitBalance().add(parseExplanationOfBenefitBenefitBalanceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
    parseExplanationOfBenefitRelatedClaimComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitRelatedClaimComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(json.getAsJsonObject("reference")));
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseExplanationOfBenefitPayeeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitPayeeComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("resource"))
      res.setResource(parseCoding(json.getAsJsonObject("resource")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
    parseExplanationOfBenefitSupportingInformationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitSupportingInformationComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
  }

  protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
    parseExplanationOfBenefitCareTeamComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitCareTeamComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("qualification"))
      res.setQualification(parseCodeableConcept(json.getAsJsonObject("qualification")));
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseExplanationOfBenefitDiagnosisComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitDiagnosisComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    Type diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmission(parseCodeableConcept(json.getAsJsonObject("onAdmission")));
    if (json.has("packageCode"))
      res.setPackageCode(parseCodeableConcept(json.getAsJsonObject("packageCode")));
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseExplanationOfBenefitProcedureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitProcedureComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    Type procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
  }

  protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
    parseExplanationOfBenefitInsuranceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitInsuranceComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
  }

  protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
    parseExplanationOfBenefitAccidentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAccidentComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
    parseExplanationOfBenefitItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitItemComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeamSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("_careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamSequence().size())
          res.getCareTeamSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCareTeamSequence().get(i));
      }
    };
    if (json.has("diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosisSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("_diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisSequence().size())
          res.getDiagnosisSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisSequence().get(i));
      }
    };
    if (json.has("procedureSequence")) {
      JsonArray array = json.getAsJsonArray("procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedureSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_procedureSequence")) {
      JsonArray array = json.getAsJsonArray("_procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureSequence().size())
          res.getProcedureSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProcedureSequence().get(i));
      }
    };
    if (json.has("informationSequence")) {
      JsonArray array = json.getAsJsonArray("informationSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_informationSequence")) {
      JsonArray array = json.getAsJsonArray("_informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationSequence().size())
          res.getInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInformationSequence().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
    parseExplanationOfBenefitAdjudicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAdjudicationComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseExplanationOfBenefitDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseExplanationOfBenefitSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseExplanationOfBenefitAddedItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence")) {
      JsonArray array = json.getAsJsonArray("itemSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getItemSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_itemSequence")) {
      JsonArray array = json.getAsJsonArray("_itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getItemSequence().size())
          res.getItemSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getItemSequence().get(i));
      }
    };
    if (json.has("detailSequence")) {
      JsonArray array = json.getAsJsonArray("detailSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_detailSequence")) {
      JsonArray array = json.getAsJsonArray("_detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDetailSequence().size())
          res.getDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDetailSequence().get(i));
      }
    };
    if (json.has("subDetailSequence")) {
      JsonArray array = json.getAsJsonArray("subDetailSequence");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_subDetailSequence")) {
      JsonArray array = json.getAsJsonArray("_subDetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubDetailSequence().size())
          res.getSubDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSubDetailSequence().get(i));
      }
    };
    if (json.has("provider")) {
      JsonArray array = json.getAsJsonArray("provider");
      for (int i = 0; i < array.size(); i++) {
        res.getProvider().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    Type location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitAddedItemDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
    parseExplanationOfBenefitAddedItemDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitAddedItemDetailSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
    parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("billcode"))
      res.setBillcode(parseCodeableConcept(json.getAsJsonObject("billcode")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
    parseExplanationOfBenefitTotalComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitTotalComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.TotalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
    parseExplanationOfBenefitPaymentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitPaymentComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(json.getAsJsonObject("adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(json.getAsJsonObject("adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
  }

  protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
    parseExplanationOfBenefitNoteComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitNoteComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseExplanationOfBenefitBenefitBalanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitBalanceComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitBalanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(json.getAsJsonObject("_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(json.getAsJsonObject("network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(json.getAsJsonObject("term")));
    if (json.has("financial")) {
      JsonArray array = json.getAsJsonArray("financial");
      for (int i = 0; i < array.size(); i++) {
        res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseExplanationOfBenefitBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitComponentProperties(JsonObject json, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    Type used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseFamilyMemberHistoryProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryProperties(JsonObject json, FamilyMemberHistory res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("gender"))
      res.setGender(parseCodeableConcept(json.getAsJsonObject("gender")));
    Type born = parseType("born", json);
    if (born != null)
      res.setBorn(born);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("estimatedAge"))
      res.setEstimatedAgeElement(parseBoolean(json.get("estimatedAge").getAsBoolean()));
    if (json.has("_estimatedAge"))
      parseElementProperties(json.getAsJsonObject("_estimatedAge"), res.getEstimatedAgeElement());
    Type deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(JsonObject json, FamilyMemberHistory owner) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentProperties(JsonObject json, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
    Flag res = new Flag();
    parseFlagProperties(json, res);
    return res;
  }

  protected void parseFlagProperties(JsonObject json, Flag res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
    Goal res = new Goal();
    parseGoalProperties(json, res);
    return res;
  }

  protected void parseGoalProperties(JsonObject json, Goal res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("description"))
      res.setDescription(parseCodeableConcept(json.getAsJsonObject("description")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    Type start = parseType("start", json);
    if (start != null)
      res.setStart(start);
    if (json.has("target"))
      res.setTarget(parseGoalGoalTargetComponent(json.getAsJsonObject("target"), res));
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
    if (json.has("statusReason"))
      res.setStatusReasonElement(parseString(json.get("statusReason").getAsString()));
    if (json.has("_statusReason"))
      parseElementProperties(json.getAsJsonObject("_statusReason"), res.getStatusReasonElement());
    if (json.has("expressedBy"))
      res.setExpressedBy(parseReference(json.getAsJsonObject("expressedBy")));
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeCode")) {
      JsonArray array = json.getAsJsonArray("outcomeCode");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcomeReference")) {
      JsonArray array = json.getAsJsonArray("outcomeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcomeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Goal.GoalTargetComponent parseGoalGoalTargetComponent(JsonObject json, Goal owner) throws IOException, FHIRFormatError {
    Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
    parseGoalGoalTargetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGoalGoalTargetComponentProperties(JsonObject json, Goal owner, Goal.GoalTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("measure"))
      res.setMeasure(parseCodeableConcept(json.getAsJsonObject("measure")));
    Type detail = parseType("detail", json);
    if (detail != null)
      res.setDetail(detail);
    Type due = parseType("due", json);
    if (due != null)
      res.setDue(due);
  }

  protected GraphDefinition parseGraphDefinition(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition res = new GraphDefinition();
    parseGraphDefinitionProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionProperties(JsonObject json, GraphDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("start"))
      res.setStartElement(parseCode(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionGraphDefinitionLinkComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
    parseGraphDefinitionGraphDefinitionLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(json.getAsJsonObject("_sliceName"), res.getSliceNameElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseGraphDefinitionGraphDefinitionLinkTargetComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionGraphDefinitionLinkTargetComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
    parseGraphDefinitionGraphDefinitionLinkTargetComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkTargetComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("params"))
      res.setParamsElement(parseString(json.get("params").getAsString()));
    if (json.has("_params"))
      parseElementProperties(json.getAsJsonObject("_params"), res.getParamsElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        res.getCompartment().add(parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionGraphDefinitionLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(JsonObject json, GraphDefinition owner) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
    parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentProperties(JsonObject json, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), GraphDefinition.CompartmentCode.NULL, new GraphDefinition.CompartmentCodeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("rule"))
      res.setRuleElement(parseEnumeration(json.get("rule").getAsString(), GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
    if (json.has("_rule"))
      parseElementProperties(json.getAsJsonObject("_rule"), res.getRuleElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
    Group res = new Group();
    parseGroupProperties(json, res);
    return res;
  }

  protected void parseGroupProperties(JsonObject json, Group res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(json.getAsJsonObject("_actual"), res.getActualElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("quantity"))
      res.setQuantityElement(parseUnsignedInt(json.get("quantity").getAsString()));
    if (json.has("_quantity"))
      parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseGroupGroupCharacteristicComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("member")) {
      JsonArray array = json.getAsJsonArray("member");
      for (int i = 0; i < array.size(); i++) {
        res.getMember().add(parseGroupGroupMemberComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseGroupGroupCharacteristicComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGroupGroupCharacteristicComponentProperties(JsonObject json, Group owner, Group.GroupCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(json.getAsJsonObject("_exclude"), res.getExcludeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Group.GroupMemberComponent parseGroupGroupMemberComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseGroupGroupMemberComponentProperties(json, owner, res);
    return res;
  }

  protected void parseGroupGroupMemberComponentProperties(JsonObject json, Group owner, Group.GroupMemberComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("entity"))
      res.setEntity(parseReference(json.getAsJsonObject("entity")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("inactive"))
      res.setInactiveElement(parseBoolean(json.get("inactive").getAsBoolean()));
    if (json.has("_inactive"))
      parseElementProperties(json.getAsJsonObject("_inactive"), res.getInactiveElement());
  }

  protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseGuidanceResponseProperties(json, res);
    return res;
  }

  protected void parseGuidanceResponseProperties(JsonObject json, GuidanceResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("requestIdentifier"))
      res.setRequestIdentifier(parseIdentifier(json.getAsJsonObject("requestIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    Type module = parseType("module", json);
    if (module != null)
      res.setModule(module);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("occurrenceDateTime"))
      res.setOccurrenceDateTimeElement(parseDateTime(json.get("occurrenceDateTime").getAsString()));
    if (json.has("_occurrenceDateTime"))
      parseElementProperties(json.getAsJsonObject("_occurrenceDateTime"), res.getOccurrenceDateTimeElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evaluationMessage")) {
      JsonArray array = json.getAsJsonArray("evaluationMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getEvaluationMessage().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outputParameters"))
      res.setOutputParameters(parseReference(json.getAsJsonObject("outputParameters")));
    if (json.has("result"))
      res.setResult(parseReference(json.getAsJsonObject("result")));
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseHealthcareServiceProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceProperties(JsonObject json, HealthcareService res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("providedBy"))
      res.setProvidedBy(parseReference(json.getAsJsonObject("providedBy")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("extraDetails"))
      res.setExtraDetailsElement(parseString(json.get("extraDetails").getAsString()));
    if (json.has("_extraDetails"))
      parseElementProperties(json.getAsJsonObject("_extraDetails"), res.getExtraDetailsElement());
    if (json.has("photo"))
      res.setPhoto(parseAttachment(json.getAsJsonObject("photo")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceProvisionCode")) {
      JsonArray array = json.getAsJsonArray("serviceProvisionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceProvisionCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eligibility"))
      res.setEligibility(parseCodeableConcept(json.getAsJsonObject("eligibility")));
    if (json.has("eligibilityNote"))
      res.setEligibilityNoteElement(parseString(json.get("eligibilityNote").getAsString()));
    if (json.has("_eligibilityNote"))
      parseElementProperties(json.getAsJsonObject("_eligibilityNote"), res.getEligibilityNoteElement());
    if (json.has("programName")) {
      JsonArray array = json.getAsJsonArray("programName");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramName().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_programName")) {
      JsonArray array = json.getAsJsonArray("_programName");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProgramName().size())
          res.getProgramName().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProgramName().get(i));
      }
    };
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referralMethod")) {
      JsonArray array = json.getAsJsonArray("referralMethod");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralMethod().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentRequired"))
      res.setAppointmentRequiredElement(parseBoolean(json.get("appointmentRequired").getAsBoolean()));
    if (json.has("_appointmentRequired"))
      parseElementProperties(json.getAsJsonObject("_appointmentRequired"), res.getAppointmentRequiredElement());
    if (json.has("availableTime")) {
      JsonArray array = json.getAsJsonArray("availableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailableTime().add(parseHealthcareServiceHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("notAvailable")) {
      JsonArray array = json.getAsJsonArray("notAvailable");
      for (int i = 0; i < array.size(); i++) {
        res.getNotAvailable().add(parseHealthcareServiceHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
    parseHealthcareServiceHealthcareServiceAvailableTimeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseHealthcareServiceHealthcareServiceAvailableTimeComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
    if (json.has("availableStartTime"))
      res.setAvailableStartTimeElement(parseTime(json.get("availableStartTime").getAsString()));
    if (json.has("_availableStartTime"))
      parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
    if (json.has("availableEndTime"))
      res.setAvailableEndTimeElement(parseTime(json.get("availableEndTime").getAsString()));
    if (json.has("_availableEndTime"))
      parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
  }

  protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
    parseHealthcareServiceHealthcareServiceNotAvailableComponentProperties(json, owner, res);
    return res;
  }

  protected void parseHealthcareServiceHealthcareServiceNotAvailableComponentProperties(JsonObject json, HealthcareService owner, HealthcareService.HealthcareServiceNotAvailableComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("during"))
      res.setDuring(parsePeriod(json.getAsJsonObject("during")));
  }

  protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseImagingStudyProperties(json, res);
    return res;
  }

  protected void parseImagingStudyProperties(JsonObject json, ImagingStudy res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("modality")) {
      JsonArray array = json.getAsJsonArray("modality");
      for (int i = 0; i < array.size(); i++) {
        res.getModality().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referrer"))
      res.setReferrer(parseReference(json.getAsJsonObject("referrer")));
    if (json.has("interpreter")) {
      JsonArray array = json.getAsJsonArray("interpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpreter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("numberOfSeries"))
      res.setNumberOfSeriesElement(parseUnsignedInt(json.get("numberOfSeries").getAsString()));
    if (json.has("_numberOfSeries"))
      parseElementProperties(json.getAsJsonObject("_numberOfSeries"), res.getNumberOfSeriesElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("procedureReference"))
      res.setProcedureReference(parseReference(json.getAsJsonObject("procedureReference")));
    if (json.has("procedureCode")) {
      JsonArray array = json.getAsJsonArray("procedureCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedureCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("series")) {
      JsonArray array = json.getAsJsonArray("series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingStudyImagingStudySeriesComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseImagingStudyImagingStudySeriesComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingStudyImagingStudySeriesComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("modality"))
      res.setModality(parseCoding(json.getAsJsonObject("modality")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCoding(json.getAsJsonObject("bodySite")));
    if (json.has("laterality"))
      res.setLaterality(parseCoding(json.getAsJsonObject("laterality")));
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImagingStudyImagingStudySeriesPerformerComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingStudyImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudyImagingStudySeriesPerformerComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
    parseImagingStudyImagingStudySeriesPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingStudyImagingStudySeriesPerformerComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseImagingStudyImagingStudySeriesInstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImagingStudyImagingStudySeriesInstanceComponentProperties(JsonObject json, ImagingStudy owner, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("sopClass"))
      res.setSopClass(parseCoding(json.getAsJsonObject("sopClass")));
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
  }

  protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseImmunizationProperties(json, res);
    return res;
  }

  protected void parseImmunizationProperties(JsonObject json, Immunization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Immunization.ImmunizationStatus.NULL, new Immunization.ImmunizationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("vaccineCode"))
      res.setVaccineCode(parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    Type occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("recorded"))
      res.setRecordedElement(parseDateTime(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("primarySource"))
      res.setPrimarySourceElement(parseBoolean(json.get("primarySource").getAsBoolean()));
    if (json.has("_primarySource"))
      parseElementProperties(json.getAsJsonObject("_primarySource"), res.getPrimarySourceElement());
    if (json.has("reportOrigin"))
      res.setReportOrigin(parseCodeableConcept(json.getAsJsonObject("reportOrigin")));
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDate(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("doseQuantity"))
      res.setDoseQuantity(parseQuantity(json.getAsJsonObject("doseQuantity")));
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImmunizationImmunizationPerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("isSubpotent"))
      res.setIsSubpotentElement(parseBoolean(json.get("isSubpotent").getAsBoolean()));
    if (json.has("_isSubpotent"))
      parseElementProperties(json.getAsJsonObject("_isSubpotent"), res.getIsSubpotentElement());
    if (json.has("subpotentReason")) {
      JsonArray array = json.getAsJsonArray("subpotentReason");
      for (int i = 0; i < array.size(); i++) {
        res.getSubpotentReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("education")) {
      JsonArray array = json.getAsJsonArray("education");
      for (int i = 0; i < array.size(); i++) {
        res.getEducation().add(parseImmunizationImmunizationEducationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("programEligibility")) {
      JsonArray array = json.getAsJsonArray("programEligibility");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramEligibility().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fundingSource"))
      res.setFundingSource(parseCodeableConcept(json.getAsJsonObject("fundingSource")));
    if (json.has("protocolApplied")) {
      JsonArray array = json.getAsJsonArray("protocolApplied");
      for (int i = 0; i < array.size(); i++) {
        res.getProtocolApplied().add(parseImmunizationImmunizationProtocolAppliedComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Immunization.ImmunizationPerformerComponent parseImmunizationImmunizationPerformerComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
    parseImmunizationImmunizationPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationPerformerComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected Immunization.ImmunizationEducationComponent parseImmunizationImmunizationEducationComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationEducationComponent res = new Immunization.ImmunizationEducationComponent();
    parseImmunizationImmunizationEducationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationEducationComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationEducationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("documentType"))
      res.setDocumentTypeElement(parseString(json.get("documentType").getAsString()));
    if (json.has("_documentType"))
      parseElementProperties(json.getAsJsonObject("_documentType"), res.getDocumentTypeElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDateTime(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(json.getAsJsonObject("_publicationDate"), res.getPublicationDateElement());
    if (json.has("presentationDate"))
      res.setPresentationDateElement(parseDateTime(json.get("presentationDate").getAsString()));
    if (json.has("_presentationDate"))
      parseElementProperties(json.getAsJsonObject("_presentationDate"), res.getPresentationDateElement());
  }

  protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationImmunizationProtocolAppliedComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
    parseImmunizationImmunizationProtocolAppliedComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationImmunizationProtocolAppliedComponentProperties(JsonObject json, Immunization owner, Immunization.ImmunizationProtocolAppliedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("targetDisease"))
      res.setTargetDisease(parseCodeableConcept(json.getAsJsonObject("targetDisease")));
    Type doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
  }

  protected ImmunizationEvaluation parseImmunizationEvaluation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationEvaluation res = new ImmunizationEvaluation();
    parseImmunizationEvaluationProperties(json, res);
    return res;
  }

  protected void parseImmunizationEvaluationProperties(JsonObject json, ImmunizationEvaluation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImmunizationEvaluation.ImmunizationEvaluationStatus.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("targetDisease"))
      res.setTargetDisease(parseCodeableConcept(json.getAsJsonObject("targetDisease")));
    if (json.has("immunizationEvent"))
      res.setImmunizationEvent(parseReference(json.getAsJsonObject("immunizationEvent")));
    if (json.has("doseStatus"))
      res.setDoseStatus(parseCodeableConcept(json.getAsJsonObject("doseStatus")));
    if (json.has("doseStatusReason")) {
      JsonArray array = json.getAsJsonArray("doseStatusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getDoseStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    Type doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
    Type seriesDoses = parseType("seriesDoses", json);
    if (seriesDoses != null)
      res.setSeriesDoses(seriesDoses);
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseImmunizationRecommendationProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationProperties(JsonObject json, ImmunizationRecommendation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("recommendation")) {
      JsonArray array = json.getAsJsonArray("recommendation");
      for (int i = 0; i < array.size(); i++) {
        res.getRecommendation().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("vaccineCode")) {
      JsonArray array = json.getAsJsonArray("vaccineCode");
      for (int i = 0; i < array.size(); i++) {
        res.getVaccineCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("targetDisease"))
      res.setTargetDisease(parseCodeableConcept(json.getAsJsonObject("targetDisease")));
    if (json.has("contraindicatedVaccineCode")) {
      JsonArray array = json.getAsJsonArray("contraindicatedVaccineCode");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindicatedVaccineCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("forecastStatus"))
      res.setForecastStatus(parseCodeableConcept(json.getAsJsonObject("forecastStatus")));
    if (json.has("forecastReason")) {
      JsonArray array = json.getAsJsonArray("forecastReason");
      for (int i = 0; i < array.size(); i++) {
        res.getForecastReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dateCriterion")) {
      JsonArray array = json.getAsJsonArray("dateCriterion");
      for (int i = 0; i < array.size(); i++) {
        res.getDateCriterion().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    Type doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
    Type seriesDoses = parseType("seriesDoses", json);
    if (seriesDoses != null)
      res.setSeriesDoses(seriesDoses);
    if (json.has("supportingImmunization")) {
      JsonArray array = json.getAsJsonArray("supportingImmunization");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingImmunization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingPatientInformation")) {
      JsonArray array = json.getAsJsonArray("supportingPatientInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingPatientInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentProperties(JsonObject json, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("value"))
      res.setValueElement(parseDateTime(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseImplementationGuideProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideProperties(JsonObject json, ImplementationGuide res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("packageId"))
      res.setPackageIdElement(parseId(json.get("packageId").getAsString()));
    if (json.has("_packageId"))
      parseElementProperties(json.getAsJsonObject("_packageId"), res.getPackageIdElement());
    if (json.has("license"))
      res.setLicenseElement(parseEnumeration(json.get("license").getAsString(), ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
    if (json.has("_license"))
      parseElementProperties(json.getAsJsonObject("_license"), res.getLicenseElement());
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseId(json.get("fhirVersion").getAsString()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("dependsOn")) {
      JsonArray array = json.getAsJsonArray("dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseImplementationGuideImplementationGuideDependsOnComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("global")) {
      JsonArray array = json.getAsJsonArray("global");
      for (int i = 0; i < array.size(); i++) {
        res.getGlobal().add(parseImplementationGuideImplementationGuideGlobalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("definition"))
      res.setDefinition(parseImplementationGuideImplementationGuideDefinitionComponent(json.getAsJsonObject("definition"), res));
    if (json.has("manifest"))
      res.setManifest(parseImplementationGuideImplementationGuideManifestComponent(json.getAsJsonObject("manifest"), res));
  }

  protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideImplementationGuideDependsOnComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
    parseImplementationGuideImplementationGuideDependsOnComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDependsOnComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uri"))
      res.setUriElement(parseCanonical(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("packageId"))
      res.setPackageIdElement(parseId(json.get("packageId").getAsString()));
    if (json.has("_packageId"))
      parseElementProperties(json.getAsJsonObject("_packageId"), res.getPackageIdElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseImplementationGuideImplementationGuideGlobalComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideGlobalComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideGlobalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideImplementationGuideDefinitionComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
    parseImplementationGuideImplementationGuideDefinitionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("package")) {
      JsonArray array = json.getAsJsonArray("package");
      for (int i = 0; i < array.size(); i++) {
        res.getPackage().add(parseImplementationGuideImplementationGuideDefinitionPackageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideImplementationGuideDefinitionResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("page"))
      res.setPage(parseImplementationGuideImplementationGuideDefinitionPageComponent(json.getAsJsonObject("page"), owner));
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseImplementationGuideImplementationGuideDefinitionParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("template")) {
      JsonArray array = json.getAsJsonArray("template");
      for (int i = 0; i < array.size(); i++) {
        res.getTemplate().add(parseImplementationGuideImplementationGuideDefinitionTemplateComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuideDefinitionPackageComponent parseImplementationGuideImplementationGuideDefinitionPackageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionPackageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPackageComponent();
    parseImplementationGuideImplementationGuideDefinitionPackageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionPackageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionPackageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideImplementationGuideDefinitionResourceComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
    parseImplementationGuideImplementationGuideDefinitionResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionResourceComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    Type example = parseType("example", json);
    if (example != null)
      res.setExample(example);
    if (json.has("package"))
      res.setPackageElement(parseId(json.get("package").getAsString()));
    if (json.has("_package"))
      parseElementProperties(json.getAsJsonObject("_package"), res.getPackageElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideImplementationGuideDefinitionPageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
    parseImplementationGuideImplementationGuideDefinitionPageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionPageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type name = parseType("name", json);
    if (name != null)
      res.setName(name);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("generation"))
      res.setGenerationElement(parseEnumeration(json.get("generation").getAsString(), ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
    if (json.has("_generation"))
      parseElementProperties(json.getAsJsonObject("_generation"), res.getGenerationElement());
    if (json.has("page")) {
      JsonArray array = json.getAsJsonArray("page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideImplementationGuideDefinitionPageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideImplementationGuideDefinitionParameterComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
    parseImplementationGuideImplementationGuideDefinitionParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionParameterComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), ImplementationGuide.GuideParameterCode.NULL, new ImplementationGuide.GuideParameterCodeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideImplementationGuideDefinitionTemplateComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
    parseImplementationGuideImplementationGuideDefinitionTemplateComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideDefinitionTemplateComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("source"))
      res.setSourceElement(parseString(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("scope"))
      res.setScopeElement(parseString(json.get("scope").getAsString()));
    if (json.has("_scope"))
      parseElementProperties(json.getAsJsonObject("_scope"), res.getScopeElement());
  }

  protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideImplementationGuideManifestComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
    parseImplementationGuideImplementationGuideManifestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideImplementationGuideManifestComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ImplementationGuideManifestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("rendering"))
      res.setRenderingElement(parseUrl(json.get("rendering").getAsString()));
    if (json.has("_rendering"))
      parseElementProperties(json.getAsJsonObject("_rendering"), res.getRenderingElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideManifestResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("page")) {
      JsonArray array = json.getAsJsonArray("page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideManifestPageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_image")) {
      JsonArray array = json.getAsJsonArray("_image");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImage().size())
          res.getImage().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImage().get(i));
      }
    };
    if (json.has("other")) {
      JsonArray array = json.getAsJsonArray("other");
      for (int i = 0; i < array.size(); i++) {
        res.getOther().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_other")) {
      JsonArray array = json.getAsJsonArray("_other");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOther().size())
          res.getOther().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOther().get(i));
      }
    };
  }

  protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
    parseImplementationGuideManifestResourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideManifestResourceComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ManifestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    Type example = parseType("example", json);
    if (example != null)
      res.setExample(example);
    if (json.has("relativePath"))
      res.setRelativePathElement(parseUrl(json.get("relativePath").getAsString()));
    if (json.has("_relativePath"))
      parseElementProperties(json.getAsJsonObject("_relativePath"), res.getRelativePathElement());
  }

  protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
    parseImplementationGuideManifestPageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseImplementationGuideManifestPageComponentProperties(JsonObject json, ImplementationGuide owner, ImplementationGuide.ManifestPageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("anchor")) {
      JsonArray array = json.getAsJsonArray("anchor");
      for (int i = 0; i < array.size(); i++) {
        res.getAnchor().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_anchor")) {
      JsonArray array = json.getAsJsonArray("_anchor");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAnchor().size())
          res.getAnchor().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAnchor().get(i));
      }
    };
  }

  protected InsurancePlan parseInsurancePlan(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan res = new InsurancePlan();
    parseInsurancePlanProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanProperties(JsonObject json, InsurancePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("ownedBy"))
      res.setOwnedBy(parseReference(json.getAsJsonObject("ownedBy")));
    if (json.has("administeredBy"))
      res.setAdministeredBy(parseReference(json.getAsJsonObject("administeredBy")));
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseInsurancePlanInsurancePlanContactComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseInsurancePlanInsurancePlanCoverageComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("plan")) {
      JsonArray array = json.getAsJsonArray("plan");
      for (int i = 0; i < array.size(); i++) {
        res.getPlan().add(parseInsurancePlanInsurancePlanPlanComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected InsurancePlan.InsurancePlanContactComponent parseInsurancePlanInsurancePlanContactComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanContactComponent res = new InsurancePlan.InsurancePlanContactComponent();
    parseInsurancePlanInsurancePlanContactComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanContactComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanContactComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("purpose"))
      res.setPurpose(parseCodeableConcept(json.getAsJsonObject("purpose")));
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
  }

  protected InsurancePlan.InsurancePlanCoverageComponent parseInsurancePlanInsurancePlanCoverageComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanCoverageComponent res = new InsurancePlan.InsurancePlanCoverageComponent();
    parseInsurancePlanInsurancePlanCoverageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanCoverageComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanCoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseInsurancePlanCoverageBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.CoverageBenefitComponent parseInsurancePlanCoverageBenefitComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitComponent res = new InsurancePlan.CoverageBenefitComponent();
    parseInsurancePlanCoverageBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanCoverageBenefitComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.CoverageBenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("requirement"))
      res.setRequirementElement(parseString(json.get("requirement").getAsString()));
    if (json.has("_requirement"))
      parseElementProperties(json.getAsJsonObject("_requirement"), res.getRequirementElement());
    if (json.has("limit")) {
      JsonArray array = json.getAsJsonArray("limit");
      for (int i = 0; i < array.size(); i++) {
        res.getLimit().add(parseInsurancePlanCoverageBenefitLimitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.CoverageBenefitLimitComponent parseInsurancePlanCoverageBenefitLimitComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitLimitComponent res = new InsurancePlan.CoverageBenefitLimitComponent();
    parseInsurancePlanCoverageBenefitLimitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanCoverageBenefitLimitComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.CoverageBenefitLimitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValue(parseQuantity(json.getAsJsonObject("value")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected InsurancePlan.InsurancePlanPlanComponent parseInsurancePlanInsurancePlanPlanComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanComponent res = new InsurancePlan.InsurancePlanPlanComponent();
    parseInsurancePlanInsurancePlanPlanComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanPlanComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanPlanComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("generalCost")) {
      JsonArray array = json.getAsJsonArray("generalCost");
      for (int i = 0; i < array.size(); i++) {
        res.getGeneralCost().add(parseInsurancePlanInsurancePlanPlanGeneralCostComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("specificCost")) {
      JsonArray array = json.getAsJsonArray("specificCost");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecificCost().add(parseInsurancePlanInsurancePlanPlanSpecificCostComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.InsurancePlanPlanGeneralCostComponent parseInsurancePlanInsurancePlanPlanGeneralCostComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanGeneralCostComponent res = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
    parseInsurancePlanInsurancePlanPlanGeneralCostComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanPlanGeneralCostComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanPlanGeneralCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("groupSize"))
      res.setGroupSizeElement(parsePositiveInt(json.get("groupSize").getAsString()));
    if (json.has("_groupSize"))
      parseElementProperties(json.getAsJsonObject("_groupSize"), res.getGroupSizeElement());
    if (json.has("cost"))
      res.setCost(parseMoney(json.getAsJsonObject("cost")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected InsurancePlan.InsurancePlanPlanSpecificCostComponent parseInsurancePlanInsurancePlanPlanSpecificCostComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanSpecificCostComponent res = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
    parseInsurancePlanInsurancePlanPlanSpecificCostComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanInsurancePlanPlanSpecificCostComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.InsurancePlanPlanSpecificCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseInsurancePlanPlanBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.PlanBenefitComponent parseInsurancePlanPlanBenefitComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitComponent res = new InsurancePlan.PlanBenefitComponent();
    parseInsurancePlanPlanBenefitComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanPlanBenefitComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.PlanBenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("cost")) {
      JsonArray array = json.getAsJsonArray("cost");
      for (int i = 0; i < array.size(); i++) {
        res.getCost().add(parseInsurancePlanPlanBenefitCostComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected InsurancePlan.PlanBenefitCostComponent parseInsurancePlanPlanBenefitCostComponent(JsonObject json, InsurancePlan owner) throws IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitCostComponent res = new InsurancePlan.PlanBenefitCostComponent();
    parseInsurancePlanPlanBenefitCostComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInsurancePlanPlanBenefitCostComponentProperties(JsonObject json, InsurancePlan owner, InsurancePlan.PlanBenefitCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("applicability"))
      res.setApplicability(parseCodeableConcept(json.getAsJsonObject("applicability")));
    if (json.has("qualifiers")) {
      JsonArray array = json.getAsJsonArray("qualifiers");
      for (int i = 0; i < array.size(); i++) {
        res.getQualifiers().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("value"))
      res.setValue(parseQuantity(json.getAsJsonObject("value")));
  }

  protected Invoice parseInvoice(JsonObject json) throws IOException, FHIRFormatError {
    Invoice res = new Invoice();
    parseInvoiceProperties(json, res);
    return res;
  }

  protected void parseInvoiceProperties(JsonObject json, Invoice res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Invoice.InvoiceStatus.NULL, new Invoice.InvoiceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("cancelledReason"))
      res.setCancelledReasonElement(parseString(json.get("cancelledReason").getAsString()));
    if (json.has("_cancelledReason"))
      parseElementProperties(json.getAsJsonObject("_cancelledReason"), res.getCancelledReasonElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("recipient"))
      res.setRecipient(parseReference(json.getAsJsonObject("recipient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseInvoiceInvoiceParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("issuer"))
      res.setIssuer(parseReference(json.getAsJsonObject("issuer")));
    if (json.has("account"))
      res.setAccount(parseReference(json.getAsJsonObject("account")));
    if (json.has("lineItem")) {
      JsonArray array = json.getAsJsonArray("lineItem");
      for (int i = 0; i < array.size(); i++) {
        res.getLineItem().add(parseInvoiceInvoiceLineItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("totalPriceComponent")) {
      JsonArray array = json.getAsJsonArray("totalPriceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getTotalPriceComponent().add(parseInvoiceInvoiceLineItemPriceComponentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("totalNet"))
      res.setTotalNet(parseMoney(json.getAsJsonObject("totalNet")));
    if (json.has("totalGross"))
      res.setTotalGross(parseMoney(json.getAsJsonObject("totalGross")));
    if (json.has("paymentTerms"))
      res.setPaymentTermsElement(parseMarkdown(json.get("paymentTerms").getAsString()));
    if (json.has("_paymentTerms"))
      parseElementProperties(json.getAsJsonObject("_paymentTerms"), res.getPaymentTermsElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Invoice.InvoiceParticipantComponent parseInvoiceInvoiceParticipantComponent(JsonObject json, Invoice owner) throws IOException, FHIRFormatError {
    Invoice.InvoiceParticipantComponent res = new Invoice.InvoiceParticipantComponent();
    parseInvoiceInvoiceParticipantComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInvoiceInvoiceParticipantComponentProperties(JsonObject json, Invoice owner, Invoice.InvoiceParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected Invoice.InvoiceLineItemComponent parseInvoiceInvoiceLineItemComponent(JsonObject json, Invoice owner) throws IOException, FHIRFormatError {
    Invoice.InvoiceLineItemComponent res = new Invoice.InvoiceLineItemComponent();
    parseInvoiceInvoiceLineItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInvoiceInvoiceLineItemComponentProperties(JsonObject json, Invoice owner, Invoice.InvoiceLineItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    Type chargeItem = parseType("chargeItem", json);
    if (chargeItem != null)
      res.setChargeItem(chargeItem);
    if (json.has("priceComponent")) {
      JsonArray array = json.getAsJsonArray("priceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getPriceComponent().add(parseInvoiceInvoiceLineItemPriceComponentComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Invoice.InvoiceLineItemPriceComponentComponent parseInvoiceInvoiceLineItemPriceComponentComponent(JsonObject json, Invoice owner) throws IOException, FHIRFormatError {
    Invoice.InvoiceLineItemPriceComponentComponent res = new Invoice.InvoiceLineItemPriceComponentComponent();
    parseInvoiceInvoiceLineItemPriceComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseInvoiceInvoiceLineItemPriceComponentComponentProperties(JsonObject json, Invoice owner, Invoice.InvoiceLineItemPriceComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Invoice.InvoicePriceComponentType.NULL, new Invoice.InvoicePriceComponentTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected ItemInstance parseItemInstance(JsonObject json) throws IOException, FHIRFormatError {
    ItemInstance res = new ItemInstance();
    parseItemInstanceProperties(json, res);
    return res;
  }

  protected void parseItemInstanceProperties(JsonObject json, ItemInstance res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("manufactureDate"))
      res.setManufactureDateElement(parseDateTime(json.get("manufactureDate").getAsString()));
    if (json.has("_manufactureDate"))
      parseElementProperties(json.getAsJsonObject("_manufactureDate"), res.getManufactureDateElement());
    if (json.has("expiryDate"))
      res.setExpiryDateElement(parseDateTime(json.get("expiryDate").getAsString()));
    if (json.has("_expiryDate"))
      parseElementProperties(json.getAsJsonObject("_expiryDate"), res.getExpiryDateElement());
    if (json.has("currentSWVersion"))
      res.setCurrentSWVersionElement(parseString(json.get("currentSWVersion").getAsString()));
    if (json.has("_currentSWVersion"))
      parseElementProperties(json.getAsJsonObject("_currentSWVersion"), res.getCurrentSWVersionElement());
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("serialNumber"))
      res.setSerialNumberElement(parseString(json.get("serialNumber").getAsString()));
    if (json.has("_serialNumber"))
      parseElementProperties(json.getAsJsonObject("_serialNumber"), res.getSerialNumberElement());
    if (json.has("carrierAIDC"))
      res.setCarrierAIDCElement(parseString(json.get("carrierAIDC").getAsString()));
    if (json.has("_carrierAIDC"))
      parseElementProperties(json.getAsJsonObject("_carrierAIDC"), res.getCarrierAIDCElement());
    if (json.has("carrierHRF"))
      res.setCarrierHRFElement(parseString(json.get("carrierHRF").getAsString()));
    if (json.has("_carrierHRF"))
      parseElementProperties(json.getAsJsonObject("_carrierHRF"), res.getCarrierHRFElement());
  }

  protected Library parseLibrary(JsonObject json) throws IOException, FHIRFormatError {
    Library res = new Library();
    parseLibraryProperties(json, res);
    return res;
  }

  protected void parseLibraryProperties(JsonObject json, Library res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParameterDefinition(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Linkage parseLinkage(JsonObject json) throws IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseLinkageProperties(json, res);
    return res;
  }

  protected void parseLinkageProperties(JsonObject json, Linkage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseLinkageLinkageItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(JsonObject json, Linkage owner) throws IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseLinkageLinkageItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseLinkageLinkageItemComponentProperties(JsonObject json, Linkage owner, Linkage.LinkageItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
  }

  protected ListResource parseListResource(JsonObject json) throws IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseListResourceProperties(json, res);
    return res;
  }

  protected void parseListResourceProperties(JsonObject json, ListResource res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(json.getAsJsonObject("orderedBy")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseListResourceListEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(json.getAsJsonObject("emptyReason")));
  }

  protected ListResource.ListEntryComponent parseListResourceListEntryComponent(JsonObject json, ListResource owner) throws IOException, FHIRFormatError {
    ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
    parseListResourceListEntryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseListResourceListEntryComponentProperties(JsonObject json, ListResource owner, ListResource.ListEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("flag"))
      res.setFlag(parseCodeableConcept(json.getAsJsonObject("flag")));
    if (json.has("deleted"))
      res.setDeletedElement(parseBoolean(json.get("deleted").getAsBoolean()));
    if (json.has("_deleted"))
      parseElementProperties(json.getAsJsonObject("_deleted"), res.getDeletedElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("item"))
      res.setItem(parseReference(json.getAsJsonObject("item")));
  }

  protected Location parseLocation(JsonObject json) throws IOException, FHIRFormatError {
    Location res = new Location();
    parseLocationProperties(json, res);
    return res;
  }

  protected void parseLocationProperties(JsonObject json, Location res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("operationalStatus"))
      res.setOperationalStatus(parseCoding(json.getAsJsonObject("operationalStatus")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
    if (json.has("physicalType"))
      res.setPhysicalType(parseCodeableConcept(json.getAsJsonObject("physicalType")));
    if (json.has("position"))
      res.setPosition(parseLocationLocationPositionComponent(json.getAsJsonObject("position"), res));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
    if (json.has("hoursOfOperation")) {
      JsonArray array = json.getAsJsonArray("hoursOfOperation");
      for (int i = 0; i < array.size(); i++) {
        res.getHoursOfOperation().add(parseLocationLocationHoursOfOperationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Location.LocationPositionComponent parseLocationLocationPositionComponent(JsonObject json, Location owner) throws IOException, FHIRFormatError {
    Location.LocationPositionComponent res = new Location.LocationPositionComponent();
    parseLocationLocationPositionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseLocationLocationPositionComponentProperties(JsonObject json, Location owner, Location.LocationPositionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("longitude"))
      res.setLongitudeElement(parseDecimal(json.get("longitude").getAsBigDecimal()));
    if (json.has("_longitude"))
      parseElementProperties(json.getAsJsonObject("_longitude"), res.getLongitudeElement());
    if (json.has("latitude"))
      res.setLatitudeElement(parseDecimal(json.get("latitude").getAsBigDecimal()));
    if (json.has("_latitude"))
      parseElementProperties(json.getAsJsonObject("_latitude"), res.getLatitudeElement());
    if (json.has("altitude"))
      res.setAltitudeElement(parseDecimal(json.get("altitude").getAsBigDecimal()));
    if (json.has("_altitude"))
      parseElementProperties(json.getAsJsonObject("_altitude"), res.getAltitudeElement());
  }

  protected Location.LocationHoursOfOperationComponent parseLocationLocationHoursOfOperationComponent(JsonObject json, Location owner) throws IOException, FHIRFormatError {
    Location.LocationHoursOfOperationComponent res = new Location.LocationHoursOfOperationComponent();
    parseLocationLocationHoursOfOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseLocationLocationHoursOfOperationComponentProperties(JsonObject json, Location owner, Location.LocationHoursOfOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), Location.DaysOfWeek.NULL, new Location.DaysOfWeekEnumFactory()));
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, Location.DaysOfWeek.NULL, new Location.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
    if (json.has("openingTime"))
      res.setOpeningTimeElement(parseTime(json.get("openingTime").getAsString()));
    if (json.has("_openingTime"))
      parseElementProperties(json.getAsJsonObject("_openingTime"), res.getOpeningTimeElement());
    if (json.has("closingTime"))
      res.setClosingTimeElement(parseTime(json.get("closingTime").getAsString()));
    if (json.has("_closingTime"))
      parseElementProperties(json.getAsJsonObject("_closingTime"), res.getClosingTimeElement());
  }

  protected Measure parseMeasure(JsonObject json) throws IOException, FHIRFormatError {
    Measure res = new Measure();
    parseMeasureProperties(json, res);
    return res;
  }

  protected void parseMeasureProperties(JsonObject json, Measure res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_library")) {
      JsonArray array = json.getAsJsonArray("_library");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLibrary().size())
          res.getLibrary().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLibrary().get(i));
      }
    };
    if (json.has("disclaimer"))
      res.setDisclaimerElement(parseMarkdown(json.get("disclaimer").getAsString()));
    if (json.has("_disclaimer"))
      parseElementProperties(json.getAsJsonObject("_disclaimer"), res.getDisclaimerElement());
    if (json.has("scoring"))
      res.setScoring(parseCodeableConcept(json.getAsJsonObject("scoring")));
    if (json.has("compositeScoring"))
      res.setCompositeScoring(parseCodeableConcept(json.getAsJsonObject("compositeScoring")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("riskAdjustment"))
      res.setRiskAdjustmentElement(parseString(json.get("riskAdjustment").getAsString()));
    if (json.has("_riskAdjustment"))
      parseElementProperties(json.getAsJsonObject("_riskAdjustment"), res.getRiskAdjustmentElement());
    if (json.has("rateAggregation"))
      res.setRateAggregationElement(parseString(json.get("rateAggregation").getAsString()));
    if (json.has("_rateAggregation"))
      parseElementProperties(json.getAsJsonObject("_rateAggregation"), res.getRateAggregationElement());
    if (json.has("rationale"))
      res.setRationaleElement(parseMarkdown(json.get("rationale").getAsString()));
    if (json.has("_rationale"))
      parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
    if (json.has("clinicalRecommendationStatement"))
      res.setClinicalRecommendationStatementElement(parseMarkdown(json.get("clinicalRecommendationStatement").getAsString()));
    if (json.has("_clinicalRecommendationStatement"))
      parseElementProperties(json.getAsJsonObject("_clinicalRecommendationStatement"), res.getClinicalRecommendationStatementElement());
    if (json.has("improvementNotation"))
      res.setImprovementNotationElement(parseEnumeration(json.get("improvementNotation").getAsString(), Measure.MeasureImprovementNotation.NULL, new Measure.MeasureImprovementNotationEnumFactory()));
    if (json.has("_improvementNotation"))
      parseElementProperties(json.getAsJsonObject("_improvementNotation"), res.getImprovementNotationElement());
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        res.getDefinition().add(parseMarkdown(array.get(i).getAsString()));
      }
    };
    if (json.has("_definition")) {
      JsonArray array = json.getAsJsonArray("_definition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinition().size())
          res.getDefinition().add(parseMarkdown(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
      }
    };
    if (json.has("guidance"))
      res.setGuidanceElement(parseMarkdown(json.get("guidance").getAsString()));
    if (json.has("_guidance"))
      parseElementProperties(json.getAsJsonObject("_guidance"), res.getGuidanceElement());
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureMeasureGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("supplementalData")) {
      JsonArray array = json.getAsJsonArray("supplementalData");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplementalData().add(parseMeasureMeasureSupplementalDataComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
    parseMeasureMeasureGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureMeasureGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureMeasureGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
    parseMeasureMeasureGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupPopulationComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(json.getAsJsonObject("criteria")));
  }

  protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
    parseMeasureMeasureGroupStratifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureGroupStratifierComponentProperties(JsonObject json, Measure owner, Measure.MeasureGroupStratifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(json.getAsJsonObject("criteria")));
  }

  protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
    parseMeasureMeasureSupplementalDataComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureMeasureSupplementalDataComponentProperties(JsonObject json, Measure owner, Measure.MeasureSupplementalDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("usage")) {
      JsonArray array = json.getAsJsonArray("usage");
      for (int i = 0; i < array.size(); i++) {
        res.getUsage().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(json.getAsJsonObject("criteria")));
  }

  protected MeasureReport parseMeasureReport(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport res = new MeasureReport();
    parseMeasureReportProperties(json, res);
    return res;
  }

  protected void parseMeasureReportProperties(JsonObject json, MeasureReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("measure"))
      res.setMeasureElement(parseCanonical(json.get("measure").getAsString()));
    if (json.has("_measure"))
      parseElementProperties(json.getAsJsonObject("_measure"), res.getMeasureElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("reporter"))
      res.setReporter(parseReference(json.getAsJsonObject("reporter")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("improvementNotation"))
      res.setImprovementNotationElement(parseEnumeration(json.get("improvementNotation").getAsString(), MeasureReport.MeasureImprovementNotation.NULL, new MeasureReport.MeasureImprovementNotationEnumFactory()));
    if (json.has("_improvementNotation"))
      parseElementProperties(json.getAsJsonObject("_improvementNotation"), res.getImprovementNotationElement());
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureReportMeasureReportGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("evaluatedResource")) {
      JsonArray array = json.getAsJsonArray("evaluatedResource");
      for (int i = 0; i < array.size(); i++) {
        res.getEvaluatedResource().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
    parseMeasureReportMeasureReportGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportMeasureReportGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("measureScore"))
      res.setMeasureScore(parseQuantity(json.getAsJsonObject("measureScore")));
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureReportMeasureReportGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
    parseMeasureReportMeasureReportGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupPopulationComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("subjectResults"))
      res.setSubjectResults(parseReference(json.getAsJsonObject("subjectResults")));
  }

  protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
    parseMeasureReportMeasureReportGroupStratifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportMeasureReportGroupStratifierComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.MeasureReportGroupStratifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("stratum")) {
      JsonArray array = json.getAsJsonArray("stratum");
      for (int i = 0; i < array.size(); i++) {
        res.getStratum().add(parseMeasureReportStratifierGroupComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
    parseMeasureReportStratifierGroupComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValue(parseCodeableConcept(json.getAsJsonObject("value")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportStratifierGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("measureScore"))
      res.setMeasureScore(parseQuantity(json.getAsJsonObject("measureScore")));
  }

  protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
    parseMeasureReportStratifierGroupPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupPopulationComponentProperties(JsonObject json, MeasureReport owner, MeasureReport.StratifierGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("subjectResults"))
      res.setSubjectResults(parseReference(json.getAsJsonObject("subjectResults")));
  }

  protected Media parseMedia(JsonObject json) throws IOException, FHIRFormatError {
    Media res = new Media();
    parseMediaProperties(json, res);
    return res;
  }

  protected void parseMediaProperties(JsonObject json, Media res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Media.MediaStatus.NULL, new Media.MediaStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("modality"))
      res.setModality(parseCodeableConcept(json.getAsJsonObject("modality")));
    if (json.has("view"))
      res.setView(parseCodeableConcept(json.getAsJsonObject("view")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type created = parseType("created", json);
    if (created != null)
      res.setCreated(created);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("operator"))
      res.setOperator(parseReference(json.getAsJsonObject("operator")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("deviceName"))
      res.setDeviceNameElement(parseString(json.get("deviceName").getAsString()));
    if (json.has("_deviceName"))
      parseElementProperties(json.getAsJsonObject("_deviceName"), res.getDeviceNameElement());
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("height"))
      res.setHeightElement(parsePositiveInt(json.get("height").getAsString()));
    if (json.has("_height"))
      parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
    if (json.has("width"))
      res.setWidthElement(parsePositiveInt(json.get("width").getAsString()));
    if (json.has("_width"))
      parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
    if (json.has("frames"))
      res.setFramesElement(parsePositiveInt(json.get("frames").getAsString()));
    if (json.has("_frames"))
      parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("content"))
      res.setContent(parseAttachment(json.getAsJsonObject("content")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Medication parseMedication(JsonObject json) throws IOException, FHIRFormatError {
    Medication res = new Medication();
    parseMedicationProperties(json, res);
    return res;
  }

  protected void parseMedicationProperties(JsonObject json, Medication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Medication.MedicationStatus.NULL, new Medication.MedicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(json.getAsJsonObject("amount")));
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseMedicationMedicationIngredientComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("batch"))
      res.setBatch(parseMedicationMedicationBatchComponent(json.getAsJsonObject("batch"), res));
  }

  protected Medication.MedicationIngredientComponent parseMedicationMedicationIngredientComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
    parseMedicationMedicationIngredientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationMedicationIngredientComponentProperties(JsonObject json, Medication owner, Medication.MedicationIngredientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("isActive"))
      res.setIsActiveElement(parseBoolean(json.get("isActive").getAsBoolean()));
    if (json.has("_isActive"))
      parseElementProperties(json.getAsJsonObject("_isActive"), res.getIsActiveElement());
    if (json.has("amount"))
      res.setAmount(parseRatio(json.getAsJsonObject("amount")));
  }

  protected Medication.MedicationBatchComponent parseMedicationMedicationBatchComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationBatchComponent res = new Medication.MedicationBatchComponent();
    parseMedicationMedicationBatchComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationMedicationBatchComponentProperties(JsonObject json, Medication owner, Medication.MedicationBatchComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("serialNumber"))
      res.setSerialNumberElement(parseString(json.get("serialNumber").getAsString()));
    if (json.has("_serialNumber"))
      parseElementProperties(json.getAsJsonObject("_serialNumber"), res.getSerialNumberElement());
  }

  protected MedicationAdministration parseMedicationAdministration(JsonObject json) throws IOException, FHIRFormatError {
    MedicationAdministration res = new MedicationAdministration();
    parseMedicationAdministrationProperties(json, res);
    return res;
  }

  protected void parseMedicationAdministrationProperties(JsonObject json, MedicationAdministration res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiates().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseMedicationAdministrationMedicationAdministrationPerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosage"))
      res.setDosage(parseMedicationAdministrationMedicationAdministrationDosageComponent(json.getAsJsonObject("dosage"), res));
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationMedicationAdministrationPerformerComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
    parseMedicationAdministrationMedicationAdministrationPerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationAdministrationMedicationAdministrationPerformerComponentProperties(JsonObject json, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
    parseMedicationAdministrationMedicationAdministrationDosageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationAdministrationMedicationAdministrationDosageComponentProperties(JsonObject json, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationDosageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("dose"))
      res.setDose(parseQuantity(json.getAsJsonObject("dose")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected MedicationDispense parseMedicationDispense(JsonObject json) throws IOException, FHIRFormatError {
    MedicationDispense res = new MedicationDispense();
    parseMedicationDispenseProperties(json, res);
    return res;
  }

  protected void parseMedicationDispenseProperties(JsonObject json, MedicationDispense res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseMedicationDispenseMedicationDispensePerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("authorizingPrescription")) {
      JsonArray array = json.getAsJsonArray("authorizingPrescription");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizingPrescription().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("daysSupply"))
      res.setDaysSupply(parseQuantity(json.getAsJsonObject("daysSupply")));
    if (json.has("whenPrepared"))
      res.setWhenPreparedElement(parseDateTime(json.get("whenPrepared").getAsString()));
    if (json.has("_whenPrepared"))
      parseElementProperties(json.getAsJsonObject("_whenPrepared"), res.getWhenPreparedElement());
    if (json.has("whenHandedOver"))
      res.setWhenHandedOverElement(parseDateTime(json.get("whenHandedOver").getAsString()));
    if (json.has("_whenHandedOver"))
      parseElementProperties(json.getAsJsonObject("_whenHandedOver"), res.getWhenHandedOverElement());
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("receiver")) {
      JsonArray array = json.getAsJsonArray("receiver");
      for (int i = 0; i < array.size(); i++) {
        res.getReceiver().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("substitution"))
      res.setSubstitution(parseMedicationDispenseMedicationDispenseSubstitutionComponent(json.getAsJsonObject("substitution"), res));
    if (json.has("detectedIssue")) {
      JsonArray array = json.getAsJsonArray("detectedIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getDetectedIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type statusReason = parseType("statusReason", json);
    if (statusReason != null)
      res.setStatusReason(statusReason);
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispenseMedicationDispensePerformerComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
    parseMedicationDispenseMedicationDispensePerformerComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationDispenseMedicationDispensePerformerComponentProperties(JsonObject json, MedicationDispense owner, MedicationDispense.MedicationDispensePerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
    parseMedicationDispenseMedicationDispenseSubstitutionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationDispenseMedicationDispenseSubstitutionComponentProperties(JsonObject json, MedicationDispense owner, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("wasSubstituted"))
      res.setWasSubstitutedElement(parseBoolean(json.get("wasSubstituted").getAsBoolean()));
    if (json.has("_wasSubstituted"))
      parseElementProperties(json.getAsJsonObject("_wasSubstituted"), res.getWasSubstitutedElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responsibleParty")) {
      JsonArray array = json.getAsJsonArray("responsibleParty");
      for (int i = 0; i < array.size(); i++) {
        res.getResponsibleParty().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge parseMedicationKnowledge(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge res = new MedicationKnowledge();
    parseMedicationKnowledgeProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeProperties(JsonObject json, MedicationKnowledge res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationKnowledge.MedicationKnowledgeStatus.NULL, new MedicationKnowledge.MedicationKnowledgeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("doseForm"))
      res.setDoseForm(parseCodeableConcept(json.getAsJsonObject("doseForm")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(json.getAsJsonObject("amount")));
    if (json.has("synonym")) {
      JsonArray array = json.getAsJsonArray("synonym");
      for (int i = 0; i < array.size(); i++) {
        res.getSynonym().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_synonym")) {
      JsonArray array = json.getAsJsonArray("_synonym");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSynonym().size())
          res.getSynonym().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSynonym().get(i));
      }
    };
    if (json.has("relatedMedicationKnowledge")) {
      JsonArray array = json.getAsJsonArray("relatedMedicationKnowledge");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedMedicationKnowledge().add(parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("associatedMedication")) {
      JsonArray array = json.getAsJsonArray("associatedMedication");
      for (int i = 0; i < array.size(); i++) {
        res.getAssociatedMedication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productType")) {
      JsonArray array = json.getAsJsonArray("productType");
      for (int i = 0; i < array.size(); i++) {
        res.getProductType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("monograph")) {
      JsonArray array = json.getAsJsonArray("monograph");
      for (int i = 0; i < array.size(); i++) {
        res.getMonograph().add(parseMedicationKnowledgeMedicationKnowledgeMonographComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseMedicationKnowledgeMedicationKnowledgeIngredientComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("preparationInstruction"))
      res.setPreparationInstructionElement(parseMarkdown(json.get("preparationInstruction").getAsString()));
    if (json.has("_preparationInstruction"))
      parseElementProperties(json.getAsJsonObject("_preparationInstruction"), res.getPreparationInstructionElement());
    if (json.has("intendedRoute")) {
      JsonArray array = json.getAsJsonArray("intendedRoute");
      for (int i = 0; i < array.size(); i++) {
        res.getIntendedRoute().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("cost")) {
      JsonArray array = json.getAsJsonArray("cost");
      for (int i = 0; i < array.size(); i++) {
        res.getCost().add(parseMedicationKnowledgeMedicationKnowledgeCostComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("monitoringProgram")) {
      JsonArray array = json.getAsJsonArray("monitoringProgram");
      for (int i = 0; i < array.size(); i++) {
        res.getMonitoringProgram().add(parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("administrationGuidelines")) {
      JsonArray array = json.getAsJsonArray("administrationGuidelines");
      for (int i = 0; i < array.size(); i++) {
        res.getAdministrationGuidelines().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("medicineClassification")) {
      JsonArray array = json.getAsJsonArray("medicineClassification");
      for (int i = 0; i < array.size(); i++) {
        res.getMedicineClassification().add(parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("packaging"))
      res.setPackaging(parseMedicationKnowledgeMedicationKnowledgePackagingComponent(json.getAsJsonObject("packaging"), res));
    if (json.has("drugCharacteristic")) {
      JsonArray array = json.getAsJsonArray("drugCharacteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getDrugCharacteristic().add(parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("contraindication")) {
      JsonArray array = json.getAsJsonArray("contraindication");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("regulatory")) {
      JsonArray array = json.getAsJsonArray("regulatory");
      for (int i = 0; i < array.size(); i++) {
        res.getRegulatory().add(parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("kinetics")) {
      JsonArray array = json.getAsJsonArray("kinetics");
      for (int i = 0; i < array.size(); i++) {
        res.getKinetics().add(parseMedicationKnowledgeMedicationKnowledgeKineticsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res = new MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent();
    parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeMonographComponent parseMedicationKnowledgeMedicationKnowledgeMonographComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonographComponent res = new MedicationKnowledge.MedicationKnowledgeMonographComponent();
    parseMedicationKnowledgeMedicationKnowledgeMonographComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeMonographComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMonographComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
  }

  protected MedicationKnowledge.MedicationKnowledgeIngredientComponent parseMedicationKnowledgeMedicationKnowledgeIngredientComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeIngredientComponent res = new MedicationKnowledge.MedicationKnowledgeIngredientComponent();
    parseMedicationKnowledgeMedicationKnowledgeIngredientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeIngredientComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeIngredientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("isActive"))
      res.setIsActiveElement(parseBoolean(json.get("isActive").getAsBoolean()));
    if (json.has("_isActive"))
      parseElementProperties(json.getAsJsonObject("_isActive"), res.getIsActiveElement());
    if (json.has("strength"))
      res.setStrength(parseRatio(json.getAsJsonObject("strength")));
  }

  protected MedicationKnowledge.MedicationKnowledgeCostComponent parseMedicationKnowledgeMedicationKnowledgeCostComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeCostComponent res = new MedicationKnowledge.MedicationKnowledgeCostComponent();
    parseMedicationKnowledgeMedicationKnowledgeCostComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeCostComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("source"))
      res.setSourceElement(parseString(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("cost"))
      res.setCost(parseMoney(json.getAsJsonObject("cost")));
  }

  protected MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res = new MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent();
    parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent();
    parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    Type indication = parseType("indication", json);
    if (indication != null)
      res.setIndication(indication);
    if (json.has("patientCharacteristics")) {
      JsonArray array = json.getAsJsonArray("patientCharacteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getPatientCharacteristics().add(parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent();
    parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent();
    parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type characteristic = parseType("characteristic", json);
    if (characteristic != null)
      res.setCharacteristic(characteristic);
    if (json.has("value")) {
      JsonArray array = json.getAsJsonArray("value");
      for (int i = 0; i < array.size(); i++) {
        res.getValue().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_value")) {
      JsonArray array = json.getAsJsonArray("_value");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getValue().size())
          res.getValue().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getValue().get(i));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res = new MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent();
    parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("classification")) {
      JsonArray array = json.getAsJsonArray("classification");
      for (int i = 0; i < array.size(); i++) {
        res.getClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgePackagingComponent parseMedicationKnowledgeMedicationKnowledgePackagingComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgePackagingComponent res = new MedicationKnowledge.MedicationKnowledgePackagingComponent();
    parseMedicationKnowledgeMedicationKnowledgePackagingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgePackagingComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgePackagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
  }

  protected MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent();
    parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryComponent();
    parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("regulatoryAuthority"))
      res.setRegulatoryAuthority(parseReference(json.getAsJsonObject("regulatoryAuthority")));
    if (json.has("substitution")) {
      JsonArray array = json.getAsJsonArray("substitution");
      for (int i = 0; i < array.size(); i++) {
        res.getSubstitution().add(parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("maxDispense"))
      res.setMaxDispense(parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(json.getAsJsonObject("maxDispense"), owner));
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent();
    parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("allowed"))
      res.setAllowedElement(parseBoolean(json.get("allowed").getAsBoolean()));
    if (json.has("_allowed"))
      parseElementProperties(json.getAsJsonObject("_allowed"), res.getAllowedElement());
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent();
    parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("schedule"))
      res.setSchedule(parseCodeableConcept(json.getAsJsonObject("schedule")));
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent();
    parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("period"))
      res.setPeriod(parseDuration(json.getAsJsonObject("period")));
  }

  protected MedicationKnowledge.MedicationKnowledgeKineticsComponent parseMedicationKnowledgeMedicationKnowledgeKineticsComponent(JsonObject json, MedicationKnowledge owner) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeKineticsComponent res = new MedicationKnowledge.MedicationKnowledgeKineticsComponent();
    parseMedicationKnowledgeMedicationKnowledgeKineticsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicationKnowledgeKineticsComponentProperties(JsonObject json, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeKineticsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("areaUnderCurve")) {
      JsonArray array = json.getAsJsonArray("areaUnderCurve");
      for (int i = 0; i < array.size(); i++) {
        res.getAreaUnderCurve().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("lethalDose50")) {
      JsonArray array = json.getAsJsonArray("lethalDose50");
      for (int i = 0; i < array.size(); i++) {
        res.getLethalDose50().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("halfLifePeriod"))
      res.setHalfLifePeriod(parseDuration(json.getAsJsonObject("halfLifePeriod")));
  }

  protected MedicationRequest parseMedicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    MedicationRequest res = new MedicationRequest();
    parseMedicationRequestProperties(json, res);
    return res;
  }

  protected void parseMedicationRequestProperties(JsonObject json, MedicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationRequest.MedicationRequestStatus.NULL, new MedicationRequest.MedicationRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), MedicationRequest.MedicationRequestPriority.NULL, new MedicationRequest.MedicationRequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("performerType"))
      res.setPerformerType(parseCodeableConcept(json.getAsJsonObject("performerType")));
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiates().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("courseOfTherapyType"))
      res.setCourseOfTherapyType(parseCodeableConcept(json.getAsJsonObject("courseOfTherapyType")));
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dispenseRequest"))
      res.setDispenseRequest(parseMedicationRequestMedicationRequestDispenseRequestComponent(json.getAsJsonObject("dispenseRequest"), res));
    if (json.has("substitution"))
      res.setSubstitution(parseMedicationRequestMedicationRequestSubstitutionComponent(json.getAsJsonObject("substitution"), res));
    if (json.has("priorPrescription"))
      res.setPriorPrescription(parseReference(json.getAsJsonObject("priorPrescription")));
    if (json.has("detectedIssue")) {
      JsonArray array = json.getAsJsonArray("detectedIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getDetectedIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestMedicationRequestDispenseRequestComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
    parseMedicationRequestMedicationRequestDispenseRequestComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestDispenseRequestComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("initialFill"))
      res.setInitialFill(parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(json.getAsJsonObject("initialFill"), owner));
    if (json.has("dispenseInterval"))
      res.setDispenseInterval(parseDuration(json.getAsJsonObject("dispenseInterval")));
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(json.getAsJsonObject("validityPeriod")));
    if (json.has("numberOfRepeatsAllowed"))
      res.setNumberOfRepeatsAllowedElement(parseUnsignedInt(json.get("numberOfRepeatsAllowed").getAsString()));
    if (json.has("_numberOfRepeatsAllowed"))
      parseElementProperties(json.getAsJsonObject("_numberOfRepeatsAllowed"), res.getNumberOfRepeatsAllowedElement());
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("expectedSupplyDuration"))
      res.setExpectedSupplyDuration(parseDuration(json.getAsJsonObject("expectedSupplyDuration")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
  }

  protected MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res = new MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent();
    parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("duration"))
      res.setDuration(parseDuration(json.getAsJsonObject("duration")));
  }

  protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestMedicationRequestSubstitutionComponent(JsonObject json, MedicationRequest owner) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
    parseMedicationRequestMedicationRequestSubstitutionComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicationRequestMedicationRequestSubstitutionComponentProperties(JsonObject json, MedicationRequest owner, MedicationRequest.MedicationRequestSubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("allowed"))
      res.setAllowedElement(parseBoolean(json.get("allowed").getAsBoolean()));
    if (json.has("_allowed"))
      parseElementProperties(json.getAsJsonObject("_allowed"), res.getAllowedElement());
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
  }

  protected MedicationStatement parseMedicationStatement(JsonObject json) throws IOException, FHIRFormatError {
    MedicationStatement res = new MedicationStatement();
    parseMedicationStatementProperties(json, res);
    return res;
  }

  protected void parseMedicationStatementProperties(JsonObject json, MedicationStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("dateAsserted"))
      res.setDateAssertedElement(parseDateTime(json.get("dateAsserted").getAsString()));
    if (json.has("_dateAsserted"))
      parseElementProperties(json.getAsJsonObject("_dateAsserted"), res.getDateAssertedElement());
    if (json.has("informationSource"))
      res.setInformationSource(parseReference(json.getAsJsonObject("informationSource")));
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProduct parseMedicinalProduct(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProduct res = new MedicinalProduct();
    parseMedicinalProductProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductProperties(JsonObject json, MedicinalProduct res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("domain"))
      res.setDomain(parseCoding(json.getAsJsonObject("domain")));
    if (json.has("combinedPharmaceuticalDoseForm"))
      res.setCombinedPharmaceuticalDoseForm(parseCodeableConcept(json.getAsJsonObject("combinedPharmaceuticalDoseForm")));
    if (json.has("additionalMonitoringIndicator"))
      res.setAdditionalMonitoringIndicator(parseCodeableConcept(json.getAsJsonObject("additionalMonitoringIndicator")));
    if (json.has("specialMeasures")) {
      JsonArray array = json.getAsJsonArray("specialMeasures");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialMeasures().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_specialMeasures")) {
      JsonArray array = json.getAsJsonArray("_specialMeasures");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSpecialMeasures().size())
          res.getSpecialMeasures().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSpecialMeasures().get(i));
      }
    };
    if (json.has("paediatricUseIndicator"))
      res.setPaediatricUseIndicator(parseCodeableConcept(json.getAsJsonObject("paediatricUseIndicator")));
    if (json.has("productClassification")) {
      JsonArray array = json.getAsJsonArray("productClassification");
      for (int i = 0; i < array.size(); i++) {
        res.getProductClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("marketingStatus")) {
      JsonArray array = json.getAsJsonArray("marketingStatus");
      for (int i = 0; i < array.size(); i++) {
        res.getMarketingStatus().add(parseMarketingStatus(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("marketingAuthorization"))
      res.setMarketingAuthorization(parseReference(json.getAsJsonObject("marketingAuthorization")));
    if (json.has("packagedMedicinalProduct")) {
      JsonArray array = json.getAsJsonArray("packagedMedicinalProduct");
      for (int i = 0; i < array.size(); i++) {
        res.getPackagedMedicinalProduct().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("pharmaceuticalProduct")) {
      JsonArray array = json.getAsJsonArray("pharmaceuticalProduct");
      for (int i = 0; i < array.size(); i++) {
        res.getPharmaceuticalProduct().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contraindication")) {
      JsonArray array = json.getAsJsonArray("contraindication");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("therapeuticIndication")) {
      JsonArray array = json.getAsJsonArray("therapeuticIndication");
      for (int i = 0; i < array.size(); i++) {
        res.getTherapeuticIndication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("undesirableEffect")) {
      JsonArray array = json.getAsJsonArray("undesirableEffect");
      for (int i = 0; i < array.size(); i++) {
        res.getUndesirableEffect().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("attachedDocument")) {
      JsonArray array = json.getAsJsonArray("attachedDocument");
      for (int i = 0; i < array.size(); i++) {
        res.getAttachedDocument().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("masterFile")) {
      JsonArray array = json.getAsJsonArray("masterFile");
      for (int i = 0; i < array.size(); i++) {
        res.getMasterFile().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalTrial")) {
      JsonArray array = json.getAsJsonArray("clinicalTrial");
      for (int i = 0; i < array.size(); i++) {
        res.getClinicalTrial().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseMedicinalProductMedicinalProductNameComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("crossReference")) {
      JsonArray array = json.getAsJsonArray("crossReference");
      for (int i = 0; i < array.size(); i++) {
        res.getCrossReference().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturingBusinessOperation")) {
      JsonArray array = json.getAsJsonArray("manufacturingBusinessOperation");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturingBusinessOperation().add(parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("specialDesignation")) {
      JsonArray array = json.getAsJsonArray("specialDesignation");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialDesignation().add(parseMedicinalProductMedicinalProductSpecialDesignationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProduct.MedicinalProductNameComponent parseMedicinalProductMedicinalProductNameComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductNameComponent res = new MedicinalProduct.MedicinalProductNameComponent();
    parseMedicinalProductMedicinalProductNameComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductNameComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productName"))
      res.setProductNameElement(parseString(json.get("productName").getAsString()));
    if (json.has("_productName"))
      parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
    if (json.has("namePart")) {
      JsonArray array = json.getAsJsonArray("namePart");
      for (int i = 0; i < array.size(); i++) {
        res.getNamePart().add(parseMedicinalProductMedicinalProductNameNamePartComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("countryLanguage")) {
      JsonArray array = json.getAsJsonArray("countryLanguage");
      for (int i = 0; i < array.size(); i++) {
        res.getCountryLanguage().add(parseMedicinalProductMedicinalProductNameCountryLanguageComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProduct.MedicinalProductNameNamePartComponent parseMedicinalProductMedicinalProductNameNamePartComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductNameNamePartComponent res = new MedicinalProduct.MedicinalProductNameNamePartComponent();
    parseMedicinalProductMedicinalProductNameNamePartComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductNameNamePartComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameNamePartComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("part"))
      res.setPartElement(parseString(json.get("part").getAsString()));
    if (json.has("_part"))
      parseElementProperties(json.getAsJsonObject("_part"), res.getPartElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
  }

  protected MedicinalProduct.MedicinalProductNameCountryLanguageComponent parseMedicinalProductMedicinalProductNameCountryLanguageComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductNameCountryLanguageComponent res = new MedicinalProduct.MedicinalProductNameCountryLanguageComponent();
    parseMedicinalProductMedicinalProductNameCountryLanguageComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductNameCountryLanguageComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameCountryLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(json.getAsJsonObject("country")));
    if (json.has("jurisdiction"))
      res.setJurisdiction(parseCodeableConcept(json.getAsJsonObject("jurisdiction")));
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
  }

  protected MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent res = new MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent();
    parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("operationType"))
      res.setOperationType(parseCodeableConcept(json.getAsJsonObject("operationType")));
    if (json.has("authorisationReferenceNumber"))
      res.setAuthorisationReferenceNumber(parseIdentifier(json.getAsJsonObject("authorisationReferenceNumber")));
    if (json.has("effectiveDate"))
      res.setEffectiveDateElement(parseDateTime(json.get("effectiveDate").getAsString()));
    if (json.has("_effectiveDate"))
      parseElementProperties(json.getAsJsonObject("_effectiveDate"), res.getEffectiveDateElement());
    if (json.has("confidentialityIndicator"))
      res.setConfidentialityIndicator(parseCodeableConcept(json.getAsJsonObject("confidentialityIndicator")));
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("regulator"))
      res.setRegulator(parseReference(json.getAsJsonObject("regulator")));
  }

  protected MedicinalProduct.MedicinalProductSpecialDesignationComponent parseMedicinalProductMedicinalProductSpecialDesignationComponent(JsonObject json, MedicinalProduct owner) throws IOException, FHIRFormatError {
    MedicinalProduct.MedicinalProductSpecialDesignationComponent res = new MedicinalProduct.MedicinalProductSpecialDesignationComponent();
    parseMedicinalProductMedicinalProductSpecialDesignationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductMedicinalProductSpecialDesignationComponentProperties(JsonObject json, MedicinalProduct owner, MedicinalProduct.MedicinalProductSpecialDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("intendedUse"))
      res.setIntendedUse(parseCodeableConcept(json.getAsJsonObject("intendedUse")));
    if (json.has("indication"))
      res.setIndication(parseCodeableConcept(json.getAsJsonObject("indication")));
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("species"))
      res.setSpecies(parseCodeableConcept(json.getAsJsonObject("species")));
  }

  protected MedicinalProductAuthorization parseMedicinalProductAuthorization(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductAuthorization res = new MedicinalProductAuthorization();
    parseMedicinalProductAuthorizationProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductAuthorizationProperties(JsonObject json, MedicinalProductAuthorization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("country")) {
      JsonArray array = json.getAsJsonArray("country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("legalStatusOfSupply"))
      res.setLegalStatusOfSupply(parseCodeableConcept(json.getAsJsonObject("legalStatusOfSupply")));
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDateTime(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
    if (json.has("restoreDate"))
      res.setRestoreDateElement(parseDateTime(json.get("restoreDate").getAsString()));
    if (json.has("_restoreDate"))
      parseElementProperties(json.getAsJsonObject("_restoreDate"), res.getRestoreDateElement());
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(json.getAsJsonObject("validityPeriod")));
    if (json.has("dataExclusivityPeriod"))
      res.setDataExclusivityPeriod(parsePeriod(json.getAsJsonObject("dataExclusivityPeriod")));
    if (json.has("dateOfFirstAuthorization"))
      res.setDateOfFirstAuthorizationElement(parseDateTime(json.get("dateOfFirstAuthorization").getAsString()));
    if (json.has("_dateOfFirstAuthorization"))
      parseElementProperties(json.getAsJsonObject("_dateOfFirstAuthorization"), res.getDateOfFirstAuthorizationElement());
    if (json.has("internationalBirthDate"))
      res.setInternationalBirthDateElement(parseDateTime(json.get("internationalBirthDate").getAsString()));
    if (json.has("_internationalBirthDate"))
      parseElementProperties(json.getAsJsonObject("_internationalBirthDate"), res.getInternationalBirthDateElement());
    if (json.has("legalBasis"))
      res.setLegalBasis(parseCodeableConcept(json.getAsJsonObject("legalBasis")));
    if (json.has("jurisdictionalAuthorization")) {
      JsonArray array = json.getAsJsonArray("jurisdictionalAuthorization");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdictionalAuthorization().add(parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("holder"))
      res.setHolder(parseReference(json.getAsJsonObject("holder")));
    if (json.has("regulator"))
      res.setRegulator(parseReference(json.getAsJsonObject("regulator")));
    if (json.has("procedure"))
      res.setProcedure(parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(json.getAsJsonObject("procedure"), res));
  }

  protected MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(JsonObject json, MedicinalProductAuthorization owner) throws IOException, FHIRFormatError {
    MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent res = new MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent();
    parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponentProperties(JsonObject json, MedicinalProductAuthorization owner, MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(json.getAsJsonObject("country")));
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("legalStatusOfSupply"))
      res.setLegalStatusOfSupply(parseCodeableConcept(json.getAsJsonObject("legalStatusOfSupply")));
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(json.getAsJsonObject("validityPeriod")));
  }

  protected MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(JsonObject json, MedicinalProductAuthorization owner) throws IOException, FHIRFormatError {
    MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent res = new MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent();
    parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponentProperties(JsonObject json, MedicinalProductAuthorization owner, MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type date = parseType("date", json);
    if (date != null)
      res.setDate(date);
    if (json.has("application")) {
      JsonArray array = json.getAsJsonArray("application");
      for (int i = 0; i < array.size(); i++) {
        res.getApplication().add(parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductClinicals parseMedicinalProductClinicals(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductClinicals res = new MedicinalProductClinicals();
    parseMedicinalProductClinicalsProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductClinicalsProperties(JsonObject json, MedicinalProductClinicals res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("undesirableEffects")) {
      JsonArray array = json.getAsJsonArray("undesirableEffects");
      for (int i = 0; i < array.size(); i++) {
        res.getUndesirableEffects().add(parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("therapeuticIndication")) {
      JsonArray array = json.getAsJsonArray("therapeuticIndication");
      for (int i = 0; i < array.size(); i++) {
        res.getTherapeuticIndication().add(parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("contraindication")) {
      JsonArray array = json.getAsJsonArray("contraindication");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindication().add(parseMedicinalProductClinicalsMedicinalProductClinicalsContraindicationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("interactions")) {
      JsonArray array = json.getAsJsonArray("interactions");
      for (int i = 0; i < array.size(); i++) {
        res.getInteractions().add(parseMedicinalProductClinicalsMedicinalProductClinicalsInteractionsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsComponent parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsComponent(JsonObject json, MedicinalProductClinicals owner) throws IOException, FHIRFormatError {
    MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsComponent res = new MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsComponent();
    parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsComponentProperties(JsonObject json, MedicinalProductClinicals owner, MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("symptomConditionEffect"))
      res.setSymptomConditionEffect(parseCodeableConcept(json.getAsJsonObject("symptomConditionEffect")));
    if (json.has("classification"))
      res.setClassification(parseCodeableConcept(json.getAsJsonObject("classification")));
    if (json.has("frequencyOfOccurrence"))
      res.setFrequencyOfOccurrence(parseCodeableConcept(json.getAsJsonObject("frequencyOfOccurrence")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsPopulationComponent parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponent(JsonObject json, MedicinalProductClinicals owner) throws IOException, FHIRFormatError {
    MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsPopulationComponent res = new MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsPopulationComponent();
    parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponentProperties(JsonObject json, MedicinalProductClinicals owner, MedicinalProductClinicals.MedicinalProductClinicalsUndesirableEffectsPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("gender"))
      res.setGender(parseCodeableConcept(json.getAsJsonObject("gender")));
    if (json.has("race"))
      res.setRace(parseCodeableConcept(json.getAsJsonObject("race")));
    if (json.has("physiologicalCondition"))
      res.setPhysiologicalCondition(parseCodeableConcept(json.getAsJsonObject("physiologicalCondition")));
  }

  protected MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationComponent parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationComponent(JsonObject json, MedicinalProductClinicals owner) throws IOException, FHIRFormatError {
    MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationComponent res = new MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationComponent();
    parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationComponentProperties(JsonObject json, MedicinalProductClinicals owner, MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("diseaseSymptomProcedure"))
      res.setDiseaseSymptomProcedure(parseCodeableConcept(json.getAsJsonObject("diseaseSymptomProcedure")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableConcept(json.getAsJsonObject("diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = json.getAsJsonArray("comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("intendedEffect"))
      res.setIntendedEffect(parseCodeableConcept(json.getAsJsonObject("intendedEffect")));
    if (json.has("duration"))
      res.setDuration(parseQuantity(json.getAsJsonObject("duration")));
    if (json.has("undesirableEffects")) {
      JsonArray array = json.getAsJsonArray("undesirableEffects");
      for (int i = 0; i < array.size(); i++) {
        res.getUndesirableEffects().add(parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("otherTherapy")) {
      JsonArray array = json.getAsJsonArray("otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent(JsonObject json, MedicinalProductClinicals owner) throws IOException, FHIRFormatError {
    MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent res = new MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent();
    parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponentProperties(JsonObject json, MedicinalProductClinicals owner, MedicinalProductClinicals.MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("therapyRelationshipType"))
      res.setTherapyRelationshipType(parseCodeableConcept(json.getAsJsonObject("therapyRelationshipType")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
  }

  protected MedicinalProductClinicals.MedicinalProductClinicalsContraindicationComponent parseMedicinalProductClinicalsMedicinalProductClinicalsContraindicationComponent(JsonObject json, MedicinalProductClinicals owner) throws IOException, FHIRFormatError {
    MedicinalProductClinicals.MedicinalProductClinicalsContraindicationComponent res = new MedicinalProductClinicals.MedicinalProductClinicalsContraindicationComponent();
    parseMedicinalProductClinicalsMedicinalProductClinicalsContraindicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductClinicalsMedicinalProductClinicalsContraindicationComponentProperties(JsonObject json, MedicinalProductClinicals owner, MedicinalProductClinicals.MedicinalProductClinicalsContraindicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("disease"))
      res.setDisease(parseCodeableConcept(json.getAsJsonObject("disease")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableConcept(json.getAsJsonObject("diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = json.getAsJsonArray("comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("therapeuticIndication")) {
      JsonArray array = json.getAsJsonArray("therapeuticIndication");
      for (int i = 0; i < array.size(); i++) {
        res.getTherapeuticIndication().add(parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("otherTherapy")) {
      JsonArray array = json.getAsJsonArray("otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseMedicinalProductClinicalsMedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMedicinalProductClinicalsMedicinalProductClinicalsUndesirableEffectsPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductClinicals.MedicinalProductClinicalsInteractionsComponent parseMedicinalProductClinicalsMedicinalProductClinicalsInteractionsComponent(JsonObject json, MedicinalProductClinicals owner) throws IOException, FHIRFormatError {
    MedicinalProductClinicals.MedicinalProductClinicalsInteractionsComponent res = new MedicinalProductClinicals.MedicinalProductClinicalsInteractionsComponent();
    parseMedicinalProductClinicalsMedicinalProductClinicalsInteractionsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductClinicalsMedicinalProductClinicalsInteractionsComponentProperties(JsonObject json, MedicinalProductClinicals owner, MedicinalProductClinicals.MedicinalProductClinicalsInteractionsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("interaction"))
      res.setInteractionElement(parseString(json.get("interaction").getAsString()));
    if (json.has("_interaction"))
      parseElementProperties(json.getAsJsonObject("_interaction"), res.getInteractionElement());
    if (json.has("interactant")) {
      JsonArray array = json.getAsJsonArray("interactant");
      for (int i = 0; i < array.size(); i++) {
        res.getInteractant().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("effect"))
      res.setEffect(parseCodeableConcept(json.getAsJsonObject("effect")));
    if (json.has("incidence"))
      res.setIncidence(parseCodeableConcept(json.getAsJsonObject("incidence")));
    if (json.has("management"))
      res.setManagement(parseCodeableConcept(json.getAsJsonObject("management")));
  }

  protected MedicinalProductContraindication parseMedicinalProductContraindication(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductContraindication res = new MedicinalProductContraindication();
    parseMedicinalProductContraindicationProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductContraindicationProperties(JsonObject json, MedicinalProductContraindication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("disease"))
      res.setDisease(parseCodeableConcept(json.getAsJsonObject("disease")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableConcept(json.getAsJsonObject("diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = json.getAsJsonArray("comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("therapeuticIndication")) {
      JsonArray array = json.getAsJsonArray("therapeuticIndication");
      for (int i = 0; i < array.size(); i++) {
        res.getTherapeuticIndication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("otherTherapy")) {
      JsonArray array = json.getAsJsonArray("otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMedicinalProductContraindicationMedicinalProductContraindicationPopulationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponent(JsonObject json, MedicinalProductContraindication owner) throws IOException, FHIRFormatError {
    MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent res = new MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent();
    parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponentProperties(JsonObject json, MedicinalProductContraindication owner, MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("therapyRelationshipType"))
      res.setTherapyRelationshipType(parseCodeableConcept(json.getAsJsonObject("therapyRelationshipType")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
  }

  protected MedicinalProductContraindication.MedicinalProductContraindicationPopulationComponent parseMedicinalProductContraindicationMedicinalProductContraindicationPopulationComponent(JsonObject json, MedicinalProductContraindication owner) throws IOException, FHIRFormatError {
    MedicinalProductContraindication.MedicinalProductContraindicationPopulationComponent res = new MedicinalProductContraindication.MedicinalProductContraindicationPopulationComponent();
    parseMedicinalProductContraindicationMedicinalProductContraindicationPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductContraindicationMedicinalProductContraindicationPopulationComponentProperties(JsonObject json, MedicinalProductContraindication owner, MedicinalProductContraindication.MedicinalProductContraindicationPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("gender"))
      res.setGender(parseCodeableConcept(json.getAsJsonObject("gender")));
    if (json.has("race"))
      res.setRace(parseCodeableConcept(json.getAsJsonObject("race")));
    if (json.has("physiologicalCondition"))
      res.setPhysiologicalCondition(parseCodeableConcept(json.getAsJsonObject("physiologicalCondition")));
  }

  protected MedicinalProductDeviceSpec parseMedicinalProductDeviceSpec(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductDeviceSpec res = new MedicinalProductDeviceSpec();
    parseMedicinalProductDeviceSpecProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductDeviceSpecProperties(JsonObject json, MedicinalProductDeviceSpec res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("tradeName"))
      res.setTradeNameElement(parseString(json.get("tradeName").getAsString()));
    if (json.has("_tradeName"))
      parseElementProperties(json.getAsJsonObject("_tradeName"), res.getTradeNameElement());
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("listingNumber"))
      res.setListingNumberElement(parseString(json.get("listingNumber").getAsString()));
    if (json.has("_listingNumber"))
      parseElementProperties(json.getAsJsonObject("_listingNumber"), res.getListingNumberElement());
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(json.getAsJsonObject("_modelNumber"), res.getModelNumberElement());
    if (json.has("sterilityIndicator"))
      res.setSterilityIndicator(parseCodeableConcept(json.getAsJsonObject("sterilityIndicator")));
    if (json.has("sterilisationRequirement"))
      res.setSterilisationRequirement(parseCodeableConcept(json.getAsJsonObject("sterilisationRequirement")));
    if (json.has("usage"))
      res.setUsage(parseCodeableConcept(json.getAsJsonObject("usage")));
    if (json.has("nomenclature")) {
      JsonArray array = json.getAsJsonArray("nomenclature");
      for (int i = 0; i < array.size(); i++) {
        res.getNomenclature().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("shelfLifeStorage")) {
      JsonArray array = json.getAsJsonArray("shelfLifeStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getShelfLifeStorage().add(parseProductShelfLife(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("physicalCharacteristics"))
      res.setPhysicalCharacteristics(parseProdCharacteristic(json.getAsJsonObject("physicalCharacteristics")));
    if (json.has("otherCharacteristics")) {
      JsonArray array = json.getAsJsonArray("otherCharacteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherCharacteristics().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("batchIdentifier")) {
      JsonArray array = json.getAsJsonArray("batchIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getBatchIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("material")) {
      JsonArray array = json.getAsJsonArray("material");
      for (int i = 0; i < array.size(); i++) {
        res.getMaterial().add(parseMedicinalProductDeviceSpecMedicinalProductDeviceSpecMaterialComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductDeviceSpec.MedicinalProductDeviceSpecMaterialComponent parseMedicinalProductDeviceSpecMedicinalProductDeviceSpecMaterialComponent(JsonObject json, MedicinalProductDeviceSpec owner) throws IOException, FHIRFormatError {
    MedicinalProductDeviceSpec.MedicinalProductDeviceSpecMaterialComponent res = new MedicinalProductDeviceSpec.MedicinalProductDeviceSpecMaterialComponent();
    parseMedicinalProductDeviceSpecMedicinalProductDeviceSpecMaterialComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductDeviceSpecMedicinalProductDeviceSpecMaterialComponentProperties(JsonObject json, MedicinalProductDeviceSpec owner, MedicinalProductDeviceSpec.MedicinalProductDeviceSpecMaterialComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("alternate"))
      res.setAlternateElement(parseBoolean(json.get("alternate").getAsBoolean()));
    if (json.has("_alternate"))
      parseElementProperties(json.getAsJsonObject("_alternate"), res.getAlternateElement());
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(json.getAsJsonObject("_allergenicIndicator"), res.getAllergenicIndicatorElement());
  }

  protected MedicinalProductIndication parseMedicinalProductIndication(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductIndication res = new MedicinalProductIndication();
    parseMedicinalProductIndicationProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductIndicationProperties(JsonObject json, MedicinalProductIndication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diseaseSymptomProcedure"))
      res.setDiseaseSymptomProcedure(parseCodeableConcept(json.getAsJsonObject("diseaseSymptomProcedure")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableConcept(json.getAsJsonObject("diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = json.getAsJsonArray("comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("intendedEffect"))
      res.setIntendedEffect(parseCodeableConcept(json.getAsJsonObject("intendedEffect")));
    if (json.has("duration"))
      res.setDuration(parseQuantity(json.getAsJsonObject("duration")));
    if (json.has("otherTherapy")) {
      JsonArray array = json.getAsJsonArray("otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("undesirableEffect")) {
      JsonArray array = json.getAsJsonArray("undesirableEffect");
      for (int i = 0; i < array.size(); i++) {
        res.getUndesirableEffect().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMedicinalProductIndicationMedicinalProductIndicationPopulationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponent(JsonObject json, MedicinalProductIndication owner) throws IOException, FHIRFormatError {
    MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent res = new MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent();
    parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponentProperties(JsonObject json, MedicinalProductIndication owner, MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("therapyRelationshipType"))
      res.setTherapyRelationshipType(parseCodeableConcept(json.getAsJsonObject("therapyRelationshipType")));
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
  }

  protected MedicinalProductIndication.MedicinalProductIndicationPopulationComponent parseMedicinalProductIndicationMedicinalProductIndicationPopulationComponent(JsonObject json, MedicinalProductIndication owner) throws IOException, FHIRFormatError {
    MedicinalProductIndication.MedicinalProductIndicationPopulationComponent res = new MedicinalProductIndication.MedicinalProductIndicationPopulationComponent();
    parseMedicinalProductIndicationMedicinalProductIndicationPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIndicationMedicinalProductIndicationPopulationComponentProperties(JsonObject json, MedicinalProductIndication owner, MedicinalProductIndication.MedicinalProductIndicationPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("gender"))
      res.setGender(parseCodeableConcept(json.getAsJsonObject("gender")));
    if (json.has("race"))
      res.setRace(parseCodeableConcept(json.getAsJsonObject("race")));
    if (json.has("physiologicalCondition"))
      res.setPhysiologicalCondition(parseCodeableConcept(json.getAsJsonObject("physiologicalCondition")));
  }

  protected MedicinalProductIngredient parseMedicinalProductIngredient(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductIngredient res = new MedicinalProductIngredient();
    parseMedicinalProductIngredientProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductIngredientProperties(JsonObject json, MedicinalProductIngredient res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(json.getAsJsonObject("_allergenicIndicator"), res.getAllergenicIndicatorElement());
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specifiedSubstance")) {
      JsonArray array = json.getAsJsonArray("specifiedSubstance");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecifiedSubstance().add(parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("substance"))
      res.setSubstance(parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(json.getAsJsonObject("substance"), res));
  }

  protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(JsonObject json, MedicinalProductIngredient owner) throws IOException, FHIRFormatError {
    MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent();
    parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponentProperties(JsonObject json, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("group"))
      res.setGroup(parseCodeableConcept(json.getAsJsonObject("group")));
    if (json.has("confidentiality"))
      res.setConfidentiality(parseCodeableConcept(json.getAsJsonObject("confidentiality")));
    if (json.has("strength")) {
      JsonArray array = json.getAsJsonArray("strength");
      for (int i = 0; i < array.size(); i++) {
        res.getStrength().add(parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(JsonObject json, MedicinalProductIngredient owner) throws IOException, FHIRFormatError {
    MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent();
    parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponentProperties(JsonObject json, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("presentation"))
      res.setPresentation(parseRatio(json.getAsJsonObject("presentation")));
    if (json.has("presentationLowLimit"))
      res.setPresentationLowLimit(parseRatio(json.getAsJsonObject("presentationLowLimit")));
    if (json.has("concentration"))
      res.setConcentration(parseRatio(json.getAsJsonObject("concentration")));
    if (json.has("concentrationLowLimit"))
      res.setConcentrationLowLimit(parseRatio(json.getAsJsonObject("concentrationLowLimit")));
    if (json.has("measurementPoint"))
      res.setMeasurementPointElement(parseString(json.get("measurementPoint").getAsString()));
    if (json.has("_measurementPoint"))
      parseElementProperties(json.getAsJsonObject("_measurementPoint"), res.getMeasurementPointElement());
    if (json.has("country")) {
      JsonArray array = json.getAsJsonArray("country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referenceStrength")) {
      JsonArray array = json.getAsJsonArray("referenceStrength");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceStrength().add(parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(JsonObject json, MedicinalProductIngredient owner) throws IOException, FHIRFormatError {
    MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
    parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentProperties(JsonObject json, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("strength"))
      res.setStrength(parseRatio(json.getAsJsonObject("strength")));
    if (json.has("measurementPoint"))
      res.setMeasurementPointElement(parseString(json.get("measurementPoint").getAsString()));
    if (json.has("_measurementPoint"))
      parseElementProperties(json.getAsJsonObject("_measurementPoint"), res.getMeasurementPointElement());
    if (json.has("country")) {
      JsonArray array = json.getAsJsonArray("country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(JsonObject json, MedicinalProductIngredient owner) throws IOException, FHIRFormatError {
    MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent();
    parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponentProperties(JsonObject json, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("strength")) {
      JsonArray array = json.getAsJsonArray("strength");
      for (int i = 0; i < array.size(); i++) {
        res.getStrength().add(parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductInteraction parseMedicinalProductInteraction(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductInteraction res = new MedicinalProductInteraction();
    parseMedicinalProductInteractionProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductInteractionProperties(JsonObject json, MedicinalProductInteraction res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("interaction"))
      res.setInteractionElement(parseString(json.get("interaction").getAsString()));
    if (json.has("_interaction"))
      parseElementProperties(json.getAsJsonObject("_interaction"), res.getInteractionElement());
    if (json.has("interactant")) {
      JsonArray array = json.getAsJsonArray("interactant");
      for (int i = 0; i < array.size(); i++) {
        res.getInteractant().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("effect"))
      res.setEffect(parseCodeableConcept(json.getAsJsonObject("effect")));
    if (json.has("incidence"))
      res.setIncidence(parseCodeableConcept(json.getAsJsonObject("incidence")));
    if (json.has("management"))
      res.setManagement(parseCodeableConcept(json.getAsJsonObject("management")));
  }

  protected MedicinalProductManufactured parseMedicinalProductManufactured(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductManufactured res = new MedicinalProductManufactured();
    parseMedicinalProductManufacturedProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductManufacturedProperties(JsonObject json, MedicinalProductManufactured res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("manufacturedDoseForm"))
      res.setManufacturedDoseForm(parseCodeableConcept(json.getAsJsonObject("manufacturedDoseForm")));
    if (json.has("unitOfPresentation"))
      res.setUnitOfPresentation(parseCodeableConcept(json.getAsJsonObject("unitOfPresentation")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("physicalCharacteristics"))
      res.setPhysicalCharacteristics(parseProdCharacteristic(json.getAsJsonObject("physicalCharacteristics")));
    if (json.has("otherCharacteristics")) {
      JsonArray array = json.getAsJsonArray("otherCharacteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherCharacteristics().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductPackaged parseMedicinalProductPackaged(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductPackaged res = new MedicinalProductPackaged();
    parseMedicinalProductPackagedProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductPackagedProperties(JsonObject json, MedicinalProductPackaged res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("marketingStatus")) {
      JsonArray array = json.getAsJsonArray("marketingStatus");
      for (int i = 0; i < array.size(); i++) {
        res.getMarketingStatus().add(parseMarketingStatus(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("marketingAuthorization"))
      res.setMarketingAuthorization(parseReference(json.getAsJsonObject("marketingAuthorization")));
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("batchIdentifier")) {
      JsonArray array = json.getAsJsonArray("batchIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getBatchIdentifier().add(parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("packageItem")) {
      JsonArray array = json.getAsJsonArray("packageItem");
      for (int i = 0; i < array.size(); i++) {
        res.getPackageItem().add(parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(JsonObject json, MedicinalProductPackaged owner) throws IOException, FHIRFormatError {
    MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent res = new MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent();
    parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponentProperties(JsonObject json, MedicinalProductPackaged owner, MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("outerPackaging"))
      res.setOuterPackaging(parseIdentifier(json.getAsJsonObject("outerPackaging")));
    if (json.has("immediatePackaging"))
      res.setImmediatePackaging(parseIdentifier(json.getAsJsonObject("immediatePackaging")));
  }

  protected MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(JsonObject json, MedicinalProductPackaged owner) throws IOException, FHIRFormatError {
    MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent res = new MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent();
    parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponentProperties(JsonObject json, MedicinalProductPackaged owner, MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("material")) {
      JsonArray array = json.getAsJsonArray("material");
      for (int i = 0; i < array.size(); i++) {
        res.getMaterial().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("alternateMaterial")) {
      JsonArray array = json.getAsJsonArray("alternateMaterial");
      for (int i = 0; i < array.size(); i++) {
        res.getAlternateMaterial().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturedItem")) {
      JsonArray array = json.getAsJsonArray("manufacturedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturedItem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("packageItem")) {
      JsonArray array = json.getAsJsonArray("packageItem");
      for (int i = 0; i < array.size(); i++) {
        res.getPackageItem().add(parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("physicalCharacteristics"))
      res.setPhysicalCharacteristics(parseProdCharacteristic(json.getAsJsonObject("physicalCharacteristics")));
    if (json.has("otherCharacteristics")) {
      JsonArray array = json.getAsJsonArray("otherCharacteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherCharacteristics().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("shelfLifeStorage")) {
      JsonArray array = json.getAsJsonArray("shelfLifeStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getShelfLifeStorage().add(parseProductShelfLife(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductPharmaceutical parseMedicinalProductPharmaceutical(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical res = new MedicinalProductPharmaceutical();
    parseMedicinalProductPharmaceuticalProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalProperties(JsonObject json, MedicinalProductPharmaceutical res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("administrableDoseForm"))
      res.setAdministrableDoseForm(parseCodeableConcept(json.getAsJsonObject("administrableDoseForm")));
    if (json.has("unitOfPresentation"))
      res.setUnitOfPresentation(parseCodeableConcept(json.getAsJsonObject("unitOfPresentation")));
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("characteristics")) {
      JsonArray array = json.getAsJsonArray("characteristics");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristics().add(parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("routeOfAdministration")) {
      JsonArray array = json.getAsJsonArray("routeOfAdministration");
      for (int i = 0; i < array.size(); i++) {
        res.getRouteOfAdministration().add(parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(JsonObject json, MedicinalProductPharmaceutical owner) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent();
    parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponentProperties(JsonObject json, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
  }

  protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponent(JsonObject json, MedicinalProductPharmaceutical owner) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent();
    parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponentProperties(JsonObject json, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("firstDose"))
      res.setFirstDose(parseQuantity(json.getAsJsonObject("firstDose")));
    if (json.has("maxSingleDose"))
      res.setMaxSingleDose(parseQuantity(json.getAsJsonObject("maxSingleDose")));
    if (json.has("maxDosePerDay"))
      res.setMaxDosePerDay(parseQuantity(json.getAsJsonObject("maxDosePerDay")));
    if (json.has("maxDosePerTreatmentPeriod"))
      res.setMaxDosePerTreatmentPeriod(parseRatio(json.getAsJsonObject("maxDosePerTreatmentPeriod")));
    if (json.has("maxTreatmentPeriod"))
      res.setMaxTreatmentPeriod(parseDuration(json.getAsJsonObject("maxTreatmentPeriod")));
    if (json.has("targetSpecies")) {
      JsonArray array = json.getAsJsonArray("targetSpecies");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetSpecies().add(parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(JsonObject json, MedicinalProductPharmaceutical owner) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent();
    parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponentProperties(JsonObject json, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("withdrawalPeriod")) {
      JsonArray array = json.getAsJsonArray("withdrawalPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getWithdrawalPeriod().add(parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(JsonObject json, MedicinalProductPharmaceutical owner) throws IOException, FHIRFormatError {
    MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
    parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(JsonObject json, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("tissue"))
      res.setTissue(parseCodeableConcept(json.getAsJsonObject("tissue")));
    if (json.has("value"))
      res.setValue(parseQuantity(json.getAsJsonObject("value")));
    if (json.has("supportingInformation"))
      res.setSupportingInformationElement(parseString(json.get("supportingInformation").getAsString()));
    if (json.has("_supportingInformation"))
      parseElementProperties(json.getAsJsonObject("_supportingInformation"), res.getSupportingInformationElement());
  }

  protected MedicinalProductUndesirableEffect parseMedicinalProductUndesirableEffect(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductUndesirableEffect res = new MedicinalProductUndesirableEffect();
    parseMedicinalProductUndesirableEffectProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductUndesirableEffectProperties(JsonObject json, MedicinalProductUndesirableEffect res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("symptomConditionEffect"))
      res.setSymptomConditionEffect(parseCodeableConcept(json.getAsJsonObject("symptomConditionEffect")));
    if (json.has("classification"))
      res.setClassification(parseCodeableConcept(json.getAsJsonObject("classification")));
    if (json.has("frequencyOfOccurrence"))
      res.setFrequencyOfOccurrence(parseCodeableConcept(json.getAsJsonObject("frequencyOfOccurrence")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMedicinalProductUndesirableEffectMedicinalProductUndesirableEffectPopulationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected MedicinalProductUndesirableEffect.MedicinalProductUndesirableEffectPopulationComponent parseMedicinalProductUndesirableEffectMedicinalProductUndesirableEffectPopulationComponent(JsonObject json, MedicinalProductUndesirableEffect owner) throws IOException, FHIRFormatError {
    MedicinalProductUndesirableEffect.MedicinalProductUndesirableEffectPopulationComponent res = new MedicinalProductUndesirableEffect.MedicinalProductUndesirableEffectPopulationComponent();
    parseMedicinalProductUndesirableEffectMedicinalProductUndesirableEffectPopulationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMedicinalProductUndesirableEffectMedicinalProductUndesirableEffectPopulationComponentProperties(JsonObject json, MedicinalProductUndesirableEffect owner, MedicinalProductUndesirableEffect.MedicinalProductUndesirableEffectPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("gender"))
      res.setGender(parseCodeableConcept(json.getAsJsonObject("gender")));
    if (json.has("race"))
      res.setRace(parseCodeableConcept(json.getAsJsonObject("race")));
    if (json.has("physiologicalCondition"))
      res.setPhysiologicalCondition(parseCodeableConcept(json.getAsJsonObject("physiologicalCondition")));
  }

  protected MessageDefinition parseMessageDefinition(JsonObject json) throws IOException, FHIRFormatError {
    MessageDefinition res = new MessageDefinition();
    parseMessageDefinitionProperties(json, res);
    return res;
  }

  protected void parseMessageDefinitionProperties(JsonObject json, MessageDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_replaces")) {
      JsonArray array = json.getAsJsonArray("_replaces");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReplaces().size())
          res.getReplaces().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReplaces().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("base"))
      res.setBaseElement(parseCanonical(json.get("base").getAsString()));
    if (json.has("_base"))
      parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        res.getParent().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_parent")) {
      JsonArray array = json.getAsJsonArray("_parent");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParent().size())
          res.getParent().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParent().get(i));
      }
    };
    Type event = parseType("event", json);
    if (event != null)
      res.setEvent(event);
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseMessageDefinitionMessageDefinitionFocusComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("responseRequired"))
      res.setResponseRequiredElement(parseEnumeration(json.get("responseRequired").getAsString(), MessageDefinition.MessageheaderResponseRequest.NULL, new MessageDefinition.MessageheaderResponseRequestEnumFactory()));
    if (json.has("_responseRequired"))
      parseElementProperties(json.getAsJsonObject("_responseRequired"), res.getResponseRequiredElement());
    if (json.has("allowedResponse")) {
      JsonArray array = json.getAsJsonArray("allowedResponse");
      for (int i = 0; i < array.size(); i++) {
        res.getAllowedResponse().add(parseMessageDefinitionMessageDefinitionAllowedResponseComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("graph")) {
      JsonArray array = json.getAsJsonArray("graph");
      for (int i = 0; i < array.size(); i++) {
        res.getGraph().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_graph")) {
      JsonArray array = json.getAsJsonArray("_graph");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGraph().size())
          res.getGraph().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGraph().get(i));
      }
    };
  }

  protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionMessageDefinitionFocusComponent(JsonObject json, MessageDefinition owner) throws IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
    parseMessageDefinitionMessageDefinitionFocusComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageDefinitionMessageDefinitionFocusComponentProperties(JsonObject json, MessageDefinition owner, MessageDefinition.MessageDefinitionFocusComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
  }

  protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionMessageDefinitionAllowedResponseComponent(JsonObject json, MessageDefinition owner) throws IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
    parseMessageDefinitionMessageDefinitionAllowedResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageDefinitionMessageDefinitionAllowedResponseComponentProperties(JsonObject json, MessageDefinition owner, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("message"))
      res.setMessageElement(parseCanonical(json.get("message").getAsString()));
    if (json.has("_message"))
      parseElementProperties(json.getAsJsonObject("_message"), res.getMessageElement());
    if (json.has("situation"))
      res.setSituationElement(parseMarkdown(json.get("situation").getAsString()));
    if (json.has("_situation"))
      parseElementProperties(json.getAsJsonObject("_situation"), res.getSituationElement());
  }

  protected MessageHeader parseMessageHeader(JsonObject json) throws IOException, FHIRFormatError {
    MessageHeader res = new MessageHeader();
    parseMessageHeaderProperties(json, res);
    return res;
  }

  protected void parseMessageHeaderProperties(JsonObject json, MessageHeader res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    Type event = parseType("event", json);
    if (event != null)
      res.setEvent(event);
    if (json.has("destination")) {
      JsonArray array = json.getAsJsonArray("destination");
      for (int i = 0; i < array.size(); i++) {
        res.getDestination().add(parseMessageHeaderMessageDestinationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("source"))
      res.setSource(parseMessageHeaderMessageSourceComponent(json.getAsJsonObject("source"), res));
    if (json.has("responsible"))
      res.setResponsible(parseReference(json.getAsJsonObject("responsible")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("response"))
      res.setResponse(parseMessageHeaderMessageHeaderResponseComponent(json.getAsJsonObject("response"), res));
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
  }

  protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
    parseMessageHeaderMessageDestinationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageDestinationComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageDestinationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUrl(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
    if (json.has("receiver"))
      res.setReceiver(parseReference(json.getAsJsonObject("receiver")));
  }

  protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
    parseMessageHeaderMessageSourceComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageSourceComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("software"))
      res.setSoftwareElement(parseString(json.get("software").getAsString()));
    if (json.has("_software"))
      parseElementProperties(json.getAsJsonObject("_software"), res.getSoftwareElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("contact"))
      res.setContact(parseContactPoint(json.getAsJsonObject("contact")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUrl(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
  }

  protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
    parseMessageHeaderMessageHeaderResponseComponentProperties(json, owner, res);
    return res;
  }

  protected void parseMessageHeaderMessageHeaderResponseComponentProperties(JsonObject json, MessageHeader owner, MessageHeader.MessageHeaderResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifierElement(parseId(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("details"))
      res.setDetails(parseReference(json.getAsJsonObject("details")));
  }

  protected NamingSystem parseNamingSystem(JsonObject json) throws IOException, FHIRFormatError {
    NamingSystem res = new NamingSystem();
    parseNamingSystemProperties(json, res);
    return res;
  }

  protected void parseNamingSystemProperties(JsonObject json, NamingSystem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responsible"))
      res.setResponsibleElement(parseString(json.get("responsible").getAsString()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("uniqueId")) {
      JsonArray array = json.getAsJsonArray("uniqueId");
      for (int i = 0; i < array.size(); i++) {
        res.getUniqueId().add(parseNamingSystemNamingSystemUniqueIdComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(JsonObject json, NamingSystem owner) throws IOException, FHIRFormatError {
    NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
    parseNamingSystemNamingSystemUniqueIdComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNamingSystemNamingSystemUniqueIdComponentProperties(JsonObject json, NamingSystem owner, NamingSystem.NamingSystemUniqueIdComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("preferred"))
      res.setPreferredElement(parseBoolean(json.get("preferred").getAsBoolean()));
    if (json.has("_preferred"))
      parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected NutritionOrder parseNutritionOrder(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder res = new NutritionOrder();
    parseNutritionOrderProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderProperties(JsonObject json, NutritionOrder res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        res.getInstantiates().add(parseUri(array.get(i).getAsString()));
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), NutritionOrder.NutritiionOrderIntent.NULL, new NutritionOrder.NutritiionOrderIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
    if (json.has("orderer"))
      res.setOrderer(parseReference(json.getAsJsonObject("orderer")));
    if (json.has("allergyIntolerance")) {
      JsonArray array = json.getAsJsonArray("allergyIntolerance");
      for (int i = 0; i < array.size(); i++) {
        res.getAllergyIntolerance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("foodPreferenceModifier")) {
      JsonArray array = json.getAsJsonArray("foodPreferenceModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getFoodPreferenceModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("excludeFoodModifier")) {
      JsonArray array = json.getAsJsonArray("excludeFoodModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getExcludeFoodModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("oralDiet"))
      res.setOralDiet(parseNutritionOrderNutritionOrderOralDietComponent(json.getAsJsonObject("oralDiet"), res));
    if (json.has("supplement")) {
      JsonArray array = json.getAsJsonArray("supplement");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplement().add(parseNutritionOrderNutritionOrderSupplementComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("enteralFormula"))
      res.setEnteralFormula(parseNutritionOrderNutritionOrderEnteralFormulaComponent(json.getAsJsonObject("enteralFormula"), res));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
    parseNutritionOrderNutritionOrderOralDietComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("nutrient")) {
      JsonArray array = json.getAsJsonArray("nutrient");
      for (int i = 0; i < array.size(); i++) {
        res.getNutrient().add(parseNutritionOrderNutritionOrderOralDietNutrientComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("texture")) {
      JsonArray array = json.getAsJsonArray("texture");
      for (int i = 0; i < array.size(); i++) {
        res.getTexture().add(parseNutritionOrderNutritionOrderOralDietTextureComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("fluidConsistencyType")) {
      JsonArray array = json.getAsJsonArray("fluidConsistencyType");
      for (int i = 0; i < array.size(); i++) {
        res.getFluidConsistencyType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
  }

  protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
    parseNutritionOrderNutritionOrderOralDietNutrientComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietNutrientComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(json.getAsJsonObject("modifier")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(json.getAsJsonObject("amount")));
  }

  protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
    parseNutritionOrderNutritionOrderOralDietTextureComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderOralDietTextureComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(json.getAsJsonObject("modifier")));
    if (json.has("foodType"))
      res.setFoodType(parseCodeableConcept(json.getAsJsonObject("foodType")));
  }

  protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
    parseNutritionOrderNutritionOrderSupplementComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderSupplementComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderSupplementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("productName"))
      res.setProductNameElement(parseString(json.get("productName").getAsString()));
    if (json.has("_productName"))
      parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
    parseNutritionOrderNutritionOrderEnteralFormulaComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderEnteralFormulaComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("baseFormulaType"))
      res.setBaseFormulaType(parseCodeableConcept(json.getAsJsonObject("baseFormulaType")));
    if (json.has("baseFormulaProductName"))
      res.setBaseFormulaProductNameElement(parseString(json.get("baseFormulaProductName").getAsString()));
    if (json.has("_baseFormulaProductName"))
      parseElementProperties(json.getAsJsonObject("_baseFormulaProductName"), res.getBaseFormulaProductNameElement());
    if (json.has("additiveType"))
      res.setAdditiveType(parseCodeableConcept(json.getAsJsonObject("additiveType")));
    if (json.has("additiveProductName"))
      res.setAdditiveProductNameElement(parseString(json.get("additiveProductName").getAsString()));
    if (json.has("_additiveProductName"))
      parseElementProperties(json.getAsJsonObject("_additiveProductName"), res.getAdditiveProductNameElement());
    if (json.has("caloricDensity"))
      res.setCaloricDensity(parseQuantity(json.getAsJsonObject("caloricDensity")));
    if (json.has("routeofAdministration"))
      res.setRouteofAdministration(parseCodeableConcept(json.getAsJsonObject("routeofAdministration")));
    if (json.has("administration")) {
      JsonArray array = json.getAsJsonArray("administration");
      for (int i = 0; i < array.size(); i++) {
        res.getAdministration().add(parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("maxVolumeToDeliver"))
      res.setMaxVolumeToDeliver(parseQuantity(json.getAsJsonObject("maxVolumeToDeliver")));
    if (json.has("administrationInstruction"))
      res.setAdministrationInstructionElement(parseString(json.get("administrationInstruction").getAsString()));
    if (json.has("_administrationInstruction"))
      parseElementProperties(json.getAsJsonObject("_administrationInstruction"), res.getAdministrationInstructionElement());
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
    parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentProperties(json, owner, res);
    return res;
  }

  protected void parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentProperties(JsonObject json, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("schedule"))
      res.setSchedule(parseTiming(json.getAsJsonObject("schedule")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected Observation parseObservation(JsonObject json) throws IOException, FHIRFormatError {
    Observation res = new Observation();
    parseObservationProperties(json, res);
    return res;
  }

  protected void parseObservationProperties(JsonObject json, Observation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("interpretation")) {
      JsonArray array = json.getAsJsonArray("interpretation");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpretation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(json.getAsJsonObject("specimen")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("referenceRange")) {
      JsonArray array = json.getAsJsonArray("referenceRange");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("hasMember")) {
      JsonArray array = json.getAsJsonArray("hasMember");
      for (int i = 0; i < array.size(); i++) {
        res.getHasMember().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseObservationObservationComponentComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
    parseObservationObservationReferenceRangeComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationObservationReferenceRangeComponentProperties(JsonObject json, Observation owner, Observation.ObservationReferenceRangeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("low"))
      res.setLow(parseQuantity(json.getAsJsonObject("low")));
    if (json.has("high"))
      res.setHigh(parseQuantity(json.getAsJsonObject("high")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("appliesTo")) {
      JsonArray array = json.getAsJsonArray("appliesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getAppliesTo().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("age"))
      res.setAge(parseRange(json.getAsJsonObject("age")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
    parseObservationObservationComponentComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationObservationComponentComponentProperties(JsonObject json, Observation owner, Observation.ObservationComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("interpretation")) {
      JsonArray array = json.getAsJsonArray("interpretation");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpretation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referenceRange")) {
      JsonArray array = json.getAsJsonArray("referenceRange");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceRange().add(parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected ObservationDefinition parseObservationDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ObservationDefinition res = new ObservationDefinition();
    parseObservationDefinitionProperties(json, res);
    return res;
  }

  protected void parseObservationDefinitionProperties(JsonObject json, ObservationDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("permittedDataType")) {
      JsonArray array = json.getAsJsonArray("permittedDataType");
      for (int i = 0; i < array.size(); i++) {
        res.getPermittedDataType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("multipleResultsAllowed"))
      res.setMultipleResultsAllowedElement(parseBoolean(json.get("multipleResultsAllowed").getAsBoolean()));
    if (json.has("_multipleResultsAllowed"))
      parseElementProperties(json.getAsJsonObject("_multipleResultsAllowed"), res.getMultipleResultsAllowedElement());
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("preferredReportName"))
      res.setPreferredReportNameElement(parseString(json.get("preferredReportName").getAsString()));
    if (json.has("_preferredReportName"))
      parseElementProperties(json.getAsJsonObject("_preferredReportName"), res.getPreferredReportNameElement());
    if (json.has("quantitativeDetails"))
      res.setQuantitativeDetails(parseObservationDefinitionObservationDefinitionQuantitativeDetailsComponent(json.getAsJsonObject("quantitativeDetails"), res));
    if (json.has("qualifiedInterval")) {
      JsonArray array = json.getAsJsonArray("qualifiedInterval");
      for (int i = 0; i < array.size(); i++) {
        res.getQualifiedInterval().add(parseObservationDefinitionObservationDefinitionQualifiedIntervalComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("validCodedValueSet"))
      res.setValidCodedValueSetElement(parseUri(json.get("validCodedValueSet").getAsString()));
    if (json.has("_validCodedValueSet"))
      parseElementProperties(json.getAsJsonObject("_validCodedValueSet"), res.getValidCodedValueSetElement());
    if (json.has("normalCodedValueSet"))
      res.setNormalCodedValueSetElement(parseUri(json.get("normalCodedValueSet").getAsString()));
    if (json.has("_normalCodedValueSet"))
      parseElementProperties(json.getAsJsonObject("_normalCodedValueSet"), res.getNormalCodedValueSetElement());
    if (json.has("abnormalCodedValueSet"))
      res.setAbnormalCodedValueSetElement(parseUri(json.get("abnormalCodedValueSet").getAsString()));
    if (json.has("_abnormalCodedValueSet"))
      parseElementProperties(json.getAsJsonObject("_abnormalCodedValueSet"), res.getAbnormalCodedValueSetElement());
    if (json.has("criticalCodedValueSet"))
      res.setCriticalCodedValueSetElement(parseUri(json.get("criticalCodedValueSet").getAsString()));
    if (json.has("_criticalCodedValueSet"))
      parseElementProperties(json.getAsJsonObject("_criticalCodedValueSet"), res.getCriticalCodedValueSetElement());
  }

  protected ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent parseObservationDefinitionObservationDefinitionQuantitativeDetailsComponent(JsonObject json, ObservationDefinition owner) throws IOException, FHIRFormatError {
    ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent res = new ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent();
    parseObservationDefinitionObservationDefinitionQuantitativeDetailsComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationDefinitionObservationDefinitionQuantitativeDetailsComponentProperties(JsonObject json, ObservationDefinition owner, ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("customaryUnit"))
      res.setCustomaryUnit(parseCoding(json.getAsJsonObject("customaryUnit")));
    if (json.has("unit"))
      res.setUnit(parseCoding(json.getAsJsonObject("unit")));
    if (json.has("conversionFactor"))
      res.setConversionFactorElement(parseDecimal(json.get("conversionFactor").getAsBigDecimal()));
    if (json.has("_conversionFactor"))
      parseElementProperties(json.getAsJsonObject("_conversionFactor"), res.getConversionFactorElement());
    if (json.has("decimalPrecision"))
      res.setDecimalPrecisionElement(parseInteger(json.get("decimalPrecision").getAsLong()));
    if (json.has("_decimalPrecision"))
      parseElementProperties(json.getAsJsonObject("_decimalPrecision"), res.getDecimalPrecisionElement());
  }

  protected ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent parseObservationDefinitionObservationDefinitionQualifiedIntervalComponent(JsonObject json, ObservationDefinition owner) throws IOException, FHIRFormatError {
    ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent res = new ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent();
    parseObservationDefinitionObservationDefinitionQualifiedIntervalComponentProperties(json, owner, res);
    return res;
  }

  protected void parseObservationDefinitionObservationDefinitionQualifiedIntervalComponentProperties(JsonObject json, ObservationDefinition owner, ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("range"))
      res.setRange(parseRange(json.getAsJsonObject("range")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("appliesTo")) {
      JsonArray array = json.getAsJsonArray("appliesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getAppliesTo().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("age"))
      res.setAge(parseRange(json.getAsJsonObject("age")));
    if (json.has("gestationalAge"))
      res.setGestationalAge(parseRange(json.getAsJsonObject("gestationalAge")));
    if (json.has("condition"))
      res.setConditionElement(parseString(json.get("condition").getAsString()));
    if (json.has("_condition"))
      parseElementProperties(json.getAsJsonObject("_condition"), res.getConditionElement());
  }

  protected OperationDefinition parseOperationDefinition(JsonObject json) throws IOException, FHIRFormatError {
    OperationDefinition res = new OperationDefinition();
    parseOperationDefinitionProperties(json, res);
    return res;
  }

  protected void parseOperationDefinitionProperties(JsonObject json, OperationDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("affectsState"))
      res.setAffectsStateElement(parseBoolean(json.get("affectsState").getAsBoolean()));
    if (json.has("_affectsState"))
      parseElementProperties(json.getAsJsonObject("_affectsState"), res.getAffectsStateElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("base"))
      res.setBaseElement(parseCanonical(json.get("base").getAsString()));
    if (json.has("_base"))
      parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCode(array.get(i).getAsString()));
      }
    };
    if (json.has("_resource")) {
      JsonArray array = json.getAsJsonArray("_resource");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getResource().size())
          res.getResource().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getResource().get(i));
      }
    };
    if (json.has("system"))
      res.setSystemElement(parseBoolean(json.get("system").getAsBoolean()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("type"))
      res.setTypeElement(parseBoolean(json.get("type").getAsBoolean()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("instance"))
      res.setInstanceElement(parseBoolean(json.get("instance").getAsBoolean()));
    if (json.has("_instance"))
      parseElementProperties(json.getAsJsonObject("_instance"), res.getInstanceElement());
    if (json.has("inputProfile"))
      res.setInputProfileElement(parseCanonical(json.get("inputProfile").getAsString()));
    if (json.has("_inputProfile"))
      parseElementProperties(json.getAsJsonObject("_inputProfile"), res.getInputProfileElement());
    if (json.has("outputProfile"))
      res.setOutputProfileElement(parseCanonical(json.get("outputProfile").getAsString()));
    if (json.has("_outputProfile"))
      parseElementProperties(json.getAsJsonObject("_outputProfile"), res.getOutputProfileElement());
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("overload")) {
      JsonArray array = json.getAsJsonArray("overload");
      for (int i = 0; i < array.size(); i++) {
        res.getOverload().add(parseOperationDefinitionOperationDefinitionOverloadComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
    parseOperationDefinitionOperationDefinitionParameterComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationDefinitionOperationDefinitionParameterComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("targetProfile")) {
      JsonArray array = json.getAsJsonArray("targetProfile");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetProfile().add(parseCanonical(array.get(i).getAsString()));
      }
    };
    if (json.has("_targetProfile")) {
      JsonArray array = json.getAsJsonArray("_targetProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTargetProfile().size())
          res.getTargetProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTargetProfile().get(i));
      }
    };
    if (json.has("searchType"))
      res.setSearchTypeElement(parseEnumeration(json.get("searchType").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_searchType"))
      parseElementProperties(json.getAsJsonObject("_searchType"), res.getSearchTypeElement());
    if (json.has("binding"))
      res.setBinding(parseOperationDefinitionOperationDefinitionParameterBindingComponent(json.getAsJsonObject("binding"), owner));
    if (json.has("referencedFrom")) {
      JsonArray array = json.getAsJsonArray("referencedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getReferencedFrom().add(parseOperationDefinitionOperationDefinitionParameterReferencedFromComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
    if (json.has("part")) {
      JsonArray array = json.getAsJsonArray("part");
      for (int i = 0; i < array.size(); i++) {
        res.getPart().add(parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    };
  }

  protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
    parseOperationDefinitionOperationDefinitionParameterBindingComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationDefinitionOperationDefinitionParameterBindingComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterBindingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
  }

  protected OperationDefinition.OperationDefinitionParameterReferencedFromComponent parseOperationDefinitionOperationDefinitionParameterReferencedFromComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterReferencedFromComponent res = new OperationDefinition.OperationDefinitionParameterReferencedFromComponent();
    parseOperationDefinitionOperationDefinitionParameterReferencedFromComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationDefinitionOperationDefinitionParameterReferencedFromComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionParameterReferencedFromComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("source"))
      res.setSourceElement(parseString(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("sourceId"))
      res.setSourceIdElement(parseString(json.get("sourceId").getAsString()));
    if (json.has("_sourceId"))
      parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
  }

  protected OperationDefinition.OperationDefinitionOverloadComponent parseOperationDefinitionOperationDefinitionOverloadComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionOverloadComponent res = new OperationDefinition.OperationDefinitionOverloadComponent();
    parseOperationDefinitionOperationDefinitionOverloadComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationDefinitionOperationDefinitionOverloadComponentProperties(JsonObject json, OperationDefinition owner, OperationDefinition.OperationDefinitionOverloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("parameterName")) {
      JsonArray array = json.getAsJsonArray("parameterName");
      for (int i = 0; i < array.size(); i++) {
        res.getParameterName().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_parameterName")) {
      JsonArray array = json.getAsJsonArray("_parameterName");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParameterName().size())
          res.getParameterName().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParameterName().get(i));
      }
    };
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected OperationOutcome parseOperationOutcome(JsonObject json) throws IOException, FHIRFormatError {
    OperationOutcome res = new OperationOutcome();
    parseOperationOutcomeProperties(json, res);
    return res;
  }

  protected void parseOperationOutcomeProperties(JsonObject json, OperationOutcome res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("issue")) {
      JsonArray array = json.getAsJsonArray("issue");
      for (int i = 0; i < array.size(); i++) {
        res.getIssue().add(parseOperationOutcomeOperationOutcomeIssueComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(JsonObject json, OperationOutcome owner) throws IOException, FHIRFormatError {
    OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
    parseOperationOutcomeOperationOutcomeIssueComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOperationOutcomeOperationOutcomeIssueComponentProperties(JsonObject json, OperationOutcome owner, OperationOutcome.OperationOutcomeIssueComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("details"))
      res.setDetails(parseCodeableConcept(json.getAsJsonObject("details")));
    if (json.has("diagnostics"))
      res.setDiagnosticsElement(parseString(json.get("diagnostics").getAsString()));
    if (json.has("_diagnostics"))
      parseElementProperties(json.getAsJsonObject("_diagnostics"), res.getDiagnosticsElement());
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_location")) {
      JsonArray array = json.getAsJsonArray("_location");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLocation().size())
          res.getLocation().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLocation().get(i));
      }
    };
    if (json.has("expression")) {
      JsonArray array = json.getAsJsonArray("expression");
      for (int i = 0; i < array.size(); i++) {
        res.getExpression().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_expression")) {
      JsonArray array = json.getAsJsonArray("_expression");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExpression().size())
          res.getExpression().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getExpression().get(i));
      }
    };
  }

  protected Organization parseOrganization(JsonObject json) throws IOException, FHIRFormatError {
    Organization res = new Organization();
    parseOrganizationProperties(json, res);
    return res;
  }

  protected void parseOrganizationProperties(JsonObject json, Organization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseOrganizationOrganizationContactComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(JsonObject json, Organization owner) throws IOException, FHIRFormatError {
    Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
    parseOrganizationOrganizationContactComponentProperties(json, owner, res);
    return res;
  }

  protected void parseOrganizationOrganizationContactComponentProperties(JsonObject json, Organization owner, Organization.OrganizationContactComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("purpose"))
      res.setPurpose(parseCodeableConcept(json.getAsJsonObject("purpose")));
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
  }

  protected OrganizationAffiliation parseOrganizationAffiliation(JsonObject json) throws IOException, FHIRFormatError {
    OrganizationAffiliation res = new OrganizationAffiliation();
    parseOrganizationAffiliationProperties(json, res);
    return res;
  }

  protected void parseOrganizationAffiliationProperties(JsonObject json, OrganizationAffiliation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("participatingOrganization"))
      res.setParticipatingOrganization(parseReference(json.getAsJsonObject("participatingOrganization")));
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("healthcareService")) {
      JsonArray array = json.getAsJsonArray("healthcareService");
      for (int i = 0; i < array.size(); i++) {
        res.getHealthcareService().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Patient parsePatient(JsonObject json) throws IOException, FHIRFormatError {
    Patient res = new Patient();
    parsePatientProperties(json, res);
    return res;
  }

  protected void parsePatientProperties(JsonObject json, Patient res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    Type deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("maritalStatus"))
      res.setMaritalStatus(parseCodeableConcept(json.getAsJsonObject("maritalStatus")));
    Type multipleBirth = parseType("multipleBirth", json);
    if (multipleBirth != null)
      res.setMultipleBirth(multipleBirth);
    if (json.has("photo")) {
      JsonArray array = json.getAsJsonArray("photo");
      for (int i = 0; i < array.size(); i++) {
        res.getPhoto().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parsePatientContactComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("communication")) {
      JsonArray array = json.getAsJsonArray("communication");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunication().add(parsePatientPatientCommunicationComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("generalPractitioner")) {
      JsonArray array = json.getAsJsonArray("generalPractitioner");
      for (int i = 0; i < array.size(); i++) {
        res.getGeneralPractitioner().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parsePatientPatientLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Patient.ContactComponent parsePatientContactComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
    Patient.ContactComponent res = new Patient.ContactComponent();
    parsePatientContactComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePatientContactComponentProperties(JsonObject json, Patient owner, Patient.ContactComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relationship")) {
      JsonArray array = json.getAsJsonArray("relationship");
      for (int i = 0; i < array.size(); i++) {
        res.getRelationship().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
    Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
    parsePatientPatientCommunicationComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePatientPatientCommunicationComponentProperties(JsonObject json, Patient owner, Patient.PatientCommunicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
    if (json.has("preferred"))
      res.setPreferredElement(parseBoolean(json.get("preferred").getAsBoolean()));
    if (json.has("_preferred"))
      parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
  }

  protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
    Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
    parsePatientPatientLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePatientPatientLinkComponentProperties(JsonObject json, Patient owner, Patient.PatientLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("other"))
      res.setOther(parseReference(json.getAsJsonObject("other")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected PaymentNotice parsePaymentNotice(JsonObject json) throws IOException, FHIRFormatError {
    PaymentNotice res = new PaymentNotice();
    parsePaymentNoticeProperties(json, res);
    return res;
  }

  protected void parsePaymentNoticeProperties(JsonObject json, PaymentNotice res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), PaymentNotice.PaymentNoticeStatus.NULL, new PaymentNotice.PaymentNoticeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseReference(json.getAsJsonObject("response")));
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("paymentStatus"))
      res.setPaymentStatus(parseCodeableConcept(json.getAsJsonObject("paymentStatus")));
  }

  protected PaymentReconciliation parsePaymentReconciliation(JsonObject json) throws IOException, FHIRFormatError {
    PaymentReconciliation res = new PaymentReconciliation();
    parsePaymentReconciliationProperties(json, res);
    return res;
  }

  protected void parsePaymentReconciliationProperties(JsonObject json, PaymentReconciliation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), PaymentReconciliation.PaymentReconciliationStatus.NULL, new PaymentReconciliation.PaymentReconciliationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parsePaymentReconciliationDetailsComponent(array.get(i).getAsJsonObject(), res));
      }
    };
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("total"))
      res.setTotal(parseMoney(json.getAsJsonObject("total")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parsePaymentReconciliationNotesComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
    PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
    parsePaymentReconciliationDetailsComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePaymentReconciliationDetailsComponentProperties(JsonObject json, PaymentReconciliation owner, PaymentReconciliation.DetailsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseReference(json.getAsJsonObject("response")));
    if (json.has("submitter"))
      res.setSubmitter(parseReference(json.getAsJsonObject("submitter")));
    if (json.has("payee"))
      res.setPayee(parseReference(json.getAsJsonObject("payee")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
    PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
    parsePaymentReconciliationNotesComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePaymentReconciliationNotesComponentProperties(JsonObject json, PaymentReconciliation owner, PaymentReconciliation.NotesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Person parsePerson(JsonObject json) throws IOException, FHIRFormatError {
    Person res = new Person();
    parsePersonProperties(json, res);
    return res;
  }

  protected void parsePersonProperties(JsonObject json, Person res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("photo"))
      res.setPhoto(parseAttachment(json.getAsJsonObject("photo")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parsePersonPersonLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    };
  }

  protected Person.PersonLinkComponent parsePersonPersonLinkComponent(JsonObject json, Person owner) throws IOException, FHIRFormatError {
    Person.PersonLinkComponent res = new Person.PersonLinkComponent();
    parsePersonPersonLinkComponentProperties(json, owner, res);
    return res;
  }

  protected void parsePersonPersonLinkComponentProperties(JsonObject json, Person owner, Person.PersonLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("assurance"))
      res.setAssuranceElement(parseEnumeration(json.get("assurance").getAsString(), Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
    if (json.has("_assurance"))
      parseElementProperties(json.getAsJsonObject("_assurance"), res.getAssuranceElement());
  }

  protected PlanDefinition parsePlanDefinition(JsonObject json) throws IOException, FHIRFormatError {
    PlanDefinition res = new PlanDefinition();
    parsePlanDefinitionProperties(json, res);
    return res;
  }

  protected void parsePlanDefinitionProperties(JsonObject json, PlanDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    Type subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString(