/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.context;

import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.context.TerminologyCache;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetCheckerSimple;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.r4.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.r4.utils.client.FHIRToolingClient;
import org.hl7.fhir.utilities.OIDUtils;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public abstract class BaseWorkerContext
implements IWorkerContext {
    private Object lock = new Object();
    private Map<String, Map<String, Resource>> allResourcesById = new HashMap<String, Map<String, Resource>>();
    private Map<String, CodeSystem> codeSystems = new HashMap<String, CodeSystem>();
    private Set<String> nonSupportedCodeSystems = new HashSet<String>();
    private Map<String, ValueSet> valueSets = new HashMap<String, ValueSet>();
    private Map<String, ConceptMap> maps = new HashMap<String, ConceptMap>();
    private Map<String, StructureMap> transforms = new HashMap<String, StructureMap>();
    private Map<String, StructureDefinition> structures = new HashMap<String, StructureDefinition>();
    private Map<String, ImplementationGuide> guides = new HashMap<String, ImplementationGuide>();
    private Map<String, SearchParameter> searchParameters = new HashMap<String, SearchParameter>();
    private Map<String, Questionnaire> questionnaires = new HashMap<String, Questionnaire>();
    private Map<String, OperationDefinition> operations = new HashMap<String, OperationDefinition>();
    private Map<String, PlanDefinition> plans = new HashMap<String, PlanDefinition>();
    private List<NamingSystem> systems = new ArrayList<NamingSystem>();
    protected Map<String, Map<String, IWorkerContext.ValidationResult>> validationCache = new HashMap<String, Map<String, IWorkerContext.ValidationResult>>();
    protected String tsServer;
    protected String name;
    private boolean allowLoadingDuplicates;
    protected FHIRToolingClient txServer;
    private Bundle bndCodeSystems;
    private boolean canRunWithoutTerminology;
    protected boolean noTerminologyServer;
    private int expandCodesLimit = 1000;
    protected IWorkerContext.ILoggingService logger;
    protected Parameters expParameters;
    private TranslationServices translator = new NullTranslator();
    protected TerminologyCache txCache;
    private Set<String> notCanonical = new HashSet<String>();
    private String overrideVersionNs;

    public BaseWorkerContext() throws FileNotFoundException, IOException, FHIRException {
        this.txCache = new TerminologyCache(this.lock, null);
    }

    public BaseWorkerContext(Map<String, CodeSystem> codeSystems, Map<String, ValueSet> valueSets, Map<String, ConceptMap> maps, Map<String, StructureDefinition> profiles, Map<String, ImplementationGuide> guides) throws FileNotFoundException, IOException, FHIRException {
        this.codeSystems = codeSystems;
        this.valueSets = valueSets;
        this.maps = maps;
        this.structures = profiles;
        this.guides = guides;
        this.txCache = new TerminologyCache(this.lock, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(BaseWorkerContext other) {
        Object object = other.lock;
        synchronized (object) {
            this.allResourcesById.putAll(other.allResourcesById);
            this.translator = other.translator;
            this.codeSystems.putAll(other.codeSystems);
            this.nonSupportedCodeSystems.addAll(other.nonSupportedCodeSystems);
            this.valueSets.putAll(other.valueSets);
            this.maps.putAll(other.maps);
            this.transforms.putAll(other.transforms);
            this.structures.putAll(other.structures);
            this.searchParameters.putAll(other.searchParameters);
            this.plans.putAll(other.plans);
            this.questionnaires.putAll(other.questionnaires);
            this.operations.putAll(other.operations);
            this.systems.addAll(other.systems);
            this.guides.putAll(other.guides);
            this.allowLoadingDuplicates = other.allowLoadingDuplicates;
            this.tsServer = other.tsServer;
            this.name = other.name;
            this.txServer = other.txServer;
            this.bndCodeSystems = other.bndCodeSystems;
            this.canRunWithoutTerminology = other.canRunWithoutTerminology;
            this.noTerminologyServer = other.noTerminologyServer;
            if (other.txCache != null) {
                this.txCache = other.txCache.copy();
            }
            this.expandCodesLimit = other.expandCodesLimit;
            this.logger = other.logger;
            this.expParameters = other.expParameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheResource(Resource r) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            Map<String, Resource> map = this.allResourcesById.get(r.fhirType());
            if (map == null) {
                map = new HashMap<String, Resource>();
                this.allResourcesById.put(r.fhirType(), map);
            }
            map.put(r.getId(), r);
            if (r instanceof MetadataResource) {
                MetadataResource m = (MetadataResource)r;
                String url = m.getUrl();
                if (!this.allowLoadingDuplicates && this.hasResource(r.getClass(), url)) {
                    throw new DefinitionException("Duplicate Resource " + url);
                }
                if (r instanceof StructureDefinition) {
                    this.seeMetadataResource((StructureDefinition)m, this.structures, false);
                } else if (r instanceof ValueSet) {
                    this.seeMetadataResource((ValueSet)m, this.valueSets, false);
                } else if (r instanceof CodeSystem) {
                    this.seeMetadataResource((CodeSystem)m, this.codeSystems, false);
                } else if (r instanceof ImplementationGuide) {
                    this.seeMetadataResource((ImplementationGuide)m, this.guides, false);
                } else if (r instanceof SearchParameter) {
                    this.seeMetadataResource((SearchParameter)m, this.searchParameters, false);
                } else if (r instanceof PlanDefinition) {
                    this.seeMetadataResource((PlanDefinition)m, this.plans, false);
                } else if (r instanceof OperationDefinition) {
                    this.seeMetadataResource((OperationDefinition)m, this.operations, false);
                } else if (r instanceof Questionnaire) {
                    this.seeMetadataResource((Questionnaire)m, this.questionnaires, true);
                } else if (r instanceof ConceptMap) {
                    this.seeMetadataResource((ConceptMap)m, this.maps, false);
                } else if (r instanceof StructureMap) {
                    this.seeMetadataResource((StructureMap)m, this.transforms, false);
                } else if (r instanceof NamingSystem) {
                    this.systems.add((NamingSystem)r);
                }
            }
        }
    }

    private boolean laterVersion(String newVersion, String oldVersion) {
        newVersion = newVersion.trim();
        oldVersion = oldVersion.trim();
        if (StringUtils.isNumeric((CharSequence)newVersion) && StringUtils.isNumeric((CharSequence)oldVersion)) {
            return Double.parseDouble(newVersion) > Double.parseDouble(oldVersion);
        }
        if (this.hasDelimiter(newVersion, oldVersion, ".")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\.");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "-")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\-");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "_")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\_");
        }
        if (this.hasDelimiter(newVersion, oldVersion, ":")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\:");
        }
        if (this.hasDelimiter(newVersion, oldVersion, " ")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\ ");
        }
        return newVersion.compareTo(oldVersion) > 0;
    }

    private boolean hasDelimiter(String s1, String s2, String delimiter) {
        return s1.contains(delimiter) && s2.contains(delimiter) && s1.split(delimiter).length == s2.split(delimiter).length;
    }

    private boolean laterDelimitedVersion(String newVersion, String oldVersion, String delimiter) {
        String[] newParts = newVersion.split(delimiter);
        String[] oldParts = oldVersion.split(delimiter);
        for (int i = 0; i < newParts.length; ++i) {
            if (newParts[i].equals(oldParts[i])) continue;
            return this.laterVersion(newParts[i], oldParts[i]);
        }
        throw new Error("Delimited versions have exact match for delimiter '" + delimiter + "' : " + Arrays.asList(newParts) + " vs " + Arrays.asList(oldParts));
    }

    protected <T extends MetadataResource> void seeMetadataResource(T r, Map<String, T> map, boolean addId) throws FHIRException {
        if (addId) {
            map.put(r.getId(), r);
        }
        if (!map.containsKey(r.getUrl())) {
            map.put(r.getUrl(), r);
        } else {
            MetadataResource existingResource = (MetadataResource)map.get(r.getUrl());
            if (r.hasVersion() && existingResource.hasVersion() && !r.getVersion().equals(existingResource.getVersion())) {
                if (this.laterVersion(r.getVersion(), existingResource.getVersion())) {
                    map.remove(r.getUrl());
                    map.put(r.getUrl(), r);
                }
            } else {
                map.remove(r.getUrl());
            }
            map.put(r.getUrl(), r);
        }
        if (r.hasVersion()) {
            map.put(r.getUrl() + "|" + r.getVersion(), r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeSystem fetchCodeSystem(String system) {
        Object object = this.lock;
        synchronized (object) {
            return this.codeSystems.get(system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSystem(String system) throws TerminologyServiceException {
        Object object = this.lock;
        synchronized (object) {
            if (this.codeSystems.containsKey(system)) {
                return true;
            }
            if (this.nonSupportedCodeSystems.contains(system)) {
                return false;
            }
            if (system.startsWith("http://example.org") || system.startsWith("http://acme.com") || system.startsWith("http://hl7.org/fhir/valueset-") || system.startsWith("urn:oid:")) {
                return false;
            }
            if (this.noTerminologyServer) {
                return false;
            }
            if (this.bndCodeSystems == null) {
                try {
                    this.log("Terminology server: Check for supported code systems for " + system);
                    this.bndCodeSystems = this.txServer.fetchFeed(this.txServer.getAddress() + "/CodeSystem?content-mode=not-present&_summary=true&_count=1000");
                }
                catch (Exception e) {
                    if (this.canRunWithoutTerminology) {
                        this.noTerminologyServer = true;
                        this.log("==============!! Running without terminology server !! ==============");
                        if (this.txServer != null) {
                            this.log("txServer = " + this.txServer.getAddress());
                            this.log("Error = " + e.getMessage() + "");
                        }
                        this.log("=====================================================================");
                        return false;
                    }
                    throw new TerminologyServiceException((Throwable)e);
                }
            }
            if (this.bndCodeSystems != null) {
                for (Bundle.BundleEntryComponent be : this.bndCodeSystems.getEntry()) {
                    CodeSystem cs = (CodeSystem)be.getResource();
                    if (cs == null || this.codeSystems.containsKey(cs.getUrl())) continue;
                    this.codeSystems.put(cs.getUrl(), null);
                }
            }
            if (this.codeSystems.containsKey(system)) {
                return true;
            }
            this.nonSupportedCodeSystems.add(system);
            return false;
        }
    }

    private void log(String message) {
        if (this.logger != null) {
            this.logger.logMessage(message);
        } else {
            System.out.println(message);
        }
    }

    protected void tlog(String msg) {
        System.out.println("-tx cache miss: " + msg);
    }

    public int getExpandCodesLimit() {
        return this.expandCodesLimit;
    }

    public void setExpandCodesLimit(int expandCodesLimit) {
        this.expandCodesLimit = expandCodesLimit;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean heirarchical) throws FHIRException {
        ValueSet vs = null;
        vs = this.fetchResource(ValueSet.class, binding.getValueSet());
        if (vs == null) {
            throw new FHIRException("Unable to resolve value Set " + binding.getValueSet());
        }
        return this.expandVS(vs, cacheOk, heirarchical);
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean heirachical) throws TerminologyServiceException {
        ValueSet vs = new ValueSet();
        vs.setCompose(new ValueSet.ValueSetComposeComponent());
        vs.getCompose().getInclude().add(inc);
        TerminologyCache.CacheToken cacheToken = this.txCache.generateExpandToken(vs, heirachical);
        ValueSetExpander.ValueSetExpansionOutcome res = this.txCache.getExpansion(cacheToken);
        if (res != null) {
            return res;
        }
        Parameters p = this.expParameters.copy();
        p.setParameter("includeDefinition", false);
        p.setParameter("excludeNested", !heirachical);
        if (this.noTerminologyServer) {
            return new ValueSetExpander.ValueSetExpansionOutcome("Error expanding ValueSet: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("_limit", Integer.toString(this.expandCodesLimit));
        params.put("_incomplete", "true");
        this.tlog("$expand on " + this.txCache.summary(vs));
        try {
            ValueSet result = this.txServer.expandValueset(vs, p, params);
            res = new ValueSetExpander.ValueSetExpansionOutcome(result);
        }
        catch (Exception e) {
            res = new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
        }
        this.txCache.cacheExpansion(cacheToken, res, true);
        return res;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical) {
        if (this.expParameters == null) {
            throw new Error("No Expansion Parameters provided");
        }
        Parameters p = this.expParameters.copy();
        return this.expandVS(vs, cacheOk, heirarchical, p);
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical, Parameters p) {
        ValueSetExpander.ValueSetExpansionOutcome res;
        if (p == null) {
            throw new Error("No Parameters provided to expandVS");
        }
        if (vs.hasExpansion()) {
            return new ValueSetExpander.ValueSetExpansionOutcome(vs.copy());
        }
        if (!vs.hasUrl()) {
            throw new Error("no value set");
        }
        TerminologyCache.CacheToken cacheToken = this.txCache.generateExpandToken(vs, heirarchical);
        if (cacheOk && (res = this.txCache.getExpansion(cacheToken)) != null) {
            return res;
        }
        p.setParameter("includeDefinition", false);
        p.setParameter("excludeNested", !heirarchical);
        try {
            ValueSetExpanderSimple vse = new ValueSetExpanderSimple(this);
            res = vse.doExpand(vs, p);
            if (!res.getValueset().hasUrl()) {
                throw new Error("no url in expand value set");
            }
            this.txCache.cacheExpansion(cacheToken, res, false);
            return res;
        }
        catch (Exception vse) {
            if (this.noTerminologyServer) {
                return new ValueSetExpander.ValueSetExpansionOutcome("Error expanding ValueSet: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("_limit", Integer.toString(this.expandCodesLimit));
            params.put("_incomplete", "true");
            this.tlog("$expand on " + this.txCache.summary(vs));
            try {
                ValueSet result = this.txServer.expandValueset(vs, p, params);
                if (!result.hasUrl()) {
                    result.setUrl(vs.getUrl());
                }
                if (!result.hasUrl()) {
                    throw new Error("no url in expand value set 2");
                }
                res = new ValueSetExpander.ValueSetExpansionOutcome(result);
            }
            catch (Exception e) {
                res = new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
            }
            this.txCache.cacheExpansion(cacheToken, res, true);
            return res;
        }
    }

    private boolean hasTooCostlyExpansion(ValueSet valueset) {
        return valueset != null && valueset.hasExpansion() && ToolingExtensions.hasExtension(valueset.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly");
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display) {
        Coding c = new Coding(system, code, display);
        return this.validateCode(c, null);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display, ValueSet vs) {
        Coding c = new Coding(system, code, display);
        return this.validateCode(c, vs);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String code, ValueSet vs) {
        Coding c = new Coding(null, code, null);
        return this.doValidateCode(c, vs, true);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display, ValueSet.ConceptSetComponent vsi) {
        Coding c = new Coding(system, code, display);
        ValueSet vs = new ValueSet();
        vs.setUrl(Utilities.makeUuidUrn());
        vs.getCompose().addInclude(vsi);
        return this.validateCode(c, vs);
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(Coding code, ValueSet vs) {
        return this.doValidateCode(code, vs, false);
    }

    public IWorkerContext.ValidationResult doValidateCode(Coding code, ValueSet vs, boolean implySystem) {
        TerminologyCache.CacheToken cacheToken = this.txCache.generateValidationToken(code, vs);
        IWorkerContext.ValidationResult res = this.txCache.getValidation(cacheToken);
        if (res != null) {
            return res;
        }
        try {
            ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(vs, this);
            res = vsc.validateCode(code);
            this.txCache.cacheValidation(cacheToken, res, false);
            return res;
        }
        catch (Exception vsc) {
            if (this.noTerminologyServer) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Error validating code: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
            }
            String csumm = this.txCache.summary(code);
            this.tlog("$validate " + csumm + " for " + this.txCache.summary(vs));
            try {
                Parameters pIn = new Parameters();
                pIn.addParameter().setName("coding").setValue(code);
                if (implySystem) {
                    pIn.addParameter().setName("implySystem").setValue(new BooleanType(true));
                }
                res = this.validateOnServer(vs, pIn);
            }
            catch (Exception e) {
                res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            }
            this.txCache.cacheValidation(cacheToken, res, true);
            return res;
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(CodeableConcept code, ValueSet vs) {
        TerminologyCache.CacheToken cacheToken = this.txCache.generateValidationToken(code, vs);
        IWorkerContext.ValidationResult res = this.txCache.getValidation(cacheToken);
        if (res != null) {
            return res;
        }
        try {
            ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(vs, this);
            res = vsc.validateCode(code);
            this.txCache.cacheValidation(cacheToken, res, false);
            return res;
        }
        catch (Exception vsc) {
            if (this.noTerminologyServer) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Error validating code: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
            }
            this.tlog("$validate " + this.txCache.summary(code) + " for " + this.txCache.summary(vs));
            try {
                Parameters pIn = new Parameters();
                pIn.addParameter().setName("codeableConcept").setValue(code);
                res = this.validateOnServer(vs, pIn);
            }
            catch (Exception e) {
                res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            }
            this.txCache.cacheValidation(cacheToken, res, true);
            return res;
        }
    }

    private IWorkerContext.ValidationResult validateOnServer(ValueSet vs, Parameters pin) {
        if (vs != null) {
            pin.addParameter().setName("valueSet").setResource(vs);
        }
        for (Parameters.ParametersParameterComponent pp : pin.getParameter()) {
            if (!pp.getName().equals("profile")) continue;
            throw new Error("Can only specify profile in the context");
        }
        if (this.expParameters == null) {
            throw new Error("No ExpansionProfile provided");
        }
        pin.addParameter().setName("profile").setResource(this.expParameters);
        Parameters pOut = vs == null ? this.txServer.operateType(CodeSystem.class, "validate-code", pin) : this.txServer.operateType(ValueSet.class, "validate-code", pin);
        boolean ok = false;
        String message = "No Message returned";
        String display = null;
        ValueSetExpander.TerminologyServiceErrorClass err = ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN;
        for (Parameters.ParametersParameterComponent p : pOut.getParameter()) {
            if (p.getName().equals("result")) {
                ok = (Boolean)((BooleanType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("message")) {
                message = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("display")) {
                display = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (!p.getName().equals("cause")) continue;
            try {
                ValidationMessage.IssueType it = ValidationMessage.IssueType.fromCode((String)((String)((StringType)p.getValue()).getValue()));
                if (it == ValidationMessage.IssueType.UNKNOWN) {
                    err = ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN;
                    continue;
                }
                if (it != ValidationMessage.IssueType.NOTSUPPORTED) continue;
                err = ValueSetExpander.TerminologyServiceErrorClass.VALUESET_UNSUPPORTED;
            }
            catch (FHIRException fHIRException) {}
        }
        if (!ok) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, message, err);
        }
        if (message != null && !message.equals("No Message returned")) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, message, new CodeSystem.ConceptDefinitionComponent().setDisplay(display));
        }
        if (display != null) {
            return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setDisplay(display));
        }
        return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent());
    }

    public void initTS(String cachePath) throws Exception {
        this.txCache = new TerminologyCache(this.lock, cachePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConceptMap> findMapsForSource(String url) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<ConceptMap> res = new ArrayList<ConceptMap>();
            for (ConceptMap map : this.maps.values()) {
                if (!((Reference)map.getSource()).getReference().equals(url)) continue;
                res.add(map);
            }
            return res;
        }
    }

    public boolean isCanRunWithoutTerminology() {
        return this.canRunWithoutTerminology;
    }

    public void setCanRunWithoutTerminology(boolean canRunWithoutTerminology) {
        this.canRunWithoutTerminology = canRunWithoutTerminology;
    }

    @Override
    public void setLogger(IWorkerContext.ILoggingService logger) {
        this.logger = logger;
    }

    @Override
    public Parameters getExpansionParameters() {
        return this.expParameters;
    }

    @Override
    public void setExpansionProfile(Parameters expParameters) {
        this.expParameters = expParameters;
    }

    @Override
    public boolean isNoTerminologyServer() {
        return this.noTerminologyServer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Set<String> getResourceNamesAsSet() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.getResourceNames());
        return res;
    }

    public boolean isAllowLoadingDuplicates() {
        return this.allowLoadingDuplicates;
    }

    public void setAllowLoadingDuplicates(boolean allowLoadingDuplicates) {
        this.allowLoadingDuplicates = allowLoadingDuplicates;
    }

    @Override
    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        if (class_ == StructureDefinition.class) {
            uri = ProfileUtilities.sdNs(uri, this.getOverrideVersionNs());
        }
        Object object = this.lock;
        synchronized (object) {
            if (uri.startsWith("http:") || uri.startsWith("https:")) {
                Object version = null;
                if (uri.contains("#")) {
                    uri = uri.substring(0, uri.indexOf("#"));
                }
                if (class_ == Resource.class || class_ == null) {
                    if (this.structures.containsKey(uri)) {
                        return (T)this.structures.get(uri);
                    }
                    if (this.guides.containsKey(uri)) {
                        return (T)this.guides.get(uri);
                    }
                    if (this.valueSets.containsKey(uri)) {
                        return (T)this.valueSets.get(uri);
                    }
                    if (this.codeSystems.containsKey(uri)) {
                        return (T)this.codeSystems.get(uri);
                    }
                    if (this.operations.containsKey(uri)) {
                        return (T)this.operations.get(uri);
                    }
                    if (this.searchParameters.containsKey(uri)) {
                        return (T)this.searchParameters.get(uri);
                    }
                    if (this.plans.containsKey(uri)) {
                        return (T)this.plans.get(uri);
                    }
                    if (this.maps.containsKey(uri)) {
                        return (T)this.maps.get(uri);
                    }
                    if (this.transforms.containsKey(uri)) {
                        return (T)this.transforms.get(uri);
                    }
                    if (this.questionnaires.containsKey(uri)) {
                        return (T)this.questionnaires.get(uri);
                    }
                    return null;
                }
                if (class_ == ImplementationGuide.class) {
                    return (T)this.guides.get(uri);
                }
                if (class_ == StructureDefinition.class) {
                    return (T)this.structures.get(uri);
                }
                if (class_ == ValueSet.class) {
                    return (T)this.valueSets.get(uri);
                }
                if (class_ == CodeSystem.class) {
                    return (T)this.codeSystems.get(uri);
                }
                if (class_ == ConceptMap.class) {
                    return (T)this.maps.get(uri);
                }
                if (class_ == PlanDefinition.class) {
                    return (T)this.plans.get(uri);
                }
                if (class_ == OperationDefinition.class) {
                    OperationDefinition od = this.operations.get(uri);
                    return (T)od;
                }
                if (class_ == SearchParameter.class) {
                    SearchParameter res = this.searchParameters.get(uri);
                    if (res == null) {
                        StringBuilder b = new StringBuilder();
                        for (String s : this.searchParameters.keySet()) {
                            b.append(s);
                            b.append("\r\n");
                        }
                    }
                    if (res != null) {
                        return (T)res;
                    }
                }
            }
            if (class_ == Questionnaire.class) {
                return (T)this.questionnaires.get(uri);
            }
            if (class_ == null) {
                T res;
                if (uri.matches("((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|ItemInstance|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductClinicals|MedicinalProductContraindication|MedicinalProductDeviceSpec|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|ProcessRequest|ProcessResponse|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|Sequence|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstancePolymer|SubstanceReferenceInformation|SubstanceSpecification|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|UserSession|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && !uri.contains("ValueSet")) {
                    return null;
                }
                if ((Utilities.isAbsoluteUrl((String)uri) || uri.startsWith("ValueSet/")) && (res = null) != null) {
                    return res;
                }
                return null;
            }
            throw new FHIRException("not done yet: can't fetch " + uri);
        }
    }

    @Override
    public Resource fetchResourceById(String type, String uri) {
        Object object = this.lock;
        synchronized (object) {
            String[] parts = uri.split("\\/");
            if (!Utilities.noString((String)type) && parts.length == 1) {
                return this.allResourcesById.get(type).get(parts[0]);
            }
            if (parts.length >= 2) {
                if (!Utilities.noString((String)type) && !type.equals(parts[parts.length - 2])) {
                    throw new Error("Resource type mismatch for " + type + " / " + uri);
                }
                return this.allResourcesById.get(parts[parts.length - 2]).get(parts[parts.length - 1]);
            }
            throw new Error("Unable to process request for resource for " + type + " / " + uri);
        }
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public TranslationServices translator() {
        return this.translator;
    }

    public void setTranslator(TranslationServices translator) {
        this.translator = translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportStatus(JsonObject json) {
        Object object = this.lock;
        synchronized (object) {
            json.addProperty("codeystem-count", (Number)this.codeSystems.size());
            json.addProperty("valueset-count", (Number)this.valueSets.size());
            json.addProperty("conceptmap-count", (Number)this.maps.size());
            json.addProperty("transforms-count", (Number)this.transforms.size());
            json.addProperty("structures-count", (Number)this.structures.size());
            json.addProperty("guides-count", (Number)this.guides.size());
        }
    }

    public void dropResource(Resource r) throws FHIRException {
        this.dropResource(r.fhirType(), r.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropResource(String fhirType, String id) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, Resource> map = this.allResourcesById.get(fhirType);
            if (map == null) {
                map = new HashMap<String, Resource>();
                this.allResourcesById.put(fhirType, map);
            }
            if (map.containsKey(id)) {
                map.remove(id);
            }
            if (fhirType.equals("StructureDefinition")) {
                this.dropMetadataResource(this.structures, id);
            } else if (fhirType.equals("ImplementationGuide")) {
                this.dropMetadataResource(this.guides, id);
            } else if (fhirType.equals("ValueSet")) {
                this.dropMetadataResource(this.valueSets, id);
            } else if (fhirType.equals("CodeSystem")) {
                this.dropMetadataResource(this.codeSystems, id);
            } else if (fhirType.equals("OperationDefinition")) {
                this.dropMetadataResource(this.operations, id);
            } else if (fhirType.equals("Questionnaire")) {
                this.dropMetadataResource(this.questionnaires, id);
            } else if (fhirType.equals("ConceptMap")) {
                this.dropMetadataResource(this.maps, id);
            } else if (fhirType.equals("StructureMap")) {
                this.dropMetadataResource(this.transforms, id);
            } else if (fhirType.equals("NamingSystem")) {
                for (int i = this.systems.size() - 1; i >= 0; --i) {
                    if (!this.systems.get(i).getId().equals(id)) continue;
                    this.systems.remove(i);
                }
            }
        }
    }

    private <T extends MetadataResource> void dropMetadataResource(Map<String, T> map, String id) {
        MetadataResource res = (MetadataResource)map.get(id);
        if (res != null) {
            map.remove(id);
            if (map.containsKey(res.getUrl())) {
                map.remove(res.getUrl());
            }
            if (res.getVersion() != null && map.containsKey(res.getUrl() + "|" + res.getVersion())) {
                map.remove(res.getUrl() + "|" + res.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MetadataResource> allConformanceResources() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<MetadataResource> result = new ArrayList<MetadataResource>();
            result.addAll(this.structures.values());
            result.addAll(this.guides.values());
            result.addAll(this.codeSystems.values());
            result.addAll(this.valueSets.values());
            result.addAll(this.maps.values());
            result.addAll(this.transforms.values());
            result.addAll(this.plans.values());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonSupportedCodeSystems(String s) {
        Object object = this.lock;
        synchronized (object) {
            this.nonSupportedCodeSystems.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listNonSupportedSystems() {
        Object object = this.lock;
        synchronized (object) {
            String sl = null;
            for (String s : this.nonSupportedCodeSystems) {
                sl = sl == null ? s : sl + "\r\n" + s;
            }
            return sl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.valueSets.size() + this.maps.size() + this.structures.size() + this.transforms.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConceptMap> listMaps() {
        ArrayList<ConceptMap> m = new ArrayList<ConceptMap>();
        Object object = this.lock;
        synchronized (object) {
            m.addAll(this.maps.values());
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StructureMap> listTransforms() {
        ArrayList<StructureMap> m = new ArrayList<StructureMap>();
        Object object = this.lock;
        synchronized (object) {
            m.addAll(this.transforms.values());
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StructureMap getTransform(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.transforms.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StructureDefinition> listStructures() {
        ArrayList<StructureDefinition> m = new ArrayList<StructureDefinition>();
        Object object = this.lock;
        synchronized (object) {
            m.addAll(this.structures.values());
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureDefinition getStructure(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.structures.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String oid2Uri(String oid) {
        Object object = this.lock;
        synchronized (object) {
            String uri = OIDUtils.getUriForOid((String)oid);
            if (uri != null) {
                return uri;
            }
            for (NamingSystem ns : this.systems) {
                if (!this.hasOid(ns, oid) || (uri = this.getUri(ns)) == null) continue;
                return null;
            }
        }
        return null;
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheVS(JsonObject json, Map<String, IWorkerContext.ValidationResult> t) {
        Object object = this.lock;
        synchronized (object) {
            this.validationCache.put(json.get("url").getAsString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchParameter getSearchParameter(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.searchParameters.get(code);
        }
    }

    @Override
    public String getOverrideVersionNs() {
        return this.overrideVersionNs;
    }

    @Override
    public void setOverrideVersionNs(String value) {
        this.overrideVersionNs = value;
    }

    @Override
    public IWorkerContext.ILoggingService getLogger() {
        return this.logger;
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName) {
        if (Utilities.isAbsoluteUrl((String)typeName)) {
            return this.fetchResource(StructureDefinition.class, typeName);
        }
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public class NullTranslator
    implements TranslationServices {
        public String translate(String context, String value, String targetLang) {
            return value;
        }

        public String translate(String context, String value) {
            return value;
        }

        public String toStr(float value) {
            return null;
        }

        public String toStr(Date value) {
            return null;
        }

        public String translateAndFormat(String contest, String lang, String value, Object ... args) {
            return String.format(value, args);
        }

        public Map<String, String> translations(String value) {
            return null;
        }

        public Set<String> listTranslations(String category) {
            return null;
        }
    }
}

