/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ClaimResponse", profile="http://hl7.org/fhir/StructureDefinition/ClaimResponse")
public class ClaimResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Response  number", formalDefinition="The response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<ClaimResponseStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type or discipline", formalDefinition="The category of claim, e.g, oral, pharmacy, vision, institutional, professional.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-type")
    protected CodeableConcept type;
    @Child(name="subType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Finer grained claim type information", formalDefinition="A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the CMS Bill Type.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-subtype")
    protected CodeableConcept subType;
    @Child(name="use", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="claim | preauthorization | predetermination", formalDefinition="A claim, a list of completed goods and services; a preauthorization, a list or proposed goods and services; or a predetermination, a set of goods and services being considered, for which insurer adjudication is sought.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-use")
    protected Enumeration<Use> use;
    @Child(name="patient", type={Patient.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The subject of the Products and Services", formalDefinition="Patient Resource.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="created", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="insurer", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance issuing organization", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="requestProvider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestProvider;
    protected Resource requestProviderTarget;
    @Child(name="request", type={Claim.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Id of resource triggering adjudication", formalDefinition="Original request resource reference.")
    protected Reference request;
    protected Claim requestTarget;
    @Child(name="outcome", type={CodeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="queued | complete | error | partial", formalDefinition="Transaction: error, complete, partial processing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome")
    protected Enumeration<RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="preAuthRef", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Pre-Authorization/Determination Reference", formalDefinition="A list of references from the Insurer to which these services pertain.")
    protected StringType preAuthRef;
    @Child(name="payeeType", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party to be paid any benefits payable", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payeetype")
    protected CodeableConcept payeeType;
    @Child(name="item", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Line items", formalDefinition="The first-tier service adjudications for submitted services.")
    protected List<ItemComponent> item;
    @Child(name="addItem", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer added line items", formalDefinition="The first-tier service adjudications for payor added services.")
    protected List<AddedItemComponent> addItem;
    @Child(name="error", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing errors", formalDefinition="Mutually exclusive with Services Provided (Item).")
    protected List<ErrorComponent> error;
    @Child(name="total", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Adjudication totals", formalDefinition="Totals for amounts submitted, co-pays, benefits payable etc.")
    protected List<TotalComponent> total;
    @Child(name="payment", type={}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment Details", formalDefinition="Payment details for the claim if the claim has been paid.")
    protected PaymentComponent payment;
    @Child(name="reserved", type={Coding.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Funds reserved status", formalDefinition="Status of funds reservation (For provider, for Patient, None).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fundsreserve")
    protected Coding reserved;
    @Child(name="form", type={CodeableConcept.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept form;
    @Child(name="processNote", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing notes", formalDefinition="Note text.")
    protected List<NoteComponent> processNote;
    @Child(name="communicationRequest", type={CommunicationRequest.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request for additional information", formalDefinition="Request for additional supporting or authorizing information, such as: documents, images or resources.")
    protected List<Reference> communicationRequest;
    protected List<CommunicationRequest> communicationRequestTarget;
    @Child(name="insurance", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected List<InsuranceComponent> insurance;
    private static final long serialVersionUID = -1574471350L;
    @SearchParamDefinition(name="identifier", path="ClaimResponse.identifier", description="The identity of the ClaimResponse", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="ClaimResponse.request", description="The claim reference", type="reference", target={Claim.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("ClaimResponse:request").toLocked();
    @SearchParamDefinition(name="disposition", path="ClaimResponse.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="insurer", path="ClaimResponse.insurer", description="The organization who generated this resource", type="reference", target={Organization.class})
    public static final String SP_INSURER = "insurer";
    public static final ReferenceClientParam INSURER = new ReferenceClientParam("insurer");
    public static final Include INCLUDE_INSURER = new Include("ClaimResponse:insurer").toLocked();
    @SearchParamDefinition(name="created", path="ClaimResponse.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="patient", path="ClaimResponse.patient", description="The subject of care", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ClaimResponse:patient").toLocked();
    @SearchParamDefinition(name="payment-date", path="ClaimResponse.payment.date", description="The expected payment date", type="date")
    public static final String SP_PAYMENT_DATE = "payment-date";
    public static final DateClientParam PAYMENT_DATE = new DateClientParam("payment-date");
    @SearchParamDefinition(name="request-provider", path="ClaimResponse.requestProvider", description="The Provider of the claim", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_REQUEST_PROVIDER = "request-provider";
    public static final ReferenceClientParam REQUEST_PROVIDER = new ReferenceClientParam("request-provider");
    public static final Include INCLUDE_REQUEST_PROVIDER = new Include("ClaimResponse:request-provider").toLocked();
    @SearchParamDefinition(name="outcome", path="ClaimResponse.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="status", path="ClaimResponse.status", description="The status of the ClaimResponse", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ClaimResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ClaimResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ClaimResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ClaimResponseStatus>(new ClaimResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ClaimResponse setStatusElement(Enumeration<ClaimResponseStatus> value) {
        this.status = value;
        return this;
    }

    public ClaimResponseStatus getStatus() {
        return this.status == null ? null : (ClaimResponseStatus)((Object)this.status.getValue());
    }

    public ClaimResponse setStatus(ClaimResponseStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<ClaimResponseStatus>(new ClaimResponseStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ClaimResponse setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getSubType() {
        if (this.subType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.subType");
            }
            if (Configuration.doAutoCreate()) {
                this.subType = new CodeableConcept();
            }
        }
        return this.subType;
    }

    public boolean hasSubType() {
        return this.subType != null && !this.subType.isEmpty();
    }

    public ClaimResponse setSubType(CodeableConcept value) {
        this.subType = value;
        return this;
    }

    public Enumeration<Use> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public ClaimResponse setUseElement(Enumeration<Use> value) {
        this.use = value;
        return this;
    }

    public Use getUse() {
        return this.use == null ? null : (Use)((Object)this.use.getValue());
    }

    public ClaimResponse setUse(Use value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ClaimResponse setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ClaimResponse setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ClaimResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ClaimResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public ClaimResponse setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public ClaimResponse setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public Reference getRequestProvider() {
        if (this.requestProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProvider = new Reference();
            }
        }
        return this.requestProvider;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public ClaimResponse setRequestProvider(Reference value) {
        this.requestProvider = value;
        return this;
    }

    public Resource getRequestProviderTarget() {
        return this.requestProviderTarget;
    }

    public ClaimResponse setRequestProviderTarget(Resource value) {
        this.requestProviderTarget = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public ClaimResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Claim getRequestTarget() {
        if (this.requestTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.requestTarget = new Claim();
            }
        }
        return this.requestTarget;
    }

    public ClaimResponse setRequestTarget(Claim value) {
        this.requestTarget = value;
        return this;
    }

    public Enumeration<RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<RemittanceOutcome>(new RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public ClaimResponse setOutcomeElement(Enumeration<RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public ClaimResponse setOutcome(RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<RemittanceOutcome>(new RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ClaimResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public ClaimResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public StringType getPreAuthRefElement() {
        if (this.preAuthRef == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.preAuthRef");
            }
            if (Configuration.doAutoCreate()) {
                this.preAuthRef = new StringType();
            }
        }
        return this.preAuthRef;
    }

    public boolean hasPreAuthRefElement() {
        return this.preAuthRef != null && !this.preAuthRef.isEmpty();
    }

    public boolean hasPreAuthRef() {
        return this.preAuthRef != null && !this.preAuthRef.isEmpty();
    }

    public ClaimResponse setPreAuthRefElement(StringType value) {
        this.preAuthRef = value;
        return this;
    }

    public String getPreAuthRef() {
        return this.preAuthRef == null ? null : (String)this.preAuthRef.getValue();
    }

    public ClaimResponse setPreAuthRef(String value) {
        if (Utilities.noString((String)value)) {
            this.preAuthRef = null;
        } else {
            if (this.preAuthRef == null) {
                this.preAuthRef = new StringType();
            }
            this.preAuthRef.setValue(value);
        }
        return this;
    }

    public CodeableConcept getPayeeType() {
        if (this.payeeType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.payeeType");
            }
            if (Configuration.doAutoCreate()) {
                this.payeeType = new CodeableConcept();
            }
        }
        return this.payeeType;
    }

    public boolean hasPayeeType() {
        return this.payeeType != null && !this.payeeType.isEmpty();
    }

    public ClaimResponse setPayeeType(CodeableConcept value) {
        this.payeeType = value;
        return this;
    }

    public List<ItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        return this.item;
    }

    public ClaimResponse setItem(List<ItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemComponent addItem() {
        ItemComponent t = new ItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public ClaimResponse addItem(ItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public ItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    public List<AddedItemComponent> getAddItem() {
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        return this.addItem;
    }

    public ClaimResponse setAddItem(List<AddedItemComponent> theAddItem) {
        this.addItem = theAddItem;
        return this;
    }

    public boolean hasAddItem() {
        if (this.addItem == null) {
            return false;
        }
        for (AddedItemComponent item : this.addItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AddedItemComponent addAddItem() {
        AddedItemComponent t = new AddedItemComponent();
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return t;
    }

    public ClaimResponse addAddItem(AddedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return this;
    }

    public AddedItemComponent getAddItemFirstRep() {
        if (this.getAddItem().isEmpty()) {
            this.addAddItem();
        }
        return this.getAddItem().get(0);
    }

    public List<ErrorComponent> getError() {
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        return this.error;
    }

    public ClaimResponse setError(List<ErrorComponent> theError) {
        this.error = theError;
        return this;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (ErrorComponent item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ErrorComponent addError() {
        ErrorComponent t = new ErrorComponent();
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        this.error.add(t);
        return t;
    }

    public ClaimResponse addError(ErrorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        this.error.add(t);
        return this;
    }

    public ErrorComponent getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            this.addError();
        }
        return this.getError().get(0);
    }

    public List<TotalComponent> getTotal() {
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        return this.total;
    }

    public ClaimResponse setTotal(List<TotalComponent> theTotal) {
        this.total = theTotal;
        return this;
    }

    public boolean hasTotal() {
        if (this.total == null) {
            return false;
        }
        for (TotalComponent item : this.total) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TotalComponent addTotal() {
        TotalComponent t = new TotalComponent();
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        this.total.add(t);
        return t;
    }

    public ClaimResponse addTotal(TotalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        this.total.add(t);
        return this;
    }

    public TotalComponent getTotalFirstRep() {
        if (this.getTotal().isEmpty()) {
            this.addTotal();
        }
        return this.getTotal().get(0);
    }

    public PaymentComponent getPayment() {
        if (this.payment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.payment");
            }
            if (Configuration.doAutoCreate()) {
                this.payment = new PaymentComponent();
            }
        }
        return this.payment;
    }

    public boolean hasPayment() {
        return this.payment != null && !this.payment.isEmpty();
    }

    public ClaimResponse setPayment(PaymentComponent value) {
        this.payment = value;
        return this;
    }

    public Coding getReserved() {
        if (this.reserved == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.reserved");
            }
            if (Configuration.doAutoCreate()) {
                this.reserved = new Coding();
            }
        }
        return this.reserved;
    }

    public boolean hasReserved() {
        return this.reserved != null && !this.reserved.isEmpty();
    }

    public ClaimResponse setReserved(Coding value) {
        this.reserved = value;
        return this;
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public ClaimResponse setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public List<NoteComponent> getProcessNote() {
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        return this.processNote;
    }

    public ClaimResponse setProcessNote(List<NoteComponent> theProcessNote) {
        this.processNote = theProcessNote;
        return this;
    }

    public boolean hasProcessNote() {
        if (this.processNote == null) {
            return false;
        }
        for (NoteComponent item : this.processNote) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NoteComponent addProcessNote() {
        NoteComponent t = new NoteComponent();
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        this.processNote.add(t);
        return t;
    }

    public ClaimResponse addProcessNote(NoteComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        this.processNote.add(t);
        return this;
    }

    public NoteComponent getProcessNoteFirstRep() {
        if (this.getProcessNote().isEmpty()) {
            this.addProcessNote();
        }
        return this.getProcessNote().get(0);
    }

    public List<Reference> getCommunicationRequest() {
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        return this.communicationRequest;
    }

    public ClaimResponse setCommunicationRequest(List<Reference> theCommunicationRequest) {
        this.communicationRequest = theCommunicationRequest;
        return this;
    }

    public boolean hasCommunicationRequest() {
        if (this.communicationRequest == null) {
            return false;
        }
        for (Reference item : this.communicationRequest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCommunicationRequest() {
        Reference t = new Reference();
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        this.communicationRequest.add(t);
        return t;
    }

    public ClaimResponse addCommunicationRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        this.communicationRequest.add(t);
        return this;
    }

    public Reference getCommunicationRequestFirstRep() {
        if (this.getCommunicationRequest().isEmpty()) {
            this.addCommunicationRequest();
        }
        return this.getCommunicationRequest().get(0);
    }

    @Deprecated
    public List<CommunicationRequest> getCommunicationRequestTarget() {
        if (this.communicationRequestTarget == null) {
            this.communicationRequestTarget = new ArrayList<CommunicationRequest>();
        }
        return this.communicationRequestTarget;
    }

    @Deprecated
    public CommunicationRequest addCommunicationRequestTarget() {
        CommunicationRequest r = new CommunicationRequest();
        if (this.communicationRequestTarget == null) {
            this.communicationRequestTarget = new ArrayList<CommunicationRequest>();
        }
        this.communicationRequestTarget.add(r);
        return r;
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public ClaimResponse setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public ClaimResponse addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("type", "CodeableConcept", "The category of claim, e.g, oral, pharmacy, vision, institutional, professional.", 0, 1, this.type));
        children.add(new Property("subType", "CodeableConcept", "A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the CMS Bill Type.", 0, 1, this.subType));
        children.add(new Property("use", "code", "A claim, a list of completed goods and services; a preauthorization, a list or proposed goods and services; or a predetermination, a set of goods and services being considered, for which insurer adjudication is sought.", 0, 1, this.use));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, 1, this.patient));
        children.add(new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created));
        children.add(new Property(SP_INSURER, "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.insurer));
        children.add(new Property("requestProvider", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider));
        children.add(new Property(SP_REQUEST, "Reference(Claim)", "Original request resource reference.", 0, 1, this.request));
        children.add(new Property(SP_OUTCOME, "code", "Transaction: error, complete, partial processing.", 0, 1, this.outcome));
        children.add(new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, 1, this.disposition));
        children.add(new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, 1, this.preAuthRef));
        children.add(new Property("payeeType", "CodeableConcept", "Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.payeeType));
        children.add(new Property("item", "", "The first-tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.item));
        children.add(new Property("addItem", "", "The first-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.addItem));
        children.add(new Property("error", "", "Mutually exclusive with Services Provided (Item).", 0, Integer.MAX_VALUE, this.error));
        children.add(new Property("total", "", "Totals for amounts submitted, co-pays, benefits payable etc.", 0, Integer.MAX_VALUE, this.total));
        children.add(new Property("payment", "", "Payment details for the claim if the claim has been paid.", 0, 1, this.payment));
        children.add(new Property("reserved", "Coding", "Status of funds reservation (For provider, for Patient, None).", 0, 1, this.reserved));
        children.add(new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form));
        children.add(new Property("processNote", "", "Note text.", 0, Integer.MAX_VALUE, this.processNote));
        children.add(new Property("communicationRequest", "Reference(CommunicationRequest)", "Request for additional supporting or authorizing information, such as: documents, images or resources.", 0, Integer.MAX_VALUE, this.communicationRequest));
        children.add(new Property("insurance", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.insurance));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The response business identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The category of claim, e.g, oral, pharmacy, vision, institutional, professional.", 0, 1, this.type);
            }
            case -1868521062: {
                return new Property("subType", "CodeableConcept", "A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the CMS Bill Type.", 0, 1, this.subType);
            }
            case 116103: {
                return new Property("use", "code", "A claim, a list of completed goods and services; a preauthorization, a list or proposed goods and services; or a predetermination, a set of goods and services being considered, for which insurer adjudication is sought.", 0, 1, this.use);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, 1, this.patient);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created);
            }
            case 1957615864: {
                return new Property(SP_INSURER, "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.insurer);
            }
            case 1601527200: {
                return new Property("requestProvider", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(Claim)", "Original request resource reference.", 0, 1, this.request);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "code", "Transaction: error, complete, partial processing.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, 1, this.disposition);
            }
            case 522246568: {
                return new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, 1, this.preAuthRef);
            }
            case -316321118: {
                return new Property("payeeType", "CodeableConcept", "Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.payeeType);
            }
            case 3242771: {
                return new Property("item", "", "The first-tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.item);
            }
            case -1148899500: {
                return new Property("addItem", "", "The first-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.addItem);
            }
            case 96784904: {
                return new Property("error", "", "Mutually exclusive with Services Provided (Item).", 0, Integer.MAX_VALUE, this.error);
            }
            case 110549828: {
                return new Property("total", "", "Totals for amounts submitted, co-pays, benefits payable etc.", 0, Integer.MAX_VALUE, this.total);
            }
            case -786681338: {
                return new Property("payment", "", "Payment details for the claim if the claim has been paid.", 0, 1, this.payment);
            }
            case -350385368: {
                return new Property("reserved", "Coding", "Status of funds reservation (For provider, for Patient, None).", 0, 1, this.reserved);
            }
            case 3148996: {
                return new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form);
            }
            case 202339073: {
                return new Property("processNote", "", "Note text.", 0, Integer.MAX_VALUE, this.processNote);
            }
            case -2071896615: {
                return new Property("communicationRequest", "Reference(CommunicationRequest)", "Request for additional supporting or authorizing information, such as: documents, images or resources.", 0, Integer.MAX_VALUE, this.communicationRequest);
            }
            case 73049818: {
                return new Property("insurance", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.insurance);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1868521062: {
                Base[] baseArray;
                if (this.subType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subType;
                }
                return baseArray;
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.use;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.patient;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.created;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.insurer;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requestProvider;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.disposition;
                }
                return baseArray;
            }
            case 522246568: {
                Base[] baseArray;
                if (this.preAuthRef == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.preAuthRef;
                }
                return baseArray;
            }
            case -316321118: {
                Base[] baseArray;
                if (this.payeeType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.payeeType;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
            case -1148899500: {
                return this.addItem == null ? new Base[]{} : this.addItem.toArray(new Base[this.addItem.size()]);
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
            case 110549828: {
                return this.total == null ? new Base[]{} : this.total.toArray(new Base[this.total.size()]);
            }
            case -786681338: {
                Base[] baseArray;
                if (this.payment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.payment;
                }
                return baseArray;
            }
            case -350385368: {
                Base[] baseArray;
                if (this.reserved == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.reserved;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.form;
                }
                return baseArray;
            }
            case 202339073: {
                return this.processNote == null ? new Base[]{} : this.processNote.toArray(new Base[this.processNote.size()]);
            }
            case -2071896615: {
                return this.communicationRequest == null ? new Base[]{} : this.communicationRequest.toArray(new Base[this.communicationRequest.size()]);
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ClaimResponseStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1868521062: {
                this.subType = this.castToCodeableConcept(value);
                return value;
            }
            case 116103: {
                value = new UseEnumFactory().fromType(this.castToCode(value));
                this.use = value;
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case 1601527200: {
                this.requestProvider = this.castToReference(value);
                return value;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                return value;
            }
            case 522246568: {
                this.preAuthRef = this.castToString(value);
                return value;
            }
            case -316321118: {
                this.payeeType = this.castToCodeableConcept(value);
                return value;
            }
            case 3242771: {
                this.getItem().add((ItemComponent)((Object)value));
                return value;
            }
            case -1148899500: {
                this.getAddItem().add((AddedItemComponent)((Object)value));
                return value;
            }
            case 96784904: {
                this.getError().add((ErrorComponent)((Object)value));
                return value;
            }
            case 110549828: {
                this.getTotal().add((TotalComponent)((Object)value));
                return value;
            }
            case -786681338: {
                this.payment = (PaymentComponent)((Object)value);
                return value;
            }
            case -350385368: {
                this.reserved = this.castToCoding(value);
                return value;
            }
            case 3148996: {
                this.form = this.castToCodeableConcept(value);
                return value;
            }
            case 202339073: {
                this.getProcessNote().add((NoteComponent)((Object)value));
                return value;
            }
            case -2071896615: {
                this.getCommunicationRequest().add(this.castToReference(value));
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ClaimResponseStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("subType")) {
            this.subType = this.castToCodeableConcept(value);
        } else if (name.equals("use")) {
            value = new UseEnumFactory().fromType(this.castToCode(value));
            this.use = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_INSURER)) {
            this.insurer = this.castToReference(value);
        } else if (name.equals("requestProvider")) {
            this.requestProvider = this.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals(SP_OUTCOME)) {
            value = new RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
            this.outcome = value;
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = this.castToString(value);
        } else if (name.equals("preAuthRef")) {
            this.preAuthRef = this.castToString(value);
        } else if (name.equals("payeeType")) {
            this.payeeType = this.castToCodeableConcept(value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemComponent)((Object)value));
        } else if (name.equals("addItem")) {
            this.getAddItem().add((AddedItemComponent)((Object)value));
        } else if (name.equals("error")) {
            this.getError().add((ErrorComponent)((Object)value));
        } else if (name.equals("total")) {
            this.getTotal().add((TotalComponent)((Object)value));
        } else if (name.equals("payment")) {
            this.payment = (PaymentComponent)((Object)value);
        } else if (name.equals("reserved")) {
            this.reserved = this.castToCoding(value);
        } else if (name.equals("form")) {
            this.form = this.castToCodeableConcept(value);
        } else if (name.equals("processNote")) {
            this.getProcessNote().add((NoteComponent)((Object)value));
        } else if (name.equals("communicationRequest")) {
            this.getCommunicationRequest().add(this.castToReference(value));
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1868521062: {
                return this.getSubType();
            }
            case 116103: {
                return this.getUseElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case 1601527200: {
                return this.getRequestProvider();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 522246568: {
                return this.getPreAuthRefElement();
            }
            case -316321118: {
                return this.getPayeeType();
            }
            case 3242771: {
                return this.addItem();
            }
            case -1148899500: {
                return this.addAddItem();
            }
            case 96784904: {
                return this.addError();
            }
            case 110549828: {
                return this.addTotal();
            }
            case -786681338: {
                return this.getPayment();
            }
            case -350385368: {
                return this.getReserved();
            }
            case 3148996: {
                return this.getForm();
            }
            case 202339073: {
                return this.addProcessNote();
            }
            case -2071896615: {
                return this.addCommunicationRequest();
            }
            case 73049818: {
                return this.addInsurance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1868521062: {
                return new String[]{"CodeableConcept"};
            }
            case 116103: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case 1601527200: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 522246568: {
                return new String[]{"string"};
            }
            case -316321118: {
                return new String[]{"CodeableConcept"};
            }
            case 3242771: {
                return new String[0];
            }
            case -1148899500: {
                return new String[0];
            }
            case 96784904: {
                return new String[0];
            }
            case 110549828: {
                return new String[0];
            }
            case -786681338: {
                return new String[0];
            }
            case -350385368: {
                return new String[]{"Coding"};
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case 202339073: {
                return new String[0];
            }
            case -2071896615: {
                return new String[]{"Reference"};
            }
            case 73049818: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.status");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("subType")) {
            this.subType = new CodeableConcept();
            return this.subType;
        }
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.use");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.created");
        }
        if (name.equals(SP_INSURER)) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals("requestProvider")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.outcome");
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.disposition");
        }
        if (name.equals("preAuthRef")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.preAuthRef");
        }
        if (name.equals("payeeType")) {
            this.payeeType = new CodeableConcept();
            return this.payeeType;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("addItem")) {
            return this.addAddItem();
        }
        if (name.equals("error")) {
            return this.addError();
        }
        if (name.equals("total")) {
            return this.addTotal();
        }
        if (name.equals("payment")) {
            this.payment = new PaymentComponent();
            return this.payment;
        }
        if (name.equals("reserved")) {
            this.reserved = new Coding();
            return this.reserved;
        }
        if (name.equals("form")) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals("processNote")) {
            return this.addProcessNote();
        }
        if (name.equals("communicationRequest")) {
            return this.addCommunicationRequest();
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ClaimResponse";
    }

    @Override
    public ClaimResponse copy() {
        ClaimResponse dst = new ClaimResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subType = this.subType == null ? null : this.subType.copy();
        dst.use = this.use == null ? null : this.use.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.preAuthRef = this.preAuthRef == null ? null : this.preAuthRef.copy();
        CodeableConcept codeableConcept = dst.payeeType = this.payeeType == null ? null : this.payeeType.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemComponent>();
            for (ItemComponent itemComponent : this.item) {
                dst.item.add(itemComponent.copy());
            }
        }
        if (this.addItem != null) {
            dst.addItem = new ArrayList<AddedItemComponent>();
            for (AddedItemComponent addedItemComponent : this.addItem) {
                dst.addItem.add(addedItemComponent.copy());
            }
        }
        if (this.error != null) {
            dst.error = new ArrayList<ErrorComponent>();
            for (ErrorComponent errorComponent : this.error) {
                dst.error.add(errorComponent.copy());
            }
        }
        if (this.total != null) {
            dst.total = new ArrayList<TotalComponent>();
            for (TotalComponent totalComponent : this.total) {
                dst.total.add(totalComponent.copy());
            }
        }
        dst.payment = this.payment == null ? null : this.payment.copy();
        dst.reserved = this.reserved == null ? null : this.reserved.copy();
        CodeableConcept codeableConcept2 = dst.form = this.form == null ? null : this.form.copy();
        if (this.processNote != null) {
            dst.processNote = new ArrayList<NoteComponent>();
            for (NoteComponent noteComponent : this.processNote) {
                dst.processNote.add(noteComponent.copy());
            }
        }
        if (this.communicationRequest != null) {
            dst.communicationRequest = new ArrayList<Reference>();
            for (Reference reference : this.communicationRequest) {
                dst.communicationRequest.add(reference.copy());
            }
        }
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        return dst;
    }

    protected ClaimResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ClaimResponse)) {
            return false;
        }
        ClaimResponse o = (ClaimResponse)other_;
        return ClaimResponse.compareDeep(this.identifier, o.identifier, true) && ClaimResponse.compareDeep(this.status, o.status, true) && ClaimResponse.compareDeep(this.type, o.type, true) && ClaimResponse.compareDeep(this.subType, o.subType, true) && ClaimResponse.compareDeep(this.use, o.use, true) && ClaimResponse.compareDeep(this.patient, o.patient, true) && ClaimResponse.compareDeep(this.created, o.created, true) && ClaimResponse.compareDeep(this.insurer, o.insurer, true) && ClaimResponse.compareDeep(this.requestProvider, o.requestProvider, true) && ClaimResponse.compareDeep(this.request, o.request, true) && ClaimResponse.compareDeep(this.outcome, o.outcome, true) && ClaimResponse.compareDeep(this.disposition, o.disposition, true) && ClaimResponse.compareDeep(this.preAuthRef, o.preAuthRef, true) && ClaimResponse.compareDeep(this.payeeType, o.payeeType, true) && ClaimResponse.compareDeep(this.item, o.item, true) && ClaimResponse.compareDeep(this.addItem, o.addItem, true) && ClaimResponse.compareDeep(this.error, o.error, true) && ClaimResponse.compareDeep(this.total, o.total, true) && ClaimResponse.compareDeep(this.payment, o.payment, true) && ClaimResponse.compareDeep(this.reserved, o.reserved, true) && ClaimResponse.compareDeep(this.form, o.form, true) && ClaimResponse.compareDeep(this.processNote, o.processNote, true) && ClaimResponse.compareDeep(this.communicationRequest, o.communicationRequest, true) && ClaimResponse.compareDeep(this.insurance, o.insurance, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ClaimResponse)) {
            return false;
        }
        ClaimResponse o = (ClaimResponse)other_;
        return ClaimResponse.compareValues(this.status, o.status, true) && ClaimResponse.compareValues(this.use, o.use, true) && ClaimResponse.compareValues(this.created, o.created, true) && ClaimResponse.compareValues(this.outcome, o.outcome, true) && ClaimResponse.compareValues(this.disposition, o.disposition, true) && ClaimResponse.compareValues(this.preAuthRef, o.preAuthRef, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.subType, this.use, this.patient, this.created, this.insurer, this.requestProvider, this.request, this.outcome, this.disposition, this.preAuthRef, this.payeeType, this.item, this.addItem, this.error, this.total, this.payment, this.reserved, this.form, this.processNote, this.communicationRequest, this.insurance});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ClaimResponse;
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance identifier", formalDefinition="A service line item.")
        protected PositiveIntType sequence;
        @Child(name="focal", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is the focal Coverage", formalDefinition="The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.")
        protected BooleanType focal;
        @Child(name="coverage", type={Coverage.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        @Child(name="businessArrangement", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business agreement", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
        protected StringType businessArrangement;
        @Child(name="claimResponse", type={ClaimResponse.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication results", formalDefinition="The Coverages adjudication details.")
        protected Reference claimResponse;
        protected ClaimResponse claimResponseTarget;
        private static final long serialVersionUID = 282380584L;

        public InsuranceComponent() {
        }

        public InsuranceComponent(PositiveIntType sequence, BooleanType focal, Reference coverage) {
            this.sequence = sequence;
            this.focal = focal;
            this.coverage = coverage;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public InsuranceComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public InsuranceComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public InsuranceComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public InsuranceComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public InsuranceComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        public StringType getBusinessArrangementElement() {
            if (this.businessArrangement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.businessArrangement");
                }
                if (Configuration.doAutoCreate()) {
                    this.businessArrangement = new StringType();
                }
            }
            return this.businessArrangement;
        }

        public boolean hasBusinessArrangementElement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public boolean hasBusinessArrangement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public InsuranceComponent setBusinessArrangementElement(StringType value) {
            this.businessArrangement = value;
            return this;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
        }

        public InsuranceComponent setBusinessArrangement(String value) {
            if (Utilities.noString((String)value)) {
                this.businessArrangement = null;
            } else {
                if (this.businessArrangement == null) {
                    this.businessArrangement = new StringType();
                }
                this.businessArrangement.setValue(value);
            }
            return this;
        }

        public Reference getClaimResponse() {
            if (this.claimResponse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponse = new Reference();
                }
            }
            return this.claimResponse;
        }

        public boolean hasClaimResponse() {
            return this.claimResponse != null && !this.claimResponse.isEmpty();
        }

        public InsuranceComponent setClaimResponse(Reference value) {
            this.claimResponse = value;
            return this;
        }

        public ClaimResponse getClaimResponseTarget() {
            if (this.claimResponseTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponseTarget = new ClaimResponse();
                }
            }
            return this.claimResponseTarget;
        }

        public InsuranceComponent setClaimResponseTarget(ClaimResponse value) {
            this.claimResponseTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A service line item.", 0, 1, this.sequence));
            children.add(new Property("focal", "boolean", "The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.", 0, 1, this.focal));
            children.add(new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage));
            children.add(new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, 1, this.businessArrangement));
            children.add(new Property("claimResponse", "Reference(ClaimResponse)", "The Coverages adjudication details.", 0, 1, this.claimResponse));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A service line item.", 0, 1, this.sequence);
                }
                case 97604197: {
                    return new Property("focal", "boolean", "The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.", 0, 1, this.focal);
                }
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage);
                }
                case 259920682: {
                    return new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, 1, this.businessArrangement);
                }
                case 689513629: {
                    return new Property("claimResponse", "Reference(ClaimResponse)", "The Coverages adjudication details.", 0, 1, this.claimResponse);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 97604197: {
                    Base[] baseArray;
                    if (this.focal == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.focal;
                    }
                    return baseArray;
                }
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.coverage;
                    }
                    return baseArray;
                }
                case 259920682: {
                    Base[] baseArray;
                    if (this.businessArrangement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.businessArrangement;
                    }
                    return baseArray;
                }
                case 689513629: {
                    Base[] baseArray;
                    if (this.claimResponse == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.claimResponse;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 97604197: {
                    this.focal = this.castToBoolean(value);
                    return value;
                }
                case -351767064: {
                    this.coverage = this.castToReference(value);
                    return value;
                }
                case 259920682: {
                    this.businessArrangement = this.castToString(value);
                    return value;
                }
                case 689513629: {
                    this.claimResponse = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("focal")) {
                this.focal = this.castToBoolean(value);
            } else if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = this.castToString(value);
            } else if (name.equals("claimResponse")) {
                this.claimResponse = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 97604197: {
                    return this.getFocalElement();
                }
                case -351767064: {
                    return this.getCoverage();
                }
                case 259920682: {
                    return this.getBusinessArrangementElement();
                }
                case 689513629: {
                    return this.getClaimResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 97604197: {
                    return new String[]{"boolean"};
                }
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case 259920682: {
                    return new String[]{"string"};
                }
                case 689513629: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequence");
            }
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.focal");
            }
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("businessArrangement")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.businessArrangement");
            }
            if (name.equals("claimResponse")) {
                this.claimResponse = new Reference();
                return this.claimResponse;
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
            dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareDeep(this.sequence, o.sequence, true) && InsuranceComponent.compareDeep(this.focal, o.focal, true) && InsuranceComponent.compareDeep(this.coverage, o.coverage, true) && InsuranceComponent.compareDeep(this.businessArrangement, o.businessArrangement, true) && InsuranceComponent.compareDeep(this.claimResponse, o.claimResponse, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareValues(this.sequence, o.sequence, true) && InsuranceComponent.compareValues(this.focal, o.focal, true) && InsuranceComponent.compareValues(this.businessArrangement, o.businessArrangement, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.focal, this.coverage, this.businessArrangement, this.claimResponse});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.insurance";
        }
    }

    @Block
    public static class NoteComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sequence Number for this note", formalDefinition="An integer associated with each note which may be referred to from each service line item.")
        protected PositiveIntType number;
        @Child(name="type", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        protected Enumeration<Enumerations.NoteType> type;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Note explanatory text", formalDefinition="The note text.")
        protected StringType text;
        @Child(name="language", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language if different from the resource", formalDefinition="The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        private static final long serialVersionUID = -385184277L;

        public PositiveIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new PositiveIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public NoteComponent setNumberElement(PositiveIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public NoteComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new PositiveIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Enumeration<Enumerations.NoteType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NoteComponent setTypeElement(Enumeration<Enumerations.NoteType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.NoteType getType() {
            return this.type == null ? null : (Enumerations.NoteType)((Object)this.type.getValue());
        }

        public NoteComponent setType(Enumerations.NoteType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NoteComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NoteComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public NoteComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("number", "positiveInt", "An integer associated with each note which may be referred to from each service line item.", 0, 1, this.number));
            children.add(new Property("type", "code", "The note purpose: Print/Display.", 0, 1, this.type));
            children.add(new Property("text", "string", "The note text.", 0, 1, this.text));
            children.add(new Property("language", "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.", 0, 1, this.language));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1034364087: {
                    return new Property("number", "positiveInt", "An integer associated with each note which may be referred to from each service line item.", 0, 1, this.number);
                }
                case 3575610: {
                    return new Property("type", "code", "The note purpose: Print/Display.", 0, 1, this.type);
                }
                case 3556653: {
                    return new Property("text", "string", "The note text.", 0, 1, this.text);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.", 0, 1, this.language);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.number;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.language;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.number = this.castToPositiveInt(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.NoteTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                value = new Enumerations.NoteTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("language")) {
                this.language = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return new String[]{"positiveInt"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.number");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.type");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.text");
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            return super.addChild(name);
        }

        @Override
        public NoteComponent copy() {
            NoteComponent dst = new NoteComponent();
            this.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.language = this.language == null ? null : this.language.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NoteComponent)) {
                return false;
            }
            NoteComponent o = (NoteComponent)other_;
            return NoteComponent.compareDeep(this.number, o.number, true) && NoteComponent.compareDeep(this.type, o.type, true) && NoteComponent.compareDeep(this.text, o.text, true) && NoteComponent.compareDeep(this.language, o.language, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NoteComponent)) {
                return false;
            }
            NoteComponent o = (NoteComponent)other_;
            return NoteComponent.compareValues(this.number, o.number, true) && NoteComponent.compareValues(this.type, o.type, true) && NoteComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.number, this.type, this.text, this.language});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.processNote";
        }
    }

    @Block
    public static class PaymentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Partial or Complete", formalDefinition="Whether this represents partial or complete payment of the claim.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-paymenttype")
        protected CodeableConcept type;
        @Child(name="adjustment", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Payment adjustment for non-Claim issues", formalDefinition="Adjustment to the payment of this transaction which is not related to adjudication of this transaction.")
        protected Money adjustment;
        @Child(name="adjustmentReason", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation for the non-claim adjustment", formalDefinition="Reason for the payment adjustment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-adjustment-reason")
        protected CodeableConcept adjustmentReason;
        @Child(name="date", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Expected data of Payment", formalDefinition="Estimated payment data.")
        protected DateType date;
        @Child(name="amount", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Payable amount after adjustment", formalDefinition="Payable less any payment adjustment.")
        protected Money amount;
        @Child(name="identifier", type={Identifier.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier of the payment instrument", formalDefinition="Payment identifier.")
        protected Identifier identifier;
        private static final long serialVersionUID = 1539906026L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PaymentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Money getAdjustment() {
            if (this.adjustment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.adjustment");
                }
                if (Configuration.doAutoCreate()) {
                    this.adjustment = new Money();
                }
            }
            return this.adjustment;
        }

        public boolean hasAdjustment() {
            return this.adjustment != null && !this.adjustment.isEmpty();
        }

        public PaymentComponent setAdjustment(Money value) {
            this.adjustment = value;
            return this;
        }

        public CodeableConcept getAdjustmentReason() {
            if (this.adjustmentReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.adjustmentReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.adjustmentReason = new CodeableConcept();
                }
            }
            return this.adjustmentReason;
        }

        public boolean hasAdjustmentReason() {
            return this.adjustmentReason != null && !this.adjustmentReason.isEmpty();
        }

        public PaymentComponent setAdjustmentReason(CodeableConcept value) {
            this.adjustmentReason = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public PaymentComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public PaymentComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PaymentComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public PaymentComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Whether this represents partial or complete payment of the claim.", 0, 1, this.type));
            children.add(new Property("adjustment", "Money", "Adjustment to the payment of this transaction which is not related to adjudication of this transaction.", 0, 1, this.adjustment));
            children.add(new Property("adjustmentReason", "CodeableConcept", "Reason for the payment adjustment.", 0, 1, this.adjustmentReason));
            children.add(new Property("date", "date", "Estimated payment data.", 0, 1, this.date));
            children.add(new Property("amount", "Money", "Payable less any payment adjustment.", 0, 1, this.amount));
            children.add(new Property(ClaimResponse.SP_IDENTIFIER, "Identifier", "Payment identifier.", 0, 1, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Whether this represents partial or complete payment of the claim.", 0, 1, this.type);
                }
                case 1977085293: {
                    return new Property("adjustment", "Money", "Adjustment to the payment of this transaction which is not related to adjudication of this transaction.", 0, 1, this.adjustment);
                }
                case -1255938543: {
                    return new Property("adjustmentReason", "CodeableConcept", "Reason for the payment adjustment.", 0, 1, this.adjustmentReason);
                }
                case 3076014: {
                    return new Property("date", "date", "Estimated payment data.", 0, 1, this.date);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Payable less any payment adjustment.", 0, 1, this.amount);
                }
                case -1618432855: {
                    return new Property(ClaimResponse.SP_IDENTIFIER, "Identifier", "Payment identifier.", 0, 1, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1977085293: {
                    Base[] baseArray;
                    if (this.adjustment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.adjustment;
                    }
                    return baseArray;
                }
                case -1255938543: {
                    Base[] baseArray;
                    if (this.adjustmentReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.adjustmentReason;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.date;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.identifier;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1977085293: {
                    this.adjustment = this.castToMoney(value);
                    return value;
                }
                case -1255938543: {
                    this.adjustmentReason = this.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDate(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("adjustment")) {
                this.adjustment = this.castToMoney(value);
            } else if (name.equals("adjustmentReason")) {
                this.adjustmentReason = this.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals(ClaimResponse.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1977085293: {
                    return this.getAdjustment();
                }
                case -1255938543: {
                    return this.getAdjustmentReason();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1977085293: {
                    return new String[]{"Money"};
                }
                case -1255938543: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"date"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("adjustment")) {
                this.adjustment = new Money();
                return this.adjustment;
            }
            if (name.equals("adjustmentReason")) {
                this.adjustmentReason = new CodeableConcept();
                return this.adjustmentReason;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.date");
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals(ClaimResponse.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            return super.addChild(name);
        }

        @Override
        public PaymentComponent copy() {
            PaymentComponent dst = new PaymentComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.adjustment = this.adjustment == null ? null : this.adjustment.copy();
            dst.adjustmentReason = this.adjustmentReason == null ? null : this.adjustmentReason.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PaymentComponent)) {
                return false;
            }
            PaymentComponent o = (PaymentComponent)other_;
            return PaymentComponent.compareDeep(this.type, o.type, true) && PaymentComponent.compareDeep(this.adjustment, o.adjustment, true) && PaymentComponent.compareDeep(this.adjustmentReason, o.adjustmentReason, true) && PaymentComponent.compareDeep(this.date, o.date, true) && PaymentComponent.compareDeep(this.amount, o.amount, true) && PaymentComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PaymentComponent)) {
                return false;
            }
            PaymentComponent o = (PaymentComponent)other_;
            return PaymentComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.adjustment, this.adjustmentReason, this.date, this.amount, this.identifier});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.payment";
        }
    }

    @Block
    public static class TotalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication category such as submitted, co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Submitted, Co-Pay, deductible, eligible, benefit, tax, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication")
        protected CodeableConcept category;
        @Child(name="amount", type={Money.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monitory amount associated with the code.")
        protected Money amount;
        private static final long serialVersionUID = 2012310309L;

        public TotalComponent() {
        }

        public TotalComponent(CodeableConcept category, Money amount) {
            this.category = category;
            this.amount = amount;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TotalComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public TotalComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TotalComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public TotalComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Code indicating: Submitted, Co-Pay, deductible, eligible, benefit, tax, etc.", 0, 1, this.category));
            children.add(new Property("amount", "Money", "Monitory amount associated with the code.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code indicating: Submitted, Co-Pay, deductible, eligible, benefit, tax, etc.", 0, 1, this.category);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Monitory amount associated with the code.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public TotalComponent copy() {
            TotalComponent dst = new TotalComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TotalComponent)) {
                return false;
            }
            TotalComponent o = (TotalComponent)other_;
            return TotalComponent.compareDeep(this.category, o.category, true) && TotalComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TotalComponent)) {
                return false;
            }
            TotalComponent o = (TotalComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.amount});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.total";
        }
    }

    @Block
    public static class ErrorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="itemSequence", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Item sequence number", formalDefinition="The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.")
        protected PositiveIntType itemSequence;
        @Child(name="detailSequence", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected PositiveIntType detailSequence;
        @Child(name="subDetailSequence", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected PositiveIntType subDetailSequence;
        @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Error code detailing processing issues", formalDefinition="An error code, from a specified code system, which details why the claim could not be adjudicated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-error")
        protected CodeableConcept code;
        private static final long serialVersionUID = 843818320L;

        public ErrorComponent() {
        }

        public ErrorComponent(CodeableConcept code) {
            this.code = code;
        }

        public PositiveIntType getItemSequenceElement() {
            if (this.itemSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.itemSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemSequence = new PositiveIntType();
                }
            }
            return this.itemSequence;
        }

        public boolean hasItemSequenceElement() {
            return this.itemSequence != null && !this.itemSequence.isEmpty();
        }

        public boolean hasItemSequence() {
            return this.itemSequence != null && !this.itemSequence.isEmpty();
        }

        public ErrorComponent setItemSequenceElement(PositiveIntType value) {
            this.itemSequence = value;
            return this;
        }

        public int getItemSequence() {
            return this.itemSequence == null || this.itemSequence.isEmpty() ? 0 : (Integer)this.itemSequence.getValue();
        }

        public ErrorComponent setItemSequence(int value) {
            if (this.itemSequence == null) {
                this.itemSequence = new PositiveIntType();
            }
            this.itemSequence.setValue((Object)value);
            return this;
        }

        public PositiveIntType getDetailSequenceElement() {
            if (this.detailSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.detailSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailSequence = new PositiveIntType();
                }
            }
            return this.detailSequence;
        }

        public boolean hasDetailSequenceElement() {
            return this.detailSequence != null && !this.detailSequence.isEmpty();
        }

        public boolean hasDetailSequence() {
            return this.detailSequence != null && !this.detailSequence.isEmpty();
        }

        public ErrorComponent setDetailSequenceElement(PositiveIntType value) {
            this.detailSequence = value;
            return this;
        }

        public int getDetailSequence() {
            return this.detailSequence == null || this.detailSequence.isEmpty() ? 0 : (Integer)this.detailSequence.getValue();
        }

        public ErrorComponent setDetailSequence(int value) {
            if (this.detailSequence == null) {
                this.detailSequence = new PositiveIntType();
            }
            this.detailSequence.setValue((Object)value);
            return this;
        }

        public PositiveIntType getSubDetailSequenceElement() {
            if (this.subDetailSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.subDetailSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.subDetailSequence = new PositiveIntType();
                }
            }
            return this.subDetailSequence;
        }

        public boolean hasSubDetailSequenceElement() {
            return this.subDetailSequence != null && !this.subDetailSequence.isEmpty();
        }

        public boolean hasSubDetailSequence() {
            return this.subDetailSequence != null && !this.subDetailSequence.isEmpty();
        }

        public ErrorComponent setSubDetailSequenceElement(PositiveIntType value) {
            this.subDetailSequence = value;
            return this;
        }

        public int getSubDetailSequence() {
            return this.subDetailSequence == null || this.subDetailSequence.isEmpty() ? 0 : (Integer)this.subDetailSequence.getValue();
        }

        public ErrorComponent setSubDetailSequence(int value) {
            if (this.subDetailSequence == null) {
                this.subDetailSequence = new PositiveIntType();
            }
            this.subDetailSequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ErrorComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("itemSequence", "positiveInt", "The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.", 0, 1, this.itemSequence));
            children.add(new Property("detailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, 1, this.detailSequence));
            children.add(new Property("subDetailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, 1, this.subDetailSequence));
            children.add(new Property("code", "CodeableConcept", "An error code, from a specified code system, which details why the claim could not be adjudicated.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1977979892: {
                    return new Property("itemSequence", "positiveInt", "The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.", 0, 1, this.itemSequence);
                }
                case 1321472818: {
                    return new Property("detailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, 1, this.detailSequence);
                }
                case -855462510: {
                    return new Property("subDetailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, 1, this.subDetailSequence);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "An error code, from a specified code system, which details why the claim could not be adjudicated.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    Base[] baseArray;
                    if (this.itemSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.itemSequence;
                    }
                    return baseArray;
                }
                case 1321472818: {
                    Base[] baseArray;
                    if (this.detailSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detailSequence;
                    }
                    return baseArray;
                }
                case -855462510: {
                    Base[] baseArray;
                    if (this.subDetailSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.subDetailSequence;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    this.itemSequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1321472818: {
                    this.detailSequence = this.castToPositiveInt(value);
                    return value;
                }
                case -855462510: {
                    this.subDetailSequence = this.castToPositiveInt(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.itemSequence = this.castToPositiveInt(value);
            } else if (name.equals("detailSequence")) {
                this.detailSequence = this.castToPositiveInt(value);
            } else if (name.equals("subDetailSequence")) {
                this.subDetailSequence = this.castToPositiveInt(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.getItemSequenceElement();
                }
                case 1321472818: {
                    return this.getDetailSequenceElement();
                }
                case -855462510: {
                    return this.getSubDetailSequenceElement();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return new String[]{"positiveInt"};
                }
                case 1321472818: {
                    return new String[]{"positiveInt"};
                }
                case -855462510: {
                    return new String[]{"positiveInt"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.itemSequence");
            }
            if (name.equals("detailSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.detailSequence");
            }
            if (name.equals("subDetailSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.subDetailSequence");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ErrorComponent copy() {
            ErrorComponent dst = new ErrorComponent();
            this.copyValues(dst);
            dst.itemSequence = this.itemSequence == null ? null : this.itemSequence.copy();
            dst.detailSequence = this.detailSequence == null ? null : this.detailSequence.copy();
            dst.subDetailSequence = this.subDetailSequence == null ? null : this.subDetailSequence.copy();
            dst.code = this.code == null ? null : this.code.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ErrorComponent)) {
                return false;
            }
            ErrorComponent o = (ErrorComponent)other_;
            return ErrorComponent.compareDeep(this.itemSequence, o.itemSequence, true) && ErrorComponent.compareDeep(this.detailSequence, o.detailSequence, true) && ErrorComponent.compareDeep(this.subDetailSequence, o.subDetailSequence, true) && ErrorComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ErrorComponent)) {
                return false;
            }
            ErrorComponent o = (ErrorComponent)other_;
            return ErrorComponent.compareValues(this.itemSequence, o.itemSequence, true) && ErrorComponent.compareValues(this.detailSequence, o.detailSequence, true) && ErrorComponent.compareValues(this.subDetailSequence, o.subDetailSequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.itemSequence, this.detailSequence, this.subDetailSequence, this.code});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.error";
        }
    }

    @Block
    public static class AddedItemSubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="billcode", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Group, Service or Product", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="quantity", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items detail adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        private static final long serialVersionUID = 374278167L;

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public AddedItemSubDetailComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemSubDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemSubDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemSubDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemSubDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemSubDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemSubDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemSubDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemSubDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemSubDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemSubDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemSubDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemSubDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemSubDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("billcode", "CodeableConcept", "A code to indicate the Professional Service or Product supplied.", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "A code to indicate the Professional Service or Product supplied.", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.net;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemSubDetailComponent copy() {
            AddedItemSubDetailComponent dst = new AddedItemSubDetailComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemSubDetailComponent)) {
                return false;
            }
            AddedItemSubDetailComponent o = (AddedItemSubDetailComponent)other_;
            return AddedItemSubDetailComponent.compareDeep(this.billcode, o.billcode, true) && AddedItemSubDetailComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemSubDetailComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemSubDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemSubDetailComponent.compareDeep(this.factor, o.factor, true) && AddedItemSubDetailComponent.compareDeep(this.net, o.net, true) && AddedItemSubDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemSubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemSubDetailComponent)) {
                return false;
            }
            AddedItemSubDetailComponent o = (AddedItemSubDetailComponent)other_;
            return AddedItemSubDetailComponent.compareValues(this.factor, o.factor, true) && AddedItemSubDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.billcode, this.modifier, this.quantity, this.unitPrice, this.factor, this.net, this.noteNumber, this.adjudication});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem.detail.subDetail";
        }
    }

    @Block
    public static class AddedItemDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="billcode", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Group, Service or Product", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="quantity", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items detail adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Insurer added line items", formalDefinition="The third-tier service adjudications for payor added services.")
        protected List<AddedItemSubDetailComponent> subDetail;
        private static final long serialVersionUID = 212805939L;

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public AddedItemDetailComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<AddedItemSubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemSubDetailComponent>();
            }
            return this.subDetail;
        }

        public AddedItemDetailComponent setSubDetail(List<AddedItemSubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (AddedItemSubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemSubDetailComponent addSubDetail() {
            AddedItemSubDetailComponent t = new AddedItemSubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemSubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public AddedItemDetailComponent addSubDetail(AddedItemSubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemSubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public AddedItemSubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("billcode", "CodeableConcept", "A code to indicate the Professional Service or Product supplied.", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("subDetail", "", "The third-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "A code to indicate the Professional Service or Product supplied.", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -828829007: {
                    return new Property("subDetail", "", "The third-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.net;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((AddedItemSubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((AddedItemSubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemDetailComponent copy() {
            AddedItemDetailComponent dst = new AddedItemDetailComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<AddedItemSubDetailComponent>();
                for (AddedItemSubDetailComponent addedItemSubDetailComponent : this.subDetail) {
                    dst.subDetail.add(addedItemSubDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemDetailComponent)) {
                return false;
            }
            AddedItemDetailComponent o = (AddedItemDetailComponent)other_;
            return AddedItemDetailComponent.compareDeep(this.billcode, o.billcode, true) && AddedItemDetailComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemDetailComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemDetailComponent.compareDeep(this.factor, o.factor, true) && AddedItemDetailComponent.compareDeep(this.net, o.net, true) && AddedItemDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemDetailComponent.compareDeep(this.adjudication, o.adjudication, true) && AddedItemDetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemDetailComponent)) {
                return false;
            }
            AddedItemDetailComponent o = (AddedItemDetailComponent)other_;
            return AddedItemDetailComponent.compareValues(this.factor, o.factor, true) && AddedItemDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.billcode, this.modifier, this.quantity, this.unitPrice, this.factor, this.net, this.noteNumber, this.adjudication, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem.detail";
        }
    }

    @Block
    public static class AddedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="itemSequence", type={PositiveIntType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service instances", formalDefinition="List of input service items which this service line is intended to replace.")
        protected List<PositiveIntType> itemSequence;
        @Child(name="detailSequence", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected List<PositiveIntType> detailSequence;
        @Child(name="subdetailSequence", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected List<PositiveIntType> subdetailSequence;
        @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Authorized providers", formalDefinition="The providers who are authorized for the services rendered to the patient.")
        protected List<Reference> provider;
        protected List<Resource> providerTarget;
        @Child(name="billcode", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Group, Service or Product", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="serviced", type={DateType.class, Period.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date or dates of Service", formalDefinition="The date or dates when the service or product was supplied, performed or completed.")
        protected Type serviced;
        @Child(name="location", type={CodeableConcept.class, Address.class, Location.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Place of service", formalDefinition="Where the service was provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-place")
        protected Type location;
        @Child(name="quantity", type={Quantity.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="bodySite", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service Location", formalDefinition="Physical service site on the patient (limb, tooth, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/tooth")
        protected CodeableConcept bodySite;
        @Child(name="subSite", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service Sub-location", formalDefinition="A region or surface of the site, e.g. limb region or tooth surface(s).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/surface")
        protected List<CodeableConcept> subSite;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=16, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=17, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Insurer added line items", formalDefinition="The second-tier service adjudications for payor added services.")
        protected List<AddedItemDetailComponent> detail;
        private static final long serialVersionUID = 691249599L;

        public List<PositiveIntType> getItemSequence() {
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            return this.itemSequence;
        }

        public AddedItemComponent setItemSequence(List<PositiveIntType> theItemSequence) {
            this.itemSequence = theItemSequence;
            return this;
        }

        public boolean hasItemSequence() {
            if (this.itemSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.itemSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addItemSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            this.itemSequence.add(t);
            return t;
        }

        public AddedItemComponent addItemSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            this.itemSequence.add(t);
            return this;
        }

        public boolean hasItemSequence(int value) {
            if (this.itemSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.itemSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getDetailSequence() {
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            return this.detailSequence;
        }

        public AddedItemComponent setDetailSequence(List<PositiveIntType> theDetailSequence) {
            this.detailSequence = theDetailSequence;
            return this;
        }

        public boolean hasDetailSequence() {
            if (this.detailSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.detailSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDetailSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            this.detailSequence.add(t);
            return t;
        }

        public AddedItemComponent addDetailSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            this.detailSequence.add(t);
            return this;
        }

        public boolean hasDetailSequence(int value) {
            if (this.detailSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.detailSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getSubdetailSequence() {
            if (this.subdetailSequence == null) {
                this.subdetailSequence = new ArrayList<PositiveIntType>();
            }
            return this.subdetailSequence;
        }

        public AddedItemComponent setSubdetailSequence(List<PositiveIntType> theSubdetailSequence) {
            this.subdetailSequence = theSubdetailSequence;
            return this;
        }

        public boolean hasSubdetailSequence() {
            if (this.subdetailSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.subdetailSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addSubdetailSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.subdetailSequence == null) {
                this.subdetailSequence = new ArrayList<PositiveIntType>();
            }
            this.subdetailSequence.add(t);
            return t;
        }

        public AddedItemComponent addSubdetailSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.subdetailSequence == null) {
                this.subdetailSequence = new ArrayList<PositiveIntType>();
            }
            this.subdetailSequence.add(t);
            return this;
        }

        public boolean hasSubdetailSequence(int value) {
            if (this.subdetailSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.subdetailSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Reference> getProvider() {
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            return this.provider;
        }

        public AddedItemComponent setProvider(List<Reference> theProvider) {
            this.provider = theProvider;
            return this;
        }

        public boolean hasProvider() {
            if (this.provider == null) {
                return false;
            }
            for (Reference item : this.provider) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addProvider() {
            Reference t = new Reference();
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            this.provider.add(t);
            return t;
        }

        public AddedItemComponent addProvider(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            this.provider.add(t);
            return this;
        }

        public Reference getProviderFirstRep() {
            if (this.getProvider().isEmpty()) {
                this.addProvider();
            }
            return this.getProvider().get(0);
        }

        @Deprecated
        public List<Resource> getProviderTarget() {
            if (this.providerTarget == null) {
                this.providerTarget = new ArrayList<Resource>();
            }
            return this.providerTarget;
        }

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public AddedItemComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public AddedItemComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public AddedItemComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Type getServiced() {
            return this.serviced;
        }

        public DateType getServicedDateType() throws FHIRException {
            if (this.serviced == null) {
                return null;
            }
            if (!(this.serviced instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (DateType)this.serviced;
        }

        public boolean hasServicedDateType() {
            return this != null && this.serviced instanceof DateType;
        }

        public Period getServicedPeriod() throws FHIRException {
            if (this.serviced == null) {
                return null;
            }
            if (!(this.serviced instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (Period)this.serviced;
        }

        public boolean hasServicedPeriod() {
            return this != null && this.serviced instanceof Period;
        }

        public boolean hasServiced() {
            return this.serviced != null && !this.serviced.isEmpty();
        }

        public AddedItemComponent setServiced(Type value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new Error("Not the right type for ClaimResponse.addItem.serviced[x]: " + value.fhirType());
            }
            this.serviced = value;
            return this;
        }

        public Type getLocation() {
            return this.location;
        }

        public CodeableConcept getLocationCodeableConcept() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.location;
        }

        public boolean hasLocationCodeableConcept() {
            return this != null && this.location instanceof CodeableConcept;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AddedItemComponent setLocation(Type value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Address || value instanceof Reference)) {
                throw new Error("Not the right type for ClaimResponse.addItem.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public CodeableConcept getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableConcept();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public AddedItemComponent setBodySite(CodeableConcept value) {
            this.bodySite = value;
            return this;
        }

        public List<CodeableConcept> getSubSite() {
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            return this.subSite;
        }

        public AddedItemComponent setSubSite(List<CodeableConcept> theSubSite) {
            this.subSite = theSubSite;
            return this;
        }

        public boolean hasSubSite() {
            if (this.subSite == null) {
                return false;
            }
            for (CodeableConcept item : this.subSite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSubSite() {
            CodeableConcept t = new CodeableConcept();
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return t;
        }

        public AddedItemComponent addSubSite(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return this;
        }

        public CodeableConcept getSubSiteFirstRep() {
            if (this.getSubSite().isEmpty()) {
                this.addSubSite();
            }
            return this.getSubSite().get(0);
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<AddedItemDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            return this.detail;
        }

        public AddedItemComponent setDetail(List<AddedItemDetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (AddedItemDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemDetailComponent addDetail() {
            AddedItemDetailComponent t = new AddedItemDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public AddedItemComponent addDetail(AddedItemDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public AddedItemDetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("itemSequence", "positiveInt", "List of input service items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.itemSequence));
            children.add(new Property("detailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.detailSequence));
            children.add(new Property("subdetailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.subdetailSequence));
            children.add(new Property("provider", "Reference(Practitioner|PractitionerRole|Organization)", "The providers who are authorized for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
            children.add(new Property("billcode", "CodeableConcept", "A code to indicate the Professional Service or Product supplied.", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced));
            children.add(new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc.).", 0, 1, this.bodySite));
            children.add(new Property("subSite", "CodeableConcept", "A region or surface of the site, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("detail", "", "The second-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1977979892: {
                    return new Property("itemSequence", "positiveInt", "List of input service items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.itemSequence);
                }
                case 1321472818: {
                    return new Property("detailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.detailSequence);
                }
                case 146530674: {
                    return new Property("subdetailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.subdetailSequence);
                }
                case -987494927: {
                    return new Property("provider", "Reference(Practitioner|PractitionerRole|Organization)", "The providers who are authorized for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider);
                }
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "A code to indicate the Professional Service or Product supplied.", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1927922223: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1379209295: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 363246749: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1534966512: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 552316075: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1224800468: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case 1702620169: {
                    return new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc.).", 0, 1, this.bodySite);
                }
                case -1868566105: {
                    return new Property("subSite", "CodeableConcept", "A region or surface of the site, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -1335224239: {
                    return new Property("detail", "", "The second-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.itemSequence == null ? new Base[]{} : this.itemSequence.toArray(new Base[this.itemSequence.size()]);
                }
                case 1321472818: {
                    return this.detailSequence == null ? new Base[]{} : this.detailSequence.toArray(new Base[this.detailSequence.size()]);
                }
                case 146530674: {
                    return this.subdetailSequence == null ? new Base[]{} : this.subdetailSequence.toArray(new Base[this.subdetailSequence.size()]);
                }
                case -987494927: {
                    return this.provider == null ? new Base[]{} : this.provider.toArray(new Base[this.provider.size()]);
                }
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case 1379209295: {
                    Base[] baseArray;
                    if (this.serviced == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.serviced;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.location;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.net;
                    }
                    return baseArray;
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -1868566105: {
                    return this.subSite == null ? new Base[]{} : this.subSite.toArray(new Base[this.subSite.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    this.getItemSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case 1321472818: {
                    this.getDetailSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case 146530674: {
                    this.getSubdetailSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -987494927: {
                    this.getProvider().add(this.castToReference(value));
                    return value;
                }
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1379209295: {
                    this.serviced = this.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToType(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 1702620169: {
                    this.bodySite = this.castToCodeableConcept(value);
                    return value;
                }
                case -1868566105: {
                    this.getSubSite().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((AddedItemDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.getItemSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("detailSequence")) {
                this.getDetailSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("subdetailSequence")) {
                this.getSubdetailSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("provider")) {
                this.getProvider().add(this.castToReference(value));
            } else if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("serviced[x]")) {
                this.serviced = this.castToType(value);
            } else if (name.equals("location[x]")) {
                this.location = this.castToType(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCodeableConcept(value);
            } else if (name.equals("subSite")) {
                this.getSubSite().add(this.castToCodeableConcept(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((AddedItemDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.addItemSequenceElement();
                }
                case 1321472818: {
                    return this.addDetailSequenceElement();
                }
                case 146530674: {
                    return this.addSubdetailSequenceElement();
                }
                case -987494927: {
                    return this.addProvider();
                }
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1927922223: {
                    return this.getServiced();
                }
                case 1379209295: {
                    return this.getServiced();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -1868566105: {
                    return this.addSubSite();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return new String[]{"positiveInt"};
                }
                case 1321472818: {
                    return new String[]{"positiveInt"};
                }
                case 146530674: {
                    return new String[]{"positiveInt"};
                }
                case -987494927: {
                    return new String[]{"Reference"};
                }
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case 1379209295: {
                    return new String[]{"date", "Period"};
                }
                case 1901043637: {
                    return new String[]{"CodeableConcept", "Address", "Reference"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 1702620169: {
                    return new String[]{"CodeableConcept"};
                }
                case -1868566105: {
                    return new String[]{"CodeableConcept"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.itemSequence");
            }
            if (name.equals("detailSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.detailSequence");
            }
            if (name.equals("subdetailSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.subdetailSequence");
            }
            if (name.equals("provider")) {
                return this.addProvider();
            }
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("servicedDate")) {
                this.serviced = new DateType();
                return this.serviced;
            }
            if (name.equals("servicedPeriod")) {
                this.serviced = new Period();
                return this.serviced;
            }
            if (name.equals("locationCodeableConcept")) {
                this.location = new CodeableConcept();
                return this.location;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableConcept();
                return this.bodySite;
            }
            if (name.equals("subSite")) {
                return this.addSubSite();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemComponent copy() {
            AddedItemComponent dst = new AddedItemComponent();
            this.copyValues(dst);
            if (this.itemSequence != null) {
                dst.itemSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.itemSequence) {
                    dst.itemSequence.add(positiveIntType.copy());
                }
            }
            if (this.detailSequence != null) {
                dst.detailSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.detailSequence) {
                    dst.detailSequence.add(positiveIntType.copy());
                }
            }
            if (this.subdetailSequence != null) {
                dst.subdetailSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.subdetailSequence) {
                    dst.subdetailSequence.add(positiveIntType.copy());
                }
            }
            if (this.provider != null) {
                dst.provider = new ArrayList<Reference>();
                for (Reference reference : this.provider) {
                    dst.provider.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.serviced = this.serviced == null ? null : this.serviced.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.net = this.net == null ? null : this.net.copy();
            CodeableConcept codeableConcept4 = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            if (this.subSite != null) {
                dst.subSite = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept5 : this.subSite) {
                    dst.subSite.add(codeableConcept5.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<AddedItemDetailComponent>();
                for (AddedItemDetailComponent addedItemDetailComponent : this.detail) {
                    dst.detail.add(addedItemDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other_;
            return AddedItemComponent.compareDeep(this.itemSequence, o.itemSequence, true) && AddedItemComponent.compareDeep(this.detailSequence, o.detailSequence, true) && AddedItemComponent.compareDeep(this.subdetailSequence, o.subdetailSequence, true) && AddedItemComponent.compareDeep(this.provider, o.provider, true) && AddedItemComponent.compareDeep(this.billcode, o.billcode, true) && AddedItemComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemComponent.compareDeep(this.programCode, o.programCode, true) && AddedItemComponent.compareDeep(this.serviced, o.serviced, true) && AddedItemComponent.compareDeep(this.location, o.location, true) && AddedItemComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemComponent.compareDeep(this.factor, o.factor, true) && AddedItemComponent.compareDeep(this.net, o.net, true) && AddedItemComponent.compareDeep(this.bodySite, o.bodySite, true) && AddedItemComponent.compareDeep(this.subSite, o.subSite, true) && AddedItemComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemComponent.compareDeep(this.adjudication, o.adjudication, true) && AddedItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other_;
            return AddedItemComponent.compareValues(this.itemSequence, o.itemSequence, true) && AddedItemComponent.compareValues(this.detailSequence, o.detailSequence, true) && AddedItemComponent.compareValues(this.subdetailSequence, o.subdetailSequence, true) && AddedItemComponent.compareValues(this.factor, o.factor, true) && AddedItemComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.itemSequence, this.detailSequence, this.subdetailSequence, this.provider, this.billcode, this.modifier, this.programCode, this.serviced, this.location, this.quantity, this.unitPrice, this.factor, this.net, this.bodySite, this.subSite, this.noteNumber, this.adjudication, this.detail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem";
        }
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="subDetailSequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType subDetailSequence;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail level adjudication details", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        private static final long serialVersionUID = -1083724362L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(PositiveIntType subDetailSequence) {
            this.subDetailSequence = subDetailSequence;
        }

        public PositiveIntType getSubDetailSequenceElement() {
            if (this.subDetailSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.subDetailSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.subDetailSequence = new PositiveIntType();
                }
            }
            return this.subDetailSequence;
        }

        public boolean hasSubDetailSequenceElement() {
            return this.subDetailSequence != null && !this.subDetailSequence.isEmpty();
        }

        public boolean hasSubDetailSequence() {
            return this.subDetailSequence != null && !this.subDetailSequence.isEmpty();
        }

        public SubDetailComponent setSubDetailSequenceElement(PositiveIntType value) {
            this.subDetailSequence = value;
            return this;
        }

        public int getSubDetailSequence() {
            return this.subDetailSequence == null || this.subDetailSequence.isEmpty() ? 0 : (Integer)this.subDetailSequence.getValue();
        }

        public SubDetailComponent setSubDetailSequence(int value) {
            if (this.subDetailSequence == null) {
                this.subDetailSequence = new PositiveIntType();
            }
            this.subDetailSequence.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public SubDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public SubDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public SubDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public SubDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("subDetailSequence", "positiveInt", "A service line number.", 0, 1, this.subDetailSequence));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -855462510: {
                    return new Property("subDetailSequence", "positiveInt", "A service line number.", 0, 1, this.subDetailSequence);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -855462510: {
                    Base[] baseArray;
                    if (this.subDetailSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.subDetailSequence;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -855462510: {
                    this.subDetailSequence = this.castToPositiveInt(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("subDetailSequence")) {
                this.subDetailSequence = this.castToPositiveInt(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -855462510: {
                    return this.getSubDetailSequenceElement();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -855462510: {
                    return new String[]{"positiveInt"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("subDetailSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.subDetailSequence");
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.subDetailSequence = this.subDetailSequence == null ? null : this.subDetailSequence.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareDeep(this.subDetailSequence, o.subDetailSequence, true) && SubDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && SubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareValues(this.subDetailSequence, o.subDetailSequence, true) && SubDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.subDetailSequence, this.noteNumber, this.adjudication});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail.subDetail";
        }
    }

    @Block
    public static class ItemDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="detailSequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType detailSequence;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail level adjudication details", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail line items", formalDefinition="The third-tier service adjudications for submitted services.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = 1066636111L;

        public ItemDetailComponent() {
        }

        public ItemDetailComponent(PositiveIntType detailSequence) {
            this.detailSequence = detailSequence;
        }

        public PositiveIntType getDetailSequenceElement() {
            if (this.detailSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemDetailComponent.detailSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailSequence = new PositiveIntType();
                }
            }
            return this.detailSequence;
        }

        public boolean hasDetailSequenceElement() {
            return this.detailSequence != null && !this.detailSequence.isEmpty();
        }

        public boolean hasDetailSequence() {
            return this.detailSequence != null && !this.detailSequence.isEmpty();
        }

        public ItemDetailComponent setDetailSequenceElement(PositiveIntType value) {
            this.detailSequence = value;
            return this;
        }

        public int getDetailSequence() {
            return this.detailSequence == null || this.detailSequence.isEmpty() ? 0 : (Integer)this.detailSequence.getValue();
        }

        public ItemDetailComponent setDetailSequence(int value) {
            if (this.detailSequence == null) {
                this.detailSequence = new PositiveIntType();
            }
            this.detailSequence.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public ItemDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public ItemDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public ItemDetailComponent setSubDetail(List<SubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public ItemDetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public SubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("detailSequence", "positiveInt", "A service line number.", 0, 1, this.detailSequence));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("subDetail", "", "The third-tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1321472818: {
                    return new Property("detailSequence", "positiveInt", "A service line number.", 0, 1, this.detailSequence);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -828829007: {
                    return new Property("subDetail", "", "The third-tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1321472818: {
                    Base[] baseArray;
                    if (this.detailSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.detailSequence;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1321472818: {
                    this.detailSequence = this.castToPositiveInt(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((SubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("detailSequence")) {
                this.detailSequence = this.castToPositiveInt(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1321472818: {
                    return this.getDetailSequenceElement();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1321472818: {
                    return new String[]{"positiveInt"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("detailSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.detailSequence");
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemDetailComponent copy() {
            ItemDetailComponent dst = new ItemDetailComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.detailSequence = this.detailSequence == null ? null : this.detailSequence.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent subDetailComponent : this.subDetail) {
                    dst.subDetail.add(subDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemDetailComponent)) {
                return false;
            }
            ItemDetailComponent o = (ItemDetailComponent)other_;
            return ItemDetailComponent.compareDeep(this.detailSequence, o.detailSequence, true) && ItemDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemDetailComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemDetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemDetailComponent)) {
                return false;
            }
            ItemDetailComponent o = (ItemDetailComponent)other_;
            return ItemDetailComponent.compareValues(this.detailSequence, o.detailSequence, true) && ItemDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.detailSequence, this.noteNumber, this.adjudication, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail";
        }
    }

    @Block
    public static class AdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication")
        protected CodeableConcept category;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation of Adjudication outcome", formalDefinition="Adjudication reason such as limit reached.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-reason")
        protected CodeableConcept reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monetary amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Non-monetary value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = 1559898786L;

        public AdjudicationComponent() {
        }

        public AdjudicationComponent(CodeableConcept category) {
            this.category = category;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public AdjudicationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public AdjudicationComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public AdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public AdjudicationComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public AdjudicationComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, 1, this.category));
            children.add(new Property("reason", "CodeableConcept", "Adjudication reason such as limit reached.", 0, 1, this.reason));
            children.add(new Property("amount", "Money", "Monetary amount associated with the code.", 0, 1, this.amount));
            children.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, 1, this.category);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Adjudication reason such as limit reached.", 0, 1, this.reason);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Monetary amount associated with the code.", 0, 1, this.amount);
                }
                case 111972721: {
                    return new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.reason = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
                case 111972721: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.value");
            }
            return super.addChild(name);
        }

        @Override
        public AdjudicationComponent copy() {
            AdjudicationComponent dst = new AdjudicationComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdjudicationComponent)) {
                return false;
            }
            AdjudicationComponent o = (AdjudicationComponent)other_;
            return AdjudicationComponent.compareDeep(this.category, o.category, true) && AdjudicationComponent.compareDeep(this.reason, o.reason, true) && AdjudicationComponent.compareDeep(this.amount, o.amount, true) && AdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdjudicationComponent)) {
                return false;
            }
            AdjudicationComponent o = (AdjudicationComponent)other_;
            return AdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.reason, this.amount, this.value});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.adjudication";
        }
    }

    @Block
    public static class ItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="itemSequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType itemSequence;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication details", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail line items", formalDefinition="The second-tier service adjudications for submitted services.")
        protected List<ItemDetailComponent> detail;
        private static final long serialVersionUID = 701277928L;

        public ItemComponent() {
        }

        public ItemComponent(PositiveIntType itemSequence) {
            this.itemSequence = itemSequence;
        }

        public PositiveIntType getItemSequenceElement() {
            if (this.itemSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.itemSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemSequence = new PositiveIntType();
                }
            }
            return this.itemSequence;
        }

        public boolean hasItemSequenceElement() {
            return this.itemSequence != null && !this.itemSequence.isEmpty();
        }

        public boolean hasItemSequence() {
            return this.itemSequence != null && !this.itemSequence.isEmpty();
        }

        public ItemComponent setItemSequenceElement(PositiveIntType value) {
            this.itemSequence = value;
            return this;
        }

        public int getItemSequence() {
            return this.itemSequence == null || this.itemSequence.isEmpty() ? 0 : (Integer)this.itemSequence.getValue();
        }

        public ItemComponent setItemSequence(int value) {
            if (this.itemSequence == null) {
                this.itemSequence = new PositiveIntType();
            }
            this.itemSequence.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public ItemComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public ItemComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<ItemDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            return this.detail;
        }

        public ItemComponent setDetail(List<ItemDetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (ItemDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ItemDetailComponent addDetail() {
            ItemDetailComponent t = new ItemDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemComponent addDetail(ItemDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public ItemDetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("itemSequence", "positiveInt", "A service line number.", 0, 1, this.itemSequence));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("detail", "", "The second-tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1977979892: {
                    return new Property("itemSequence", "positiveInt", "A service line number.", 0, 1, this.itemSequence);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -1335224239: {
                    return new Property("detail", "", "The second-tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    Base[] baseArray;
                    if (this.itemSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.itemSequence;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    this.itemSequence = this.castToPositiveInt(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((ItemDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.itemSequence = this.castToPositiveInt(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((ItemDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.getItemSequenceElement();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return new String[]{"positiveInt"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[0];
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.itemSequence");
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemComponent copy() {
            ItemComponent dst = new ItemComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.itemSequence = this.itemSequence == null ? null : this.itemSequence.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<ItemDetailComponent>();
                for (ItemDetailComponent itemDetailComponent : this.detail) {
                    dst.detail.add(itemDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareDeep(this.itemSequence, o.itemSequence, true) && ItemComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareValues(this.itemSequence, o.itemSequence, true) && ItemComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.itemSequence, this.noteNumber, this.adjudication, this.detail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item";
        }
    }

    public static class RemittanceOutcomeEnumFactory
    implements EnumFactory<RemittanceOutcome> {
        @Override
        public RemittanceOutcome fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return RemittanceOutcome.QUEUED;
            }
            if ("complete".equals(codeString)) {
                return RemittanceOutcome.COMPLETE;
            }
            if ("error".equals(codeString)) {
                return RemittanceOutcome.ERROR;
            }
            if ("partial".equals(codeString)) {
                return RemittanceOutcome.PARTIAL;
            }
            throw new IllegalArgumentException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        public Enumeration<RemittanceOutcome> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RemittanceOutcome>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.QUEUED);
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.COMPLETE);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.ERROR);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.PARTIAL);
            }
            throw new FHIRException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        @Override
        public String toCode(RemittanceOutcome code) {
            if (code == RemittanceOutcome.QUEUED) {
                return "queued";
            }
            if (code == RemittanceOutcome.COMPLETE) {
                return "complete";
            }
            if (code == RemittanceOutcome.ERROR) {
                return "error";
            }
            if (code == RemittanceOutcome.PARTIAL) {
                return "partial";
            }
            return "?";
        }

        @Override
        public String toSystem(RemittanceOutcome code) {
            return code.getSystem();
        }
    }

    public static enum RemittanceOutcome {
        QUEUED,
        COMPLETE,
        ERROR,
        PARTIAL,
        NULL;


        public static RemittanceOutcome fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return QUEUED;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case QUEUED: {
                    return "queued";
                }
                case COMPLETE: {
                    return "complete";
                }
                case ERROR: {
                    return "error";
                }
                case PARTIAL: {
                    return "partial";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case QUEUED: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
                case COMPLETE: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case QUEUED: {
                    return "The Claim/Pre-authorization/Pre-determination has been received but processing has not begun.";
                }
                case COMPLETE: {
                    return "The processing has completed without errors";
                }
                case ERROR: {
                    return "One or more errors have been detected in the Claim";
                }
                case PARTIAL: {
                    return "No errors have been detected in the Claim and some of the adjudication has been performed.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case QUEUED: {
                    return "Queued";
                }
                case COMPLETE: {
                    return "Processing Complete";
                }
                case ERROR: {
                    return "Error";
                }
                case PARTIAL: {
                    return "Partial Processing";
                }
            }
            return "?";
        }
    }

    public static class UseEnumFactory
    implements EnumFactory<Use> {
        @Override
        public Use fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("claim".equals(codeString)) {
                return Use.CLAIM;
            }
            if ("preauthorization".equals(codeString)) {
                return Use.PREAUTHORIZATION;
            }
            if ("predetermination".equals(codeString)) {
                return Use.PREDETERMINATION;
            }
            throw new IllegalArgumentException("Unknown Use code '" + codeString + "'");
        }

        public Enumeration<Use> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<Use>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("claim".equals(codeString)) {
                return new Enumeration<Use>(this, Use.CLAIM);
            }
            if ("preauthorization".equals(codeString)) {
                return new Enumeration<Use>(this, Use.PREAUTHORIZATION);
            }
            if ("predetermination".equals(codeString)) {
                return new Enumeration<Use>(this, Use.PREDETERMINATION);
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        @Override
        public String toCode(Use code) {
            if (code == Use.CLAIM) {
                return "claim";
            }
            if (code == Use.PREAUTHORIZATION) {
                return "preauthorization";
            }
            if (code == Use.PREDETERMINATION) {
                return "predetermination";
            }
            return "?";
        }

        @Override
        public String toSystem(Use code) {
            return code.getSystem();
        }
    }

    public static enum Use {
        CLAIM,
        PREAUTHORIZATION,
        PREDETERMINATION,
        NULL;


        public static Use fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("claim".equals(codeString)) {
                return CLAIM;
            }
            if ("preauthorization".equals(codeString)) {
                return PREAUTHORIZATION;
            }
            if ("predetermination".equals(codeString)) {
                return PREDETERMINATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CLAIM: {
                    return "claim";
                }
                case PREAUTHORIZATION: {
                    return "preauthorization";
                }
                case PREDETERMINATION: {
                    return "predetermination";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CLAIM: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case PREAUTHORIZATION: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case PREDETERMINATION: {
                    return "http://hl7.org/fhir/claim-use";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CLAIM: {
                    return "The treatment is complete and this represents a Claim for the services.";
                }
                case PREAUTHORIZATION: {
                    return "The treatment is proposed and this represents a Pre-authorization for the services.";
                }
                case PREDETERMINATION: {
                    return "The treatment is proposed and this represents a Pre-determination for the services.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CLAIM: {
                    return "Claim";
                }
                case PREAUTHORIZATION: {
                    return "Preauthorization";
                }
                case PREDETERMINATION: {
                    return "Predetermination";
                }
            }
            return "?";
        }
    }

    public static class ClaimResponseStatusEnumFactory
    implements EnumFactory<ClaimResponseStatus> {
        @Override
        public ClaimResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ClaimResponseStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return ClaimResponseStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return ClaimResponseStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ClaimResponseStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ClaimResponseStatus code '" + codeString + "'");
        }

        public Enumeration<ClaimResponseStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ClaimResponseStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ClaimResponseStatus>(this, ClaimResponseStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ClaimResponseStatus>(this, ClaimResponseStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ClaimResponseStatus>(this, ClaimResponseStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ClaimResponseStatus>(this, ClaimResponseStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ClaimResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ClaimResponseStatus code) {
            if (code == ClaimResponseStatus.ACTIVE) {
                return "active";
            }
            if (code == ClaimResponseStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ClaimResponseStatus.DRAFT) {
                return "draft";
            }
            if (code == ClaimResponseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ClaimResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum ClaimResponseStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static ClaimResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ClaimResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

