/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

public abstract class Element
extends Base
implements IBaseHasExtensions,
IBaseElement {
    @Child(name="id", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="xml:id (or equivalent in JSON)", formalDefinition="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.")
    protected StringType id;
    @Child(name="extension", type={Extension.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional content defined by implementations", formalDefinition="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.")
    protected List<Extension> extension;
    private static final long serialVersionUID = -1452745816L;
    private boolean disallowExtensions;

    public StringType getIdElement() {
        if (this.id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Element.id");
            }
            if (Configuration.doAutoCreate()) {
                this.id = new StringType();
            }
        }
        return this.id;
    }

    public boolean hasIdElement() {
        return this.id != null && !this.id.isEmpty();
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    public Element setIdElement(StringType value) {
        this.id = value;
        return this;
    }

    public String getId() {
        return this.id == null ? null : (String)this.id.getValue();
    }

    public Element setId(String value) {
        if (Utilities.noString((String)value)) {
            this.id = null;
        } else {
            if (this.id == null) {
                this.id = new StringType();
            }
            this.id.setValue(value);
        }
        return this;
    }

    public List<Extension> getExtension() {
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        return this.extension;
    }

    public Element setExtension(List<Extension> theExtension) {
        this.extension = theExtension;
        return this;
    }

    public boolean hasExtension() {
        if (this.extension == null) {
            return false;
        }
        for (Extension item : this.extension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addExtension() {
        Extension t = new Extension();
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        this.extension.add(t);
        return t;
    }

    public Element addExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        this.extension.add(t);
        return this;
    }

    public Extension getExtensionFirstRep() {
        if (this.getExtension().isEmpty()) {
            this.addExtension();
        }
        return this.getExtension().get(0);
    }

    public List<Extension> getExtensionsByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must not be blank or null", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    public boolean hasExtension(String theUrl) {
        return !this.getExtensionsByUrl(theUrl).isEmpty();
    }

    public String getExtensionString(String theUrl) throws FHIRException {
        List<Extension> ext = this.getExtensionsByUrl(theUrl);
        if (ext.isEmpty()) {
            return null;
        }
        if (ext.size() > 1) {
            throw new FHIRException("Multiple matching extensions found");
        }
        if (!ext.get(0).getValue().isPrimitive()) {
            throw new FHIRException("Extension could not be converted to a string");
        }
        return ext.get(0).getValue().primitiveValue();
    }

    @Override
    protected void listChildren(List<Property> children) {
        children.add(new Property("id", "string", "Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.", 0, 1, this.id));
        children.add(new Property("extension", "Extension", "May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.", 0, Integer.MAX_VALUE, this.extension));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3355: {
                return new Property("id", "string", "Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.", 0, 1, this.id);
            }
            case -612557761: {
                return new Property("extension", "Extension", "May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.", 0, Integer.MAX_VALUE, this.extension);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3355: {
                Base[] baseArray;
                if (this.id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.id;
                }
                return baseArray;
            }
            case -612557761: {
                return this.extension == null ? new Base[]{} : this.extension.toArray(new Base[this.extension.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3355: {
                this.id = this.castToString(value);
                return value;
            }
            case -612557761: {
                this.getExtension().add(this.castToExtension(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("id")) {
            this.id = this.castToString(value);
        } else if (name.equals("extension")) {
            this.getExtension().add(this.castToExtension(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3355: {
                return this.getIdElement();
            }
            case -612557761: {
                return this.addExtension();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3355: {
                return new String[]{"string"};
            }
            case -612557761: {
                return new String[]{"Extension"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("id")) {
            throw new FHIRException("Cannot call addChild on a primitive type Element.id");
        }
        if (name.equals("extension")) {
            return this.addExtension();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Element";
    }

    public abstract Element copy();

    public void copyValues(Element dst) {
        StringType stringType = dst.id = this.id == null ? null : this.id.copy();
        if (this.extension != null) {
            dst.extension = new ArrayList<Extension>();
            for (Extension i : this.extension) {
                dst.extension.add(i.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Element)) {
            return false;
        }
        Element o = (Element)other_;
        return Element.compareDeep(this.id, o.id, true) && Element.compareDeep(this.extension, o.extension, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Element)) {
            return false;
        }
        Element o = (Element)other_;
        return Element.compareValues(this.id, o.id, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.id, this.extension});
    }

    @Override
    public String getIdBase() {
        return this.getId();
    }

    @Override
    public void setIdBase(String value) {
        this.setId(value);
    }

    public void addExtension(String url, Type value) {
        if (this.disallowExtensions) {
            throw new Error("Extensions are not allowed in this context");
        }
        Extension ex = new Extension();
        ex.setUrl(url);
        ex.setValue(value);
        this.getExtension().add(ex);
    }

    public Extension getExtensionByUrl(String theUrl) {
        Validate.notBlank((CharSequence)theUrl, (String)"theUrl must not be blank or null", (Object[])new Object[0]);
        ArrayList<Extension> retVal = new ArrayList<Extension>();
        for (Extension next : this.getExtension()) {
            if (!theUrl.equals(next.getUrl())) continue;
            retVal.add(next);
        }
        if (retVal.size() == 0) {
            return null;
        }
        Validate.isTrue((retVal.size() == 1 ? 1 : 0) != 0, (String)("Url " + theUrl + " must have only one match"), (Object[])new Object[0]);
        return (Extension)retVal.get(0);
    }

    public void removeExtension(String theUrl) {
        for (int i = this.getExtension().size() - 1; i >= 0; --i) {
            if (!theUrl.equals(this.getExtension().get(i).getUrl())) continue;
            this.getExtension().remove(i);
        }
    }

    public boolean isDisallowExtensions() {
        return this.disallowExtensions;
    }

    public Element setDisallowExtensions(boolean disallowExtensions) {
        this.disallowExtensions = disallowExtensions;
        return this;
    }

    public Element noExtensions() {
        this.disallowExtensions = true;
        return this;
    }
}

