/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.ClaimResponse;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ExplanationOfBenefit", profile="http://hl7.org/fhir/StructureDefinition/ExplanationOfBenefit")
public class ExplanationOfBenefit
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier", formalDefinition="The EOB Business Identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/explanationofbenefit-status")
    protected Enumeration<ExplanationOfBenefitStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type or discipline", formalDefinition="The category of claim, e.g, oral, pharmacy, vision, institutional, professional.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-type")
    protected CodeableConcept type;
    @Child(name="subType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Finer grained claim type information", formalDefinition="A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the CMS Bill Type.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-subtype")
    protected CodeableConcept subType;
    @Child(name="use", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="claim | preauthorization | predetermination", formalDefinition="A claim, a list of completed goods and services; a preauthorization, a list or proposed goods and services; or a predetermination, a set of goods and services being considered, for which insurer adjudication is sought.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-use")
    protected Enumeration<Use> use;
    @Child(name="patient", type={Patient.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The subject of the Products and Services", formalDefinition="Patient Resource.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="billablePeriod", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period for charge submission", formalDefinition="The billable period for which charges are being submitted.")
    protected Period billablePeriod;
    @Child(name="created", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="enterer", type={Practitioner.class, PractitionerRole.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Author", formalDefinition="The person who created the explanation of benefit.")
    protected Reference enterer;
    protected Resource entererTarget;
    @Child(name="insurer", type={Organization.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer responsible for the EOB", formalDefinition="The insurer which is responsible for the explanation of benefit.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible provider for the claim", formalDefinition="The provider which is responsible for the claim.")
    protected Reference provider;
    protected Resource providerTarget;
    @Child(name="referral", type={ServiceRequest.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Treatment Referral", formalDefinition="The referral resource which lists the date, practitioner, reason and other supporting information.")
    protected Reference referral;
    protected ServiceRequest referralTarget;
    @Child(name="facility", type={Location.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Servicing Facility", formalDefinition="Facility where the services were provided.")
    protected Reference facility;
    protected Location facilityTarget;
    @Child(name="claim", type={Claim.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Claim reference", formalDefinition="The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.")
    protected Reference claim;
    protected Claim claimTarget;
    @Child(name="claimResponse", type={ClaimResponse.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Claim response reference", formalDefinition="The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.")
    protected Reference claimResponse;
    protected ClaimResponse claimResponseTarget;
    @Child(name="outcome", type={CodeType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="queued | complete | error | partial", formalDefinition="Processing outcome errror, partial or complete processing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome")
    protected Enumeration<RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="related", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Related Claims which may be revelant to processing this claim", formalDefinition="Other claims which are related to this claim such as prior claim versions or for related services.")
    protected List<RelatedClaimComponent> related;
    @Child(name="prescription", type={MedicationRequest.class, VisionPrescription.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Prescription authorizing services or products", formalDefinition="Prescription to support the dispensing of Pharmacy or Vision products.")
    protected Reference prescription;
    protected Resource prescriptionTarget;
    @Child(name="originalPrescription", type={MedicationRequest.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Original prescription if superceded by fulfiller", formalDefinition="Original prescription which has been superceded by this prescription to support the dispensing of pharmacy services, medications or products. For example, a physician may prescribe a medication which the pharmacy determines is contraindicated, or for which the patient has an intolerance, and therefor issues a new precription for an alternate medication which has the same theraputic intent. The prescription from the pharmacy becomes the 'prescription' and that from the physician becomes the 'original prescription'.")
    protected Reference originalPrescription;
    protected MedicationRequest originalPrescriptionTarget;
    @Child(name="payee", type={}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party to be paid any benefits payable", formalDefinition="The party to be reimbursed for the services.")
    protected PayeeComponent payee;
    @Child(name="information", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Exceptions, special considerations, the condition, situation, prior or concurrent issues", formalDefinition="Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues. Often there are mutiple jurisdiction specific valuesets which are required.")
    protected List<SupportingInformationComponent> information;
    @Child(name="careTeam", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Care Team members", formalDefinition="The members of the team who provided the overall service as well as their role and whether responsible and qualifications.")
    protected List<CareTeamComponent> careTeam;
    @Child(name="diagnosis", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of Diagnosis", formalDefinition="Ordered list of patient diagnosis for which care is sought.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="procedure", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Procedures performed", formalDefinition="Ordered list of patient procedures performed to support the adjudication.")
    protected List<ProcedureComponent> procedure;
    @Child(name="precedence", type={PositiveIntType.class}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Precedence (primary, secondary, etc.)", formalDefinition="Precedence (primary, secondary, etc.).")
    protected PositiveIntType precedence;
    @Child(name="insurance", type={}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected List<InsuranceComponent> insurance;
    @Child(name="accident", type={}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details of an accident", formalDefinition="An accident which resulted in the need for healthcare services.")
    protected AccidentComponent accident;
    @Child(name="item", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Goods and Services", formalDefinition="First-tier of goods and services.")
    protected List<ItemComponent> item;
    @Child(name="addItem", type={}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer added line items", formalDefinition="The first-tier service adjudications for payor added services.")
    protected List<AddedItemComponent> addItem;
    @Child(name="total", type={}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Adjudication totals", formalDefinition="Totals for amounts submitted, co-pays, benefits payable etc.")
    protected List<TotalComponent> total;
    @Child(name="payment", type={}, order=31, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment Details", formalDefinition="Payment details for the claim if the claim has been paid.")
    protected PaymentComponent payment;
    @Child(name="form", type={CodeableConcept.class}, order=32, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept form;
    @Child(name="processNote", type={}, order=33, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing notes", formalDefinition="Note text.")
    protected List<NoteComponent> processNote;
    @Child(name="benefitBalance", type={}, order=34, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Balance by Benefit Category", formalDefinition="Balance by Benefit Category.")
    protected List<BenefitBalanceComponent> benefitBalance;
    private static final long serialVersionUID = 459572084L;
    @SearchParamDefinition(name="coverage", path="ExplanationOfBenefit.insurance.coverage", description="The plan under which the claim was adjudicated", type="reference", target={Coverage.class})
    public static final String SP_COVERAGE = "coverage";
    public static final ReferenceClientParam COVERAGE = new ReferenceClientParam("coverage");
    public static final Include INCLUDE_COVERAGE = new Include("ExplanationOfBenefit:coverage").toLocked();
    @SearchParamDefinition(name="care-team", path="ExplanationOfBenefit.careTeam.provider", description="Member of the CareTeam", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_CARE_TEAM = "care-team";
    public static final ReferenceClientParam CARE_TEAM = new ReferenceClientParam("care-team");
    public static final Include INCLUDE_CARE_TEAM = new Include("ExplanationOfBenefit:care-team").toLocked();
    @SearchParamDefinition(name="identifier", path="ExplanationOfBenefit.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="created", path="ExplanationOfBenefit.created", description="The creation date for the EOB", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="encounter", path="ExplanationOfBenefit.item.encounter", description="Encounters associated with a billed line item", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ExplanationOfBenefit:encounter").toLocked();
    @SearchParamDefinition(name="payee", path="ExplanationOfBenefit.payee.party", description="The party receiving any payment for the Claim", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PAYEE = "payee";
    public static final ReferenceClientParam PAYEE = new ReferenceClientParam("payee");
    public static final Include INCLUDE_PAYEE = new Include("ExplanationOfBenefit:payee").toLocked();
    @SearchParamDefinition(name="disposition", path="ExplanationOfBenefit.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="provider", path="ExplanationOfBenefit.provider", description="The reference to the provider", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("ExplanationOfBenefit:provider").toLocked();
    @SearchParamDefinition(name="patient", path="ExplanationOfBenefit.patient", description="The reference to the patient", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ExplanationOfBenefit:patient").toLocked();
    @SearchParamDefinition(name="claim", path="ExplanationOfBenefit.claim", description="The reference to the claim", type="reference", target={Claim.class})
    public static final String SP_CLAIM = "claim";
    public static final ReferenceClientParam CLAIM = new ReferenceClientParam("claim");
    public static final Include INCLUDE_CLAIM = new Include("ExplanationOfBenefit:claim").toLocked();
    @SearchParamDefinition(name="enterer", path="ExplanationOfBenefit.enterer", description="The party responsible for the entry of the Claim", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("ExplanationOfBenefit:enterer").toLocked();
    @SearchParamDefinition(name="facility", path="ExplanationOfBenefit.facility", description="Facility responsible for the goods and services", type="reference", target={Location.class})
    public static final String SP_FACILITY = "facility";
    public static final ReferenceClientParam FACILITY = new ReferenceClientParam("facility");
    public static final Include INCLUDE_FACILITY = new Include("ExplanationOfBenefit:facility").toLocked();
    @SearchParamDefinition(name="status", path="ExplanationOfBenefit.status", description="Status of the instance", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ExplanationOfBenefit setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ExplanationOfBenefit addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ExplanationOfBenefitStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ExplanationOfBenefitStatus>(new ExplanationOfBenefitStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ExplanationOfBenefit setStatusElement(Enumeration<ExplanationOfBenefitStatus> value) {
        this.status = value;
        return this;
    }

    public ExplanationOfBenefitStatus getStatus() {
        return this.status == null ? null : (ExplanationOfBenefitStatus)((Object)this.status.getValue());
    }

    public ExplanationOfBenefit setStatus(ExplanationOfBenefitStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<ExplanationOfBenefitStatus>(new ExplanationOfBenefitStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ExplanationOfBenefit setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getSubType() {
        if (this.subType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.subType");
            }
            if (Configuration.doAutoCreate()) {
                this.subType = new CodeableConcept();
            }
        }
        return this.subType;
    }

    public boolean hasSubType() {
        return this.subType != null && !this.subType.isEmpty();
    }

    public ExplanationOfBenefit setSubType(CodeableConcept value) {
        this.subType = value;
        return this;
    }

    public Enumeration<Use> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public ExplanationOfBenefit setUseElement(Enumeration<Use> value) {
        this.use = value;
        return this;
    }

    public Use getUse() {
        return this.use == null ? null : (Use)((Object)this.use.getValue());
    }

    public ExplanationOfBenefit setUse(Use value) {
        if (value == null) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
            this.use.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ExplanationOfBenefit setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ExplanationOfBenefit setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Period getBillablePeriod() {
        if (this.billablePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.billablePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.billablePeriod = new Period();
            }
        }
        return this.billablePeriod;
    }

    public boolean hasBillablePeriod() {
        return this.billablePeriod != null && !this.billablePeriod.isEmpty();
    }

    public ExplanationOfBenefit setBillablePeriod(Period value) {
        this.billablePeriod = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ExplanationOfBenefit setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ExplanationOfBenefit setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public ExplanationOfBenefit setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Resource getEntererTarget() {
        return this.entererTarget;
    }

    public ExplanationOfBenefit setEntererTarget(Resource value) {
        this.entererTarget = value;
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public ExplanationOfBenefit setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public ExplanationOfBenefit setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public ExplanationOfBenefit setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Resource getProviderTarget() {
        return this.providerTarget;
    }

    public ExplanationOfBenefit setProviderTarget(Resource value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getReferral() {
        if (this.referral == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.referral");
            }
            if (Configuration.doAutoCreate()) {
                this.referral = new Reference();
            }
        }
        return this.referral;
    }

    public boolean hasReferral() {
        return this.referral != null && !this.referral.isEmpty();
    }

    public ExplanationOfBenefit setReferral(Reference value) {
        this.referral = value;
        return this;
    }

    public ServiceRequest getReferralTarget() {
        if (this.referralTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.referral");
            }
            if (Configuration.doAutoCreate()) {
                this.referralTarget = new ServiceRequest();
            }
        }
        return this.referralTarget;
    }

    public ExplanationOfBenefit setReferralTarget(ServiceRequest value) {
        this.referralTarget = value;
        return this;
    }

    public Reference getFacility() {
        if (this.facility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facility = new Reference();
            }
        }
        return this.facility;
    }

    public boolean hasFacility() {
        return this.facility != null && !this.facility.isEmpty();
    }

    public ExplanationOfBenefit setFacility(Reference value) {
        this.facility = value;
        return this;
    }

    public Location getFacilityTarget() {
        if (this.facilityTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facilityTarget = new Location();
            }
        }
        return this.facilityTarget;
    }

    public ExplanationOfBenefit setFacilityTarget(Location value) {
        this.facilityTarget = value;
        return this;
    }

    public Reference getClaim() {
        if (this.claim == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.claim");
            }
            if (Configuration.doAutoCreate()) {
                this.claim = new Reference();
            }
        }
        return this.claim;
    }

    public boolean hasClaim() {
        return this.claim != null && !this.claim.isEmpty();
    }

    public ExplanationOfBenefit setClaim(Reference value) {
        this.claim = value;
        return this;
    }

    public Claim getClaimTarget() {
        if (this.claimTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.claim");
            }
            if (Configuration.doAutoCreate()) {
                this.claimTarget = new Claim();
            }
        }
        return this.claimTarget;
    }

    public ExplanationOfBenefit setClaimTarget(Claim value) {
        this.claimTarget = value;
        return this;
    }

    public Reference getClaimResponse() {
        if (this.claimResponse == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.claimResponse");
            }
            if (Configuration.doAutoCreate()) {
                this.claimResponse = new Reference();
            }
        }
        return this.claimResponse;
    }

    public boolean hasClaimResponse() {
        return this.claimResponse != null && !this.claimResponse.isEmpty();
    }

    public ExplanationOfBenefit setClaimResponse(Reference value) {
        this.claimResponse = value;
        return this;
    }

    public ClaimResponse getClaimResponseTarget() {
        if (this.claimResponseTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.claimResponse");
            }
            if (Configuration.doAutoCreate()) {
                this.claimResponseTarget = new ClaimResponse();
            }
        }
        return this.claimResponseTarget;
    }

    public ExplanationOfBenefit setClaimResponseTarget(ClaimResponse value) {
        this.claimResponseTarget = value;
        return this;
    }

    public Enumeration<RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<RemittanceOutcome>(new RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public ExplanationOfBenefit setOutcomeElement(Enumeration<RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public ExplanationOfBenefit setOutcome(RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<RemittanceOutcome>(new RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ExplanationOfBenefit setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public ExplanationOfBenefit setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public List<RelatedClaimComponent> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        return this.related;
    }

    public ExplanationOfBenefit setRelated(List<RelatedClaimComponent> theRelated) {
        this.related = theRelated;
        return this;
    }

    public boolean hasRelated() {
        if (this.related == null) {
            return false;
        }
        for (RelatedClaimComponent item : this.related) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedClaimComponent addRelated() {
        RelatedClaimComponent t = new RelatedClaimComponent();
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        this.related.add(t);
        return t;
    }

    public ExplanationOfBenefit addRelated(RelatedClaimComponent t) {
        if (t == null) {
            return this;
        }
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        this.related.add(t);
        return this;
    }

    public RelatedClaimComponent getRelatedFirstRep() {
        if (this.getRelated().isEmpty()) {
            this.addRelated();
        }
        return this.getRelated().get(0);
    }

    public Reference getPrescription() {
        if (this.prescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.prescription");
            }
            if (Configuration.doAutoCreate()) {
                this.prescription = new Reference();
            }
        }
        return this.prescription;
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public ExplanationOfBenefit setPrescription(Reference value) {
        this.prescription = value;
        return this;
    }

    public Resource getPrescriptionTarget() {
        return this.prescriptionTarget;
    }

    public ExplanationOfBenefit setPrescriptionTarget(Resource value) {
        this.prescriptionTarget = value;
        return this;
    }

    public Reference getOriginalPrescription() {
        if (this.originalPrescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.originalPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.originalPrescription = new Reference();
            }
        }
        return this.originalPrescription;
    }

    public boolean hasOriginalPrescription() {
        return this.originalPrescription != null && !this.originalPrescription.isEmpty();
    }

    public ExplanationOfBenefit setOriginalPrescription(Reference value) {
        this.originalPrescription = value;
        return this;
    }

    public MedicationRequest getOriginalPrescriptionTarget() {
        if (this.originalPrescriptionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.originalPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.originalPrescriptionTarget = new MedicationRequest();
            }
        }
        return this.originalPrescriptionTarget;
    }

    public ExplanationOfBenefit setOriginalPrescriptionTarget(MedicationRequest value) {
        this.originalPrescriptionTarget = value;
        return this;
    }

    public PayeeComponent getPayee() {
        if (this.payee == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.payee");
            }
            if (Configuration.doAutoCreate()) {
                this.payee = new PayeeComponent();
            }
        }
        return this.payee;
    }

    public boolean hasPayee() {
        return this.payee != null && !this.payee.isEmpty();
    }

    public ExplanationOfBenefit setPayee(PayeeComponent value) {
        this.payee = value;
        return this;
    }

    public List<SupportingInformationComponent> getInformation() {
        if (this.information == null) {
            this.information = new ArrayList<SupportingInformationComponent>();
        }
        return this.information;
    }

    public ExplanationOfBenefit setInformation(List<SupportingInformationComponent> theInformation) {
        this.information = theInformation;
        return this;
    }

    public boolean hasInformation() {
        if (this.information == null) {
            return false;
        }
        for (SupportingInformationComponent item : this.information) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SupportingInformationComponent addInformation() {
        SupportingInformationComponent t = new SupportingInformationComponent();
        if (this.information == null) {
            this.information = new ArrayList<SupportingInformationComponent>();
        }
        this.information.add(t);
        return t;
    }

    public ExplanationOfBenefit addInformation(SupportingInformationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.information == null) {
            this.information = new ArrayList<SupportingInformationComponent>();
        }
        this.information.add(t);
        return this;
    }

    public SupportingInformationComponent getInformationFirstRep() {
        if (this.getInformation().isEmpty()) {
            this.addInformation();
        }
        return this.getInformation().get(0);
    }

    public List<CareTeamComponent> getCareTeam() {
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        return this.careTeam;
    }

    public ExplanationOfBenefit setCareTeam(List<CareTeamComponent> theCareTeam) {
        this.careTeam = theCareTeam;
        return this;
    }

    public boolean hasCareTeam() {
        if (this.careTeam == null) {
            return false;
        }
        for (CareTeamComponent item : this.careTeam) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CareTeamComponent addCareTeam() {
        CareTeamComponent t = new CareTeamComponent();
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        this.careTeam.add(t);
        return t;
    }

    public ExplanationOfBenefit addCareTeam(CareTeamComponent t) {
        if (t == null) {
            return this;
        }
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        this.careTeam.add(t);
        return this;
    }

    public CareTeamComponent getCareTeamFirstRep() {
        if (this.getCareTeam().isEmpty()) {
            this.addCareTeam();
        }
        return this.getCareTeam().get(0);
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public ExplanationOfBenefit setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public ExplanationOfBenefit addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public DiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public List<ProcedureComponent> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        return this.procedure;
    }

    public ExplanationOfBenefit setProcedure(List<ProcedureComponent> theProcedure) {
        this.procedure = theProcedure;
        return this;
    }

    public boolean hasProcedure() {
        if (this.procedure == null) {
            return false;
        }
        for (ProcedureComponent item : this.procedure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedureComponent addProcedure() {
        ProcedureComponent t = new ProcedureComponent();
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        this.procedure.add(t);
        return t;
    }

    public ExplanationOfBenefit addProcedure(ProcedureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        this.procedure.add(t);
        return this;
    }

    public ProcedureComponent getProcedureFirstRep() {
        if (this.getProcedure().isEmpty()) {
            this.addProcedure();
        }
        return this.getProcedure().get(0);
    }

    public PositiveIntType getPrecedenceElement() {
        if (this.precedence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.precedence");
            }
            if (Configuration.doAutoCreate()) {
                this.precedence = new PositiveIntType();
            }
        }
        return this.precedence;
    }

    public boolean hasPrecedenceElement() {
        return this.precedence != null && !this.precedence.isEmpty();
    }

    public boolean hasPrecedence() {
        return this.precedence != null && !this.precedence.isEmpty();
    }

    public ExplanationOfBenefit setPrecedenceElement(PositiveIntType value) {
        this.precedence = value;
        return this;
    }

    public int getPrecedence() {
        return this.precedence == null || this.precedence.isEmpty() ? 0 : (Integer)this.precedence.getValue();
    }

    public ExplanationOfBenefit setPrecedence(int value) {
        if (this.precedence == null) {
            this.precedence = new PositiveIntType();
        }
        this.precedence.setValue((Object)value);
        return this;
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public ExplanationOfBenefit setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public ExplanationOfBenefit addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public AccidentComponent getAccident() {
        if (this.accident == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.accident");
            }
            if (Configuration.doAutoCreate()) {
                this.accident = new AccidentComponent();
            }
        }
        return this.accident;
    }

    public boolean hasAccident() {
        return this.accident != null && !this.accident.isEmpty();
    }

    public ExplanationOfBenefit setAccident(AccidentComponent value) {
        this.accident = value;
        return this;
    }

    public List<ItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        return this.item;
    }

    public ExplanationOfBenefit setItem(List<ItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemComponent addItem() {
        ItemComponent t = new ItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public ExplanationOfBenefit addItem(ItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public ItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    public List<AddedItemComponent> getAddItem() {
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        return this.addItem;
    }

    public ExplanationOfBenefit setAddItem(List<AddedItemComponent> theAddItem) {
        this.addItem = theAddItem;
        return this;
    }

    public boolean hasAddItem() {
        if (this.addItem == null) {
            return false;
        }
        for (AddedItemComponent item : this.addItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AddedItemComponent addAddItem() {
        AddedItemComponent t = new AddedItemComponent();
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return t;
    }

    public ExplanationOfBenefit addAddItem(AddedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return this;
    }

    public AddedItemComponent getAddItemFirstRep() {
        if (this.getAddItem().isEmpty()) {
            this.addAddItem();
        }
        return this.getAddItem().get(0);
    }

    public List<TotalComponent> getTotal() {
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        return this.total;
    }

    public ExplanationOfBenefit setTotal(List<TotalComponent> theTotal) {
        this.total = theTotal;
        return this;
    }

    public boolean hasTotal() {
        if (this.total == null) {
            return false;
        }
        for (TotalComponent item : this.total) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TotalComponent addTotal() {
        TotalComponent t = new TotalComponent();
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        this.total.add(t);
        return t;
    }

    public ExplanationOfBenefit addTotal(TotalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        this.total.add(t);
        return this;
    }

    public TotalComponent getTotalFirstRep() {
        if (this.getTotal().isEmpty()) {
            this.addTotal();
        }
        return this.getTotal().get(0);
    }

    public PaymentComponent getPayment() {
        if (this.payment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.payment");
            }
            if (Configuration.doAutoCreate()) {
                this.payment = new PaymentComponent();
            }
        }
        return this.payment;
    }

    public boolean hasPayment() {
        return this.payment != null && !this.payment.isEmpty();
    }

    public ExplanationOfBenefit setPayment(PaymentComponent value) {
        this.payment = value;
        return this;
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ExplanationOfBenefit.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public ExplanationOfBenefit setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public List<NoteComponent> getProcessNote() {
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        return this.processNote;
    }

    public ExplanationOfBenefit setProcessNote(List<NoteComponent> theProcessNote) {
        this.processNote = theProcessNote;
        return this;
    }

    public boolean hasProcessNote() {
        if (this.processNote == null) {
            return false;
        }
        for (NoteComponent item : this.processNote) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NoteComponent addProcessNote() {
        NoteComponent t = new NoteComponent();
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        this.processNote.add(t);
        return t;
    }

    public ExplanationOfBenefit addProcessNote(NoteComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        this.processNote.add(t);
        return this;
    }

    public NoteComponent getProcessNoteFirstRep() {
        if (this.getProcessNote().isEmpty()) {
            this.addProcessNote();
        }
        return this.getProcessNote().get(0);
    }

    public List<BenefitBalanceComponent> getBenefitBalance() {
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitBalanceComponent>();
        }
        return this.benefitBalance;
    }

    public ExplanationOfBenefit setBenefitBalance(List<BenefitBalanceComponent> theBenefitBalance) {
        this.benefitBalance = theBenefitBalance;
        return this;
    }

    public boolean hasBenefitBalance() {
        if (this.benefitBalance == null) {
            return false;
        }
        for (BenefitBalanceComponent item : this.benefitBalance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BenefitBalanceComponent addBenefitBalance() {
        BenefitBalanceComponent t = new BenefitBalanceComponent();
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitBalanceComponent>();
        }
        this.benefitBalance.add(t);
        return t;
    }

    public ExplanationOfBenefit addBenefitBalance(BenefitBalanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<BenefitBalanceComponent>();
        }
        this.benefitBalance.add(t);
        return this;
    }

    public BenefitBalanceComponent getBenefitBalanceFirstRep() {
        if (this.getBenefitBalance().isEmpty()) {
            this.addBenefitBalance();
        }
        return this.getBenefitBalance().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The EOB Business Identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("type", "CodeableConcept", "The category of claim, e.g, oral, pharmacy, vision, institutional, professional.", 0, 1, this.type));
        children.add(new Property("subType", "CodeableConcept", "A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the CMS Bill Type.", 0, 1, this.subType));
        children.add(new Property("use", "code", "A claim, a list of completed goods and services; a preauthorization, a list or proposed goods and services; or a predetermination, a set of goods and services being considered, for which insurer adjudication is sought.", 0, 1, this.use));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, 1, this.patient));
        children.add(new Property("billablePeriod", "Period", "The billable period for which charges are being submitted.", 0, 1, this.billablePeriod));
        children.add(new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created));
        children.add(new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole)", "The person who created the explanation of benefit.", 0, 1, this.enterer));
        children.add(new Property("insurer", "Reference(Organization)", "The insurer which is responsible for the explanation of benefit.", 0, 1, this.insurer));
        children.add(new Property(SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the claim.", 0, 1, this.provider));
        children.add(new Property("referral", "Reference(ServiceRequest)", "The referral resource which lists the date, practitioner, reason and other supporting information.", 0, 1, this.referral));
        children.add(new Property(SP_FACILITY, "Reference(Location)", "Facility where the services were provided.", 0, 1, this.facility));
        children.add(new Property(SP_CLAIM, "Reference(Claim)", "The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.", 0, 1, this.claim));
        children.add(new Property("claimResponse", "Reference(ClaimResponse)", "The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.", 0, 1, this.claimResponse));
        children.add(new Property("outcome", "code", "Processing outcome errror, partial or complete processing.", 0, 1, this.outcome));
        children.add(new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, 1, this.disposition));
        children.add(new Property("related", "", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, Integer.MAX_VALUE, this.related));
        children.add(new Property("prescription", "Reference(MedicationRequest|VisionPrescription)", "Prescription to support the dispensing of Pharmacy or Vision products.", 0, 1, this.prescription));
        children.add(new Property("originalPrescription", "Reference(MedicationRequest)", "Original prescription which has been superceded by this prescription to support the dispensing of pharmacy services, medications or products. For example, a physician may prescribe a medication which the pharmacy determines is contraindicated, or for which the patient has an intolerance, and therefor issues a new precription for an alternate medication which has the same theraputic intent. The prescription from the pharmacy becomes the 'prescription' and that from the physician becomes the 'original prescription'.", 0, 1, this.originalPrescription));
        children.add(new Property(SP_PAYEE, "", "The party to be reimbursed for the services.", 0, 1, this.payee));
        children.add(new Property("information", "", "Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues. Often there are mutiple jurisdiction specific valuesets which are required.", 0, Integer.MAX_VALUE, this.information));
        children.add(new Property("careTeam", "", "The members of the team who provided the overall service as well as their role and whether responsible and qualifications.", 0, Integer.MAX_VALUE, this.careTeam));
        children.add(new Property("diagnosis", "", "Ordered list of patient diagnosis for which care is sought.", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property("procedure", "", "Ordered list of patient procedures performed to support the adjudication.", 0, Integer.MAX_VALUE, this.procedure));
        children.add(new Property("precedence", "positiveInt", "Precedence (primary, secondary, etc.).", 0, 1, this.precedence));
        children.add(new Property("insurance", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("accident", "", "An accident which resulted in the need for healthcare services.", 0, 1, this.accident));
        children.add(new Property("item", "", "First-tier of goods and services.", 0, Integer.MAX_VALUE, this.item));
        children.add(new Property("addItem", "", "The first-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.addItem));
        children.add(new Property("total", "", "Totals for amounts submitted, co-pays, benefits payable etc.", 0, Integer.MAX_VALUE, this.total));
        children.add(new Property("payment", "", "Payment details for the claim if the claim has been paid.", 0, 1, this.payment));
        children.add(new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form));
        children.add(new Property("processNote", "", "Note text.", 0, Integer.MAX_VALUE, this.processNote));
        children.add(new Property("benefitBalance", "", "Balance by Benefit Category.", 0, Integer.MAX_VALUE, this.benefitBalance));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The EOB Business Identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The category of claim, e.g, oral, pharmacy, vision, institutional, professional.", 0, 1, this.type);
            }
            case -1868521062: {
                return new Property("subType", "CodeableConcept", "A finer grained suite of claim subtype codes which may convey Inpatient vs Outpatient and/or a specialty service. In the US the CMS Bill Type.", 0, 1, this.subType);
            }
            case 116103: {
                return new Property("use", "code", "A claim, a list of completed goods and services; a preauthorization, a list or proposed goods and services; or a predetermination, a set of goods and services being considered, for which insurer adjudication is sought.", 0, 1, this.use);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "Patient Resource.", 0, 1, this.patient);
            }
            case -332066046: {
                return new Property("billablePeriod", "Period", "The billable period for which charges are being submitted.", 0, 1, this.billablePeriod);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, 1, this.created);
            }
            case -1591951995: {
                return new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole)", "The person who created the explanation of benefit.", 0, 1, this.enterer);
            }
            case 1957615864: {
                return new Property("insurer", "Reference(Organization)", "The insurer which is responsible for the explanation of benefit.", 0, 1, this.insurer);
            }
            case -987494927: {
                return new Property(SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the claim.", 0, 1, this.provider);
            }
            case -722568291: {
                return new Property("referral", "Reference(ServiceRequest)", "The referral resource which lists the date, practitioner, reason and other supporting information.", 0, 1, this.referral);
            }
            case 501116579: {
                return new Property(SP_FACILITY, "Reference(Location)", "Facility where the services were provided.", 0, 1, this.facility);
            }
            case 94742588: {
                return new Property(SP_CLAIM, "Reference(Claim)", "The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.", 0, 1, this.claim);
            }
            case 689513629: {
                return new Property("claimResponse", "Reference(ClaimResponse)", "The business identifier for the instance: invoice number, claim number, pre-determination or pre-authorization number.", 0, 1, this.claimResponse);
            }
            case -1106507950: {
                return new Property("outcome", "code", "Processing outcome errror, partial or complete processing.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, 1, this.disposition);
            }
            case 1090493483: {
                return new Property("related", "", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, Integer.MAX_VALUE, this.related);
            }
            case 460301338: {
                return new Property("prescription", "Reference(MedicationRequest|VisionPrescription)", "Prescription to support the dispensing of Pharmacy or Vision products.", 0, 1, this.prescription);
            }
            case -1814015861: {
                return new Property("originalPrescription", "Reference(MedicationRequest)", "Original prescription which has been superceded by this prescription to support the dispensing of pharmacy services, medications or products. For example, a physician may prescribe a medication which the pharmacy determines is contraindicated, or for which the patient has an intolerance, and therefor issues a new precription for an alternate medication which has the same theraputic intent. The prescription from the pharmacy becomes the 'prescription' and that from the physician becomes the 'original prescription'.", 0, 1, this.originalPrescription);
            }
            case 106443592: {
                return new Property(SP_PAYEE, "", "The party to be reimbursed for the services.", 0, 1, this.payee);
            }
            case 1968600364: {
                return new Property("information", "", "Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues. Often there are mutiple jurisdiction specific valuesets which are required.", 0, Integer.MAX_VALUE, this.information);
            }
            case -7323378: {
                return new Property("careTeam", "", "The members of the team who provided the overall service as well as their role and whether responsible and qualifications.", 0, Integer.MAX_VALUE, this.careTeam);
            }
            case 1196993265: {
                return new Property("diagnosis", "", "Ordered list of patient diagnosis for which care is sought.", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -1095204141: {
                return new Property("procedure", "", "Ordered list of patient procedures performed to support the adjudication.", 0, Integer.MAX_VALUE, this.procedure);
            }
            case 159695370: {
                return new Property("precedence", "positiveInt", "Precedence (primary, secondary, etc.).", 0, 1, this.precedence);
            }
            case 73049818: {
                return new Property("insurance", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case -2143202801: {
                return new Property("accident", "", "An accident which resulted in the need for healthcare services.", 0, 1, this.accident);
            }
            case 3242771: {
                return new Property("item", "", "First-tier of goods and services.", 0, Integer.MAX_VALUE, this.item);
            }
            case -1148899500: {
                return new Property("addItem", "", "The first-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.addItem);
            }
            case 110549828: {
                return new Property("total", "", "Totals for amounts submitted, co-pays, benefits payable etc.", 0, Integer.MAX_VALUE, this.total);
            }
            case -786681338: {
                return new Property("payment", "", "Payment details for the claim if the claim has been paid.", 0, 1, this.payment);
            }
            case 3148996: {
                return new Property("form", "CodeableConcept", "The form to be used for printing the content.", 0, 1, this.form);
            }
            case 202339073: {
                return new Property("processNote", "", "Note text.", 0, Integer.MAX_VALUE, this.processNote);
            }
            case 596003397: {
                return new Property("benefitBalance", "", "Balance by Benefit Category.", 0, Integer.MAX_VALUE, this.benefitBalance);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1868521062: {
                Base[] baseArray;
                if (this.subType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subType;
                }
                return baseArray;
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.use;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.patient;
                }
                return baseArray;
            }
            case -332066046: {
                Base[] baseArray;
                if (this.billablePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.billablePeriod;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.created;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.enterer;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.insurer;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.provider;
                }
                return baseArray;
            }
            case -722568291: {
                Base[] baseArray;
                if (this.referral == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.referral;
                }
                return baseArray;
            }
            case 501116579: {
                Base[] baseArray;
                if (this.facility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.facility;
                }
                return baseArray;
            }
            case 94742588: {
                Base[] baseArray;
                if (this.claim == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.claim;
                }
                return baseArray;
            }
            case 689513629: {
                Base[] baseArray;
                if (this.claimResponse == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.claimResponse;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.disposition;
                }
                return baseArray;
            }
            case 1090493483: {
                return this.related == null ? new Base[]{} : this.related.toArray(new Base[this.related.size()]);
            }
            case 460301338: {
                Base[] baseArray;
                if (this.prescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.prescription;
                }
                return baseArray;
            }
            case -1814015861: {
                Base[] baseArray;
                if (this.originalPrescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.originalPrescription;
                }
                return baseArray;
            }
            case 106443592: {
                Base[] baseArray;
                if (this.payee == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.payee;
                }
                return baseArray;
            }
            case 1968600364: {
                return this.information == null ? new Base[]{} : this.information.toArray(new Base[this.information.size()]);
            }
            case -7323378: {
                return this.careTeam == null ? new Base[]{} : this.careTeam.toArray(new Base[this.careTeam.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -1095204141: {
                return this.procedure == null ? new Base[]{} : this.procedure.toArray(new Base[this.procedure.size()]);
            }
            case 159695370: {
                Base[] baseArray;
                if (this.precedence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.precedence;
                }
                return baseArray;
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case -2143202801: {
                Base[] baseArray;
                if (this.accident == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.accident;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
            case -1148899500: {
                return this.addItem == null ? new Base[]{} : this.addItem.toArray(new Base[this.addItem.size()]);
            }
            case 110549828: {
                return this.total == null ? new Base[]{} : this.total.toArray(new Base[this.total.size()]);
            }
            case -786681338: {
                Base[] baseArray;
                if (this.payment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.payment;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.form;
                }
                return baseArray;
            }
            case 202339073: {
                return this.processNote == null ? new Base[]{} : this.processNote.toArray(new Base[this.processNote.size()]);
            }
            case 596003397: {
                return this.benefitBalance == null ? new Base[]{} : this.benefitBalance.toArray(new Base[this.benefitBalance.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ExplanationOfBenefitStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1868521062: {
                this.subType = this.castToCodeableConcept(value);
                return value;
            }
            case 116103: {
                value = new UseEnumFactory().fromType(this.castToCode(value));
                this.use = value;
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case -332066046: {
                this.billablePeriod = this.castToPeriod(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case -1591951995: {
                this.enterer = this.castToReference(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case -987494927: {
                this.provider = this.castToReference(value);
                return value;
            }
            case -722568291: {
                this.referral = this.castToReference(value);
                return value;
            }
            case 501116579: {
                this.facility = this.castToReference(value);
                return value;
            }
            case 94742588: {
                this.claim = this.castToReference(value);
                return value;
            }
            case 689513629: {
                this.claimResponse = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                return value;
            }
            case 1090493483: {
                this.getRelated().add((RelatedClaimComponent)((Object)value));
                return value;
            }
            case 460301338: {
                this.prescription = this.castToReference(value);
                return value;
            }
            case -1814015861: {
                this.originalPrescription = this.castToReference(value);
                return value;
            }
            case 106443592: {
                this.payee = (PayeeComponent)((Object)value);
                return value;
            }
            case 1968600364: {
                this.getInformation().add((SupportingInformationComponent)((Object)value));
                return value;
            }
            case -7323378: {
                this.getCareTeam().add((CareTeamComponent)((Object)value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)((Object)value));
                return value;
            }
            case -1095204141: {
                this.getProcedure().add((ProcedureComponent)((Object)value));
                return value;
            }
            case 159695370: {
                this.precedence = this.castToPositiveInt(value);
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
            case -2143202801: {
                this.accident = (AccidentComponent)((Object)value);
                return value;
            }
            case 3242771: {
                this.getItem().add((ItemComponent)((Object)value));
                return value;
            }
            case -1148899500: {
                this.getAddItem().add((AddedItemComponent)((Object)value));
                return value;
            }
            case 110549828: {
                this.getTotal().add((TotalComponent)((Object)value));
                return value;
            }
            case -786681338: {
                this.payment = (PaymentComponent)((Object)value);
                return value;
            }
            case 3148996: {
                this.form = this.castToCodeableConcept(value);
                return value;
            }
            case 202339073: {
                this.getProcessNote().add((NoteComponent)((Object)value));
                return value;
            }
            case 596003397: {
                this.getBenefitBalance().add((BenefitBalanceComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ExplanationOfBenefitStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("subType")) {
            this.subType = this.castToCodeableConcept(value);
        } else if (name.equals("use")) {
            value = new UseEnumFactory().fromType(this.castToCode(value));
            this.use = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("billablePeriod")) {
            this.billablePeriod = this.castToPeriod(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = this.castToReference(value);
        } else if (name.equals("insurer")) {
            this.insurer = this.castToReference(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals("referral")) {
            this.referral = this.castToReference(value);
        } else if (name.equals(SP_FACILITY)) {
            this.facility = this.castToReference(value);
        } else if (name.equals(SP_CLAIM)) {
            this.claim = this.castToReference(value);
        } else if (name.equals("claimResponse")) {
            this.claimResponse = this.castToReference(value);
        } else if (name.equals("outcome")) {
            value = new RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
            this.outcome = value;
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = this.castToString(value);
        } else if (name.equals("related")) {
            this.getRelated().add((RelatedClaimComponent)((Object)value));
        } else if (name.equals("prescription")) {
            this.prescription = this.castToReference(value);
        } else if (name.equals("originalPrescription")) {
            this.originalPrescription = this.castToReference(value);
        } else if (name.equals(SP_PAYEE)) {
            this.payee = (PayeeComponent)((Object)value);
        } else if (name.equals("information")) {
            this.getInformation().add((SupportingInformationComponent)((Object)value));
        } else if (name.equals("careTeam")) {
            this.getCareTeam().add((CareTeamComponent)((Object)value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((DiagnosisComponent)((Object)value));
        } else if (name.equals("procedure")) {
            this.getProcedure().add((ProcedureComponent)((Object)value));
        } else if (name.equals("precedence")) {
            this.precedence = this.castToPositiveInt(value);
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else if (name.equals("accident")) {
            this.accident = (AccidentComponent)((Object)value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemComponent)((Object)value));
        } else if (name.equals("addItem")) {
            this.getAddItem().add((AddedItemComponent)((Object)value));
        } else if (name.equals("total")) {
            this.getTotal().add((TotalComponent)((Object)value));
        } else if (name.equals("payment")) {
            this.payment = (PaymentComponent)((Object)value);
        } else if (name.equals("form")) {
            this.form = this.castToCodeableConcept(value);
        } else if (name.equals("processNote")) {
            this.getProcessNote().add((NoteComponent)((Object)value));
        } else if (name.equals("benefitBalance")) {
            this.getBenefitBalance().add((BenefitBalanceComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1868521062: {
                return this.getSubType();
            }
            case 116103: {
                return this.getUseElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -332066046: {
                return this.getBillablePeriod();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case -987494927: {
                return this.getProvider();
            }
            case -722568291: {
                return this.getReferral();
            }
            case 501116579: {
                return this.getFacility();
            }
            case 94742588: {
                return this.getClaim();
            }
            case 689513629: {
                return this.getClaimResponse();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 1090493483: {
                return this.addRelated();
            }
            case 460301338: {
                return this.getPrescription();
            }
            case -1814015861: {
                return this.getOriginalPrescription();
            }
            case 106443592: {
                return this.getPayee();
            }
            case 1968600364: {
                return this.addInformation();
            }
            case -7323378: {
                return this.addCareTeam();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -1095204141: {
                return this.addProcedure();
            }
            case 159695370: {
                return this.getPrecedenceElement();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case -2143202801: {
                return this.getAccident();
            }
            case 3242771: {
                return this.addItem();
            }
            case -1148899500: {
                return this.addAddItem();
            }
            case 110549828: {
                return this.addTotal();
            }
            case -786681338: {
                return this.getPayment();
            }
            case 3148996: {
                return this.getForm();
            }
            case 202339073: {
                return this.addProcessNote();
            }
            case 596003397: {
                return this.addBenefitBalance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1868521062: {
                return new String[]{"CodeableConcept"};
            }
            case 116103: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -332066046: {
                return new String[]{"Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case -987494927: {
                return new String[]{"Reference"};
            }
            case -722568291: {
                return new String[]{"Reference"};
            }
            case 501116579: {
                return new String[]{"Reference"};
            }
            case 94742588: {
                return new String[]{"Reference"};
            }
            case 689513629: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 1090493483: {
                return new String[0];
            }
            case 460301338: {
                return new String[]{"Reference"};
            }
            case -1814015861: {
                return new String[]{"Reference"};
            }
            case 106443592: {
                return new String[0];
            }
            case 1968600364: {
                return new String[0];
            }
            case -7323378: {
                return new String[0];
            }
            case 1196993265: {
                return new String[0];
            }
            case -1095204141: {
                return new String[0];
            }
            case 159695370: {
                return new String[]{"positiveInt"};
            }
            case 73049818: {
                return new String[0];
            }
            case -2143202801: {
                return new String[0];
            }
            case 3242771: {
                return new String[0];
            }
            case -1148899500: {
                return new String[0];
            }
            case 110549828: {
                return new String[0];
            }
            case -786681338: {
                return new String[0];
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case 202339073: {
                return new String[0];
            }
            case 596003397: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.status");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("subType")) {
            this.subType = new CodeableConcept();
            return this.subType;
        }
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.use");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("billablePeriod")) {
            this.billablePeriod = new Period();
            return this.billablePeriod;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.created");
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals("insurer")) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("referral")) {
            this.referral = new Reference();
            return this.referral;
        }
        if (name.equals(SP_FACILITY)) {
            this.facility = new Reference();
            return this.facility;
        }
        if (name.equals(SP_CLAIM)) {
            this.claim = new Reference();
            return this.claim;
        }
        if (name.equals("claimResponse")) {
            this.claimResponse = new Reference();
            return this.claimResponse;
        }
        if (name.equals("outcome")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.outcome");
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.disposition");
        }
        if (name.equals("related")) {
            return this.addRelated();
        }
        if (name.equals("prescription")) {
            this.prescription = new Reference();
            return this.prescription;
        }
        if (name.equals("originalPrescription")) {
            this.originalPrescription = new Reference();
            return this.originalPrescription;
        }
        if (name.equals(SP_PAYEE)) {
            this.payee = new PayeeComponent();
            return this.payee;
        }
        if (name.equals("information")) {
            return this.addInformation();
        }
        if (name.equals("careTeam")) {
            return this.addCareTeam();
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals("procedure")) {
            return this.addProcedure();
        }
        if (name.equals("precedence")) {
            throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.precedence");
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("accident")) {
            this.accident = new AccidentComponent();
            return this.accident;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("addItem")) {
            return this.addAddItem();
        }
        if (name.equals("total")) {
            return this.addTotal();
        }
        if (name.equals("payment")) {
            this.payment = new PaymentComponent();
            return this.payment;
        }
        if (name.equals("form")) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals("processNote")) {
            return this.addProcessNote();
        }
        if (name.equals("benefitBalance")) {
            return this.addBenefitBalance();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ExplanationOfBenefit";
    }

    @Override
    public ExplanationOfBenefit copy() {
        ExplanationOfBenefit dst = new ExplanationOfBenefit();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subType = this.subType == null ? null : this.subType.copy();
        dst.use = this.use == null ? null : this.use.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.billablePeriod = this.billablePeriod == null ? null : this.billablePeriod.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.referral = this.referral == null ? null : this.referral.copy();
        dst.facility = this.facility == null ? null : this.facility.copy();
        dst.claim = this.claim == null ? null : this.claim.copy();
        dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        StringType stringType = dst.disposition = this.disposition == null ? null : this.disposition.copy();
        if (this.related != null) {
            dst.related = new ArrayList<RelatedClaimComponent>();
            for (RelatedClaimComponent relatedClaimComponent : this.related) {
                dst.related.add(relatedClaimComponent.copy());
            }
        }
        dst.prescription = this.prescription == null ? null : this.prescription.copy();
        dst.originalPrescription = this.originalPrescription == null ? null : this.originalPrescription.copy();
        PayeeComponent payeeComponent = dst.payee = this.payee == null ? null : this.payee.copy();
        if (this.information != null) {
            dst.information = new ArrayList<SupportingInformationComponent>();
            for (SupportingInformationComponent supportingInformationComponent : this.information) {
                dst.information.add(supportingInformationComponent.copy());
            }
        }
        if (this.careTeam != null) {
            dst.careTeam = new ArrayList<CareTeamComponent>();
            for (CareTeamComponent careTeamComponent : this.careTeam) {
                dst.careTeam.add(careTeamComponent.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        if (this.procedure != null) {
            dst.procedure = new ArrayList<ProcedureComponent>();
            for (ProcedureComponent procedureComponent : this.procedure) {
                dst.procedure.add(procedureComponent.copy());
            }
        }
        PositiveIntType positiveIntType = dst.precedence = this.precedence == null ? null : this.precedence.copy();
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        AccidentComponent accidentComponent = dst.accident = this.accident == null ? null : this.accident.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemComponent>();
            for (ItemComponent itemComponent : this.item) {
                dst.item.add(itemComponent.copy());
            }
        }
        if (this.addItem != null) {
            dst.addItem = new ArrayList<AddedItemComponent>();
            for (AddedItemComponent addedItemComponent : this.addItem) {
                dst.addItem.add(addedItemComponent.copy());
            }
        }
        if (this.total != null) {
            dst.total = new ArrayList<TotalComponent>();
            for (TotalComponent totalComponent : this.total) {
                dst.total.add(totalComponent.copy());
            }
        }
        dst.payment = this.payment == null ? null : this.payment.copy();
        CodeableConcept codeableConcept = dst.form = this.form == null ? null : this.form.copy();
        if (this.processNote != null) {
            dst.processNote = new ArrayList<NoteComponent>();
            for (NoteComponent noteComponent : this.processNote) {
                dst.processNote.add(noteComponent.copy());
            }
        }
        if (this.benefitBalance != null) {
            dst.benefitBalance = new ArrayList<BenefitBalanceComponent>();
            for (BenefitBalanceComponent benefitBalanceComponent : this.benefitBalance) {
                dst.benefitBalance.add(benefitBalanceComponent.copy());
            }
        }
        return dst;
    }

    protected ExplanationOfBenefit typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ExplanationOfBenefit)) {
            return false;
        }
        ExplanationOfBenefit o = (ExplanationOfBenefit)other_;
        return ExplanationOfBenefit.compareDeep(this.identifier, o.identifier, true) && ExplanationOfBenefit.compareDeep(this.status, o.status, true) && ExplanationOfBenefit.compareDeep(this.type, o.type, true) && ExplanationOfBenefit.compareDeep(this.subType, o.subType, true) && ExplanationOfBenefit.compareDeep(this.use, o.use, true) && ExplanationOfBenefit.compareDeep(this.patient, o.patient, true) && ExplanationOfBenefit.compareDeep(this.billablePeriod, o.billablePeriod, true) && ExplanationOfBenefit.compareDeep(this.created, o.created, true) && ExplanationOfBenefit.compareDeep(this.enterer, o.enterer, true) && ExplanationOfBenefit.compareDeep(this.insurer, o.insurer, true) && ExplanationOfBenefit.compareDeep(this.provider, o.provider, true) && ExplanationOfBenefit.compareDeep(this.referral, o.referral, true) && ExplanationOfBenefit.compareDeep(this.facility, o.facility, true) && ExplanationOfBenefit.compareDeep(this.claim, o.claim, true) && ExplanationOfBenefit.compareDeep(this.claimResponse, o.claimResponse, true) && ExplanationOfBenefit.compareDeep(this.outcome, o.outcome, true) && ExplanationOfBenefit.compareDeep(this.disposition, o.disposition, true) && ExplanationOfBenefit.compareDeep(this.related, o.related, true) && ExplanationOfBenefit.compareDeep(this.prescription, o.prescription, true) && ExplanationOfBenefit.compareDeep(this.originalPrescription, o.originalPrescription, true) && ExplanationOfBenefit.compareDeep(this.payee, o.payee, true) && ExplanationOfBenefit.compareDeep(this.information, o.information, true) && ExplanationOfBenefit.compareDeep(this.careTeam, o.careTeam, true) && ExplanationOfBenefit.compareDeep(this.diagnosis, o.diagnosis, true) && ExplanationOfBenefit.compareDeep(this.procedure, o.procedure, true) && ExplanationOfBenefit.compareDeep(this.precedence, o.precedence, true) && ExplanationOfBenefit.compareDeep(this.insurance, o.insurance, true) && ExplanationOfBenefit.compareDeep(this.accident, o.accident, true) && ExplanationOfBenefit.compareDeep(this.item, o.item, true) && ExplanationOfBenefit.compareDeep(this.addItem, o.addItem, true) && ExplanationOfBenefit.compareDeep(this.total, o.total, true) && ExplanationOfBenefit.compareDeep(this.payment, o.payment, true) && ExplanationOfBenefit.compareDeep(this.form, o.form, true) && ExplanationOfBenefit.compareDeep(this.processNote, o.processNote, true) && ExplanationOfBenefit.compareDeep(this.benefitBalance, o.benefitBalance, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ExplanationOfBenefit)) {
            return false;
        }
        ExplanationOfBenefit o = (ExplanationOfBenefit)other_;
        return ExplanationOfBenefit.compareValues(this.status, o.status, true) && ExplanationOfBenefit.compareValues(this.use, o.use, true) && ExplanationOfBenefit.compareValues(this.created, o.created, true) && ExplanationOfBenefit.compareValues(this.outcome, o.outcome, true) && ExplanationOfBenefit.compareValues(this.disposition, o.disposition, true) && ExplanationOfBenefit.compareValues(this.precedence, o.precedence, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.subType, this.use, this.patient, this.billablePeriod, this.created, this.enterer, this.insurer, this.provider, this.referral, this.facility, this.claim, this.claimResponse, this.outcome, this.disposition, this.related, this.prescription, this.originalPrescription, this.payee, this.information, this.careTeam, this.diagnosis, this.procedure, this.precedence, this.insurance, this.accident, this.item, this.addItem, this.total, this.payment, this.form, this.processNote, this.benefitBalance});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ExplanationOfBenefit;
    }

    @Block
    public static class BenefitComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Deductable, visits, benefit amount", formalDefinition="Deductable, visits, benefit amount.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-type")
        protected CodeableConcept type;
        @Child(name="allowed", type={UnsignedIntType.class, StringType.class, Money.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits allowed", formalDefinition="Benefits allowed.")
        protected Type allowed;
        @Child(name="used", type={UnsignedIntType.class, Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefits used", formalDefinition="Benefits used.")
        protected Type used;
        private static final long serialVersionUID = -1506285314L;

        public BenefitComponent() {
        }

        public BenefitComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public BenefitComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getAllowed() {
            return this.allowed;
        }

        public UnsignedIntType getAllowedUnsignedIntType() throws FHIRException {
            if (this.allowed == null) {
                return null;
            }
            if (!(this.allowed instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.allowed;
        }

        public boolean hasAllowedUnsignedIntType() {
            return this != null && this.allowed instanceof UnsignedIntType;
        }

        public StringType getAllowedStringType() throws FHIRException {
            if (this.allowed == null) {
                return null;
            }
            if (!(this.allowed instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (StringType)this.allowed;
        }

        public boolean hasAllowedStringType() {
            return this != null && this.allowed instanceof StringType;
        }

        public Money getAllowedMoney() throws FHIRException {
            if (this.allowed == null) {
                return null;
            }
            if (!(this.allowed instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.allowed.getClass().getName() + " was encountered");
            }
            return (Money)this.allowed;
        }

        public boolean hasAllowedMoney() {
            return this != null && this.allowed instanceof Money;
        }

        public boolean hasAllowed() {
            return this.allowed != null && !this.allowed.isEmpty();
        }

        public BenefitComponent setAllowed(Type value) {
            if (!(value == null || value instanceof UnsignedIntType || value instanceof StringType || value instanceof Money)) {
                throw new Error("Not the right type for ExplanationOfBenefit.benefitBalance.financial.allowed[x]: " + value.fhirType());
            }
            this.allowed = value;
            return this;
        }

        public Type getUsed() {
            return this.used;
        }

        public UnsignedIntType getUsedUnsignedIntType() throws FHIRException {
            if (this.used == null) {
                return null;
            }
            if (!(this.used instanceof UnsignedIntType)) {
                throw new FHIRException("Type mismatch: the type UnsignedIntType was expected, but " + this.used.getClass().getName() + " was encountered");
            }
            return (UnsignedIntType)this.used;
        }

        public boolean hasUsedUnsignedIntType() {
            return this != null && this.used instanceof UnsignedIntType;
        }

        public Money getUsedMoney() throws FHIRException {
            if (this.used == null) {
                return null;
            }
            if (!(this.used instanceof Money)) {
                throw new FHIRException("Type mismatch: the type Money was expected, but " + this.used.getClass().getName() + " was encountered");
            }
            return (Money)this.used;
        }

        public boolean hasUsedMoney() {
            return this != null && this.used instanceof Money;
        }

        public boolean hasUsed() {
            return this.used != null && !this.used.isEmpty();
        }

        public BenefitComponent setUsed(Type value) {
            if (value != null && !(value instanceof UnsignedIntType) && !(value instanceof Money)) {
                throw new Error("Not the right type for ExplanationOfBenefit.benefitBalance.financial.used[x]: " + value.fhirType());
            }
            this.used = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Deductable, visits, benefit amount.", 0, 1, this.type));
            children.add(new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed));
            children.add(new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Deductable, visits, benefit amount.", 0, 1, this.type);
                }
                case -1336663592: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case -911343192: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case 1668802034: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case -2135265319: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case -351668232: {
                    return new Property("allowed[x]", "unsignedInt|string|Money", "Benefits allowed.", 0, 1, this.allowed);
                }
                case -147553373: {
                    return new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used);
                }
                case 3599293: {
                    return new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used);
                }
                case 1252740285: {
                    return new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used);
                }
                case -78048509: {
                    return new Property("used[x]", "unsignedInt|Money", "Benefits used.", 0, 1, this.used);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -911343192: {
                    Base[] baseArray;
                    if (this.allowed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.allowed;
                    }
                    return baseArray;
                }
                case 3599293: {
                    Base[] baseArray;
                    if (this.used == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.used;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -911343192: {
                    this.allowed = this.castToType(value);
                    return value;
                }
                case 3599293: {
                    this.used = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("allowed[x]")) {
                this.allowed = this.castToType(value);
            } else if (name.equals("used[x]")) {
                this.used = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1336663592: {
                    return this.getAllowed();
                }
                case -911343192: {
                    return this.getAllowed();
                }
                case -147553373: {
                    return this.getUsed();
                }
                case 3599293: {
                    return this.getUsed();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -911343192: {
                    return new String[]{"unsignedInt", "string", "Money"};
                }
                case 3599293: {
                    return new String[]{"unsignedInt", "Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("allowedUnsignedInt")) {
                this.allowed = new UnsignedIntType();
                return this.allowed;
            }
            if (name.equals("allowedString")) {
                this.allowed = new StringType();
                return this.allowed;
            }
            if (name.equals("allowedMoney")) {
                this.allowed = new Money();
                return this.allowed;
            }
            if (name.equals("usedUnsignedInt")) {
                this.used = new UnsignedIntType();
                return this.used;
            }
            if (name.equals("usedMoney")) {
                this.used = new Money();
                return this.used;
            }
            return super.addChild(name);
        }

        @Override
        public BenefitComponent copy() {
            BenefitComponent dst = new BenefitComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.allowed = this.allowed == null ? null : this.allowed.copy();
            dst.used = this.used == null ? null : this.used.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other_;
            return BenefitComponent.compareDeep(this.type, o.type, true) && BenefitComponent.compareDeep(this.allowed, o.allowed, true) && BenefitComponent.compareDeep(this.used, o.used, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitComponent)) {
                return false;
            }
            BenefitComponent o = (BenefitComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.allowed, this.used});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.benefitBalance.financial";
        }
    }

    @Block
    public static class BenefitBalanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of services covered", formalDefinition="Dental, Vision, Medical, Pharmacy, Rehab etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="excluded", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Excluded from the plan", formalDefinition="True if the indicated class of service is excluded from the plan, missing or False indicated the service is included in the coverage.")
        protected BooleanType excluded;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short name for the benefit", formalDefinition="A short name or tag for the benefit, for example MED01, or DENT2.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the benefit or services covered", formalDefinition="A richer description of the benefit, for example 'DENT2 covers 100% of basic, 50% of major but exclused Ortho, Implants and Costmetic services'.")
        protected StringType description;
        @Child(name="network", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="In or out of network", formalDefinition="Network designation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-network")
        protected CodeableConcept network;
        @Child(name="unit", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual or family", formalDefinition="Unit designation: individual or family.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-unit")
        protected CodeableConcept unit;
        @Child(name="term", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Annual or lifetime", formalDefinition="The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/benefit-term")
        protected CodeableConcept term;
        @Child(name="financial", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit Summary", formalDefinition="Benefits Used to date.")
        protected List<BenefitComponent> financial;
        private static final long serialVersionUID = -1889655824L;

        public BenefitBalanceComponent() {
        }

        public BenefitBalanceComponent(CodeableConcept category) {
            this.category = category;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public BenefitBalanceComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public BooleanType getExcludedElement() {
            if (this.excluded == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.excluded");
                }
                if (Configuration.doAutoCreate()) {
                    this.excluded = new BooleanType();
                }
            }
            return this.excluded;
        }

        public boolean hasExcludedElement() {
            return this.excluded != null && !this.excluded.isEmpty();
        }

        public boolean hasExcluded() {
            return this.excluded != null && !this.excluded.isEmpty();
        }

        public BenefitBalanceComponent setExcludedElement(BooleanType value) {
            this.excluded = value;
            return this;
        }

        public boolean getExcluded() {
            return this.excluded == null || this.excluded.isEmpty() ? false : (Boolean)this.excluded.getValue();
        }

        public BenefitBalanceComponent setExcluded(boolean value) {
            if (this.excluded == null) {
                this.excluded = new BooleanType();
            }
            this.excluded.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public BenefitBalanceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public BenefitBalanceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public BenefitBalanceComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public BenefitBalanceComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getNetwork() {
            if (this.network == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.network");
                }
                if (Configuration.doAutoCreate()) {
                    this.network = new CodeableConcept();
                }
            }
            return this.network;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public BenefitBalanceComponent setNetwork(CodeableConcept value) {
            this.network = value;
            return this;
        }

        public CodeableConcept getUnit() {
            if (this.unit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.unit");
                }
                if (Configuration.doAutoCreate()) {
                    this.unit = new CodeableConcept();
                }
            }
            return this.unit;
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public BenefitBalanceComponent setUnit(CodeableConcept value) {
            this.unit = value;
            return this;
        }

        public CodeableConcept getTerm() {
            if (this.term == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BenefitBalanceComponent.term");
                }
                if (Configuration.doAutoCreate()) {
                    this.term = new CodeableConcept();
                }
            }
            return this.term;
        }

        public boolean hasTerm() {
            return this.term != null && !this.term.isEmpty();
        }

        public BenefitBalanceComponent setTerm(CodeableConcept value) {
            this.term = value;
            return this;
        }

        public List<BenefitComponent> getFinancial() {
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            return this.financial;
        }

        public BenefitBalanceComponent setFinancial(List<BenefitComponent> theFinancial) {
            this.financial = theFinancial;
            return this;
        }

        public boolean hasFinancial() {
            if (this.financial == null) {
                return false;
            }
            for (BenefitComponent item : this.financial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BenefitComponent addFinancial() {
            BenefitComponent t = new BenefitComponent();
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            this.financial.add(t);
            return t;
        }

        public BenefitBalanceComponent addFinancial(BenefitComponent t) {
            if (t == null) {
                return this;
            }
            if (this.financial == null) {
                this.financial = new ArrayList<BenefitComponent>();
            }
            this.financial.add(t);
            return this;
        }

        public BenefitComponent getFinancialFirstRep() {
            if (this.getFinancial().isEmpty()) {
                this.addFinancial();
            }
            return this.getFinancial().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Dental, Vision, Medical, Pharmacy, Rehab etc.", 0, 1, this.category));
            children.add(new Property("excluded", "boolean", "True if the indicated class of service is excluded from the plan, missing or False indicated the service is included in the coverage.", 0, 1, this.excluded));
            children.add(new Property("name", "string", "A short name or tag for the benefit, for example MED01, or DENT2.", 0, 1, this.name));
            children.add(new Property("description", "string", "A richer description of the benefit, for example 'DENT2 covers 100% of basic, 50% of major but exclused Ortho, Implants and Costmetic services'.", 0, 1, this.description));
            children.add(new Property("network", "CodeableConcept", "Network designation.", 0, 1, this.network));
            children.add(new Property("unit", "CodeableConcept", "Unit designation: individual or family.", 0, 1, this.unit));
            children.add(new Property("term", "CodeableConcept", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.", 0, 1, this.term));
            children.add(new Property("financial", "", "Benefits Used to date.", 0, Integer.MAX_VALUE, this.financial));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Dental, Vision, Medical, Pharmacy, Rehab etc.", 0, 1, this.category);
                }
                case 1994055114: {
                    return new Property("excluded", "boolean", "True if the indicated class of service is excluded from the plan, missing or False indicated the service is included in the coverage.", 0, 1, this.excluded);
                }
                case 3373707: {
                    return new Property("name", "string", "A short name or tag for the benefit, for example MED01, or DENT2.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "string", "A richer description of the benefit, for example 'DENT2 covers 100% of basic, 50% of major but exclused Ortho, Implants and Costmetic services'.", 0, 1, this.description);
                }
                case 1843485230: {
                    return new Property("network", "CodeableConcept", "Network designation.", 0, 1, this.network);
                }
                case 3594628: {
                    return new Property("unit", "CodeableConcept", "Unit designation: individual or family.", 0, 1, this.unit);
                }
                case 3556460: {
                    return new Property("term", "CodeableConcept", "The term or period of the values such as 'maximum lifetime benefit' or 'maximum annual vistis'.", 0, 1, this.term);
                }
                case 357555337: {
                    return new Property("financial", "", "Benefits Used to date.", 0, Integer.MAX_VALUE, this.financial);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 1994055114: {
                    Base[] baseArray;
                    if (this.excluded == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.excluded;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    Base[] baseArray;
                    if (this.network == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.network;
                    }
                    return baseArray;
                }
                case 3594628: {
                    Base[] baseArray;
                    if (this.unit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.unit;
                    }
                    return baseArray;
                }
                case 3556460: {
                    Base[] baseArray;
                    if (this.term == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.term;
                    }
                    return baseArray;
                }
                case 357555337: {
                    return this.financial == null ? new Base[]{} : this.financial.toArray(new Base[this.financial.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1994055114: {
                    this.excluded = this.castToBoolean(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 1843485230: {
                    this.network = this.castToCodeableConcept(value);
                    return value;
                }
                case 3594628: {
                    this.unit = this.castToCodeableConcept(value);
                    return value;
                }
                case 3556460: {
                    this.term = this.castToCodeableConcept(value);
                    return value;
                }
                case 357555337: {
                    this.getFinancial().add((BenefitComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("excluded")) {
                this.excluded = this.castToBoolean(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("network")) {
                this.network = this.castToCodeableConcept(value);
            } else if (name.equals("unit")) {
                this.unit = this.castToCodeableConcept(value);
            } else if (name.equals("term")) {
                this.term = this.castToCodeableConcept(value);
            } else if (name.equals("financial")) {
                this.getFinancial().add((BenefitComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 1994055114: {
                    return this.getExcludedElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1843485230: {
                    return this.getNetwork();
                }
                case 3594628: {
                    return this.getUnit();
                }
                case 3556460: {
                    return this.getTerm();
                }
                case 357555337: {
                    return this.addFinancial();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1994055114: {
                    return new String[]{"boolean"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1843485230: {
                    return new String[]{"CodeableConcept"};
                }
                case 3594628: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556460: {
                    return new String[]{"CodeableConcept"};
                }
                case 357555337: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("excluded")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.excluded");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.description");
            }
            if (name.equals("network")) {
                this.network = new CodeableConcept();
                return this.network;
            }
            if (name.equals("unit")) {
                this.unit = new CodeableConcept();
                return this.unit;
            }
            if (name.equals("term")) {
                this.term = new CodeableConcept();
                return this.term;
            }
            if (name.equals("financial")) {
                return this.addFinancial();
            }
            return super.addChild(name);
        }

        @Override
        public BenefitBalanceComponent copy() {
            BenefitBalanceComponent dst = new BenefitBalanceComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.excluded = this.excluded == null ? null : this.excluded.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.network = this.network == null ? null : this.network.copy();
            dst.unit = this.unit == null ? null : this.unit.copy();
            CodeableConcept codeableConcept = dst.term = this.term == null ? null : this.term.copy();
            if (this.financial != null) {
                dst.financial = new ArrayList<BenefitComponent>();
                for (BenefitComponent i : this.financial) {
                    dst.financial.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitBalanceComponent)) {
                return false;
            }
            BenefitBalanceComponent o = (BenefitBalanceComponent)other_;
            return BenefitBalanceComponent.compareDeep(this.category, o.category, true) && BenefitBalanceComponent.compareDeep(this.excluded, o.excluded, true) && BenefitBalanceComponent.compareDeep(this.name, o.name, true) && BenefitBalanceComponent.compareDeep(this.description, o.description, true) && BenefitBalanceComponent.compareDeep(this.network, o.network, true) && BenefitBalanceComponent.compareDeep(this.unit, o.unit, true) && BenefitBalanceComponent.compareDeep(this.term, o.term, true) && BenefitBalanceComponent.compareDeep(this.financial, o.financial, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BenefitBalanceComponent)) {
                return false;
            }
            BenefitBalanceComponent o = (BenefitBalanceComponent)other_;
            return BenefitBalanceComponent.compareValues(this.excluded, o.excluded, true) && BenefitBalanceComponent.compareValues(this.name, o.name, true) && BenefitBalanceComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.excluded, this.name, this.description, this.network, this.unit, this.term, this.financial});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.benefitBalance";
        }
    }

    @Block
    public static class NoteComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sequence number for this note", formalDefinition="An integer associated with each note which may be referred to from each service line item.")
        protected PositiveIntType number;
        @Child(name="type", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        protected Enumeration<Enumerations.NoteType> type;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Note explanitory text", formalDefinition="The note text.")
        protected StringType text;
        @Child(name="language", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language if different from the resource", formalDefinition="The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        private static final long serialVersionUID = -385184277L;

        public PositiveIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new PositiveIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public NoteComponent setNumberElement(PositiveIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public NoteComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new PositiveIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Enumeration<Enumerations.NoteType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NoteComponent setTypeElement(Enumeration<Enumerations.NoteType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.NoteType getType() {
            return this.type == null ? null : (Enumerations.NoteType)((Object)this.type.getValue());
        }

        public NoteComponent setType(Enumerations.NoteType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NoteComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NoteComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public NoteComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("number", "positiveInt", "An integer associated with each note which may be referred to from each service line item.", 0, 1, this.number));
            children.add(new Property("type", "code", "The note purpose: Print/Display.", 0, 1, this.type));
            children.add(new Property("text", "string", "The note text.", 0, 1, this.text));
            children.add(new Property("language", "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.", 0, 1, this.language));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1034364087: {
                    return new Property("number", "positiveInt", "An integer associated with each note which may be referred to from each service line item.", 0, 1, this.number);
                }
                case 3575610: {
                    return new Property("type", "code", "The note purpose: Print/Display.", 0, 1, this.type);
                }
                case 3556653: {
                    return new Property("text", "string", "The note text.", 0, 1, this.text);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.", 0, 1, this.language);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.number;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.language;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.number = this.castToPositiveInt(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.NoteTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                value = new Enumerations.NoteTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("language")) {
                this.language = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return new String[]{"positiveInt"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.number");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.type");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.text");
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            return super.addChild(name);
        }

        @Override
        public NoteComponent copy() {
            NoteComponent dst = new NoteComponent();
            this.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.language = this.language == null ? null : this.language.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NoteComponent)) {
                return false;
            }
            NoteComponent o = (NoteComponent)other_;
            return NoteComponent.compareDeep(this.number, o.number, true) && NoteComponent.compareDeep(this.type, o.type, true) && NoteComponent.compareDeep(this.text, o.text, true) && NoteComponent.compareDeep(this.language, o.language, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NoteComponent)) {
                return false;
            }
            NoteComponent o = (NoteComponent)other_;
            return NoteComponent.compareValues(this.number, o.number, true) && NoteComponent.compareValues(this.type, o.type, true) && NoteComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.number, this.type, this.text, this.language});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.processNote";
        }
    }

    @Block
    public static class PaymentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Partial or Complete", formalDefinition="Whether this represents partial or complete payment of the claim.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-paymenttype")
        protected CodeableConcept type;
        @Child(name="adjustment", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Payment adjustment for non-Claim issues", formalDefinition="Adjustment to the payment of this transaction which is not related to adjudication of this transaction.")
        protected Money adjustment;
        @Child(name="adjustmentReason", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation for the non-claim adjustment", formalDefinition="Reason for the payment adjustment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-adjustment-reason")
        protected CodeableConcept adjustmentReason;
        @Child(name="date", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Expected date of Payment", formalDefinition="Estimated payment date.")
        protected DateType date;
        @Child(name="amount", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Payable amount after adjustment", formalDefinition="Payable less any payment adjustment.")
        protected Money amount;
        @Child(name="identifier", type={Identifier.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier of the payment instrument", formalDefinition="Payment identifier.")
        protected Identifier identifier;
        private static final long serialVersionUID = 1539906026L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PaymentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Money getAdjustment() {
            if (this.adjustment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.adjustment");
                }
                if (Configuration.doAutoCreate()) {
                    this.adjustment = new Money();
                }
            }
            return this.adjustment;
        }

        public boolean hasAdjustment() {
            return this.adjustment != null && !this.adjustment.isEmpty();
        }

        public PaymentComponent setAdjustment(Money value) {
            this.adjustment = value;
            return this;
        }

        public CodeableConcept getAdjustmentReason() {
            if (this.adjustmentReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.adjustmentReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.adjustmentReason = new CodeableConcept();
                }
            }
            return this.adjustmentReason;
        }

        public boolean hasAdjustmentReason() {
            return this.adjustmentReason != null && !this.adjustmentReason.isEmpty();
        }

        public PaymentComponent setAdjustmentReason(CodeableConcept value) {
            this.adjustmentReason = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public PaymentComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public PaymentComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PaymentComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public PaymentComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Whether this represents partial or complete payment of the claim.", 0, 1, this.type));
            children.add(new Property("adjustment", "Money", "Adjustment to the payment of this transaction which is not related to adjudication of this transaction.", 0, 1, this.adjustment));
            children.add(new Property("adjustmentReason", "CodeableConcept", "Reason for the payment adjustment.", 0, 1, this.adjustmentReason));
            children.add(new Property("date", "date", "Estimated payment date.", 0, 1, this.date));
            children.add(new Property("amount", "Money", "Payable less any payment adjustment.", 0, 1, this.amount));
            children.add(new Property(ExplanationOfBenefit.SP_IDENTIFIER, "Identifier", "Payment identifier.", 0, 1, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Whether this represents partial or complete payment of the claim.", 0, 1, this.type);
                }
                case 1977085293: {
                    return new Property("adjustment", "Money", "Adjustment to the payment of this transaction which is not related to adjudication of this transaction.", 0, 1, this.adjustment);
                }
                case -1255938543: {
                    return new Property("adjustmentReason", "CodeableConcept", "Reason for the payment adjustment.", 0, 1, this.adjustmentReason);
                }
                case 3076014: {
                    return new Property("date", "date", "Estimated payment date.", 0, 1, this.date);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Payable less any payment adjustment.", 0, 1, this.amount);
                }
                case -1618432855: {
                    return new Property(ExplanationOfBenefit.SP_IDENTIFIER, "Identifier", "Payment identifier.", 0, 1, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1977085293: {
                    Base[] baseArray;
                    if (this.adjustment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.adjustment;
                    }
                    return baseArray;
                }
                case -1255938543: {
                    Base[] baseArray;
                    if (this.adjustmentReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.adjustmentReason;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.date;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.identifier;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1977085293: {
                    this.adjustment = this.castToMoney(value);
                    return value;
                }
                case -1255938543: {
                    this.adjustmentReason = this.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDate(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("adjustment")) {
                this.adjustment = this.castToMoney(value);
            } else if (name.equals("adjustmentReason")) {
                this.adjustmentReason = this.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals(ExplanationOfBenefit.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1977085293: {
                    return this.getAdjustment();
                }
                case -1255938543: {
                    return this.getAdjustmentReason();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1977085293: {
                    return new String[]{"Money"};
                }
                case -1255938543: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"date"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("adjustment")) {
                this.adjustment = new Money();
                return this.adjustment;
            }
            if (name.equals("adjustmentReason")) {
                this.adjustmentReason = new CodeableConcept();
                return this.adjustmentReason;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.date");
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals(ExplanationOfBenefit.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            return super.addChild(name);
        }

        @Override
        public PaymentComponent copy() {
            PaymentComponent dst = new PaymentComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.adjustment = this.adjustment == null ? null : this.adjustment.copy();
            dst.adjustmentReason = this.adjustmentReason == null ? null : this.adjustmentReason.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PaymentComponent)) {
                return false;
            }
            PaymentComponent o = (PaymentComponent)other_;
            return PaymentComponent.compareDeep(this.type, o.type, true) && PaymentComponent.compareDeep(this.adjustment, o.adjustment, true) && PaymentComponent.compareDeep(this.adjustmentReason, o.adjustmentReason, true) && PaymentComponent.compareDeep(this.date, o.date, true) && PaymentComponent.compareDeep(this.amount, o.amount, true) && PaymentComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PaymentComponent)) {
                return false;
            }
            PaymentComponent o = (PaymentComponent)other_;
            return PaymentComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.adjustment, this.adjustmentReason, this.date, this.amount, this.identifier});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.payment";
        }
    }

    @Block
    public static class TotalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication category such as submitted, co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Submitted, Co-Pay, deductible, eligible, benefit, tax, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication")
        protected CodeableConcept category;
        @Child(name="amount", type={Money.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monitory amount associated with the code.")
        protected Money amount;
        private static final long serialVersionUID = 2012310309L;

        public TotalComponent() {
        }

        public TotalComponent(CodeableConcept category, Money amount) {
            this.category = category;
            this.amount = amount;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TotalComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public TotalComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TotalComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public TotalComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Code indicating: Submitted, Co-Pay, deductible, eligible, benefit, tax, etc.", 0, 1, this.category));
            children.add(new Property("amount", "Money", "Monitory amount associated with the code.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code indicating: Submitted, Co-Pay, deductible, eligible, benefit, tax, etc.", 0, 1, this.category);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Monitory amount associated with the code.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public TotalComponent copy() {
            TotalComponent dst = new TotalComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TotalComponent)) {
                return false;
            }
            TotalComponent o = (TotalComponent)other_;
            return TotalComponent.compareDeep(this.category, o.category, true) && TotalComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TotalComponent)) {
                return false;
            }
            TotalComponent o = (TotalComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.amount});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.total";
        }
    }

    @Block
    public static class AddedItemDetailSubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="billcode", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="quantity", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        private static final long serialVersionUID = 374278167L;

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailSubDetailComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public AddedItemDetailSubDetailComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemDetailSubDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemDetailSubDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailSubDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemDetailSubDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailSubDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemDetailSubDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailSubDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemDetailSubDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemDetailSubDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemDetailSubDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemDetailSubDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailSubDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemDetailSubDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemDetailSubDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemDetailSubDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemDetailSubDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemDetailSubDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.net;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ExplanationOfBenefit.item.adjudication"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemDetailSubDetailComponent copy() {
            AddedItemDetailSubDetailComponent dst = new AddedItemDetailSubDetailComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemDetailSubDetailComponent)) {
                return false;
            }
            AddedItemDetailSubDetailComponent o = (AddedItemDetailSubDetailComponent)other_;
            return AddedItemDetailSubDetailComponent.compareDeep(this.billcode, o.billcode, true) && AddedItemDetailSubDetailComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemDetailSubDetailComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemDetailSubDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemDetailSubDetailComponent.compareDeep(this.factor, o.factor, true) && AddedItemDetailSubDetailComponent.compareDeep(this.net, o.net, true) && AddedItemDetailSubDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemDetailSubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemDetailSubDetailComponent)) {
                return false;
            }
            AddedItemDetailSubDetailComponent o = (AddedItemDetailSubDetailComponent)other_;
            return AddedItemDetailSubDetailComponent.compareValues(this.factor, o.factor, true) && AddedItemDetailSubDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.billcode, this.modifier, this.quantity, this.unitPrice, this.factor, this.net, this.noteNumber, this.adjudication});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.addItem.detail.subDetail";
        }
    }

    @Block
    public static class AddedItemDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="billcode", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="quantity", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Insurer added line items", formalDefinition="The third-tier service adjudications for payor added services.")
        protected List<AddedItemDetailSubDetailComponent> subDetail;
        private static final long serialVersionUID = -387896540L;

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public AddedItemDetailComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<AddedItemDetailSubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemDetailSubDetailComponent>();
            }
            return this.subDetail;
        }

        public AddedItemDetailComponent setSubDetail(List<AddedItemDetailSubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (AddedItemDetailSubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemDetailSubDetailComponent addSubDetail() {
            AddedItemDetailSubDetailComponent t = new AddedItemDetailSubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemDetailSubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public AddedItemDetailComponent addSubDetail(AddedItemDetailSubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemDetailSubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public AddedItemDetailSubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("subDetail", "", "The third-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -828829007: {
                    return new Property("subDetail", "", "The third-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.net;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((AddedItemDetailSubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((AddedItemDetailSubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ExplanationOfBenefit.item.adjudication"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemDetailComponent copy() {
            AddedItemDetailComponent dst = new AddedItemDetailComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<AddedItemDetailSubDetailComponent>();
                for (AddedItemDetailSubDetailComponent addedItemDetailSubDetailComponent : this.subDetail) {
                    dst.subDetail.add(addedItemDetailSubDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemDetailComponent)) {
                return false;
            }
            AddedItemDetailComponent o = (AddedItemDetailComponent)other_;
            return AddedItemDetailComponent.compareDeep(this.billcode, o.billcode, true) && AddedItemDetailComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemDetailComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemDetailComponent.compareDeep(this.factor, o.factor, true) && AddedItemDetailComponent.compareDeep(this.net, o.net, true) && AddedItemDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemDetailComponent.compareDeep(this.adjudication, o.adjudication, true) && AddedItemDetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemDetailComponent)) {
                return false;
            }
            AddedItemDetailComponent o = (AddedItemDetailComponent)other_;
            return AddedItemDetailComponent.compareValues(this.factor, o.factor, true) && AddedItemDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.billcode, this.modifier, this.quantity, this.unitPrice, this.factor, this.net, this.noteNumber, this.adjudication, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.addItem.detail";
        }
    }

    @Block
    public static class AddedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="itemSequence", type={PositiveIntType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service instances", formalDefinition="List of input service items which this service line is intended to replace.")
        protected List<PositiveIntType> itemSequence;
        @Child(name="detailSequence", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected List<PositiveIntType> detailSequence;
        @Child(name="subDetailSequence", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected List<PositiveIntType> subDetailSequence;
        @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Authorized providers", formalDefinition="The providers who are authorized for the services rendered to the patient.")
        protected List<Reference> provider;
        protected List<Resource> providerTarget;
        @Child(name="billcode", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="serviced", type={DateType.class, Period.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date or dates of Service", formalDefinition="The date or dates when the service or product was supplied, performed or completed.")
        protected Type serviced;
        @Child(name="location", type={CodeableConcept.class, Address.class, Location.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Place of service", formalDefinition="Where the service was provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-place")
        protected Type location;
        @Child(name="quantity", type={Quantity.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="bodySite", type={CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service Location", formalDefinition="Physical service site on the patient (limb, tooth, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/tooth")
        protected CodeableConcept bodySite;
        @Child(name="subSite", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service Sub-location", formalDefinition="A region or surface of the site, e.g. limb region or tooth surface(s).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/surface")
        protected List<CodeableConcept> subSite;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=16, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=17, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Insurer added line items", formalDefinition="The second-tier service adjudications for payor added services.")
        protected List<AddedItemDetailComponent> detail;
        private static final long serialVersionUID = 1857131999L;

        public List<PositiveIntType> getItemSequence() {
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            return this.itemSequence;
        }

        public AddedItemComponent setItemSequence(List<PositiveIntType> theItemSequence) {
            this.itemSequence = theItemSequence;
            return this;
        }

        public boolean hasItemSequence() {
            if (this.itemSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.itemSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addItemSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            this.itemSequence.add(t);
            return t;
        }

        public AddedItemComponent addItemSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            this.itemSequence.add(t);
            return this;
        }

        public boolean hasItemSequence(int value) {
            if (this.itemSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.itemSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getDetailSequence() {
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            return this.detailSequence;
        }

        public AddedItemComponent setDetailSequence(List<PositiveIntType> theDetailSequence) {
            this.detailSequence = theDetailSequence;
            return this;
        }

        public boolean hasDetailSequence() {
            if (this.detailSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.detailSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDetailSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            this.detailSequence.add(t);
            return t;
        }

        public AddedItemComponent addDetailSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            this.detailSequence.add(t);
            return this;
        }

        public boolean hasDetailSequence(int value) {
            if (this.detailSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.detailSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getSubDetailSequence() {
            if (this.subDetailSequence == null) {
                this.subDetailSequence = new ArrayList<PositiveIntType>();
            }
            return this.subDetailSequence;
        }

        public AddedItemComponent setSubDetailSequence(List<PositiveIntType> theSubDetailSequence) {
            this.subDetailSequence = theSubDetailSequence;
            return this;
        }

        public boolean hasSubDetailSequence() {
            if (this.subDetailSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.subDetailSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addSubDetailSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.subDetailSequence == null) {
                this.subDetailSequence = new ArrayList<PositiveIntType>();
            }
            this.subDetailSequence.add(t);
            return t;
        }

        public AddedItemComponent addSubDetailSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.subDetailSequence == null) {
                this.subDetailSequence = new ArrayList<PositiveIntType>();
            }
            this.subDetailSequence.add(t);
            return this;
        }

        public boolean hasSubDetailSequence(int value) {
            if (this.subDetailSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.subDetailSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Reference> getProvider() {
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            return this.provider;
        }

        public AddedItemComponent setProvider(List<Reference> theProvider) {
            this.provider = theProvider;
            return this;
        }

        public boolean hasProvider() {
            if (this.provider == null) {
                return false;
            }
            for (Reference item : this.provider) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addProvider() {
            Reference t = new Reference();
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            this.provider.add(t);
            return t;
        }

        public AddedItemComponent addProvider(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            this.provider.add(t);
            return this;
        }

        public Reference getProviderFirstRep() {
            if (this.getProvider().isEmpty()) {
                this.addProvider();
            }
            return this.getProvider().get(0);
        }

        @Deprecated
        public List<Resource> getProviderTarget() {
            if (this.providerTarget == null) {
                this.providerTarget = new ArrayList<Resource>();
            }
            return this.providerTarget;
        }

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public AddedItemComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public AddedItemComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public AddedItemComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Type getServiced() {
            return this.serviced;
        }

        public DateType getServicedDateType() throws FHIRException {
            if (this.serviced == null) {
                return null;
            }
            if (!(this.serviced instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (DateType)this.serviced;
        }

        public boolean hasServicedDateType() {
            return this != null && this.serviced instanceof DateType;
        }

        public Period getServicedPeriod() throws FHIRException {
            if (this.serviced == null) {
                return null;
            }
            if (!(this.serviced instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (Period)this.serviced;
        }

        public boolean hasServicedPeriod() {
            return this != null && this.serviced instanceof Period;
        }

        public boolean hasServiced() {
            return this.serviced != null && !this.serviced.isEmpty();
        }

        public AddedItemComponent setServiced(Type value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new Error("Not the right type for ExplanationOfBenefit.addItem.serviced[x]: " + value.fhirType());
            }
            this.serviced = value;
            return this;
        }

        public Type getLocation() {
            return this.location;
        }

        public CodeableConcept getLocationCodeableConcept() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.location;
        }

        public boolean hasLocationCodeableConcept() {
            return this != null && this.location instanceof CodeableConcept;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AddedItemComponent setLocation(Type value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Address || value instanceof Reference)) {
                throw new Error("Not the right type for ExplanationOfBenefit.addItem.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public CodeableConcept getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableConcept();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public AddedItemComponent setBodySite(CodeableConcept value) {
            this.bodySite = value;
            return this;
        }

        public List<CodeableConcept> getSubSite() {
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            return this.subSite;
        }

        public AddedItemComponent setSubSite(List<CodeableConcept> theSubSite) {
            this.subSite = theSubSite;
            return this;
        }

        public boolean hasSubSite() {
            if (this.subSite == null) {
                return false;
            }
            for (CodeableConcept item : this.subSite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSubSite() {
            CodeableConcept t = new CodeableConcept();
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return t;
        }

        public AddedItemComponent addSubSite(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return this;
        }

        public CodeableConcept getSubSiteFirstRep() {
            if (this.getSubSite().isEmpty()) {
                this.addSubSite();
            }
            return this.getSubSite().get(0);
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<AddedItemDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            return this.detail;
        }

        public AddedItemComponent setDetail(List<AddedItemDetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (AddedItemDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemDetailComponent addDetail() {
            AddedItemDetailComponent t = new AddedItemDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public AddedItemComponent addDetail(AddedItemDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public AddedItemDetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("itemSequence", "positiveInt", "List of input service items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.itemSequence));
            children.add(new Property("detailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.detailSequence));
            children.add(new Property("subDetailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.subDetailSequence));
            children.add(new Property(ExplanationOfBenefit.SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The providers who are authorized for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
            children.add(new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced));
            children.add(new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc.).", 0, 1, this.bodySite));
            children.add(new Property("subSite", "CodeableConcept", "A region or surface of the site, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("detail", "", "The second-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1977979892: {
                    return new Property("itemSequence", "positiveInt", "List of input service items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.itemSequence);
                }
                case 1321472818: {
                    return new Property("detailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.detailSequence);
                }
                case -855462510: {
                    return new Property("subDetailSequence", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.subDetailSequence);
                }
                case -987494927: {
                    return new Property(ExplanationOfBenefit.SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The providers who are authorized for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider);
                }
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "For programs which require reason codes for the inclusion or covering of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1927922223: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1379209295: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 363246749: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1534966512: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 552316075: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1224800468: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case 1702620169: {
                    return new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc.).", 0, 1, this.bodySite);
                }
                case -1868566105: {
                    return new Property("subSite", "CodeableConcept", "A region or surface of the site, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -1335224239: {
                    return new Property("detail", "", "The second-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.itemSequence == null ? new Base[]{} : this.itemSequence.toArray(new Base[this.itemSequence.size()]);
                }
                case 1321472818: {
                    return this.detailSequence == null ? new Base[]{} : this.detailSequence.toArray(new Base[this.detailSequence.size()]);
                }
                case -855462510: {
                    return this.subDetailSequence == null ? new Base[]{} : this.subDetailSequence.toArray(new Base[this.subDetailSequence.size()]);
                }
                case -987494927: {
                    return this.provider == null ? new Base[]{} : this.provider.toArray(new Base[this.provider.size()]);
                }
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case 1379209295: {
                    Base[] baseArray;
                    if (this.serviced == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.serviced;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.location;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.net;
                    }
                    return baseArray;
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -1868566105: {
                    return this.subSite == null ? new Base[]{} : this.subSite.toArray(new Base[this.subSite.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    this.getItemSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case 1321472818: {
                    this.getDetailSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -855462510: {
                    this.getSubDetailSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -987494927: {
                    this.getProvider().add(this.castToReference(value));
                    return value;
                }
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1379209295: {
                    this.serviced = this.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToType(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 1702620169: {
                    this.bodySite = this.castToCodeableConcept(value);
                    return value;
                }
                case -1868566105: {
                    this.getSubSite().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((AddedItemDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.getItemSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("detailSequence")) {
                this.getDetailSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("subDetailSequence")) {
                this.getSubDetailSequence().add(this.castToPositiveInt(value));
            } else if (name.equals(ExplanationOfBenefit.SP_PROVIDER)) {
                this.getProvider().add(this.castToReference(value));
            } else if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("serviced[x]")) {
                this.serviced = this.castToType(value);
            } else if (name.equals("location[x]")) {
                this.location = this.castToType(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCodeableConcept(value);
            } else if (name.equals("subSite")) {
                this.getSubSite().add(this.castToCodeableConcept(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((AddedItemDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.addItemSequenceElement();
                }
                case 1321472818: {
                    return this.addDetailSequenceElement();
                }
                case -855462510: {
                    return this.addSubDetailSequenceElement();
                }
                case -987494927: {
                    return this.addProvider();
                }
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1927922223: {
                    return this.getServiced();
                }
                case 1379209295: {
                    return this.getServiced();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -1868566105: {
                    return this.addSubSite();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return new String[]{"positiveInt"};
                }
                case 1321472818: {
                    return new String[]{"positiveInt"};
                }
                case -855462510: {
                    return new String[]{"positiveInt"};
                }
                case -987494927: {
                    return new String[]{"Reference"};
                }
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case 1379209295: {
                    return new String[]{"date", "Period"};
                }
                case 1901043637: {
                    return new String[]{"CodeableConcept", "Address", "Reference"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 1702620169: {
                    return new String[]{"CodeableConcept"};
                }
                case -1868566105: {
                    return new String[]{"CodeableConcept"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ExplanationOfBenefit.item.adjudication"};
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.itemSequence");
            }
            if (name.equals("detailSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.detailSequence");
            }
            if (name.equals("subDetailSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.subDetailSequence");
            }
            if (name.equals(ExplanationOfBenefit.SP_PROVIDER)) {
                return this.addProvider();
            }
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("servicedDate")) {
                this.serviced = new DateType();
                return this.serviced;
            }
            if (name.equals("servicedPeriod")) {
                this.serviced = new Period();
                return this.serviced;
            }
            if (name.equals("locationCodeableConcept")) {
                this.location = new CodeableConcept();
                return this.location;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableConcept();
                return this.bodySite;
            }
            if (name.equals("subSite")) {
                return this.addSubSite();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemComponent copy() {
            AddedItemComponent dst = new AddedItemComponent();
            this.copyValues(dst);
            if (this.itemSequence != null) {
                dst.itemSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.itemSequence) {
                    dst.itemSequence.add(positiveIntType.copy());
                }
            }
            if (this.detailSequence != null) {
                dst.detailSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.detailSequence) {
                    dst.detailSequence.add(positiveIntType.copy());
                }
            }
            if (this.subDetailSequence != null) {
                dst.subDetailSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.subDetailSequence) {
                    dst.subDetailSequence.add(positiveIntType.copy());
                }
            }
            if (this.provider != null) {
                dst.provider = new ArrayList<Reference>();
                for (Reference reference : this.provider) {
                    dst.provider.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.serviced = this.serviced == null ? null : this.serviced.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.net = this.net == null ? null : this.net.copy();
            CodeableConcept codeableConcept4 = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            if (this.subSite != null) {
                dst.subSite = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept5 : this.subSite) {
                    dst.subSite.add(codeableConcept5.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<AddedItemDetailComponent>();
                for (AddedItemDetailComponent addedItemDetailComponent : this.detail) {
                    dst.detail.add(addedItemDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other_;
            return AddedItemComponent.compareDeep(this.itemSequence, o.itemSequence, true) && AddedItemComponent.compareDeep(this.detailSequence, o.detailSequence, true) && AddedItemComponent.compareDeep(this.subDetailSequence, o.subDetailSequence, true) && AddedItemComponent.compareDeep(this.provider, o.provider, true) && AddedItemComponent.compareDeep(this.billcode, o.billcode, true) && AddedItemComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemComponent.compareDeep(this.programCode, o.programCode, true) && AddedItemComponent.compareDeep(this.serviced, o.serviced, true) && AddedItemComponent.compareDeep(this.location, o.location, true) && AddedItemComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemComponent.compareDeep(this.factor, o.factor, true) && AddedItemComponent.compareDeep(this.net, o.net, true) && AddedItemComponent.compareDeep(this.bodySite, o.bodySite, true) && AddedItemComponent.compareDeep(this.subSite, o.subSite, true) && AddedItemComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemComponent.compareDeep(this.adjudication, o.adjudication, true) && AddedItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other_;
            return AddedItemComponent.compareValues(this.itemSequence, o.itemSequence, true) && AddedItemComponent.compareValues(this.detailSequence, o.detailSequence, true) && AddedItemComponent.compareValues(this.subDetailSequence, o.subDetailSequence, true) && AddedItemComponent.compareValues(this.factor, o.factor, true) && AddedItemComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.itemSequence, this.detailSequence, this.subDetailSequence, this.provider, this.billcode, this.modifier, this.programCode, this.serviced, this.location, this.quantity, this.unitPrice, this.factor, this.net, this.bodySite, this.subSite, this.noteNumber, this.adjudication, this.detail});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.addItem";
        }
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="revenue", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of service or product", formalDefinition="Health Care Service Type Codes to identify the classification of service or benefits.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="billcode", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="A code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="quantity", type={Quantity.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="The fee for an addittional service or product or charge.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Net additional item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Language if different from the resource", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        private static final long serialVersionUID = -319838820L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(PositiveIntType sequence) {
            this.sequence = sequence;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SubDetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SubDetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public SubDetailComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SubDetailComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public SubDetailComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public SubDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public SubDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public SubDetailComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public SubDetailComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public SubDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public SubDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public SubDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public SubDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public SubDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public SubDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public SubDetailComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public SubDetailComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public SubDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public SubDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public SubDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public SubDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Health Care Service Type Codes to identify the classification of service or benefits.", 0, 1, this.category));
            children.add(new Property("billcode", "CodeableConcept", "A code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI).", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "The fee for an addittional service or product or charge.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Health Care Service Type Codes to identify the classification of service or benefits.", 0, 1, this.category);
                }
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "A code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI).", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "The fee for an addittional service or product or charge.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ExplanationOfBenefit.item.adjudication"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareDeep(this.sequence, o.sequence, true) && SubDetailComponent.compareDeep(this.revenue, o.revenue, true) && SubDetailComponent.compareDeep(this.category, o.category, true) && SubDetailComponent.compareDeep(this.billcode, o.billcode, true) && SubDetailComponent.compareDeep(this.modifier, o.modifier, true) && SubDetailComponent.compareDeep(this.programCode, o.programCode, true) && SubDetailComponent.compareDeep(this.quantity, o.quantity, true) && SubDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && SubDetailComponent.compareDeep(this.factor, o.factor, true) && SubDetailComponent.compareDeep(this.net, o.net, true) && SubDetailComponent.compareDeep(this.udi, o.udi, true) && SubDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && SubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareValues(this.sequence, o.sequence, true) && SubDetailComponent.compareValues(this.factor, o.factor, true) && SubDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.revenue, this.category, this.billcode, this.modifier, this.programCode, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.noteNumber, this.adjudication});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.detail.subDetail";
        }
    }

    @Block
    public static class DetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="revenue", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of service or product", formalDefinition="Health Care Service Type Codes to identify the classification of service or benefits.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="billcode", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="quantity", type={Quantity.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total additional item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail level adjudication details", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional items", formalDefinition="Third-tier of goods and services.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = -299169019L;

        public DetailComponent() {
        }

        public DetailComponent(PositiveIntType sequence) {
            this.sequence = sequence;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public DetailComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public DetailComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public DetailComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public DetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public DetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public DetailComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public DetailComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public DetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public DetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public DetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public DetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public DetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public DetailComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public DetailComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public DetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public DetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public DetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public DetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public DetailComponent setSubDetail(List<SubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public DetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public SubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Health Care Service Type Codes to identify the classification of service or benefits.", 0, 1, this.category));
            children.add(new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("subDetail", "", "Third-tier of goods and services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Health Care Service Type Codes to identify the classification of service or benefits.", 0, 1, this.category);
                }
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "@ExplanationOfBenefit.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -828829007: {
                    return new Property("subDetail", "", "Third-tier of goods and services.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((SubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[]{"@ExplanationOfBenefit.item.adjudication"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public DetailComponent copy() {
            DetailComponent dst = new DetailComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent subDetailComponent : this.subDetail) {
                    dst.subDetail.add(subDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other_;
            return DetailComponent.compareDeep(this.sequence, o.sequence, true) && DetailComponent.compareDeep(this.revenue, o.revenue, true) && DetailComponent.compareDeep(this.category, o.category, true) && DetailComponent.compareDeep(this.billcode, o.billcode, true) && DetailComponent.compareDeep(this.modifier, o.modifier, true) && DetailComponent.compareDeep(this.programCode, o.programCode, true) && DetailComponent.compareDeep(this.quantity, o.quantity, true) && DetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && DetailComponent.compareDeep(this.factor, o.factor, true) && DetailComponent.compareDeep(this.net, o.net, true) && DetailComponent.compareDeep(this.udi, o.udi, true) && DetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && DetailComponent.compareDeep(this.adjudication, o.adjudication, true) && DetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other_;
            return DetailComponent.compareValues(this.sequence, o.sequence, true) && DetailComponent.compareValues(this.factor, o.factor, true) && DetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.revenue, this.category, this.billcode, this.modifier, this.programCode, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.noteNumber, this.adjudication, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.detail";
        }
    }

    @Block
    public static class AdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication")
        protected CodeableConcept category;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation of Adjudication outcome", formalDefinition="Adjudication reason such as limit reached.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-reason")
        protected CodeableConcept reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monitory amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Non-monitory value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = 1559898786L;

        public AdjudicationComponent() {
        }

        public AdjudicationComponent(CodeableConcept category) {
            this.category = category;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public AdjudicationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public AdjudicationComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public AdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        public AdjudicationComponent setValue(long value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        public AdjudicationComponent setValue(double value) {
            this.value = new DecimalType();
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.", 0, 1, this.category));
            children.add(new Property("reason", "CodeableConcept", "Adjudication reason such as limit reached.", 0, 1, this.reason));
            children.add(new Property("amount", "Money", "Monitory amount associated with the code.", 0, 1, this.amount));
            children.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code indicating: Co-Pay, deductable, elegible, benefit, tax, etc.", 0, 1, this.category);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Adjudication reason such as limit reached.", 0, 1, this.reason);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Monitory amount associated with the code.", 0, 1, this.amount);
                }
                case 111972721: {
                    return new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.reason = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
                case 111972721: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.value");
            }
            return super.addChild(name);
        }

        @Override
        public AdjudicationComponent copy() {
            AdjudicationComponent dst = new AdjudicationComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdjudicationComponent)) {
                return false;
            }
            AdjudicationComponent o = (AdjudicationComponent)other_;
            return AdjudicationComponent.compareDeep(this.category, o.category, true) && AdjudicationComponent.compareDeep(this.reason, o.reason, true) && AdjudicationComponent.compareDeep(this.amount, o.amount, true) && AdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdjudicationComponent)) {
                return false;
            }
            AdjudicationComponent o = (AdjudicationComponent)other_;
            return AdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.reason, this.amount, this.value});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item.adjudication";
        }
    }

    @Block
    public static class ItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequence;
        @Child(name="careTeamSequence", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable careteam members", formalDefinition="Careteam applicable for this service or product line.")
        protected List<PositiveIntType> careTeamSequence;
        @Child(name="diagnosisSequence", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable diagnoses", formalDefinition="Diagnosis applicable for this service or product line.")
        protected List<PositiveIntType> diagnosisSequence;
        @Child(name="procedureSequence", type={PositiveIntType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable procedures", formalDefinition="Procedures applicable for this service or product line.")
        protected List<PositiveIntType> procedureSequence;
        @Child(name="informationSequence", type={PositiveIntType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable exception and supporting information", formalDefinition="Exceptions, special conditions and supporting information pplicable for this service or product line.")
        protected List<PositiveIntType> informationSequence;
        @Child(name="revenue", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of service or product", formalDefinition="Health Care Service Type Codes  to identify the classification of service or benefits.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="billcode", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing Code", formalDefinition="If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept billcode;
        @Child(name="modifier", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program specific reason for item inclusion", formalDefinition="For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="serviced", type={DateType.class, Period.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date or dates of Service", formalDefinition="The date or dates when the service or product was supplied, performed or completed.")
        protected Type serviced;
        @Child(name="location", type={CodeableConcept.class, Address.class, Location.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Place of service", formalDefinition="Where the service was provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-place")
        protected Type location;
        @Child(name="quantity", type={Quantity.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Products or Services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per point", formalDefinition="If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=17, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique Device Identifier", formalDefinition="List of Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="bodySite", type={CodeableConcept.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service Location", formalDefinition="Physical service site on the patient (limb, tooth, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/tooth")
        protected CodeableConcept bodySite;
        @Child(name="subSite", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service Sub-location", formalDefinition="A region or surface of the site, e.g. limb region or tooth surface(s).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/surface")
        protected List<CodeableConcept> subSite;
        @Child(name="encounter", type={Encounter.class}, order=20, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Encounters related to this billed item", formalDefinition="A billed item may include goods or services provided in multiple encounters.")
        protected List<Reference> encounter;
        protected List<Encounter> encounterTarget;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=21, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication details", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional items", formalDefinition="Second-tier of goods and services.")
        protected List<DetailComponent> detail;
        private static final long serialVersionUID = -987069984L;

        public ItemComponent() {
        }

        public ItemComponent(PositiveIntType sequence) {
            this.sequence = sequence;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ItemComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ItemComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getCareTeamSequence() {
            if (this.careTeamSequence == null) {
                this.careTeamSequence = new ArrayList<PositiveIntType>();
            }
            return this.careTeamSequence;
        }

        public ItemComponent setCareTeamSequence(List<PositiveIntType> theCareTeamSequence) {
            this.careTeamSequence = theCareTeamSequence;
            return this;
        }

        public boolean hasCareTeamSequence() {
            if (this.careTeamSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.careTeamSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addCareTeamSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.careTeamSequence == null) {
                this.careTeamSequence = new ArrayList<PositiveIntType>();
            }
            this.careTeamSequence.add(t);
            return t;
        }

        public ItemComponent addCareTeamSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.careTeamSequence == null) {
                this.careTeamSequence = new ArrayList<PositiveIntType>();
            }
            this.careTeamSequence.add(t);
            return this;
        }

        public boolean hasCareTeamSequence(int value) {
            if (this.careTeamSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.careTeamSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getDiagnosisSequence() {
            if (this.diagnosisSequence == null) {
                this.diagnosisSequence = new ArrayList<PositiveIntType>();
            }
            return this.diagnosisSequence;
        }

        public ItemComponent setDiagnosisSequence(List<PositiveIntType> theDiagnosisSequence) {
            this.diagnosisSequence = theDiagnosisSequence;
            return this;
        }

        public boolean hasDiagnosisSequence() {
            if (this.diagnosisSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.diagnosisSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDiagnosisSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.diagnosisSequence == null) {
                this.diagnosisSequence = new ArrayList<PositiveIntType>();
            }
            this.diagnosisSequence.add(t);
            return t;
        }

        public ItemComponent addDiagnosisSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.diagnosisSequence == null) {
                this.diagnosisSequence = new ArrayList<PositiveIntType>();
            }
            this.diagnosisSequence.add(t);
            return this;
        }

        public boolean hasDiagnosisSequence(int value) {
            if (this.diagnosisSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.diagnosisSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getProcedureSequence() {
            if (this.procedureSequence == null) {
                this.procedureSequence = new ArrayList<PositiveIntType>();
            }
            return this.procedureSequence;
        }

        public ItemComponent setProcedureSequence(List<PositiveIntType> theProcedureSequence) {
            this.procedureSequence = theProcedureSequence;
            return this;
        }

        public boolean hasProcedureSequence() {
            if (this.procedureSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.procedureSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addProcedureSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.procedureSequence == null) {
                this.procedureSequence = new ArrayList<PositiveIntType>();
            }
            this.procedureSequence.add(t);
            return t;
        }

        public ItemComponent addProcedureSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.procedureSequence == null) {
                this.procedureSequence = new ArrayList<PositiveIntType>();
            }
            this.procedureSequence.add(t);
            return this;
        }

        public boolean hasProcedureSequence(int value) {
            if (this.procedureSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.procedureSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getInformationSequence() {
            if (this.informationSequence == null) {
                this.informationSequence = new ArrayList<PositiveIntType>();
            }
            return this.informationSequence;
        }

        public ItemComponent setInformationSequence(List<PositiveIntType> theInformationSequence) {
            this.informationSequence = theInformationSequence;
            return this;
        }

        public boolean hasInformationSequence() {
            if (this.informationSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.informationSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addInformationSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.informationSequence == null) {
                this.informationSequence = new ArrayList<PositiveIntType>();
            }
            this.informationSequence.add(t);
            return t;
        }

        public ItemComponent addInformationSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.informationSequence == null) {
                this.informationSequence = new ArrayList<PositiveIntType>();
            }
            this.informationSequence.add(t);
            return this;
        }

        public boolean hasInformationSequence(int value) {
            if (this.informationSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.informationSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public ItemComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ItemComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getBillcode() {
            if (this.billcode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.billcode");
                }
                if (Configuration.doAutoCreate()) {
                    this.billcode = new CodeableConcept();
                }
            }
            return this.billcode;
        }

        public boolean hasBillcode() {
            return this.billcode != null && !this.billcode.isEmpty();
        }

        public ItemComponent setBillcode(CodeableConcept value) {
            this.billcode = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public ItemComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public ItemComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public ItemComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public ItemComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Type getServiced() {
            return this.serviced;
        }

        public DateType getServicedDateType() throws FHIRException {
            if (this.serviced == null) {
                return null;
            }
            if (!(this.serviced instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (DateType)this.serviced;
        }

        public boolean hasServicedDateType() {
            return this != null && this.serviced instanceof DateType;
        }

        public Period getServicedPeriod() throws FHIRException {
            if (this.serviced == null) {
                return null;
            }
            if (!(this.serviced instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (Period)this.serviced;
        }

        public boolean hasServicedPeriod() {
            return this != null && this.serviced instanceof Period;
        }

        public boolean hasServiced() {
            return this.serviced != null && !this.serviced.isEmpty();
        }

        public ItemComponent setServiced(Type value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new Error("Not the right type for ExplanationOfBenefit.item.serviced[x]: " + value.fhirType());
            }
            this.serviced = value;
            return this;
        }

        public Type getLocation() {
            return this.location;
        }

        public CodeableConcept getLocationCodeableConcept() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.location;
        }

        public boolean hasLocationCodeableConcept() {
            return this != null && this.location instanceof CodeableConcept;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public ItemComponent setLocation(Type value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Address || value instanceof Reference)) {
                throw new Error("Not the right type for ExplanationOfBenefit.item.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public ItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public ItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public ItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public ItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public ItemComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public ItemComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public CodeableConcept getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableConcept();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public ItemComponent setBodySite(CodeableConcept value) {
            this.bodySite = value;
            return this;
        }

        public List<CodeableConcept> getSubSite() {
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            return this.subSite;
        }

        public ItemComponent setSubSite(List<CodeableConcept> theSubSite) {
            this.subSite = theSubSite;
            return this;
        }

        public boolean hasSubSite() {
            if (this.subSite == null) {
                return false;
            }
            for (CodeableConcept item : this.subSite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSubSite() {
            CodeableConcept t = new CodeableConcept();
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return t;
        }

        public ItemComponent addSubSite(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return this;
        }

        public CodeableConcept getSubSiteFirstRep() {
            if (this.getSubSite().isEmpty()) {
                this.addSubSite();
            }
            return this.getSubSite().get(0);
        }

        public List<Reference> getEncounter() {
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            return this.encounter;
        }

        public ItemComponent setEncounter(List<Reference> theEncounter) {
            this.encounter = theEncounter;
            return this;
        }

        public boolean hasEncounter() {
            if (this.encounter == null) {
                return false;
            }
            for (Reference item : this.encounter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEncounter() {
            Reference t = new Reference();
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            this.encounter.add(t);
            return t;
        }

        public ItemComponent addEncounter(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            this.encounter.add(t);
            return this;
        }

        public Reference getEncounterFirstRep() {
            if (this.getEncounter().isEmpty()) {
                this.addEncounter();
            }
            return this.getEncounter().get(0);
        }

        @Deprecated
        public List<Encounter> getEncounterTarget() {
            if (this.encounterTarget == null) {
                this.encounterTarget = new ArrayList<Encounter>();
            }
            return this.encounterTarget;
        }

        @Deprecated
        public Encounter addEncounterTarget() {
            Encounter r = new Encounter();
            if (this.encounterTarget == null) {
                this.encounterTarget = new ArrayList<Encounter>();
            }
            this.encounterTarget.add(r);
            return r;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public ItemComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public ItemComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<DetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            return this.detail;
        }

        public ItemComponent setDetail(List<DetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (DetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DetailComponent addDetail() {
            DetailComponent t = new DetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemComponent addDetail(DetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public DetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence));
            children.add(new Property("careTeamSequence", "positiveInt", "Careteam applicable for this service or product line.", 0, Integer.MAX_VALUE, this.careTeamSequence));
            children.add(new Property("diagnosisSequence", "positiveInt", "Diagnosis applicable for this service or product line.", 0, Integer.MAX_VALUE, this.diagnosisSequence));
            children.add(new Property("procedureSequence", "positiveInt", "Procedures applicable for this service or product line.", 0, Integer.MAX_VALUE, this.procedureSequence));
            children.add(new Property("informationSequence", "positiveInt", "Exceptions, special conditions and supporting information pplicable for this service or product line.", 0, Integer.MAX_VALUE, this.informationSequence));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Health Care Service Type Codes  to identify the classification of service or benefits.", 0, 1, this.category));
            children.add(new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced));
            children.add(new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            children.add(new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc.).", 0, 1, this.bodySite));
            children.add(new Property("subSite", "CodeableConcept", "A region or surface of the site, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite));
            children.add(new Property(ExplanationOfBenefit.SP_ENCOUNTER, "Reference(Encounter)", "A billed item may include goods or services provided in multiple encounters.", 0, Integer.MAX_VALUE, this.encounter));
            children.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("adjudication", "", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("detail", "", "Second-tier of goods and services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A service line number.", 0, 1, this.sequence);
                }
                case 1070083823: {
                    return new Property("careTeamSequence", "positiveInt", "Careteam applicable for this service or product line.", 0, Integer.MAX_VALUE, this.careTeamSequence);
                }
                case -909769262: {
                    return new Property("diagnosisSequence", "positiveInt", "Diagnosis applicable for this service or product line.", 0, Integer.MAX_VALUE, this.diagnosisSequence);
                }
                case -808920140: {
                    return new Property("procedureSequence", "positiveInt", "Procedures applicable for this service or product line.", 0, Integer.MAX_VALUE, this.procedureSequence);
                }
                case -702585587: {
                    return new Property("informationSequence", "positiveInt", "Exceptions, special conditions and supporting information pplicable for this service or product line.", 0, Integer.MAX_VALUE, this.informationSequence);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Health Care Service Type Codes  to identify the classification of service or benefits.", 0, 1, this.category);
                }
                case 890074740: {
                    return new Property("billcode", "CodeableConcept", "If this is an actual service or product line, i.e. not a Group, then use code to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,USCLS,ICD10, NCPDP,DIN,ACHI,CCI). If a grouping item then use a group code to indicate the type of thing being grouped eg. 'glasses' or 'compound'.", 0, 1, this.billcode);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes, e.g. for Oral whether the treatment is cosmetic or associated with TMJ, or for medical whether the treatment was outside the clinic or out of office hours.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "For programs which require reson codes for the inclusion, covering, of this billed item under the program or sub-program.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1927922223: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1379209295: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 363246749: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1534966512: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 552316075: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1224800468: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the service was provided.", 0, 1, this.location);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is a node then this is the fee for the product or service, otherwise this is the total of the fees for the children of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "List of Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
                case 1702620169: {
                    return new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc.).", 0, 1, this.bodySite);
                }
                case -1868566105: {
                    return new Property("subSite", "CodeableConcept", "A region or surface of the site, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite);
                }
                case 1524132147: {
                    return new Property(ExplanationOfBenefit.SP_ENCOUNTER, "Reference(Encounter)", "A billed item may include goods or services provided in multiple encounters.", 0, Integer.MAX_VALUE, this.encounter);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -231349275: {
                    return new Property("adjudication", "", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -1335224239: {
                    return new Property("detail", "", "Second-tier of goods and services.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1070083823: {
                    return this.careTeamSequence == null ? new Base[]{} : this.careTeamSequence.toArray(new Base[this.careTeamSequence.size()]);
                }
                case -909769262: {
                    return this.diagnosisSequence == null ? new Base[]{} : this.diagnosisSequence.toArray(new Base[this.diagnosisSequence.size()]);
                }
                case -808920140: {
                    return this.procedureSequence == null ? new Base[]{} : this.procedureSequence.toArray(new Base[this.procedureSequence.size()]);
                }
                case -702585587: {
                    return this.informationSequence == null ? new Base[]{} : this.informationSequence.toArray(new Base[this.informationSequence.size()]);
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 890074740: {
                    Base[] baseArray;
                    if (this.billcode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.billcode;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case 1379209295: {
                    Base[] baseArray;
                    if (this.serviced == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.serviced;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.location;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -1868566105: {
                    return this.subSite == null ? new Base[]{} : this.subSite.toArray(new Base[this.subSite.size()]);
                }
                case 1524132147: {
                    return this.encounter == null ? new Base[]{} : this.encounter.toArray(new Base[this.encounter.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1070083823: {
                    this.getCareTeamSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -909769262: {
                    this.getDiagnosisSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -808920140: {
                    this.getProcedureSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -702585587: {
                    this.getInformationSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 890074740: {
                    this.billcode = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1379209295: {
                    this.serviced = this.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToType(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
                case 1702620169: {
                    this.bodySite = this.castToCodeableConcept(value);
                    return value;
                }
                case -1868566105: {
                    this.getSubSite().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1524132147: {
                    this.getEncounter().add(this.castToReference(value));
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(this.castToPositiveInt(value));
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((DetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("careTeamSequence")) {
                this.getCareTeamSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("diagnosisSequence")) {
                this.getDiagnosisSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("procedureSequence")) {
                this.getProcedureSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("informationSequence")) {
                this.getInformationSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("billcode")) {
                this.billcode = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("serviced[x]")) {
                this.serviced = this.castToType(value);
            } else if (name.equals("location[x]")) {
                this.location = this.castToType(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCodeableConcept(value);
            } else if (name.equals("subSite")) {
                this.getSubSite().add(this.castToCodeableConcept(value));
            } else if (name.equals(ExplanationOfBenefit.SP_ENCOUNTER)) {
                this.getEncounter().add(this.castToReference(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((DetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1070083823: {
                    return this.addCareTeamSequenceElement();
                }
                case -909769262: {
                    return this.addDiagnosisSequenceElement();
                }
                case -808920140: {
                    return this.addProcedureSequenceElement();
                }
                case -702585587: {
                    return this.addInformationSequenceElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 890074740: {
                    return this.getBillcode();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1927922223: {
                    return this.getServiced();
                }
                case 1379209295: {
                    return this.getServiced();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -1868566105: {
                    return this.addSubSite();
                }
                case 1524132147: {
                    return this.addEncounter();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1070083823: {
                    return new String[]{"positiveInt"};
                }
                case -909769262: {
                    return new String[]{"positiveInt"};
                }
                case -808920140: {
                    return new String[]{"positiveInt"};
                }
                case -702585587: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 890074740: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case 1379209295: {
                    return new String[]{"date", "Period"};
                }
                case 1901043637: {
                    return new String[]{"CodeableConcept", "Address", "Reference"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
                case 1702620169: {
                    return new String[]{"CodeableConcept"};
                }
                case -1868566105: {
                    return new String[]{"CodeableConcept"};
                }
                case 1524132147: {
                    return new String[]{"Reference"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -231349275: {
                    return new String[0];
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("careTeamSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.careTeamSequence");
            }
            if (name.equals("diagnosisSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.diagnosisSequence");
            }
            if (name.equals("procedureSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.procedureSequence");
            }
            if (name.equals("informationSequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.informationSequence");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("billcode")) {
                this.billcode = new CodeableConcept();
                return this.billcode;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("servicedDate")) {
                this.serviced = new DateType();
                return this.serviced;
            }
            if (name.equals("servicedPeriod")) {
                this.serviced = new Period();
                return this.serviced;
            }
            if (name.equals("locationCodeableConcept")) {
                this.location = new CodeableConcept();
                return this.location;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableConcept();
                return this.bodySite;
            }
            if (name.equals("subSite")) {
                return this.addSubSite();
            }
            if (name.equals(ExplanationOfBenefit.SP_ENCOUNTER)) {
                return this.addEncounter();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemComponent copy() {
            ItemComponent dst = new ItemComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequence = this.sequence == null ? null : this.sequence.copy();
            if (this.careTeamSequence != null) {
                dst.careTeamSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.careTeamSequence) {
                    dst.careTeamSequence.add(positiveIntType2.copy());
                }
            }
            if (this.diagnosisSequence != null) {
                dst.diagnosisSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType3 : this.diagnosisSequence) {
                    dst.diagnosisSequence.add(positiveIntType3.copy());
                }
            }
            if (this.procedureSequence != null) {
                dst.procedureSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType4 : this.procedureSequence) {
                    dst.procedureSequence.add(positiveIntType4.copy());
                }
            }
            if (this.informationSequence != null) {
                dst.informationSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType5 : this.informationSequence) {
                    dst.informationSequence.add(positiveIntType5.copy());
                }
            }
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.billcode = this.billcode == null ? null : this.billcode.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.serviced = this.serviced == null ? null : this.serviced.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept4 = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            if (this.subSite != null) {
                dst.subSite = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept5 : this.subSite) {
                    dst.subSite.add(codeableConcept5.copy());
                }
            }
            if (this.encounter != null) {
                dst.encounter = new ArrayList<Reference>();
                for (Reference reference : this.encounter) {
                    dst.encounter.add(reference.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType6 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType6.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<DetailComponent>();
                for (DetailComponent detailComponent : this.detail) {
                    dst.detail.add(detailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareDeep(this.sequence, o.sequence, true) && ItemComponent.compareDeep(this.careTeamSequence, o.careTeamSequence, true) && ItemComponent.compareDeep(this.diagnosisSequence, o.diagnosisSequence, true) && ItemComponent.compareDeep(this.procedureSequence, o.procedureSequence, true) && ItemComponent.compareDeep(this.informationSequence, o.informationSequence, true) && ItemComponent.compareDeep(this.revenue, o.revenue, true) && ItemComponent.compareDeep(this.category, o.category, true) && ItemComponent.compareDeep(this.billcode, o.billcode, true) && ItemComponent.compareDeep(this.modifier, o.modifier, true) && ItemComponent.compareDeep(this.programCode, o.programCode, true) && ItemComponent.compareDeep(this.serviced, o.serviced, true) && ItemComponent.compareDeep(this.location, o.location, true) && ItemComponent.compareDeep(this.quantity, o.quantity, true) && ItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && ItemComponent.compareDeep(this.factor, o.factor, true) && ItemComponent.compareDeep(this.net, o.net, true) && ItemComponent.compareDeep(this.udi, o.udi, true) && ItemComponent.compareDeep(this.bodySite, o.bodySite, true) && ItemComponent.compareDeep(this.subSite, o.subSite, true) && ItemComponent.compareDeep(this.encounter, o.encounter, true) && ItemComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareValues(this.sequence, o.sequence, true) && ItemComponent.compareValues(this.careTeamSequence, o.careTeamSequence, true) && ItemComponent.compareValues(this.diagnosisSequence, o.diagnosisSequence, true) && ItemComponent.compareValues(this.procedureSequence, o.procedureSequence, true) && ItemComponent.compareValues(this.informationSequence, o.informationSequence, true) && ItemComponent.compareValues(this.factor, o.factor, true) && ItemComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.careTeamSequence, this.diagnosisSequence, this.procedureSequence, this.informationSequence, this.revenue, this.category, this.billcode, this.modifier, this.programCode, this.serviced, this.location, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.bodySite, this.subSite, this.encounter, this.noteNumber, this.adjudication, this.detail});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.item";
        }
    }

    @Block
    public static class AccidentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="date", type={DateType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the accident occurred", formalDefinition="Date of an accident which these services are addressing.")
        protected DateType date;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The nature of the accident", formalDefinition="Type of accident: work, auto, etc.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActIncidentCode")
        protected CodeableConcept type;
        @Child(name="location", type={Address.class, Location.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Accident Place", formalDefinition="Where the accident occurred.")
        protected Type location;
        private static final long serialVersionUID = 622904984L;

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccidentComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public AccidentComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public AccidentComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccidentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AccidentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getLocation() {
            return this.location;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                return null;
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AccidentComponent setLocation(Type value) {
            if (value != null && !(value instanceof Address) && !(value instanceof Reference)) {
                throw new Error("Not the right type for ExplanationOfBenefit.accident.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("date", "date", "Date of an accident which these services are addressing.", 0, 1, this.date));
            children.add(new Property("type", "CodeableConcept", "Type of accident: work, auto, etc.", 0, 1, this.type));
            children.add(new Property("location[x]", "Address|Reference(Location)", "Where the accident occurred.", 0, 1, this.location));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3076014: {
                    return new Property("date", "date", "Date of an accident which these services are addressing.", 0, 1, this.date);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of accident: work, auto, etc.", 0, 1, this.type);
                }
                case 552316075: {
                    return new Property("location[x]", "Address|Reference(Location)", "Where the accident occurred.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "Address|Reference(Location)", "Where the accident occurred.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "Address|Reference(Location)", "Where the accident occurred.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "Address|Reference(Location)", "Where the accident occurred.", 0, 1, this.location);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.date;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.location;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    this.date = this.castToDate(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("location[x]")) {
                this.location = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return this.getDateElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return new String[]{"date"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1901043637: {
                    return new String[]{"Address", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.date");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            return super.addChild(name);
        }

        @Override
        public AccidentComponent copy() {
            AccidentComponent dst = new AccidentComponent();
            this.copyValues(dst);
            dst.date = this.date == null ? null : this.date.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.location = this.location == null ? null : this.location.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AccidentComponent)) {
                return false;
            }
            AccidentComponent o = (AccidentComponent)other_;
            return AccidentComponent.compareDeep(this.date, o.date, true) && AccidentComponent.compareDeep(this.type, o.type, true) && AccidentComponent.compareDeep(this.location, o.location, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AccidentComponent)) {
                return false;
            }
            AccidentComponent o = (AccidentComponent)other_;
            return AccidentComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.date, this.type, this.location});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.accident";
        }
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="focal", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Is the focal Coverage", formalDefinition="The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim was adjudicated.")
        protected BooleanType focal;
        @Child(name="coverage", type={Coverage.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        private static final long serialVersionUID = 668686623L;

        public InsuranceComponent() {
        }

        public InsuranceComponent(BooleanType focal, Reference coverage) {
            this.focal = focal;
            this.coverage = coverage;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public InsuranceComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public InsuranceComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public InsuranceComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("focal", "boolean", "The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim was adjudicated.", 0, 1, this.focal));
            children.add(new Property(ExplanationOfBenefit.SP_COVERAGE, "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 97604197: {
                    return new Property("focal", "boolean", "The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim was adjudicated.", 0, 1, this.focal);
                }
                case -351767064: {
                    return new Property(ExplanationOfBenefit.SP_COVERAGE, "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, 1, this.coverage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 97604197: {
                    Base[] baseArray;
                    if (this.focal == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.focal;
                    }
                    return baseArray;
                }
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.coverage;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 97604197: {
                    this.focal = this.castToBoolean(value);
                    return value;
                }
                case -351767064: {
                    this.coverage = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("focal")) {
                this.focal = this.castToBoolean(value);
            } else if (name.equals(ExplanationOfBenefit.SP_COVERAGE)) {
                this.coverage = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97604197: {
                    return this.getFocalElement();
                }
                case -351767064: {
                    return this.getCoverage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97604197: {
                    return new String[]{"boolean"};
                }
                case -351767064: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.focal");
            }
            if (name.equals(ExplanationOfBenefit.SP_COVERAGE)) {
                this.coverage = new Reference();
                return this.coverage;
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareDeep(this.focal, o.focal, true) && InsuranceComponent.compareDeep(this.coverage, o.coverage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareValues(this.focal, o.focal, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.focal, this.coverage});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.insurance";
        }
    }

    @Block
    public static class ProcedureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Procedure sequence for reference", formalDefinition="Sequence of procedures which serves to order and provide a link.")
        protected PositiveIntType sequence;
        @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the procedure was performed", formalDefinition="Date and optionally time the procedure was performed .")
        protected DateTimeType date;
        @Child(name="procedure", type={CodeableConcept.class, Procedure.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Patient's list of procedures performed", formalDefinition="The procedure code.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10-procedures")
        protected Type procedure;
        private static final long serialVersionUID = 864307347L;

        public ProcedureComponent() {
        }

        public ProcedureComponent(PositiveIntType sequence, Type procedure) {
            this.sequence = sequence;
            this.procedure = procedure;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ProcedureComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ProcedureComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ProcedureComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ProcedureComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Type getProcedure() {
            return this.procedure;
        }

        public CodeableConcept getProcedureCodeableConcept() throws FHIRException {
            if (this.procedure == null) {
                return null;
            }
            if (!(this.procedure instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.procedure.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.procedure;
        }

        public boolean hasProcedureCodeableConcept() {
            return this != null && this.procedure instanceof CodeableConcept;
        }

        public Reference getProcedureReference() throws FHIRException {
            if (this.procedure == null) {
                return null;
            }
            if (!(this.procedure instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.procedure.getClass().getName() + " was encountered");
            }
            return (Reference)this.procedure;
        }

        public boolean hasProcedureReference() {
            return this != null && this.procedure instanceof Reference;
        }

        public boolean hasProcedure() {
            return this.procedure != null && !this.procedure.isEmpty();
        }

        public ProcedureComponent setProcedure(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for ExplanationOfBenefit.procedure.procedure[x]: " + value.fhirType());
            }
            this.procedure = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of procedures which serves to order and provide a link.", 0, 1, this.sequence));
            children.add(new Property("date", "dateTime", "Date and optionally time the procedure was performed .", 0, 1, this.date));
            children.add(new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of procedures which serves to order and provide a link.", 0, 1, this.sequence);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "Date and optionally time the procedure was performed .", 0, 1, this.date);
                }
                case 1640074445: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure);
                }
                case -1095204141: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure);
                }
                case -1284783026: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure);
                }
                case 881809848: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The procedure code.", 0, 1, this.procedure);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.date;
                    }
                    return baseArray;
                }
                case -1095204141: {
                    Base[] baseArray;
                    if (this.procedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.procedure;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    return value;
                }
                case -1095204141: {
                    this.procedure = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("date")) {
                this.date = this.castToDateTime(value);
            } else if (name.equals("procedure[x]")) {
                this.procedure = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case 1640074445: {
                    return this.getProcedure();
                }
                case -1095204141: {
                    return this.getProcedure();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case -1095204141: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.date");
            }
            if (name.equals("procedureCodeableConcept")) {
                this.procedure = new CodeableConcept();
                return this.procedure;
            }
            if (name.equals("procedureReference")) {
                this.procedure = new Reference();
                return this.procedure;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedureComponent copy() {
            ProcedureComponent dst = new ProcedureComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.procedure = this.procedure == null ? null : this.procedure.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureComponent)) {
                return false;
            }
            ProcedureComponent o = (ProcedureComponent)other_;
            return ProcedureComponent.compareDeep(this.sequence, o.sequence, true) && ProcedureComponent.compareDeep(this.date, o.date, true) && ProcedureComponent.compareDeep(this.procedure, o.procedure, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureComponent)) {
                return false;
            }
            ProcedureComponent o = (ProcedureComponent)other_;
            return ProcedureComponent.compareValues(this.sequence, o.sequence, true) && ProcedureComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.date, this.procedure});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.procedure";
        }
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number to convey order of diagnosis", formalDefinition="Sequence of diagnosis which serves to provide a link.")
        protected PositiveIntType sequence;
        @Child(name="diagnosis", type={CodeableConcept.class, Condition.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Patient's diagnosis", formalDefinition="The diagnosis.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10")
        protected Type diagnosis;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Timing or nature of the diagnosis", formalDefinition="The type of the Diagnosis, for example: admitting, primary, secondary, discharge.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosistype")
        protected List<CodeableConcept> type;
        @Child(name="onAdmission", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Present on admission", formalDefinition="Indication of whether the diagnosis was present on admission to a facility.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosis-on-admission")
        protected CodeableConcept onAdmission;
        @Child(name="packageCode", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Package billing code", formalDefinition="The package billing code, for example DRG, based on the assigned grouping code system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosisrelatedgroup")
        protected CodeableConcept packageCode;
        private static final long serialVersionUID = 2120593974L;

        public DiagnosisComponent() {
        }

        public DiagnosisComponent(PositiveIntType sequence, Type diagnosis) {
            this.sequence = sequence;
            this.diagnosis = diagnosis;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DiagnosisComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DiagnosisComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Type getDiagnosis() {
            return this.diagnosis;
        }

        public CodeableConcept getDiagnosisCodeableConcept() throws FHIRException {
            if (this.diagnosis == null) {
                return null;
            }
            if (!(this.diagnosis instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.diagnosis.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.diagnosis;
        }

        public boolean hasDiagnosisCodeableConcept() {
            return this != null && this.diagnosis instanceof CodeableConcept;
        }

        public Reference getDiagnosisReference() throws FHIRException {
            if (this.diagnosis == null) {
                return null;
            }
            if (!(this.diagnosis instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.diagnosis.getClass().getName() + " was encountered");
            }
            return (Reference)this.diagnosis;
        }

        public boolean hasDiagnosisReference() {
            return this != null && this.diagnosis instanceof Reference;
        }

        public boolean hasDiagnosis() {
            return this.diagnosis != null && !this.diagnosis.isEmpty();
        }

        public DiagnosisComponent setDiagnosis(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for ExplanationOfBenefit.diagnosis.diagnosis[x]: " + value.fhirType());
            }
            this.diagnosis = value;
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public DiagnosisComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public DiagnosisComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public CodeableConcept getOnAdmission() {
            if (this.onAdmission == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.onAdmission");
                }
                if (Configuration.doAutoCreate()) {
                    this.onAdmission = new CodeableConcept();
                }
            }
            return this.onAdmission;
        }

        public boolean hasOnAdmission() {
            return this.onAdmission != null && !this.onAdmission.isEmpty();
        }

        public DiagnosisComponent setOnAdmission(CodeableConcept value) {
            this.onAdmission = value;
            return this;
        }

        public CodeableConcept getPackageCode() {
            if (this.packageCode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.packageCode");
                }
                if (Configuration.doAutoCreate()) {
                    this.packageCode = new CodeableConcept();
                }
            }
            return this.packageCode;
        }

        public boolean hasPackageCode() {
            return this.packageCode != null && !this.packageCode.isEmpty();
        }

        public DiagnosisComponent setPackageCode(CodeableConcept value) {
            this.packageCode = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of diagnosis which serves to provide a link.", 0, 1, this.sequence));
            children.add(new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis));
            children.add(new Property("type", "CodeableConcept", "The type of the Diagnosis, for example: admitting, primary, secondary, discharge.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("onAdmission", "CodeableConcept", "Indication of whether the diagnosis was present on admission to a facility.", 0, 1, this.onAdmission));
            children.add(new Property("packageCode", "CodeableConcept", "The package billing code, for example DRG, based on the assigned grouping code system.", 0, 1, this.packageCode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of diagnosis which serves to provide a link.", 0, 1, this.sequence);
                }
                case -1487009809: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis);
                }
                case 1196993265: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis);
                }
                case 277781616: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis);
                }
                case 2050454362: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The diagnosis.", 0, 1, this.diagnosis);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of the Diagnosis, for example: admitting, primary, secondary, discharge.", 0, Integer.MAX_VALUE, this.type);
                }
                case -3386134: {
                    return new Property("onAdmission", "CodeableConcept", "Indication of whether the diagnosis was present on admission to a facility.", 0, 1, this.onAdmission);
                }
                case 908444499: {
                    return new Property("packageCode", "CodeableConcept", "The package billing code, for example DRG, based on the assigned grouping code system.", 0, 1, this.packageCode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1196993265: {
                    Base[] baseArray;
                    if (this.diagnosis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.diagnosis;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -3386134: {
                    Base[] baseArray;
                    if (this.onAdmission == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onAdmission;
                    }
                    return baseArray;
                }
                case 908444499: {
                    Base[] baseArray;
                    if (this.packageCode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.packageCode;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1196993265: {
                    this.diagnosis = this.castToType(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -3386134: {
                    this.onAdmission = this.castToCodeableConcept(value);
                    return value;
                }
                case 908444499: {
                    this.packageCode = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("diagnosis[x]")) {
                this.diagnosis = this.castToType(value);
            } else if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("onAdmission")) {
                this.onAdmission = this.castToCodeableConcept(value);
            } else if (name.equals("packageCode")) {
                this.packageCode = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -1487009809: {
                    return this.getDiagnosis();
                }
                case 1196993265: {
                    return this.getDiagnosis();
                }
                case 3575610: {
                    return this.addType();
                }
                case -3386134: {
                    return this.getOnAdmission();
                }
                case 908444499: {
                    return this.getPackageCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1196993265: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -3386134: {
                    return new String[]{"CodeableConcept"};
                }
                case 908444499: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("diagnosisCodeableConcept")) {
                this.diagnosis = new CodeableConcept();
                return this.diagnosis;
            }
            if (name.equals("diagnosisReference")) {
                this.diagnosis = new Reference();
                return this.diagnosis;
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("onAdmission")) {
                this.onAdmission = new CodeableConcept();
                return this.onAdmission;
            }
            if (name.equals("packageCode")) {
                this.packageCode = new CodeableConcept();
                return this.packageCode;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            Type type = dst.diagnosis = this.diagnosis == null ? null : this.diagnosis.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.onAdmission = this.onAdmission == null ? null : this.onAdmission.copy();
            dst.packageCode = this.packageCode == null ? null : this.packageCode.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.sequence, o.sequence, true) && DiagnosisComponent.compareDeep(this.diagnosis, o.diagnosis, true) && DiagnosisComponent.compareDeep(this.type, o.type, true) && DiagnosisComponent.compareDeep(this.onAdmission, o.onAdmission, true) && DiagnosisComponent.compareDeep(this.packageCode, o.packageCode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.diagnosis, this.type, this.onAdmission, this.packageCode});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.diagnosis";
        }
    }

    @Block
    public static class CareTeamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number to convey order of careteam", formalDefinition="Sequence of careteam which serves to order and provide a link.")
        protected PositiveIntType sequence;
        @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Member of the Care Team", formalDefinition="The members of the team who provided the overall service.")
        protected Reference provider;
        protected Resource providerTarget;
        @Child(name="responsible", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing practitioner", formalDefinition="The practitioner who is billing and responsible for the claimed services rendered to the patient.")
        protected BooleanType responsible;
        @Child(name="role", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role on the team", formalDefinition="The lead, assisting or supervising practitioner and their discipline if a multidisiplinary team.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-careteamrole")
        protected CodeableConcept role;
        @Child(name="qualification", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type, classification or Specialization", formalDefinition="The qualification which is applicable for this service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/provider-qualification")
        protected CodeableConcept qualification;
        private static final long serialVersionUID = 1758966968L;

        public CareTeamComponent() {
        }

        public CareTeamComponent(PositiveIntType sequence, Reference provider) {
            this.sequence = sequence;
            this.provider = provider;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public CareTeamComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public CareTeamComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Reference getProvider() {
            if (this.provider == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.provider = new Reference();
                }
            }
            return this.provider;
        }

        public boolean hasProvider() {
            return this.provider != null && !this.provider.isEmpty();
        }

        public CareTeamComponent setProvider(Reference value) {
            this.provider = value;
            return this;
        }

        public Resource getProviderTarget() {
            return this.providerTarget;
        }

        public CareTeamComponent setProviderTarget(Resource value) {
            this.providerTarget = value;
            return this;
        }

        public BooleanType getResponsibleElement() {
            if (this.responsible == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.responsible");
                }
                if (Configuration.doAutoCreate()) {
                    this.responsible = new BooleanType();
                }
            }
            return this.responsible;
        }

        public boolean hasResponsibleElement() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public boolean hasResponsible() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public CareTeamComponent setResponsibleElement(BooleanType value) {
            this.responsible = value;
            return this;
        }

        public boolean getResponsible() {
            return this.responsible == null || this.responsible.isEmpty() ? false : (Boolean)this.responsible.getValue();
        }

        public CareTeamComponent setResponsible(boolean value) {
            if (this.responsible == null) {
                this.responsible = new BooleanType();
            }
            this.responsible.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CareTeamComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public CodeableConcept getQualification() {
            if (this.qualification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.qualification");
                }
                if (Configuration.doAutoCreate()) {
                    this.qualification = new CodeableConcept();
                }
            }
            return this.qualification;
        }

        public boolean hasQualification() {
            return this.qualification != null && !this.qualification.isEmpty();
        }

        public CareTeamComponent setQualification(CodeableConcept value) {
            this.qualification = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of careteam which serves to order and provide a link.", 0, 1, this.sequence));
            children.add(new Property(ExplanationOfBenefit.SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The members of the team who provided the overall service.", 0, 1, this.provider));
            children.add(new Property("responsible", "boolean", "The practitioner who is billing and responsible for the claimed services rendered to the patient.", 0, 1, this.responsible));
            children.add(new Property("role", "CodeableConcept", "The lead, assisting or supervising practitioner and their discipline if a multidisiplinary team.", 0, 1, this.role));
            children.add(new Property("qualification", "CodeableConcept", "The qualification which is applicable for this service.", 0, 1, this.qualification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of careteam which serves to order and provide a link.", 0, 1, this.sequence);
                }
                case -987494927: {
                    return new Property(ExplanationOfBenefit.SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The members of the team who provided the overall service.", 0, 1, this.provider);
                }
                case 1847674614: {
                    return new Property("responsible", "boolean", "The practitioner who is billing and responsible for the claimed services rendered to the patient.", 0, 1, this.responsible);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The lead, assisting or supervising practitioner and their discipline if a multidisiplinary team.", 0, 1, this.role);
                }
                case -631333393: {
                    return new Property("qualification", "CodeableConcept", "The qualification which is applicable for this service.", 0, 1, this.qualification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case -987494927: {
                    Base[] baseArray;
                    if (this.provider == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.provider;
                    }
                    return baseArray;
                }
                case 1847674614: {
                    Base[] baseArray;
                    if (this.responsible == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.responsible;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.role;
                    }
                    return baseArray;
                }
                case -631333393: {
                    Base[] baseArray;
                    if (this.qualification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.qualification;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case -987494927: {
                    this.provider = this.castToReference(value);
                    return value;
                }
                case 1847674614: {
                    this.responsible = this.castToBoolean(value);
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case -631333393: {
                    this.qualification = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals(ExplanationOfBenefit.SP_PROVIDER)) {
                this.provider = this.castToReference(value);
            } else if (name.equals("responsible")) {
                this.responsible = this.castToBoolean(value);
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("qualification")) {
                this.qualification = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -987494927: {
                    return this.getProvider();
                }
                case 1847674614: {
                    return this.getResponsibleElement();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -631333393: {
                    return this.getQualification();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case -987494927: {
                    return new String[]{"Reference"};
                }
                case 1847674614: {
                    return new String[]{"boolean"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -631333393: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals(ExplanationOfBenefit.SP_PROVIDER)) {
                this.provider = new Reference();
                return this.provider;
            }
            if (name.equals("responsible")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.responsible");
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("qualification")) {
                this.qualification = new CodeableConcept();
                return this.qualification;
            }
            return super.addChild(name);
        }

        @Override
        public CareTeamComponent copy() {
            CareTeamComponent dst = new CareTeamComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.provider = this.provider == null ? null : this.provider.copy();
            dst.responsible = this.responsible == null ? null : this.responsible.copy();
            dst.role = this.role == null ? null : this.role.copy();
            dst.qualification = this.qualification == null ? null : this.qualification.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CareTeamComponent)) {
                return false;
            }
            CareTeamComponent o = (CareTeamComponent)other_;
            return CareTeamComponent.compareDeep(this.sequence, o.sequence, true) && CareTeamComponent.compareDeep(this.provider, o.provider, true) && CareTeamComponent.compareDeep(this.responsible, o.responsible, true) && CareTeamComponent.compareDeep(this.role, o.role, true) && CareTeamComponent.compareDeep(this.qualification, o.qualification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CareTeamComponent)) {
                return false;
            }
            CareTeamComponent o = (CareTeamComponent)other_;
            return CareTeamComponent.compareValues(this.sequence, o.sequence, true) && CareTeamComponent.compareValues(this.responsible, o.responsible, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.provider, this.responsible, this.role, this.qualification});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.careTeam";
        }
    }

    @Block
    public static class SupportingInformationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information instance identifier", formalDefinition="Sequence of the information element which serves to provide a link.")
        protected PositiveIntType sequence;
        @Child(name="category", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General class of information", formalDefinition="The general class of the information supplied: information; exception; accident, employment; onset, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-informationcategory")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of information", formalDefinition="System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought which may influence the adjudication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-exception")
        protected CodeableConcept code;
        @Child(name="timing", type={DateType.class, Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When it occurred", formalDefinition="The date when or period to which this information refers.")
        protected Type timing;
        @Child(name="value", type={BooleanType.class, StringType.class, Quantity.class, Attachment.class, Reference.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional Data or supporting information", formalDefinition="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.")
        protected Type value;
        @Child(name="reason", type={Coding.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason associated with the information", formalDefinition="For example, provides the reason for: the additional stay, or missing tooth or any other situation where a reason code is required in addition to the content.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/missing-tooth-reason")
        protected Coding reason;
        private static final long serialVersionUID = -410136661L;

        public SupportingInformationComponent() {
        }

        public SupportingInformationComponent(PositiveIntType sequence, CodeableConcept category) {
            this.sequence = sequence;
            this.category = category;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SupportingInformationComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SupportingInformationComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SupportingInformationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SupportingInformationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Type getTiming() {
            return this.timing;
        }

        public DateType getTimingDateType() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (DateType)this.timing;
        }

        public boolean hasTimingDateType() {
            return this != null && this.timing instanceof DateType;
        }

        public Period getTimingPeriod() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Period)this.timing;
        }

        public boolean hasTimingPeriod() {
            return this != null && this.timing instanceof Period;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public SupportingInformationComponent setTiming(Type value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new Error("Not the right type for ExplanationOfBenefit.information.timing[x]: " + value.fhirType());
            }
            this.timing = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SupportingInformationComponent setValue(Type value) {
            if (!(value == null || value instanceof BooleanType || value instanceof StringType || value instanceof Quantity || value instanceof Attachment || value instanceof Reference)) {
                throw new Error("Not the right type for ExplanationOfBenefit.information.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public Coding getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new Coding();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public SupportingInformationComponent setReason(Coding value) {
            this.reason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence of the information element which serves to provide a link.", 0, 1, this.sequence));
            children.add(new Property("category", "CodeableConcept", "The general class of the information supplied: information; exception; accident, employment; onset, etc.", 0, 1, this.category));
            children.add(new Property("code", "CodeableConcept", "System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought which may influence the adjudication.", 0, 1, this.code));
            children.add(new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing));
            children.add(new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value));
            children.add(new Property("reason", "Coding", "For example, provides the reason for: the additional stay, or missing tooth or any other situation where a reason code is required in addition to the content.", 0, 1, this.reason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence of the information element which serves to provide a link.", 0, 1, this.sequence);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "The general class of the information supplied: information; exception; accident, employment; onset, etc.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought which may influence the adjudication.", 0, 1, this.code);
                }
                case 164632566: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -873664438: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case 807935768: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -615615829: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -1410166417: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -934964668: {
                    return new Property("reason", "Coding", "For example, provides the reason for: the additional stay, or missing tooth or any other situation where a reason code is required in addition to the content.", 0, 1, this.reason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.code;
                    }
                    return baseArray;
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.timing;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.value;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.reason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -873664438: {
                    this.timing = this.castToType(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
                case -934964668: {
                    this.reason = this.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("timing[x]")) {
                this.timing = this.castToType(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -934964668: {
                    return this.getReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -873664438: {
                    return new String[]{"date", "Period"};
                }
                case 111972721: {
                    return new String[]{"boolean", "string", "Quantity", "Attachment", "Reference"};
                }
                case -934964668: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ExplanationOfBenefit.sequence");
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("timingDate")) {
                this.timing = new DateType();
                return this.timing;
            }
            if (name.equals("timingPeriod")) {
                this.timing = new Period();
                return this.timing;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("reason")) {
                this.reason = new Coding();
                return this.reason;
            }
            return super.addChild(name);
        }

        @Override
        public SupportingInformationComponent copy() {
            SupportingInformationComponent dst = new SupportingInformationComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.timing = this.timing == null ? null : this.timing.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SupportingInformationComponent)) {
                return false;
            }
            SupportingInformationComponent o = (SupportingInformationComponent)other_;
            return SupportingInformationComponent.compareDeep(this.sequence, o.sequence, true) && SupportingInformationComponent.compareDeep(this.category, o.category, true) && SupportingInformationComponent.compareDeep(this.code, o.code, true) && SupportingInformationComponent.compareDeep(this.timing, o.timing, true) && SupportingInformationComponent.compareDeep(this.value, o.value, true) && SupportingInformationComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SupportingInformationComponent)) {
                return false;
            }
            SupportingInformationComponent o = (SupportingInformationComponent)other_;
            return SupportingInformationComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.category, this.code, this.timing, this.value, this.reason});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.information";
        }
    }

    @Block
    public static class PayeeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of party: Subscriber, Provider, other", formalDefinition="Type of Party to be reimbursed: Subscriber, provider, other.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payeetype")
        protected CodeableConcept type;
        @Child(name="resource", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="organization | patient | practitioner | relatedperson", formalDefinition="organization | patient | practitioner | relatedperson.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-type-link")
        protected Coding resource;
        @Child(name="party", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Party to receive the payable", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
        protected Reference party;
        protected Resource partyTarget;
        private static final long serialVersionUID = -553403531L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PayeeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Coding getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Coding();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public PayeeComponent setResource(Coding value) {
            this.resource = value;
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public PayeeComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public PayeeComponent setPartyTarget(Resource value) {
            this.partyTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.type));
            children.add(new Property("resource", "Coding", "organization | patient | practitioner | relatedperson.", 0, 1, this.resource));
            children.add(new Property("party", "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson)", "Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.party));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.type);
                }
                case -341064690: {
                    return new Property("resource", "Coding", "organization | patient | practitioner | relatedperson.", 0, 1, this.resource);
                }
                case 106437350: {
                    return new Property("party", "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson)", "Party to be reimbursed: Subscriber, provider, other.", 0, 1, this.party);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -341064690: {
                    this.resource = this.castToCoding(value);
                    return value;
                }
                case 106437350: {
                    this.party = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToCoding(value);
            } else if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -341064690: {
                    return this.getResource();
                }
                case 106437350: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -341064690: {
                    return new String[]{"Coding"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("resource")) {
                this.resource = new Coding();
                return this.resource;
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public PayeeComponent copy() {
            PayeeComponent dst = new PayeeComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.party = this.party == null ? null : this.party.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other_;
            return PayeeComponent.compareDeep(this.type, o.type, true) && PayeeComponent.compareDeep(this.resource, o.resource, true) && PayeeComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.resource, this.party});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.payee";
        }
    }

    @Block
    public static class RelatedClaimComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="claim", type={Claim.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to the related claim", formalDefinition="Other claims which are related to this claim such as prior claim versions or for related services.")
        protected Reference claim;
        protected Claim claimTarget;
        @Child(name="relationship", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the reference claim is related", formalDefinition="For example, prior or umbrella.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/related-claim-relationship")
        protected CodeableConcept relationship;
        @Child(name="reference", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Related file or case reference", formalDefinition="An alternate organizational reference to the case or file to which this particular claim pertains - e.g. Property/Casualy insurer claim # or Workers Compensation case # .")
        protected Identifier reference;
        private static final long serialVersionUID = -379338905L;

        public Reference getClaim() {
            if (this.claim == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.claim");
                }
                if (Configuration.doAutoCreate()) {
                    this.claim = new Reference();
                }
            }
            return this.claim;
        }

        public boolean hasClaim() {
            return this.claim != null && !this.claim.isEmpty();
        }

        public RelatedClaimComponent setClaim(Reference value) {
            this.claim = value;
            return this;
        }

        public Claim getClaimTarget() {
            if (this.claimTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.claim");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimTarget = new Claim();
                }
            }
            return this.claimTarget;
        }

        public RelatedClaimComponent setClaimTarget(Claim value) {
            this.claimTarget = value;
            return this;
        }

        public CodeableConcept getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new CodeableConcept();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public RelatedClaimComponent setRelationship(CodeableConcept value) {
            this.relationship = value;
            return this;
        }

        public Identifier getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Identifier();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public RelatedClaimComponent setReference(Identifier value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ExplanationOfBenefit.SP_CLAIM, "Reference(Claim)", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, 1, this.claim));
            children.add(new Property("relationship", "CodeableConcept", "For example, prior or umbrella.", 0, 1, this.relationship));
            children.add(new Property("reference", "Identifier", "An alternate organizational reference to the case or file to which this particular claim pertains - e.g. Property/Casualy insurer claim # or Workers Compensation case # .", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 94742588: {
                    return new Property(ExplanationOfBenefit.SP_CLAIM, "Reference(Claim)", "Other claims which are related to this claim such as prior claim versions or for related services.", 0, 1, this.claim);
                }
                case -261851592: {
                    return new Property("relationship", "CodeableConcept", "For example, prior or umbrella.", 0, 1, this.relationship);
                }
                case -925155509: {
                    return new Property("reference", "Identifier", "An alternate organizational reference to the case or file to which this particular claim pertains - e.g. Property/Casualy insurer claim # or Workers Compensation case # .", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    Base[] baseArray;
                    if (this.claim == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.claim;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    this.claim = this.castToReference(value);
                    return value;
                }
                case -261851592: {
                    this.relationship = this.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ExplanationOfBenefit.SP_CLAIM)) {
                this.claim = this.castToReference(value);
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    return this.getClaim();
                }
                case -261851592: {
                    return this.getRelationship();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    return new String[]{"Reference"};
                }
                case -261851592: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ExplanationOfBenefit.SP_CLAIM)) {
                this.claim = new Reference();
                return this.claim;
            }
            if (name.equals("relationship")) {
                this.relationship = new CodeableConcept();
                return this.relationship;
            }
            if (name.equals("reference")) {
                this.reference = new Identifier();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public RelatedClaimComponent copy() {
            RelatedClaimComponent dst = new RelatedClaimComponent();
            this.copyValues(dst);
            dst.claim = this.claim == null ? null : this.claim.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RelatedClaimComponent)) {
                return false;
            }
            RelatedClaimComponent o = (RelatedClaimComponent)other_;
            return RelatedClaimComponent.compareDeep(this.claim, o.claim, true) && RelatedClaimComponent.compareDeep(this.relationship, o.relationship, true) && RelatedClaimComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RelatedClaimComponent)) {
                return false;
            }
            RelatedClaimComponent o = (RelatedClaimComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.claim, this.relationship, this.reference});
        }

        @Override
        public String fhirType() {
            return "ExplanationOfBenefit.related";
        }
    }

    public static class RemittanceOutcomeEnumFactory
    implements EnumFactory<RemittanceOutcome> {
        @Override
        public RemittanceOutcome fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return RemittanceOutcome.QUEUED;
            }
            if ("complete".equals(codeString)) {
                return RemittanceOutcome.COMPLETE;
            }
            if ("error".equals(codeString)) {
                return RemittanceOutcome.ERROR;
            }
            if ("partial".equals(codeString)) {
                return RemittanceOutcome.PARTIAL;
            }
            throw new IllegalArgumentException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        public Enumeration<RemittanceOutcome> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RemittanceOutcome>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.QUEUED);
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.COMPLETE);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.ERROR);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<RemittanceOutcome>(this, RemittanceOutcome.PARTIAL);
            }
            throw new FHIRException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        @Override
        public String toCode(RemittanceOutcome code) {
            if (code == RemittanceOutcome.QUEUED) {
                return "queued";
            }
            if (code == RemittanceOutcome.COMPLETE) {
                return "complete";
            }
            if (code == RemittanceOutcome.ERROR) {
                return "error";
            }
            if (code == RemittanceOutcome.PARTIAL) {
                return "partial";
            }
            return "?";
        }

        @Override
        public String toSystem(RemittanceOutcome code) {
            return code.getSystem();
        }
    }

    public static enum RemittanceOutcome {
        QUEUED,
        COMPLETE,
        ERROR,
        PARTIAL,
        NULL;


        public static RemittanceOutcome fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return QUEUED;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RemittanceOutcome code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case QUEUED: {
                    return "queued";
                }
                case COMPLETE: {
                    return "complete";
                }
                case ERROR: {
                    return "error";
                }
                case PARTIAL: {
                    return "partial";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case QUEUED: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
                case COMPLETE: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/remittance-outcome";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case QUEUED: {
                    return "The Claim/Pre-authorization/Pre-determination has been received but processing has not begun.";
                }
                case COMPLETE: {
                    return "The processing has completed without errors";
                }
                case ERROR: {
                    return "One or more errors have been detected in the Claim";
                }
                case PARTIAL: {
                    return "No errors have been detected in the Claim and some of the adjudication has been performed.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case QUEUED: {
                    return "Queued";
                }
                case COMPLETE: {
                    return "Processing Complete";
                }
                case ERROR: {
                    return "Error";
                }
                case PARTIAL: {
                    return "Partial Processing";
                }
            }
            return "?";
        }
    }

    public static class UseEnumFactory
    implements EnumFactory<Use> {
        @Override
        public Use fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if (ExplanationOfBenefit.SP_CLAIM.equals(codeString)) {
                return Use.CLAIM;
            }
            if ("preauthorization".equals(codeString)) {
                return Use.PREAUTHORIZATION;
            }
            if ("predetermination".equals(codeString)) {
                return Use.PREDETERMINATION;
            }
            throw new IllegalArgumentException("Unknown Use code '" + codeString + "'");
        }

        public Enumeration<Use> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<Use>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (ExplanationOfBenefit.SP_CLAIM.equals(codeString)) {
                return new Enumeration<Use>(this, Use.CLAIM);
            }
            if ("preauthorization".equals(codeString)) {
                return new Enumeration<Use>(this, Use.PREAUTHORIZATION);
            }
            if ("predetermination".equals(codeString)) {
                return new Enumeration<Use>(this, Use.PREDETERMINATION);
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        @Override
        public String toCode(Use code) {
            if (code == Use.CLAIM) {
                return ExplanationOfBenefit.SP_CLAIM;
            }
            if (code == Use.PREAUTHORIZATION) {
                return "preauthorization";
            }
            if (code == Use.PREDETERMINATION) {
                return "predetermination";
            }
            return "?";
        }

        @Override
        public String toSystem(Use code) {
            return code.getSystem();
        }
    }

    public static enum Use {
        CLAIM,
        PREAUTHORIZATION,
        PREDETERMINATION,
        NULL;


        public static Use fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (ExplanationOfBenefit.SP_CLAIM.equals(codeString)) {
                return CLAIM;
            }
            if ("preauthorization".equals(codeString)) {
                return PREAUTHORIZATION;
            }
            if ("predetermination".equals(codeString)) {
                return PREDETERMINATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CLAIM: {
                    return ExplanationOfBenefit.SP_CLAIM;
                }
                case PREAUTHORIZATION: {
                    return "preauthorization";
                }
                case PREDETERMINATION: {
                    return "predetermination";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CLAIM: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case PREAUTHORIZATION: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case PREDETERMINATION: {
                    return "http://hl7.org/fhir/claim-use";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CLAIM: {
                    return "The treatment is complete and this represents a Claim for the services.";
                }
                case PREAUTHORIZATION: {
                    return "The treatment is proposed and this represents a Pre-authorization for the services.";
                }
                case PREDETERMINATION: {
                    return "The treatment is proposed and this represents a Pre-determination for the services.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CLAIM: {
                    return "Claim";
                }
                case PREAUTHORIZATION: {
                    return "Preauthorization";
                }
                case PREDETERMINATION: {
                    return "Predetermination";
                }
            }
            return "?";
        }
    }

    public static class ExplanationOfBenefitStatusEnumFactory
    implements EnumFactory<ExplanationOfBenefitStatus> {
        @Override
        public ExplanationOfBenefitStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ExplanationOfBenefitStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return ExplanationOfBenefitStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return ExplanationOfBenefitStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ExplanationOfBenefitStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ExplanationOfBenefitStatus code '" + codeString + "'");
        }

        public Enumeration<ExplanationOfBenefitStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ExplanationOfBenefitStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ExplanationOfBenefitStatus>(this, ExplanationOfBenefitStatus.ACTIVE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ExplanationOfBenefitStatus>(this, ExplanationOfBenefitStatus.CANCELLED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ExplanationOfBenefitStatus>(this, ExplanationOfBenefitStatus.DRAFT);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ExplanationOfBenefitStatus>(this, ExplanationOfBenefitStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ExplanationOfBenefitStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ExplanationOfBenefitStatus code) {
            if (code == ExplanationOfBenefitStatus.ACTIVE) {
                return "active";
            }
            if (code == ExplanationOfBenefitStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ExplanationOfBenefitStatus.DRAFT) {
                return "draft";
            }
            if (code == ExplanationOfBenefitStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ExplanationOfBenefitStatus code) {
            return code.getSystem();
        }
    }

    public static enum ExplanationOfBenefitStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static ExplanationOfBenefitStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ExplanationOfBenefitStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/explanationofbenefit-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/explanationofbenefit-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/explanationofbenefit-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/explanationofbenefit-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The resource instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The resource instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new resource instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The resource instance was entered in error.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
            }
            return "?";
        }
    }
}

