/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ItemInstance", profile="http://hl7.org/fhir/StructureDefinition/ItemInstance")
public class ItemInstance
extends DomainResource {
    @Child(name="count", type={IntegerType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The count of items", formalDefinition="The quantity or amount of instances. For example if several units are being counted for inventory, this quantity can be more than one, provided they are not unique. Seriallized items are considered unique and as such would have a quantity max 1. This element is required and its presence asserts that the reource refers to a physical item.")
    protected IntegerType count;
    @Child(name="location", type={Location.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The physical location of the item", formalDefinition="The location where the item is phisically located.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="subject", type={Patient.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient that the item is affixed to", formalDefinition="The patient that the item is associated with (implanted in, given to).")
    protected Reference subject;
    protected Patient subjectTarget;
    @Child(name="manufactureDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The manufacture or preparation date and time", formalDefinition="The manufacture or preparation date and time. Times are necessary for several examples - for example biologically derived products, prepared or coumpounded medication, rapidly decaying isotopes.")
    protected DateTimeType manufactureDate;
    @Child(name="expiryDate", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The expiry or preparation date and time", formalDefinition="The expiry or preparation date and time.")
    protected DateTimeType expiryDate;
    @Child(name="currentSWVersion", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Software version associated with the device", formalDefinition="The Software version associated with the device, typically only used for devices with embedded software or firmware.")
    protected StringType currentSWVersion;
    @Child(name="lotNumber", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The lot or batch number", formalDefinition="The lot or batch number.")
    protected StringType lotNumber;
    @Child(name="serialNumber", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The serial number if available", formalDefinition="The serial number if available.")
    protected StringType serialNumber;
    @Child(name="carrierAIDC", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The machine-readable AIDC string in base64 encoding", formalDefinition="The machine-readable AIDC string in base64 encoding. Can correspond to the UDI pattern in devices.")
    protected StringType carrierAIDC;
    @Child(name="carrierHRF", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The human-readable barcode string", formalDefinition="The human-readable barcode string. Can correspond to the UDI pattern in devices.")
    protected StringType carrierHRF;
    private static final long serialVersionUID = 1664070945L;
    @SearchParamDefinition(name="subject", path="ItemInstance.subject", description="The identifier of the patient who has devices assigned to", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ItemInstance:subject").toLocked();

    public ItemInstance() {
    }

    public ItemInstance(IntegerType count) {
        this.count = count;
    }

    public IntegerType getCountElement() {
        if (this.count == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.count");
            }
            if (Configuration.doAutoCreate()) {
                this.count = new IntegerType();
            }
        }
        return this.count;
    }

    public boolean hasCountElement() {
        return this.count != null && !this.count.isEmpty();
    }

    public boolean hasCount() {
        return this.count != null && !this.count.isEmpty();
    }

    public ItemInstance setCountElement(IntegerType value) {
        this.count = value;
        return this;
    }

    public int getCount() {
        return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
    }

    public ItemInstance setCount(int value) {
        if (this.count == null) {
            this.count = new IntegerType();
        }
        this.count.setValue((Object)value);
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public ItemInstance setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public ItemInstance setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ItemInstance setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Patient getSubjectTarget() {
        if (this.subjectTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subjectTarget = new Patient();
            }
        }
        return this.subjectTarget;
    }

    public ItemInstance setSubjectTarget(Patient value) {
        this.subjectTarget = value;
        return this;
    }

    public DateTimeType getManufactureDateElement() {
        if (this.manufactureDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.manufactureDate");
            }
            if (Configuration.doAutoCreate()) {
                this.manufactureDate = new DateTimeType();
            }
        }
        return this.manufactureDate;
    }

    public boolean hasManufactureDateElement() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public boolean hasManufactureDate() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public ItemInstance setManufactureDateElement(DateTimeType value) {
        this.manufactureDate = value;
        return this;
    }

    public Date getManufactureDate() {
        return this.manufactureDate == null ? null : (Date)this.manufactureDate.getValue();
    }

    public ItemInstance setManufactureDate(Date value) {
        if (value == null) {
            this.manufactureDate = null;
        } else {
            if (this.manufactureDate == null) {
                this.manufactureDate = new DateTimeType();
            }
            this.manufactureDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getExpiryDateElement() {
        if (this.expiryDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.expiryDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expiryDate = new DateTimeType();
            }
        }
        return this.expiryDate;
    }

    public boolean hasExpiryDateElement() {
        return this.expiryDate != null && !this.expiryDate.isEmpty();
    }

    public boolean hasExpiryDate() {
        return this.expiryDate != null && !this.expiryDate.isEmpty();
    }

    public ItemInstance setExpiryDateElement(DateTimeType value) {
        this.expiryDate = value;
        return this;
    }

    public Date getExpiryDate() {
        return this.expiryDate == null ? null : (Date)this.expiryDate.getValue();
    }

    public ItemInstance setExpiryDate(Date value) {
        if (value == null) {
            this.expiryDate = null;
        } else {
            if (this.expiryDate == null) {
                this.expiryDate = new DateTimeType();
            }
            this.expiryDate.setValue(value);
        }
        return this;
    }

    public StringType getCurrentSWVersionElement() {
        if (this.currentSWVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.currentSWVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.currentSWVersion = new StringType();
            }
        }
        return this.currentSWVersion;
    }

    public boolean hasCurrentSWVersionElement() {
        return this.currentSWVersion != null && !this.currentSWVersion.isEmpty();
    }

    public boolean hasCurrentSWVersion() {
        return this.currentSWVersion != null && !this.currentSWVersion.isEmpty();
    }

    public ItemInstance setCurrentSWVersionElement(StringType value) {
        this.currentSWVersion = value;
        return this;
    }

    public String getCurrentSWVersion() {
        return this.currentSWVersion == null ? null : (String)this.currentSWVersion.getValue();
    }

    public ItemInstance setCurrentSWVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.currentSWVersion = null;
        } else {
            if (this.currentSWVersion == null) {
                this.currentSWVersion = new StringType();
            }
            this.currentSWVersion.setValue(value);
        }
        return this;
    }

    public StringType getLotNumberElement() {
        if (this.lotNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.lotNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.lotNumber = new StringType();
            }
        }
        return this.lotNumber;
    }

    public boolean hasLotNumberElement() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public boolean hasLotNumber() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public ItemInstance setLotNumberElement(StringType value) {
        this.lotNumber = value;
        return this;
    }

    public String getLotNumber() {
        return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
    }

    public ItemInstance setLotNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(value);
        }
        return this;
    }

    public StringType getSerialNumberElement() {
        if (this.serialNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.serialNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.serialNumber = new StringType();
            }
        }
        return this.serialNumber;
    }

    public boolean hasSerialNumberElement() {
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    public boolean hasSerialNumber() {
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    public ItemInstance setSerialNumberElement(StringType value) {
        this.serialNumber = value;
        return this;
    }

    public String getSerialNumber() {
        return this.serialNumber == null ? null : (String)this.serialNumber.getValue();
    }

    public ItemInstance setSerialNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.serialNumber = null;
        } else {
            if (this.serialNumber == null) {
                this.serialNumber = new StringType();
            }
            this.serialNumber.setValue(value);
        }
        return this;
    }

    public StringType getCarrierAIDCElement() {
        if (this.carrierAIDC == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.carrierAIDC");
            }
            if (Configuration.doAutoCreate()) {
                this.carrierAIDC = new StringType();
            }
        }
        return this.carrierAIDC;
    }

    public boolean hasCarrierAIDCElement() {
        return this.carrierAIDC != null && !this.carrierAIDC.isEmpty();
    }

    public boolean hasCarrierAIDC() {
        return this.carrierAIDC != null && !this.carrierAIDC.isEmpty();
    }

    public ItemInstance setCarrierAIDCElement(StringType value) {
        this.carrierAIDC = value;
        return this;
    }

    public String getCarrierAIDC() {
        return this.carrierAIDC == null ? null : (String)this.carrierAIDC.getValue();
    }

    public ItemInstance setCarrierAIDC(String value) {
        if (Utilities.noString((String)value)) {
            this.carrierAIDC = null;
        } else {
            if (this.carrierAIDC == null) {
                this.carrierAIDC = new StringType();
            }
            this.carrierAIDC.setValue(value);
        }
        return this;
    }

    public StringType getCarrierHRFElement() {
        if (this.carrierHRF == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ItemInstance.carrierHRF");
            }
            if (Configuration.doAutoCreate()) {
                this.carrierHRF = new StringType();
            }
        }
        return this.carrierHRF;
    }

    public boolean hasCarrierHRFElement() {
        return this.carrierHRF != null && !this.carrierHRF.isEmpty();
    }

    public boolean hasCarrierHRF() {
        return this.carrierHRF != null && !this.carrierHRF.isEmpty();
    }

    public ItemInstance setCarrierHRFElement(StringType value) {
        this.carrierHRF = value;
        return this;
    }

    public String getCarrierHRF() {
        return this.carrierHRF == null ? null : (String)this.carrierHRF.getValue();
    }

    public ItemInstance setCarrierHRF(String value) {
        if (Utilities.noString((String)value)) {
            this.carrierHRF = null;
        } else {
            if (this.carrierHRF == null) {
                this.carrierHRF = new StringType();
            }
            this.carrierHRF.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("count", "integer", "The quantity or amount of instances. For example if several units are being counted for inventory, this quantity can be more than one, provided they are not unique. Seriallized items are considered unique and as such would have a quantity max 1. This element is required and its presence asserts that the reource refers to a physical item.", 0, 1, this.count));
        children.add(new Property("location", "Reference(Location)", "The location where the item is phisically located.", 0, 1, this.location));
        children.add(new Property(SP_SUBJECT, "Reference(Patient)", "The patient that the item is associated with (implanted in, given to).", 0, 1, this.subject));
        children.add(new Property("manufactureDate", "dateTime", "The manufacture or preparation date and time. Times are necessary for several examples - for example biologically derived products, prepared or coumpounded medication, rapidly decaying isotopes.", 0, 1, this.manufactureDate));
        children.add(new Property("expiryDate", "dateTime", "The expiry or preparation date and time.", 0, 1, this.expiryDate));
        children.add(new Property("currentSWVersion", "string", "The Software version associated with the device, typically only used for devices with embedded software or firmware.", 0, 1, this.currentSWVersion));
        children.add(new Property("lotNumber", "string", "The lot or batch number.", 0, 1, this.lotNumber));
        children.add(new Property("serialNumber", "string", "The serial number if available.", 0, 1, this.serialNumber));
        children.add(new Property("carrierAIDC", "string", "The machine-readable AIDC string in base64 encoding. Can correspond to the UDI pattern in devices.", 0, 1, this.carrierAIDC));
        children.add(new Property("carrierHRF", "string", "The human-readable barcode string. Can correspond to the UDI pattern in devices.", 0, 1, this.carrierHRF));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 94851343: {
                return new Property("count", "integer", "The quantity or amount of instances. For example if several units are being counted for inventory, this quantity can be more than one, provided they are not unique. Seriallized items are considered unique and as such would have a quantity max 1. This element is required and its presence asserts that the reource refers to a physical item.", 0, 1, this.count);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "The location where the item is phisically located.", 0, 1, this.location);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient)", "The patient that the item is associated with (implanted in, given to).", 0, 1, this.subject);
            }
            case 416714767: {
                return new Property("manufactureDate", "dateTime", "The manufacture or preparation date and time. Times are necessary for several examples - for example biologically derived products, prepared or coumpounded medication, rapidly decaying isotopes.", 0, 1, this.manufactureDate);
            }
            case -816738431: {
                return new Property("expiryDate", "dateTime", "The expiry or preparation date and time.", 0, 1, this.expiryDate);
            }
            case -1538044805: {
                return new Property("currentSWVersion", "string", "The Software version associated with the device, typically only used for devices with embedded software or firmware.", 0, 1, this.currentSWVersion);
            }
            case 462547450: {
                return new Property("lotNumber", "string", "The lot or batch number.", 0, 1, this.lotNumber);
            }
            case 83787357: {
                return new Property("serialNumber", "string", "The serial number if available.", 0, 1, this.serialNumber);
            }
            case -768521825: {
                return new Property("carrierAIDC", "string", "The machine-readable AIDC string in base64 encoding. Can correspond to the UDI pattern in devices.", 0, 1, this.carrierAIDC);
            }
            case 806499972: {
                return new Property("carrierHRF", "string", "The human-readable barcode string. Can correspond to the UDI pattern in devices.", 0, 1, this.carrierHRF);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 94851343: {
                Base[] baseArray;
                if (this.count == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.count;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.location;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 416714767: {
                Base[] baseArray;
                if (this.manufactureDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.manufactureDate;
                }
                return baseArray;
            }
            case -816738431: {
                Base[] baseArray;
                if (this.expiryDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.expiryDate;
                }
                return baseArray;
            }
            case -1538044805: {
                Base[] baseArray;
                if (this.currentSWVersion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.currentSWVersion;
                }
                return baseArray;
            }
            case 462547450: {
                Base[] baseArray;
                if (this.lotNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.lotNumber;
                }
                return baseArray;
            }
            case 83787357: {
                Base[] baseArray;
                if (this.serialNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.serialNumber;
                }
                return baseArray;
            }
            case -768521825: {
                Base[] baseArray;
                if (this.carrierAIDC == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.carrierAIDC;
                }
                return baseArray;
            }
            case 806499972: {
                Base[] baseArray;
                if (this.carrierHRF == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.carrierHRF;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 94851343: {
                this.count = this.castToInteger(value);
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 416714767: {
                this.manufactureDate = this.castToDateTime(value);
                return value;
            }
            case -816738431: {
                this.expiryDate = this.castToDateTime(value);
                return value;
            }
            case -1538044805: {
                this.currentSWVersion = this.castToString(value);
                return value;
            }
            case 462547450: {
                this.lotNumber = this.castToString(value);
                return value;
            }
            case 83787357: {
                this.serialNumber = this.castToString(value);
                return value;
            }
            case -768521825: {
                this.carrierAIDC = this.castToString(value);
                return value;
            }
            case 806499972: {
                this.carrierHRF = this.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("count")) {
            this.count = this.castToInteger(value);
        } else if (name.equals("location")) {
            this.location = this.castToReference(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("manufactureDate")) {
            this.manufactureDate = this.castToDateTime(value);
        } else if (name.equals("expiryDate")) {
            this.expiryDate = this.castToDateTime(value);
        } else if (name.equals("currentSWVersion")) {
            this.currentSWVersion = this.castToString(value);
        } else if (name.equals("lotNumber")) {
            this.lotNumber = this.castToString(value);
        } else if (name.equals("serialNumber")) {
            this.serialNumber = this.castToString(value);
        } else if (name.equals("carrierAIDC")) {
            this.carrierAIDC = this.castToString(value);
        } else if (name.equals("carrierHRF")) {
            this.carrierHRF = this.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 94851343: {
                return this.getCountElement();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 416714767: {
                return this.getManufactureDateElement();
            }
            case -816738431: {
                return this.getExpiryDateElement();
            }
            case -1538044805: {
                return this.getCurrentSWVersionElement();
            }
            case 462547450: {
                return this.getLotNumberElement();
            }
            case 83787357: {
                return this.getSerialNumberElement();
            }
            case -768521825: {
                return this.getCarrierAIDCElement();
            }
            case 806499972: {
                return this.getCarrierHRFElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 94851343: {
                return new String[]{"integer"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 416714767: {
                return new String[]{"dateTime"};
            }
            case -816738431: {
                return new String[]{"dateTime"};
            }
            case -1538044805: {
                return new String[]{"string"};
            }
            case 462547450: {
                return new String[]{"string"};
            }
            case 83787357: {
                return new String[]{"string"};
            }
            case -768521825: {
                return new String[]{"string"};
            }
            case 806499972: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("count")) {
            throw new FHIRException("Cannot call addChild on a primitive type ItemInstance.count");
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("manufactureDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ItemInstance.manufactureDate");
        }
        if (name.equals("expiryDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ItemInstance.expiryDate");
        }
        if (name.equals("currentSWVersion")) {
            throw new FHIRException("Cannot call addChild on a primitive type ItemInstance.currentSWVersion");
        }
        if (name.equals("lotNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type ItemInstance.lotNumber");
        }
        if (name.equals("serialNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type ItemInstance.serialNumber");
        }
        if (name.equals("carrierAIDC")) {
            throw new FHIRException("Cannot call addChild on a primitive type ItemInstance.carrierAIDC");
        }
        if (name.equals("carrierHRF")) {
            throw new FHIRException("Cannot call addChild on a primitive type ItemInstance.carrierHRF");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ItemInstance";
    }

    @Override
    public ItemInstance copy() {
        ItemInstance dst = new ItemInstance();
        this.copyValues(dst);
        dst.count = this.count == null ? null : this.count.copy();
        dst.location = this.location == null ? null : this.location.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.manufactureDate = this.manufactureDate == null ? null : this.manufactureDate.copy();
        dst.expiryDate = this.expiryDate == null ? null : this.expiryDate.copy();
        dst.currentSWVersion = this.currentSWVersion == null ? null : this.currentSWVersion.copy();
        dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        dst.serialNumber = this.serialNumber == null ? null : this.serialNumber.copy();
        dst.carrierAIDC = this.carrierAIDC == null ? null : this.carrierAIDC.copy();
        dst.carrierHRF = this.carrierHRF == null ? null : this.carrierHRF.copy();
        return dst;
    }

    protected ItemInstance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ItemInstance)) {
            return false;
        }
        ItemInstance o = (ItemInstance)other_;
        return ItemInstance.compareDeep(this.count, o.count, true) && ItemInstance.compareDeep(this.location, o.location, true) && ItemInstance.compareDeep(this.subject, o.subject, true) && ItemInstance.compareDeep(this.manufactureDate, o.manufactureDate, true) && ItemInstance.compareDeep(this.expiryDate, o.expiryDate, true) && ItemInstance.compareDeep(this.currentSWVersion, o.currentSWVersion, true) && ItemInstance.compareDeep(this.lotNumber, o.lotNumber, true) && ItemInstance.compareDeep(this.serialNumber, o.serialNumber, true) && ItemInstance.compareDeep(this.carrierAIDC, o.carrierAIDC, true) && ItemInstance.compareDeep(this.carrierHRF, o.carrierHRF, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ItemInstance)) {
            return false;
        }
        ItemInstance o = (ItemInstance)other_;
        return ItemInstance.compareValues(this.count, o.count, true) && ItemInstance.compareValues(this.manufactureDate, o.manufactureDate, true) && ItemInstance.compareValues(this.expiryDate, o.expiryDate, true) && ItemInstance.compareValues(this.currentSWVersion, o.currentSWVersion, true) && ItemInstance.compareValues(this.lotNumber, o.lotNumber, true) && ItemInstance.compareValues(this.serialNumber, o.serialNumber, true) && ItemInstance.compareValues(this.carrierAIDC, o.carrierAIDC, true) && ItemInstance.compareValues(this.carrierHRF, o.carrierHRF, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.count, this.location, this.subject, this.manufactureDate, this.expiryDate, this.currentSWVersion, this.lotNumber, this.serialNumber, this.carrierAIDC, this.carrierHRF});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ItemInstance;
    }
}

