/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Type;

@ResourceDef(name="MedicinalProductUndesirableEffect", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductUndesirableEffect")
public class MedicinalProductUndesirableEffect
extends DomainResource {
    @Child(name="subject", type={MedicinalProduct.class, Medication.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The medication for which this is an indication", formalDefinition="The medication for which this is an indication.")
    protected List<Reference> subject;
    protected List<Resource> subjectTarget;
    @Child(name="symptomConditionEffect", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The symptom, condition or undesirable effect", formalDefinition="The symptom, condition or undesirable effect.")
    protected CodeableConcept symptomConditionEffect;
    @Child(name="classification", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of the effect", formalDefinition="Classification of the effect.")
    protected CodeableConcept classification;
    @Child(name="frequencyOfOccurrence", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The frequency of occurrence of the effect", formalDefinition="The frequency of occurrence of the effect.")
    protected CodeableConcept frequencyOfOccurrence;
    @Child(name="population", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The population group to which this applies", formalDefinition="The population group to which this applies.")
    protected List<MedicinalProductUndesirableEffectPopulationComponent> population;
    private static final long serialVersionUID = 522261133L;
    @SearchParamDefinition(name="subject", path="MedicinalProductUndesirableEffect.subject", description="The medication for which this is an undesirable effect", type="reference", target={Medication.class, MedicinalProduct.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicinalProductUndesirableEffect:subject").toLocked();

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public MedicinalProductUndesirableEffect setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public MedicinalProductUndesirableEffect addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    @Deprecated
    public List<Resource> getSubjectTarget() {
        if (this.subjectTarget == null) {
            this.subjectTarget = new ArrayList<Resource>();
        }
        return this.subjectTarget;
    }

    public CodeableConcept getSymptomConditionEffect() {
        if (this.symptomConditionEffect == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductUndesirableEffect.symptomConditionEffect");
            }
            if (Configuration.doAutoCreate()) {
                this.symptomConditionEffect = new CodeableConcept();
            }
        }
        return this.symptomConditionEffect;
    }

    public boolean hasSymptomConditionEffect() {
        return this.symptomConditionEffect != null && !this.symptomConditionEffect.isEmpty();
    }

    public MedicinalProductUndesirableEffect setSymptomConditionEffect(CodeableConcept value) {
        this.symptomConditionEffect = value;
        return this;
    }

    public CodeableConcept getClassification() {
        if (this.classification == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductUndesirableEffect.classification");
            }
            if (Configuration.doAutoCreate()) {
                this.classification = new CodeableConcept();
            }
        }
        return this.classification;
    }

    public boolean hasClassification() {
        return this.classification != null && !this.classification.isEmpty();
    }

    public MedicinalProductUndesirableEffect setClassification(CodeableConcept value) {
        this.classification = value;
        return this;
    }

    public CodeableConcept getFrequencyOfOccurrence() {
        if (this.frequencyOfOccurrence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductUndesirableEffect.frequencyOfOccurrence");
            }
            if (Configuration.doAutoCreate()) {
                this.frequencyOfOccurrence = new CodeableConcept();
            }
        }
        return this.frequencyOfOccurrence;
    }

    public boolean hasFrequencyOfOccurrence() {
        return this.frequencyOfOccurrence != null && !this.frequencyOfOccurrence.isEmpty();
    }

    public MedicinalProductUndesirableEffect setFrequencyOfOccurrence(CodeableConcept value) {
        this.frequencyOfOccurrence = value;
        return this;
    }

    public List<MedicinalProductUndesirableEffectPopulationComponent> getPopulation() {
        if (this.population == null) {
            this.population = new ArrayList<MedicinalProductUndesirableEffectPopulationComponent>();
        }
        return this.population;
    }

    public MedicinalProductUndesirableEffect setPopulation(List<MedicinalProductUndesirableEffectPopulationComponent> thePopulation) {
        this.population = thePopulation;
        return this;
    }

    public boolean hasPopulation() {
        if (this.population == null) {
            return false;
        }
        for (MedicinalProductUndesirableEffectPopulationComponent item : this.population) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductUndesirableEffectPopulationComponent addPopulation() {
        MedicinalProductUndesirableEffectPopulationComponent t = new MedicinalProductUndesirableEffectPopulationComponent();
        if (this.population == null) {
            this.population = new ArrayList<MedicinalProductUndesirableEffectPopulationComponent>();
        }
        this.population.add(t);
        return t;
    }

    public MedicinalProductUndesirableEffect addPopulation(MedicinalProductUndesirableEffectPopulationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.population == null) {
            this.population = new ArrayList<MedicinalProductUndesirableEffectPopulationComponent>();
        }
        this.population.add(t);
        return this;
    }

    public MedicinalProductUndesirableEffectPopulationComponent getPopulationFirstRep() {
        if (this.getPopulation().isEmpty()) {
            this.addPopulation();
        }
        return this.getPopulation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProduct|Medication)", "The medication for which this is an indication.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("symptomConditionEffect", "CodeableConcept", "The symptom, condition or undesirable effect.", 0, 1, this.symptomConditionEffect));
        children.add(new Property("classification", "CodeableConcept", "Classification of the effect.", 0, 1, this.classification));
        children.add(new Property("frequencyOfOccurrence", "CodeableConcept", "The frequency of occurrence of the effect.", 0, 1, this.frequencyOfOccurrence));
        children.add(new Property("population", "", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProduct|Medication)", "The medication for which this is an indication.", 0, Integer.MAX_VALUE, this.subject);
            }
            case -650549981: {
                return new Property("symptomConditionEffect", "CodeableConcept", "The symptom, condition or undesirable effect.", 0, 1, this.symptomConditionEffect);
            }
            case 382350310: {
                return new Property("classification", "CodeableConcept", "Classification of the effect.", 0, 1, this.classification);
            }
            case 791175812: {
                return new Property("frequencyOfOccurrence", "CodeableConcept", "The frequency of occurrence of the effect.", 0, 1, this.frequencyOfOccurrence);
            }
            case -2023558323: {
                return new Property("population", "", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case -650549981: {
                Base[] baseArray;
                if (this.symptomConditionEffect == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.symptomConditionEffect;
                }
                return baseArray;
            }
            case 382350310: {
                Base[] baseArray;
                if (this.classification == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.classification;
                }
                return baseArray;
            }
            case 791175812: {
                Base[] baseArray;
                if (this.frequencyOfOccurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.frequencyOfOccurrence;
                }
                return baseArray;
            }
            case -2023558323: {
                return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                this.getSubject().add(this.castToReference(value));
                return value;
            }
            case -650549981: {
                this.symptomConditionEffect = this.castToCodeableConcept(value);
                return value;
            }
            case 382350310: {
                this.classification = this.castToCodeableConcept(value);
                return value;
            }
            case 791175812: {
                this.frequencyOfOccurrence = this.castToCodeableConcept(value);
                return value;
            }
            case -2023558323: {
                this.getPopulation().add((MedicinalProductUndesirableEffectPopulationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals("symptomConditionEffect")) {
            this.symptomConditionEffect = this.castToCodeableConcept(value);
        } else if (name.equals("classification")) {
            this.classification = this.castToCodeableConcept(value);
        } else if (name.equals("frequencyOfOccurrence")) {
            this.frequencyOfOccurrence = this.castToCodeableConcept(value);
        } else if (name.equals("population")) {
            this.getPopulation().add((MedicinalProductUndesirableEffectPopulationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.addSubject();
            }
            case -650549981: {
                return this.getSymptomConditionEffect();
            }
            case 382350310: {
                return this.getClassification();
            }
            case 791175812: {
                return this.getFrequencyOfOccurrence();
            }
            case -2023558323: {
                return this.addPopulation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -650549981: {
                return new String[]{"CodeableConcept"};
            }
            case 382350310: {
                return new String[]{"CodeableConcept"};
            }
            case 791175812: {
                return new String[]{"CodeableConcept"};
            }
            case -2023558323: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("symptomConditionEffect")) {
            this.symptomConditionEffect = new CodeableConcept();
            return this.symptomConditionEffect;
        }
        if (name.equals("classification")) {
            this.classification = new CodeableConcept();
            return this.classification;
        }
        if (name.equals("frequencyOfOccurrence")) {
            this.frequencyOfOccurrence = new CodeableConcept();
            return this.frequencyOfOccurrence;
        }
        if (name.equals("population")) {
            return this.addPopulation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductUndesirableEffect";
    }

    @Override
    public MedicinalProductUndesirableEffect copy() {
        MedicinalProductUndesirableEffect dst = new MedicinalProductUndesirableEffect();
        this.copyValues(dst);
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.symptomConditionEffect = this.symptomConditionEffect == null ? null : this.symptomConditionEffect.copy();
        dst.classification = this.classification == null ? null : this.classification.copy();
        CodeableConcept codeableConcept = dst.frequencyOfOccurrence = this.frequencyOfOccurrence == null ? null : this.frequencyOfOccurrence.copy();
        if (this.population != null) {
            dst.population = new ArrayList<MedicinalProductUndesirableEffectPopulationComponent>();
            for (MedicinalProductUndesirableEffectPopulationComponent medicinalProductUndesirableEffectPopulationComponent : this.population) {
                dst.population.add(medicinalProductUndesirableEffectPopulationComponent.copy());
            }
        }
        return dst;
    }

    protected MedicinalProductUndesirableEffect typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductUndesirableEffect)) {
            return false;
        }
        MedicinalProductUndesirableEffect o = (MedicinalProductUndesirableEffect)other_;
        return MedicinalProductUndesirableEffect.compareDeep(this.subject, o.subject, true) && MedicinalProductUndesirableEffect.compareDeep(this.symptomConditionEffect, o.symptomConditionEffect, true) && MedicinalProductUndesirableEffect.compareDeep(this.classification, o.classification, true) && MedicinalProductUndesirableEffect.compareDeep(this.frequencyOfOccurrence, o.frequencyOfOccurrence, true) && MedicinalProductUndesirableEffect.compareDeep(this.population, o.population, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductUndesirableEffect)) {
            return false;
        }
        MedicinalProductUndesirableEffect o = (MedicinalProductUndesirableEffect)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.subject, this.symptomConditionEffect, this.classification, this.frequencyOfOccurrence, this.population});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductUndesirableEffect;
    }

    @Block
    public static class MedicinalProductUndesirableEffectPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="age", type={Range.class, CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The age of the specific population", formalDefinition="The age of the specific population.")
        protected Type age;
        @Child(name="gender", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The gender of the specific population", formalDefinition="The gender of the specific population.")
        protected CodeableConcept gender;
        @Child(name="race", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Race of the specific population", formalDefinition="Race of the specific population.")
        protected CodeableConcept race;
        @Child(name="physiologicalCondition", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The existing physiological conditions of the specific population to which this applies", formalDefinition="The existing physiological conditions of the specific population to which this applies.")
        protected CodeableConcept physiologicalCondition;
        private static final long serialVersionUID = -394311584L;

        public Type getAge() {
            return this.age;
        }

        public Range getAgeRange() throws FHIRException {
            if (this.age == null) {
                return null;
            }
            if (!(this.age instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.age.getClass().getName() + " was encountered");
            }
            return (Range)this.age;
        }

        public boolean hasAgeRange() {
            return this != null && this.age instanceof Range;
        }

        public CodeableConcept getAgeCodeableConcept() throws FHIRException {
            if (this.age == null) {
                return null;
            }
            if (!(this.age instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.age.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.age;
        }

        public boolean hasAgeCodeableConcept() {
            return this != null && this.age instanceof CodeableConcept;
        }

        public boolean hasAge() {
            return this.age != null && !this.age.isEmpty();
        }

        public MedicinalProductUndesirableEffectPopulationComponent setAge(Type value) {
            if (value != null && !(value instanceof Range) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for MedicinalProductUndesirableEffect.population.age[x]: " + value.fhirType());
            }
            this.age = value;
            return this;
        }

        public CodeableConcept getGender() {
            if (this.gender == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductUndesirableEffectPopulationComponent.gender");
                }
                if (Configuration.doAutoCreate()) {
                    this.gender = new CodeableConcept();
                }
            }
            return this.gender;
        }

        public boolean hasGender() {
            return this.gender != null && !this.gender.isEmpty();
        }

        public MedicinalProductUndesirableEffectPopulationComponent setGender(CodeableConcept value) {
            this.gender = value;
            return this;
        }

        public CodeableConcept getRace() {
            if (this.race == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductUndesirableEffectPopulationComponent.race");
                }
                if (Configuration.doAutoCreate()) {
                    this.race = new CodeableConcept();
                }
            }
            return this.race;
        }

        public boolean hasRace() {
            return this.race != null && !this.race.isEmpty();
        }

        public MedicinalProductUndesirableEffectPopulationComponent setRace(CodeableConcept value) {
            this.race = value;
            return this;
        }

        public CodeableConcept getPhysiologicalCondition() {
            if (this.physiologicalCondition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductUndesirableEffectPopulationComponent.physiologicalCondition");
                }
                if (Configuration.doAutoCreate()) {
                    this.physiologicalCondition = new CodeableConcept();
                }
            }
            return this.physiologicalCondition;
        }

        public boolean hasPhysiologicalCondition() {
            return this.physiologicalCondition != null && !this.physiologicalCondition.isEmpty();
        }

        public MedicinalProductUndesirableEffectPopulationComponent setPhysiologicalCondition(CodeableConcept value) {
            this.physiologicalCondition = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age));
            children.add(new Property("gender", "CodeableConcept", "The gender of the specific population.", 0, 1, this.gender));
            children.add(new Property("race", "CodeableConcept", "Race of the specific population.", 0, 1, this.race));
            children.add(new Property("physiologicalCondition", "CodeableConcept", "The existing physiological conditions of the specific population to which this applies.", 0, 1, this.physiologicalCondition));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1419716831: {
                    return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
                }
                case 96511: {
                    return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
                }
                case 1442748286: {
                    return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
                }
                case -1452658526: {
                    return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
                }
                case -1249512767: {
                    return new Property("gender", "CodeableConcept", "The gender of the specific population.", 0, 1, this.gender);
                }
                case 3492561: {
                    return new Property("race", "CodeableConcept", "Race of the specific population.", 0, 1, this.race);
                }
                case -62715190: {
                    return new Property("physiologicalCondition", "CodeableConcept", "The existing physiological conditions of the specific population to which this applies.", 0, 1, this.physiologicalCondition);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 96511: {
                    Base[] baseArray;
                    if (this.age == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.age;
                    }
                    return baseArray;
                }
                case -1249512767: {
                    Base[] baseArray;
                    if (this.gender == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.gender;
                    }
                    return baseArray;
                }
                case 3492561: {
                    Base[] baseArray;
                    if (this.race == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.race;
                    }
                    return baseArray;
                }
                case -62715190: {
                    Base[] baseArray;
                    if (this.physiologicalCondition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.physiologicalCondition;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 96511: {
                    this.age = this.castToType(value);
                    return value;
                }
                case -1249512767: {
                    this.gender = this.castToCodeableConcept(value);
                    return value;
                }
                case 3492561: {
                    this.race = this.castToCodeableConcept(value);
                    return value;
                }
                case -62715190: {
                    this.physiologicalCondition = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("age[x]")) {
                this.age = this.castToType(value);
            } else if (name.equals("gender")) {
                this.gender = this.castToCodeableConcept(value);
            } else if (name.equals("race")) {
                this.race = this.castToCodeableConcept(value);
            } else if (name.equals("physiologicalCondition")) {
                this.physiologicalCondition = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1419716831: {
                    return this.getAge();
                }
                case 96511: {
                    return this.getAge();
                }
                case -1249512767: {
                    return this.getGender();
                }
                case 3492561: {
                    return this.getRace();
                }
                case -62715190: {
                    return this.getPhysiologicalCondition();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 96511: {
                    return new String[]{"Range", "CodeableConcept"};
                }
                case -1249512767: {
                    return new String[]{"CodeableConcept"};
                }
                case 3492561: {
                    return new String[]{"CodeableConcept"};
                }
                case -62715190: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("ageRange")) {
                this.age = new Range();
                return this.age;
            }
            if (name.equals("ageCodeableConcept")) {
                this.age = new CodeableConcept();
                return this.age;
            }
            if (name.equals("gender")) {
                this.gender = new CodeableConcept();
                return this.gender;
            }
            if (name.equals("race")) {
                this.race = new CodeableConcept();
                return this.race;
            }
            if (name.equals("physiologicalCondition")) {
                this.physiologicalCondition = new CodeableConcept();
                return this.physiologicalCondition;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductUndesirableEffectPopulationComponent copy() {
            MedicinalProductUndesirableEffectPopulationComponent dst = new MedicinalProductUndesirableEffectPopulationComponent();
            this.copyValues(dst);
            dst.age = this.age == null ? null : this.age.copy();
            dst.gender = this.gender == null ? null : this.gender.copy();
            dst.race = this.race == null ? null : this.race.copy();
            dst.physiologicalCondition = this.physiologicalCondition == null ? null : this.physiologicalCondition.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductUndesirableEffectPopulationComponent)) {
                return false;
            }
            MedicinalProductUndesirableEffectPopulationComponent o = (MedicinalProductUndesirableEffectPopulationComponent)other_;
            return MedicinalProductUndesirableEffectPopulationComponent.compareDeep(this.age, o.age, true) && MedicinalProductUndesirableEffectPopulationComponent.compareDeep(this.gender, o.gender, true) && MedicinalProductUndesirableEffectPopulationComponent.compareDeep(this.race, o.race, true) && MedicinalProductUndesirableEffectPopulationComponent.compareDeep(this.physiologicalCondition, o.physiologicalCondition, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductUndesirableEffectPopulationComponent)) {
                return false;
            }
            MedicinalProductUndesirableEffectPopulationComponent o = (MedicinalProductUndesirableEffectPopulationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.age, this.gender, this.race, this.physiologicalCondition});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductUndesirableEffect.population";
        }
    }
}

