/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ObservationDefinition", profile="http://hl7.org/fhir/StructureDefinition/ObservationDefinition")
public class ObservationDefinition
extends DomainResource {
    @Child(name="category", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Category of observation", formalDefinition="A code that classifies the general type of observation.")
    protected CodeableConcept category;
    @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of observation (code / type)", formalDefinition="Describes what will be observed. Sometimes this is called the observation \"name\".")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
    protected CodeableConcept code;
    @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier for this ObservationDefinition artifact", formalDefinition="Unique identifier for this ObservationDefinition artifact.")
    protected List<Identifier> identifier;
    @Child(name="permittedDataType", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Permitted data type for observation value", formalDefinition="Data type allowed for the result of the observation.")
    protected List<Coding> permittedDataType;
    @Child(name="multipleResultsAllowed", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Multiple results allowed", formalDefinition="Multiple results allowed for this kind of observation.")
    protected BooleanType multipleResultsAllowed;
    @Child(name="method", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The method or technique used to perform the observation", formalDefinition="The method or technique used to perform the observation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-methods")
    protected CodeableConcept method;
    @Child(name="preferredReportName", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Preferred report name", formalDefinition="The preferred name to be used when reporting the results of this observation.")
    protected StringType preferredReportName;
    @Child(name="quantitativeDetails", type={}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Characteristics of quantitative results", formalDefinition="Characteristics for quantitative results of this observation.")
    protected ObservationDefinitionQuantitativeDetailsComponent quantitativeDetails;
    @Child(name="qualifiedInterval", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reference range for observation result", formalDefinition="Reference range for ordinal and continuous observations.")
    protected List<ObservationDefinitionQualifiedIntervalComponent> qualifiedInterval;
    @Child(name="validCodedValueSet", type={UriType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Value set of valid coded values for the observation", formalDefinition="The set of valid coded results for the observation.")
    protected UriType validCodedValueSet;
    @Child(name="normalCodedValueSet", type={UriType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Value set of normal coded values for the observation", formalDefinition="The set of normal coded results for the observation.")
    protected UriType normalCodedValueSet;
    @Child(name="abnormalCodedValueSet", type={UriType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Value set of abnormal coded values for the observation", formalDefinition="The set of abnormal coded results for the observation.")
    protected UriType abnormalCodedValueSet;
    @Child(name="criticalCodedValueSet", type={UriType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Value set of critical coded values for the observation", formalDefinition="The set of critical coded results for the observation.")
    protected UriType criticalCodedValueSet;
    private static final long serialVersionUID = 1248420796L;

    public ObservationDefinition() {
    }

    public ObservationDefinition(CodeableConcept code) {
        this.code = code;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public ObservationDefinition setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ObservationDefinition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ObservationDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ObservationDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Coding> getPermittedDataType() {
        if (this.permittedDataType == null) {
            this.permittedDataType = new ArrayList<Coding>();
        }
        return this.permittedDataType;
    }

    public ObservationDefinition setPermittedDataType(List<Coding> thePermittedDataType) {
        this.permittedDataType = thePermittedDataType;
        return this;
    }

    public boolean hasPermittedDataType() {
        if (this.permittedDataType == null) {
            return false;
        }
        for (Coding item : this.permittedDataType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addPermittedDataType() {
        Coding t = new Coding();
        if (this.permittedDataType == null) {
            this.permittedDataType = new ArrayList<Coding>();
        }
        this.permittedDataType.add(t);
        return t;
    }

    public ObservationDefinition addPermittedDataType(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.permittedDataType == null) {
            this.permittedDataType = new ArrayList<Coding>();
        }
        this.permittedDataType.add(t);
        return this;
    }

    public Coding getPermittedDataTypeFirstRep() {
        if (this.getPermittedDataType().isEmpty()) {
            this.addPermittedDataType();
        }
        return this.getPermittedDataType().get(0);
    }

    public BooleanType getMultipleResultsAllowedElement() {
        if (this.multipleResultsAllowed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.multipleResultsAllowed");
            }
            if (Configuration.doAutoCreate()) {
                this.multipleResultsAllowed = new BooleanType();
            }
        }
        return this.multipleResultsAllowed;
    }

    public boolean hasMultipleResultsAllowedElement() {
        return this.multipleResultsAllowed != null && !this.multipleResultsAllowed.isEmpty();
    }

    public boolean hasMultipleResultsAllowed() {
        return this.multipleResultsAllowed != null && !this.multipleResultsAllowed.isEmpty();
    }

    public ObservationDefinition setMultipleResultsAllowedElement(BooleanType value) {
        this.multipleResultsAllowed = value;
        return this;
    }

    public boolean getMultipleResultsAllowed() {
        return this.multipleResultsAllowed == null || this.multipleResultsAllowed.isEmpty() ? false : (Boolean)this.multipleResultsAllowed.getValue();
    }

    public ObservationDefinition setMultipleResultsAllowed(boolean value) {
        if (this.multipleResultsAllowed == null) {
            this.multipleResultsAllowed = new BooleanType();
        }
        this.multipleResultsAllowed.setValue((Object)value);
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public ObservationDefinition setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public StringType getPreferredReportNameElement() {
        if (this.preferredReportName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.preferredReportName");
            }
            if (Configuration.doAutoCreate()) {
                this.preferredReportName = new StringType();
            }
        }
        return this.preferredReportName;
    }

    public boolean hasPreferredReportNameElement() {
        return this.preferredReportName != null && !this.preferredReportName.isEmpty();
    }

    public boolean hasPreferredReportName() {
        return this.preferredReportName != null && !this.preferredReportName.isEmpty();
    }

    public ObservationDefinition setPreferredReportNameElement(StringType value) {
        this.preferredReportName = value;
        return this;
    }

    public String getPreferredReportName() {
        return this.preferredReportName == null ? null : (String)this.preferredReportName.getValue();
    }

    public ObservationDefinition setPreferredReportName(String value) {
        if (Utilities.noString((String)value)) {
            this.preferredReportName = null;
        } else {
            if (this.preferredReportName == null) {
                this.preferredReportName = new StringType();
            }
            this.preferredReportName.setValue(value);
        }
        return this;
    }

    public ObservationDefinitionQuantitativeDetailsComponent getQuantitativeDetails() {
        if (this.quantitativeDetails == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.quantitativeDetails");
            }
            if (Configuration.doAutoCreate()) {
                this.quantitativeDetails = new ObservationDefinitionQuantitativeDetailsComponent();
            }
        }
        return this.quantitativeDetails;
    }

    public boolean hasQuantitativeDetails() {
        return this.quantitativeDetails != null && !this.quantitativeDetails.isEmpty();
    }

    public ObservationDefinition setQuantitativeDetails(ObservationDefinitionQuantitativeDetailsComponent value) {
        this.quantitativeDetails = value;
        return this;
    }

    public List<ObservationDefinitionQualifiedIntervalComponent> getQualifiedInterval() {
        if (this.qualifiedInterval == null) {
            this.qualifiedInterval = new ArrayList<ObservationDefinitionQualifiedIntervalComponent>();
        }
        return this.qualifiedInterval;
    }

    public ObservationDefinition setQualifiedInterval(List<ObservationDefinitionQualifiedIntervalComponent> theQualifiedInterval) {
        this.qualifiedInterval = theQualifiedInterval;
        return this;
    }

    public boolean hasQualifiedInterval() {
        if (this.qualifiedInterval == null) {
            return false;
        }
        for (ObservationDefinitionQualifiedIntervalComponent item : this.qualifiedInterval) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ObservationDefinitionQualifiedIntervalComponent addQualifiedInterval() {
        ObservationDefinitionQualifiedIntervalComponent t = new ObservationDefinitionQualifiedIntervalComponent();
        if (this.qualifiedInterval == null) {
            this.qualifiedInterval = new ArrayList<ObservationDefinitionQualifiedIntervalComponent>();
        }
        this.qualifiedInterval.add(t);
        return t;
    }

    public ObservationDefinition addQualifiedInterval(ObservationDefinitionQualifiedIntervalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.qualifiedInterval == null) {
            this.qualifiedInterval = new ArrayList<ObservationDefinitionQualifiedIntervalComponent>();
        }
        this.qualifiedInterval.add(t);
        return this;
    }

    public ObservationDefinitionQualifiedIntervalComponent getQualifiedIntervalFirstRep() {
        if (this.getQualifiedInterval().isEmpty()) {
            this.addQualifiedInterval();
        }
        return this.getQualifiedInterval().get(0);
    }

    public UriType getValidCodedValueSetElement() {
        if (this.validCodedValueSet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.validCodedValueSet");
            }
            if (Configuration.doAutoCreate()) {
                this.validCodedValueSet = new UriType();
            }
        }
        return this.validCodedValueSet;
    }

    public boolean hasValidCodedValueSetElement() {
        return this.validCodedValueSet != null && !this.validCodedValueSet.isEmpty();
    }

    public boolean hasValidCodedValueSet() {
        return this.validCodedValueSet != null && !this.validCodedValueSet.isEmpty();
    }

    public ObservationDefinition setValidCodedValueSetElement(UriType value) {
        this.validCodedValueSet = value;
        return this;
    }

    public String getValidCodedValueSet() {
        return this.validCodedValueSet == null ? null : (String)this.validCodedValueSet.getValue();
    }

    public ObservationDefinition setValidCodedValueSet(String value) {
        if (Utilities.noString((String)value)) {
            this.validCodedValueSet = null;
        } else {
            if (this.validCodedValueSet == null) {
                this.validCodedValueSet = new UriType();
            }
            this.validCodedValueSet.setValue(value);
        }
        return this;
    }

    public UriType getNormalCodedValueSetElement() {
        if (this.normalCodedValueSet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.normalCodedValueSet");
            }
            if (Configuration.doAutoCreate()) {
                this.normalCodedValueSet = new UriType();
            }
        }
        return this.normalCodedValueSet;
    }

    public boolean hasNormalCodedValueSetElement() {
        return this.normalCodedValueSet != null && !this.normalCodedValueSet.isEmpty();
    }

    public boolean hasNormalCodedValueSet() {
        return this.normalCodedValueSet != null && !this.normalCodedValueSet.isEmpty();
    }

    public ObservationDefinition setNormalCodedValueSetElement(UriType value) {
        this.normalCodedValueSet = value;
        return this;
    }

    public String getNormalCodedValueSet() {
        return this.normalCodedValueSet == null ? null : (String)this.normalCodedValueSet.getValue();
    }

    public ObservationDefinition setNormalCodedValueSet(String value) {
        if (Utilities.noString((String)value)) {
            this.normalCodedValueSet = null;
        } else {
            if (this.normalCodedValueSet == null) {
                this.normalCodedValueSet = new UriType();
            }
            this.normalCodedValueSet.setValue(value);
        }
        return this;
    }

    public UriType getAbnormalCodedValueSetElement() {
        if (this.abnormalCodedValueSet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.abnormalCodedValueSet");
            }
            if (Configuration.doAutoCreate()) {
                this.abnormalCodedValueSet = new UriType();
            }
        }
        return this.abnormalCodedValueSet;
    }

    public boolean hasAbnormalCodedValueSetElement() {
        return this.abnormalCodedValueSet != null && !this.abnormalCodedValueSet.isEmpty();
    }

    public boolean hasAbnormalCodedValueSet() {
        return this.abnormalCodedValueSet != null && !this.abnormalCodedValueSet.isEmpty();
    }

    public ObservationDefinition setAbnormalCodedValueSetElement(UriType value) {
        this.abnormalCodedValueSet = value;
        return this;
    }

    public String getAbnormalCodedValueSet() {
        return this.abnormalCodedValueSet == null ? null : (String)this.abnormalCodedValueSet.getValue();
    }

    public ObservationDefinition setAbnormalCodedValueSet(String value) {
        if (Utilities.noString((String)value)) {
            this.abnormalCodedValueSet = null;
        } else {
            if (this.abnormalCodedValueSet == null) {
                this.abnormalCodedValueSet = new UriType();
            }
            this.abnormalCodedValueSet.setValue(value);
        }
        return this;
    }

    public UriType getCriticalCodedValueSetElement() {
        if (this.criticalCodedValueSet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ObservationDefinition.criticalCodedValueSet");
            }
            if (Configuration.doAutoCreate()) {
                this.criticalCodedValueSet = new UriType();
            }
        }
        return this.criticalCodedValueSet;
    }

    public boolean hasCriticalCodedValueSetElement() {
        return this.criticalCodedValueSet != null && !this.criticalCodedValueSet.isEmpty();
    }

    public boolean hasCriticalCodedValueSet() {
        return this.criticalCodedValueSet != null && !this.criticalCodedValueSet.isEmpty();
    }

    public ObservationDefinition setCriticalCodedValueSetElement(UriType value) {
        this.criticalCodedValueSet = value;
        return this;
    }

    public String getCriticalCodedValueSet() {
        return this.criticalCodedValueSet == null ? null : (String)this.criticalCodedValueSet.getValue();
    }

    public ObservationDefinition setCriticalCodedValueSet(String value) {
        if (Utilities.noString((String)value)) {
            this.criticalCodedValueSet = null;
        } else {
            if (this.criticalCodedValueSet == null) {
                this.criticalCodedValueSet = new UriType();
            }
            this.criticalCodedValueSet.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("category", "CodeableConcept", "A code that classifies the general type of observation.", 0, 1, this.category));
        children.add(new Property("code", "CodeableConcept", "Describes what will be observed. Sometimes this is called the observation \"name\".", 0, 1, this.code));
        children.add(new Property("identifier", "Identifier", "Unique identifier for this ObservationDefinition artifact.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("permittedDataType", "Coding", "Data type allowed for the result of the observation.", 0, Integer.MAX_VALUE, this.permittedDataType));
        children.add(new Property("multipleResultsAllowed", "boolean", "Multiple results allowed for this kind of observation.", 0, 1, this.multipleResultsAllowed));
        children.add(new Property("method", "CodeableConcept", "The method or technique used to perform the observation.", 0, 1, this.method));
        children.add(new Property("preferredReportName", "string", "The preferred name to be used when reporting the results of this observation.", 0, 1, this.preferredReportName));
        children.add(new Property("quantitativeDetails", "", "Characteristics for quantitative results of this observation.", 0, 1, this.quantitativeDetails));
        children.add(new Property("qualifiedInterval", "", "Reference range for ordinal and continuous observations.", 0, Integer.MAX_VALUE, this.qualifiedInterval));
        children.add(new Property("validCodedValueSet", "uri", "The set of valid coded results for the observation.", 0, 1, this.validCodedValueSet));
        children.add(new Property("normalCodedValueSet", "uri", "The set of normal coded results for the observation.", 0, 1, this.normalCodedValueSet));
        children.add(new Property("abnormalCodedValueSet", "uri", "The set of abnormal coded results for the observation.", 0, 1, this.abnormalCodedValueSet));
        children.add(new Property("criticalCodedValueSet", "uri", "The set of critical coded results for the observation.", 0, 1, this.criticalCodedValueSet));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 50511102: {
                return new Property("category", "CodeableConcept", "A code that classifies the general type of observation.", 0, 1, this.category);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Describes what will be observed. Sometimes this is called the observation \"name\".", 0, 1, this.code);
            }
            case -1618432855: {
                return new Property("identifier", "Identifier", "Unique identifier for this ObservationDefinition artifact.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -99492804: {
                return new Property("permittedDataType", "Coding", "Data type allowed for the result of the observation.", 0, Integer.MAX_VALUE, this.permittedDataType);
            }
            case -2102414590: {
                return new Property("multipleResultsAllowed", "boolean", "Multiple results allowed for this kind of observation.", 0, 1, this.multipleResultsAllowed);
            }
            case -1077554975: {
                return new Property("method", "CodeableConcept", "The method or technique used to perform the observation.", 0, 1, this.method);
            }
            case -1851030208: {
                return new Property("preferredReportName", "string", "The preferred name to be used when reporting the results of this observation.", 0, 1, this.preferredReportName);
            }
            case 842150763: {
                return new Property("quantitativeDetails", "", "Characteristics for quantitative results of this observation.", 0, 1, this.quantitativeDetails);
            }
            case 1882971521: {
                return new Property("qualifiedInterval", "", "Reference range for ordinal and continuous observations.", 0, Integer.MAX_VALUE, this.qualifiedInterval);
            }
            case 1374640076: {
                return new Property("validCodedValueSet", "uri", "The set of valid coded results for the observation.", 0, 1, this.validCodedValueSet);
            }
            case -837500735: {
                return new Property("normalCodedValueSet", "uri", "The set of normal coded results for the observation.", 0, 1, this.normalCodedValueSet);
            }
            case 1073600256: {
                return new Property("abnormalCodedValueSet", "uri", "The set of abnormal coded results for the observation.", 0, 1, this.abnormalCodedValueSet);
            }
            case 2568457: {
                return new Property("criticalCodedValueSet", "uri", "The set of critical coded results for the observation.", 0, 1, this.criticalCodedValueSet);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.category;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -99492804: {
                return this.permittedDataType == null ? new Base[]{} : this.permittedDataType.toArray(new Base[this.permittedDataType.size()]);
            }
            case -2102414590: {
                Base[] baseArray;
                if (this.multipleResultsAllowed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.multipleResultsAllowed;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.method;
                }
                return baseArray;
            }
            case -1851030208: {
                Base[] baseArray;
                if (this.preferredReportName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.preferredReportName;
                }
                return baseArray;
            }
            case 842150763: {
                Base[] baseArray;
                if (this.quantitativeDetails == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.quantitativeDetails;
                }
                return baseArray;
            }
            case 1882971521: {
                return this.qualifiedInterval == null ? new Base[]{} : this.qualifiedInterval.toArray(new Base[this.qualifiedInterval.size()]);
            }
            case 1374640076: {
                Base[] baseArray;
                if (this.validCodedValueSet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.validCodedValueSet;
                }
                return baseArray;
            }
            case -837500735: {
                Base[] baseArray;
                if (this.normalCodedValueSet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.normalCodedValueSet;
                }
                return baseArray;
            }
            case 1073600256: {
                Base[] baseArray;
                if (this.abnormalCodedValueSet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.abnormalCodedValueSet;
                }
                return baseArray;
            }
            case 2568457: {
                Base[] baseArray;
                if (this.criticalCodedValueSet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.criticalCodedValueSet;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -99492804: {
                this.getPermittedDataType().add(this.castToCoding(value));
                return value;
            }
            case -2102414590: {
                this.multipleResultsAllowed = this.castToBoolean(value);
                return value;
            }
            case -1077554975: {
                this.method = this.castToCodeableConcept(value);
                return value;
            }
            case -1851030208: {
                this.preferredReportName = this.castToString(value);
                return value;
            }
            case 842150763: {
                this.quantitativeDetails = (ObservationDefinitionQuantitativeDetailsComponent)value;
                return value;
            }
            case 1882971521: {
                this.getQualifiedInterval().add((ObservationDefinitionQualifiedIntervalComponent)value);
                return value;
            }
            case 1374640076: {
                this.validCodedValueSet = this.castToUri(value);
                return value;
            }
            case -837500735: {
                this.normalCodedValueSet = this.castToUri(value);
                return value;
            }
            case 1073600256: {
                this.abnormalCodedValueSet = this.castToUri(value);
                return value;
            }
            case 2568457: {
                this.criticalCodedValueSet = this.castToUri(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("category")) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("permittedDataType")) {
            this.getPermittedDataType().add(this.castToCoding(value));
        } else if (name.equals("multipleResultsAllowed")) {
            this.multipleResultsAllowed = this.castToBoolean(value);
        } else if (name.equals("method")) {
            this.method = this.castToCodeableConcept(value);
        } else if (name.equals("preferredReportName")) {
            this.preferredReportName = this.castToString(value);
        } else if (name.equals("quantitativeDetails")) {
            this.quantitativeDetails = (ObservationDefinitionQuantitativeDetailsComponent)value;
        } else if (name.equals("qualifiedInterval")) {
            this.getQualifiedInterval().add((ObservationDefinitionQualifiedIntervalComponent)value);
        } else if (name.equals("validCodedValueSet")) {
            this.validCodedValueSet = this.castToUri(value);
        } else if (name.equals("normalCodedValueSet")) {
            this.normalCodedValueSet = this.castToUri(value);
        } else if (name.equals("abnormalCodedValueSet")) {
            this.abnormalCodedValueSet = this.castToUri(value);
        } else if (name.equals("criticalCodedValueSet")) {
            this.criticalCodedValueSet = this.castToUri(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 50511102: {
                return this.getCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -99492804: {
                return this.addPermittedDataType();
            }
            case -2102414590: {
                return this.getMultipleResultsAllowedElement();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case -1851030208: {
                return this.getPreferredReportNameElement();
            }
            case 842150763: {
                return this.getQuantitativeDetails();
            }
            case 1882971521: {
                return this.addQualifiedInterval();
            }
            case 1374640076: {
                return this.getValidCodedValueSetElement();
            }
            case -837500735: {
                return this.getNormalCodedValueSetElement();
            }
            case 1073600256: {
                return this.getAbnormalCodedValueSetElement();
            }
            case 2568457: {
                return this.getCriticalCodedValueSetElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -99492804: {
                return new String[]{"Coding"};
            }
            case -2102414590: {
                return new String[]{"boolean"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case -1851030208: {
                return new String[]{"string"};
            }
            case 842150763: {
                return new String[0];
            }
            case 1882971521: {
                return new String[0];
            }
            case 1374640076: {
                return new String[]{"uri"};
            }
            case -837500735: {
                return new String[]{"uri"};
            }
            case 1073600256: {
                return new String[]{"uri"};
            }
            case 2568457: {
                return new String[]{"uri"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("category")) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("permittedDataType")) {
            return this.addPermittedDataType();
        }
        if (name.equals("multipleResultsAllowed")) {
            throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.multipleResultsAllowed");
        }
        if (name.equals("method")) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals("preferredReportName")) {
            throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.preferredReportName");
        }
        if (name.equals("quantitativeDetails")) {
            this.quantitativeDetails = new ObservationDefinitionQuantitativeDetailsComponent();
            return this.quantitativeDetails;
        }
        if (name.equals("qualifiedInterval")) {
            return this.addQualifiedInterval();
        }
        if (name.equals("validCodedValueSet")) {
            throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.validCodedValueSet");
        }
        if (name.equals("normalCodedValueSet")) {
            throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.normalCodedValueSet");
        }
        if (name.equals("abnormalCodedValueSet")) {
            throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.abnormalCodedValueSet");
        }
        if (name.equals("criticalCodedValueSet")) {
            throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.criticalCodedValueSet");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ObservationDefinition";
    }

    @Override
    public ObservationDefinition copy() {
        ObservationDefinition dst = new ObservationDefinition();
        this.copyValues(dst);
        dst.category = this.category == null ? null : this.category.copy();
        CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.permittedDataType != null) {
            dst.permittedDataType = new ArrayList<Coding>();
            for (Coding coding : this.permittedDataType) {
                dst.permittedDataType.add(coding.copy());
            }
        }
        dst.multipleResultsAllowed = this.multipleResultsAllowed == null ? null : this.multipleResultsAllowed.copy();
        dst.method = this.method == null ? null : this.method.copy();
        dst.preferredReportName = this.preferredReportName == null ? null : this.preferredReportName.copy();
        ObservationDefinitionQuantitativeDetailsComponent observationDefinitionQuantitativeDetailsComponent = dst.quantitativeDetails = this.quantitativeDetails == null ? null : this.quantitativeDetails.copy();
        if (this.qualifiedInterval != null) {
            dst.qualifiedInterval = new ArrayList<ObservationDefinitionQualifiedIntervalComponent>();
            for (ObservationDefinitionQualifiedIntervalComponent observationDefinitionQualifiedIntervalComponent : this.qualifiedInterval) {
                dst.qualifiedInterval.add(observationDefinitionQualifiedIntervalComponent.copy());
            }
        }
        dst.validCodedValueSet = this.validCodedValueSet == null ? null : this.validCodedValueSet.copy();
        dst.normalCodedValueSet = this.normalCodedValueSet == null ? null : this.normalCodedValueSet.copy();
        dst.abnormalCodedValueSet = this.abnormalCodedValueSet == null ? null : this.abnormalCodedValueSet.copy();
        dst.criticalCodedValueSet = this.criticalCodedValueSet == null ? null : this.criticalCodedValueSet.copy();
        return dst;
    }

    protected ObservationDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ObservationDefinition)) {
            return false;
        }
        ObservationDefinition o = (ObservationDefinition)other_;
        return ObservationDefinition.compareDeep(this.category, o.category, true) && ObservationDefinition.compareDeep(this.code, o.code, true) && ObservationDefinition.compareDeep(this.identifier, o.identifier, true) && ObservationDefinition.compareDeep(this.permittedDataType, o.permittedDataType, true) && ObservationDefinition.compareDeep(this.multipleResultsAllowed, o.multipleResultsAllowed, true) && ObservationDefinition.compareDeep(this.method, o.method, true) && ObservationDefinition.compareDeep(this.preferredReportName, o.preferredReportName, true) && ObservationDefinition.compareDeep(this.quantitativeDetails, o.quantitativeDetails, true) && ObservationDefinition.compareDeep(this.qualifiedInterval, o.qualifiedInterval, true) && ObservationDefinition.compareDeep(this.validCodedValueSet, o.validCodedValueSet, true) && ObservationDefinition.compareDeep(this.normalCodedValueSet, o.normalCodedValueSet, true) && ObservationDefinition.compareDeep(this.abnormalCodedValueSet, o.abnormalCodedValueSet, true) && ObservationDefinition.compareDeep(this.criticalCodedValueSet, o.criticalCodedValueSet, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ObservationDefinition)) {
            return false;
        }
        ObservationDefinition o = (ObservationDefinition)other_;
        return ObservationDefinition.compareValues(this.multipleResultsAllowed, o.multipleResultsAllowed, true) && ObservationDefinition.compareValues(this.preferredReportName, o.preferredReportName, true) && ObservationDefinition.compareValues(this.validCodedValueSet, o.validCodedValueSet, true) && ObservationDefinition.compareValues(this.normalCodedValueSet, o.normalCodedValueSet, true) && ObservationDefinition.compareValues(this.abnormalCodedValueSet, o.abnormalCodedValueSet, true) && ObservationDefinition.compareValues(this.criticalCodedValueSet, o.criticalCodedValueSet, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.code, this.identifier, this.permittedDataType, this.multipleResultsAllowed, this.method, this.preferredReportName, this.quantitativeDetails, this.qualifiedInterval, this.validCodedValueSet, this.normalCodedValueSet, this.abnormalCodedValueSet, this.criticalCodedValueSet});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ObservationDefinition;
    }

    @Block
    public static class ObservationDefinitionQualifiedIntervalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category or type of interval", formalDefinition="The category or type of interval.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-category")
        protected CodeableConcept category;
        @Child(name="range", type={Range.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The range of the interval", formalDefinition="The range of the interval.")
        protected Range range;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference range qualifier", formalDefinition="Codes to indicate what part of the targeted reference population it applies to. For example, the normal or therapeutic range.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/referencerange-meaning")
        protected CodeableConcept type;
        @Child(name="appliesTo", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Reference range population", formalDefinition="Codes to indicate the target population this reference range applies to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/referencerange-appliesto")
        protected List<CodeableConcept> appliesTo;
        @Child(name="age", type={Range.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable age range, if relevant", formalDefinition="The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.")
        protected Range age;
        @Child(name="gestationalAge", type={Range.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable gestational age range, if relevant", formalDefinition="The gestational age at which this reference range is applicable, in the context of pregnancy.")
        protected Range gestationalAge;
        @Child(name="condition", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Condition associated with the reference range", formalDefinition="Text based condition for which the reference range is valid.")
        protected StringType condition;
        private static final long serialVersionUID = 1566527077L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedIntervalComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ObservationDefinitionQualifiedIntervalComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public Range getRange() {
            if (this.range == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedIntervalComponent.range");
                }
                if (Configuration.doAutoCreate()) {
                    this.range = new Range();
                }
            }
            return this.range;
        }

        public boolean hasRange() {
            return this.range != null && !this.range.isEmpty();
        }

        public ObservationDefinitionQualifiedIntervalComponent setRange(Range value) {
            this.range = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedIntervalComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ObservationDefinitionQualifiedIntervalComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getAppliesTo() {
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            return this.appliesTo;
        }

        public ObservationDefinitionQualifiedIntervalComponent setAppliesTo(List<CodeableConcept> theAppliesTo) {
            this.appliesTo = theAppliesTo;
            return this;
        }

        public boolean hasAppliesTo() {
            if (this.appliesTo == null) {
                return false;
            }
            for (CodeableConcept item : this.appliesTo) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAppliesTo() {
            CodeableConcept t = new CodeableConcept();
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            this.appliesTo.add(t);
            return t;
        }

        public ObservationDefinitionQualifiedIntervalComponent addAppliesTo(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.appliesTo == null) {
                this.appliesTo = new ArrayList<CodeableConcept>();
            }
            this.appliesTo.add(t);
            return this;
        }

        public CodeableConcept getAppliesToFirstRep() {
            if (this.getAppliesTo().isEmpty()) {
                this.addAppliesTo();
            }
            return this.getAppliesTo().get(0);
        }

        public Range getAge() {
            if (this.age == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedIntervalComponent.age");
                }
                if (Configuration.doAutoCreate()) {
                    this.age = new Range();
                }
            }
            return this.age;
        }

        public boolean hasAge() {
            return this.age != null && !this.age.isEmpty();
        }

        public ObservationDefinitionQualifiedIntervalComponent setAge(Range value) {
            this.age = value;
            return this;
        }

        public Range getGestationalAge() {
            if (this.gestationalAge == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedIntervalComponent.gestationalAge");
                }
                if (Configuration.doAutoCreate()) {
                    this.gestationalAge = new Range();
                }
            }
            return this.gestationalAge;
        }

        public boolean hasGestationalAge() {
            return this.gestationalAge != null && !this.gestationalAge.isEmpty();
        }

        public ObservationDefinitionQualifiedIntervalComponent setGestationalAge(Range value) {
            this.gestationalAge = value;
            return this;
        }

        public StringType getConditionElement() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQualifiedIntervalComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new StringType();
                }
            }
            return this.condition;
        }

        public boolean hasConditionElement() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public ObservationDefinitionQualifiedIntervalComponent setConditionElement(StringType value) {
            this.condition = value;
            return this;
        }

        public String getCondition() {
            return this.condition == null ? null : (String)this.condition.getValue();
        }

        public ObservationDefinitionQualifiedIntervalComponent setCondition(String value) {
            if (Utilities.noString((String)value)) {
                this.condition = null;
            } else {
                if (this.condition == null) {
                    this.condition = new StringType();
                }
                this.condition.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "The category or type of interval.", 0, 1, this.category));
            children.add(new Property("range", "Range", "The range of the interval.", 0, 1, this.range));
            children.add(new Property("type", "CodeableConcept", "Codes to indicate what part of the targeted reference population it applies to. For example, the normal or therapeutic range.", 0, 1, this.type));
            children.add(new Property("appliesTo", "CodeableConcept", "Codes to indicate the target population this reference range applies to.", 0, Integer.MAX_VALUE, this.appliesTo));
            children.add(new Property("age", "Range", "The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.", 0, 1, this.age));
            children.add(new Property("gestationalAge", "Range", "The gestational age at which this reference range is applicable, in the context of pregnancy.", 0, 1, this.gestationalAge));
            children.add(new Property("condition", "string", "Text based condition for which the reference range is valid.", 0, 1, this.condition));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "The category or type of interval.", 0, 1, this.category);
                }
                case 108280125: {
                    return new Property("range", "Range", "The range of the interval.", 0, 1, this.range);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Codes to indicate what part of the targeted reference population it applies to. For example, the normal or therapeutic range.", 0, 1, this.type);
                }
                case -2089924569: {
                    return new Property("appliesTo", "CodeableConcept", "Codes to indicate the target population this reference range applies to.", 0, Integer.MAX_VALUE, this.appliesTo);
                }
                case 96511: {
                    return new Property("age", "Range", "The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so.", 0, 1, this.age);
                }
                case -241217538: {
                    return new Property("gestationalAge", "Range", "The gestational age at which this reference range is applicable, in the context of pregnancy.", 0, 1, this.gestationalAge);
                }
                case -861311717: {
                    return new Property("condition", "string", "Text based condition for which the reference range is valid.", 0, 1, this.condition);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 108280125: {
                    Base[] baseArray;
                    if (this.range == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.range;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case -2089924569: {
                    return this.appliesTo == null ? new Base[]{} : this.appliesTo.toArray(new Base[this.appliesTo.size()]);
                }
                case 96511: {
                    Base[] baseArray;
                    if (this.age == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.age;
                    }
                    return baseArray;
                }
                case -241217538: {
                    Base[] baseArray;
                    if (this.gestationalAge == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.gestationalAge;
                    }
                    return baseArray;
                }
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.condition;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 108280125: {
                    this.range = this.castToRange(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -2089924569: {
                    this.getAppliesTo().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 96511: {
                    this.age = this.castToRange(value);
                    return value;
                }
                case -241217538: {
                    this.gestationalAge = this.castToRange(value);
                    return value;
                }
                case -861311717: {
                    this.condition = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("range")) {
                this.range = this.castToRange(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("appliesTo")) {
                this.getAppliesTo().add(this.castToCodeableConcept(value));
            } else if (name.equals("age")) {
                this.age = this.castToRange(value);
            } else if (name.equals("gestationalAge")) {
                this.gestationalAge = this.castToRange(value);
            } else if (name.equals("condition")) {
                this.condition = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 108280125: {
                    return this.getRange();
                }
                case 3575610: {
                    return this.getType();
                }
                case -2089924569: {
                    return this.addAppliesTo();
                }
                case 96511: {
                    return this.getAge();
                }
                case -241217538: {
                    return this.getGestationalAge();
                }
                case -861311717: {
                    return this.getConditionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 108280125: {
                    return new String[]{"Range"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -2089924569: {
                    return new String[]{"CodeableConcept"};
                }
                case 96511: {
                    return new String[]{"Range"};
                }
                case -241217538: {
                    return new String[]{"Range"};
                }
                case -861311717: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("range")) {
                this.range = new Range();
                return this.range;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("appliesTo")) {
                return this.addAppliesTo();
            }
            if (name.equals("age")) {
                this.age = new Range();
                return this.age;
            }
            if (name.equals("gestationalAge")) {
                this.gestationalAge = new Range();
                return this.gestationalAge;
            }
            if (name.equals("condition")) {
                throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.condition");
            }
            return super.addChild(name);
        }

        @Override
        public ObservationDefinitionQualifiedIntervalComponent copy() {
            ObservationDefinitionQualifiedIntervalComponent dst = new ObservationDefinitionQualifiedIntervalComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.range = this.range == null ? null : this.range.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.appliesTo != null) {
                dst.appliesTo = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.appliesTo) {
                    dst.appliesTo.add(i.copy());
                }
            }
            dst.age = this.age == null ? null : this.age.copy();
            dst.gestationalAge = this.gestationalAge == null ? null : this.gestationalAge.copy();
            dst.condition = this.condition == null ? null : this.condition.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationDefinitionQualifiedIntervalComponent)) {
                return false;
            }
            ObservationDefinitionQualifiedIntervalComponent o = (ObservationDefinitionQualifiedIntervalComponent)other_;
            return ObservationDefinitionQualifiedIntervalComponent.compareDeep(this.category, o.category, true) && ObservationDefinitionQualifiedIntervalComponent.compareDeep(this.range, o.range, true) && ObservationDefinitionQualifiedIntervalComponent.compareDeep(this.type, o.type, true) && ObservationDefinitionQualifiedIntervalComponent.compareDeep(this.appliesTo, o.appliesTo, true) && ObservationDefinitionQualifiedIntervalComponent.compareDeep(this.age, o.age, true) && ObservationDefinitionQualifiedIntervalComponent.compareDeep(this.gestationalAge, o.gestationalAge, true) && ObservationDefinitionQualifiedIntervalComponent.compareDeep(this.condition, o.condition, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationDefinitionQualifiedIntervalComponent)) {
                return false;
            }
            ObservationDefinitionQualifiedIntervalComponent o = (ObservationDefinitionQualifiedIntervalComponent)other_;
            return ObservationDefinitionQualifiedIntervalComponent.compareValues(this.condition, o.condition, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.range, this.type, this.appliesTo, this.age, this.gestationalAge, this.condition});
        }

        @Override
        public String fhirType() {
            return "ObservationDefinition.qualifiedInterval";
        }
    }

    @Block
    public static class ObservationDefinitionQuantitativeDetailsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="customaryUnit", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Customary unit for quantitative results", formalDefinition="Customary unit used to report quantitative results of this observation.")
        protected Coding customaryUnit;
        @Child(name="unit", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="SI unit for quantitative results", formalDefinition="SI unit used to report quantitative results of this observation.")
        protected Coding unit;
        @Child(name="conversionFactor", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="SI to Customary unit conversion factor", formalDefinition="Factor for converting value expressed with SI unit to value expressed with customary unit.")
        protected DecimalType conversionFactor;
        @Child(name="decimalPrecision", type={IntegerType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Decimal precision of observation quantitative results", formalDefinition="Number of digits after decimal separator when the results of this observation are of type Quantity.")
        protected IntegerType decimalPrecision;
        private static final long serialVersionUID = -1533265578L;

        public Coding getCustomaryUnit() {
            if (this.customaryUnit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQuantitativeDetailsComponent.customaryUnit");
                }
                if (Configuration.doAutoCreate()) {
                    this.customaryUnit = new Coding();
                }
            }
            return this.customaryUnit;
        }

        public boolean hasCustomaryUnit() {
            return this.customaryUnit != null && !this.customaryUnit.isEmpty();
        }

        public ObservationDefinitionQuantitativeDetailsComponent setCustomaryUnit(Coding value) {
            this.customaryUnit = value;
            return this;
        }

        public Coding getUnit() {
            if (this.unit == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQuantitativeDetailsComponent.unit");
                }
                if (Configuration.doAutoCreate()) {
                    this.unit = new Coding();
                }
            }
            return this.unit;
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public ObservationDefinitionQuantitativeDetailsComponent setUnit(Coding value) {
            this.unit = value;
            return this;
        }

        public DecimalType getConversionFactorElement() {
            if (this.conversionFactor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQuantitativeDetailsComponent.conversionFactor");
                }
                if (Configuration.doAutoCreate()) {
                    this.conversionFactor = new DecimalType();
                }
            }
            return this.conversionFactor;
        }

        public boolean hasConversionFactorElement() {
            return this.conversionFactor != null && !this.conversionFactor.isEmpty();
        }

        public boolean hasConversionFactor() {
            return this.conversionFactor != null && !this.conversionFactor.isEmpty();
        }

        public ObservationDefinitionQuantitativeDetailsComponent setConversionFactorElement(DecimalType value) {
            this.conversionFactor = value;
            return this;
        }

        public BigDecimal getConversionFactor() {
            return this.conversionFactor == null ? null : (BigDecimal)this.conversionFactor.getValue();
        }

        public ObservationDefinitionQuantitativeDetailsComponent setConversionFactor(BigDecimal value) {
            if (value == null) {
                this.conversionFactor = null;
            } else {
                if (this.conversionFactor == null) {
                    this.conversionFactor = new DecimalType();
                }
                this.conversionFactor.setValue(value);
            }
            return this;
        }

        public ObservationDefinitionQuantitativeDetailsComponent setConversionFactor(long value) {
            this.conversionFactor = new DecimalType();
            this.conversionFactor.setValue(value);
            return this;
        }

        public ObservationDefinitionQuantitativeDetailsComponent setConversionFactor(double value) {
            this.conversionFactor = new DecimalType();
            this.conversionFactor.setValue(value);
            return this;
        }

        public IntegerType getDecimalPrecisionElement() {
            if (this.decimalPrecision == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ObservationDefinitionQuantitativeDetailsComponent.decimalPrecision");
                }
                if (Configuration.doAutoCreate()) {
                    this.decimalPrecision = new IntegerType();
                }
            }
            return this.decimalPrecision;
        }

        public boolean hasDecimalPrecisionElement() {
            return this.decimalPrecision != null && !this.decimalPrecision.isEmpty();
        }

        public boolean hasDecimalPrecision() {
            return this.decimalPrecision != null && !this.decimalPrecision.isEmpty();
        }

        public ObservationDefinitionQuantitativeDetailsComponent setDecimalPrecisionElement(IntegerType value) {
            this.decimalPrecision = value;
            return this;
        }

        public int getDecimalPrecision() {
            return this.decimalPrecision == null || this.decimalPrecision.isEmpty() ? 0 : (Integer)this.decimalPrecision.getValue();
        }

        public ObservationDefinitionQuantitativeDetailsComponent setDecimalPrecision(int value) {
            if (this.decimalPrecision == null) {
                this.decimalPrecision = new IntegerType();
            }
            this.decimalPrecision.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("customaryUnit", "Coding", "Customary unit used to report quantitative results of this observation.", 0, 1, this.customaryUnit));
            children.add(new Property("unit", "Coding", "SI unit used to report quantitative results of this observation.", 0, 1, this.unit));
            children.add(new Property("conversionFactor", "decimal", "Factor for converting value expressed with SI unit to value expressed with customary unit.", 0, 1, this.conversionFactor));
            children.add(new Property("decimalPrecision", "integer", "Number of digits after decimal separator when the results of this observation are of type Quantity.", 0, 1, this.decimalPrecision));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1375586437: {
                    return new Property("customaryUnit", "Coding", "Customary unit used to report quantitative results of this observation.", 0, 1, this.customaryUnit);
                }
                case 3594628: {
                    return new Property("unit", "Coding", "SI unit used to report quantitative results of this observation.", 0, 1, this.unit);
                }
                case 1438876165: {
                    return new Property("conversionFactor", "decimal", "Factor for converting value expressed with SI unit to value expressed with customary unit.", 0, 1, this.conversionFactor);
                }
                case -1564447699: {
                    return new Property("decimalPrecision", "integer", "Number of digits after decimal separator when the results of this observation are of type Quantity.", 0, 1, this.decimalPrecision);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1375586437: {
                    Base[] baseArray;
                    if (this.customaryUnit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.customaryUnit;
                    }
                    return baseArray;
                }
                case 3594628: {
                    Base[] baseArray;
                    if (this.unit == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.unit;
                    }
                    return baseArray;
                }
                case 1438876165: {
                    Base[] baseArray;
                    if (this.conversionFactor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.conversionFactor;
                    }
                    return baseArray;
                }
                case -1564447699: {
                    Base[] baseArray;
                    if (this.decimalPrecision == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.decimalPrecision;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1375586437: {
                    this.customaryUnit = this.castToCoding(value);
                    return value;
                }
                case 3594628: {
                    this.unit = this.castToCoding(value);
                    return value;
                }
                case 1438876165: {
                    this.conversionFactor = this.castToDecimal(value);
                    return value;
                }
                case -1564447699: {
                    this.decimalPrecision = this.castToInteger(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("customaryUnit")) {
                this.customaryUnit = this.castToCoding(value);
            } else if (name.equals("unit")) {
                this.unit = this.castToCoding(value);
            } else if (name.equals("conversionFactor")) {
                this.conversionFactor = this.castToDecimal(value);
            } else if (name.equals("decimalPrecision")) {
                this.decimalPrecision = this.castToInteger(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1375586437: {
                    return this.getCustomaryUnit();
                }
                case 3594628: {
                    return this.getUnit();
                }
                case 1438876165: {
                    return this.getConversionFactorElement();
                }
                case -1564447699: {
                    return this.getDecimalPrecisionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1375586437: {
                    return new String[]{"Coding"};
                }
                case 3594628: {
                    return new String[]{"Coding"};
                }
                case 1438876165: {
                    return new String[]{"decimal"};
                }
                case -1564447699: {
                    return new String[]{"integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("customaryUnit")) {
                this.customaryUnit = new Coding();
                return this.customaryUnit;
            }
            if (name.equals("unit")) {
                this.unit = new Coding();
                return this.unit;
            }
            if (name.equals("conversionFactor")) {
                throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.conversionFactor");
            }
            if (name.equals("decimalPrecision")) {
                throw new FHIRException("Cannot call addChild on a primitive type ObservationDefinition.decimalPrecision");
            }
            return super.addChild(name);
        }

        @Override
        public ObservationDefinitionQuantitativeDetailsComponent copy() {
            ObservationDefinitionQuantitativeDetailsComponent dst = new ObservationDefinitionQuantitativeDetailsComponent();
            this.copyValues(dst);
            dst.customaryUnit = this.customaryUnit == null ? null : this.customaryUnit.copy();
            dst.unit = this.unit == null ? null : this.unit.copy();
            dst.conversionFactor = this.conversionFactor == null ? null : this.conversionFactor.copy();
            dst.decimalPrecision = this.decimalPrecision == null ? null : this.decimalPrecision.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationDefinitionQuantitativeDetailsComponent)) {
                return false;
            }
            ObservationDefinitionQuantitativeDetailsComponent o = (ObservationDefinitionQuantitativeDetailsComponent)other_;
            return ObservationDefinitionQuantitativeDetailsComponent.compareDeep(this.customaryUnit, o.customaryUnit, true) && ObservationDefinitionQuantitativeDetailsComponent.compareDeep(this.unit, o.unit, true) && ObservationDefinitionQuantitativeDetailsComponent.compareDeep(this.conversionFactor, o.conversionFactor, true) && ObservationDefinitionQuantitativeDetailsComponent.compareDeep(this.decimalPrecision, o.decimalPrecision, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ObservationDefinitionQuantitativeDetailsComponent)) {
                return false;
            }
            ObservationDefinitionQuantitativeDetailsComponent o = (ObservationDefinitionQuantitativeDetailsComponent)other_;
            return ObservationDefinitionQuantitativeDetailsComponent.compareValues(this.conversionFactor, o.conversionFactor, true) && ObservationDefinitionQuantitativeDetailsComponent.compareValues(this.decimalPrecision, o.decimalPrecision, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.customaryUnit, this.unit, this.conversionFactor, this.decimalPrecision});
        }

        @Override
        public String fhirType() {
            return "ObservationDefinition.quantitativeDetails";
        }
    }
}

