/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="RelatedArtifact")
public class RelatedArtifact
extends Type
implements ICompositeType {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="documentation | justification | citation | predecessor | successor | derived-from | depends-on | composed-of", formalDefinition="The type of relationship to the related artifact.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/related-artifact-type")
    protected Enumeration<RelatedArtifactType> type;
    @Child(name="display", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Brief description of the related artifact", formalDefinition="A brief description of the document or knowledge resource being referenced, suitable for display to a consumer.")
    protected StringType display;
    @Child(name="citation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Bibliographic citation for the artifact", formalDefinition="A bibliographic citation for the related artifact. This text SHOULD be formatted according to an accepted citation format.")
    protected StringType citation;
    @Child(name="url", type={UrlType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the artifact can be accessed", formalDefinition="A url for the artifact that can be followed to access the actual content.")
    protected UrlType url;
    @Child(name="document", type={Attachment.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What document is being referenced", formalDefinition="The document being referenced, represented as an attachment. This is exclusive with the resource element.")
    protected Attachment document;
    @Child(name="resource", type={CanonicalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What resource is being referenced", formalDefinition="The related resource, such as a library, value set, profile, or other knowledge resource.")
    protected CanonicalType resource;
    private static final long serialVersionUID = 365945959L;

    public RelatedArtifact() {
    }

    public RelatedArtifact(Enumeration<RelatedArtifactType> type) {
        this.type = type;
    }

    public Enumeration<RelatedArtifactType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedArtifact.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<RelatedArtifactType>(new RelatedArtifactTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public RelatedArtifact setTypeElement(Enumeration<RelatedArtifactType> value) {
        this.type = value;
        return this;
    }

    public RelatedArtifactType getType() {
        return this.type == null ? null : (RelatedArtifactType)((Object)this.type.getValue());
    }

    public RelatedArtifact setType(RelatedArtifactType value) {
        if (this.type == null) {
            this.type = new Enumeration<RelatedArtifactType>(new RelatedArtifactTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public StringType getDisplayElement() {
        if (this.display == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedArtifact.display");
            }
            if (Configuration.doAutoCreate()) {
                this.display = new StringType();
            }
        }
        return this.display;
    }

    public boolean hasDisplayElement() {
        return this.display != null && !this.display.isEmpty();
    }

    public boolean hasDisplay() {
        return this.display != null && !this.display.isEmpty();
    }

    public RelatedArtifact setDisplayElement(StringType value) {
        this.display = value;
        return this;
    }

    public String getDisplay() {
        return this.display == null ? null : (String)this.display.getValue();
    }

    public RelatedArtifact setDisplay(String value) {
        if (Utilities.noString((String)value)) {
            this.display = null;
        } else {
            if (this.display == null) {
                this.display = new StringType();
            }
            this.display.setValue(value);
        }
        return this;
    }

    public StringType getCitationElement() {
        if (this.citation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedArtifact.citation");
            }
            if (Configuration.doAutoCreate()) {
                this.citation = new StringType();
            }
        }
        return this.citation;
    }

    public boolean hasCitationElement() {
        return this.citation != null && !this.citation.isEmpty();
    }

    public boolean hasCitation() {
        return this.citation != null && !this.citation.isEmpty();
    }

    public RelatedArtifact setCitationElement(StringType value) {
        this.citation = value;
        return this;
    }

    public String getCitation() {
        return this.citation == null ? null : (String)this.citation.getValue();
    }

    public RelatedArtifact setCitation(String value) {
        if (Utilities.noString((String)value)) {
            this.citation = null;
        } else {
            if (this.citation == null) {
                this.citation = new StringType();
            }
            this.citation.setValue(value);
        }
        return this;
    }

    public UrlType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedArtifact.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UrlType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public RelatedArtifact setUrlElement(UrlType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public RelatedArtifact setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UrlType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Attachment getDocument() {
        if (this.document == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedArtifact.document");
            }
            if (Configuration.doAutoCreate()) {
                this.document = new Attachment();
            }
        }
        return this.document;
    }

    public boolean hasDocument() {
        return this.document != null && !this.document.isEmpty();
    }

    public RelatedArtifact setDocument(Attachment value) {
        this.document = value;
        return this;
    }

    public CanonicalType getResourceElement() {
        if (this.resource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedArtifact.resource");
            }
            if (Configuration.doAutoCreate()) {
                this.resource = new CanonicalType();
            }
        }
        return this.resource;
    }

    public boolean hasResourceElement() {
        return this.resource != null && !this.resource.isEmpty();
    }

    public boolean hasResource() {
        return this.resource != null && !this.resource.isEmpty();
    }

    public RelatedArtifact setResourceElement(CanonicalType value) {
        this.resource = value;
        return this;
    }

    public String getResource() {
        return this.resource == null ? null : (String)this.resource.getValue();
    }

    public RelatedArtifact setResource(String value) {
        if (Utilities.noString((String)value)) {
            this.resource = null;
        } else {
            if (this.resource == null) {
                this.resource = new CanonicalType();
            }
            this.resource.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "code", "The type of relationship to the related artifact.", 0, 1, this.type));
        children.add(new Property("display", "string", "A brief description of the document or knowledge resource being referenced, suitable for display to a consumer.", 0, 1, this.display));
        children.add(new Property("citation", "string", "A bibliographic citation for the related artifact. This text SHOULD be formatted according to an accepted citation format.", 0, 1, this.citation));
        children.add(new Property("url", "url", "A url for the artifact that can be followed to access the actual content.", 0, 1, this.url));
        children.add(new Property("document", "Attachment", "The document being referenced, represented as an attachment. This is exclusive with the resource element.", 0, 1, this.document));
        children.add(new Property("resource", "canonical(Any)", "The related resource, such as a library, value set, profile, or other knowledge resource.", 0, 1, this.resource));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "code", "The type of relationship to the related artifact.", 0, 1, this.type);
            }
            case 1671764162: {
                return new Property("display", "string", "A brief description of the document or knowledge resource being referenced, suitable for display to a consumer.", 0, 1, this.display);
            }
            case -1442706713: {
                return new Property("citation", "string", "A bibliographic citation for the related artifact. This text SHOULD be formatted according to an accepted citation format.", 0, 1, this.citation);
            }
            case 116079: {
                return new Property("url", "url", "A url for the artifact that can be followed to access the actual content.", 0, 1, this.url);
            }
            case 861720859: {
                return new Property("document", "Attachment", "The document being referenced, represented as an attachment. This is exclusive with the resource element.", 0, 1, this.document);
            }
            case -341064690: {
                return new Property("resource", "canonical(Any)", "The related resource, such as a library, value set, profile, or other knowledge resource.", 0, 1, this.resource);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 1671764162: {
                Base[] baseArray;
                if (this.display == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.display;
                }
                return baseArray;
            }
            case -1442706713: {
                Base[] baseArray;
                if (this.citation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.citation;
                }
                return baseArray;
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.url;
                }
                return baseArray;
            }
            case 861720859: {
                Base[] baseArray;
                if (this.document == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.document;
                }
                return baseArray;
            }
            case -341064690: {
                Base[] baseArray;
                if (this.resource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.resource;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                value = new RelatedArtifactTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 1671764162: {
                this.display = this.castToString(value);
                return value;
            }
            case -1442706713: {
                this.citation = this.castToString(value);
                return value;
            }
            case 116079: {
                this.url = this.castToUrl(value);
                return value;
            }
            case 861720859: {
                this.document = this.castToAttachment(value);
                return value;
            }
            case -341064690: {
                this.resource = this.castToCanonical(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            value = new RelatedArtifactTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals("display")) {
            this.display = this.castToString(value);
        } else if (name.equals("citation")) {
            this.citation = this.castToString(value);
        } else if (name.equals("url")) {
            this.url = this.castToUrl(value);
        } else if (name.equals("document")) {
            this.document = this.castToAttachment(value);
        } else if (name.equals("resource")) {
            this.resource = this.castToCanonical(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getTypeElement();
            }
            case 1671764162: {
                return this.getDisplayElement();
            }
            case -1442706713: {
                return this.getCitationElement();
            }
            case 116079: {
                return this.getUrlElement();
            }
            case 861720859: {
                return this.getDocument();
            }
            case -341064690: {
                return this.getResourceElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"code"};
            }
            case 1671764162: {
                return new String[]{"string"};
            }
            case -1442706713: {
                return new String[]{"string"};
            }
            case 116079: {
                return new String[]{"url"};
            }
            case 861720859: {
                return new String[]{"Attachment"};
            }
            case -341064690: {
                return new String[]{"canonical"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type RelatedArtifact.type");
        }
        if (name.equals("display")) {
            throw new FHIRException("Cannot call addChild on a primitive type RelatedArtifact.display");
        }
        if (name.equals("citation")) {
            throw new FHIRException("Cannot call addChild on a primitive type RelatedArtifact.citation");
        }
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a primitive type RelatedArtifact.url");
        }
        if (name.equals("document")) {
            this.document = new Attachment();
            return this.document;
        }
        if (name.equals("resource")) {
            throw new FHIRException("Cannot call addChild on a primitive type RelatedArtifact.resource");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RelatedArtifact";
    }

    @Override
    public RelatedArtifact copy() {
        RelatedArtifact dst = new RelatedArtifact();
        this.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        dst.display = this.display == null ? null : this.display.copy();
        dst.citation = this.citation == null ? null : this.citation.copy();
        dst.url = this.url == null ? null : this.url.copy();
        dst.document = this.document == null ? null : this.document.copy();
        dst.resource = this.resource == null ? null : this.resource.copy();
        return dst;
    }

    @Override
    protected RelatedArtifact typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RelatedArtifact)) {
            return false;
        }
        RelatedArtifact o = (RelatedArtifact)other_;
        return RelatedArtifact.compareDeep(this.type, o.type, true) && RelatedArtifact.compareDeep(this.display, o.display, true) && RelatedArtifact.compareDeep(this.citation, o.citation, true) && RelatedArtifact.compareDeep(this.url, o.url, true) && RelatedArtifact.compareDeep(this.document, o.document, true) && RelatedArtifact.compareDeep(this.resource, o.resource, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RelatedArtifact)) {
            return false;
        }
        RelatedArtifact o = (RelatedArtifact)other_;
        return RelatedArtifact.compareValues(this.type, o.type, true) && RelatedArtifact.compareValues(this.display, o.display, true) && RelatedArtifact.compareValues(this.citation, o.citation, true) && RelatedArtifact.compareValues(this.url, o.url, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.display, this.citation, this.url, this.document, this.resource});
    }

    public static class RelatedArtifactTypeEnumFactory
    implements EnumFactory<RelatedArtifactType> {
        @Override
        public RelatedArtifactType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("documentation".equals(codeString)) {
                return RelatedArtifactType.DOCUMENTATION;
            }
            if ("justification".equals(codeString)) {
                return RelatedArtifactType.JUSTIFICATION;
            }
            if ("citation".equals(codeString)) {
                return RelatedArtifactType.CITATION;
            }
            if ("predecessor".equals(codeString)) {
                return RelatedArtifactType.PREDECESSOR;
            }
            if ("successor".equals(codeString)) {
                return RelatedArtifactType.SUCCESSOR;
            }
            if ("derived-from".equals(codeString)) {
                return RelatedArtifactType.DERIVEDFROM;
            }
            if ("depends-on".equals(codeString)) {
                return RelatedArtifactType.DEPENDSON;
            }
            if ("composed-of".equals(codeString)) {
                return RelatedArtifactType.COMPOSEDOF;
            }
            throw new IllegalArgumentException("Unknown RelatedArtifactType code '" + codeString + "'");
        }

        public Enumeration<RelatedArtifactType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RelatedArtifactType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("documentation".equals(codeString)) {
                return new Enumeration<RelatedArtifactType>(this, RelatedArtifactType.DOCUMENTATION);
            }
            if ("justification".equals(codeString)) {
                return new Enumeration<RelatedArtifactType>(this, RelatedArtifactType.JUSTIFICATION);
            }
            if ("citation".equals(codeString)) {
                return new Enumeration<RelatedArtifactType>(this, RelatedArtifactType.CITATION);
            }
            if ("predecessor".equals(codeString)) {
                return new Enumeration<RelatedArtifactType>(this, RelatedArtifactType.PREDECESSOR);
            }
            if ("successor".equals(codeString)) {
                return new Enumeration<RelatedArtifactType>(this, RelatedArtifactType.SUCCESSOR);
            }
            if ("derived-from".equals(codeString)) {
                return new Enumeration<RelatedArtifactType>(this, RelatedArtifactType.DERIVEDFROM);
            }
            if ("depends-on".equals(codeString)) {
                return new Enumeration<RelatedArtifactType>(this, RelatedArtifactType.DEPENDSON);
            }
            if ("composed-of".equals(codeString)) {
                return new Enumeration<RelatedArtifactType>(this, RelatedArtifactType.COMPOSEDOF);
            }
            throw new FHIRException("Unknown RelatedArtifactType code '" + codeString + "'");
        }

        @Override
        public String toCode(RelatedArtifactType code) {
            if (code == RelatedArtifactType.DOCUMENTATION) {
                return "documentation";
            }
            if (code == RelatedArtifactType.JUSTIFICATION) {
                return "justification";
            }
            if (code == RelatedArtifactType.CITATION) {
                return "citation";
            }
            if (code == RelatedArtifactType.PREDECESSOR) {
                return "predecessor";
            }
            if (code == RelatedArtifactType.SUCCESSOR) {
                return "successor";
            }
            if (code == RelatedArtifactType.DERIVEDFROM) {
                return "derived-from";
            }
            if (code == RelatedArtifactType.DEPENDSON) {
                return "depends-on";
            }
            if (code == RelatedArtifactType.COMPOSEDOF) {
                return "composed-of";
            }
            return "?";
        }

        @Override
        public String toSystem(RelatedArtifactType code) {
            return code.getSystem();
        }
    }

    public static enum RelatedArtifactType {
        DOCUMENTATION,
        JUSTIFICATION,
        CITATION,
        PREDECESSOR,
        SUCCESSOR,
        DERIVEDFROM,
        DEPENDSON,
        COMPOSEDOF,
        NULL;


        public static RelatedArtifactType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("documentation".equals(codeString)) {
                return DOCUMENTATION;
            }
            if ("justification".equals(codeString)) {
                return JUSTIFICATION;
            }
            if ("citation".equals(codeString)) {
                return CITATION;
            }
            if ("predecessor".equals(codeString)) {
                return PREDECESSOR;
            }
            if ("successor".equals(codeString)) {
                return SUCCESSOR;
            }
            if ("derived-from".equals(codeString)) {
                return DERIVEDFROM;
            }
            if ("depends-on".equals(codeString)) {
                return DEPENDSON;
            }
            if ("composed-of".equals(codeString)) {
                return COMPOSEDOF;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RelatedArtifactType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DOCUMENTATION: {
                    return "documentation";
                }
                case JUSTIFICATION: {
                    return "justification";
                }
                case CITATION: {
                    return "citation";
                }
                case PREDECESSOR: {
                    return "predecessor";
                }
                case SUCCESSOR: {
                    return "successor";
                }
                case DERIVEDFROM: {
                    return "derived-from";
                }
                case DEPENDSON: {
                    return "depends-on";
                }
                case COMPOSEDOF: {
                    return "composed-of";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DOCUMENTATION: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case JUSTIFICATION: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case CITATION: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case PREDECESSOR: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case SUCCESSOR: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case DERIVEDFROM: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case DEPENDSON: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
                case COMPOSEDOF: {
                    return "http://hl7.org/fhir/related-artifact-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DOCUMENTATION: {
                    return "Additional documentation for the knowledge resource. This would include additional instructions on usage as well as additional information on clinical context or appropriateness.";
                }
                case JUSTIFICATION: {
                    return "A summary of the justification for the knowledge resource including supporting evidence, relevant guidelines, or other clinically important information. This information is intended to provide a way to make the justification for the knowledge resource available to the consumer of interventions or results produced by the knowledge resource.";
                }
                case CITATION: {
                    return "Bibliographic citation for papers, references, or other relevant material for the knowledge resource. This is intended to allow for citation of related material, but that was not necessarily specifically prepared in connection with this knowledge resource.";
                }
                case PREDECESSOR: {
                    return "The previous version of the knowledge resource.";
                }
                case SUCCESSOR: {
                    return "The next version of the knowledge resource.";
                }
                case DERIVEDFROM: {
                    return "The knowledge resource is derived from the related artifact. This is intended to capture the relationship in which a particular knowledge resource is based on the content of another artifact, but is modified to capture either a different set of overall requirements, or a more specific set of requirements such as those involved in a particular institution or clinical setting.";
                }
                case DEPENDSON: {
                    return "The knowledge resource depends on the given related artifact.";
                }
                case COMPOSEDOF: {
                    return "The knowledge resource is composed of the given related artifact.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DOCUMENTATION: {
                    return "Documentation";
                }
                case JUSTIFICATION: {
                    return "Justification";
                }
                case CITATION: {
                    return "Citation";
                }
                case PREDECESSOR: {
                    return "Predecessor";
                }
                case SUCCESSOR: {
                    return "Successor";
                }
                case DERIVEDFROM: {
                    return "Derived From";
                }
                case DEPENDSON: {
                    return "Depends On";
                }
                case COMPOSEDOF: {
                    return "Composed Of";
                }
            }
            return "?";
        }
    }
}

