/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Signature")
public class Signature
extends Type
implements ICompositeType {
    @Child(name="type", type={Coding.class}, order=0, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indication of the reason the entity signed the object(s)", formalDefinition="An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/signature-type")
    protected List<Coding> type;
    @Child(name="when", type={InstantType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the signature was created", formalDefinition="When the digital signature was signed.")
    protected InstantType when;
    @Child(name="who", type={Practitioner.class, RelatedPerson.class, Patient.class, Device.class, Organization.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who signed", formalDefinition="A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).")
    protected Reference who;
    protected Resource whoTarget;
    @Child(name="onBehalfOf", type={Practitioner.class, RelatedPerson.class, Patient.class, Device.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The party represented", formalDefinition="A reference to an application-usable description of the identity that is represented by the signature.")
    protected Reference onBehalfOf;
    protected Resource onBehalfOfTarget;
    @Child(name="targetFormat", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The technical format of the signed resources", formalDefinition="A mime type that indicates the technical format of the target resources signed by the signature.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected CodeType targetFormat;
    @Child(name="sigFormat", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The technical format of the signature", formalDefinition="A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jose for JWS, and image/* for a graphical image of a signature, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected CodeType sigFormat;
    @Child(name="data", type={Base64BinaryType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual signature content (XML DigSig. JWS, picture, etc.)", formalDefinition="The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.")
    protected Base64BinaryType data;
    private static final long serialVersionUID = 1587325823L;

    public Signature() {
    }

    public Signature(InstantType when, Reference who) {
        this.when = when;
        this.who = who;
    }

    public List<Coding> getType() {
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        return this.type;
    }

    public Signature setType(List<Coding> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (Coding item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addType() {
        Coding t = new Coding();
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        this.type.add(t);
        return t;
    }

    public Signature addType(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        this.type.add(t);
        return this;
    }

    public Coding getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public InstantType getWhenElement() {
        if (this.when == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.when");
            }
            if (Configuration.doAutoCreate()) {
                this.when = new InstantType();
            }
        }
        return this.when;
    }

    public boolean hasWhenElement() {
        return this.when != null && !this.when.isEmpty();
    }

    public boolean hasWhen() {
        return this.when != null && !this.when.isEmpty();
    }

    public Signature setWhenElement(InstantType value) {
        this.when = value;
        return this;
    }

    public Date getWhen() {
        return this.when == null ? null : (Date)this.when.getValue();
    }

    public Signature setWhen(Date value) {
        if (this.when == null) {
            this.when = new InstantType();
        }
        this.when.setValue(value);
        return this;
    }

    public Reference getWho() {
        if (this.who == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.who");
            }
            if (Configuration.doAutoCreate()) {
                this.who = new Reference();
            }
        }
        return this.who;
    }

    public boolean hasWho() {
        return this.who != null && !this.who.isEmpty();
    }

    public Signature setWho(Reference value) {
        this.who = value;
        return this;
    }

    public Resource getWhoTarget() {
        return this.whoTarget;
    }

    public Signature setWhoTarget(Resource value) {
        this.whoTarget = value;
        return this;
    }

    public Reference getOnBehalfOf() {
        if (this.onBehalfOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.onBehalfOf");
            }
            if (Configuration.doAutoCreate()) {
                this.onBehalfOf = new Reference();
            }
        }
        return this.onBehalfOf;
    }

    public boolean hasOnBehalfOf() {
        return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
    }

    public Signature setOnBehalfOf(Reference value) {
        this.onBehalfOf = value;
        return this;
    }

    public Resource getOnBehalfOfTarget() {
        return this.onBehalfOfTarget;
    }

    public Signature setOnBehalfOfTarget(Resource value) {
        this.onBehalfOfTarget = value;
        return this;
    }

    public CodeType getTargetFormatElement() {
        if (this.targetFormat == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.targetFormat");
            }
            if (Configuration.doAutoCreate()) {
                this.targetFormat = new CodeType();
            }
        }
        return this.targetFormat;
    }

    public boolean hasTargetFormatElement() {
        return this.targetFormat != null && !this.targetFormat.isEmpty();
    }

    public boolean hasTargetFormat() {
        return this.targetFormat != null && !this.targetFormat.isEmpty();
    }

    public Signature setTargetFormatElement(CodeType value) {
        this.targetFormat = value;
        return this;
    }

    public String getTargetFormat() {
        return this.targetFormat == null ? null : (String)this.targetFormat.getValue();
    }

    public Signature setTargetFormat(String value) {
        if (Utilities.noString((String)value)) {
            this.targetFormat = null;
        } else {
            if (this.targetFormat == null) {
                this.targetFormat = new CodeType();
            }
            this.targetFormat.setValue(value);
        }
        return this;
    }

    public CodeType getSigFormatElement() {
        if (this.sigFormat == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.sigFormat");
            }
            if (Configuration.doAutoCreate()) {
                this.sigFormat = new CodeType();
            }
        }
        return this.sigFormat;
    }

    public boolean hasSigFormatElement() {
        return this.sigFormat != null && !this.sigFormat.isEmpty();
    }

    public boolean hasSigFormat() {
        return this.sigFormat != null && !this.sigFormat.isEmpty();
    }

    public Signature setSigFormatElement(CodeType value) {
        this.sigFormat = value;
        return this;
    }

    public String getSigFormat() {
        return this.sigFormat == null ? null : (String)this.sigFormat.getValue();
    }

    public Signature setSigFormat(String value) {
        if (Utilities.noString((String)value)) {
            this.sigFormat = null;
        } else {
            if (this.sigFormat == null) {
                this.sigFormat = new CodeType();
            }
            this.sigFormat.setValue(value);
        }
        return this;
    }

    public Base64BinaryType getDataElement() {
        if (this.data == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.data");
            }
            if (Configuration.doAutoCreate()) {
                this.data = new Base64BinaryType();
            }
        }
        return this.data;
    }

    public boolean hasDataElement() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public Signature setDataElement(Base64BinaryType value) {
        this.data = value;
        return this;
    }

    public byte[] getData() {
        return this.data == null ? null : (byte[])this.data.getValue();
    }

    public Signature setData(byte[] value) {
        if (value == null) {
            this.data = null;
        } else {
            if (this.data == null) {
                this.data = new Base64BinaryType();
            }
            this.data.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "Coding", "An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("when", "instant", "When the digital signature was signed.", 0, 1, this.when));
        children.add(new Property("who", "Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).", 0, 1, this.who));
        children.add(new Property("onBehalfOf", "Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that is represented by the signature.", 0, 1, this.onBehalfOf));
        children.add(new Property("targetFormat", "code", "A mime type that indicates the technical format of the target resources signed by the signature.", 0, 1, this.targetFormat));
        children.add(new Property("sigFormat", "code", "A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jose for JWS, and image/* for a graphical image of a signature, etc.", 0, 1, this.sigFormat));
        children.add(new Property("data", "base64Binary", "The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.", 0, 1, this.data));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "Coding", "An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.", 0, Integer.MAX_VALUE, this.type);
            }
            case 3648314: {
                return new Property("when", "instant", "When the digital signature was signed.", 0, 1, this.when);
            }
            case 117694: {
                return new Property("who", "Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).", 0, 1, this.who);
            }
            case -14402964: {
                return new Property("onBehalfOf", "Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the identity that is represented by the signature.", 0, 1, this.onBehalfOf);
            }
            case -917363480: {
                return new Property("targetFormat", "code", "A mime type that indicates the technical format of the target resources signed by the signature.", 0, 1, this.targetFormat);
            }
            case -58720216: {
                return new Property("sigFormat", "code", "A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jose for JWS, and image/* for a graphical image of a signature, etc.", 0, 1, this.sigFormat);
            }
            case 3076010: {
                return new Property("data", "base64Binary", "The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.", 0, 1, this.data);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 3648314: {
                Base[] baseArray;
                if (this.when == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.when;
                }
                return baseArray;
            }
            case 117694: {
                Base[] baseArray;
                if (this.who == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.who;
                }
                return baseArray;
            }
            case -14402964: {
                Base[] baseArray;
                if (this.onBehalfOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.onBehalfOf;
                }
                return baseArray;
            }
            case -917363480: {
                Base[] baseArray;
                if (this.targetFormat == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.targetFormat;
                }
                return baseArray;
            }
            case -58720216: {
                Base[] baseArray;
                if (this.sigFormat == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.sigFormat;
                }
                return baseArray;
            }
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.data;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.getType().add(this.castToCoding(value));
                return value;
            }
            case 3648314: {
                this.when = this.castToInstant(value);
                return value;
            }
            case 117694: {
                this.who = this.castToReference(value);
                return value;
            }
            case -14402964: {
                this.onBehalfOf = this.castToReference(value);
                return value;
            }
            case -917363480: {
                this.targetFormat = this.castToCode(value);
                return value;
            }
            case -58720216: {
                this.sigFormat = this.castToCode(value);
                return value;
            }
            case 3076010: {
                this.data = this.castToBase64Binary(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.getType().add(this.castToCoding(value));
        } else if (name.equals("when")) {
            this.when = this.castToInstant(value);
        } else if (name.equals("who")) {
            this.who = this.castToReference(value);
        } else if (name.equals("onBehalfOf")) {
            this.onBehalfOf = this.castToReference(value);
        } else if (name.equals("targetFormat")) {
            this.targetFormat = this.castToCode(value);
        } else if (name.equals("sigFormat")) {
            this.sigFormat = this.castToCode(value);
        } else if (name.equals("data")) {
            this.data = this.castToBase64Binary(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.addType();
            }
            case 3648314: {
                return this.getWhenElement();
            }
            case 117694: {
                return this.getWho();
            }
            case -14402964: {
                return this.getOnBehalfOf();
            }
            case -917363480: {
                return this.getTargetFormatElement();
            }
            case -58720216: {
                return this.getSigFormatElement();
            }
            case 3076010: {
                return this.getDataElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"Coding"};
            }
            case 3648314: {
                return new String[]{"instant"};
            }
            case 117694: {
                return new String[]{"Reference"};
            }
            case -14402964: {
                return new String[]{"Reference"};
            }
            case -917363480: {
                return new String[]{"code"};
            }
            case -58720216: {
                return new String[]{"code"};
            }
            case 3076010: {
                return new String[]{"base64Binary"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals("when")) {
            throw new FHIRException("Cannot call addChild on a primitive type Signature.when");
        }
        if (name.equals("who")) {
            this.who = new Reference();
            return this.who;
        }
        if (name.equals("onBehalfOf")) {
            this.onBehalfOf = new Reference();
            return this.onBehalfOf;
        }
        if (name.equals("targetFormat")) {
            throw new FHIRException("Cannot call addChild on a primitive type Signature.targetFormat");
        }
        if (name.equals("sigFormat")) {
            throw new FHIRException("Cannot call addChild on a primitive type Signature.sigFormat");
        }
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on a primitive type Signature.data");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Signature";
    }

    @Override
    public Signature copy() {
        Signature dst = new Signature();
        this.copyValues(dst);
        if (this.type != null) {
            dst.type = new ArrayList<Coding>();
            for (Coding i : this.type) {
                dst.type.add(i.copy());
            }
        }
        dst.when = this.when == null ? null : this.when.copy();
        dst.who = this.who == null ? null : this.who.copy();
        dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
        dst.targetFormat = this.targetFormat == null ? null : this.targetFormat.copy();
        dst.sigFormat = this.sigFormat == null ? null : this.sigFormat.copy();
        dst.data = this.data == null ? null : this.data.copy();
        return dst;
    }

    @Override
    protected Signature typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Signature)) {
            return false;
        }
        Signature o = (Signature)other_;
        return Signature.compareDeep(this.type, o.type, true) && Signature.compareDeep(this.when, o.when, true) && Signature.compareDeep(this.who, o.who, true) && Signature.compareDeep(this.onBehalfOf, o.onBehalfOf, true) && Signature.compareDeep(this.targetFormat, o.targetFormat, true) && Signature.compareDeep(this.sigFormat, o.sigFormat, true) && Signature.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Signature)) {
            return false;
        }
        Signature o = (Signature)other_;
        return Signature.compareValues(this.when, o.when, true) && Signature.compareValues(this.targetFormat, o.targetFormat, true) && Signature.compareValues(this.sigFormat, o.sigFormat, true) && Signature.compareValues(this.data, o.data, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.when, this.who, this.onBehalfOf, this.targetFormat, this.sigFormat, this.data});
    }
}

