/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.BackboneType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="SubstanceMoiety")
public class SubstanceMoiety
extends BackboneType
implements ICompositeType {
    @Child(name="role", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The role of the moiety should be specified if there is a specific role the moiety is playing", formalDefinition="The role of the moiety should be specified if there is a specific role the moiety is playing.")
    protected CodeableConcept role;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The unique identifier assigned to the substance representing the moiety based on the ISO 11238 substance controlled vocabulary", formalDefinition="The unique identifier assigned to the substance representing the moiety based on the ISO 11238 substance controlled vocabulary.")
    protected Identifier identifier;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The name of the moiety shall be provided", formalDefinition="The name of the moiety shall be provided.")
    protected StringType name;
    @Child(name="stereochemistry", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Stereochemistry shall be captured as described in 4.7.1", formalDefinition="Stereochemistry shall be captured as described in 4.7.1.")
    protected CodeableConcept stereochemistry;
    @Child(name="opticalActivity", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Optical activity shall be captured as described in 4.7.2", formalDefinition="Optical activity shall be captured as described in 4.7.2.")
    protected CodeableConcept opticalActivity;
    @Child(name="molecularFormula", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Molecular formula shall be captured as described in 4.7.3", formalDefinition="Molecular formula shall be captured as described in 4.7.3.")
    protected StringType molecularFormula;
    @Child(name="amount", type={SubstanceAmount.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field", formalDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.")
    protected SubstanceAmount amount;
    private static final long serialVersionUID = 204575891L;

    public CodeableConcept getRole() {
        if (this.role == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceMoiety.role");
            }
            if (Configuration.doAutoCreate()) {
                this.role = new CodeableConcept();
            }
        }
        return this.role;
    }

    public boolean hasRole() {
        return this.role != null && !this.role.isEmpty();
    }

    public SubstanceMoiety setRole(CodeableConcept value) {
        this.role = value;
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceMoiety.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SubstanceMoiety setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceMoiety.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public SubstanceMoiety setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public SubstanceMoiety setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeableConcept getStereochemistry() {
        if (this.stereochemistry == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceMoiety.stereochemistry");
            }
            if (Configuration.doAutoCreate()) {
                this.stereochemistry = new CodeableConcept();
            }
        }
        return this.stereochemistry;
    }

    public boolean hasStereochemistry() {
        return this.stereochemistry != null && !this.stereochemistry.isEmpty();
    }

    public SubstanceMoiety setStereochemistry(CodeableConcept value) {
        this.stereochemistry = value;
        return this;
    }

    public CodeableConcept getOpticalActivity() {
        if (this.opticalActivity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceMoiety.opticalActivity");
            }
            if (Configuration.doAutoCreate()) {
                this.opticalActivity = new CodeableConcept();
            }
        }
        return this.opticalActivity;
    }

    public boolean hasOpticalActivity() {
        return this.opticalActivity != null && !this.opticalActivity.isEmpty();
    }

    public SubstanceMoiety setOpticalActivity(CodeableConcept value) {
        this.opticalActivity = value;
        return this;
    }

    public StringType getMolecularFormulaElement() {
        if (this.molecularFormula == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceMoiety.molecularFormula");
            }
            if (Configuration.doAutoCreate()) {
                this.molecularFormula = new StringType();
            }
        }
        return this.molecularFormula;
    }

    public boolean hasMolecularFormulaElement() {
        return this.molecularFormula != null && !this.molecularFormula.isEmpty();
    }

    public boolean hasMolecularFormula() {
        return this.molecularFormula != null && !this.molecularFormula.isEmpty();
    }

    public SubstanceMoiety setMolecularFormulaElement(StringType value) {
        this.molecularFormula = value;
        return this;
    }

    public String getMolecularFormula() {
        return this.molecularFormula == null ? null : (String)this.molecularFormula.getValue();
    }

    public SubstanceMoiety setMolecularFormula(String value) {
        if (Utilities.noString((String)value)) {
            this.molecularFormula = null;
        } else {
            if (this.molecularFormula == null) {
                this.molecularFormula = new StringType();
            }
            this.molecularFormula.setValue(value);
        }
        return this;
    }

    public SubstanceAmount getAmount() {
        if (this.amount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceMoiety.amount");
            }
            if (Configuration.doAutoCreate()) {
                this.amount = new SubstanceAmount();
            }
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public SubstanceMoiety setAmount(SubstanceAmount value) {
        this.amount = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("role", "CodeableConcept", "The role of the moiety should be specified if there is a specific role the moiety is playing.", 0, 1, this.role));
        children.add(new Property("identifier", "Identifier", "The unique identifier assigned to the substance representing the moiety based on the ISO 11238 substance controlled vocabulary.", 0, 1, this.identifier));
        children.add(new Property("name", "string", "The name of the moiety shall be provided.", 0, 1, this.name));
        children.add(new Property("stereochemistry", "CodeableConcept", "Stereochemistry shall be captured as described in 4.7.1.", 0, 1, this.stereochemistry));
        children.add(new Property("opticalActivity", "CodeableConcept", "Optical activity shall be captured as described in 4.7.2.", 0, 1, this.opticalActivity));
        children.add(new Property("molecularFormula", "string", "Molecular formula shall be captured as described in 4.7.3.", 0, 1, this.molecularFormula));
        children.add(new Property("amount", "SubstanceAmount", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3506294: {
                return new Property("role", "CodeableConcept", "The role of the moiety should be specified if there is a specific role the moiety is playing.", 0, 1, this.role);
            }
            case -1618432855: {
                return new Property("identifier", "Identifier", "The unique identifier assigned to the substance representing the moiety based on the ISO 11238 substance controlled vocabulary.", 0, 1, this.identifier);
            }
            case 3373707: {
                return new Property("name", "string", "The name of the moiety shall be provided.", 0, 1, this.name);
            }
            case 263475116: {
                return new Property("stereochemistry", "CodeableConcept", "Stereochemistry shall be captured as described in 4.7.1.", 0, 1, this.stereochemistry);
            }
            case 1420900135: {
                return new Property("opticalActivity", "CodeableConcept", "Optical activity shall be captured as described in 4.7.2.", 0, 1, this.opticalActivity);
            }
            case 616660246: {
                return new Property("molecularFormula", "string", "Molecular formula shall be captured as described in 4.7.3.", 0, 1, this.molecularFormula);
            }
            case -1413853096: {
                return new Property("amount", "SubstanceAmount", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3506294: {
                Base[] baseArray;
                if (this.role == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.role;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 263475116: {
                Base[] baseArray;
                if (this.stereochemistry == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.stereochemistry;
                }
                return baseArray;
            }
            case 1420900135: {
                Base[] baseArray;
                if (this.opticalActivity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.opticalActivity;
                }
                return baseArray;
            }
            case 616660246: {
                Base[] baseArray;
                if (this.molecularFormula == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.molecularFormula;
                }
                return baseArray;
            }
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.amount;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3506294: {
                this.role = this.castToCodeableConcept(value);
                return value;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 263475116: {
                this.stereochemistry = this.castToCodeableConcept(value);
                return value;
            }
            case 1420900135: {
                this.opticalActivity = this.castToCodeableConcept(value);
                return value;
            }
            case 616660246: {
                this.molecularFormula = this.castToString(value);
                return value;
            }
            case -1413853096: {
                this.amount = this.castToSubstanceAmount(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("role")) {
            this.role = this.castToCodeableConcept(value);
        } else if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals("stereochemistry")) {
            this.stereochemistry = this.castToCodeableConcept(value);
        } else if (name.equals("opticalActivity")) {
            this.opticalActivity = this.castToCodeableConcept(value);
        } else if (name.equals("molecularFormula")) {
            this.molecularFormula = this.castToString(value);
        } else if (name.equals("amount")) {
            this.amount = this.castToSubstanceAmount(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3506294: {
                return this.getRole();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 263475116: {
                return this.getStereochemistry();
            }
            case 1420900135: {
                return this.getOpticalActivity();
            }
            case 616660246: {
                return this.getMolecularFormulaElement();
            }
            case -1413853096: {
                return this.getAmount();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3506294: {
                return new String[]{"CodeableConcept"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 263475116: {
                return new String[]{"CodeableConcept"};
            }
            case 1420900135: {
                return new String[]{"CodeableConcept"};
            }
            case 616660246: {
                return new String[]{"string"};
            }
            case -1413853096: {
                return new String[]{"SubstanceAmount"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("role")) {
            this.role = new CodeableConcept();
            return this.role;
        }
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceMoiety.name");
        }
        if (name.equals("stereochemistry")) {
            this.stereochemistry = new CodeableConcept();
            return this.stereochemistry;
        }
        if (name.equals("opticalActivity")) {
            this.opticalActivity = new CodeableConcept();
            return this.opticalActivity;
        }
        if (name.equals("molecularFormula")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceMoiety.molecularFormula");
        }
        if (name.equals("amount")) {
            this.amount = new SubstanceAmount();
            return this.amount;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceMoiety";
    }

    @Override
    public SubstanceMoiety copy() {
        SubstanceMoiety dst = new SubstanceMoiety();
        this.copyValues(dst);
        dst.role = this.role == null ? null : this.role.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.stereochemistry = this.stereochemistry == null ? null : this.stereochemistry.copy();
        dst.opticalActivity = this.opticalActivity == null ? null : this.opticalActivity.copy();
        dst.molecularFormula = this.molecularFormula == null ? null : this.molecularFormula.copy();
        dst.amount = this.amount == null ? null : this.amount.copy();
        return dst;
    }

    @Override
    protected SubstanceMoiety typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceMoiety)) {
            return false;
        }
        SubstanceMoiety o = (SubstanceMoiety)other_;
        return SubstanceMoiety.compareDeep(this.role, o.role, true) && SubstanceMoiety.compareDeep(this.identifier, o.identifier, true) && SubstanceMoiety.compareDeep(this.name, o.name, true) && SubstanceMoiety.compareDeep(this.stereochemistry, o.stereochemistry, true) && SubstanceMoiety.compareDeep(this.opticalActivity, o.opticalActivity, true) && SubstanceMoiety.compareDeep(this.molecularFormula, o.molecularFormula, true) && SubstanceMoiety.compareDeep(this.amount, o.amount, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceMoiety)) {
            return false;
        }
        SubstanceMoiety o = (SubstanceMoiety)other_;
        return SubstanceMoiety.compareValues(this.name, o.name, true) && SubstanceMoiety.compareValues(this.molecularFormula, o.molecularFormula, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.identifier, this.name, this.stereochemistry, this.opticalActivity, this.molecularFormula, this.amount});
    }
}

