/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

@ResourceDef(name="UserSession", profile="http://hl7.org/fhir/StructureDefinition/UserSession")
public class UserSession
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Allows a service to provide a unique, business identifier for the session.")
    protected Identifier identifier;
    @Child(name="user", type={Device.class, Practitioner.class, Patient.class, RelatedPerson.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="User engaged in the session", formalDefinition="A practitioner, patient, device, or related person engaged in the session.")
    protected Reference user;
    protected Resource userTarget;
    @Child(name="status", type={}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Status of the session", formalDefinition="Status of the session.")
    protected UserSessionStatusComponent status;
    @Child(name="workstation", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where is the session", formalDefinition="Location that identifies the physical place at which the user's session is occurring. For the purposes of context synchronization, this is intended to represent the user's workstation.")
    protected Identifier workstation;
    @Child(name="focus", type={Reference.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What is the user's current focus", formalDefinition="The current focus of the user's session. Common values are a reference to a Patient, Encounter, ImagingStudy, etc.")
    protected List<Reference> focus;
    protected List<Resource> focusTarget;
    @Child(name="created", type={InstantType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When was the session created", formalDefinition="Indicates the timestamp when the user session was first created.")
    protected InstantType created;
    @Child(name="expires", type={InstantType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When does the session expire", formalDefinition="Indicates the timestamp when the user session will expire (i.e. no longer be valid).")
    protected InstantType expires;
    @Child(name="context", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about the session", formalDefinition="Provides additional information associated with the context.")
    protected List<UserSessionContextComponent> context;
    private static final long serialVersionUID = -1422979558L;
    @SearchParamDefinition(name="identifier", path="UserSession.identifier", description="External identifiers for the user session", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="UserSession.focus.where(resolve() is Patient)", description="The identity of a patient to search for user sessions", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("UserSession:patient").toLocked();
    @SearchParamDefinition(name="focus", path="UserSession.focus", description="The focus of the user session", type="reference", providesMembershipIn={@Compartment(name="Encounter"), @Compartment(name="Patient"), @Compartment(name="Practitioner")})
    public static final String SP_FOCUS = "focus";
    public static final ReferenceClientParam FOCUS = new ReferenceClientParam("focus");
    public static final Include INCLUDE_FOCUS = new Include("UserSession:focus").toLocked();
    @SearchParamDefinition(name="workstation", path="UserSession.workstation", description="The workstation of the session", type="token")
    public static final String SP_WORKSTATION = "workstation";
    public static final TokenClientParam WORKSTATION = new TokenClientParam("workstation");
    @SearchParamDefinition(name="user", path="UserSession.user", description="The user of the session", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_USER = "user";
    public static final ReferenceClientParam USER = new ReferenceClientParam("user");
    public static final Include INCLUDE_USER = new Include("UserSession:user").toLocked();
    @SearchParamDefinition(name="status", path="UserSession.status.code", description="The status of the user session", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public UserSession() {
    }

    public UserSession(Reference user) {
        this.user = user;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create UserSession.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public UserSession setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Reference getUser() {
        if (this.user == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create UserSession.user");
            }
            if (Configuration.doAutoCreate()) {
                this.user = new Reference();
            }
        }
        return this.user;
    }

    public boolean hasUser() {
        return this.user != null && !this.user.isEmpty();
    }

    public UserSession setUser(Reference value) {
        this.user = value;
        return this;
    }

    public Resource getUserTarget() {
        return this.userTarget;
    }

    public UserSession setUserTarget(Resource value) {
        this.userTarget = value;
        return this;
    }

    public UserSessionStatusComponent getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create UserSession.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new UserSessionStatusComponent();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public UserSession setStatus(UserSessionStatusComponent value) {
        this.status = value;
        return this;
    }

    public Identifier getWorkstation() {
        if (this.workstation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create UserSession.workstation");
            }
            if (Configuration.doAutoCreate()) {
                this.workstation = new Identifier();
            }
        }
        return this.workstation;
    }

    public boolean hasWorkstation() {
        return this.workstation != null && !this.workstation.isEmpty();
    }

    public UserSession setWorkstation(Identifier value) {
        this.workstation = value;
        return this;
    }

    public List<Reference> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        return this.focus;
    }

    public UserSession setFocus(List<Reference> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (Reference item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addFocus() {
        Reference t = new Reference();
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return t;
    }

    public UserSession addFocus(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return this;
    }

    public Reference getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    @Deprecated
    public List<Resource> getFocusTarget() {
        if (this.focusTarget == null) {
            this.focusTarget = new ArrayList<Resource>();
        }
        return this.focusTarget;
    }

    public InstantType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create UserSession.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new InstantType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public UserSession setCreatedElement(InstantType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public UserSession setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new InstantType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public InstantType getExpiresElement() {
        if (this.expires == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create UserSession.expires");
            }
            if (Configuration.doAutoCreate()) {
                this.expires = new InstantType();
            }
        }
        return this.expires;
    }

    public boolean hasExpiresElement() {
        return this.expires != null && !this.expires.isEmpty();
    }

    public boolean hasExpires() {
        return this.expires != null && !this.expires.isEmpty();
    }

    public UserSession setExpiresElement(InstantType value) {
        this.expires = value;
        return this;
    }

    public Date getExpires() {
        return this.expires == null ? null : (Date)this.expires.getValue();
    }

    public UserSession setExpires(Date value) {
        if (value == null) {
            this.expires = null;
        } else {
            if (this.expires == null) {
                this.expires = new InstantType();
            }
            this.expires.setValue(value);
        }
        return this;
    }

    public List<UserSessionContextComponent> getContext() {
        if (this.context == null) {
            this.context = new ArrayList<UserSessionContextComponent>();
        }
        return this.context;
    }

    public UserSession setContext(List<UserSessionContextComponent> theContext) {
        this.context = theContext;
        return this;
    }

    public boolean hasContext() {
        if (this.context == null) {
            return false;
        }
        for (UserSessionContextComponent item : this.context) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UserSessionContextComponent addContext() {
        UserSessionContextComponent t = new UserSessionContextComponent();
        if (this.context == null) {
            this.context = new ArrayList<UserSessionContextComponent>();
        }
        this.context.add(t);
        return t;
    }

    public UserSession addContext(UserSessionContextComponent t) {
        if (t == null) {
            return this;
        }
        if (this.context == null) {
            this.context = new ArrayList<UserSessionContextComponent>();
        }
        this.context.add(t);
        return this;
    }

    public UserSessionContextComponent getContextFirstRep() {
        if (this.getContext().isEmpty()) {
            this.addContext();
        }
        return this.getContext().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide a unique, business identifier for the session.", 0, 1, this.identifier));
        children.add(new Property(SP_USER, "Reference(Device|Practitioner|Patient|RelatedPerson)", "A practitioner, patient, device, or related person engaged in the session.", 0, 1, this.user));
        children.add(new Property(SP_STATUS, "", "Status of the session.", 0, 1, this.status));
        children.add(new Property(SP_WORKSTATION, "Identifier", "Location that identifies the physical place at which the user's session is occurring. For the purposes of context synchronization, this is intended to represent the user's workstation.", 0, 1, this.workstation));
        children.add(new Property(SP_FOCUS, "Reference(Any)", "The current focus of the user's session. Common values are a reference to a Patient, Encounter, ImagingStudy, etc.", 0, Integer.MAX_VALUE, this.focus));
        children.add(new Property("created", "instant", "Indicates the timestamp when the user session was first created.", 0, 1, this.created));
        children.add(new Property("expires", "instant", "Indicates the timestamp when the user session will expire (i.e. no longer be valid).", 0, 1, this.expires));
        children.add(new Property("context", "", "Provides additional information associated with the context.", 0, Integer.MAX_VALUE, this.context));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide a unique, business identifier for the session.", 0, 1, this.identifier);
            }
            case 3599307: {
                return new Property(SP_USER, "Reference(Device|Practitioner|Patient|RelatedPerson)", "A practitioner, patient, device, or related person engaged in the session.", 0, 1, this.user);
            }
            case -892481550: {
                return new Property(SP_STATUS, "", "Status of the session.", 0, 1, this.status);
            }
            case 581588227: {
                return new Property(SP_WORKSTATION, "Identifier", "Location that identifies the physical place at which the user's session is occurring. For the purposes of context synchronization, this is intended to represent the user's workstation.", 0, 1, this.workstation);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "Reference(Any)", "The current focus of the user's session. Common values are a reference to a Patient, Encounter, ImagingStudy, etc.", 0, Integer.MAX_VALUE, this.focus);
            }
            case 1028554472: {
                return new Property("created", "instant", "Indicates the timestamp when the user session was first created.", 0, 1, this.created);
            }
            case -1309235404: {
                return new Property("expires", "instant", "Indicates the timestamp when the user session will expire (i.e. no longer be valid).", 0, 1, this.expires);
            }
            case 951530927: {
                return new Property("context", "", "Provides additional information associated with the context.", 0, Integer.MAX_VALUE, this.context);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3599307: {
                Base[] baseArray;
                if (this.user == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.user;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 581588227: {
                Base[] baseArray;
                if (this.workstation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.workstation;
                }
                return baseArray;
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.created;
                }
                return baseArray;
            }
            case -1309235404: {
                Base[] baseArray;
                if (this.expires == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.expires;
                }
                return baseArray;
            }
            case 951530927: {
                return this.context == null ? new Base[]{} : this.context.toArray(new Base[this.context.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3599307: {
                this.user = this.castToReference(value);
                return value;
            }
            case -892481550: {
                this.status = (UserSessionStatusComponent)value;
                return value;
            }
            case 581588227: {
                this.workstation = this.castToIdentifier(value);
                return value;
            }
            case 97604824: {
                this.getFocus().add(this.castToReference(value));
                return value;
            }
            case 1028554472: {
                this.created = this.castToInstant(value);
                return value;
            }
            case -1309235404: {
                this.expires = this.castToInstant(value);
                return value;
            }
            case 951530927: {
                this.getContext().add((UserSessionContextComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_USER)) {
            this.user = this.castToReference(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = (UserSessionStatusComponent)value;
        } else if (name.equals(SP_WORKSTATION)) {
            this.workstation = this.castToIdentifier(value);
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().add(this.castToReference(value));
        } else if (name.equals("created")) {
            this.created = this.castToInstant(value);
        } else if (name.equals("expires")) {
            this.expires = this.castToInstant(value);
        } else if (name.equals("context")) {
            this.getContext().add((UserSessionContextComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3599307: {
                return this.getUser();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 581588227: {
                return this.getWorkstation();
            }
            case 97604824: {
                return this.addFocus();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -1309235404: {
                return this.getExpiresElement();
            }
            case 951530927: {
                return this.addContext();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3599307: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[0];
            }
            case 581588227: {
                return new String[]{"Identifier"};
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"instant"};
            }
            case -1309235404: {
                return new String[]{"instant"};
            }
            case 951530927: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_USER)) {
            this.user = new Reference();
            return this.user;
        }
        if (name.equals(SP_STATUS)) {
            this.status = new UserSessionStatusComponent();
            return this.status;
        }
        if (name.equals(SP_WORKSTATION)) {
            this.workstation = new Identifier();
            return this.workstation;
        }
        if (name.equals(SP_FOCUS)) {
            return this.addFocus();
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type UserSession.created");
        }
        if (name.equals("expires")) {
            throw new FHIRException("Cannot call addChild on a primitive type UserSession.expires");
        }
        if (name.equals("context")) {
            return this.addContext();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "UserSession";
    }

    @Override
    public UserSession copy() {
        UserSession dst = new UserSession();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.user = this.user == null ? null : this.user.copy();
        dst.status = this.status == null ? null : this.status.copy();
        Identifier identifier = dst.workstation = this.workstation == null ? null : this.workstation.copy();
        if (this.focus != null) {
            dst.focus = new ArrayList<Reference>();
            for (Reference reference : this.focus) {
                dst.focus.add(reference.copy());
            }
        }
        dst.created = this.created == null ? null : this.created.copy();
        InstantType instantType = dst.expires = this.expires == null ? null : this.expires.copy();
        if (this.context != null) {
            dst.context = new ArrayList<UserSessionContextComponent>();
            for (UserSessionContextComponent userSessionContextComponent : this.context) {
                dst.context.add(userSessionContextComponent.copy());
            }
        }
        return dst;
    }

    protected UserSession typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof UserSession)) {
            return false;
        }
        UserSession o = (UserSession)other_;
        return UserSession.compareDeep(this.identifier, o.identifier, true) && UserSession.compareDeep(this.user, o.user, true) && UserSession.compareDeep(this.status, o.status, true) && UserSession.compareDeep(this.workstation, o.workstation, true) && UserSession.compareDeep(this.focus, o.focus, true) && UserSession.compareDeep(this.created, o.created, true) && UserSession.compareDeep(this.expires, o.expires, true) && UserSession.compareDeep(this.context, o.context, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof UserSession)) {
            return false;
        }
        UserSession o = (UserSession)other_;
        return UserSession.compareValues(this.created, o.created, true) && UserSession.compareValues(this.expires, o.expires, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.user, this.status, this.workstation, this.focus, this.created, this.expires, this.context});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.UserSession;
    }

    @Block
    public static class UserSessionContextComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What type of context value", formalDefinition="Indicates which type of context is being provided.")
        protected StringType type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the context", formalDefinition="Provides the context value.")
        protected Type value;
        private static final long serialVersionUID = -1035059584L;

        public UserSessionContextComponent() {
        }

        public UserSessionContextComponent(StringType type) {
            this.type = type;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create UserSessionContextComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public UserSessionContextComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public UserSessionContextComponent setType(String value) {
            if (this.type == null) {
                this.type = new StringType();
            }
            this.type.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public UserSessionContextComponent setValue(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for UserSession.context.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "string", "Indicates which type of context is being provided.", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity", "Provides the context value.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "string", "Indicates which type of context is being provided.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "Provides the context value.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "Provides the context value.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "Provides the context value.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "Provides the context value.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type UserSession.type");
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public UserSessionContextComponent copy() {
            UserSessionContextComponent dst = new UserSessionContextComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof UserSessionContextComponent)) {
                return false;
            }
            UserSessionContextComponent o = (UserSessionContextComponent)other_;
            return UserSessionContextComponent.compareDeep(this.type, o.type, true) && UserSessionContextComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof UserSessionContextComponent)) {
                return false;
            }
            UserSessionContextComponent o = (UserSessionContextComponent)other_;
            return UserSessionContextComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "UserSession.context";
        }
    }

    @Block
    public static class UserSessionStatusComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="activating | active | suspended | closing | closed", formalDefinition="The current status of the user session.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/usersession-status")
        protected Enumeration<UserSessionStatus> code;
        @Child(name="source", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="user | system", formalDefinition="The source of the status code.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/usersession-status-source")
        protected Enumeration<UserSessionStatusSource> source;
        private static final long serialVersionUID = 2003820253L;

        public UserSessionStatusComponent() {
        }

        public UserSessionStatusComponent(Enumeration<UserSessionStatus> code, Enumeration<UserSessionStatusSource> source) {
            this.code = code;
            this.source = source;
        }

        public Enumeration<UserSessionStatus> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create UserSessionStatusComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<UserSessionStatus>(new UserSessionStatusEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public UserSessionStatusComponent setCodeElement(Enumeration<UserSessionStatus> value) {
            this.code = value;
            return this;
        }

        public UserSessionStatus getCode() {
            return this.code == null ? null : (UserSessionStatus)((Object)this.code.getValue());
        }

        public UserSessionStatusComponent setCode(UserSessionStatus value) {
            if (this.code == null) {
                this.code = new Enumeration<UserSessionStatus>(new UserSessionStatusEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public Enumeration<UserSessionStatusSource> getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create UserSessionStatusComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new Enumeration<UserSessionStatusSource>(new UserSessionStatusSourceEnumFactory());
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public UserSessionStatusComponent setSourceElement(Enumeration<UserSessionStatusSource> value) {
            this.source = value;
            return this;
        }

        public UserSessionStatusSource getSource() {
            return this.source == null ? null : (UserSessionStatusSource)((Object)this.source.getValue());
        }

        public UserSessionStatusComponent setSource(UserSessionStatusSource value) {
            if (this.source == null) {
                this.source = new Enumeration<UserSessionStatusSource>(new UserSessionStatusSourceEnumFactory());
            }
            this.source.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "The current status of the user session.", 0, 1, this.code));
            children.add(new Property("source", "code", "The source of the status code.", 0, 1, this.source));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "The current status of the user session.", 0, 1, this.code);
                }
                case -896505829: {
                    return new Property("source", "code", "The source of the status code.", 0, 1, this.source);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new UserSessionStatusEnumFactory().fromType(this.castToCode(value));
                    this.code = value;
                    return value;
                }
                case -896505829: {
                    value = new UserSessionStatusSourceEnumFactory().fromType(this.castToCode(value));
                    this.source = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new UserSessionStatusEnumFactory().fromType(this.castToCode(value));
                this.code = value;
            } else if (name.equals("source")) {
                value = new UserSessionStatusSourceEnumFactory().fromType(this.castToCode(value));
                this.source = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -896505829: {
                    return this.getSourceElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case -896505829: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type UserSession.code");
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type UserSession.source");
            }
            return super.addChild(name);
        }

        @Override
        public UserSessionStatusComponent copy() {
            UserSessionStatusComponent dst = new UserSessionStatusComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.source = this.source == null ? null : this.source.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof UserSessionStatusComponent)) {
                return false;
            }
            UserSessionStatusComponent o = (UserSessionStatusComponent)other_;
            return UserSessionStatusComponent.compareDeep(this.code, o.code, true) && UserSessionStatusComponent.compareDeep(this.source, o.source, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof UserSessionStatusComponent)) {
                return false;
            }
            UserSessionStatusComponent o = (UserSessionStatusComponent)other_;
            return UserSessionStatusComponent.compareValues(this.code, o.code, true) && UserSessionStatusComponent.compareValues(this.source, o.source, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.source});
        }

        @Override
        public String fhirType() {
            return "UserSession.status";
        }
    }

    public static class UserSessionStatusSourceEnumFactory
    implements EnumFactory<UserSessionStatusSource> {
        @Override
        public UserSessionStatusSource fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if (UserSession.SP_USER.equals(codeString)) {
                return UserSessionStatusSource.USER;
            }
            if ("system".equals(codeString)) {
                return UserSessionStatusSource.SYSTEM;
            }
            throw new IllegalArgumentException("Unknown UserSessionStatusSource code '" + codeString + "'");
        }

        public Enumeration<UserSessionStatusSource> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<UserSessionStatusSource>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (UserSession.SP_USER.equals(codeString)) {
                return new Enumeration<UserSessionStatusSource>(this, UserSessionStatusSource.USER);
            }
            if ("system".equals(codeString)) {
                return new Enumeration<UserSessionStatusSource>(this, UserSessionStatusSource.SYSTEM);
            }
            throw new FHIRException("Unknown UserSessionStatusSource code '" + codeString + "'");
        }

        @Override
        public String toCode(UserSessionStatusSource code) {
            if (code == UserSessionStatusSource.USER) {
                return UserSession.SP_USER;
            }
            if (code == UserSessionStatusSource.SYSTEM) {
                return "system";
            }
            return "?";
        }

        @Override
        public String toSystem(UserSessionStatusSource code) {
            return code.getSystem();
        }
    }

    public static enum UserSessionStatusSource {
        USER,
        SYSTEM,
        NULL;


        public static UserSessionStatusSource fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (UserSession.SP_USER.equals(codeString)) {
                return USER;
            }
            if ("system".equals(codeString)) {
                return SYSTEM;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown UserSessionStatusSource code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case USER: {
                    return UserSession.SP_USER;
                }
                case SYSTEM: {
                    return "system";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case USER: {
                    return "http://hl7.org/fhir/usersession-status-source";
                }
                case SYSTEM: {
                    return "http://hl7.org/fhir/usersession-status-source";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case USER: {
                    return "The status was reported by the user.";
                }
                case SYSTEM: {
                    return "The status was reported by the system.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case USER: {
                    return "User";
                }
                case SYSTEM: {
                    return "System";
                }
            }
            return "?";
        }
    }

    public static class UserSessionStatusEnumFactory
    implements EnumFactory<UserSessionStatus> {
        @Override
        public UserSessionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("activating".equals(codeString)) {
                return UserSessionStatus.ACTIVATING;
            }
            if ("active".equals(codeString)) {
                return UserSessionStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return UserSessionStatus.SUSPENDED;
            }
            if ("closing".equals(codeString)) {
                return UserSessionStatus.CLOSING;
            }
            if ("closed".equals(codeString)) {
                return UserSessionStatus.CLOSED;
            }
            throw new IllegalArgumentException("Unknown UserSessionStatus code '" + codeString + "'");
        }

        public Enumeration<UserSessionStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<UserSessionStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("activating".equals(codeString)) {
                return new Enumeration<UserSessionStatus>(this, UserSessionStatus.ACTIVATING);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<UserSessionStatus>(this, UserSessionStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<UserSessionStatus>(this, UserSessionStatus.SUSPENDED);
            }
            if ("closing".equals(codeString)) {
                return new Enumeration<UserSessionStatus>(this, UserSessionStatus.CLOSING);
            }
            if ("closed".equals(codeString)) {
                return new Enumeration<UserSessionStatus>(this, UserSessionStatus.CLOSED);
            }
            throw new FHIRException("Unknown UserSessionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(UserSessionStatus code) {
            if (code == UserSessionStatus.ACTIVATING) {
                return "activating";
            }
            if (code == UserSessionStatus.ACTIVE) {
                return "active";
            }
            if (code == UserSessionStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == UserSessionStatus.CLOSING) {
                return "closing";
            }
            if (code == UserSessionStatus.CLOSED) {
                return "closed";
            }
            return "?";
        }

        @Override
        public String toSystem(UserSessionStatus code) {
            return code.getSystem();
        }
    }

    public static enum UserSessionStatus {
        ACTIVATING,
        ACTIVE,
        SUSPENDED,
        CLOSING,
        CLOSED,
        NULL;


        public static UserSessionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("activating".equals(codeString)) {
                return ACTIVATING;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("closing".equals(codeString)) {
                return CLOSING;
            }
            if ("closed".equals(codeString)) {
                return CLOSED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown UserSessionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVATING: {
                    return "activating";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case CLOSING: {
                    return "closing";
                }
                case CLOSED: {
                    return "closed";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVATING: {
                    return "http://hl7.org/fhir/usersession-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/usersession-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/usersession-status";
                }
                case CLOSING: {
                    return "http://hl7.org/fhir/usersession-status";
                }
                case CLOSED: {
                    return "http://hl7.org/fhir/usersession-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVATING: {
                    return "The user session is activating.";
                }
                case ACTIVE: {
                    return "The user session is active.";
                }
                case SUSPENDED: {
                    return "The user session is suspended.";
                }
                case CLOSING: {
                    return "The user session is closing.";
                }
                case CLOSED: {
                    return "The user session is closed.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVATING: {
                    return "Activating";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspending";
                }
                case CLOSING: {
                    return "Closing";
                }
                case CLOSED: {
                    return "Closed";
                }
            }
            return "?";
        }
    }
}

