/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventCategory {
    PRODUCTPROBLEM,
    PRODUCTQUALITY,
    PRODUCTUSEERROR,
    WRONGDOSE,
    INCORRECTPRESCRIBINGINFORMATION,
    WRONGTECHNIQUE,
    WRONGROUTEOFADMINISTRATION,
    WRONGRATE,
    WRONGDURATION,
    WRONGTIME,
    EXPIREDDRUG,
    MEDICALDEVICEUSEERROR,
    PROBLEMDIFFERENTMANUFACTURER,
    UNSAFEPHYSICALENVIRONMENT,
    NULL;


    public static AdverseEventCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("product-problem".equals(codeString)) {
            return PRODUCTPROBLEM;
        }
        if ("product-quality".equals(codeString)) {
            return PRODUCTQUALITY;
        }
        if ("product-use-error".equals(codeString)) {
            return PRODUCTUSEERROR;
        }
        if ("wrong-dose".equals(codeString)) {
            return WRONGDOSE;
        }
        if ("incorrect-prescribing-information".equals(codeString)) {
            return INCORRECTPRESCRIBINGINFORMATION;
        }
        if ("wrong-technique".equals(codeString)) {
            return WRONGTECHNIQUE;
        }
        if ("wrong-route-of-administration".equals(codeString)) {
            return WRONGROUTEOFADMINISTRATION;
        }
        if ("wrong-rate".equals(codeString)) {
            return WRONGRATE;
        }
        if ("wrong-duration".equals(codeString)) {
            return WRONGDURATION;
        }
        if ("wrong-time".equals(codeString)) {
            return WRONGTIME;
        }
        if ("expired-drug".equals(codeString)) {
            return EXPIREDDRUG;
        }
        if ("medical-device-use-error".equals(codeString)) {
            return MEDICALDEVICEUSEERROR;
        }
        if ("problem-different-manufacturer".equals(codeString)) {
            return PROBLEMDIFFERENTMANUFACTURER;
        }
        if ("unsafe-physical-environment".equals(codeString)) {
            return UNSAFEPHYSICALENVIRONMENT;
        }
        throw new FHIRException("Unknown AdverseEventCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRODUCTPROBLEM: {
                return "product-problem";
            }
            case PRODUCTQUALITY: {
                return "product-quality";
            }
            case PRODUCTUSEERROR: {
                return "product-use-error";
            }
            case WRONGDOSE: {
                return "wrong-dose";
            }
            case INCORRECTPRESCRIBINGINFORMATION: {
                return "incorrect-prescribing-information";
            }
            case WRONGTECHNIQUE: {
                return "wrong-technique";
            }
            case WRONGROUTEOFADMINISTRATION: {
                return "wrong-route-of-administration";
            }
            case WRONGRATE: {
                return "wrong-rate";
            }
            case WRONGDURATION: {
                return "wrong-duration";
            }
            case WRONGTIME: {
                return "wrong-time";
            }
            case EXPIREDDRUG: {
                return "expired-drug";
            }
            case MEDICALDEVICEUSEERROR: {
                return "medical-device-use-error";
            }
            case PROBLEMDIFFERENTMANUFACTURER: {
                return "problem-different-manufacturer";
            }
            case UNSAFEPHYSICALENVIRONMENT: {
                return "unsafe-physical-environment";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/adverse-event-category";
    }

    public String getDefinition() {
        switch (this) {
            case PRODUCTPROBLEM: {
                return "";
            }
            case PRODUCTQUALITY: {
                return "";
            }
            case PRODUCTUSEERROR: {
                return "";
            }
            case WRONGDOSE: {
                return "";
            }
            case INCORRECTPRESCRIBINGINFORMATION: {
                return "";
            }
            case WRONGTECHNIQUE: {
                return "";
            }
            case WRONGROUTEOFADMINISTRATION: {
                return "";
            }
            case WRONGRATE: {
                return "";
            }
            case WRONGDURATION: {
                return "";
            }
            case WRONGTIME: {
                return "";
            }
            case EXPIREDDRUG: {
                return "";
            }
            case MEDICALDEVICEUSEERROR: {
                return "";
            }
            case PROBLEMDIFFERENTMANUFACTURER: {
                return "";
            }
            case UNSAFEPHYSICALENVIRONMENT: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRODUCTPROBLEM: {
                return "Product Problem";
            }
            case PRODUCTQUALITY: {
                return "Product Quality";
            }
            case PRODUCTUSEERROR: {
                return "Product Use Error";
            }
            case WRONGDOSE: {
                return "Wrong Dose";
            }
            case INCORRECTPRESCRIBINGINFORMATION: {
                return "Incorrect Prescribing Information";
            }
            case WRONGTECHNIQUE: {
                return "Wrong Technique";
            }
            case WRONGROUTEOFADMINISTRATION: {
                return "Wrong Route of Administration";
            }
            case WRONGRATE: {
                return "Wrong Rate";
            }
            case WRONGDURATION: {
                return "Wrong Duration";
            }
            case WRONGTIME: {
                return "Wrong Time";
            }
            case EXPIREDDRUG: {
                return "Expired Drug";
            }
            case MEDICALDEVICEUSEERROR: {
                return "Medical Device Use Error";
            }
            case PROBLEMDIFFERENTMANUFACTURER: {
                return "Problem with Different Manufacturer of Same Medicine";
            }
            case UNSAFEPHYSICALENVIRONMENT: {
                return "Unsafe Physical Environment";
            }
        }
        return "?";
    }
}

