/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CarePlanIntent {
    PROPOSAL,
    PLAN,
    ORDER,
    OPTION,
    NULL;


    public static CarePlanIntent fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return PLAN;
        }
        if ("order".equals(codeString)) {
            return ORDER;
        }
        if ("option".equals(codeString)) {
            return OPTION;
        }
        throw new FHIRException("Unknown CarePlanIntent code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSAL: {
                return "proposal";
            }
            case PLAN: {
                return "plan";
            }
            case ORDER: {
                return "order";
            }
            case OPTION: {
                return "option";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/care-plan-intent";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSAL: {
                return "The care plan is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
            }
            case PLAN: {
                return "The care plan represents an intention to ensure something occurs without providing an authorization for others to act";
            }
            case ORDER: {
                return "The care plan represents a request/demand and authorization for action";
            }
            case OPTION: {
                return "The care plan represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.\n\nRefer to [[[RequestGroup]]] for additional information on how this status is used";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSAL: {
                return "Proposal";
            }
            case PLAN: {
                return "Plan";
            }
            case ORDER: {
                return "Order";
            }
            case OPTION: {
                return "Option";
            }
        }
        return "?";
    }
}

