/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.CarePlanIntent;

public class CarePlanIntentEnumFactory
implements EnumFactory<CarePlanIntent> {
    @Override
    public CarePlanIntent fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return CarePlanIntent.PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return CarePlanIntent.PLAN;
        }
        if ("order".equals(codeString)) {
            return CarePlanIntent.ORDER;
        }
        if ("option".equals(codeString)) {
            return CarePlanIntent.OPTION;
        }
        throw new IllegalArgumentException("Unknown CarePlanIntent code '" + codeString + "'");
    }

    @Override
    public String toCode(CarePlanIntent code) {
        if (code == CarePlanIntent.PROPOSAL) {
            return "proposal";
        }
        if (code == CarePlanIntent.PLAN) {
            return "plan";
        }
        if (code == CarePlanIntent.ORDER) {
            return "order";
        }
        if (code == CarePlanIntent.OPTION) {
            return "option";
        }
        return "?";
    }

    @Override
    public String toSystem(CarePlanIntent code) {
        return code.getSystem();
    }
}

